/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip.clientauthutils;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.address.Hop;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.AuthorizationHeader;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.HeaderFactory;
import com.coraltele.interfaces.sip.header.ProxyAuthenticateHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.header.WWWAuthenticateHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.clientauthutils.AccountManager;
import com.coraltele.javax.sip.clientauthutils.AuthenticationHelper;
import com.coraltele.javax.sip.clientauthutils.CredentialsCache;
import com.coraltele.javax.sip.clientauthutils.MessageDigestAlgorithm;
import com.coraltele.javax.sip.clientauthutils.SecureAccountManager;
import com.coraltele.javax.sip.clientauthutils.UserCredentialHash;
import com.coraltele.javax.sip.clientauthutils.UserCredentials;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import java.text.ParseException;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Timer;

public class AuthenticationHelperImpl
implements AuthenticationHelper {
    private static StackLogger logger = CommonLogger.getLogger(AuthenticationHelperImpl.class);
    private CredentialsCache cachedCredentials;
    private Object accountManager = null;
    private HeaderFactory headerFactory;
    private SIPTransactionStack sipStack;
    Timer timer;

    public AuthenticationHelperImpl(SIPTransactionStack sipStack, AccountManager accountManager, HeaderFactory headerFactory) {
        this.accountManager = accountManager;
        this.headerFactory = headerFactory;
        this.sipStack = sipStack;
        this.cachedCredentials = new CredentialsCache(sipStack.getTimer());
    }

    public AuthenticationHelperImpl(SIPTransactionStack sipStack, SecureAccountManager accountManager, HeaderFactory headerFactory) {
        this.accountManager = accountManager;
        this.headerFactory = headerFactory;
        this.sipStack = sipStack;
        this.cachedCredentials = new CredentialsCache(sipStack.getTimer());
    }

    public ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction, SipProvider transactionCreator, int cacheTime) throws SipException, NullPointerException {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("handleChallenge: " + challenge);
            }
            SIPRequest challengedRequest = (SIPRequest)challengedTransaction.getRequest();
            Request reoriginatedRequest = null;
            if (challengedRequest.getToTag() != null || challengedTransaction.getDialog() == null || challengedTransaction.getDialog().getState() != DialogState.CONFIRMED) {
                reoriginatedRequest = (Request)challengedRequest.clone();
            } else {
                reoriginatedRequest = challengedTransaction.getDialog().createRequest(challengedRequest.getMethod());
                ListIterator headerNames = challengedRequest.getHeaderNames();
                while (headerNames.hasNext()) {
                    String headerName = (String)headerNames.next();
                    if (reoriginatedRequest.getHeader(headerName) == null) continue;
                    ListIterator iterator = reoriginatedRequest.getHeaders(headerName);
                    while (iterator.hasNext()) {
                        reoriginatedRequest.addHeader((Header)iterator.next());
                    }
                }
            }
            this.removeBranchID(reoriginatedRequest);
            if (challenge == null || reoriginatedRequest == null) {
                throw new NullPointerException("A null argument was passed to handle challenge.");
            }
            ListIterator authHeaders = null;
            if (challenge.getStatusCode() == 401) {
                authHeaders = challenge.getHeaders("WWW-Authenticate");
            } else if (challenge.getStatusCode() == 407) {
                authHeaders = challenge.getHeaders("Proxy-Authenticate");
            } else {
                throw new IllegalArgumentException("Unexpected status code ");
            }
            if (authHeaders == null) {
                throw new IllegalArgumentException("Could not find WWWAuthenticate or ProxyAuthenticate headers");
            }
            reoriginatedRequest.removeHeader("Authorization");
            reoriginatedRequest.removeHeader("Proxy-Authorization");
            CSeqHeader cSeq = (CSeqHeader)reoriginatedRequest.getHeader("CSeq");
            try {
                cSeq.setSeqNumber(cSeq.getSeqNumber() + 1L);
            }
            catch (InvalidArgumentException ex) {
                throw new SipException("Invalid CSeq -- could not increment : " + cSeq.getSeqNumber());
            }
            if (challengedRequest.getRouteHeaders() == null) {
                Hop hop = ((SIPClientTransaction)challengedTransaction).getNextHop();
                SipURI sipUri = (SipURI)reoriginatedRequest.getRequestURI();
                sipUri.setMAddrParam(hop.getHost());
                if (hop.getPort() != -1) {
                    sipUri.setPort(hop.getPort());
                }
            }
            ClientTransaction retryTran = transactionCreator.getNewClientTransaction(reoriginatedRequest);
            WWWAuthenticateHeader authHeader = null;
            SipURI requestUri = (SipURI)challengedTransaction.getRequest().getRequestURI();
            while (authHeaders.hasNext()) {
                String sipDomain;
                authHeader = (WWWAuthenticateHeader)authHeaders.next();
                String realm = authHeader.getRealm();
                AuthorizationHeader authorization = null;
                if (this.accountManager instanceof SecureAccountManager) {
                    UserCredentialHash credHash = ((SecureAccountManager)this.accountManager).getCredentialHash(challengedTransaction, realm);
                    if (credHash == null) {
                        logger.logDebug("Could not find creds");
                        throw new SipException("Cannot find user creds for the given user name and realm");
                    }
                    URI uri = reoriginatedRequest.getRequestURI();
                    sipDomain = credHash.getSipDomain();
                    authorization = this.getAuthorization(reoriginatedRequest.getMethod(), uri.toString(), reoriginatedRequest.getContent() == null ? "" : new String(reoriginatedRequest.getRawContent()), authHeader, credHash);
                } else {
                    UserCredentials userCreds = ((AccountManager)this.accountManager).getCredentials(challengedTransaction, realm);
                    if (userCreds == null) {
                        throw new SipException("Cannot find user creds for the given user name and realm");
                    }
                    sipDomain = userCreds.getSipDomain();
                    authorization = this.getAuthorization(reoriginatedRequest.getMethod(), reoriginatedRequest.getRequestURI().toString(), reoriginatedRequest.getContent() == null ? "" : new String(reoriginatedRequest.getRawContent()), authHeader, userCreds);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Created authorization header: " + authorization.toString());
                }
                if (cacheTime != 0) {
                    String callId = challengedRequest.getCallId().getCallId();
                    this.cachedCredentials.cacheAuthorizationHeader(callId, authorization, cacheTime);
                }
                reoriginatedRequest.addHeader((Header)authorization);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Returning authorization transaction." + retryTran);
            }
            return retryTran;
        }
        catch (SipException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.logError("Unexpected exception ", ex);
            throw new SipException("Unexpected exception ", (Throwable)ex);
        }
    }

    private AuthorizationHeader getAuthorization(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentials userCredentials) {
        String response = null;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        response = MessageDigestAlgorithm.calculateResponse((String)authHeader.getAlgorithm(), (String)userCredentials.getUserName(), (String)authHeader.getRealm(), (String)userCredentials.getPassword(), (String)authHeader.getNonce(), (String)nc_value, (String)cnonce, (String)method, (String)uri, (String)requestBody, (String)qop);
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to create an authorization header!");
        }
        return authorization;
    }

    private AuthorizationHeader getAuthorization(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentialHash userCredentials) {
        String response = null;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        response = MessageDigestAlgorithm.calculateResponse((String)authHeader.getAlgorithm(), (String)userCredentials.getHashUserDomainPassword(), (String)authHeader.getNonce(), (String)nc_value, (String)cnonce, (String)method, (String)uri, (String)requestBody, (String)qop, (StackLogger)logger);
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to create an authorization header!");
        }
        return authorization;
    }

    private void removeBranchID(Request request) {
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        viaHeader.removeParameter("branch");
    }

    public void setAuthenticationHeaders(Request request) {
        SIPRequest sipRequest = (SIPRequest)request;
        String callId = sipRequest.getCallId().getCallId();
        request.removeHeader("Authorization");
        Collection authHeaders = this.cachedCredentials.getCachedAuthorizationHeaders(callId);
        if (authHeaders == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Could not find authentication headers for " + callId);
            }
            return;
        }
        for (AuthorizationHeader authHeader : authHeaders) {
            request.addHeader((Header)authHeader);
        }
    }

    public void removeCachedAuthenticationHeaders(String callId) {
        if (callId == null) {
            throw new NullPointerException("Null callId argument ");
        }
        this.cachedCredentials.removeAuthenticationHeader(callId);
    }
}

