/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.javax.sip.DialogFilter;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.javax.sip.stack.SIPTransactionStack;
import com.coraltele.javax.sip.stack.ServerRequestInterface;
import com.coraltele.javax.sip.stack.ServerResponseInterface;
import com.coraltele.javax.sip.stack.StackMessageFactory;

class NistSipMessageFactoryImpl
implements StackMessageFactory {
    private static StackLogger logger = CommonLogger.getLogger(NistSipMessageFactoryImpl.class);
    private SIPTransactionStack sipStack;

    public ServerRequestInterface newSIPServerRequest(SIPRequest sipRequest, MessageChannel messageChannel) {
        if (messageChannel == null || sipRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        SIPTransactionStack theStack = messageChannel.getSIPStack();
        DialogFilter retval = new DialogFilter(theStack);
        if (messageChannel instanceof SIPTransaction) {
            retval.transactionChannel = (SIPTransaction)messageChannel;
        }
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        if (retval.listeningPoint == null) {
            return null;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Returning request interface for " + sipRequest.getFirstLine() + " " + retval + " messageChannel = " + messageChannel);
        }
        return retval;
    }

    public ServerResponseInterface newSIPServerResponse(SIPResponse sipResponse, MessageChannel messageChannel) {
        SIPTransactionStack theStack = messageChannel.getSIPStack();
        SIPTransaction tr = theStack.findTransaction((SIPMessage)sipResponse, false);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Found Transaction " + tr + " for " + sipResponse);
        }
        if (tr != null) {
            if (tr.getInternalState() < 0) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping response - null transaction state");
                }
                return null;
            }
            if (3 == tr.getInternalState() && sipResponse.getStatusCode() / 100 == 1) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping response - late arriving " + sipResponse.getStatusCode());
                }
                return null;
            }
        }
        DialogFilter retval = new DialogFilter(this.sipStack);
        retval.transactionChannel = tr;
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        return retval;
    }

    public NistSipMessageFactoryImpl(SIPTransactionStack sipStackImpl) {
        this.sipStack = sipStackImpl;
    }
}

