/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.Host;
import com.coraltele.core.HostPort;
import com.coraltele.core.InternalErrorHandler;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.ListeningPoint;
import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.javax.sip.ListeningPointExt;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.address.AddressImpl;
import com.coraltele.javax.sip.address.SipUri;
import com.coraltele.javax.sip.header.Contact;
import com.coraltele.javax.sip.header.Via;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.stack.MessageChannel;
import com.coraltele.javax.sip.stack.MessageProcessor;
import java.io.IOException;
import java.text.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ListeningPointImpl
implements ListeningPoint,
ListeningPointExt {
    private static StackLogger logger = CommonLogger.getLogger(ListeningPointImpl.class);
    protected String transport;
    int port;
    protected MessageProcessor messageProcessor;
    protected SipProviderImpl sipProvider;
    protected SipStackImpl sipStack;

    public static String makeKey(String host, int port, String transport) {
        return (host + ":" + port + "/" + transport).toLowerCase();
    }

    protected String getKey() {
        return ListeningPointImpl.makeKey((String)this.getIPAddress(), (int)this.port, (String)this.transport);
    }

    public void setSipProvider(SipProviderImpl sipProviderImpl) {
        this.sipProvider = sipProviderImpl;
    }

    public void removeSipProvider() {
        this.sipProvider = null;
    }

    protected ListeningPointImpl(SipStack sipStack, int port, String transport) {
        this.sipStack = (SipStackImpl)sipStack;
        this.port = port;
        this.transport = transport;
    }

    public Object clone() {
        ListeningPointImpl lip = new ListeningPointImpl((SipStack)this.sipStack, this.port, null);
        lip.sipStack = this.sipStack;
        return lip;
    }

    public int getPort() {
        return this.messageProcessor.getPort();
    }

    public String getTransport() {
        return this.messageProcessor.getTransport();
    }

    public SipProviderImpl getProvider() {
        return this.sipProvider;
    }

    public String getIPAddress() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    public void setSentBy(String sentBy) throws ParseException {
        this.messageProcessor.setSentBy(sentBy);
    }

    public String getSentBy() {
        return this.messageProcessor.getSentBy();
    }

    public boolean isSentBySet() {
        return this.messageProcessor.isSentBySet();
    }

    public Via getViaHeader() {
        return this.messageProcessor.getViaHeader();
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public ContactHeader createContactHeader() {
        try {
            String ipAddress = this.getIPAddress();
            int port = this.getPort();
            SipUri sipURI = new SipUri();
            sipURI.setHost(ipAddress);
            sipURI.setPort(port);
            sipURI.setTransportParam(this.transport);
            Contact contact = new Contact();
            AddressImpl address = new AddressImpl();
            address.setURI((URI)sipURI);
            contact.setAddress((Address)address);
            return contact;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((String)"Unexpected exception", (StackLogger)logger);
            return null;
        }
    }

    public void sendHeartbeat(String ipAddress, int port) throws IOException {
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(new Host(ipAddress));
        targetHostPort.setPort(port);
        MessageChannel messageChannel = this.messageProcessor.createMessageChannel(targetHostPort);
        SIPRequest siprequest = new SIPRequest();
        siprequest.setNullRequest();
        messageChannel.sendMessage((SIPMessage)siprequest);
    }

    public ViaHeader createViaHeader() {
        return this.getViaHeader();
    }
}

