/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sip;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.StackLogger;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.DialogTerminatedEvent;
import com.coraltele.interfaces.sip.IOExceptionEvent;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ResponseEvent;
import com.coraltele.interfaces.sip.SipListener;
import com.coraltele.interfaces.sip.TimeoutEvent;
import com.coraltele.interfaces.sip.TransactionTerminatedEvent;
import com.coraltele.javax.sip.DialogTimeoutEvent;
import com.coraltele.javax.sip.EventWrapper;
import com.coraltele.javax.sip.SipListenerExt;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.message.SIPMessage;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPTransaction;
import java.util.EventObject;
import java.util.LinkedList;

class EventScanner
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(EventScanner.class);
    private boolean isStopped;
    private int refCount;
    private LinkedList pendingEvents;
    private int[] eventMutex = new int[]{0};
    private SipStackImpl sipStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefcount() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            ++this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedList();
        Thread myThread = new Thread((Runnable)this);
        myThread.setDaemon(false);
        this.sipStack = sipStackImpl;
        myThread.setName("EventScannerThread");
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("addEvent " + eventWrapper);
        }
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.pendingEvents.add(eventWrapper);
            this.eventMutex.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            if (this.refCount > 0) {
                --this.refCount;
            }
            if (this.refCount == 0) {
                this.isStopped = true;
                this.eventMutex.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.isStopped = true;
            this.refCount = 0;
            this.eventMutex.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliverEvent(EventWrapper eventWrapper) {
        SipListener sipListener;
        EventObject sipEvent;
        block53: {
            sipEvent = eventWrapper.sipEvent;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("sipEvent = " + sipEvent + "source = " + sipEvent.getSource());
            }
            sipListener = null;
            sipListener = !(sipEvent instanceof IOExceptionEvent) ? ((SipProviderImpl)sipEvent.getSource()).getSipListener() : this.sipStack.getSipListener();
            if (!(sipEvent instanceof RequestEvent)) break block53;
            try {
                SIPRequest sipRequest;
                block55: {
                    block54: {
                        SIPServerTransaction tx;
                        sipRequest = (SIPRequest)((RequestEvent)sipEvent).getRequest();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("deliverEvent : " + sipRequest.getFirstLine() + " transaction " + eventWrapper.transaction + " sipEvent.serverTx = " + ((RequestEvent)sipEvent).getServerTransaction());
                        }
                        if ((tx = (SIPServerTransaction)this.sipStack.findTransaction((SIPMessage)sipRequest, true)) == null || tx.passToListener()) break block54;
                        if (sipRequest.getMethod().equals("ACK") && tx.isInviteTransaction() && (tx.getLastResponseStatusCode() / 100 == 2 || this.sipStack.isNon2XXAckPassedToListener())) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Detected broken client sending ACK with same branch! Passing...");
                            }
                            break block55;
                        } else {
                            if (!logger.isLoggingEnabled(32)) return;
                            logger.logDebug("transaction already exists! " + tx);
                            return;
                        }
                    }
                    if (this.sipStack.findPendingTransaction(sipRequest.getTransactionId()) != null) {
                        if (!logger.isLoggingEnabled(32)) return;
                        logger.logDebug("transaction already exists!!");
                        return;
                    }
                    SIPServerTransaction st = (SIPServerTransaction)eventWrapper.transaction;
                    this.sipStack.putPendingTransaction(st);
                }
                sipRequest.setTransaction((Object)eventWrapper.transaction);
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Calling listener " + sipRequest.getFirstLine());
                        logger.logDebug("Calling listener " + eventWrapper.transaction);
                    }
                    if (sipListener != null) {
                        sipListener.processRequest((RequestEvent)sipEvent);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Done processing Message " + sipRequest.getFirstLine());
                    }
                    if (eventWrapper.transaction == null) return;
                    SIPDialog dialog = (SIPDialog)eventWrapper.transaction.getDialog();
                    if (dialog == null) return;
                    dialog.requestConsumed();
                    return;
                }
                catch (Exception ex) {
                    logger.logException((Throwable)ex);
                    return;
                }
            }
            finally {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                }
                if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                    ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                }
                if (eventWrapper.transaction != null) {
                    this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                }
                if (eventWrapper.transaction.getMethod().equals("ACK")) {
                    eventWrapper.transaction.setState(5);
                }
            }
        }
        if (sipEvent instanceof ResponseEvent) {
            try {
                ResponseEvent responseEvent = (ResponseEvent)sipEvent;
                SIPResponse sipResponse = (SIPResponse)responseEvent.getResponse();
                SIPDialog sipDialog = (SIPDialog)responseEvent.getDialog();
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Calling listener " + sipListener + " for " + sipResponse.getFirstLine());
                    }
                    if (sipListener != null) {
                        SIPTransaction tx = eventWrapper.transaction;
                        if (tx != null) {
                            tx.setPassToListener();
                        }
                        sipListener.processResponse((ResponseEvent)sipEvent);
                    }
                    if (!(sipDialog == null || sipDialog.getState() != null && sipDialog.getState().equals((Object)DialogState.TERMINATED) || sipResponse.getStatusCode() != 481 && sipResponse.getStatusCode() != 408)) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Removing dialog on 408 or 481 response");
                        }
                        sipDialog.doDeferredDelete();
                    }
                    if (sipResponse.getCSeq().getMethod().equals("INVITE") && sipDialog != null && sipResponse.getStatusCode() == 200) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Warning! unacknowledged dialog. " + sipDialog.getState());
                        }
                        sipDialog.doDeferredDeleteIfNoAckSent(sipResponse.getCSeq().getSeqNumber());
                    }
                }
                catch (Exception ex) {
                    logger.logException((Throwable)ex);
                }
                SIPClientTransaction ct = (SIPClientTransaction)eventWrapper.transaction;
                if (ct == null) return;
                if (3 != ct.getInternalState()) return;
                if (ct.getMethod().equals("INVITE")) return;
                ct.clearState();
                return;
            }
            finally {
                if (eventWrapper.transaction != null && eventWrapper.transaction.passToListener()) {
                    eventWrapper.transaction.releaseSem();
                }
            }
        }
        if (sipEvent instanceof TimeoutEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processTimeout((TimeoutEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                logger.logException((Throwable)ex);
                return;
            }
        }
        if (sipEvent instanceof DialogTimeoutEvent) {
            try {
                if (sipListener != null && sipListener instanceof SipListenerExt) {
                    ((SipListenerExt)sipListener).processDialogTimeout((DialogTimeoutEvent)sipEvent);
                    return;
                }
                if (!logger.isLoggingEnabled(32)) return;
                logger.logDebug("DialogTimeoutEvent not delivered");
                return;
            }
            catch (Exception ex) {
                logger.logException((Throwable)ex);
                return;
            }
        }
        if (sipEvent instanceof IOExceptionEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processIOException((IOExceptionEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                logger.logException((Throwable)ex);
                return;
            }
        }
        if (sipEvent instanceof TransactionTerminatedEvent) {
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("About to deliver transactionTerminatedEvent");
                    logger.logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getClientTransaction());
                    logger.logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getServerTransaction());
                }
                if (sipListener == null) return;
                sipListener.processTransactionTerminated((TransactionTerminatedEvent)sipEvent);
                return;
            }
            catch (AbstractMethodError ame) {
                if (!logger.isLoggingEnabled()) return;
                logger.logWarning("Unable to call sipListener.processTransactionTerminated");
                return;
            }
            catch (Exception ex) {
                logger.logException((Throwable)ex);
                return;
            }
        }
        if (!(sipEvent instanceof DialogTerminatedEvent)) {
            logger.logFatalError("bad event" + sipEvent);
            return;
        }
        try {
            if (sipListener == null) return;
            sipListener.processDialogTerminated((DialogTerminatedEvent)sipEvent);
            return;
        }
        catch (AbstractMethodError ame) {
            if (!logger.isLoggingEnabled()) return;
            logger.logWarning("Unable to call sipListener.processDialogTerminated");
            return;
        }
        catch (Exception ex) {
            logger.logException((Throwable)ex);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

