/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.parser;

import com.coraltele.core.ParserCore;
import com.coraltele.javax.sdp.SessionDescriptionImpl;
import com.coraltele.javax.sdp.fields.SDPField;
import com.coraltele.javax.sdp.parser.Lexer;
import com.coraltele.javax.sdp.parser.ParserFactory;
import com.coraltele.javax.sdp.parser.SDPParser;
import java.text.ParseException;
import java.util.Vector;

public class SDPAnnounceParser
extends ParserCore {
    protected Lexer lexer;
    protected Vector sdpMessage;

    public SDPAnnounceParser(Vector sdpMessage) {
        this.sdpMessage = sdpMessage;
    }

    public SDPAnnounceParser(String message) {
        int start = 0;
        String line = null;
        if (message == null) {
            return;
        }
        this.sdpMessage = new Vector();
        String sdpAnnounce = message.trim() + "\r\n";
        while (start < sdpAnnounce.length()) {
            int lfPos = sdpAnnounce.indexOf("\n", start);
            int crPos = sdpAnnounce.indexOf("\r", start);
            if (lfPos > 0 && crPos < 0) {
                line = sdpAnnounce.substring(start, lfPos);
                start = lfPos + 1;
            } else if (lfPos < 0 && crPos > 0) {
                line = sdpAnnounce.substring(start, crPos);
                start = crPos + 1;
            } else if (lfPos > 0 && crPos > 0) {
                if (lfPos > crPos) {
                    line = sdpAnnounce.substring(start, crPos);
                    start = lfPos == crPos + 1 ? lfPos + 1 : crPos + 1;
                } else {
                    line = sdpAnnounce.substring(start, lfPos);
                    start = crPos == lfPos + 1 ? crPos + 1 : lfPos + 1;
                }
            } else if (lfPos < 0 && crPos < 0) break;
            this.sdpMessage.addElement(line);
        }
    }

    public SessionDescriptionImpl parse() throws ParseException {
        SessionDescriptionImpl retval = new SessionDescriptionImpl();
        for (int i = 0; i < this.sdpMessage.size(); ++i) {
            String field = (String)this.sdpMessage.elementAt(i);
            SDPParser sdpParser = ParserFactory.createParser((String)field);
            SDPField sdpField = null;
            if (sdpParser != null) {
                sdpField = sdpParser.parse();
            }
            retval.addField(sdpField);
        }
        return retval;
    }
}

