/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.parser;

import com.coraltele.core.InternalErrorHandler;
import com.coraltele.javax.sdp.parser.Lexer;
import com.coraltele.javax.sdp.parser.SDPParser;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Hashtable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParserFactory {
    private static Hashtable parserTable;
    private static Class[] constructorArgs;
    private static final String packageName = "gov.nist.javax.sdp.parser";

    private static Class getParser(String parserClass) {
        try {
            return Class.forName("gov.nist.javax.sdp.parser." + parserClass);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Could not find class");
            ex.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static SDPParser createParser(String field) throws ParseException {
        String fieldName = Lexer.getFieldName((String)field);
        if (fieldName == null) {
            return null;
        }
        Class parserClass = (Class)parserTable.get(fieldName.toLowerCase());
        if (parserClass != null) {
            try {
                Constructor cons = parserClass.getConstructor(constructorArgs);
                Object[] args = new Object[]{field};
                SDPParser retval = (SDPParser)cons.newInstance(args);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException((Exception)ex);
                return null;
            }
        }
        throw new ParseException("Could not find parser for " + fieldName, 0);
    }

    static {
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = String.class;
        parserTable = new Hashtable();
        parserTable.put("a", ParserFactory.getParser((String)"AttributeFieldParser"));
        parserTable.put("b", ParserFactory.getParser((String)"BandwidthFieldParser"));
        parserTable.put("c", ParserFactory.getParser((String)"ConnectionFieldParser"));
        parserTable.put("e", ParserFactory.getParser((String)"EmailFieldParser"));
        parserTable.put("i", ParserFactory.getParser((String)"InformationFieldParser"));
        parserTable.put("k", ParserFactory.getParser((String)"KeyFieldParser"));
        parserTable.put("m", ParserFactory.getParser((String)"MediaFieldParser"));
        parserTable.put("o", ParserFactory.getParser((String)"OriginFieldParser"));
        parserTable.put("p", ParserFactory.getParser((String)"PhoneFieldParser"));
        parserTable.put("v", ParserFactory.getParser((String)"ProtoVersionFieldParser"));
        parserTable.put("r", ParserFactory.getParser((String)"RepeatFieldParser"));
        parserTable.put("s", ParserFactory.getParser((String)"SessionNameFieldParser"));
        parserTable.put("t", ParserFactory.getParser((String)"TimeFieldParser"));
        parserTable.put("u", ParserFactory.getParser((String)"URIFieldParser"));
        parserTable.put("z", ParserFactory.getParser((String)"ZoneFieldParser"));
    }
}

