/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.fields;

import com.coraltele.interfaces.sdp.SdpException;
import com.coraltele.interfaces.sdp.SdpFactory;
import com.coraltele.interfaces.sdp.SdpParseException;
import com.coraltele.interfaces.sdp.Time;
import com.coraltele.javax.sdp.fields.SDPField;
import java.util.Date;

public class TimeField
extends SDPField
implements Time {
    protected long startTime;
    protected long stopTime;

    public TimeField() {
        super("t=");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public Date getStart() throws SdpParseException {
        return SdpFactory.getDateFromNtp((long)this.startTime);
    }

    public Date getStop() throws SdpParseException {
        return SdpFactory.getDateFromNtp((long)this.stopTime);
    }

    public void setStop(Date stop) throws SdpException {
        if (stop == null) {
            throw new SdpException("The date is null");
        }
        this.stopTime = SdpFactory.getNtpTime((Date)stop);
    }

    public void setStart(Date start) throws SdpException {
        if (start == null) {
            throw new SdpException("The date is null");
        }
        this.startTime = SdpFactory.getNtpTime((Date)start);
    }

    public boolean getTypedTime() {
        return false;
    }

    public void setTypedTime(boolean typedTime) {
    }

    public boolean isZero() {
        return this.getStartTime() == 0L && this.getStopTime() == 0L;
    }

    public void setZero() {
        this.setStopTime(0L);
        this.setStartTime(0L);
    }

    public String encode() {
        return "t=" + this.startTime + " " + this.stopTime + "\r\n";
    }
}

