/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.fields;

import com.coraltele.javax.sdp.fields.Indentation;
import com.coraltele.javax.sdp.fields.SDPField;
import com.coraltele.javax.sdp.fields.SDPObject;
import com.coraltele.javax.sdp.fields.SDPObjectList;
import java.util.ListIterator;

public abstract class SDPFieldList
extends SDPField {
    protected SDPObjectList sdpFields;

    public SDPFieldList() {
    }

    public ListIterator listIterator() {
        return this.sdpFields.listIterator();
    }

    public SDPFieldList(String fieldName) {
        super(fieldName);
        this.sdpFields = new SDPObjectList(fieldName);
    }

    public SDPFieldList(String fieldName, String classname) {
        super(fieldName);
        this.sdpFields = new SDPObjectList(fieldName, classname);
    }

    public void add(SDPField h) {
        this.sdpFields.add((SDPObject)h);
    }

    public SDPObject first() {
        return (SDPObject)this.sdpFields.first();
    }

    public SDPObject next() {
        return (SDPObject)this.sdpFields.next();
    }

    public String encode() {
        StringBuilder retval = new StringBuilder();
        ListIterator li = this.sdpFields.listIterator();
        while (li.hasNext()) {
            SDPField sdphdr = (SDPField)li.next();
            retval.append(sdphdr.encode());
        }
        return retval.toString();
    }

    public String debugDump(int indentation) {
        this.stringRepresentation = "";
        String indent = new Indentation(indentation).getIndentation();
        String className = this.getClass().getName();
        this.sprint(indent + className);
        this.sprint(indent + "{");
        this.sprint(indent + this.sdpFields.debugDump(indentation));
        this.sprint(indent + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SDPFieldList that = (SDPFieldList)other;
        if (this.sdpFields == null) {
            return that.sdpFields == null;
        }
        return this.sdpFields.equals((Object)that.sdpFields);
    }

    public boolean match(Object template) {
        if (template == null) {
            return true;
        }
        if (!template.getClass().equals(this.getClass())) {
            return false;
        }
        SDPFieldList other = (SDPFieldList)template;
        if (this.sdpFields == other.sdpFields) {
            return true;
        }
        if (this.sdpFields == null) {
            return false;
        }
        return this.sdpFields.match((Object)other.sdpFields);
    }

    public Object clone() {
        SDPFieldList retval = (SDPFieldList)super.clone();
        if (this.sdpFields != null) {
            retval.sdpFields = (SDPObjectList)this.sdpFields.clone();
        }
        return retval;
    }
}

