/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.fields;

import com.coraltele.interfaces.sdp.RepeatTime;
import com.coraltele.interfaces.sdp.SdpException;
import com.coraltele.interfaces.sdp.SdpParseException;
import com.coraltele.javax.sdp.fields.SDPField;
import com.coraltele.javax.sdp.fields.SDPObject;
import com.coraltele.javax.sdp.fields.SDPObjectList;
import com.coraltele.javax.sdp.fields.TypedTime;
import java.util.LinkedList;
import java.util.ListIterator;

public class RepeatField
extends SDPField
implements RepeatTime {
    private static final long serialVersionUID = -6415338212212641819L;
    protected TypedTime repeatInterval;
    protected TypedTime activeDuration;
    protected SDPObjectList offsets = new SDPObjectList();

    public RepeatField() {
        super("r=");
    }

    public void setRepeatInterval(TypedTime interval) {
        this.repeatInterval = interval;
    }

    public void setActiveDuration(TypedTime duration) {
        this.activeDuration = duration;
    }

    public void addOffset(TypedTime offset) {
        this.offsets.add((SDPObject)offset);
    }

    public LinkedList getOffsets() {
        return this.offsets;
    }

    public int getRepeatInterval() throws SdpParseException {
        if (this.repeatInterval == null) {
            return -1;
        }
        return this.repeatInterval.getTime();
    }

    public void setRepeatInterval(int repeatInterval) throws SdpException {
        if (repeatInterval < 0) {
            throw new SdpException("The repeat interval is <0");
        }
        if (this.repeatInterval == null) {
            this.repeatInterval = new TypedTime();
        }
        this.repeatInterval.setTime(repeatInterval);
    }

    public int getActiveDuration() throws SdpParseException {
        if (this.activeDuration == null) {
            return -1;
        }
        return this.activeDuration.getTime();
    }

    public void setActiveDuration(int activeDuration) throws SdpException {
        if (activeDuration < 0) {
            throw new SdpException("The active Duration is <0");
        }
        if (this.activeDuration == null) {
            this.activeDuration = new TypedTime();
        }
        this.activeDuration.setTime(activeDuration);
    }

    public int[] getOffsetArray() throws SdpParseException {
        LinkedList linkedList = this.getOffsets();
        int[] result = new int[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            TypedTime typedTime = (TypedTime)linkedList.get(i);
            result[i] = typedTime.getTime();
        }
        return result;
    }

    public void setOffsetArray(int[] offsets) throws SdpException {
        for (int i = 0; i < offsets.length; ++i) {
            TypedTime typedTime = new TypedTime();
            typedTime.setTime(offsets[i]);
            this.addOffset(typedTime);
        }
    }

    public boolean getTypedTime() throws SdpParseException {
        return true;
    }

    public void setTypedTime(boolean typedTime) {
    }

    public String encode() {
        StringBuilder retval = new StringBuilder();
        retval.append("r=").append(this.repeatInterval.encode()).append(" ").append(this.activeDuration.encode());
        ListIterator li = this.offsets.listIterator();
        while (li.hasNext()) {
            TypedTime off = (TypedTime)li.next();
            retval.append(" ").append(off.encode());
        }
        retval.append("\r\n");
        return retval.toString();
    }

    public Object clone() {
        RepeatField retval = (RepeatField)super.clone();
        if (this.repeatInterval != null) {
            retval.repeatInterval = (TypedTime)this.repeatInterval.clone();
        }
        if (this.activeDuration != null) {
            retval.activeDuration = (TypedTime)this.activeDuration.clone();
        }
        if (this.offsets != null) {
            retval.offsets = (SDPObjectList)this.offsets.clone();
        }
        return retval;
    }
}

