/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.fields;

import com.coraltele.interfaces.sdp.Key;
import com.coraltele.interfaces.sdp.SdpException;
import com.coraltele.interfaces.sdp.SdpParseException;
import com.coraltele.javax.sdp.fields.SDPField;

public class KeyField
extends SDPField
implements Key {
    protected String type;
    protected String keyData;

    public KeyField() {
        super("k=");
    }

    public String getType() {
        return this.type;
    }

    public String getKeyData() {
        return this.keyData;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setKeyData(String k) {
        this.keyData = k;
    }

    public String encode() {
        String encoded_string = "k=" + this.type;
        if (this.keyData != null) {
            encoded_string = encoded_string + ":";
            encoded_string = encoded_string + this.keyData;
        }
        encoded_string = encoded_string + "\r\n";
        return encoded_string;
    }

    public String getMethod() throws SdpParseException {
        return this.type;
    }

    public void setMethod(String name) throws SdpException {
        this.type = name;
    }

    public boolean hasKey() throws SdpParseException {
        String key = this.getKeyData();
        return key != null;
    }

    public String getKey() throws SdpParseException {
        return this.getKeyData();
    }

    public void setKey(String key) throws SdpException {
        if (key == null) {
            throw new SdpException("The key is null");
        }
        this.setKeyData(key);
    }
}

