/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.javax.sdp.fields;

import com.coraltele.interfaces.sdp.EMail;
import com.coraltele.interfaces.sdp.SdpException;
import com.coraltele.interfaces.sdp.SdpParseException;
import com.coraltele.javax.sdp.fields.EmailAddress;
import com.coraltele.javax.sdp.fields.SDPField;

public class EmailField
extends SDPField
implements EMail {
    protected EmailAddress emailAddress = new EmailAddress();

    public EmailField() {
        super("e=");
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String encode() {
        return "e=" + this.emailAddress.encode() + "\r\n";
    }

    public String toString() {
        return this.encode();
    }

    public String getValue() throws SdpParseException {
        if (this.emailAddress == null) {
            return null;
        }
        return this.emailAddress.getDisplayName();
    }

    public void setValue(String value) throws SdpException {
        if (value == null) {
            throw new SdpException("The value is null");
        }
        this.emailAddress.setDisplayName(value);
    }

    public Object clone() {
        EmailField retval = (EmailField)super.clone();
        if (this.emailAddress != null) {
            retval.emailAddress = (EmailAddress)this.emailAddress.clone();
        }
        return retval;
    }
}

