/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.interfaces.sip;

import com.coraltele.interfaces.sip.PeerUnavailableException;
import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.address.AddressFactory;
import com.coraltele.interfaces.sip.header.HeaderFactory;
import com.coraltele.interfaces.sip.message.MessageFactory;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;

public class SipFactory {
    private String pathName = "gov.nist";
    private Hashtable sipStackByName;
    private MessageFactory messageFactory = null;
    private HeaderFactory headerFactory = null;
    private AddressFactory addressFactory = null;
    private static SipFactory myFactory = null;
    private final LinkedList sipStackList = new LinkedList();

    public static synchronized SipFactory getInstance() {
        if (myFactory == null) {
            myFactory = new SipFactory();
        }
        return myFactory;
    }

    public synchronized SipStack createSipStack(Properties properties) throws PeerUnavailableException {
        String ipAddress = properties.getProperty("javax.sip.IP_ADDRESS");
        String name = properties.getProperty("javax.sip.STACK_NAME");
        if (name == null) {
            throw new PeerUnavailableException("Missing javax.sip.STACK_NAME property");
        }
        if (ipAddress == null) {
            SipStack mySipStack = (SipStack)this.sipStackByName.get(name);
            if (mySipStack == null) {
                mySipStack = this.createStack(properties);
            }
            return mySipStack;
        }
        int i = 0;
        for (i = 0; i < this.sipStackList.size(); ++i) {
            if (!((SipStack)this.sipStackList.get(i)).getIPAddress().equals(ipAddress)) continue;
            return (SipStack)this.sipStackList.get(i);
        }
        return this.createStack(properties);
    }

    public MessageFactory createMessageFactory() throws PeerUnavailableException {
        if (this.messageFactory == null) {
            this.messageFactory = (MessageFactory)this.createSipFactory("javax.sip.message.MessageFactoryImpl");
        }
        return this.messageFactory;
    }

    public HeaderFactory createHeaderFactory() throws PeerUnavailableException {
        if (this.headerFactory == null) {
            this.headerFactory = (HeaderFactory)this.createSipFactory("javax.sip.header.HeaderFactoryImpl");
        }
        return this.headerFactory;
    }

    public AddressFactory createAddressFactory() throws PeerUnavailableException {
        if (this.addressFactory == null) {
            this.addressFactory = (AddressFactory)this.createSipFactory("javax.sip.address.AddressFactoryImpl");
        }
        return this.addressFactory;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void resetFactory() {
        this.sipStackList.clear();
        this.messageFactory = null;
        this.headerFactory = null;
        this.addressFactory = null;
        this.sipStackByName = new Hashtable();
        this.pathName = "gov.nist";
    }

    private Object createSipFactory(String objectClassName) throws PeerUnavailableException {
        if (objectClassName == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> peerObjectClass = Class.forName(this.getPathName() + "." + objectClassName);
            Object newPeerObject = peerObjectClass.newInstance();
            return newPeerObject;
        }
        catch (Exception e) {
            String errmsg = "The Peer Factory: " + this.getPathName() + "." + objectClassName + " could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(errmsg, (Throwable)e);
        }
    }

    private SipStack createStack(Properties properties) throws PeerUnavailableException {
        try {
            Class[] paramTypes = new Class[]{Class.forName("java.util.Properties")};
            Constructor<?> sipStackConstructor = Class.forName(this.getPathName() + ".javax.sip.SipStackImpl").getConstructor(paramTypes);
            Object[] conArgs = new Object[]{properties};
            SipStack sipStack = (SipStack)sipStackConstructor.newInstance(conArgs);
            this.sipStackList.add(sipStack);
            String name = properties.getProperty("javax.sip.STACK_NAME");
            this.sipStackByName.put(name, sipStack);
            return sipStack;
        }
        catch (Exception e) {
            String errmsg = "The Peer SIP Stack: " + this.getPathName() + ".javax.sip.SipStackImpl could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(errmsg, (Throwable)e);
        }
    }

    private SipFactory() {
        this.sipStackByName = new Hashtable();
    }
}

