/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.interfaces.sip;

import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.DialogDoesNotExistException;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.InvalidArgumentException;
import com.coraltele.interfaces.sip.SipException;
import com.coraltele.interfaces.sip.Transaction;
import com.coraltele.interfaces.sip.TransactionDoesNotExistException;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import java.io.Serializable;
import java.util.Iterator;

public interface Dialog
extends Serializable {
    public Address getLocalParty();

    public Address getRemoteParty();

    public Address getRemoteTarget();

    public String getDialogId();

    public CallIdHeader getCallId();

    public int getLocalSequenceNumber();

    public long getLocalSeqNumber();

    public int getRemoteSequenceNumber();

    public long getRemoteSeqNumber();

    public Iterator getRouteSet();

    public boolean isSecure();

    public boolean isServer();

    public void incrementLocalSequenceNumber();

    public Request createRequest(String var1) throws SipException;

    public Response createReliableProvisionalResponse(int var1) throws InvalidArgumentException, SipException;

    public void sendRequest(ClientTransaction var1) throws TransactionDoesNotExistException, SipException;

    public void sendReliableProvisionalResponse(Response var1) throws SipException;

    public Request createPrack(Response var1) throws DialogDoesNotExistException, SipException;

    public Request createAck(long var1) throws InvalidArgumentException, SipException;

    public void sendAck(Request var1) throws SipException;

    public DialogState getState();

    public void delete();

    public Transaction getFirstTransaction();

    public String getLocalTag();

    public String getRemoteTag();

    public void setApplicationData(Object var1);

    public Object getApplicationData();

    public void terminateOnBye(boolean var1) throws SipException;
}

