/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.condition.EnableV2StateMachine;
import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentLengthHeader;
import com.coraltele.interfaces.sip.header.ReferToHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.javax.sip.header.extensions.ReferredByHeader;
import com.coraltele.javax.sip.header.extensions.ReplacesHeader;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.model.StateDialog;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Conditional(value={EnableV2StateMachine.class, EnableIMSV2_SERVER.class})
public class V2StateMachine {
    private static final Logger logger = LogManager.getLogger(V2StateMachine.class);
    private static String className = "V2StateMachine";
    @Autowired
    HelperIMS helperIMS;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Constants.MAX_POOL_SIZE);
    private ReentrantLock rluIpLock = new ReentrantLock();
    private ConcurrentHashMap<String, StateDialog> stateMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<String>> subscribeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentSkipListSet<String>> keyCallIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentSkipListSet<String>> keyUserMap = new ConcurrentHashMap();

    public void onInviteUpdate(SIPDialog inviteDialog, String key, String receivedFromUser, String receivedToUser) {
        String functionName = "onInviteUpdate";
        try {
            Request request;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved INVITE dialog for DialogCallId: " + inviteDialog.getCallId().getCallId() + " fromRegistrar: " + inviteDialog.isServer() + " key: " + key + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Boolean isServer = inviteDialog.isServer();
            Long epochMillis = System.currentTimeMillis();
            String callId = Optional.ofNullable(inviteDialog.getCallId()).map(CallIdHeader::getCallId).orElse(null);
            if (callId == null) {
                this.helperIMS.printCustomLogs(className, functionName, "error", receivedFromUser, receivedFromUser, "CallId is null for key: " + key);
                return;
            }
            Address toHeader = inviteDialog.getLocalParty();
            Address fromHeader = inviteDialog.getRemoteParty();
            SipURI fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
            SipURI toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
            String fromUser = fromURI != null ? fromURI.getUser() : null;
            String toUser = toURI != null ? toURI.getUser() : null;
            long cSeqNumber = isServer != false ? inviteDialog.getRemoteSeqNumber() : inviteDialog.getLocalSeqNumber();
            String fromTag = isServer != false ? inviteDialog.getRemoteTag() : inviteDialog.getLocalTag();
            String toTag = isServer != false ? inviteDialog.getLocalTag() : inviteDialog.getRemoteTag();
            Request request2 = request = inviteDialog.getLastTransaction() != null ? inviteDialog.getLastTransaction().getRequest() : null;
            if (request == null || request.getRequestURI() == null) {
                this.helperIMS.printCustomLogs(className, functionName, "error", fromUser, toUser, "Request or RequestURI is null for callId: " + callId);
                return;
            }
            Address contactHeader = ((ContactHeader)request.getHeader("Contact")).getAddress();
            ToHeader requestToHeader = (ToHeader)request.getHeader("To");
            String fieldName = "Referred-CallId";
            String replaceCall = this.findReplaceHeader(requestToHeader.toString(), fieldName, receivedFromUser, receivedToUser);
            String referredKey = replaceCall != null ? this.findKeyByCallId(replaceCall) : null;
            SipURI requestUri = (SipURI)request.getRequestURI();
            ReplacesHeader replacesHeader = (ReplacesHeader)request.getHeader("Replaces");
            String linkCallId = isServer != false ? key : callId + ":" + toUser;
            String callDirection = this.callDirectionCheck(fromUser, toUser);
            if (!this.stateMap.containsKey(key)) {
                StateDialog replacesStateDialog;
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "No Existing StateDialog is found, creating new for callId : " + callId);
                StateDialog inviteStateDialog = new StateDialog();
                inviteStateDialog.setCallId(callId);
                inviteStateDialog.setState("trying");
                inviteStateDialog.setLocalUser(fromUser);
                inviteStateDialog.setRemoteUser(toUser);
                inviteStateDialog.setLocalNumber(fromURI != null ? fromURI.toString() : null);
                inviteStateDialog.setRemoteNumber(toURI != null ? toURI.toString() : null);
                if (isServer.booleanValue()) {
                    inviteStateDialog.setLocalTag(fromTag);
                } else {
                    inviteStateDialog.setRemoteTag(fromTag);
                }
                inviteStateDialog.setLocalContact(contactHeader.getURI().toString());
                inviteStateDialog.setEpoch(String.valueOf(epochMillis));
                inviteStateDialog.setEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                inviteStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                inviteStateDialog.setCallDirection(callDirection);
                inviteStateDialog.setDirection(isServer != false ? "initiator" : "recipient");
                if (linkCallId != null && this.stateMap.containsKey(linkCallId)) {
                    StateDialog linkStateDialog = (StateDialog)this.stateMap.get(linkCallId);
                    linkStateDialog.setRemoteContact(requestUri.toString());
                    linkStateDialog.setLinkCallId(linkCallId);
                    inviteStateDialog.setLocalContact(requestUri.toString());
                    inviteStateDialog.setRemoteContact(linkStateDialog.getLocalContact());
                    inviteStateDialog.setLinkCallId(linkCallId);
                }
                if (referredKey != null) {
                    StateDialog referredDialog;
                    StateDialog stateDialog = referredDialog = referredKey != null ? (StateDialog)this.stateMap.get(referredKey) : null;
                    if (referredDialog != null) {
                        inviteStateDialog.setReferredBy(referredDialog.getReferredBy());
                        inviteStateDialog.setReferTo(referredDialog.getReferTo());
                        inviteStateDialog.setTransferredBy(referredDialog.getTransferredBy());
                        inviteStateDialog.setTransferredTo(referredDialog.getTransferredTo());
                        inviteStateDialog.setTransferType("blind_transfer");
                    }
                }
                StateDialog stateDialog = replacesStateDialog = replacesHeader != null && replacesHeader.getCallId() != null ? (StateDialog)this.stateMap.get(this.findKeyByCallId(replacesHeader.getCallId())) : null;
                if (replacesStateDialog != null) {
                    inviteStateDialog.setReferredBy(replacesStateDialog.getReferredBy());
                    inviteStateDialog.setReferTo(replacesStateDialog.getReferTo());
                    inviteStateDialog.setTransferredBy(replacesStateDialog.getTransferredBy());
                    inviteStateDialog.setTransferredTo(replacesStateDialog.getTransferredTo());
                    inviteStateDialog.setTransferType(replacesStateDialog.getTransferType());
                }
                this.stateMap.put(key, inviteStateDialog);
                this.keyCallIdMap.computeIfAbsent(callId, k -> new ConcurrentSkipListSet()).add(key);
                this.keyUserMap.computeIfAbsent(fromUser, k -> new ConcurrentSkipListSet()).add(key);
                this.keyUserMap.computeIfAbsent(toUser, k -> new ConcurrentSkipListSet()).add(key);
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    this.scheduler.schedule(() -> this.checkResponseTrying(key), (long)Constants.BACKGROUND_TASK_TIMER_IN_MINUTES.intValue(), TimeUnit.MINUTES);
                }
            } else {
                StateDialog linkStateDialog;
                StateDialog inviteStateDialog = (StateDialog)this.stateMap.get(key);
                linkCallId = inviteStateDialog != null ? this.findByLinkedCallIdAndDirection(inviteStateDialog.getLinkCallId(), inviteStateDialog.getDirection()) : null;
                StateDialog stateDialog = linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
                if (inviteStateDialog != null) {
                    try {
                        this.updateStateWithLock(inviteStateDialog, () -> {
                            boolean holdRequestFlag = this.isHoldRequest(request);
                            System.out.println(request.toString());
                            inviteStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                            if (toTag != null) {
                                inviteStateDialog.setHoldState(holdRequestFlag ? "true" : "false");
                                inviteStateDialog.setHoldBy(holdRequestFlag ? fromUser : null);
                                inviteStateDialog.setHoldTo(holdRequestFlag ? toUser : null);
                                if (linkStateDialog != null) {
                                    try {
                                        this.updateStateWithLock(linkStateDialog, () -> {
                                            linkStateDialog.setHoldState(holdRequestFlag ? "true" : "false");
                                            linkStateDialog.setHoldBy(holdRequestFlag ? fromUser : null);
                                            linkStateDialog.setHoldTo(holdRequestFlag ? toUser : null);
                                        });
                                    }
                                    catch (Exception e) {
                                        logger.error("Error updating linkStateDialog for linkCallId {}: {}", (Object)callId, (Object)e.getMessage(), (Object)e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error("Error locking inviteStateDialog for callId {}: {}", (Object)key, (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error: {} in onInviteUpdate method. inviteDialogCallID: {}", (Object)e.getMessage(), (Object)inviteDialog.getCallId().getCallId(), (Object)e);
        }
    }

    private void checkResponseTrying(String key) {
        String functionName = "checkResponseTrying";
        try {
            if (this.stateMap.containsKey(key) && "trying".equals(((StateDialog)this.stateMap.get(key)).getState())) {
                this.scheduleRemoveDialog(key);
                this.helperIMS.printCustomLogs(className, functionName, "info", ((StateDialog)this.stateMap.get(key)).getLocalUser(), ((StateDialog)this.stateMap.get(key)).getRemoteUser(), "Dialog stuck in trying, scheduled removal of dialog for key: " + key);
            }
        }
        catch (Exception e) {
            logger.error("Error: {} in checkResponseTrying method for key: {}", (Object)e.getMessage(), (Object)key, (Object)e);
        }
    }

    private String callDirectionCheck(String fromExtension, String toExtension) {
        String functionName = "callDirectionCheck";
        try {
            this.helperIMS.printCustomLogs(className, functionName, "info", fromExtension, toExtension, "Received fromExtension: " + fromExtension + " toExtension: " + toExtension);
            if (fromExtension != null && toExtension != null) {
                if (this.helperIMS.extensionMap.containsKey(fromExtension) && this.helperIMS.extensionMap.containsKey(toExtension)) {
                    String fromType = (String)((List)this.helperIMS.extensionMap.get(fromExtension)).get(3);
                    String toType = (String)((List)this.helperIMS.extensionMap.get(toExtension)).get(3);
                    if (this.isInternal(fromType) && this.isInternal(toType)) {
                        return "INT";
                    }
                    if (this.isInternal(fromType)) {
                        return toType;
                    }
                    if (this.isInternal(toType)) {
                        return fromType;
                    }
                    return fromType;
                }
                if (this.helperIMS.extensionMap.containsKey(fromExtension)) {
                    return "OUT";
                }
                if (this.helperIMS.extensionMap.containsKey(toExtension)) {
                    return "IN";
                }
            }
        }
        catch (Exception e) {
            logger.error("Receved Error :{}  in callDirectionCheck Method while processing from : {} and to : {} extensions", (Object)e.getLocalizedMessage(), (Object)fromExtension, (Object)toExtension, (Object)e);
        }
        return "INT";
    }

    private boolean isInternal(String extensionType) {
        return extensionType.equalsIgnoreCase("phone") || extensionType.equalsIgnoreCase("agent") || extensionType.equalsIgnoreCase("fax") || extensionType.equalsIgnoreCase("remoteUser");
    }

    public boolean isHoldRequest(Request request) {
        String sdpContent;
        byte[] content;
        int contentLength;
        ContentLengthHeader contentLengthHeader = (ContentLengthHeader)request.getHeader("Content-Length");
        return contentLengthHeader != null && (contentLength = contentLengthHeader.getContentLength()) > 0 && (content = request.getRawContent()) != null && ((sdpContent = new String(content)).contains("a=inactive") || sdpContent.contains("a=sendonly"));
    }

    public void onByeUpdate(SIPDialog byeDialog, String key, String receivedFromUser, String receivedToUser) {
        String functionName = "onByeUpdate";
        try {
            StateDialog linkStateDialog;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved BYE dialog for DialogCallId: " + byeDialog.getCallId().getCallId() + " key: " + key + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Boolean isServer = byeDialog.isServer();
            Long epochMillis = System.currentTimeMillis();
            Address toHeader = byeDialog.getLocalParty();
            Address fromHeader = byeDialog.getRemoteParty();
            SipURI fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
            SipURI toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
            long cSeqNumber = isServer != false ? byeDialog.getRemoteSeqNumber() : byeDialog.getLocalSeqNumber();
            StateDialog stateDialog = (StateDialog)this.stateMap.get(key);
            String linkCallId = stateDialog != null ? this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection()) : null;
            StateDialog stateDialog2 = linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
            if (stateDialog != null) {
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                    stateDialog.setState("stale");
                    stateDialog.setDisconnectedBy(fromURI != null ? fromURI.getUser() : null);
                    stateDialog.setDisconnectedTo(toURI != null ? toURI.getUser() : null);
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    if (linkStateDialog != null) {
                        try {
                            this.updateStateWithLock(linkStateDialog, () -> {
                                linkStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                                linkStateDialog.setState("stale");
                                linkStateDialog.setDisconnectedBy(fromURI != null ? fromURI.getUser() : null);
                                linkStateDialog.setDisconnectedTo(toURI != null ? toURI.getUser() : null);
                                linkStateDialog.setEndEpoch(String.valueOf(epochMillis));
                                linkStateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                            });
                        }
                        catch (Exception e) {
                            logger.error("Error updating linkStateDialog in onByeUpdate for callId {}: {}", (Object)linkCallId, (Object)e.getMessage(), (Object)e);
                        }
                    }
                });
            }
            this.scheduleRemoveDialog(key);
            if (linkCallId != null) {
                this.scheduleRemoveDialog(linkCallId);
            }
        }
        catch (Exception e) {
            logger.error("Error: {} in onByeUpdate method ByeDialogCallID: {},key: {}", (Object)e.getLocalizedMessage(), (Object)byeDialog.getCallId().getCallId(), (Object)key, (Object)e);
        }
    }

    public void onCancelUpdate(SIPDialog cancelDialog, String key, String receivedFromUser, String receivedToUser) {
        String functionName = "onCancelUpdate";
        try {
            StateDialog linkStateDialog;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved CANCEL dialog for DialogCallId: " + cancelDialog.getCallId().getCallId() + " key: " + key + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Long epochMillis = System.currentTimeMillis();
            Address toHeader = cancelDialog.getLocalParty();
            Address fromHeader = cancelDialog.getRemoteParty();
            SipURI fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
            SipURI toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
            long cSeqNumber = cancelDialog.getRemoteSeqNumber();
            StateDialog stateDialog = (StateDialog)this.stateMap.get(key);
            String linkCallId = stateDialog != null ? this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection()) : null;
            StateDialog stateDialog2 = linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
            if (stateDialog != null && cSeqNumber >= Long.parseLong(stateDialog.getCseqNumber())) {
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                    stateDialog.setState("cancelled");
                    stateDialog.setDisconnectedBy(fromURI != null ? fromURI.getUser() : null);
                    stateDialog.setDisconnectedTo(toURI != null ? toURI.getUser() : null);
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    if (linkStateDialog != null) {
                        try {
                            this.updateStateWithLock(linkStateDialog, () -> {
                                linkStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                                linkStateDialog.setState("cancelled");
                                linkStateDialog.setDisconnectedBy(fromURI != null ? fromURI.getUser() : null);
                                linkStateDialog.setDisconnectedTo(toURI != null ? toURI.getUser() : null);
                                linkStateDialog.setEndEpoch(String.valueOf(epochMillis));
                                linkStateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                            });
                        }
                        catch (Exception ex) {
                            logger.error("Error updating linkStateDialog in onCancelUpdate for callId {}: {}", (Object)linkCallId, (Object)ex.getMessage(), (Object)ex);
                        }
                    }
                });
            }
            this.scheduleRemoveDialog(key);
            if (linkCallId != null) {
                this.scheduleRemoveDialog(linkCallId);
            }
        }
        catch (Exception e) {
            logger.error("Error: {} in onCancelUpdate method CancelDialogCallId: {}", (Object)e.getLocalizedMessage(), (Object)cancelDialog.getCallId().getCallId(), (Object)e);
        }
    }

    public void updateResponse(SIPDialog responseDialog, String key, String receivedFromUser, String receivedToUser) {
        String functionName = "updateResponse";
        this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Received " + responseDialog.getMethod().toUpperCase() + " response Dialog for DialogCallId : " + responseDialog.getCallId().getCallId() + " fromRegistrar: " + responseDialog.isServer() + " key: " + key + " receivedfromUser: " + receivedFromUser + " receivedTouser: " + receivedToUser);
        Long epochMillis = System.currentTimeMillis();
        Boolean isServer = responseDialog.isServer();
        try {
            String callID;
            CallIdHeader callIdHeader = responseDialog.getCallId();
            String string = callID = callIdHeader != null ? callIdHeader.getCallId() : null;
            if (callID == null || !this.stateMap.containsKey(key)) {
                this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "No Existing StateDialog is found for callID : " + callID + " for Key: " + key);
                return;
            }
            StateDialog responseStateDialog = (StateDialog)this.stateMap.get(key);
            if (HelperIMS.DISCONNECTED_STATES.contains(responseStateDialog.getState())) {
                return;
            }
            Address toHeader = responseDialog.getLocalParty();
            Address fromHeader = responseDialog.getRemoteParty();
            SipURI fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
            SipURI toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
            String toTag = isServer != false ? responseDialog.getLocalTag() : responseDialog.getRemoteTag();
            int statusCode = responseDialog.getLastResponseStatusCode();
            if (responseDialog.getLastResponseMethod().equals("INVITE")) {
                this.handleInviteResponse(statusCode, responseStateDialog, epochMillis, toURI, fromURI, toTag, isServer, key);
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in updateResponse method ResponseDialogCallId : {},key:{} ", (Object)e.getLocalizedMessage(), (Object)responseDialog.getCallId().getCallId(), (Object)key, (Object)e);
        }
    }

    private void handleInviteResponse(int statusCode, StateDialog stateDialog, Long epochMillis, SipURI toURI, SipURI fromURI, String toTag, Boolean isServer, String key) throws Exception {
        String functionName = "hanldeInviteResponse";
        this.helperIMS.printCustomLogs(className, functionName, "info", fromURI.getUser(), toURI.getUser(), "Received INVITE response Dialog for DialogCallId : " + stateDialog.getCallId() + " statusCode: " + statusCode + " fromURI: " + fromURI + " toURI: " + toURI + " toTag: " + toTag + " isServer: " + isServer + " key: " + key);
        switch (statusCode) {
            case 180: 
            case 183: {
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setRingEpoch(String.valueOf(epochMillis));
                    stateDialog.setRingEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    stateDialog.setState("ringing");
                    if (isServer.booleanValue()) {
                        stateDialog.setRemoteTag(toTag);
                    } else {
                        stateDialog.setLocalTag(toTag);
                    }
                });
                break;
            }
            case 200: 
            case 202: 
            case 204: {
                if ("confirmed".equals(stateDialog.getState())) break;
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setState("confirmed");
                    if (isServer.booleanValue()) {
                        stateDialog.setRemoteTag(toTag);
                    } else {
                        stateDialog.setLocalTag(toTag);
                    }
                    stateDialog.setAnswerEpoch(String.valueOf(epochMillis));
                    stateDialog.setAnswerEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    stateDialog.setIsAnswered("true");
                });
                break;
            }
            case 480: 
            case 486: {
                this.updateStateWithLock(stateDialog, () -> {
                    String linkCallId = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
                    StateDialog linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
                    stateDialog.setState(statusCode == 480 ? "unavailable" : "declined");
                    stateDialog.setDisconnectedBy(fromURI.getUser());
                    stateDialog.setDisconnectedTo(toURI.getUser());
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    if (linkStateDialog != null) {
                        linkStateDialog.setState(statusCode == 480 ? "unavailable" : "declined");
                        linkStateDialog.setDisconnectedBy(fromURI.getUser());
                        linkStateDialog.setDisconnectedTo(toURI.getUser());
                        linkStateDialog.setEndEpoch(String.valueOf(epochMillis));
                        linkStateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    }
                    this.scheduleRemoveDialog(linkCallId);
                });
                this.scheduleRemoveDialog(key);
                break;
            }
            case 487: {
                if (stateDialog.getState().equals("cancelled")) {
                    return;
                }
                this.updateStateWithLock(stateDialog, () -> {
                    String linkCallId = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
                    StateDialog linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
                    stateDialog.setState("cancelled");
                    stateDialog.setDisconnectedBy(fromURI.getUser());
                    stateDialog.setDisconnectedTo(toURI.getUser());
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    if (linkStateDialog != null) {
                        linkStateDialog.setState("cancelled");
                        linkStateDialog.setDisconnectedBy(fromURI.getUser());
                        linkStateDialog.setDisconnectedTo(toURI.getUser());
                        linkStateDialog.setEndEpoch(String.valueOf(epochMillis));
                        linkStateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    }
                    this.scheduleRemoveDialog(linkCallId);
                });
                this.scheduleRemoveDialog(key);
                break;
            }
            case 407: {
                break;
            }
            default: {
                if (statusCode < 400) break;
                this.updateStateWithLock(stateDialog, () -> {
                    String linkCallId = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
                    StateDialog linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
                    stateDialog.setState("terminated");
                    stateDialog.setDisconnectedBy(fromURI.getUser());
                    stateDialog.setDisconnectedTo(toURI.getUser());
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    if (linkStateDialog != null) {
                        linkStateDialog.setState("terminated");
                        linkStateDialog.setDisconnectedBy(fromURI.getUser());
                        linkStateDialog.setDisconnectedTo(toURI.getUser());
                        linkStateDialog.setEndEpoch(String.valueOf(epochMillis));
                        linkStateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                    }
                    this.scheduleRemoveDialog(linkCallId);
                });
                this.scheduleRemoveDialog(key);
            }
        }
    }

    public void onReferUpdate(SIPDialog referDialog, ReferToHeader referToHeader, ReferredByHeader referredByHeader, String key, String receivedFromUser, String receivedToUser) {
        String functionName = "onReferUpdate";
        try {
            StateDialog replacekeyDialog;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Received REFER dialog key: " + key + " for DialogCallId : " + referDialog.getCallId().getCallId() + ",\n referToHeader : " + referToHeader.getAddress().getURI().toString() + ",\nreferByHeader : " + referredByHeader.getAddress().toString() + ",\nreceivedFromUser: " + receivedFromUser + " receivedToUser: " + receivedToUser);
            StateDialog referStateDialog = (StateDialog)this.stateMap.get(key);
            if (referStateDialog == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "No Existing StateDialog is found for key : " + key);
                return;
            }
            Boolean isServer = referDialog.isServer();
            long cSeqNumber = isServer != false ? referDialog.getRemoteSeqNumber() : referDialog.getLocalSeqNumber();
            String fieldName = "Replaces";
            String replaceHeader = this.findReplaceHeader(referToHeader.getAddress().getURI().toString(), fieldName, receivedFromUser, receivedToUser);
            String replaceKey = replaceHeader != null ? this.findKeyByCallId(replaceHeader) : null;
            this.updateStateWithLock(referStateDialog, () -> this.updateStateDialog(referStateDialog, cSeqNumber, referToHeader, referredByHeader, replaceKey));
            if (replaceKey != null && (replacekeyDialog = (StateDialog)this.stateMap.get(replaceKey)) != null) {
                this.updateStateWithLock(replacekeyDialog, () -> {
                    this.updateStateDialog(replacekeyDialog, Long.parseLong(replacekeyDialog.getCseqNumber()), referToHeader, referredByHeader, replaceKey);
                    this.findTransferType(referStateDialog, replacekeyDialog, replacekeyDialog.getState());
                });
            }
        }
        catch (Exception e) {
            logger.error("Error in onReferUpdate for referDialogCallID: {} - {}", (Object)referDialog.getCallId(), (Object)e.getMessage(), (Object)e);
        }
    }

    private void updateStateDialog(StateDialog stateDialog, long cSeqNumber, ReferToHeader referToHeader, ReferredByHeader referredByHeader, String replaceKey) {
        StateDialog linkStateDialog;
        String referredBy = referredByHeader.getAddress().getURI().toString();
        String referToUri = V2StateMachine.extractSipUri((String)referToHeader.getAddress().getURI().toString());
        String transferredBy = ((SipURI)referredByHeader.getAddress().getURI()).getUser();
        String transferredTo = ((SipURI)referToHeader.getAddress().getURI()).getUser();
        String cSeqString = String.valueOf(cSeqNumber);
        stateDialog.setCseqNumber(cSeqString);
        stateDialog.setReferredBy(referredBy);
        stateDialog.setReferTo(referToUri);
        stateDialog.setTransferredBy(transferredBy);
        stateDialog.setTransferredTo(transferredTo);
        String linkCallId = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
        StateDialog stateDialog2 = linkStateDialog = linkCallId != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
        if (linkStateDialog != null) {
            try {
                this.updateStateWithLock(linkStateDialog, () -> {
                    linkStateDialog.setCseqNumber(cSeqString);
                    linkStateDialog.setReferredBy(referredBy);
                    linkStateDialog.setReferTo(referToUri);
                    linkStateDialog.setTransferredBy(transferredBy);
                    linkStateDialog.setTransferredTo(transferredTo);
                    if (replaceKey == null) {
                        linkStateDialog.setTransferType("blind_transfer");
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error updating linkStateDialog in updateStateDialog function for linkCallId {}: {}", (Object)linkCallId, (Object)e.getMessage(), (Object)e);
            }
        }
        if (replaceKey == null) {
            stateDialog.setTransferType("blind_transfer");
        }
    }

    private void findTransferType(StateDialog stateDialog, StateDialog replacekeyDialog, String state) {
        String transferType = "ringing".equals(state) ? "semiAttended_transfer" : "attended_transfer";
        String stateLinkedCallId = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
        String replaceLinkedCallId = this.findByLinkedCallIdAndDirection(replacekeyDialog.getLinkCallId(), replacekeyDialog.getDirection());
        StateDialog stateLinkedDialog = stateLinkedCallId != null ? (StateDialog)this.stateMap.get(stateLinkedCallId) : null;
        StateDialog replaceStateDialog = replaceLinkedCallId != null ? (StateDialog)this.stateMap.get(replaceLinkedCallId) : null;
        stateDialog.setTransferType(transferType);
        replacekeyDialog.setTransferType(transferType);
        if (stateLinkedDialog != null) {
            stateLinkedDialog.setTransferType(transferType);
        }
        if (replaceStateDialog != null) {
            replaceStateDialog.setTransferType(transferType);
        }
    }

    public String findReplaceHeader(String input, String fieldName, String receivedFromUser, String receivedToUser) {
        String functionName = "findReplaceHeader";
        if (input == null || input.isEmpty() || fieldName == null || fieldName.isEmpty()) {
            this.helperIMS.printCustomLogs(className, functionName, "warn", receivedFromUser, receivedToUser, "Invalid  input or any fieldName: input= " + input + ", key= " + fieldName);
            return null;
        }
        try {
            String decodedInput = URLDecoder.decode(input, "UTF-8");
            String pattern = fieldName + "=([^;]+)";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(decodedInput);
            if (m.find()) {
                String replacesCallID = m.group(1);
                System.out.println(fieldName + " Call ID: " + replacesCallID);
                return replacesCallID.trim();
            }
        }
        catch (Exception e) {
            System.err.println("Error decoding input: " + e.getMessage());
        }
        return null;
    }

    private static String extractSipUri(String input) {
        int questionMarkIndex = input.indexOf(63);
        if (questionMarkIndex != -1) {
            return input.substring(0, questionMarkIndex);
        }
        return input;
    }

    private void updateStateWithLock(StateDialog stateDialog, Runnable task) throws Exception {
        block5: {
            try {
                if (!stateDialog.getLock().tryLock(2L, TimeUnit.SECONDS)) break block5;
                try {
                    task.run();
                }
                finally {
                    stateDialog.getLock().unlock();
                }
            }
            catch (Exception e) {
                logger.error("Lock acquisition interrupted for dialog: {} ,{}", (Object)stateDialog.getCallId(), (Object)e.getLocalizedMessage());
            }
        }
    }

    private void scheduleRemoveDialog(String key) {
        String functionName = "scheduleRemoveDialog";
        try {
            if (key == null) {
                return;
            }
            if (this.stateMap.get(key) == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", null, null, "Dialog is not found to remove for key:" + key);
                return;
            }
            this.scheduler.schedule(() -> {
                StateDialog dialog = (StateDialog)this.stateMap.get(key);
                if (dialog != null) {
                    this.stateMap.remove(key);
                    this.removeKeyFromMapSet(this.keyCallIdMap, dialog.getCallId(), key);
                    this.removeKeyFromMapSet(this.keyUserMap, dialog.getLocalUser(), key);
                    this.removeKeyFromMapSet(this.keyUserMap, dialog.getRemoteUser(), key);
                }
            }, 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Error in scheduleRemoveDialog for key : {} ,{}", (Object)key, (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    private void removeKeyFromMapSet(ConcurrentHashMap<String, ConcurrentSkipListSet<String>> map, String mapKey, String valueToRemove) {
        if (mapKey == null || valueToRemove == null) {
            return;
        }
        ConcurrentSkipListSet<String> set = map.get(mapKey);
        if (set != null) {
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                map.remove(mapKey, set);
            }
        }
    }

    private String findKeyByCallId(String callId) {
        return this.stateMap.entrySet().stream().filter(entry -> callId.equals(((StateDialog)entry.getValue()).getCallId())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public String findByLinkedCallIdAndDirection(String linkedCallId, String direction) {
        if (linkedCallId == null || direction == null) {
            return null;
        }
        return this.stateMap.entrySet().stream().filter(entry -> linkedCallId.equals(((StateDialog)entry.getValue()).getLinkCallId())).filter(entry -> !direction.equals(((StateDialog)entry.getValue()).getDirection())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public List<StateDialog> getchannel() {
        return new ArrayList<StateDialog>(this.stateMap.values());
    }

    public List<StateDialog> getDialogsByCallId(String callId) {
        ConcurrentSkipListSet keys = (ConcurrentSkipListSet)this.keyCallIdMap.get(callId);
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        return keys.stream().map(this.stateMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<StateDialog> getDialogsByUser(String user) {
        ConcurrentSkipListSet keys = (ConcurrentSkipListSet)this.keyUserMap.get(user);
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        return keys.stream().map(this.stateMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void releaseDialog(String callId) {
        StateDialog linkStateDialog;
        String callKey = this.findKeyByCallId(callId);
        StateDialog stateDialog = callKey != null ? (StateDialog)this.stateMap.get(callKey) : null;
        String linkedKey = null;
        if (stateDialog != null) {
            linkedKey = this.findByLinkedCallIdAndDirection(stateDialog.getLinkCallId(), stateDialog.getDirection());
            try {
                this.updateStateWithLock(stateDialog, () -> stateDialog.setState("stale"));
            }
            catch (Exception e) {
                logger.error("Error updating stateDialog for linkCallId {}: {}", (Object)callId, (Object)e.getMessage(), (Object)e);
            }
        }
        StateDialog stateDialog2 = linkStateDialog = linkedKey != null ? (StateDialog)this.stateMap.get(linkedKey) : null;
        if (linkStateDialog != null) {
            try {
                this.updateStateWithLock(linkStateDialog, () -> linkStateDialog.setState("stale"));
            }
            catch (Exception e) {
                logger.error("Error updating linkStateDialog for linkCallId {}: {}", (Object)callId, (Object)e.getMessage(), (Object)e);
            }
        }
        this.scheduleRemoveDialog(callKey);
        if (linkedKey != null) {
            this.scheduleRemoveDialog(linkedKey);
        }
    }

    public String getCallStatusFromStateMachine(String key) {
        String callStatus = "Available";
        if (this.stateMap.containsKey(key)) {
            StateDialog stateDialog = (StateDialog)this.stateMap.get(key);
            if (stateDialog.getDirection().equals("initiator")) {
                if (stateDialog.getState().equalsIgnoreCase("ringing")) {
                    callStatus = "Call";
                } else if (stateDialog.getState().equalsIgnoreCase("confirmed")) {
                    callStatus = stateDialog.getHoldState() == null || stateDialog.getHoldState().equals("false") ? "Talk" : "Hold";
                }
            } else if (stateDialog.getState().equalsIgnoreCase("ringing")) {
                callStatus = "Ring";
            } else if (stateDialog.getState().equalsIgnoreCase("confirmed")) {
                callStatus = stateDialog.getHoldState() == null || stateDialog.getHoldState().equals("false") ? "Talk" : "Hold";
            }
        }
        return callStatus;
    }

    public boolean hasOtherActiveCallLegs(String user, String currentCallId) {
        return this.stateMap.values().stream().filter(s -> !s.getCallId().equals(currentCallId)).anyMatch(s -> (s.getLocalUser().equals(user) || s.getRemoteUser().equals(user)) && this.isActiveState(s.getState()));
    }

    public boolean hasOtherConfirmCallLegs(String user, String currentCallId) {
        return this.stateMap.values().stream().filter(s -> !s.getCallId().equals(currentCallId)).anyMatch(s -> (s.getLocalUser().equals(user) || s.getRemoteUser().equals(user)) && this.isConfirmedState(s.getState()));
    }

    private boolean isActiveState(String state) {
        String lower = state.toLowerCase();
        return lower.equals("confirmed") || lower.equals("ringing") || lower.equals("trying");
    }

    private boolean isConfirmedState(String state) {
        String lower = state.toLowerCase();
        return lower.equals("confirmed");
    }

    public String[] getUsersfromCallId(String callId) {
        StateDialog stateDialog;
        String callKey = this.findKeyByCallId(callId);
        StateDialog stateDialog2 = stateDialog = callKey != null ? (StateDialog)this.stateMap.get(callKey) : null;
        if (stateDialog != null) {
            String[] users = new String[]{stateDialog.getLocalUser(), stateDialog.getRemoteUser()};
            return users;
        }
        return null;
    }

    public String[] getUsers_StateAndCallId(String user) {
        for (StateDialog dialog : this.stateMap.values()) {
            if (!user.equals(dialog.getLocalUser()) && !user.equals(dialog.getRemoteUser())) continue;
            return new String[]{dialog.getState(), dialog.getCallId()};
        }
        return new String[]{"stale", " "};
    }

    public String[] getUsers_StateAndOtherUser(String user) {
        for (StateDialog dialog : this.stateMap.values()) {
            if (user.equals(dialog.getLocalUser())) {
                if ("true".equals(dialog.getHoldState())) {
                    return new String[]{"Hold", dialog.getRemoteUser()};
                }
                return new String[]{dialog.getState(), dialog.getRemoteUser()};
            }
            if (!user.equals(dialog.getRemoteUser())) continue;
            if ("true".equals(dialog.getHoldState())) {
                return new String[]{"Hold", dialog.getLocalUser()};
            }
            return new String[]{dialog.getState(), dialog.getLocalUser()};
        }
        return new String[]{"stale", " "};
    }

    public HelperIMS getHelperIMS() {
        return this.helperIMS;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public ReentrantLock getRluIpLock() {
        return this.rluIpLock;
    }

    public ConcurrentHashMap<String, StateDialog> getStateMap() {
        return this.stateMap;
    }

    public ConcurrentHashMap<String, List<String>> getSubscribeMap() {
        return this.subscribeMap;
    }

    public ConcurrentHashMap<String, ConcurrentSkipListSet<String>> getKeyCallIdMap() {
        return this.keyCallIdMap;
    }

    public ConcurrentHashMap<String, ConcurrentSkipListSet<String>> getKeyUserMap() {
        return this.keyUserMap;
    }

    public void setHelperIMS(HelperIMS helperIMS) {
        this.helperIMS = helperIMS;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void setRluIpLock(ReentrantLock rluIpLock) {
        this.rluIpLock = rluIpLock;
    }

    public void setStateMap(ConcurrentHashMap<String, StateDialog> stateMap) {
        this.stateMap = stateMap;
    }

    public void setSubscribeMap(ConcurrentHashMap<String, List<String>> subscribeMap) {
        this.subscribeMap = subscribeMap;
    }

    public void setKeyCallIdMap(ConcurrentHashMap<String, ConcurrentSkipListSet<String>> keyCallIdMap) {
        this.keyCallIdMap = keyCallIdMap;
    }

    public void setKeyUserMap(ConcurrentHashMap<String, ConcurrentSkipListSet<String>> keyUserMap) {
        this.keyUserMap = keyUserMap;
    }
}

