/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableSUBSCRIBER_SERVER;
import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.header.SubscriptionStateHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.RequestEventExt;
import com.coraltele.model.SubscriberUser;
import com.coraltele.model.SubscriberUserModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Conditional(value={EnableSUBSCRIBER_SERVER.class})
public class SubscribeIMS {
    private static final Logger logger = LogManager.getLogger(SubscribeIMS.class);
    BlockingQueue<Runnable> subscriberQueue = null;
    ThreadPoolExecutor subscriberExecutor = null;
    BlockingQueue<Runnable> notifierQueue = null;
    ThreadPoolExecutor notifierExecutor = null;
    private Map<String, List<SubscriberUser>> subscriptions = new ConcurrentHashMap();
    @Autowired
    HelperIMS helperIMS;

    public SubscribeIMS() {
        this.subscriberQueue = new LinkedBlockingQueue();
        this.subscriberExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.subscriberQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.notifierQueue = new LinkedBlockingQueue();
        this.notifierExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.notifierQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public Map<String, List<SubscriberUser>> getSubscriptions() {
        return this.subscriptions;
    }

    public void processRequest(RequestEvent requestEvent) {
        try {
            this.subscriberExecutor.submit(() -> this.handleSubscription(requestEvent));
        }
        catch (Exception e) {
            logger.error("Error in processRequest method while handling subscription {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void sendNotify(String subscriptionUser, String activeCallID, String callState) {
        this.notifierExecutor.submit(() -> this.checkSubscription("request", subscriptionUser, "", activeCallID, callState, 0L));
    }

    public void updateNotify(String eventType, String subscriptionUser, String toUser, long responseSequence) {
        this.notifierExecutor.submit(() -> {
            if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(subscriptionUser)) {
                logger.info("In updateNotify method received eventype - {} , subscriptionUser - {} , toUser - {} , responseSequence - {}", (Object)eventType, (Object)subscriptionUser, (Object)toUser, (Object)responseSequence);
            }
            this.checkSubscription(eventType, subscriptionUser, toUser, "", "", responseSequence);
        });
    }

    public void handleSubscription(RequestEvent requestEvent) {
        try {
            SubscriptionStateHeader subscriptionState = null;
            SubscriberUser subscriberUser = null;
            Response response = null;
            Request request = requestEvent.getRequest();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
            ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            String subscriptionHost = ((RequestEventExt)requestEvent).getRemoteIpAddress() + ":" + ((RequestEventExt)requestEvent).getRemotePort();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                logger.info("In handleSubscription method Received request from : {} ->\n{}", (Object)subscriptionHost, (Object)request);
            }
            if (serverTransaction == null) {
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            boolean initial = false;
            Dialog dialog = serverTransaction.getDialog();
            if (requestEvent.getDialog() == null) {
                if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                    logger.info("In handleSubscription method request from : {} : For User {} :  New Dialog Created", (Object)fromUser, (Object)toUser);
                }
                initial = true;
                String toTag = Integer.toHexString((int)(Math.random() * 2.147483647E9));
                response = this.helperIMS.getMessageFactory().createResponse(202, request);
                if (toHeader.getTag() != null && (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser))) {
                    logger.info("In handleSubscription method To-tag!=null but no dialog match! My dialog {}", (Object)dialog.getState());
                }
                toHeader.setTag(toTag);
                dialog = serverTransaction.getDialog();
                dialog.terminateOnBye(false);
            } else {
                if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                    logger.info("In handleSubscription method request from : {} : For User {} :  Dialog Already available", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)((SipURI)toHeader.getAddress().getURI()).getUser());
                }
                response = this.helperIMS.getMessageFactory().createResponse(200, request);
            }
            if (expiresHeader == null) {
                expiresHeader = contactHeader.getExpires() != -1 ? this.helperIMS.getHeaderFactory().createExpiresHeader(contactHeader.getExpires()) : this.helperIMS.getHeaderFactory().createExpiresHeader(0);
                request.setExpires(expiresHeader);
            }
            response.addHeader((Header)expiresHeader);
            response.addHeader((Header)contactHeader);
            if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                logger.info("In handleSubscription method request from : {} : For User {} :  Source {} : Contact {}", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)((SipURI)toHeader.getAddress().getURI()).getUser(), (Object)subscriptionHost, (Object)contactHeader.getAddress());
            }
            if (expiresHeader.getExpires() > 0) {
                subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("active");
                subscriptionState.setExpires(expiresHeader.getExpires());
                subscriberUser = new SubscriberUser();
                subscriberUser.setEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                subscriberUser.setExpires(Long.valueOf(subscriberUser.getEpoch() + (long)expiresHeader.getExpires()));
                subscriberUser.setSubscriber(((SipURI)fromHeader.getAddress().getURI()).getUser());
                subscriberUser.setSubscriptionHost(subscriptionHost);
                subscriberUser.setSubscribeDialog(dialog);
                subscriberUser.setContact(contactHeader.getAddress().getURI().toString());
                subscriberUser.setActive(true);
                subscriberUser.setHostAddress(((RequestEventExt)requestEvent).getRemoteIpAddress());
                subscriberUser.setHostPort(((RequestEventExt)requestEvent).getRemotePort());
                subscriberUser.setRequest(request.toString());
                subscriberUser.setExpirationTime(Long.valueOf(System.currentTimeMillis() + (long)expiresHeader.getExpires() * 1000L));
                subscriberUser.setExpirationDateTime(this.helperIMS.getISTfromEpoch(subscriberUser.getExpires(), TimeUnit.SECONDS));
                this.updateSubscription(((SipURI)toHeader.getAddress().getURI()).getUser(), subscriberUser);
            } else {
                subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("terminated");
                subscriptionState.setReasonCode("noresource");
                this.removeSubscription(((SipURI)toHeader.getAddress().getURI()).getUser(), ((SipURI)fromHeader.getAddress().getURI()).getUser());
            }
            response.addHeader((Header)subscriptionState);
            response.addHeader((Header)this.helperIMS.getHeaderFactory().createContentLengthHeader(0));
            serverTransaction.sendResponse(response);
            if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                logger.info("In handleSubscription method request from : {} : For User {} :  Acceptance sent \r\n {}", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)((SipURI)toHeader.getAddress().getURI()).getUser(), (Object)response.toString());
            }
            if (initial) {
                if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                    logger.info("In handleSubscription method request from : {} : For User {} :  Creating notify for new Dialog", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)((SipURI)toHeader.getAddress().getURI()).getUser());
                }
                Request notifyRequest = dialog.createRequest("NOTIFY");
                notifyRequest = this.helperIMS.removeRouteHeaders(notifyRequest, "handleSubscription");
                notifyRequest.setRequestURI(contactHeader.getAddress().getURI());
                if (StringUtils.hasLength((String)Constants.FORWARDING_IP_ADDRESS) && subscriptionHost.equals(Constants.FORWARDING_IP_ADDRESS_WITH_PORT)) {
                    SipURI routeSipUri = this.helperIMS.getAddressFactory().createSipURI(null, Constants.FORWARDING_IP_ADDRESS);
                    routeSipUri.setPort(Constants.FORWARDING_PORT.intValue());
                    routeSipUri.setLrParam();
                    routeSipUri.setTransportParam("UDP");
                    Address routeSipAddress = this.helperIMS.getAddressFactory().createAddress((URI)routeSipUri);
                    RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(routeSipAddress);
                    notifyRequest.addFirst((Header)routeHeader);
                    ContactHeader contactHeader2 = this.helperIMS.getHeaderFactory().createContactHeader(routeSipAddress);
                    notifyRequest.setHeader((Header)contactHeader2);
                }
                this.helperIMS.setUserAgentHeaderRequest(notifyRequest, "handleSubscription");
                notifyRequest.setHeader((Header)eventHeader);
                if (expiresHeader.getExpires() > 0) {
                    subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("active");
                    subscriptionState.setExpires(expiresHeader.getExpires());
                    notifyRequest.addHeader((Header)subscriptionState);
                    String subScriberContent = "<?xml version=\"1.0\"?>\r\n<dialog-info xmlns=\"urn:ietf:params:xml:ns:dialog-info\" version=\"0\" state=\"full\" entity=\"sip:#subscriberUser@#subscriberIP\">\r\n</dialog-info>";
                    subScriberContent = subScriberContent.replace("#subscriberUser", ((SipURI)fromHeader.getAddress().getURI()).getUser()).replace("#subscriberIP", Constants.FORWARDING_IP_ADDRESS);
                    byte[] contentBytes = subScriberContent.getBytes();
                    ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "dialog-info+xml");
                    notifyRequest.setContent((Object)contentBytes, contentTypeHeader);
                } else {
                    subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("terminated");
                    subscriptionState.setReasonCode("noresource");
                    notifyRequest.addHeader((Header)subscriptionState);
                    notifyRequest.addHeader((Header)this.helperIMS.getHeaderFactory().createContentLengthHeader(0));
                }
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(notifyRequest);
                dialog.sendRequest(ct);
                if (this.helperIMS.isValidLogUser(toUser) || this.helperIMS.isValidLogUser(fromUser)) {
                    logger.info("From handleSubscription method request from : {} : For User {} :  Sent notify for new Dialog : \n{}", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)((SipURI)toHeader.getAddress().getURI()).getUser(), (Object)notifyRequest.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in handleSubscription method while handling subscription {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscription(String subscribedUser, SubscriberUser subscribedBy) {
        try {
            String subscribedByUser = subscribedBy.getSubscriber();
            if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedByUser)) {
                logger.info("In updateSubscription method request SubscribedUser : {} : SubscribedBy {} :  received", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
            }
            List subscriberList = this.subscriptions.computeIfAbsent(subscribedUser, k -> new ArrayList());
            Boolean found = false;
            for (SubscriberUser subscriber : subscriberList) {
                found = subscriber.getSubscriber().equals(subscribedBy.getSubscriber());
                if (!Boolean.TRUE.equals(found)) continue;
                if (!subscriber.getLock().tryLock(2L, TimeUnit.SECONDS)) break;
                try {
                    if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedByUser)) {
                        logger.info("In updateSubscription method request from : {} : For User {} :  Dialog found updating dialog information", (Object)subscribedBy.getSubscriber(), (Object)subscribedUser);
                    }
                    subscriber.setEpoch(subscribedBy.getEpoch());
                    subscriber.setExpires(subscribedBy.getExpires());
                    subscriber.setSubscribeDialog(subscribedBy.getSubscribeDialog());
                    subscriber.setSubscriptionHost(subscribedBy.getSubscriptionHost());
                    subscriber.setActive(true);
                    subscriber.setSubscribedTo(subscribedUser);
                    subscriber.setContact(subscribedBy.getContact());
                    subscriber.setHostAddress(subscribedBy.getHostAddress());
                    subscriber.setHostPort(subscribedBy.getHostPort());
                    subscriber.setRequest(subscribedBy.getRequest());
                    subscriber.setExpirationTime(subscribedBy.getExpirationTime());
                    subscriber.setExpirationDateTime(subscribedBy.getExpirationDateTime());
                    break;
                }
                catch (Exception e) {
                    logger.error("Attempting lock in updateSubscription  method Error while updating subscription from : {} : for User {} :  Fetching", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
                    break;
                }
                finally {
                    subscriber.getLock().unlock();
                }
            }
            if (Boolean.FALSE.equals(found)) {
                if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedByUser)) {
                    logger.info("In updateSubscription method request from : {} : For User {} :  Dialog not found adding new dialog", (Object)subscribedBy.getSubscriber(), (Object)subscribedUser);
                }
                subscribedBy.setSubscribedTo(subscribedUser);
                subscriberList.add(subscribedBy);
            }
        }
        catch (Exception e) {
            logger.error("Error in updateSubscription method while updating subscription from : {} : for User {} :  Fetching", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeSubscription(String subscribedUser, String subscribedBy) {
        try {
            List users;
            if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy)) {
                logger.info("In removeSubscription method request from : {} : for User {} :  Fetching", (Object)subscribedUser, (Object)subscribedBy);
            }
            if ((users = (List)this.subscriptions.get(subscribedUser)) == null) return;
            for (SubscriberUser subscriber : users) {
                if (!subscriber.getSubscriber().equals(subscribedBy)) continue;
                if (!subscriber.getLock().tryLock(2L, TimeUnit.SECONDS)) return;
                try {
                    if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy)) {
                        logger.info("In removeSubscription method request from : {} : for User {} :  Removing dialog", (Object)subscribedUser, (Object)subscribedBy);
                    }
                    subscriber.setActive(false);
                    return;
                }
                catch (Exception e) {
                    logger.error("Error in removeSubscription method while removing subscription from : {} : for User {} :  Fetching", (Object)subscribedUser, (Object)subscribedBy);
                    return;
                }
                finally {
                    subscriber.setActive(false);
                    subscriber.getLock().unlock();
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in removeSubscription method while removing subscription from : {} : for User {} :  Fetching", (Object)subscribedUser, (Object)subscribedBy);
        }
    }

    public List<SubscriberUser> getUserSubscription(String subscribeUser) {
        List users = null;
        try {
            users = (List)this.subscriptions.get(subscribeUser);
        }
        catch (Exception e) {
            logger.error("Error in getUserSubscription method {} \n:{}", (Object)subscribeUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return users;
    }

    public List<SubscriberUserModel> getUserSubscriptionList(String subscribeUser) {
        ArrayList<SubscriberUserModel> users = new ArrayList<SubscriberUserModel>();
        try {
            ((List)this.subscriptions.get(subscribeUser)).forEach(row -> users.add(new SubscriberUserModel(row.getSubscriber(), row.getEpoch(), row.getExpires(), row.getSubscriptionHost(), row.getContact(), row.isActive(), row.getSubscribedTo(), Boolean.valueOf(row.getInWIP().get()), Long.valueOf(row.getCurrentSequence().get()), (String)row.getLastEvent().get(), (String)row.getCurrentcallId().get(), (String)row.getCallState().get(), (String)row.getNextCallId().get(), (String)row.getNextCallState().get())));
        }
        catch (Exception e) {
            logger.error("Error in getUserSubscription method {} :\n{}", (Object)subscribeUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSubscription(String eventType, String subscribedUser, String toUser, String activeCallID, String callState, long packetSequence) {
        List subscription = null;
        if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(toUser)) {
            logger.info("In checkSubscription method received -> eventType : {}, subscribedUser : {} , toUser : {}, activeCallID : {}, callState : {}, packetSequence : {}", (Object)eventType, (Object)subscribedUser, (Object)toUser, (Object)activeCallID, (Object)callState, (Object)packetSequence);
        }
        try {
            subscription = this.getUserSubscription(subscribedUser);
            if (subscription == null || subscription.isEmpty()) {
                if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(toUser)) {
                    logger.info("In checkSubscription method No Subscription active/inactive found :  subscriptionUser : {}, activeCallID : {}, callState : {}", (Object)subscribedUser, (Object)activeCallID, (Object)callState);
                }
                return;
            }
            for (SubscriberUser subscribedBy : subscription) {
                if (subscribedBy.isActive() && Instant.now().getEpochSecond() < subscribedBy.getExpires()) {
                    if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                        logger.info("In checkSubscription method subscribedBy user is active. Processing notification for subscribedUser: {} to SubscribeByUser: {}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
                    }
                    if (!subscribedBy.getLock().tryLock(2L, TimeUnit.SECONDS)) continue;
                    try {
                        if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                            logger.info("In checkSubscription method Lock acquired processing notification for subscriptionUser: {} to SubscribeUser: {}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
                        }
                        this.updateStatusAndSendNotification(subscribedBy, eventType, subscribedUser, toUser, activeCallID, callState, packetSequence);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Error in checkSubscription method While processing notification for subscriptionUser: {} to SubscribeUser: {}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
                        continue;
                    }
                    finally {
                        subscribedBy.getLock().unlock();
                        continue;
                    }
                }
                if (!this.helperIMS.isValidLogUser(subscribedUser) && !this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) continue;
                logger.info("In checkSubscription method subscribedUser : {} is inactive. Not sending Notify for subscriptionUser: {} to SubscribedUser: {}", (Object)subscribedBy.getSubscriber(), (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
            }
        }
        catch (Exception e) {
            logger.error("Error in checkSubscription method {} :\n{}", (Object)subscribedUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public void updateStatusAndSendNotification(SubscriberUser subscribedBy, String eventType, String subscribedUser, String toUser, String activeCallID, String callState, long packetSequence) {
        if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
            logger.info("updateStatusAndSendNotification Processing : subscribedBy : {}, eventType : {} , subscribedUser : {}, toUser : {} , activeCallID : {}, callState : {}, packetSequence : {}", (Object)subscribedBy.getSubscriber(), (Object)eventType, (Object)subscribedUser, (Object)toUser, (Object)activeCallID, (Object)callState, (Object)packetSequence);
        }
        if (eventType.equals("request")) {
            if (!subscribedBy.getInWIP().get()) {
                subscribedBy.getLastEvent().getAndSet(eventType);
                subscribedBy.getInWIP().set(true);
                this.sendNotification(subscribedUser, subscribedBy, activeCallID, callState, eventType);
            } else {
                subscribedBy.getNextCallId().set(activeCallID);
                subscribedBy.getNextCallState().set(callState);
            }
        } else if (eventType.equals("re-request") && subscribedBy.getSubscriber().equals(toUser)) {
            this.sendNotification(subscribedUser, subscribedBy, (String)subscribedBy.getCurrentcallId().get(), (String)subscribedBy.getCallState().get(), eventType);
        } else if ((eventType.equals("delivered") || eventType.equals("timeout") || eventType.equals("error")) && subscribedBy.getSubscriber().equals(toUser)) {
            if (packetSequence >= subscribedBy.getCurrentSequence().get()) {
                subscribedBy.getCurrentcallId().set("");
                subscribedBy.getCallState().set("");
                if (StringUtils.hasText((String)((String)subscribedBy.getNextCallState().get()))) {
                    subscribedBy.getLastEvent().getAndSet("request");
                    subscribedBy.getInWIP().set(true);
                    this.sendNotification(subscribedUser, subscribedBy, (String)subscribedBy.getNextCallId().get(), (String)subscribedBy.getNextCallState().get(), eventType);
                    subscribedBy.getNextCallId().set("");
                    subscribedBy.getNextCallState().set("");
                } else {
                    subscribedBy.getLastEvent().getAndSet("");
                    subscribedBy.getInWIP().set(false);
                }
            } else if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                logger.info("Sequence Out of packet Event : {} Subscribed User : {} To User : {} Active Call Id : {} Calls : {} Packet Sequence : {}", (Object)eventType, (Object)subscribedUser, (Object)toUser, (Object)activeCallID, (Object)callState, (Object)packetSequence);
            }
        }
    }

    public void sendNotification(String subscribedUser, SubscriberUser subscribedBy, String activeCallID, String callState, String eventType) {
        try {
            if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                logger.info("In sendNotification method  Processing : subscribedUser : {}, subscribedBy : {} , activeCallID : {}, callState : {} , eventType : {} ", (Object)subscribedUser, (Object)subscribedBy.getSubscriber(), (Object)activeCallID, (Object)callState, (Object)eventType);
            }
            if (eventType.equals("re-request") && (activeCallID == null || callState == null)) {
                return;
            }
            subscribedBy.getInWIP().set(true);
            int expireTimeOut = (int)(subscribedBy.getExpires() - Instant.now().getEpochSecond());
            ExpiresHeader expires = this.helperIMS.getHeaderFactory().createExpiresHeader(expireTimeOut > 0 ? expireTimeOut : 0);
            if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                logger.info("In sendNotification method creating Notify of Subscriber {} : SubscriptionHost {} : contact {}", (Object)subscribedBy.getSubscriber(), (Object)subscribedBy.getSubscriptionHost(), (Object)subscribedBy.getContact());
            }
            Dialog dialog = subscribedBy.getSubscribeDialog();
            dialog.incrementLocalSequenceNumber();
            Request notifyRequest = dialog.createRequest("NOTIFY");
            notifyRequest = this.helperIMS.removeRouteHeaders(notifyRequest, "sendNotification");
            SipURI contactUri = (SipURI)this.helperIMS.getAddressFactory().createURI(subscribedBy.getContact());
            notifyRequest.setRequestURI((URI)contactUri);
            SipURI contactSipURI = this.helperIMS.getAddressFactory().createSipURI(subscribedUser, Constants.FORWARDING_IP_ADDRESS);
            contactSipURI.setPort(Constants.FORWARDING_PORT.intValue());
            contactSipURI.setTransportParam("UDP");
            Address contactAddress = this.helperIMS.getAddressFactory().createAddress((URI)contactSipURI);
            ContactHeader contactHeader = this.helperIMS.getHeaderFactory().createContactHeader(contactAddress);
            notifyRequest.setHeader((Header)contactHeader);
            if (StringUtils.hasLength((String)Constants.FORWARDING_IP_ADDRESS) && Constants.FORWARDING_IP_ADDRESS_WITH_PORT.equals(subscribedBy.getSubscriptionHost())) {
                SipURI proxyUri = this.helperIMS.getAddressFactory().createSipURI(null, Constants.FORWARDING_IP_ADDRESS);
                proxyUri.setPort(Constants.FORWARDING_PORT.intValue());
                proxyUri.setLrParam();
                proxyUri.setTransportParam("UDP");
                RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(this.helperIMS.getAddressFactory().createAddress((URI)proxyUri));
                notifyRequest.addFirst((Header)routeHeader);
            }
            this.helperIMS.setUserAgentHeaderRequest(notifyRequest, "sendNotification");
            SubscriptionStateHeader subscriptionState = null;
            if (expires.getExpires() > 0) {
                subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("active");
                subscriptionState.setExpires(expires.getExpires());
            } else {
                subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("terminated");
                subscriptionState.setReasonCode("timeout");
                this.removeSubscription(subscribedUser, subscribedBy.getSubscriber());
            }
            notifyRequest.addHeader((Header)subscriptionState);
            String notifyContentStr = "<?xml version=\"1.0\"?>\r\n<dialog-info xmlns=\"urn:ietf:params:xml:ns:dialog-info\" version=\"1\" state=\"full\" entity=\"sip:#subscriberUser@#subscriberIP\">\r\n<dialog id=\"#activeCallID\" direction=\"recipient\">\r\n<state>#callState</state>\r\n</dialog>\r\n</dialog-info>";
            notifyContentStr = notifyContentStr.replace("#activeCallID", activeCallID).replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.FORWARDING_IP_ADDRESS).replace("#callState", callState);
            byte[] contentBytes = notifyContentStr.getBytes();
            ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "dialog-info+xml");
            notifyRequest.setContent((Object)contentBytes, contentTypeHeader);
            CSeqHeader cseqHeader = (CSeqHeader)notifyRequest.getHeader("CSeq");
            subscribedBy.getCurrentcallId().getAndSet(activeCallID);
            subscribedBy.getCallState().getAndSet(callState);
            subscribedBy.getCurrentSequence().set(cseqHeader.getSeqNumber());
            if (this.helperIMS.isValidLogUser(subscribedUser) || this.helperIMS.isValidLogUser(subscribedBy.getSubscriber())) {
                logger.info("In sendNotification method Notify Sent for subscriptionUser: {} to SubscribeUser: {} : Sequence {} NotifyPacket: \r\n{} ", (Object)subscribedUser, (Object)subscribedBy.getSubscriber(), (Object)cseqHeader.getSeqNumber(), (Object)notifyRequest);
            }
            ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(notifyRequest);
            dialog.sendRequest(ct);
        }
        catch (Exception e) {
            logger.error("Error in sendNotification method while sending Notify for {} : to : {} \n{}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber(), (Object)e);
        }
    }
}

