/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableIMSV2_SBC;
import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ResponseEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentLengthHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.RecordRouteHeader;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.header.SubscriptionStateHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.UserAgentHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.RequestEventExt;
import com.coraltele.javax.sip.ResponseEventExt;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.header.AlertInfo;
import com.coraltele.javax.sip.header.HeaderFactoryImpl;
import com.coraltele.javax.sip.header.ims.PathHeader;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.message.SIPResponse;
import com.coraltele.javax.sip.stack.SIPClientTransaction;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPTransaction;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Conditional(value={EnableIMSV2_SBC.class})
public class SbcIMS {
    @Autowired
    HelperIMS helperIMS;
    private static final Logger logger = LogManager.getLogger(SbcIMS.class);
    private static String transport = "udp";
    private static String SIPREGISTRAR_IP_WITH_PORT = Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT;
    private static String RLUREGISTRAR_IP_WITH_PORT = Constants.SIPREGISTRAR_IP + ":" + Constants.RLUREGISTRAR_PORT;
    BlockingQueue<Runnable> sbcIMSQueue = null;
    ThreadPoolExecutor sbcIMSExecutor = null;
    private CopyOnWriteArrayList<String> rluVirtualIPList = null;
    private Lock headerValueLock = new ReentrantLock();
    private Lock userAgentLock = new ReentrantLock();

    public SbcIMS() {
        this.sbcIMSQueue = new LinkedBlockingQueue();
        this.sbcIMSExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.sbcIMSQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void setRluVirtualIPList(ArrayList<String> rluVirtualIPList) {
        try {
            this.rluVirtualIPList = new CopyOnWriteArrayList<String>(rluVirtualIPList);
        }
        catch (Exception e) {
            logger.info("Error in loading setRluVirtualIPList {}", (Object)e.getLocalizedMessage());
        }
    }

    public void SbcIMSRequest(RequestEvent requestEvent) {
        try {
            this.sbcIMSExecutor.submit(() -> this.handleSbcIMSRequest(requestEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling SbcIMSRequest {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void SbcIMSResponse(ResponseEvent responseEvent) {
        try {
            this.sbcIMSExecutor.submit(() -> this.handleSbcIMSResponse(responseEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling SbcIMSResponse {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void handleSbcIMSRequest(RequestEvent requestEvent) {
        boolean fromRegistrar = false;
        Request request = requestEvent.getRequest();
        String proxyRequest = ((RequestEventExt)requestEvent).getRemoteIpAddress() + ":" + ((RequestEventExt)requestEvent).getRemotePort();
        logger.info("handleSbcIMSRequest Received: {} fromIP:port : {}  Request:\r\n{}", (Object)request.getMethod(), (Object)proxyRequest, (Object)request);
        request = this.handleUserAgentRequest(request, request.getMethod());
        if (proxyRequest.equals(SIPREGISTRAR_IP_WITH_PORT) || proxyRequest.equals(RLUREGISTRAR_IP_WITH_PORT)) {
            fromRegistrar = true;
        }
        try {
            switch (request.getMethod()) {
                case "REGISTER": {
                    this.handleRegisterRequest(requestEvent);
                    break;
                }
                case "INVITE": {
                    this.handleInviteRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "BYE": {
                    this.handleByeRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "ACK": {
                    this.handleAckRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "CANCEL": {
                    this.handleCancelRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    this.handleSubscribeRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "REFER": {
                    this.handleReferRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "INFO": {
                    this.handleInfoRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "OPTIONS": {
                    this.handleOptionRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "MESSAGE": {
                    break;
                }
                case "UPDATE": {
                    break;
                }
                case "PRACK": {
                    break;
                }
                default: {
                    logger.error("Unhandled handleSbcIMSRequest {}", (Object)request.getMethod());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleSbcIMSRequest Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void setUserAgentHeaderRequest(Request request, String calleeMethod) {
        try {
            UserAgentHeader userAgentHeader = null;
            if (!Constants.USER_AGENT.isEmpty()) {
                ArrayList<String> productList = new ArrayList<String>();
                productList.add(Constants.USER_AGENT);
                userAgentHeader = this.helperIMS.getHeaderFactory().createUserAgentHeader(productList);
                request.setHeader((Header)userAgentHeader);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in setUserAgentHeaderRequest Method: {} Error: {}", (Object)calleeMethod, (Object)request.getMethod(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request handleUserAgentRequest(Request request, String calleeMethod) {
        boolean lockAcquired = false;
        try {
            if (this.userAgentLock.tryLock(2L, TimeUnit.SECONDS)) {
                lockAcquired = true;
                logger.debug("from {} Acquired userAgentLock lock in handleUserAgentRequest", (Object)calleeMethod);
                this.setUserAgentHeaderRequest(request, calleeMethod);
            } else {
                logger.warn("from {} Failed to acquire userAgentLock lock within 2 seconds in handleUserAgentRequest Method", (Object)calleeMethod);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in handleUserAgentRequest Method: {}", (Object)calleeMethod, (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lockAcquired) {
                this.userAgentLock.unlock();
                logger.debug("from {} Released userAgentLock lock in setUserAgentHeaderRequest Method", (Object)calleeMethod);
            }
        }
        return request;
    }

    private void handleOptionRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                logger.info("handleOptionRequest get serverTransaction null for callid: {}", (Object)callID);
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            response = this.handleUserAgentResponse(response, request.getMethod());
            serverTransaction.sendResponse(response);
            logger.info("handleOptionRequest callID: {} Send response \r\n{}", (Object)callID, (Object)response);
        }
        catch (Exception e) {
            logger.error("handleOptionRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInfoRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                logger.info("handleInfoRequest get serverTransaction null for callid: {}", (Object)callID);
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            Request forwardInfo = null;
            forwardInfo = (Request)request.clone();
            RouteHeader routeHeader = (RouteHeader)forwardInfo.getHeader("Route");
            SipURI routeURI = (SipURI)routeHeader.getAddress().getURI();
            if (routeURI.getHost().equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS) && routeURI.getParameter("ttag") != null) {
                Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
                serverTransaction.sendResponse(response);
                ToHeader toHeader = (ToHeader)forwardInfo.getHeader("To");
                toHeader.setTag(routeURI.getParameter("ttag"));
                forwardInfo.removeFirst("Via");
            }
            forwardInfo.removeFirst("Route");
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            forwardInfo.addFirst((Header)viaHeader);
            ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(forwardInfo);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            logger.info("handleInfoRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)forwardInfo.getMethod(), (Object)forwardInfo);
        }
        catch (Exception ex) {
            logger.error("Error in handleInfoRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleRegisterRequest(RequestEvent requestEvent) {
        try {
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            if (StringUtils.hasLength((String)Constants.SIPREGISTRAR_IP) && Constants.SIPREGISTRAR_PORT > 0) {
                Request request = requestEvent.getRequest();
                CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
                String callID = callIDHeader.getCallId();
                ServerTransaction serverTransaction = requestEvent.getServerTransaction();
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
                ToHeader toHeader = (ToHeader)request.getHeader("To");
                String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
                ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
                String contactUser = ((SipURI)contactHeader.getAddress().getURI()).getUser();
                int port = Constants.SIPREGISTRAR_PORT;
                if (Boolean.TRUE.equals(Constants.RLUREGISTRATION_SYNC) && !this.helperIMS.getVirtualIP(toUser).equals(Constants.SIPREGISTRAR_IP)) {
                    port = Constants.RLUREGISTRAR_PORT;
                }
                if (contactUser == null) {
                    Address contactAddress = contactHeader.getAddress();
                    SipURI contactSipURI = (SipURI)contactAddress.getURI();
                    contactSipURI.setUser(fromUser);
                    contactAddress.setURI((URI)contactSipURI);
                    contactHeader.setAddress(contactAddress);
                    request.setHeader((Header)contactHeader);
                }
                if (serverTransaction == null) {
                    logger.info("handleRegisterRequest get serverTransaction null for callid: {}", (Object)callID);
                    serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
                }
                Request forwardRequest = (Request)request.clone();
                SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)toHeader.getAddress().getURI()).getUser(), Constants.SIPREGISTRAR_IP);
                requestURI.setPort(port);
                forwardRequest.setRequestURI((URI)requestURI);
                SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)fromHeader.getAddress().getURI()).getUser(), Constants.SIPREGISTRAR_IP);
                forwardURI.setPort(port);
                forwardURI.setTransportParam(transport);
                forwardURI.setLrParam();
                Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
                forwardRequest.addFirst((Header)routeHeader);
                ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
                forwardRequest.addFirst((Header)viaHeader);
                SipURI pathURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                pathURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                pathURI.setLrParam();
                Address pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
                PathHeader newPathHeader = headerFactoryImpl.createPathHeader(pathAddress);
                forwardRequest.addFirst((Header)newPathHeader);
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(forwardRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
                logger.info("handleRegisterRequest for User : {} Sent to {}:{} ForwardRequest: \r\n{}", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)Constants.SIPREGISTRAR_IP, (Object)port, (Object)forwardRequest);
                if (Boolean.TRUE.equals(Constants.RLUREGISTRATION_SYNC) && this.rluVirtualIPList != null && !this.rluVirtualIPList.isEmpty() && this.helperIMS.getVirtualIP(toUser).equals(Constants.SIPREGISTRAR_IP)) {
                    for (String rluVirtualIP : this.rluVirtualIPList) {
                        if (rluVirtualIP == null || rluVirtualIP.equals(Constants.SIPREGISTRAR_IP)) continue;
                        logger.info("handleRegisterRequest initiate ForkRequest for toUser : {} Sent to {} ForwardRequest: \r\n{}", (Object)((SipURI)toHeader.getAddress().getURI()).getUser(), (Object)rluVirtualIP, (Object)request);
                        this.forkRegisterRequest(requestEvent, rluVirtualIP);
                    }
                }
            } else {
                logger.error("Discard handleRegisterRequest for Not founding SIPREGISTRAR_IP and SIPREGISTRAR_PORT");
            }
        }
        catch (Exception e) {
            logger.error("handleRegisterRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void forkRegisterRequest(RequestEvent requestEvent, String rluIP) {
        try {
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            if (StringUtils.hasLength((String)Constants.SIPREGISTRAR_IP) && Constants.SIPREGISTRAR_PORT > 0) {
                Request request = requestEvent.getRequest();
                ServerTransaction serverTransaction = requestEvent.getServerTransaction();
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                ToHeader toHeader = (ToHeader)request.getHeader("To");
                Request forwardRequest = (Request)request.clone();
                forwardRequest.removeFirst("Authorization");
                SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)toHeader.getAddress().getURI()).getUser(), rluIP);
                requestURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                forwardRequest.setRequestURI((URI)requestURI);
                SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)fromHeader.getAddress().getURI()).getUser(), rluIP);
                forwardURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                forwardURI.setTransportParam(transport);
                forwardURI.setLrParam();
                Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
                forwardRequest.addFirst((Header)routeHeader);
                ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
                forwardRequest.addFirst((Header)viaHeader);
                SipURI pathURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                pathURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                pathURI.setLrParam();
                Address pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
                PathHeader pathHeader = headerFactoryImpl.createPathHeader(pathAddress);
                forwardRequest.addFirst((Header)pathHeader);
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(forwardRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
                logger.info("handleRegisterRequest complete forkRegisterRequest for User : {} Sent to {}:{} ForwardRequest: \r\n{}", (Object)((SipURI)fromHeader.getAddress().getURI()).getUser(), (Object)rluIP, (Object)Constants.LISTEN_UDP_PORT, (Object)forwardRequest);
            } else {
                logger.error("Discard forkRegisterRequest for Not founding SIPREGISTRAR_IP and SIPREGISTRAR_PORT");
            }
        }
        catch (Exception e) {
            logger.error("forkRegisterRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        if (!StringUtils.hasLength((String)Constants.SIPREGISTRAR_IP) || Constants.SIPREGISTRAR_PORT <= 0) {
            logger.error("Discard handleInviteRequest for Not founding SIPREGISTRAR_IP and SIPREGISTRAR_PORT");
        } else {
            try {
                Request request = requestEvent.getRequest();
                ToHeader toHeader = (ToHeader)request.getHeader("To");
                CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
                String callID = callIDHeader.getCallId();
                AlertInfo alertInfo = (AlertInfo)request.getHeader("Alert-Info");
                RecordRouteHeader recordRouteHeader = (RecordRouteHeader)request.getHeader("Record-Route");
                ServerTransaction serverTransaction = requestEvent.getServerTransaction();
                if (serverTransaction == null) {
                    logger.info("handleInviteRequest get serverTransaction null for callid: {}", (Object)callID);
                    serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
                }
                SIPDialog serverDialog = (SIPDialog)serverTransaction.getDialog();
                Response response = this.helperIMS.getMessageFactory().createResponse(100, request);
                response = this.handleUserAgentResponse(response, request.getMethod());
                serverTransaction.sendResponse(response);
                Request forwardRequest = null;
                forwardRequest = (Request)request.clone();
                forwardRequest.removeFirst("Route");
                if (fromRegistrar && alertInfo == null) {
                    alertInfo = new AlertInfo();
                    String alertInfoValue = this.getUnrecognizedHeaderValue(request, "Alert-Info", "handleInviteRequest");
                    alertInfoValue = alertInfoValue.replaceAll("^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$", "");
                    alertInfo.setAlertInfo(alertInfoValue);
                    forwardRequest.addHeader((Header)alertInfo);
                }
                SipURI requestURI = (SipURI)forwardRequest.getRequestURI();
                if (!fromRegistrar && requestEvent.getDialog() == null) {
                    requestURI.setHost(Constants.SIPREGISTRAR_IP);
                    requestURI.setPort(Constants.SIPREGISTRAR_PORT.intValue());
                    forwardRequest.setRequestURI((URI)requestURI);
                }
                if (requestEvent.getDialog() == null) {
                    if (recordRouteHeader == null) {
                        SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                        forwardURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                        forwardURI.setLrParam();
                        Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                        recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
                        forwardRequest.addFirst((Header)recordRouteHeader);
                    } else {
                        String host = ((SipURI)recordRouteHeader.getAddress().getURI()).getHost();
                        int port = ((SipURI)recordRouteHeader.getAddress().getURI()).getPort();
                        if (!host.equals(Constants.LISTEN_IP_ADDRESS) && port != Constants.LISTEN_UDP_PORT) {
                            SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                            forwardURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                            forwardURI.setLrParam();
                            Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                            recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
                            forwardRequest.addFirst((Header)recordRouteHeader);
                        }
                    }
                }
                ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
                forwardRequest.addFirst((Header)viaHeader);
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(forwardRequest);
                ct.setApplicationData((Object)serverTransaction);
                serverTransaction.setApplicationData((Object)ct);
                serverDialog.setApplicationData((Object)ct.getDialog());
                SIPDialog clientDialog = (SIPDialog)ct.getDialog();
                clientDialog.setApplicationData((Object)serverDialog);
                ct.sendRequest();
                clientDialog.disableSequenceNumberValidation();
                serverDialog.disableSequenceNumberValidation();
                logger.info("handleInviteRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)forwardRequest.getMethod(), (Object)forwardRequest);
            }
            catch (Exception ex) {
                logger.error("Error in handleInviteRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUnrecognizedHeaderValue(Request request, String headerName, String callingMethod) {
        String headerValue = "alert-internal";
        try {
            if (!this.headerValueLock.tryLock(2L, TimeUnit.SECONDS)) {
                logger.warn(" from {} Failed to acquire headerValueLock lock within 2 seconds in getUnrecognizedHeaderValue Method", (Object)callingMethod);
                return headerValue;
            }
            logger.debug(" from {} Acquired headerValueLock lock in getUnrecognizedHeaderValue", (Object)callingMethod);
            try {
                String header;
                if (request == null) return headerValue;
                if (headerName == null) return headerValue;
                if (headerName.isEmpty()) return headerValue;
                ListIterator unrecognizedHeaderList = request.getUnrecognizedHeaders();
                do {
                    if (!unrecognizedHeaderList.hasNext()) return headerValue;
                } while ((header = (String)unrecognizedHeaderList.next()) == null || header.isEmpty() || !header.contains(headerName));
                String string = headerValue = header.split(":", -1)[1].trim();
                return string;
            }
            catch (Exception ex) {
                logger.error("from {} Error in getUnrecognizedHeaderValue  Method: {} headerName: {} Error: {}", (Object)callingMethod, (Object)request.getMethod(), (Object)headerName, (Object)ex.getMessage());
                return headerValue;
            }
            finally {
                this.headerValueLock.unlock();
                logger.debug(" from {} Released headerValueLock lock in getUnrecognizedHeaderValue Method", (Object)callingMethod);
            }
        }
        catch (Exception e) {
            logger.error(" from {} Interrupted while trying to acquire headerValueLock lock in getUnrecognizedHeaderValue Method: {}", (Object)callingMethod, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return headerValue;
    }

    private boolean isHoldRequest(RequestEvent requestEvent) {
        String sdpContent;
        byte[] content;
        int contentLength;
        Request request = requestEvent.getRequest();
        ContentLengthHeader contentLengthHeader = (ContentLengthHeader)request.getHeader("Content-Length");
        return contentLengthHeader != null && (contentLength = contentLengthHeader.getContentLength()) > 0 && (content = request.getRawContent()) != null && ((sdpContent = new String(content)).contains("a=inactive") || sdpContent.contains("a=sendonly"));
    }

    private void handleByeRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            SIPDialog byeDialog = (SIPDialog)requestEvent.getDialog();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request byeRequest = (Request)request.clone();
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            byeRequest.addFirst((Header)viaHeader);
            byeRequest.removeFirst("Route");
            String xV2Dialog = Optional.ofNullable((ExtensionHeader)request.getHeader("X-V2Dialog")).map(ExtensionHeader::getValue).orElse(null);
            if (xV2Dialog != null) {
                Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
                serverTransaction.sendResponse(response);
                byeRequest.removeHeader("Via");
                ViaHeader viaHeader2 = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
                byeRequest.addFirst((Header)viaHeader2);
                String[] dialogParts = xV2Dialog.split(":");
                if (dialogParts.length == 3) {
                    String fromTag = dialogParts[2];
                    FromHeader fromHeader = (FromHeader)byeRequest.getHeader("From");
                    fromHeader.setTag(fromTag);
                    ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(byeRequest);
                    ((ServerTransaction)byeDialog.getLastTransaction().getApplicationData()).getDialog().sendRequest(ct);
                    logger.info("handleByeRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)byeRequest.getMethod(), (Object)byeRequest);
                    return;
                }
            }
            if (serverTransaction != null) {
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(byeRequest);
                ct.setApplicationData((Object)serverTransaction);
                SIPDialog clientDialog = ct.getDialog() != null ? (SIPDialog)ct.getDialog() : ((SIPClientTransaction)ct).getDefaultDialog();
                clientDialog.sendRequest(ct);
            } else {
                this.helperIMS.getSipProvider().sendRequest(byeRequest);
            }
            logger.info("handleByeRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)byeRequest.getMethod(), (Object)byeRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleByeRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleAckRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request ackRequest = (Request)request.clone();
            ackRequest.removeFirst("Route");
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            ackRequest.addFirst((Header)viaHeader);
            if (!fromRegistrar) {
                SIPDialog clientDialog;
                if (requestEvent.getDialog() != null && requestEvent.getDialog().getApplicationData() != null && (clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData()).getLastTransaction() != null && clientDialog.getLastTransaction().getApplicationData() != null) {
                    SIPTransaction lastServerTransaction = (SIPTransaction)clientDialog.getLastTransaction().getApplicationData();
                    if (lastServerTransaction instanceof SIPServerTransaction && serverTransaction != null) {
                        ((SIPDialog)lastServerTransaction.getDialog()).handleAck((SIPServerTransaction)serverTransaction);
                    } else {
                        SIPRequest ackSipRequest = (SIPRequest)request;
                        SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
                        SIPServerTransaction ackServerTransaction = sipStackImpl.findPendingTransaction(ackSipRequest.getTransactionId());
                        if (lastServerTransaction instanceof SIPServerTransaction && ackServerTransaction != null) {
                            ((SIPDialog)lastServerTransaction.getDialog()).handleAck(ackServerTransaction);
                        }
                        logger.info("handleAckRequest callID: {} Send request Send \r\n{}", (Object)callID, (Object)ackRequest);
                    }
                }
                this.helperIMS.getSipProvider().sendRequest(ackRequest);
            } else {
                SIPDialog clientDialog = (SIPDialog)requestEvent.getDialog();
                if (clientDialog.getLastTransaction() != null && clientDialog.getLastTransaction().getApplicationData() != null) {
                    SIPTransaction clientTransactionDialog = (SIPTransaction)clientDialog.getLastTransaction().getApplicationData();
                    clientTransactionDialog.getDialog().sendAck(ackRequest);
                }
            }
            logger.info("handleAckRequest callID: {} Send request Send \r\n{}", (Object)callID, (Object)ackRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleAckRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleCancelRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            SIPDialog serverDialog = (SIPDialog)requestEvent.getDialog();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                logger.info("handleCancelRequest get serverTransaction null for callid: {}", (Object)callID);
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            response = this.handleUserAgentResponse(response, request.getMethod());
            if (serverDialog != null && serverDialog.getLocalTag() != null) {
                toHeader.setTag(serverDialog.getLocalTag());
                response.setHeader((Header)toHeader);
            }
            serverTransaction.sendResponse(response);
            Request cancelRequest = (Request)request.clone();
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            cancelRequest.addFirst((Header)viaHeader);
            if (!fromRegistrar) {
                SipURI requestURI = (SipURI)cancelRequest.getRequestURI();
                requestURI.setHost(Constants.SIPREGISTRAR_IP);
                requestURI.setPort(Constants.SIPREGISTRAR_PORT.intValue());
                cancelRequest.setRequestURI((URI)requestURI);
                SIPDialog clientDialog = (SIPDialog)serverDialog.getApplicationData();
                String cancelRequestViaBranch = clientDialog.getLastTransaction().getBranchId();
                viaHeader.setBranch(cancelRequestViaBranch);
            } else {
                cancelRequest.removeHeader("Route");
                String cancelRequestViaBranch = ((ClientTransaction)serverDialog.getLastTransaction().getApplicationData()).getBranchId();
                viaHeader.setBranch(cancelRequestViaBranch);
            }
            ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(cancelRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            logger.info("handleCancelRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)cancelRequest.getMethod(), (Object)cancelRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleCancelRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleReferRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            if (serverTransaction == null) {
                logger.info("handleReferRequest get serverTransaction null for callid: {}", (Object)request.getHeader("Call-ID"));
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            Request referRequest = (Request)request.clone();
            referRequest.removeFirst("Route");
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            referRequest.addFirst((Header)viaHeader);
            ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(referRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            logger.info("handleReferRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)referRequest.getMethod(), (Object)referRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleReferRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            if (eventHeader != null && eventHeader.getEventType().equals("refer")) {
                this.handleReferNotifyRequest(requestEvent, fromRegistrar);
            } else if (eventHeader != null && eventHeader.getEventType().equals("message-summary")) {
                this.handleRegisterNotifyRequest(requestEvent, fromRegistrar);
            } else {
                this.handleStateLessSubscribeNotifyRequest(requestEvent, fromRegistrar);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleRegisterNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            if (!fromRegistrar) {
                Request request = requestEvent.getRequest();
                Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
                response = this.handleUserAgentResponse(response, request.getMethod());
                this.helperIMS.getSipProvider().sendResponse(response);
            } else {
                Request request = requestEvent.getRequest();
                ServerTransaction serverTransaction = requestEvent.getServerTransaction();
                CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
                String callID = callIDHeader.getCallId();
                Request registerNotifyRequest = null;
                registerNotifyRequest = (Request)request.clone();
                registerNotifyRequest.removeFirst("Route");
                ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
                registerNotifyRequest.addFirst((Header)viaHeader);
                if (serverTransaction != null) {
                    ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(registerNotifyRequest);
                    ct.setApplicationData((Object)serverTransaction);
                    Dialog dialog = ct.getDialog();
                    dialog.sendRequest(ct);
                } else {
                    this.helperIMS.getSipProvider().sendRequest(registerNotifyRequest);
                }
                logger.info("handleRegisterNotifyRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)registerNotifyRequest.getMethod(), (Object)registerNotifyRequest);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleRegisterNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleStateLessSubscribeNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            ExpiresHeader expires = (ExpiresHeader)request.getHeader("Expires");
            SubscriptionStateHeader subscriptionState = (SubscriptionStateHeader)request.getHeader("Subscription-State");
            ServerTransaction serverTransaction = (ServerTransaction)((SIPRequest)request).getTransaction();
            Request subscribeNotifyRequest = null;
            SipURI forwardURI = null;
            subscribeNotifyRequest = (Request)request.clone();
            String virtualIP = Constants.SIPREGISTRAR_IP;
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            if (serverTransaction == null) {
                this.helperIMS.getSipProvider().sendResponse(response);
            }
            subscribeNotifyRequest.removeFirst("Route");
            if (eventHeader == null) {
                eventHeader = this.helperIMS.getHeaderFactory().createEventHeader("dialog");
                subscribeNotifyRequest.addFirst((Header)eventHeader);
            }
            if ((virtualIP = this.helperIMS.getVirtualIP(toUser)) != Constants.SIPREGISTRAR_IP && expires == null) {
                forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, virtualIP);
                forwardURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                forwardURI.setTransportParam("udp");
                forwardURI.setLrParam();
                Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
                subscribeNotifyRequest.addFirst((Header)routeHeader);
            }
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            subscribeNotifyRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(subscribeNotifyRequest);
                ct.setApplicationData((Object)serverTransaction);
                if (ct.getDialog() != null) {
                    Dialog clientDialog = ct.getDialog();
                    clientDialog.sendRequest(ct);
                } else {
                    ct.terminate();
                    serverTransaction.terminate();
                    sipProvider.sendRequest(subscribeNotifyRequest);
                }
            } else {
                sipProvider.sendRequest(subscribeNotifyRequest);
            }
            if (subscriptionState.getState().equalsIgnoreCase("terminated")) {
                String clientDialogID = ((SIPRequest)subscribeNotifyRequest).getDialogId(false);
                String serverDialogID = ((SIPRequest)subscribeNotifyRequest).getDialogId(true);
                SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
                SIPDialog clientSipDialog = sipStackImpl.getDialog(clientDialogID);
                SIPDialog serverSipDialog = sipStackImpl.getDialog(serverDialogID);
                if (clientSipDialog != null) {
                    clientSipDialog.setState(3);
                }
                if (serverSipDialog != null) {
                    serverSipDialog.setState(3);
                }
            }
            logger.info("handleStateLessSubscribeNotifyRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)subscribeNotifyRequest.getMethod(), (Object)subscribeNotifyRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleStateLessSubscribeNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleReferNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            Request referNotifyRequest = null;
            referNotifyRequest = (Request)request.clone();
            referNotifyRequest.removeFirst("Route");
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            referNotifyRequest.addFirst((Header)viaHeader);
            ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(referNotifyRequest);
            ct.setApplicationData((Object)serverTransaction);
            Dialog dialog = ct.getDialog();
            dialog.sendRequest(ct);
            logger.info("handleReferNotifyRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)referNotifyRequest.getMethod(), (Object)referNotifyRequest);
        }
        catch (Exception ex) {
            logger.error("Error in handleReferNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleSubscribeRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            String virtualIP = "";
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            RecordRouteHeader recordRouteHeader = (RecordRouteHeader)request.getHeader("Record-Route");
            ServerTransaction serverTransaction = (ServerTransaction)((SIPRequest)request).getTransaction();
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            ExpiresHeader expires = (ExpiresHeader)request.getHeader("Expires");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            if (serverTransaction == null) {
                logger.info("handleSubscribeRequest get serverTransaction null for callid: {}", (Object)request.getHeader("Call-ID"));
                serverTransaction = this.helperIMS.getSipProvider().getNewServerTransaction(request);
            }
            Request subscribeRequest = null;
            subscribeRequest = (Request)request.clone();
            subscribeRequest.removeFirst("Route");
            if (!fromRegistrar) {
                virtualIP = this.helperIMS.getVirtualIP(toUser);
                SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(toUser, virtualIP);
                if (virtualIP.equalsIgnoreCase(Constants.SIPREGISTRAR_IP)) {
                    requestURI.setPort(Constants.SIPREGISTRAR_PORT.intValue());
                } else {
                    requestURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                }
                subscribeRequest.setRequestURI((URI)requestURI);
            }
            if (toHeader.getTag() == null) {
                SipURI pathURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                pathURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
                pathURI.setLrParam();
                Address pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
                PathHeader pathHeader = headerFactoryImpl.createPathHeader(pathAddress);
                subscribeRequest.addFirst((Header)pathHeader);
            }
            SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
            forwardURI.setPort(Constants.LISTEN_UDP_PORT.intValue());
            forwardURI.setLrParam();
            Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
            recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
            subscribeRequest.addFirst((Header)recordRouteHeader);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), transport, null);
            subscribeRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(subscribeRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                this.helperIMS.getSipProvider().sendRequest(subscribeRequest);
            }
            logger.info("handleSubscribeRequest callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)subscribeRequest.getMethod(), (Object)subscribeRequest);
        }
        catch (Exception ex) {
            logger.error("Error in hanldeSubscribeRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    public void handleSbcIMSResponse(ResponseEvent responseEvent) {
        Response response = responseEvent.getResponse();
        CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
        Object newResponse = null;
        try {
            boolean fromRegistrar = false;
            String proxyRequest = ((ResponseEventExt)responseEvent).getRemoteIpAddress() + ":" + ((ResponseEventExt)responseEvent).getRemotePort();
            logger.info("handleSbcIMSResponse Received: {} fromIP:port : {}  Response:\r\n{}", (Object)cSeqHeader.getMethod(), (Object)proxyRequest, (Object)response);
            response = this.handleUserAgentResponse(response, cSeqHeader.getMethod());
            if (proxyRequest.equals(SIPREGISTRAR_IP_WITH_PORT) || proxyRequest.equals(RLUREGISTRAR_IP_WITH_PORT)) {
                fromRegistrar = true;
            }
            if (response.getStatusCode() == 100) {
                return;
            }
            switch (cSeqHeader.getMethod()) {
                case "REGISTER": {
                    this.handleRegisterResponse(responseEvent, fromRegistrar);
                    break;
                }
                case "INVITE": {
                    this.handleInviteResponse(responseEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    this.handleSubscribeResponse(responseEvent);
                    break;
                }
                case "BYE": {
                    this.handleByeResponse(responseEvent);
                    break;
                }
                case "CANCEL": {
                    this.handleCancelResponse(responseEvent);
                    break;
                }
                case "REFER": {
                    this.handleReferResponse(responseEvent);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyResponse(responseEvent);
                    break;
                }
                case "INFO": {
                    this.handleInfoResponse(responseEvent);
                    break;
                }
                default: {
                    SipProvider p = (SipProvider)responseEvent.getSource();
                    response.removeFirst("Via");
                    p.sendResponse(response);
                    logger.info("handleSbcIMSResponse default  Send Response  Code: {} cSeq: {} response:\r\n {}", (Object)response.getStatusCode(), (Object)response.getHeader("CSeq"), newResponse);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleSbcIMSResponse Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void setUserAgentHeaderResponse(Response response, String calleeMethod) {
        try {
            if (!Constants.USER_AGENT.isEmpty()) {
                ArrayList<String> productList = new ArrayList<String>();
                productList.add(Constants.USER_AGENT);
                UserAgentHeader userAgentHeader = this.helperIMS.getHeaderFactory().createUserAgentHeader(productList);
                response.setHeader((Header)userAgentHeader);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in setUserAgentHeaderResponse Method: {} Error: {}", (Object)calleeMethod, (Object)response.getStatusCode(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleUserAgentResponse(Response response, String calleeMethod) {
        boolean lockAcquired = false;
        try {
            if (this.userAgentLock.tryLock(2L, TimeUnit.SECONDS)) {
                lockAcquired = true;
                logger.debug("from {} Acquired userAgentLock lock in handleUserAgentResponse", (Object)calleeMethod);
                this.setUserAgentHeaderResponse(response, calleeMethod);
            } else {
                logger.warn("from {} Failed to acquire userAgentLock lock within 2 seconds in handleUserAgentResponse Method", (Object)calleeMethod);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in handleUserAgentResponse Method: {}", (Object)calleeMethod, (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lockAcquired) {
                this.userAgentLock.unlock();
                logger.debug("from {} Released userAgentLock lock in setUserAgentHeaderResponse Method", (Object)calleeMethod);
            }
        }
        return response;
    }

    private void handleInfoResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                if (newResponse.getHeader("Via") == null) {
                    return;
                }
                serverTransaction.sendResponse(newResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                response.removeFirst("Via");
                if (response.getHeader("Via") == null) {
                    return;
                }
                p.sendResponse(response);
            }
            logger.info("handleInfoResponse callID: {} Send  Response:\r\n{}", (Object)callID, (Object)response);
        }
        catch (Exception e) {
            logger.error("handleInfoResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleSubscribeResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            clientTransaction = responseEvent.getClientTransaction();
            Response newResponse = null;
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                serverTransaction.sendResponse(newResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                response.removeFirst("Via");
                p.sendResponse(response);
            }
            logger.info("handleSubscribeResponse callID: {} Send  Response:\r\n{}", (Object)callID, (Object)response);
        }
        catch (Exception e) {
            logger.error("handleSubscribeResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleNotifyResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                serverTransaction.sendResponse(newResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                response.removeFirst("Via");
                p.sendResponse(response);
            }
            logger.info("handleNotifyResponse callID: {} Send  Response:\r\n{}", (Object)callID, (Object)response);
        }
        catch (Exception e) {
            logger.error("handleNotifyResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteResponse(ResponseEvent responseEvent, boolean fromRegistrar) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                String responseDialogId = ((SIPResponse)response).getDialogId(false);
                String xV2DialogId = Optional.ofNullable((ExtensionHeader)response.getHeader("X-V2Dialog")).map(ExtensionHeader::getValue).orElse(null);
                if (newResponse.getStatusCode() == 200 && xV2DialogId != null && !xV2DialogId.equalsIgnoreCase(responseDialogId)) {
                    String[] dialogParts;
                    this.handleInviteAck(responseEvent, false);
                    RecordRouteHeader recordRouteLast = (RecordRouteHeader)((SIPResponse)response).getRecordRouteHeaders().getLast();
                    SipURI recordRouteUri = (SipURI)recordRouteLast.getAddress().getURI();
                    if (recordRouteUri.getHost().equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS)) {
                        recordRouteUri.setParameter("ttag", ((ToHeader)newResponse.getHeader("To")).getTag());
                        newResponse.removeLast("Record-Route");
                        newResponse.addLast((Header)recordRouteLast);
                    }
                    if ((dialogParts = xV2DialogId.split(":")).length == 3) {
                        String toTag = dialogParts[2];
                        ToHeader toHeader = (ToHeader)newResponse.getHeader("To");
                        toHeader.setTag(toTag);
                        newResponse.setHeader((Header)toHeader);
                    } else {
                        logger.info("X-V2Dialog header format is invalid - {} ", (Object)xV2DialogId);
                    }
                }
                serverTransaction.sendResponse(newResponse);
                logger.info("handleInviteResponse callID: {} Send  Response:\r\n{}", (Object)callID, (Object)newResponse);
            } else {
                logger.info("handleInviteResponse can't work stateLess cSeq: {} : callID: {}", (Object)response.getHeader("CSeq"), (Object)response.getHeader("Call-ID"));
            }
        }
        catch (Exception e) {
            logger.error("handleInviteResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteAck(ResponseEvent responseEvent, boolean fromRegistrar) {
        try {
            Request ackRequest = null;
            Response originalResponse = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)originalResponse.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            Response response = (Response)originalResponse.clone();
            ClientTransaction ct = responseEvent.getClientTransaction();
            SIPDialog dialog = (SIPDialog)ct.getDialog();
            CSeqHeader responseCSeq = (CSeqHeader)response.getHeader("CSeq");
            ackRequest = dialog.createAck(responseCSeq.getSeqNumber());
            ackRequest = this.handleUserAgentRequest(ackRequest, "handleInviteAck");
            ackRequest.removeFirst("Route");
            if (fromRegistrar) {
                ackRequest.removeHeader("Route");
            }
            dialog.sendAck(ackRequest);
            logger.info("handleInviteAck callID: {} Send request {} Send \r\n{}", (Object)callID, (Object)ackRequest.getMethod(), (Object)ackRequest);
        }
        catch (Exception e) {
            logger.error("handleInviteAck Error while :{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleByeResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                if (newResponse.getHeader("Via") == null) {
                    return;
                }
                serverTransaction.sendResponse(newResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                response.removeFirst("Via");
                if (response.getHeader("Via") == null) {
                    return;
                }
                p.sendResponse(response);
            }
            logger.info("handleByeResponse callID: {} Send  Response:\r\n{}", (Object)callID, (Object)newResponse);
        }
        catch (Exception e) {
            logger.error("handleByeResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleRegisterResponse(ResponseEvent responseEvent, boolean fromRegistrar) {
        try {
            if (!fromRegistrar) {
                return;
            }
            Response response = responseEvent.getResponse();
            FromHeader fromHeader = (FromHeader)response.getHeader("From");
            ClientTransaction ct = responseEvent.getClientTransaction();
            if (ct != null && ct.getApplicationData() != null) {
                ServerTransaction st = (ServerTransaction)ct.getApplicationData();
                Response newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                st.sendResponse(newResponse);
                logger.info("handleRegisterResponse Send  Response:\r\n{}", (Object)newResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                response.removeFirst("Via");
                p.sendResponse(response);
                logger.info("handleRegisterResponse Send  Response:\r\n{}", (Object)response);
            }
        }
        catch (Exception e) {
            logger.error("handleRegisterResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleCancelResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                serverTransaction.sendResponse(newResponse);
                logger.info("handleCancelResponse callID: {} Send  Response:\r\n{}", (Object)callIdHeader.getCallId(), (Object)newResponse);
            } else {
                logger.info("handleCancelResponse can't work stateLess cSeq: {} : callID: {}", (Object)response.getHeader("CSeq"), (Object)response.getHeader("Call-ID"));
            }
        }
        catch (Exception e) {
            logger.error("handleCancelResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleReferResponse(ResponseEvent responseEvent) {
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            Response newResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                newResponse = (Response)response.clone();
                newResponse.removeFirst("Via");
                serverTransaction.sendResponse(newResponse);
                logger.info("handleReferResponse callID: {} Send  Response:\r\n{}", (Object)callIdHeader.getCallId(), (Object)newResponse);
            } else {
                logger.info("handleReferResponse can't work stateLess cSeq: {} : callID: {}", (Object)response.getHeader("CSeq"), (Object)response.getHeader("Call-ID"));
            }
        }
        catch (Exception e) {
            logger.error("handleReferResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

