/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.ImsV2ServerIMS;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.SubscriptionStateHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.RequestEventExt;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.model.SubscriberUser;
import com.coraltele.model.SubscriberUserModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Conditional(value={EnableIMSV2_SERVER.class})
public class ImsV2Subscriptions {
    String className = "ImsV2Subscriptions";
    private static final Logger logger = LogManager.getLogger(ImsV2Subscriptions.class);
    BlockingQueue<Runnable> subscriberQueue = null;
    ThreadPoolExecutor subscriberExecutor = null;
    BlockingQueue<Runnable> notifierQueue = null;
    ThreadPoolExecutor notifierExecutor = null;
    public ConcurrentHashMap<String, List<SubscriberUser>> subscriptionsMap = new ConcurrentHashMap();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Constants.MAX_POOL_SIZE);
    @Autowired
    HelperIMS helperIMS;
    @Autowired
    ImsV2ServerIMS imsV2ServerIMS;

    public ImsV2Subscriptions() {
        this.subscriberQueue = new LinkedBlockingQueue();
        this.subscriberExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.subscriberQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.notifierQueue = new LinkedBlockingQueue();
        this.notifierExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.notifierQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public Map<String, List<SubscriberUser>> getSubscriptions() {
        return new HashMap<String, List<SubscriberUser>>(this.subscriptionsMap);
    }

    public void processRequest(RequestEvent requestEvent) {
        try {
            this.subscriberExecutor.submit(() -> this.handleV2Subscription(requestEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling subscription {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void sendNotify(String subscriptionUser, String activeCallID, String callState) {
        this.notifierExecutor.submit(() -> this.checkSubscription("request", subscriptionUser, "", activeCallID, callState, 0L));
    }

    public void updateNotify(String eventType, String subscribedUser, String subscribedByUser, long responseSequence, String callId) {
        String functionName = "updateNotify";
        this.notifierExecutor.submit(() -> {
            if (eventType.equals("request") || eventType.equals("re-request")) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedByUser, subscribedUser, "Received Params SubscribedBy: " + subscribedByUser + " SubscribedUser: " + subscribedUser + " callId: " + callId + " eventType: " + eventType + " responseSequence: " + responseSequence);
            }
            this.checkSubscription(eventType, subscribedUser, subscribedByUser, "", "", responseSequence);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleV2Subscription(RequestEvent requestEvent) {
        String functionName = "handleV2Subscription";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            Response response = null;
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
            this.helperIMS.handleContactForNAT(request, null, proxyIP, proxyPort, "request", true);
            String subscriptionHost = proxyIP + ":" + proxyPort;
            ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
            if (serverTransaction == null) {
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (expiresHeader == null) {
                expiresHeader = contactHeader.getExpires() != -1 ? this.helperIMS.getHeaderFactory().createExpiresHeader(contactHeader.getExpires()) : this.helperIMS.getHeaderFactory().createExpiresHeader(0);
                request.setExpires(expiresHeader);
            }
            boolean initial = false;
            SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
            if (requestEvent.getDialog() == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Received Fresh Subscribe Request from: " + subscriptionHost + " FromUser: " + fromUser + " ToUser: " + toUser + " callId: " + callId);
                initial = true;
                String toTag = Integer.toHexString((int)(Math.random() * 2.147483647E9));
                if (toHeader.getTag() != null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "FromUser: " + fromUser + " ToUser: " + toUser + " callId: " + callId + ". To-Tag is present but no dialog is present.");
                } else {
                    toHeader.setTag(toTag);
                }
                response = this.helperIMS.getMessageFactory().createResponse(202, request);
            } else {
                if (expiresHeader.getExpires() > 0) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Received Re-Subscribe Request from: " + subscriptionHost + " FromUser: " + fromUser + " ToUser: " + toUser + " callId: " + callId);
                } else {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Received UnSubscribe Request from: " + subscriptionHost + " FromUser: " + fromUser + " ToUser: " + toUser + " callId: " + callId);
                }
                response = this.helperIMS.getMessageFactory().createResponse(200, request);
            }
            response.addHeader((Header)expiresHeader);
            response.setHeader((Header)contactHeader);
            response.addHeader((Header)this.helperIMS.getHeaderFactory().createContentLengthHeader(0));
            serverTransaction.sendResponse(response);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "FromUser: " + fromUser + " ToUser: " + toUser + " callId: " + callId + ". Sending " + response.getStatusCode() + " Subscribe Response \n" + response);
            long currentSequence = dialog.getLocalSeqNumber();
            SubscriberUser existingSubscriberUser = this.getSubscriberUserFromMap(toUser, fromUser, callId);
            if (existingSubscriberUser.getLock().tryLock(2L, TimeUnit.SECONDS)) {
                try {
                    if (existingSubscriberUser.getCallId() == null) {
                        existingSubscriberUser.setNotifyCSeq(Long.valueOf(currentSequence));
                        logger.info("Fresh dialog cseq no {}", (Object)currentSequence);
                    } else {
                        if (!existingSubscriberUser.getCallId().equals(callId)) {
                            existingSubscriberUser.setNotifyCSeq(Long.valueOf(0L));
                            this.releaseSubscriptionsDialog(existingSubscriberUser.getSubscribeDialog());
                        }
                        if (existingSubscriberUser.getNotifyCSeq() <= currentSequence) {
                            logger.info("existing notify cseq is less  or equal so updating to new one {} < {}", (Object)existingSubscriberUser.getNotifyCSeq(), (Object)currentSequence);
                            existingSubscriberUser.setNotifyCSeq(Long.valueOf(currentSequence));
                        } else {
                            logger.info("existing notify cseq is greater so keeping existing one existing one {} > new one {}", (Object)existingSubscriberUser.getNotifyCSeq(), (Object)currentSequence);
                            dialog.setLocalSequenceNumber(existingSubscriberUser.getNotifyCSeq().longValue());
                        }
                    }
                    existingSubscriberUser.setEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    existingSubscriberUser.setExpires(Long.valueOf(existingSubscriberUser.getEpoch() + (long)expiresHeader.getExpires()));
                    existingSubscriberUser.setSubscriber(fromUser);
                    existingSubscriberUser.setSubscribedTo(toUser);
                    existingSubscriberUser.setCallId(callId);
                    existingSubscriberUser.setSubscriptionHost(subscriptionHost);
                    existingSubscriberUser.setSubscribeDialog((Dialog)dialog);
                    existingSubscriberUser.setContact(contactHeader.getAddress().getURI().toString());
                    existingSubscriberUser.setActive(true);
                    existingSubscriberUser.setTransport(viaHeaderTransport);
                    existingSubscriberUser.setHostAddress(((RequestEventExt)requestEvent).getRemoteIpAddress());
                    existingSubscriberUser.setHostPort(((RequestEventExt)requestEvent).getRemotePort());
                    existingSubscriberUser.setRequest(request.toString());
                    existingSubscriberUser.setExpirationTime(Long.valueOf((existingSubscriberUser.getEpoch() + (long)expiresHeader.getExpires()) * 1000L));
                    existingSubscriberUser.setExpirationDateTime(this.helperIMS.getISTfromEpoch(existingSubscriberUser.getExpires(), TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    logger.error("Attempting lock in {} Error while handling subscription from : {} : for User {} . \n{}", (Object)functionName, (Object)toUser, (Object)fromUser, (Object)e.getMessage());
                }
                finally {
                    existingSubscriberUser.getLock().unlock();
                }
            }
            if (initial) {
                if (eventHeader.getEventType().equalsIgnoreCase("presence")) {
                    String toUserCurrentState = this.imsV2ServerIMS.getUserCurrentStatus(toUser, "presence");
                    this.updateStatusAndSendNotification(existingSubscriberUser, "freshRequest", toUser, fromUser, " ", toUserCurrentState, existingSubscriberUser.getNotifyCSeq().longValue());
                } else {
                    String toUserCurrentState = this.imsV2ServerIMS.getUserCurrentStatus(toUser, "dialog");
                    String[] toUserCurrentStateArray = toUserCurrentState.split(":");
                    logger.info("toUsercurrent state - {} -- > {}", (Object)toUserCurrentStateArray[0], (Object)toUserCurrentStateArray[1]);
                    this.updateStatusAndSendNotification(existingSubscriberUser, "freshRequest", toUser, fromUser, toUserCurrentStateArray[1], toUserCurrentStateArray[0], existingSubscriberUser.getNotifyCSeq().longValue());
                }
            }
            if (expiresHeader.getExpires() <= 0) {
                this.removeV2Subscription(toUser, fromUser, callId);
                this.releaseSubscriptionsDialog((Dialog)dialog);
            }
        }
        catch (Exception e) {
            logger.error("In handleV2Subscription Error while handling subscription {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public SubscriberUser getSubscriberUserFromMap(String subscribedUser, String subscribedBy, String callId) {
        String functionName = "getSubscriberUserFromMap";
        List subscriberList = this.subscriptionsMap.computeIfAbsent(subscribedUser, k -> new ArrayList());
        SubscriberUser foundSubscriberUser = new SubscriberUser();
        boolean found = false;
        for (SubscriberUser subscriber : subscriberList) {
            if (!subscriber.getSubscriber().equals(subscribedBy)) continue;
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy, subscribedUser, "Found SubscribedUser: " + subscribedUser + " entry in subscriptionsMap. Fetching the SubscriberUser for params SubscribedBy: " + subscribedBy + " SubscribedUser: " + subscribedUser + " callId: " + callId);
            found = true;
            foundSubscriberUser = subscriber;
            break;
        }
        if (!found) {
            subscriberList.add(foundSubscriberUser);
        }
        return foundSubscriberUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV2Subscription(String subscribedUser, String subscribedBy, String callId) {
        String functionName = "removeV2Subscription";
        List users = (List)this.subscriptionsMap.get(subscribedUser);
        if (users == null) {
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy, subscribedUser, "Not found SubscribedUser: " + subscribedUser + " entry in subscriptionsMap. Dropping the remove Operation for params SubscribedBy: " + subscribedBy + " SubscribedUser: " + subscribedUser + " callId: " + callId);
            return;
        }
        List list = users;
        synchronized (list) {
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                SubscriberUser subscriber = (SubscriberUser)iterator.next();
                if (!subscriber.getSubscriber().equals(subscribedBy) || !subscriber.getCallId().equals(callId)) continue;
                this.releaseSubscriptionsDialog(subscriber.getSubscribeDialog());
                boolean locked = false;
                try {
                    locked = subscriber.getLock().tryLock(2L, TimeUnit.SECONDS);
                    if (locked) {
                        iterator.remove();
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy, subscribedUser, "Removed SubscribedBy User: " + subscribedBy + " mapping for key: " + subscribedUser + " from subscriptionsMap for callId: " + callId);
                        break;
                    }
                    this.helperIMS.printCustomLogs(this.className, functionName, "warn", subscribedBy, subscribedUser, "Cannot acquire Lock Forcefully Removing SubscribedBy User: " + subscribedBy + " mapping for key: " + subscribedUser + " from subscriptionsMap for callId: " + callId);
                    iterator.remove();
                    break;
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while trying to lock for removal: {} for User: {}", (Object)subscribedBy, (Object)subscribedUser);
                    Thread.currentThread().interrupt();
                    iterator.remove();
                    break;
                }
                finally {
                    if (locked) {
                        subscriber.getLock().unlock();
                    }
                }
            }
            if (users.isEmpty()) {
                this.subscriptionsMap.remove(subscribedUser);
            }
        }
    }

    public List<SubscriberUser> getUserSubscription(String subscribedUser) {
        List users = null;
        try {
            users = (List)this.subscriptionsMap.get(subscribedUser);
        }
        catch (Exception e) {
            logger.error("Exception in getUserSubscription {} error:{}", (Object)subscribedUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return users;
    }

    public List<SubscriberUserModel> getUserSubscriptionList(String subscribeUser) {
        ArrayList<SubscriberUserModel> users = new ArrayList<SubscriberUserModel>();
        try {
            ((List)this.subscriptionsMap.get(subscribeUser)).forEach(row -> users.add(new SubscriberUserModel(row.getSubscriber(), row.getEpoch(), row.getExpires(), row.getSubscriptionHost(), row.getContact(), row.isActive(), row.getSubscribedTo(), Boolean.valueOf(row.getInWIP().get()), Long.valueOf(row.getCurrentSequence().get()), (String)row.getLastEvent().get(), (String)row.getCurrentcallId().get(), (String)row.getCallState().get(), (String)row.getNextCallId().get(), (String)row.getNextCallState().get())));
        }
        catch (Exception e) {
            logger.error("Exception in getUserSubscription {} error:{}", (Object)subscribeUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSubscription(String eventType, String subscribedUser, String receivedSubscribByUser, String activeCallID, String callState, long packetSequence) {
        String functionName = "checkSubscription";
        List subscription = null;
        try {
            subscription = this.getUserSubscription(subscribedUser);
            if (subscription == null || subscription.isEmpty()) {
                if (eventType.equals("request") || eventType.equals("re-request")) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "No subscriptions found for params SubscribedUser: " + subscribedUser + " callId: " + activeCallID);
                }
                return;
            }
            for (SubscriberUser subscribedBy : subscription) {
                if (!subscribedBy.isActive()) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "InActive subscription found. Dropping the Notify ->  Subsciber(SubscribeBy): " + subscribedBy.getSubscriber() + " SubscribedUser: " + subscribedUser + " callId: " + activeCallID);
                    continue;
                }
                if (Instant.now().getEpochSecond() >= subscribedBy.getExpires()) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "Expiry subscription found. Dropping the Notify ->  Subsciber(SubscribeBy): " + subscribedBy.getSubscriber() + " SubscribedUser: " + subscribedUser + " callId: " + activeCallID);
                    continue;
                }
                if (!this.imsV2ServerIMS.isUserRegistered(subscribedBy.getSubscriber())) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "Unregistered subscriber found.Dropping the Notify ->  Subsciber(SubscribeBy): " + subscribedBy.getSubscriber() + " SubscribedUser: " + subscribedUser + " callId: " + activeCallID);
                    continue;
                }
                if ("keypressed".equals(activeCallID) && subscribedBy.getSubscriber().equals(subscribedUser)) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "Self subscriber found for ENM Key Pressed. Dropping the Notify ->  Subsciber(SubscribeBy): " + subscribedBy.getSubscriber() + " SubscribedUser: " + subscribedUser + " callId: " + activeCallID + " KeyPressed: " + callState);
                    continue;
                }
                if (("registered".equals(activeCallID) || "Unregistered".equals(activeCallID)) && ((SIPDialog)subscribedBy.getSubscribeDialog()).getEventHeader().getEventType().equals("dialog")) continue;
                if (eventType.equals("request") || eventType.equals("re-request")) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", receivedSubscribByUser, subscribedUser, "Active Subsciber(SubscribeBy): " + subscribedBy.getSubscriber() + " found in SubscriptionMap for key SubscribedUser: " + subscribedUser + " callId: " + activeCallID);
                }
                if (!subscribedBy.getLock().tryLock(2L, TimeUnit.SECONDS)) continue;
                try {
                    this.updateStatusAndSendNotification(subscribedBy, eventType, subscribedUser, receivedSubscribByUser, activeCallID, callState, packetSequence);
                }
                catch (Exception e) {
                    logger.error("In checkSubscription While processing notification for subscriptionUser: {} to SubscribeUser: {}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber());
                }
                finally {
                    subscribedBy.getLock().unlock();
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in checkSubscription {} error:{}", (Object)subscribedUser, (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public void updateStatusAndSendNotification(SubscriberUser subscribedBy, String eventType, String subscribedUser, String receivedSubscribeByUser, String activeCallID, String callState, long packetSequence) {
        String functionName = "updateStatusAndSendNotification";
        if (eventType.equals("request") || eventType.equals("re-request")) {
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy.getSubscriber(), subscribedUser, "Received params SubscribedByUser: " + subscribedBy.getSubscriber() + " ,subscribedUser: " + subscribedUser + " ,eventType: " + eventType + " ,activeCallId: " + activeCallID + " ,receivedSubscribeByUser: " + receivedSubscribeByUser + " ,callState: " + callState + " ,packetSequence: " + packetSequence);
        }
        if (eventType.equals("request") || eventType.equals("freshRequest")) {
            if (!subscribedBy.getInWIP().get()) {
                subscribedBy.getLastEvent().getAndSet(eventType);
                subscribedBy.getInWIP().set(true);
                this.sendNotification(subscribedUser, subscribedBy, activeCallID, callState, eventType);
            } else {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy.getSubscriber(), subscribedUser, "Subscription is in WIP for params SubscribedByUser: " + subscribedBy.getSubscriber() + " ,subscribedUser: " + subscribedUser + " ,eventType: " + eventType + " ,activeCallId: " + activeCallID + " ,receivedSubscribeByUser: " + receivedSubscribeByUser + " ,callState: " + callState + " ,packetSequence: " + packetSequence + ". Storing the Next CallID and CallState");
                subscribedBy.getNextCallId().set(activeCallID);
                subscribedBy.getNextCallState().set(callState);
            }
        } else if (eventType.equals("re-request") && subscribedBy.getSubscriber().equals(receivedSubscribeByUser)) {
            this.sendNotification(subscribedUser, subscribedBy, (String)subscribedBy.getCurrentcallId().get(), (String)subscribedBy.getCallState().get(), eventType);
        } else if ((eventType.equals("delivered") || eventType.equals("timeout") || eventType.equals("error")) && subscribedBy.getSubscriber().equals(receivedSubscribeByUser)) {
            if (packetSequence >= subscribedBy.getCurrentSequence().get()) {
                subscribedBy.getCurrentcallId().set("");
                subscribedBy.getCallState().set("");
                if (StringUtils.hasText((String)((String)subscribedBy.getNextCallState().get()))) {
                    subscribedBy.getLastEvent().getAndSet("request");
                    subscribedBy.getInWIP().set(true);
                    this.sendNotification(subscribedUser, subscribedBy, (String)subscribedBy.getNextCallId().get(), (String)subscribedBy.getNextCallState().get(), eventType);
                    subscribedBy.getNextCallId().set("");
                    subscribedBy.getNextCallState().set("");
                } else {
                    subscribedBy.getLastEvent().getAndSet("");
                    subscribedBy.getInWIP().set(false);
                }
            } else {
                subscribedBy.getLastEvent().getAndSet("");
                subscribedBy.getInWIP().set(false);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedUser, subscribedBy.getSubscriber(), "Out of Sequence Notify Response received for params SubscribedByUser: " + subscribedBy.getSubscriber() + " ,subscribedUser: " + subscribedUser + " ,eventType: " + eventType + " ,activeCallId: " + activeCallID + " ,receivedSubscribeByUser: " + receivedSubscribeByUser + " ,callState: " + callState + " ,packetSequence: " + packetSequence);
            }
        }
    }

    public void sendNotification(String subscribedUser, SubscriberUser subscribedBy, String activeCallID, String callState, String eventType) {
        String functionName = "sendNotification";
        try {
            byte[] contentBytes;
            String notifyContentStr;
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy.getSubscriber(), subscribedUser, "Received params SubscribedByUser: " + subscribedBy.getSubscriber() + " ,subscribedUser: " + subscribedUser + " ,eventType: " + eventType + " ,activeCallId: " + activeCallID + " ,callState: " + callState);
            if (eventType.equals("re-request") && (activeCallID == null || callState == null)) {
                return;
            }
            Request notifyRequest = null;
            SubscriptionStateHeader subscriptionState = null;
            subscribedBy.getInWIP().set(true);
            int expireTimeOut = (int)(subscribedBy.getExpires() - Instant.now().getEpochSecond());
            ExpiresHeader expiresHeader = this.helperIMS.getHeaderFactory().createExpiresHeader(expireTimeOut > 0 ? expireTimeOut : 0);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedBy.getSubscriber(), subscribedUser, "Creating Notify for SubscribedByUser: " + subscribedBy.getSubscriber() + " ,subscribedUser: " + subscribedUser + " ,eventType: " + eventType + " ,activeCallId: " + activeCallID + " ,contact: " + subscribedBy.getContact());
            SIPDialog dialog = (SIPDialog)subscribedBy.getSubscribeDialog();
            notifyRequest = dialog.createRequest("NOTIFY");
            notifyRequest = this.helperIMS.removeRouteHeaders(notifyRequest, this.className + "<->" + functionName);
            this.helperIMS.setUserAgentHeaderRequest(notifyRequest, "NOTIFY");
            SipURI contactUri = (SipURI)this.helperIMS.getAddressFactory().createURI(subscribedBy.getContact());
            notifyRequest.setRequestURI((URI)contactUri);
            FromHeader fromHeader = (FromHeader)notifyRequest.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            String contactHost = ((SipURI)fromHeader.getAddress().getURI()).getHost();
            SipURI sipURI = this.helperIMS.getAddressFactory().createSipURI(fromUser, contactHost);
            sipURI.setPort(this.helperIMS.getPortAccordingToTransport(subscribedBy.getTransport(), "listeningPort"));
            sipURI.setTransportParam(subscribedBy.getTransport());
            Address address = this.helperIMS.getAddressFactory().createAddress((URI)sipURI);
            ContactHeader newContactHeader = this.helperIMS.getHeaderFactory().createContactHeader(address);
            notifyRequest.setHeader((Header)newContactHeader);
            if (expiresHeader.getExpires() > 0) {
                subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("active");
                subscriptionState.setExpires(expiresHeader.getExpires());
            } else {
                if (eventType.equals("freshRequest")) {
                    subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("terminated");
                    subscriptionState.setReasonCode("noresource");
                } else {
                    subscriptionState = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("terminated");
                    subscriptionState.setReasonCode("timeout");
                }
                this.removeV2Subscription(subscribedUser, subscribedBy.getSubscriber(), subscribedBy.getCallId());
            }
            notifyRequest.addHeader((Header)subscriptionState);
            if ("keypressed".equals(activeCallID)) {
                Header keyPressedHeader = this.helperIMS.getHeaderFactory().createHeader(activeCallID, callState);
                notifyRequest.addHeader(keyPressedHeader);
                ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "dtmf-relay");
                notifyRequest.addHeader((Header)contentTypeHeader);
            } else if (dialog.getEventHeader().getEventType().equals("presence")) {
                notifyContentStr = this.getNotifyContentBody("presence", subscribedUser, activeCallID, callState);
                contentBytes = notifyContentStr.getBytes();
                ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "pidf+xml");
                notifyRequest.setContent((Object)contentBytes, contentTypeHeader);
            } else {
                callState = this.helperIMS.presenceToDialogEventCallState(callState);
                notifyContentStr = this.getNotifyContentBody("dialog", subscribedUser, activeCallID, callState);
                contentBytes = notifyContentStr.getBytes();
                ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "dialog-info+xml");
                notifyRequest.setContent((Object)contentBytes, contentTypeHeader);
            }
            this.helperIMS.printCustomLogs(this.className, functionName, "info", subscribedUser, subscribedBy.getSubscriber(), "subscribeByUser: " + subscribedBy.getSubscriber() + " subscribedUser: " + subscribedUser + " for activecallId: " + activeCallID + ". Sent Notify -> \n" + notifyRequest);
            CSeqHeader seqHeader = (CSeqHeader)notifyRequest.getHeader("CSeq");
            ClientTransaction ct = dialog.getSipProvider().getNewClientTransaction(notifyRequest);
            dialog.sendRequest(ct);
            dialog.incrementLocalSequenceNumber();
            subscribedBy.setNotifyCSeq(Long.valueOf(dialog.getLocalSeqNumber()));
            subscribedBy.getCurrentcallId().getAndSet(activeCallID);
            subscribedBy.getCallState().getAndSet(callState);
            subscribedBy.getCurrentSequence().set(seqHeader.getSeqNumber());
            subscribedBy.getInWIP().set(false);
        }
        catch (Exception e) {
            logger.error("In sendNotification Error while sending notification for {} : to : {}", (Object)subscribedUser, (Object)subscribedBy.getSubscriber(), (Object)e);
        }
    }

    public void releaseSubscriptionsDialog(Dialog dialog) {
        String functionName = "releaseSubscriptionsDialog";
        this.scheduler.schedule(() -> {
            this.helperIMS.printCustomLogs(this.className, functionName, "info", ((SipURI)dialog.getLocalParty().getURI()).getUser(), ((SipURI)dialog.getRemoteParty().getURI()).getUser(), "Deleted Subscription Dialog from sipStack dialogId: " + dialog.getDialogId());
            dialog.delete();
        }, 10L, TimeUnit.SECONDS);
    }

    public String getNotifyContentBody(String eventType, String subscribedUser, String activeCallID, String callState) {
        String notifyContentStr = null;
        if (eventType.equals("presence")) {
            if (callState.contains("Available")) {
                callState = "Available";
                notifyContentStr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<presence xmlns='urn:ietf:params:xml:ns:pidf'\n xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model'\n xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid'\n xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='sip:#subscriberUser@#subscriberIP'>\n  <tuple id='t6a5ed77e'>\n    <status>\n      <basic>open</basic>\n    </status>\n  </tuple>\n  <dm:person id='p06360c4a'>\n    <dm:note>#callState</dm:note>\n  </dm:person>\n</presence>";
                notifyContentStr = notifyContentStr.replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.LISTEN_IP_ADDRESS).replace("#callState", callState);
            } else if (callState.contains("Unregistered")) {
                notifyContentStr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<presence xmlns='urn:ietf:params:xml:ns:pidf'\n xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model'\n xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid'\n xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='sip:#subscriberUser@#subscriberIP'>\n  <tuple id='t6a5ed77e'>\n    <status>\n      <basic>closed</basic>\n    </status>\n  </tuple>\n  <dm:person id='p06360c4a'>\n    <dm:note>#callState</dm:note>\n  </dm:person>\n</presence>";
                notifyContentStr = notifyContentStr.replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.LISTEN_IP_ADDRESS).replace("#callState", callState);
            } else {
                notifyContentStr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<presence xmlns='urn:ietf:params:xml:ns:pidf'\n xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model'\n xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid'\n xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='sip:#subscriberUser@#subscriberIP'>\n  <tuple id='t6a5ed77e'>\n    <status>\n      <basic>open</basic>\n    </status>\n  </tuple>\n  <dm:person id='p06360c4a'>\n  <rpid:activities>\n   <rpid:on-the-phone/>\n  </rpid:activities>\n    <dm:note>#callState</dm:note>\n  </dm:person>\n</presence>";
                notifyContentStr = notifyContentStr.replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.LISTEN_IP_ADDRESS).replace("#callState", callState);
            }
        } else {
            if (activeCallID == null) {
                activeCallID = " ";
            }
            if (callState.contains("Available")) {
                logger.info("received callstate is available {} {} {} ", (Object)subscribedUser, (Object)activeCallID, (Object)callState);
                notifyContentStr = "<?xml version=\"1.0\"?>\r\n<dialog-info xmlns=\"urn:ietf:params:xml:ns:dialog-info\" version=\"0\" state=\"full\" entity=\"sip:#subscriberUser@#subscriberIP\">\r\n</dialog-info>";
                notifyContentStr = notifyContentStr.replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.LISTEN_IP_ADDRESS);
            } else {
                notifyContentStr = "<?xml version=\"1.0\"?>\r\n<dialog-info xmlns=\"urn:ietf:params:xml:ns:dialog-info\" version=\"1\" state=\"full\" entity=\"sip:#subscriberUser@#subscriberIP\">\r\n<dialog id=\"#activeCallID\" direction=\"recipient\">\r\n<state>#callState</state>\r\n</dialog>\r\n</dialog-info>";
                notifyContentStr = notifyContentStr.replace("#activeCallID", activeCallID).replace("#subscriberUser", subscribedUser).replace("#subscriberIP", Constants.LISTEN_IP_ADDRESS).replace("#callState", callState);
            }
        }
        return notifyContentStr;
    }
}

