/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMSStateMachine;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.ImsV2Subscriptions;
import com.coraltele.ims.V2StateMachine;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ResponseEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.AlertInfoHeader;
import com.coraltele.interfaces.sip.header.AuthorizationHeader;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.ProxyAuthenticateHeader;
import com.coraltele.interfaces.sip.header.ProxyAuthorizationHeader;
import com.coraltele.interfaces.sip.header.RecordRouteHeader;
import com.coraltele.interfaces.sip.header.ReferToHeader;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.UserAgentHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.header.WWWAuthenticateHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.RequestEventExt;
import com.coraltele.javax.sip.ResponseEventExt;
import com.coraltele.javax.sip.SipProviderImpl;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.clientauthutils.MessageDigestAlgorithm;
import com.coraltele.javax.sip.header.extensions.ReferredByHeader;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.javax.sip.stack.SIPServerTransaction;
import com.coraltele.javax.sip.stack.SIPTransaction;
import com.coraltele.model.RegisterUser;
import com.coraltele.service.BackgroundTaskService;
import com.coraltele.service.IMSV2ServerService;
import com.coraltele.service.JWTAuthenticationService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Conditional(value={EnableIMSV2_SERVER.class})
public class ImsV2ServerIMS {
    String className = "ImsV2ServerIMS";
    private static final Logger logger = LogManager.getLogger(ImsV2ServerIMS.class);
    @Autowired
    HelperIMS helperIMS;
    @Autowired
    Optional<V2StateMachine> v2StateMachine;
    @Autowired
    JWTAuthenticationService jwtAuthentication;
    @Autowired
    Optional<BackgroundTaskService> backgroundTaskService;
    @Autowired
    Optional<IMSV2ServerService> imsV2ServerService;
    @Autowired
    private Optional<FeatureIMSStateMachine> featureIMSStateMachine;
    @Autowired
    Optional<ImsV2Subscriptions> imsV2Subscriptions;
    private Lock matchInviteLock = new ReentrantLock();
    private Lock matchRegisterLock = new ReentrantLock();
    BlockingQueue<Runnable> IMSV2Queue = null;
    ThreadPoolExecutor IMSV2Executor = null;
    public ConcurrentHashMap<String, RegisterUser> registerMap = new ConcurrentHashMap();
    private static String routeViaIP = null;
    private static int routeViaPort = 0;

    public ImsV2ServerIMS() {
        this.IMSV2Queue = new LinkedBlockingQueue();
        this.IMSV2Executor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.IMSV2Queue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void IMSV2Request(RequestEvent requestEvent) {
        try {
            this.IMSV2Executor.submit(() -> this.handleIMSV2Request(requestEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling IMSV2Request {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void IMSV2Response(ResponseEvent responseEvent) {
        try {
            this.IMSV2Executor.submit(() -> this.handleIMSV2Response(responseEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling IMSV2Response {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void handleIMSV2Request(RequestEvent requestEvent) {
        String functionName = "handleIMSV2Request";
        Request request = requestEvent.getRequest();
        CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callID = callIDHeader.getCallId();
        String remoteIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
        int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
        String remoteIpPort = remoteIP + ":" + remotePort;
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        this.helperIMS.printRequestLog(this.className, functionName, "Received", request, remoteIpPort, fromUser, toUser);
        if (this.helperIMS.checkLoopInRequest(request, remoteIpPort, callID, request.getMethod(), fromUser, toUser)) {
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Loop Detected !!. Dropping the request !! \n" + request.toString());
            if (requestEvent.getServerTransaction() != null) {
                try {
                    requestEvent.getServerTransaction().terminate();
                }
                catch (Exception e) {
                    logger.error("Error while terminating loop detected transaction {}", (Throwable)e);
                }
            }
            return;
        }
        boolean fromRegistrar = false;
        if (this.helperIMS.isFromRegistrar(remoteIP, remotePort)) {
            fromRegistrar = true;
        }
        request = this.helperIMS.setUserAgentHeaderRequest(request, functionName);
        request = this.helperIMS.handleMaxForwardheader(request, functionName);
        request = this.helperIMS.addReceivedParamInViaHeader(request, functionName, remoteIP);
        try {
            switch (request.getMethod()) {
                case "REGISTER": {
                    this.handleRegisterRequest(requestEvent);
                    break;
                }
                case "INVITE": {
                    this.handleInviteRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "BYE": {
                    this.handleByeRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "ACK": {
                    this.handleAckRequest(requestEvent);
                    break;
                }
                case "CANCEL": {
                    this.handleCancelRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    this.handleSubscribeRequest(requestEvent);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "REFER": {
                    this.handleReferRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "INFO": {
                    this.handleInfoRequest(requestEvent);
                    break;
                }
                case "OPTIONS": {
                    this.handleOptionRequest(requestEvent);
                    break;
                }
                case "MESSAGE": {
                    break;
                }
                case "UPDATE": {
                    this.handleUpdateRequest(requestEvent);
                    break;
                }
                case "PRACK": {
                    break;
                }
                default: {
                    logger.error("Unhandled handleIMSV2Request {}", (Object)request.getMethod());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleIMSV2Request Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterRequest(RequestEvent requestEvent) {
        String functionName = "handleRegisterRequest";
        ServerTransaction serverTransaction = null;
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            serverTransaction = requestEvent.getServerTransaction();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            Integer remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String fromHost = ((SipURI)fromHeader.getAddress().getURI()).getHost();
            String toHost = ((SipURI)toHeader.getAddress().getURI()).getHost();
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            SipURI requestUri = (SipURI)request.getRequestURI();
            Long cseq = ((CSeqHeader)request.getHeader("CSeq")).getSeqNumber();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            String listeningIp = sipProvider.getListeningPoint(viaHeaderTransport).getIPAddress();
            AuthorizationHeader authorizationHeader = (AuthorizationHeader)request.getHeader("Authorization");
            String authorizationString = authorizationHeader != null ? authorizationHeader.toString() : null;
            UserAgentHeader userAgentHeader = (UserAgentHeader)request.getHeader("User-Agent");
            String userAgent = userAgentHeader != null && userAgentHeader.getProduct().hasNext() ? userAgentHeader.getProduct().next().toString() : null;
            this.helperIMS.handleContactForNAT(request, null, remoteIpAddress, remotePort.intValue(), "request", true);
            ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
            String stringContactUri = ((SipURI)contactHeader.getAddress().getURI()).toString();
            if (expiresHeader == null) {
                expiresHeader = contactHeader.getExpires() != -1 ? this.helperIMS.getHeaderFactory().createExpiresHeader(contactHeader.getExpires()) : this.helperIMS.getHeaderFactory().createExpiresHeader(0);
                request.setExpires(expiresHeader);
            }
            Response response = null;
            if (!toHost.equals(requestUri.getHost())) {
                this.sendUnauthorizedResponse(request, serverTransaction, 400, "Conflict b/w ToUser & RequestURI", functionName);
                return;
            }
            if (!fromHost.equalsIgnoreCase(listeningIp) && !this.helperIMS.domainSet.contains(fromHost)) {
                this.sendUnauthorizedResponse(request, serverTransaction, 400, "Bad request", functionName);
                return;
            }
            if (!this.helperIMS.getExtensionMap().containsKey(fromUser)) {
                this.sendUnauthorizedResponse(request, serverTransaction, 404, "User Not Found", functionName);
                return;
            }
            if (authorizationHeader == null) {
                this.sendUnauthorizedResponse(request, serverTransaction, 401, null, functionName);
                return;
            }
            if (authorizationHeader.getUsername() != null && !authorizationHeader.getUsername().equals(fromUser)) {
                this.sendUnauthorizedResponse(request, serverTransaction, 400, "Conflict b/w FromUser & Authoriation user", functionName);
                return;
            }
            if (authorizationString != null && authorizationString.contains("Bearer") && this.jwtAuthentication.isValid(authorizationString.replace("Authorization:", "").trim()) || this.matchRegisterResponse(authorizationHeader, request)) {
                if (this.registerMap.containsKey(fromUser) && ((RegisterUser)this.registerMap.get(fromUser)).getCallId().equals(callId) && ((RegisterUser)this.registerMap.get(fromUser)).getCseq() > cseq) {
                    this.sendUnauthorizedResponse(request, serverTransaction, 500, "Lower Cseq request not Allowed from same CallID", functionName);
                    return;
                }
                if (this.registerMap.containsKey(fromUser) && !((RegisterUser)this.registerMap.get(fromUser)).getCallId().equals(callId) && expiresHeader.getExpires() == 0 || !this.registerMap.containsKey(fromUser) && expiresHeader.getExpires() == 0) {
                    response = this.helperIMS.getMessageFactory().createResponse(200, request);
                    serverTransaction.sendResponse(response);
                    this.publishonRedis(fromUser, expiresHeader.getExpires(), contactHeader, remoteIpAddress, remotePort.intValue());
                } else {
                    this.registerMap.computeIfAbsent(fromUser, k -> new RegisterUser());
                    RegisterUser registerUser = (RegisterUser)this.registerMap.get(fromUser);
                    if (registerUser.getLock().tryLock(2L, TimeUnit.SECONDS)) {
                        this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Acquired RegisterUser lock for user: " + fromUser);
                        try {
                            Long currentTime = System.currentTimeMillis();
                            registerUser.setCallId(callId);
                            registerUser.setContact(stringContactUri);
                            registerUser.setCseq(cseq);
                            registerUser.setExpireTime(Long.valueOf(currentTime + (long)expiresHeader.getExpires() * 1000L));
                            registerUser.setExpiresAt(this.helperIMS.getISTfromEpoch(registerUser.getExpireTime(), TimeUnit.MILLISECONDS));
                            registerUser.setExpireToken(Integer.valueOf(expiresHeader.getExpires()));
                            if (expiresHeader.getExpires() != 0) {
                                registerUser.setLastRegistrationTime(this.helperIMS.getISTfromEpoch(currentTime, TimeUnit.MILLISECONDS));
                            }
                            registerUser.setRemoteIpAddress(remoteIpAddress);
                            registerUser.setRemotePort(remotePort);
                            registerUser.setListeningTransport(viaHeaderTransport.toUpperCase());
                            registerUser.setListeningIp(listeningIp);
                            registerUser.setRegisterDomain(fromHost);
                            registerUser.setListeningPort(sipProvider.getListeningPoint(viaHeaderTransport).getPort());
                        }
                        catch (Exception e) {
                            logger.error("Error while Updating User {} in handleRegisterRequest ", (Object)fromUser);
                        }
                        finally {
                            registerUser.getLock().unlock();
                            this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Released RegisterUser lock for user: " + fromUser);
                        }
                    } else {
                        this.helperIMS.printCustomLogs(this.className, functionName, "warn", fromUser, toUser, "Failed to acquir RegisterUser lock within 2 seconds for user: " + fromUser);
                    }
                    response = this.helperIMS.getMessageFactory().createResponse(200, request);
                    serverTransaction.sendResponse(response);
                    ((IMSV2ServerService)this.imsV2ServerService.get()).saveRegisterationsInDatabase(registerUser, fromUser, userAgent);
                    ((IMSV2ServerService)this.imsV2ServerService.get()).setSgwUserOff(fromUser, expiresHeader.getExpires());
                    this.publishonRedis(fromUser, expiresHeader.getExpires(), contactHeader, remoteIpAddress, remotePort.intValue());
                    if (expiresHeader.getExpires() <= 0) {
                        this.IMSV2Executor.submit(() -> this.sendCustomNotify(fromUser, "Unregistered", "Unregistered"));
                    } else {
                        this.IMSV2Executor.submit(() -> this.sendCustomNotify(fromUser, "registered", "On The Phone"));
                    }
                }
            } else {
                this.sendUnauthorizedResponse(request, serverTransaction, 401, "Authorization mismatch", functionName);
                return;
            }
            this.helperIMS.printResponseLog(this.className, functionName, "Send", response, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleRegisterRequest Error while Processing Request{}", (Object)e.getMessage(), (Object)e);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleInviteRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleInviteRequest";
        ServerTransaction serverTransaction = null;
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            ProxyAuthorizationHeader proxyAuthorizationHeader = (ProxyAuthorizationHeader)request.getHeader("Proxy-Authorization");
            AuthorizationHeader authorizationHeader = (AuthorizationHeader)request.getHeader("Authorization");
            String authorizationString = authorizationHeader != null ? authorizationHeader.toString() : null;
            Header bearerTokenHeader = request.getHeader("Bearer-Token");
            serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (this.helperIMS.checkExtensionGivenType(toUser, "enm")) {
                this.sendUnauthorizedResponse(request, serverTransaction, 480, "ENM Triggered successfully", functionName);
                this.IMSV2Executor.submit(() -> this.sendCustomNotify(fromUser, "keypressed", toUser));
                return;
            }
            if (requestEvent.getDialog() != null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " Dialog is already established for callid: " + callId);
                this.forwardInviteRequest(requestEvent, serverTransaction, null, null, Boolean.valueOf(false), fromRegistrar);
            } else if (remoteIpAddress.equals(Constants.SIPSERVER_IP) || remoteIpAddress.equals(Constants.SIPREGISTRAR_IP) || remoteIpAddress.equals(Constants.CONFERENCING_SERVER_IP) || this.helperIMS.isFromInboundGatewayIP(remoteIpAddress)) {
                this.routeInviteRequest(requestEvent, serverTransaction, remoteIpAddress, remotePort, fromRegistrar);
            } else if (authorizationString != null && authorizationString.contains("Bearer") && this.jwtAuthentication.isValid(authorizationString.replace("Authorization:", "").trim()) || bearerTokenHeader != null && this.jwtAuthentication.isValidToken(bearerTokenHeader.toString()) || this.matchInviteResponse(proxyAuthorizationHeader, request)) {
                this.routeInviteRequest(requestEvent, serverTransaction, remoteIpAddress, remotePort, fromRegistrar);
            } else if (authorizationHeader == null && proxyAuthorizationHeader == null) {
                this.sendUnauthorizedResponse(request, serverTransaction, 407, null, functionName);
            } else {
                this.sendUnauthorizedResponse(request, serverTransaction, 407, "Authorization mismatch", functionName);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleInviteRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void routeInviteRequest(RequestEvent requestEvent, ServerTransaction serverTransaction, String remoteIp, int remotePort, boolean fromRegistrar) {
        String functionName = "routeInviteRequest";
        try {
            Request request = requestEvent.getRequest();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            Header mcxbroadcastHeader = request.getHeader("X-mcxbroadcast");
            Header ecbroadcastHeader = request.getHeader("X-Ec-Broadcast");
            Header pabroadcastHeader = request.getHeader("X-Pa-Broadcast");
            Header publicEmergencyHeader = request.getHeader("X-Public-Emergency");
            Response response = this.helperIMS.getMessageFactory().createResponse(100, request);
            serverTransaction.sendResponse(response);
            if (mcxbroadcastHeader != null || ecbroadcastHeader != null || pabroadcastHeader != null || publicEmergencyHeader != null || this.helperIMS.checkUserType(toUser, Constants.SIPSERVER_ADDRESS)) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Forwarding Invite to SipServer Address: " + Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_PORT + " for callId: " + callId);
                this.forwardInviteRequest(requestEvent, serverTransaction, Constants.SIPSERVER_IP, Constants.SIPSERVER_PORT, Boolean.valueOf(false), fromRegistrar);
            } else if (this.helperIMS.isVolteVonr(toUser)) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Forwarding Invite to SBC(SipRegistrar) Address: " + Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT + " for callId: " + callId);
                this.forwardInviteRequest(requestEvent, serverTransaction, Constants.SIPREGISTRAR_IP, Constants.SIPREGISTRAR_PORT, Boolean.valueOf(false), fromRegistrar);
            } else if (this.helperIMS.checkUserType(toUser, Constants.CONFERENCESERVER_ADDRESS)) {
                Header X_coral_sbc_callid_Header = this.helperIMS.getHeaderFactory().createHeader("X-coral_sbc_callid", callId);
                request.addHeader(X_coral_sbc_callid_Header);
                String ConferenceIp = (String)((List)this.helperIMS.getExtensionMap().get(toUser)).get(6);
                if (ConferenceIp != null) {
                    int conferencePort = Integer.valueOf((String)((List)this.helperIMS.getExtensionMap().get(toUser)).get(7));
                    conferencePort = conferencePort == 0 ? 5060 : conferencePort;
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Forwarding Invite to ConferenceServer Address: " + ConferenceIp + ":" + conferencePort + " for callId: " + callId);
                    this.forwardInviteRequest(requestEvent, serverTransaction, ConferenceIp, Integer.valueOf(conferencePort), Boolean.valueOf(false), fromRegistrar);
                } else {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Forwarding Invite to ConferenceServer Address: " + Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_PORT + " for callId: " + callId);
                    this.forwardInviteRequest(requestEvent, serverTransaction, Constants.CONFERENCING_SERVER_IP, Constants.CONFERENCING_SERVER_PORT, Boolean.valueOf(false), fromRegistrar);
                }
            } else if (routeViaIP != null) {
                if (remoteIp.equals(routeViaIP) || remoteIp.equals(Constants.SIPSERVER_IP) || remoteIp.equals(Constants.SIPREGISTRAR_IP) || remoteIp.equals(Constants.CONFERENCING_SERVER_IP)) {
                    if (this.isUserRegistered(toUser)) {
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Enabled routeVia Forwarding Invite to Client: " + toUser + " for callId: " + callId);
                        this.forwardInviteRequest(requestEvent, serverTransaction, ((RegisterUser)this.registerMap.get(toUser)).getRemoteIpAddress(), ((RegisterUser)this.registerMap.get(toUser)).getRemotePort(), Boolean.valueOf(true), fromRegistrar);
                    } else {
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Enabled routeVia Client: " + toUser + " is not registered for callId: " + callId);
                        this.sendUnauthorizedResponse(request, serverTransaction, 480, "User Not Registered", functionName);
                    }
                } else {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Enabled routeVia Forwarding Invite to routeVia Adrress: " + routeViaIP + ":" + routeViaPort + " for callId: " + callId);
                    this.forwardInviteRequest(requestEvent, serverTransaction, routeViaIP, Integer.valueOf(routeViaPort), Boolean.valueOf(false), fromRegistrar);
                }
            } else if (routeViaIP == null && this.isUserRegistered(toUser)) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Forwarding Invite to Client: " + toUser + " Address: " + ((RegisterUser)this.registerMap.get(toUser)).getRemoteIpAddress() + ":" + ((RegisterUser)this.registerMap.get(toUser)).getRemotePort() + " for callId: " + callId);
                this.forwardInviteRequest(requestEvent, serverTransaction, ((RegisterUser)this.registerMap.get(toUser)).getRemoteIpAddress(), ((RegisterUser)this.registerMap.get(toUser)).getRemotePort(), Boolean.valueOf(true), fromRegistrar);
            } else if (!this.helperIMS.getExtensionMap().containsKey(toUser)) {
                this.sendUnauthorizedResponse(request, serverTransaction, 404, "User Not Found", functionName);
            } else {
                this.sendUnauthorizedResponse(request, serverTransaction, 480, "User Not Registered", functionName);
            }
        }
        catch (Exception ex) {
            logger.error("Error in routeInviteRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void forwardInviteRequest(RequestEvent requestEvent, ServerTransaction serverTransaction, String SERVER_IP, Integer SERVER_PORT, Boolean privateCall, boolean fromRegistrar) {
        String functionName = "forwardInviteRequest";
        try {
            String SERVER_ADRESS = SERVER_IP + ":" + SERVER_PORT;
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            SipProvider receivedOnSipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            AlertInfoHeader alertInfoHeader = (AlertInfoHeader)request.getHeader("Alert-Info");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            RecordRouteHeader recordRouteHeader = (RecordRouteHeader)request.getHeader("Record-Route");
            String remotePartyId = Optional.ofNullable((ExtensionHeader)request.getHeader("Remote-Party-ID")).map(ExtensionHeader::getValue).orElse(null);
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            Address fromAddress = fromHeader.getAddress();
            String fromUser = ((SipURI)fromAddress.getURI()).getUser();
            String fromName = fromAddress.getDisplayName();
            if (fromName != null && !fromName.isEmpty() && fromName.equalsIgnoreCase("Unavailable")) {
                fromName = fromUser;
                fromAddress.setDisplayName(fromName);
            }
            if (remotePartyId != null && !remotePartyId.isEmpty() && (remotePartyId.contains("Unavailable") || remotePartyId.contains("unavailable"))) {
                remotePartyId = remotePartyId.replace("Unavailable", fromUser);
                remotePartyId = remotePartyId.replace("unavailable", fromUser);
                Header newRemotePartyIdHeader = this.helperIMS.getHeaderFactory().createHeader("Remote-Party-ID", remotePartyId);
                request.removeHeader("Remote-Party-ID");
                request.addHeader(newRemotePartyIdHeader);
            }
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = receivedOnSipProvider.getNewServerTransaction(request);
            }
            SIPDialog serverDialog = (SIPDialog)serverTransaction.getDialog();
            Request inviteRequest = null;
            inviteRequest = (Request)request.clone();
            SipURI requestURI = (SipURI)inviteRequest.getRequestURI();
            inviteRequest = this.helperIMS.removeRouteHeaders(inviteRequest, request.getMethod() + ":" + callId);
            if (fromRegistrar && alertInfoHeader == null) {
                String alertInfoValue = this.helperIMS.getUnrecognizedHeaderValue(request, "Alert-Info", "handleInviteRequest");
                alertInfoValue = alertInfoValue.replaceAll("^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$", "");
                SipURI alertInfoURI = this.helperIMS.getAddressFactory().createSipURI(toUser, Constants.LISTEN_IP_ADDRESS);
                alertInfoHeader = this.helperIMS.getHeaderFactory().createAlertInfoHeader((URI)alertInfoURI);
                alertInfoHeader.setParameter("info", alertInfoValue);
                inviteRequest.setHeader((Header)alertInfoHeader);
            }
            if (SERVER_ADRESS != null && SERVER_ADRESS.equalsIgnoreCase(Constants.SIPSERVER_ADDRESS)) {
                Header X_ForwardRoute = this.helperIMS.getHeaderFactory().createHeader("X-ForwardRoute", "true");
                inviteRequest.addHeader(X_ForwardRoute);
            }
            if (privateCall != null) {
                if (privateCall.booleanValue()) {
                    listeningTransport = ((RegisterUser)this.registerMap.get(toUser)).getListeningTransport();
                    listeningPort = ((RegisterUser)this.registerMap.get(toUser)).getListeningPort();
                    listeningIp = ((RegisterUser)this.registerMap.get(toUser)).getListeningIp();
                } else {
                    if (SERVER_ADRESS != null) {
                        if (Constants.SIPSERVER_ADDRESS.equals(SERVER_ADRESS)) {
                            listeningTransport = Constants.SIPSERVER_TRANSPORT;
                        } else if (Constants.SIPREGISTRAR_ADDRESS.equals(SERVER_ADRESS)) {
                            listeningTransport = Constants.SIPREGISTRAR_TRANSPORT;
                        } else if (Constants.CONFERENCESERVER_ADDRESS.equals(SERVER_ADRESS)) {
                            listeningTransport = Constants.CONFERENCINGSERVER_TRANSPORT;
                        }
                    }
                    listeningTransport = listeningTransport.toUpperCase();
                    listeningPort = this.getPortAccordingToTransport(listeningTransport);
                }
            }
            if (requestEvent.getDialog() == null) {
                if (privateCall != null && Boolean.TRUE.equals(privateCall)) {
                    inviteRequest.setRequestURI((URI)((SipURI)this.helperIMS.getAddressFactory().createURI(((RegisterUser)this.registerMap.get(toUser)).getContact())));
                } else {
                    requestURI.setHost(SERVER_IP);
                    requestURI.setPort(SERVER_PORT.intValue());
                    requestURI.setTransportParam(listeningTransport);
                    inviteRequest.setRequestURI((URI)requestURI);
                }
                if (recordRouteHeader == null) {
                    SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getIPAddress());
                    forwardURI.setPort(receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getPort());
                    forwardURI.setTransportParam(viaHeaderTransport);
                    forwardURI.setLrParam();
                    Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                    recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
                    inviteRequest.addFirst((Header)recordRouteHeader);
                    SipURI forwardURI2 = this.helperIMS.getAddressFactory().createSipURI(null, listeningIp);
                    forwardURI2.setPort(listeningPort);
                    forwardURI2.setTransportParam(listeningTransport);
                    forwardURI2.setLrParam();
                    Address address2 = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI2);
                    recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address2);
                    inviteRequest.addFirst((Header)recordRouteHeader);
                } else {
                    String recordRouteIPPort = ((SipURI)recordRouteHeader.getAddress().getURI()).getHost() + ":" + ((SipURI)recordRouteHeader.getAddress().getURI()).getPort();
                    if (!recordRouteIPPort.equalsIgnoreCase(receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getIPAddress() + ":" + receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getPort()) && !recordRouteIPPort.equalsIgnoreCase(listeningIp + ":" + listeningPort)) {
                        SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getIPAddress());
                        forwardURI.setPort(receivedOnSipProvider.getListeningPoint(viaHeaderTransport).getPort());
                        forwardURI.setTransportParam(viaHeaderTransport);
                        forwardURI.setLrParam();
                        Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                        recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
                        inviteRequest.addFirst((Header)recordRouteHeader);
                        SipURI forwardURI2 = this.helperIMS.getAddressFactory().createSipURI(null, listeningIp);
                        forwardURI2.setPort(listeningPort);
                        forwardURI2.setTransportParam(listeningTransport);
                        forwardURI2.setLrParam();
                        Address address2 = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI2);
                        recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address2);
                        inviteRequest.addFirst((Header)recordRouteHeader);
                    }
                }
            } else {
                inviteRequest = this.handleCseqInRequest(requestEvent, inviteRequest);
                listeningTransport = this.findTransportFromRequest(inviteRequest, listeningTransport);
                listeningPort = this.getPortAccordingToTransport(listeningTransport);
                inviteRequest = this.updateIpPortInRequestURI(inviteRequest, listeningTransport);
            }
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Values of variables listeningIP: " + listeningIp + " listeningPort: " + listeningPort + " listeningTransport: " + listeningTransport);
            this.helperIMS.handleContactForNAT(inviteRequest, null, ((RequestEventExt)requestEvent).getRemoteIpAddress(), ((RequestEventExt)requestEvent).getRemotePort(), "request", true);
            if (Constants.NAT.booleanValue() && fromRegistrar) {
                this.helperIMS.modifySDP(inviteRequest, null, "request", "IP4", Constants.PUBLIC_IP_ADDRESS);
            }
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            viaHeader.setRPort();
            inviteRequest.addFirst((Header)viaHeader);
            inviteRequest.removeHeader("Authorization");
            inviteRequest.removeHeader("Proxy-Authorization");
            inviteRequest.removeHeader("Bearer-Token");
            this.helperIMS.printRequestLog(this.className, functionName, "Send", inviteRequest, null, fromUser, toUser);
            SipProvider clientSipProvider = (SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport);
            ClientTransaction clientTransaction = clientSipProvider.getNewClientTransaction(inviteRequest);
            clientTransaction.setApplicationData((Object)serverTransaction);
            serverTransaction.setApplicationData((Object)clientTransaction);
            SIPDialog clientDialog = (SIPDialog)clientTransaction.getDialog();
            clientDialog.setSipProvider((SipProviderImpl)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport));
            serverDialog.setApplicationData((Object)clientDialog);
            clientDialog.setApplicationData((Object)serverDialog);
            clientDialog.disableSequenceNumberValidation();
            serverDialog.disableSequenceNumberValidation();
            clientTransaction.sendRequest();
            if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && Constants.V2STATE_MACHINE.booleanValue()) {
                SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
                if (fromRegistrar) {
                    request.setRequestURI(inviteRequest.getRequestURI());
                }
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onInviteUpdate(dialog, fromRegistrar, fromUser, toUser);
            } else if (Constants.V2STATE_MACHINE.booleanValue()) {
                String key = callId + ":" + ((SipURI)serverDialog.getRemoteParty().getURI()).getUser();
                ((V2StateMachine)this.v2StateMachine.get()).onInviteUpdate(serverDialog, key, fromUser, toUser);
                if (!((V2StateMachine)this.v2StateMachine.get()).isHoldRequest(request)) {
                    String key2 = callId + ":" + ((SipURI)clientDialog.getRemoteParty().getURI()).getUser();
                    ((V2StateMachine)this.v2StateMachine.get()).onInviteUpdate(clientDialog, key2, fromUser, toUser);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in forwardInviteRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleCancelRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleCancelRequest";
        SIPServerTransaction serverTransaction = null;
        Request request = requestEvent.getRequest();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        try {
            String listeningTransport = "UDP";
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            serverTransaction = (SIPServerTransaction)requestEvent.getServerTransaction();
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            serverTransaction.sendResponse(response);
            Request cancelRequest = null;
            SIPDialog sipDialog2 = (SIPDialog)requestEvent.getDialog();
            if (sipDialog2 != null && sipDialog2.getLastTransaction() != null) {
                ClientTransaction clientTransaction2 = (ClientTransaction)sipDialog2.getLastTransaction().getApplicationData();
                cancelRequest = clientTransaction2.createCancel();
                listeningTransport = this.findTransportFromRequest(cancelRequest, listeningTransport);
                cancelRequest = this.updateIpPortInRequestURI(cancelRequest, listeningTransport);
                cancelRequest.removeHeader("Authorization");
                cancelRequest.removeHeader("Proxy-Authorization");
                ClientTransaction clientTransaction = ((SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport)).getNewClientTransaction(cancelRequest);
                clientTransaction.setApplicationData((Object)serverTransaction);
                clientTransaction.sendRequest();
                this.helperIMS.printRequestLog(this.className, functionName, "Send", cancelRequest, null, fromUser, toUser);
            } else {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "No associated Invite Transaction is found for callId:" + callId + " .Dropping the Cancel Request: \n" + request);
            }
        }
        catch (Exception e) {
            logger.error("Error in handleCancelRequest Method: {} callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)e.getLocalizedMessage(), (Object)e);
            this.exceptionResponse(requestEvent, (ServerTransaction)serverTransaction);
        }
        if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && Constants.V2STATE_MACHINE.booleanValue() && serverTransaction != null && serverTransaction.getDialog() != null) {
            SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
            ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onCancelUpdate(dialog, fromRegistrar, fromUser, toUser);
        } else if (Constants.V2STATE_MACHINE.booleanValue() && serverTransaction != null && serverTransaction.getDialog() != null) {
            SIPDialog serverDialog = (SIPDialog)serverTransaction.getDialog();
            String key = callId + ":" + ((SipURI)serverDialog.getRemoteParty().getURI()).getUser();
            ((V2StateMachine)this.v2StateMachine.get()).onCancelUpdate(serverDialog, key, fromUser, toUser);
        } else {
            this.releaseTerminatedDialog(callId, fromUser, toUser);
        }
        this.handleBLF(fromUser, toUser, callId);
    }

    private void handleByeRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleByeRequest";
        ServerTransaction serverTransaction = null;
        Request request = requestEvent.getRequest();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        SIPDialog clientDialog = null;
        SIPDialog serverDialog = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            serverTransaction = requestEvent.getServerTransaction();
            Request byeRequest = (Request)request.clone();
            byeRequest = this.handleCseqInRequest(requestEvent, byeRequest);
            byeRequest = this.helperIMS.removeRouteHeaders(byeRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(byeRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            byeRequest = this.updateIpPortInRequestURI(byeRequest, listeningTransport);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            viaHeader.setRPort();
            byeRequest.addFirst((Header)viaHeader);
            byeRequest.removeHeader("Authorization");
            byeRequest.removeHeader("Proxy-Authorization");
            SipProvider sipProvider = (SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport);
            if (requestEvent.getDialog() != null && requestEvent.getDialog().getApplicationData() != null) {
                clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
                clientDialog.setSipProvider((SipProviderImpl)sipProvider);
                ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(byeRequest);
                clientTransaction.setApplicationData((Object)serverTransaction);
                clientDialog.sendRequest(clientTransaction);
                if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && Constants.V2STATE_MACHINE.booleanValue()) {
                    SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onByeUpdate(dialog, fromRegistrar, fromUser, toUser);
                } else if (Constants.V2STATE_MACHINE.booleanValue()) {
                    serverDialog = (SIPDialog)serverTransaction.getDialog();
                    String key = callId + ":" + ((SipURI)serverDialog.getRemoteParty().getURI()).getUser();
                    ((V2StateMachine)this.v2StateMachine.get()).onByeUpdate(serverDialog, key, fromUser, toUser);
                }
            } else {
                sipProvider.sendRequest(byeRequest);
            }
            this.helperIMS.printRequestLog(this.className, functionName, "Send", byeRequest, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("Error in handleByeRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)e.getLocalizedMessage(), (Object)e);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
        if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
            this.handleBLF(fromUser, toUser, ((CallIdHeader)request.getHeader("Call-ID")).getCallId());
        } else if (clientDialog != null && serverDialog != null) {
            this.handleBLF(fromUser, toUser, ((CallIdHeader)request.getHeader("Call-ID")).getCallId());
        }
    }

    private void handleAckRequest(RequestEvent requestEvent) {
        String functionName = "handleAckRequest";
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            Request request = requestEvent.getRequest();
            String proxyRequest = ((RequestEventExt)requestEvent).getRemoteIpAddress() + ":" + ((RequestEventExt)requestEvent).getRemotePort();
            boolean fromRegistrar = proxyRequest.equalsIgnoreCase(routeViaIP + ":" + routeViaPort);
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request ackRequest = (Request)request.clone();
            ackRequest = this.helperIMS.removeRouteHeaders(ackRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(ackRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            ackRequest = this.updateIpPortInRequestURI(ackRequest, listeningTransport);
            this.helperIMS.handleContactForNAT(ackRequest, null, remoteIpAddress, remotePort, "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            viaHeader.setRPort();
            ackRequest.addFirst((Header)viaHeader);
            if (!Constants.IMSV2SERVER_ROUTE.equals("SBC")) {
                if (requestEvent.getDialog() == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "No associated Dialog is found for callId:" + callId + " .Dropping the Ack Request: \n" + ackRequest);
                    return;
                }
                SIPDialog clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
                clientDialog.sendAck(ackRequest);
            } else if (!fromRegistrar) {
                SIPDialog clientDialog;
                if (requestEvent.getDialog() != null && requestEvent.getDialog().getApplicationData() != null) {
                    clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
                    clientDialog.setSipProvider((SipProviderImpl)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport));
                    if (clientDialog.getLastTransaction() != null && clientDialog.getLastTransaction().getApplicationData() != null) {
                        SIPTransaction lastServerTransaction = (SIPTransaction)clientDialog.getLastTransaction().getApplicationData();
                        if (lastServerTransaction instanceof SIPServerTransaction && serverTransaction != null) {
                            ((SIPDialog)lastServerTransaction.getDialog()).handleAck((SIPServerTransaction)serverTransaction);
                        } else {
                            SIPRequest ackSipRequest = (SIPRequest)request;
                            SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
                            SIPServerTransaction ackServerTransaction = sipStackImpl.findPendingTransaction(ackSipRequest.getTransactionId());
                            if (lastServerTransaction instanceof SIPServerTransaction && ackServerTransaction != null) {
                                ((SIPDialog)lastServerTransaction.getDialog()).handleAck(ackServerTransaction);
                            }
                            this.helperIMS.printRequestLog(this.className, functionName, "Send", ackRequest, null, fromUser, toUser);
                        }
                    }
                }
                clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
                clientDialog.setSipProvider((SipProviderImpl)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport));
                clientDialog.sendAck(ackRequest);
            } else {
                SIPDialog clientDialog = (SIPDialog)requestEvent.getDialog();
                if (clientDialog != null && clientDialog.getLastTransaction() != null && clientDialog.getLastTransaction().getApplicationData() != null) {
                    SIPTransaction clientTransactionDialog = (SIPTransaction)clientDialog.getLastTransaction().getApplicationData();
                    ((SIPDialog)clientTransactionDialog.getDialog()).setSipProvider((SipProviderImpl)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport));
                    if (((SIPDialog)clientTransactionDialog.getDialog()).getSipProvider().getListeningPoint().getTransport().equalsIgnoreCase(listeningTransport)) {
                        clientTransactionDialog.getDialog().sendAck(ackRequest);
                        this.helperIMS.printRequestLog(this.className, functionName, "Send", ackRequest, null, fromUser, toUser);
                        return;
                    }
                }
                ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + listeningTransport)).sendRequest(ackRequest);
            }
            this.helperIMS.printRequestLog(this.className, functionName, "Send", ackRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleAckRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleSubscribeRequest(RequestEvent requestEvent) {
        String functionName = "handleSubscribeRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            ServerTransaction serverTransaction = null;
            serverTransaction = requestEvent.getServerTransaction();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String event = ((EventHeader)request.getHeader("Event")).getEventType();
            if (Constants.V2STATE_MACHINE.booleanValue() && this.imsV2Subscriptions.isPresent()) {
                if (this.helperIMS.getExtensionMap().containsKey(fromUser) && this.helperIMS.getExtensionMap().containsKey(toUser)) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Sending the SubscribeRequest to IMSV2Subscription class for callId: " + callId);
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).processRequest(requestEvent);
                } else {
                    if (serverTransaction == null) {
                        this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                        serverTransaction = sipProvider.getNewServerTransaction(request);
                    }
                    this.sendUnauthorizedResponse(request, serverTransaction, 404, "Users Not found in Memory", functionName + ":" + callId);
                    serverTransaction.terminate();
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "From and To users not found in our memory. Dropping the Susbcribe Request: \n" + request);
                }
            } else {
                if (serverTransaction == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                    serverTransaction = sipProvider.getNewServerTransaction(request);
                }
                this.sendUnauthorizedResponse(request, serverTransaction, 501, "StateMachine Not Loaded", functionName + ":" + callId);
                serverTransaction.terminate();
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "V2StateMachine is not loaded. Dropping the Susbcribe Request for callId: " + callId);
            }
        }
        catch (Exception e) {
            logger.error("Error in handleSubscribeRequest method {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleReferRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleReferRequest";
        ServerTransaction serverTransaction = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request referRequest = (Request)request.clone();
            referRequest = this.handleCseqInRequest(requestEvent, referRequest);
            referRequest = this.helperIMS.removeRouteHeaders(referRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(referRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            ReferToHeader referToHeader = (ReferToHeader)referRequest.getHeader("Refer-To");
            SipURI referToUri = (SipURI)referToHeader.getAddress().getURI();
            referToUri.setHost(listeningIp);
            referToUri.setPort(listeningPort);
            String replacesValue = referToUri.getHeader("Replaces");
            if (replacesValue == null || replacesValue.isEmpty()) {
                String encodedCallId = URLEncoder.encode(callId, StandardCharsets.UTF_8.name());
                referToHeader.setParameter("Referred-CallId", encodedCallId);
            }
            referRequest = this.updateIpPortInRequestURI(referRequest, listeningTransport);
            this.helperIMS.handleContactForNAT(referRequest, null, remoteIpAddress, remotePort, "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            referRequest.addFirst((Header)viaHeader);
            referRequest.removeHeader("Authorization");
            referRequest.removeHeader("Proxy-Authorization");
            ClientTransaction clientTransaction = ((SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport)).getNewClientTransaction(referRequest);
            clientTransaction.setApplicationData((Object)serverTransaction);
            SIPDialog clientDialog = (SIPDialog)clientTransaction.getDialog();
            if (clientDialog != null) {
                clientDialog.setSipProvider((SipProviderImpl)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport));
            }
            clientTransaction.sendRequest();
            this.helperIMS.printRequestLog(this.className, functionName, "Send", referRequest, null, fromUser, toUser);
            SIPDialog stDialog = (SIPDialog)requestEvent.getDialog();
            if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && Constants.V2STATE_MACHINE.booleanValue()) {
                SIPDialog dialog = (SIPDialog)requestEvent.getDialog();
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onReferUpdate(dialog, referToHeader, (ReferredByHeader)referRequest.getHeader("Referred-By"), fromUser, toUser);
            } else if (Constants.V2STATE_MACHINE.booleanValue()) {
                String key = callId + ":" + ((SipURI)stDialog.getRemoteParty().getURI()).getUser();
                ((V2StateMachine)this.v2StateMachine.get()).onReferUpdate(stDialog, referToHeader, (ReferredByHeader)referRequest.getHeader("Referred-By"), key, fromUser, toUser);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleReferRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            if (eventHeader != null && eventHeader.getEventType().equals("refer")) {
                this.handleReferNotifyRequest(requestEvent);
            } else {
                this.handleOtherNotifyRequest(requestEvent, fromRegistrar);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleReferNotifyRequest(RequestEvent requestEvent) {
        String functionName = "handleReferNotifyRequest";
        ServerTransaction serverTransaction = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            Request request = requestEvent.getRequest();
            serverTransaction = requestEvent.getServerTransaction();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            Request referNotifyRequest = null;
            referNotifyRequest = (Request)request.clone();
            referNotifyRequest = this.handleCseqInRequest(requestEvent, referNotifyRequest);
            referNotifyRequest = this.helperIMS.removeRouteHeaders(referNotifyRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(referNotifyRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            referNotifyRequest = this.updateIpPortInRequestURI(referNotifyRequest, listeningTransport);
            this.helperIMS.handleContactForNAT(referNotifyRequest, null, remoteIpAddress, remotePort, "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            referNotifyRequest.addFirst((Header)viaHeader);
            referNotifyRequest.removeHeader("Authorization");
            referNotifyRequest.removeHeader("Proxy-Authorization");
            SipProvider sipProvider2 = (SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport);
            ClientTransaction ct = sipProvider2.getNewClientTransaction(referNotifyRequest);
            ct.setApplicationData((Object)serverTransaction);
            SIPDialog clientDialog = (SIPDialog)ct.getDialog();
            clientDialog.setSipProvider((SipProviderImpl)sipProvider2);
            clientDialog.sendRequest(ct);
            this.helperIMS.printRequestLog(this.className, functionName, "Send", referNotifyRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleReferNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleOtherNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleOtherNotifyRequest";
        ServerTransaction serverTransaction = null;
        Request request = requestEvent.getRequest();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        SIPDialog clientDialog = null;
        Object serverDialog = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            serverTransaction = requestEvent.getServerTransaction();
            Request otherNotifyRequest = (Request)request.clone();
            otherNotifyRequest = this.handleCseqInRequest(requestEvent, otherNotifyRequest);
            otherNotifyRequest = this.helperIMS.removeRouteHeaders(otherNotifyRequest, request.getMethod() + ":" + callId);
            if (!fromRegistrar) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Returning from here for NoTify received from client.");
                return;
            }
            listeningTransport = ((RegisterUser)this.registerMap.get(toUser)).getListeningTransport();
            listeningPort = ((RegisterUser)this.registerMap.get(toUser)).getListeningPort();
            listeningIp = ((RegisterUser)this.registerMap.get(toUser)).getListeningIp();
            SipURI requestURI = (SipURI)otherNotifyRequest.getRequestURI();
            SipURI contactURI = (SipURI)this.helperIMS.getAddressFactory().createURI(((RegisterUser)this.registerMap.get(toUser)).getContact());
            requestURI.setHost(contactURI.getHost());
            requestURI.setPort(contactURI.getPort());
            requestURI.setTransportParam(listeningTransport);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Values of variables listeningIP: " + listeningIp + " listeningPort: " + listeningPort + " listeningTransport: " + listeningTransport);
            this.helperIMS.handleContactForNAT(otherNotifyRequest, null, ((RequestEventExt)requestEvent).getRemoteIpAddress(), ((RequestEventExt)requestEvent).getRemotePort(), "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            viaHeader.setRPort();
            otherNotifyRequest.addFirst((Header)viaHeader);
            otherNotifyRequest.removeHeader("Authorization");
            otherNotifyRequest.removeHeader("Proxy-Authorization");
            SipProvider sipProvider = (SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport);
            if (requestEvent.getDialog() != null && requestEvent.getDialog().getApplicationData() != null) {
                clientDialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
                clientDialog.setSipProvider((SipProviderImpl)sipProvider);
                ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(otherNotifyRequest);
                clientTransaction.setApplicationData((Object)serverTransaction);
                clientDialog.sendRequest(clientTransaction);
            } else {
                sipProvider.sendRequest(otherNotifyRequest);
            }
            this.helperIMS.printRequestLog(this.className, functionName, "Send", otherNotifyRequest, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("Error in handleOtherNotifyRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)e.getLocalizedMessage(), (Object)e);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleOptionRequest(RequestEvent requestEvent) {
        String functionName = "handleOptionRequest";
        ServerTransaction serverTransaction = null;
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            response = this.helperIMS.setUserAgentHeaderResponse(response, request.getMethod());
            serverTransaction.sendResponse(response);
            this.helperIMS.printResponseLog(this.className, functionName, "Send", response, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleOptionRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleInfoRequest(RequestEvent requestEvent) {
        String functionName = "handleInfoRequest";
        ServerTransaction serverTransaction = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request infoRequest = null;
            infoRequest = (Request)request.clone();
            infoRequest = this.handleCseqInRequest(requestEvent, infoRequest);
            infoRequest = this.helperIMS.removeRouteHeaders(infoRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(infoRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            infoRequest = this.updateIpPortInRequestURI(infoRequest, listeningTransport);
            this.helperIMS.handleContactForNAT(infoRequest, null, remoteIpAddress, remotePort, "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            infoRequest.addFirst((Header)viaHeader);
            infoRequest.removeHeader("Authorization");
            infoRequest.removeHeader("Proxy-Authorization");
            ClientTransaction ct = ((SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport)).getNewClientTransaction(infoRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            this.helperIMS.printRequestLog(this.className, functionName, "Send", infoRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleInfoRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    private void handleUpdateRequest(RequestEvent requestEvent) {
        String functionName = "handleUpdateRequest";
        ServerTransaction serverTransaction = null;
        try {
            String listeningTransport = "UDP";
            int listeningPort = Constants.LISTEN_UDP_PORT;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String remoteIpAddress = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callId);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request updateRequest = null;
            updateRequest = (Request)request.clone();
            updateRequest = this.handleCseqInRequest(requestEvent, updateRequest);
            updateRequest = this.helperIMS.removeRouteHeaders(updateRequest, request.getMethod() + ":" + callId);
            listeningTransport = this.findTransportFromRequest(updateRequest, listeningTransport);
            listeningPort = this.getPortAccordingToTransport(listeningTransport);
            updateRequest = this.updateIpPortInRequestURI(updateRequest, listeningTransport);
            this.helperIMS.handleContactForNAT(updateRequest, null, remoteIpAddress, remotePort, "request", true);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, listeningTransport, null);
            updateRequest.addFirst((Header)viaHeader);
            updateRequest.removeHeader("Authorization");
            updateRequest.removeHeader("Proxy-Authorization");
            SipProvider sipProvider2 = (SipProvider)this.helperIMS.getSipProviders().get(listeningIp + ":" + listeningTransport);
            if (requestEvent.getDialog() != null) {
                ClientTransaction ct = sipProvider2.getNewClientTransaction(updateRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                sipProvider2.sendRequest(updateRequest);
            }
            this.helperIMS.printRequestLog(this.className, functionName, "Send", updateRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleUpdateRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
            this.exceptionResponse(requestEvent, serverTransaction);
        }
    }

    public void handleIMSV2Response(ResponseEvent responseEvent) {
        String functionName = "handleIMSV2Response";
        Response response = responseEvent.getResponse();
        CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
        try {
            String methodName = cSeqHeader.getMethod();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            String remoteIp = ((ResponseEventExt)responseEvent).getRemoteIpAddress();
            int remotePort = ((ResponseEventExt)responseEvent).getRemotePort();
            String remoteIpPort = remoteIp + ":" + remotePort;
            this.helperIMS.printResponseLog(this.className, functionName, "Received", response, remoteIpPort, fromUser, toUser);
            response = this.helperIMS.setUserAgentHeaderResponse(response, methodName);
            if (response.getStatusCode() == 100) {
                return;
            }
            boolean fromRegistrar = false;
            if (this.helperIMS.isFromRegistrar(remoteIp, remotePort)) {
                fromRegistrar = true;
            }
            switch (cSeqHeader.getMethod()) {
                case "REGISTER": {
                    break;
                }
                case "INVITE": {
                    this.handleInviteResponse(responseEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    break;
                }
                case "BYE": {
                    this.handleByeResponse(responseEvent);
                    break;
                }
                case "CANCEL": {
                    break;
                }
                case "REFER": {
                    this.handleReferResponse(responseEvent);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyResponse(responseEvent);
                    break;
                }
                case "INFO": {
                    this.handleInfoResponse(responseEvent);
                    break;
                }
                case "UPDATE": {
                    this.handleUpdateResponse(responseEvent);
                    break;
                }
                default: {
                    response.removeFirst("Via");
                    if (response.getHeader("Via") == null) {
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Via Header is missing in to forward. Dropping the response \n" + response);
                        return;
                    }
                    ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + viaHeader.getTransport())).sendResponse(response);
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "In default way Send Response \n" + response);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleIMSV2Response Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleUpdateResponse(ResponseEvent responseEvent) {
        String functionName = "handleUpdateResponse";
        try {
            Response response = responseEvent.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            Response updateResponse = (Response)response.clone();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                if (clientTransaction.getApplicationData() instanceof ServerTransaction || clientTransaction.getApplicationData() instanceof SIPServerTransaction) {
                    ServerTransaction serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                    serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                    if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                        CSeqHeader cSeqHeader = (CSeqHeader)updateResponse.getHeader("CSeq");
                        cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                    }
                    updateResponse.removeFirst("Via");
                    if (updateResponse.getHeader("Via") != null) {
                        serverTransaction.sendResponse(updateResponse);
                    }
                    this.helperIMS.printResponseLog(this.className, functionName, "Send", updateResponse, null, fromUser, toUser);
                } else {
                    Dialog dialog = (Dialog)clientTransaction.getApplicationData();
                    String dialogId = dialog.getDialogId();
                    if (response.getStatusCode() >= 400) {
                        if (Constants.V2STATE_MACHINE.booleanValue()) {
                            ((V2StateMachine)this.v2StateMachine.get()).releaseDialog(callId);
                        }
                        if (this.backgroundTaskService.isPresent()) {
                            ((BackgroundTaskService)this.backgroundTaskService.get()).releaseAssociatedDialog(dialogId);
                        }
                    }
                    if (this.backgroundTaskService.isPresent()) {
                        ((BackgroundTaskService)this.backgroundTaskService.get()).dialogResponseMap.remove(dialogId);
                    }
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Through Update response released All Dialogs from State Machine and SipStack for this callid: [" + callId + "] & dialogId: [" + dialogId + "]");
                }
            } else {
                updateResponse.removeFirst("Via");
                if (updateResponse.getHeader("Via") != null) {
                    ViaHeader viaHeader = (ViaHeader)updateResponse.getHeader("Via");
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + viaHeader.getTransport())).sendResponse(updateResponse);
                    this.helperIMS.printResponseLog(this.className, functionName, "Send", updateResponse, null, fromUser, toUser);
                }
            }
        }
        catch (Exception e) {
            logger.error("handleUpdateResponse Error for call ID: {}  while {}", (Object)((CallIdHeader)responseEvent.getResponse().getHeader("Call-ID")).getCallId(), (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInfoResponse(ResponseEvent responseEvent) {
        String functionName = "handleInfoResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response infoResponse = (Response)response.clone();
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    CSeqHeader cSeqHeader = (CSeqHeader)infoResponse.getHeader("CSeq");
                    cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                }
                infoResponse.removeFirst("Via");
                if (infoResponse.getHeader("Via") != null) {
                    serverTransaction.sendResponse(infoResponse);
                }
            } else {
                infoResponse.removeFirst("Via");
                if (infoResponse.getHeader("Via") != null) {
                    ViaHeader viaHeader = (ViaHeader)infoResponse.getHeader("Via");
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + viaHeader.getTransport())).sendResponse(infoResponse);
                }
            }
            this.helperIMS.printResponseLog(this.className, functionName, "Send", infoResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleInfoResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleNotifyResponse(ResponseEvent responseEvent) {
        String functionName = "handleNotifyResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response notifyResponse = (Response)response.clone();
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    CSeqHeader cSeqHeader = (CSeqHeader)notifyResponse.getHeader("CSeq");
                    cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                }
                notifyResponse.removeFirst("Via");
                if (notifyResponse.getHeader("Via") != null) {
                    serverTransaction.sendResponse(notifyResponse);
                    this.helperIMS.printResponseLog(this.className, functionName, "Send", notifyResponse, null, fromUser, toUser);
                }
            } else {
                notifyResponse.removeFirst("Via");
                if (notifyResponse.getHeader("Via") != null) {
                    ViaHeader viaHeader = (ViaHeader)notifyResponse.getHeader("Via");
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + viaHeader.getTransport())).sendResponse(notifyResponse);
                    this.helperIMS.printResponseLog(this.className, functionName, "Send", notifyResponse, null, fromUser, toUser);
                }
            }
            this.processSubscriptionNotifyResponse(responseEvent);
        }
        catch (Exception e) {
            logger.error("handleNotifyResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleReferResponse(ResponseEvent responseEvent) {
        String functionName = "handleReferResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response referResponse = (Response)response.clone();
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    CSeqHeader cSeqHeader = (CSeqHeader)referResponse.getHeader("CSeq");
                    cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                }
                referResponse.removeFirst("Via");
                if (referResponse.getHeader("Via") != null) {
                    serverTransaction.sendResponse(referResponse);
                }
                this.helperIMS.printResponseLog(this.className, functionName, "Send", referResponse, null, fromUser, toUser);
            }
        }
        catch (Exception e) {
            logger.error("handleReferResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleByeResponse(ResponseEvent responseEvent) {
        String functionName = "handleByeResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response byeResponse = (Response)response.clone();
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    CSeqHeader cSeqHeader = (CSeqHeader)byeResponse.getHeader("CSeq");
                    cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                }
                byeResponse.removeFirst("Via");
                if (byeResponse.getHeader("Via") != null) {
                    serverTransaction.sendResponse(byeResponse);
                }
            } else {
                byeResponse.removeFirst("Via");
                if (byeResponse.getHeader("Via") != null) {
                    ViaHeader viaHeader = (ViaHeader)byeResponse.getHeader("Via");
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + viaHeader.getTransport())).sendResponse(byeResponse);
                }
            }
            this.helperIMS.printResponseLog(this.className, functionName, "Send", byeResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleByeResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteResponse(ResponseEvent responseEvent, boolean fromRegistrar) {
        String functionName = "handleInviteResponse";
        Response response = responseEvent.getResponse();
        String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
        String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
        String remoteIpAddress = ((ResponseEventExt)responseEvent).getRemoteIpAddress();
        int remotePort = ((ResponseEventExt)responseEvent).getRemotePort();
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            SIPDialog dialog = null;
            SIPDialog stDialog = null;
            Response inviteResponse = (Response)response.clone();
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                    CSeqHeader cSeqHeader = (CSeqHeader)inviteResponse.getHeader("CSeq");
                    cSeqHeader.setSeqNumber(serverTransaction.getDialog().getRemoteSeqNumber());
                }
                if (response.getStatusCode() >= 100 && response.getStatusCode() < 300) {
                    SipURI contactURI;
                    ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
                    if (contactHeader == null) {
                        contactURI = this.helperIMS.getAddressFactory().createSipURI(toUser, remoteIpAddress);
                        contactURI.setPort(remotePort);
                        contactURI.setTransportParam(viaHeader.getTransport());
                        if (fromRegistrar) {
                            contactURI.setMAddrParam(remoteIpAddress);
                        }
                        Address contactAddress = this.helperIMS.getAddressFactory().createAddress((URI)contactURI);
                        contactHeader = this.helperIMS.getHeaderFactory().createContactHeader(contactAddress);
                    } else {
                        contactURI = (SipURI)contactHeader.getAddress().getURI();
                        contactURI.setHost(remoteIpAddress);
                        contactURI.setPort(remotePort);
                        contactURI.setTransportParam(viaHeader.getTransport());
                        if (fromRegistrar) {
                            contactURI.setMAddrParam(remoteIpAddress);
                        }
                        contactHeader.getAddress().setURI((URI)contactURI);
                    }
                    if (Constants.NAT.booleanValue() && fromRegistrar) {
                        this.helperIMS.modifySDP(null, inviteResponse, "response", "IP4", Constants.PUBLIC_IP_ADDRESS);
                    }
                    inviteResponse.setHeader((Header)contactHeader);
                }
                inviteResponse.removeFirst("Via");
                if (inviteResponse.getHeader("Via") != null) {
                    serverTransaction.sendResponse(inviteResponse);
                }
                this.helperIMS.printResponseLog(this.className, functionName, "Send", inviteResponse, null, fromUser, toUser);
                dialog = (SIPDialog)responseEvent.getDialog();
                stDialog = (SIPDialog)serverTransaction.getDialog();
                if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && Constants.V2STATE_MACHINE.booleanValue()) {
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).updateResponse(dialog, fromRegistrar, fromUser, toUser);
                } else if (Constants.V2STATE_MACHINE.booleanValue()) {
                    String key = callId + ":" + ((SipURI)dialog.getRemoteParty().getURI()).getUser();
                    String key2 = callId + ":" + ((SipURI)stDialog.getRemoteParty().getURI()).getUser();
                    ((V2StateMachine)this.v2StateMachine.get()).updateResponse(dialog, key, fromUser, toUser);
                    ((V2StateMachine)this.v2StateMachine.get()).updateResponse(stDialog, key2, fromUser, toUser);
                }
            }
            if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                this.handleBLF(fromUser, toUser, ((CallIdHeader)response.getHeader("Call-ID")).getCallId());
            } else if (dialog != null && stDialog != null) {
                this.handleBLF(((SipURI)dialog.getRemoteParty().getURI()).getUser(), ((SipURI)stDialog.getRemoteParty().getURI()).getUser(), ((CallIdHeader)response.getHeader("Call-ID")).getCallId());
            }
        }
        catch (Exception e) {
            logger.error("handleInviteResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendUnauthorizedResponse(Request request, ServerTransaction serverTransaction, int statusCode, String reasonPhrase, String receivedFromMethod) {
        String functionName = "sendUnauthorizedResponse";
        try {
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Recceived From: " + receivedFromMethod + " with params -> fromUser: " + fromUser + " toUser: " + toUser + " statusCode: " + statusCode + " reasonPhrase: " + reasonPhrase);
            if (reasonPhrase != null) {
                reasonPhrase.toUpperCase();
            }
            Response response = null;
            switch (statusCode) {
                case 401: {
                    response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                    WWWAuthenticateHeader wwwAuthenticateHeader = this.helperIMS.getHeaderFactory().createWWWAuthenticateHeader("Digest");
                    wwwAuthenticateHeader.setRealm(Constants.LISTEN_IP_ADDRESS);
                    wwwAuthenticateHeader.setNonce(ImsV2ServerIMS.generateNonce());
                    response.setHeader((Header)wwwAuthenticateHeader);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 403: {
                    response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 404: {
                    response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 407: {
                    response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                    ProxyAuthenticateHeader proxyAuthenticateHeader = this.helperIMS.getHeaderFactory().createProxyAuthenticateHeader("Digest");
                    proxyAuthenticateHeader.setRealm(Constants.LISTEN_IP_ADDRESS);
                    proxyAuthenticateHeader.setNonce(ImsV2ServerIMS.generateNonce());
                    response.setHeader((Header)proxyAuthenticateHeader);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 480: {
                    response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                    if (reasonPhrase != null) {
                        response.setReasonPhrase(reasonPhrase);
                    }
                    Header X_kemfailure_cause = this.helperIMS.getHeaderFactory().createHeader("X-kemfailure_cause", "USER_NOT_REGISTERED");
                    response.addHeader(X_kemfailure_cause);
                    break;
                }
                case 500: {
                    response = this.helperIMS.getMessageFactory().createResponse(500, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 400: {
                    response = this.helperIMS.getMessageFactory().createResponse(400, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 503: {
                    response = this.helperIMS.getMessageFactory().createResponse(503, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                case 501: {
                    response = this.helperIMS.getMessageFactory().createResponse(501, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                    break;
                }
                default: {
                    if (statusCode > 0) {
                        response = this.helperIMS.getMessageFactory().createResponse(statusCode, request);
                        if (reasonPhrase == null) break;
                        response.setReasonPhrase(reasonPhrase);
                        break;
                    }
                    response = this.helperIMS.getMessageFactory().createResponse(200, request);
                    if (reasonPhrase == null) break;
                    response.setReasonPhrase(reasonPhrase);
                }
            }
            if (serverTransaction != null) {
                serverTransaction.sendResponse(response);
            } else {
                String transport;
                String string = transport = response.getHeader("Via") != null ? ((ViaHeader)response.getHeader("Via")).getTransport() : null;
                if (transport != null) {
                    ((SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + transport)).sendResponse(response);
                }
            }
            this.helperIMS.printResponseLog(this.className, functionName, "Send", response, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("Error in sendUnauthorizedResponse Method for statusCode: {} received from {}", (Object)statusCode, (Object)receivedFromMethod, (Object)e.getMessage(), (Object)e);
        }
    }

    private int getPortAccordingToTransport(String transport) {
        transport = transport.toUpperCase();
        int port = Constants.LISTEN_UDP_PORT;
        switch (transport) {
            case "TLS": {
                port = Constants.LISTEN_TLS_PORT;
                break;
            }
            case "TCP": {
                port = Constants.LISTEN_TCP_PORT;
                break;
            }
            default: {
                port = Constants.LISTEN_UDP_PORT;
            }
        }
        return port;
    }

    private Request updateIpPortInRequestURI(Request request, String listeningTransport) {
        String functionName = "updateIpPortInRequestURI";
        try {
            if (listeningTransport.equalsIgnoreCase("UDP")) {
                return request;
            }
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            SipURI requestUri = (SipURI)request.getRequestURI();
            if (routeHeader != null) {
                SipURI routeURI = (SipURI)routeHeader.getAddress().getURI();
                String routeUser = routeURI.getUser();
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "RouteHeader: " + routeURI.toString() + " in Request: \n" + request);
                if (routeURI.getHost().equals(Constants.SIPSERVER_IP) || routeURI.getHost().equals(Constants.SIPREGISTRAR_IP) || routeURI.getHost().equals(Constants.CONFERENCING_SERVER_IP) || this.helperIMS.domainSet.contains(routeURI.getHost())) {
                    return request;
                }
                if (routeUser != null && !routeUser.isEmpty() && this.isUserRegistered(routeUser)) {
                    routeURI.setPort(((RegisterUser)this.registerMap.get(routeUser)).getRemotePort().intValue());
                    request.removeFirst("Route");
                    request.addFirst((Header)routeHeader);
                }
                return request;
            }
            this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "RequestURI: " + requestUri.toString() + " in Request: \n" + request);
            if (requestUri.getHost().equals(Constants.SIPSERVER_IP) || requestUri.getHost().equals(Constants.SIPREGISTRAR_IP) || requestUri.getHost().equals(Constants.CONFERENCING_SERVER_IP) || this.helperIMS.domainSet.contains(requestUri.getHost())) {
                return request;
            }
            if (this.registerMap.containsKey(toUser) && System.currentTimeMillis() <= ((RegisterUser)this.registerMap.get(toUser)).getExpireTime()) {
                requestUri.setHost(((RegisterUser)this.registerMap.get(toUser)).getRemoteIpAddress());
                requestUri.setPort(((RegisterUser)this.registerMap.get(toUser)).getRemotePort().intValue());
            }
            request.setRequestURI((URI)requestUri);
        }
        catch (Exception ex) {
            logger.error("Error in UpdatePortInRequest Method: {} CallId :{}, Error: {}", (Object)request.getMethod(), (Object)request.getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        return request;
    }

    private Request handleCseqInRequest(RequestEvent requestEvent, Request request) {
        if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0 && requestEvent.getDialog() != null && requestEvent.getDialog().getApplicationData() != null) {
            SIPDialog dialog = (SIPDialog)requestEvent.getDialog().getApplicationData();
            try {
                dialog.incrementLocalSequenceNumber();
                CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
                if (cSeqHeader.getSeqNumber() > dialog.getLocalSeqNumber()) {
                    dialog.setLocalSequenceNumber(cSeqHeader.getSeqNumber());
                }
                cSeqHeader.setSeqNumber(dialog.getLocalSeqNumber());
            }
            catch (Exception ex) {
                logger.error("Error in handleCseqInRequest Method: {} DialogId :{}, Error: {}", (Object)request.getMethod(), (Object)dialog.getDialogId(), (Object)ex.getLocalizedMessage(), (Object)ex);
            }
        }
        return request;
    }

    private String findTransportFromRequest(Request request, String listeningTransport) {
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (routeHeader != null) {
            SipURI routeURI = (SipURI)routeHeader.getAddress().getURI();
            if (routeURI.getPort() <= 0) {
                routeURI.setPort(5060);
            }
            String routeAddress = routeURI.getHost() + ':' + routeURI.getPort();
            if (routeURI.getTransportParam() != null) {
                listeningTransport = routeURI.getTransportParam();
            } else if (routeAddress.equalsIgnoreCase(Constants.SIPSERVER_ADDRESS)) {
                listeningTransport = Constants.SIPSERVER_TRANSPORT;
            } else if (routeAddress.equalsIgnoreCase(Constants.SIPREGISTRAR_ADDRESS)) {
                listeningTransport = Constants.SIPREGISTRAR_TRANSPORT;
            } else if (routeAddress.equalsIgnoreCase(Constants.CONFERENCESERVER_ADDRESS)) {
                listeningTransport = Constants.CONFERENCINGSERVER_TRANSPORT;
            }
        } else {
            SipURI requestSipURI = (SipURI)request.getRequestURI();
            String requestUriAddress = requestSipURI.getHost() + ":" + requestSipURI.getPort();
            if (requestSipURI.getTransportParam() != null) {
                listeningTransport = requestSipURI.getTransportParam();
            } else if (requestUriAddress.equalsIgnoreCase(Constants.SIPSERVER_ADDRESS)) {
                listeningTransport = Constants.SIPSERVER_TRANSPORT;
            } else if (requestUriAddress.equalsIgnoreCase(Constants.SIPREGISTRAR_ADDRESS)) {
                listeningTransport = Constants.SIPREGISTRAR_TRANSPORT;
            } else if (requestUriAddress.equalsIgnoreCase(Constants.CONFERENCESERVER_ADDRESS)) {
                listeningTransport = Constants.CONFERENCINGSERVER_TRANSPORT;
            }
        }
        return listeningTransport.toUpperCase();
    }

    private void exceptionResponse(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        String functionName = "exceptionResponse";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Response response = this.helperIMS.getMessageFactory().createResponse(500, requestEvent.getRequest());
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            if (serverTransaction != null) {
                serverTransaction.sendResponse(response);
            } else {
                sipProvider.sendResponse(response);
            }
            this.helperIMS.printResponseLog(this.className, functionName, "Send", response, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in exceptionResponse Method: {}  , Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void publishonRedis(String extension, int expireTime, ContactHeader contactHeader, String remoteIpAddress, int remotePort) {
        String functionName = "publishonRedis";
        try {
            if (this.imsV2ServerService.isPresent()) {
                if (!contactHeader.getAddress().isWildcard()) {
                    SipURI contactUri = (SipURI)contactHeader.getAddress().getURI();
                    ((IMSV2ServerService)this.imsV2ServerService.get()).publishRegisterationEventonRedis(extension, contactUri.getHost(), contactUri.getPort(), expireTime);
                } else {
                    ((IMSV2ServerService)this.imsV2ServerService.get()).publishRegisterationEventonRedis(extension, remoteIpAddress, remotePort, expireTime);
                }
            } else {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "ImsV2ServerService class is not loaded. Skipping the registration publishing for user :" + extension);
            }
        }
        catch (Exception ex) {
            logger.error("Error in publishonRedis Method for extension {} , Error: {}", (Object)extension, (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    public void routeVia() {
        try {
            if (Constants.IMSV2SERVER_ROUTE.length() > 0) {
                if (Constants.IMSV2SERVER_ROUTE.equals("SBC")) {
                    routeViaIP = Constants.SIPREGISTRAR_IP;
                    routeViaPort = Constants.SIPREGISTRAR_PORT;
                } else if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                    routeViaIP = Constants.SIPSERVER_IP;
                    routeViaPort = Constants.SIPSERVER_PORT;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in routeVia method {}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchInviteResponse(ProxyAuthorizationHeader proxyAuthorizationHeader, Request request) {
        String functionName = "matchInviteResponse";
        try {
            if (proxyAuthorizationHeader == null) {
                return false;
            }
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            if (!this.matchInviteLock.tryLock(2L, TimeUnit.SECONDS)) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", fromUser, toUser, "Failed to acquire matchInviteLock lock within 2 seconds for callId: " + callId);
                return false;
            }
            this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Acquired matchInviteLock lock for callId: " + callId);
            try {
                if (proxyAuthorizationHeader == null) return false;
                String authHeaderResponse = proxyAuthorizationHeader.getResponse();
                String algorithm = proxyAuthorizationHeader.getAlgorithm();
                String username = proxyAuthorizationHeader.getUsername();
                String realm = proxyAuthorizationHeader.getRealm();
                String nonce = proxyAuthorizationHeader.getNonce();
                String cnonce = proxyAuthorizationHeader.getCNonce();
                String method = request.getMethod();
                String qop = proxyAuthorizationHeader.getQop();
                URI uri = proxyAuthorizationHeader.getURI();
                String requestbody = request.getContent() != null ? String.valueOf(request.getContent()) : null;
                String noncecount = String.valueOf(proxyAuthorizationHeader.getNonceCount());
                String password = null;
                if (this.helperIMS.getExtensionMap() != null && this.helperIMS.getExtensionMap().get(username) != null && ((List)this.helperIMS.getExtensionMap().get(username)).get(2) != null) {
                    password = (String)((List)this.helperIMS.getExtensionMap().get(username)).get(2);
                }
                if (username == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "UserName in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (realm == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Realm in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (password == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Password in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (method == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "\"method\" in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (uri == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "uri in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (nonce == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Nonce in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (authHeaderResponse == null || authHeaderResponse.length() <= 0) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "AuthHeaderResponse in ProxyAuthorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                String calculatedResponse = MessageDigestAlgorithm.calculateResponse((String)algorithm, (String)username, (String)realm, (String)password, (String)nonce, (String)noncecount, (String)cnonce, (String)method, (String)uri.toString(), (String)requestbody, (String)qop);
                if (!authHeaderResponse.equals(calculatedResponse)) return false;
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                logger.error("from {} Error in matchInviteResponse  Method: {} callId: {} Error: {}", (Object)request.getMethod(), (Object)callId, (Object)e.getMessage());
                return false;
            }
            finally {
                this.matchInviteLock.unlock();
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Released matchInviteLock lock for callId: " + callId);
            }
        }
        catch (Exception e) {
            logger.error("Error in matchInviteResponse Method: {} Error: {}", (Object)request.getMethod(), (Object)e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchRegisterResponse(AuthorizationHeader authorizationHeader, Request request) {
        String functionName = "matchRegisterResponse";
        try {
            String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            if (!this.matchRegisterLock.tryLock(2L, TimeUnit.SECONDS)) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", fromUser, toUser, "Failed to acquire matchRegisterLock lock within 2 seconds for callId: " + callId);
                return false;
            }
            this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Acquired matchRegisterLock lock for callId: " + callId);
            try {
                String authHeaderResponse = authorizationHeader.getResponse();
                String algorithm = authorizationHeader.getAlgorithm();
                String username = authorizationHeader.getUsername();
                String realm = authorizationHeader.getRealm();
                String nonce = authorizationHeader.getNonce();
                String noncecount = String.valueOf(authorizationHeader.getNonceCount());
                String cnonce = authorizationHeader.getCNonce();
                String method = request.getMethod();
                URI uri = authorizationHeader.getURI();
                String qop = authorizationHeader.getQop();
                String requestbody = request.getContent() != null ? String.valueOf(request.getContent()) : null;
                String password = null;
                if (this.helperIMS.getExtensionMap() != null && this.helperIMS.getExtensionMap().get(username) != null && ((List)this.helperIMS.getExtensionMap().get(username)).get(2) != null) {
                    password = (String)((List)this.helperIMS.getExtensionMap().get(username)).get(2);
                }
                if (username == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "UserName in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (realm == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Realm in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (password == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Password in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (method == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "method in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (uri == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "uri in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (nonce == null) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "nonce in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                if (authHeaderResponse == null || authHeaderResponse.length() <= 0) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "AuthHeaderResponse in Authorization Header is null for callId:" + callId);
                    boolean bl = false;
                    return bl;
                }
                String calculatedResponse = MessageDigestAlgorithm.calculateResponse((String)algorithm, (String)username, (String)realm, (String)password, (String)nonce, (String)noncecount, (String)cnonce, (String)method, (String)uri.toString(), (String)requestbody, (String)qop);
                if (!authHeaderResponse.equals(calculatedResponse)) return false;
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                logger.error("from {} Error in matchRegisterResponse  Method: {} callId: {} Error: {}", (Object)request.getMethod(), (Object)callId, (Object)e.getMessage());
                return false;
            }
            finally {
                this.matchRegisterLock.unlock();
                this.helperIMS.printCustomLogs(this.className, functionName, "debug", fromUser, toUser, "Released matchRegisterLock lock for callId: " + callId);
            }
        }
        catch (Exception e) {
            logger.error("Error in matchRegisterResponse Method: {} Error: {}", (Object)request.getMethod(), (Object)e.getMessage());
        }
        return false;
    }

    public boolean isUserRegistered(String user) {
        if (user == null || user.length() <= 0) {
            return false;
        }
        return this.registerMap.containsKey(user) && System.currentTimeMillis() <= ((RegisterUser)this.registerMap.get(user)).getExpireTime();
    }

    public static String generateNonce() {
        SecureRandom random = new SecureRandom();
        byte[] nonceBytes = new byte[16];
        random.nextBytes(nonceBytes);
        return Base64.getEncoder().encodeToString(nonceBytes);
    }

    public void releaseblf(String callId) {
        if (!Constants.V2STATE_MACHINE.booleanValue()) {
            return;
        }
        String[] users = null;
        users = Constants.IMSV2_ROUTETO_SIPSERVER != false ? ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getUsersfromCallId(callId) : ((V2StateMachine)this.v2StateMachine.get()).getUsersfromCallId(callId);
        if (users != null) {
            this.handleBLF(users[0], users[1], callId);
        }
    }

    private void handleBLF(String fromUser, String toUser, String callId) {
        try {
            Object stateMachineObj = this.findStateMachineType();
            if (stateMachineObj == null) {
                return;
            }
            if (stateMachineObj instanceof V2StateMachine) {
                V2StateMachine sm = (V2StateMachine)stateMachineObj;
                String fromKey = callId + ":" + fromUser;
                String toKey = callId + ":" + toUser;
                String fromUserCallStatus = sm.getCallStatusFromStateMachine(fromKey);
                String toUserCallStatus = sm.getCallStatusFromStateMachine(toKey);
                if (fromUserCallStatus.equals("Call") || fromUserCallStatus.equals("Ring")) {
                    if (!sm.hasOtherConfirmCallLegs(fromUser, callId)) {
                        ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(fromUser, callId, fromUserCallStatus + " " + toUser);
                    }
                } else if (fromUserCallStatus.equals("Talk") || fromUserCallStatus.equals("Hold")) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(fromUser, callId, fromUserCallStatus + " " + toUser);
                } else if (!sm.hasOtherActiveCallLegs(fromUser, callId)) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(fromUser, callId, fromUserCallStatus);
                }
                if (toUserCallStatus.equals("Call") || toUserCallStatus.equals("Ring")) {
                    if (!sm.hasOtherConfirmCallLegs(toUser, callId)) {
                        ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(toUser, callId, fromUserCallStatus + " " + fromUser);
                    }
                } else if (toUserCallStatus.equals("Talk") || toUserCallStatus.equals("Hold")) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(toUser, callId, toUserCallStatus);
                } else if (!sm.hasOtherActiveCallLegs(toUser, callId)) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(toUser, callId, toUserCallStatus);
                }
            } else if (stateMachineObj instanceof FeatureIMSStateMachine) {
                FeatureIMSStateMachine sm = (FeatureIMSStateMachine)stateMachineObj;
                String userCallStatus = sm.getCallStatusFromStateMachine(callId);
                String[] users = sm.findCurrentUser(callId);
                if (users == null || users.length <= 0) {
                    return;
                }
                if (userCallStatus.equals("Call") || userCallStatus.equals("Ring")) {
                    if (!sm.hasOtherConfirmCallLegs(users[0], callId)) {
                        ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(users[0], callId, userCallStatus + " " + users[1]);
                    }
                } else if (userCallStatus.equals("Talk") || userCallStatus.equals("Hold")) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(users[0], callId, userCallStatus + " " + users[1]);
                } else if (!sm.hasOtherActiveCallLegs(users[0], callId)) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(users[0], callId, userCallStatus);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleBLF Method fromUser : {} , toUser :{}, callId :{} , Error: {}", (Object)fromUser, (Object)toUser, (Object)callId, (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void processSubscriptionNotifyResponse(ResponseEvent responseEvent) {
        if (this.v2StateMachine.isPresent() && this.imsV2Subscriptions.isPresent()) {
            String functionName = "processSubscriptionNotifyResponse";
            String remoteIpPort = ((ResponseEventExt)responseEvent).getRemoteIpAddress() + ":" + ((ResponseEventExt)responseEvent).getRemotePort();
            Response response = responseEvent.getResponse();
            int status = response.getStatusCode();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            long packetSequence = ((CSeqHeader)response.getHeader("CSeq")).getSeqNumber();
            this.helperIMS.printResponseLog(this.className, functionName, "Received", response, remoteIpPort, fromUser, toUser);
            if (status >= 200 && status < 300) {
                ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).updateNotify("delivered", fromUser, toUser, packetSequence, callId);
            } else if (status >= 300) {
                if (status == 408) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).updateNotify("timeout", fromUser, toUser, packetSequence, callId);
                } else if (status == 481) {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).removeV2Subscription(fromUser, toUser, callId);
                } else {
                    ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).updateNotify("error", fromUser, toUser, packetSequence, callId);
                }
            }
        }
    }

    public void releaseTerminatedDialog(String callId, String localUser, String remoteUser) {
        if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue() && this.featureIMSStateMachine.isPresent()) {
            this.IMSV2Executor.submit(() -> {
                try {
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).releaseTerminatedDialog(callId, localUser, localUser);
                    this.releaseblf(callId);
                }
                catch (Exception e) {
                    logger.error("Error while releasing Dialogs from StateMachine {}", (Throwable)e);
                }
            });
        } else if (this.v2StateMachine.isPresent()) {
            this.IMSV2Executor.submit(() -> {
                try {
                    ((V2StateMachine)this.v2StateMachine.get()).releaseDialog(callId);
                    this.releaseblf(callId);
                }
                catch (Exception e) {
                    logger.error("Error while releasing Dialogs from StateMachine {}", (Throwable)e);
                }
            });
        }
    }

    public void sendCustomNotify(String user, String type, String value) {
        String functionName = "sendCustomNotify";
        try {
            if (!this.imsV2Subscriptions.isPresent()) {
                return;
            }
            if (type.equals("registered")) {
                String callState = this.getUserCurrentStatus(user, "presence");
                ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(user, type, callState);
            } else if (type.equals("Unregistered")) {
                ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(user, type, value);
            } else if (type.equals("keypressed")) {
                ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).sendNotify(user, type, value);
            }
        }
        catch (Exception e) {
            logger.error("Error in {} for {}", (Object)functionName, (Object)e.getMessage());
        }
    }

    public String getUserCurrentStatus(String user, String eventType) {
        if (eventType.equalsIgnoreCase("dialog")) {
            if (!this.isUserRegistered(user)) {
                return "terminated: ";
            }
            Object stateMachineObj = this.findStateMachineType();
            if (stateMachineObj == null) {
                return "terminated: ";
            }
            if (stateMachineObj instanceof FeatureIMSStateMachine) {
                FeatureIMSStateMachine sm = (FeatureIMSStateMachine)stateMachineObj;
                String[] userStatus = sm.getUsers_StateAndCallId(user);
                String callState = this.helperIMS.toBlfDialogState(userStatus[0]);
                return callState + ":" + userStatus[1];
            }
            if (stateMachineObj instanceof V2StateMachine) {
                V2StateMachine sm = (V2StateMachine)stateMachineObj;
                String[] userStatus = sm.getUsers_StateAndCallId(user);
                String callState = this.helperIMS.toBlfDialogState(userStatus[0]);
                return callState + ":" + userStatus[1];
            }
            return "terminated: ";
        }
        if (eventType.equalsIgnoreCase("presence")) {
            if (!this.isUserRegistered(user)) {
                return "Unregistered";
            }
            Object stateMachineObj = this.findStateMachineType();
            if (stateMachineObj == null) {
                return "Available";
            }
            if (stateMachineObj instanceof FeatureIMSStateMachine) {
                FeatureIMSStateMachine sm = (FeatureIMSStateMachine)stateMachineObj;
                String[] userStatus = sm.getUsers_StateAndOtherUser(user);
                String callState = this.helperIMS.toBlfPresenceState(userStatus[0]);
                if (callState.equals("Available")) {
                    return callState;
                }
                return callState + " " + userStatus[1];
            }
            if (stateMachineObj instanceof V2StateMachine) {
                V2StateMachine sm = (V2StateMachine)stateMachineObj;
                String[] userStatus = sm.getUsers_StateAndOtherUser(user);
                String callState = this.helperIMS.toBlfPresenceState(userStatus[0]);
                return callState + " " + userStatus[1];
            }
            return "Available";
        }
        return "terminated: ";
    }

    public Object findStateMachineType() {
        Object stateMachineObj;
        if (!this.imsV2Subscriptions.isPresent()) {
            return null;
        }
        if (Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
            if (!this.featureIMSStateMachine.isPresent()) {
                return null;
            }
            stateMachineObj = this.featureIMSStateMachine.get();
        } else {
            if (!this.v2StateMachine.isPresent()) {
                return null;
            }
            stateMachineObj = this.v2StateMachine.get();
        }
        return stateMachineObj;
    }
}

