/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.helper.Constants;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.SipStack;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.AddressFactory;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentLengthHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.HeaderFactory;
import com.coraltele.interfaces.sip.header.MaxForwardsHeader;
import com.coraltele.interfaces.sip.header.RecordRouteHeader;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.header.UserAgentHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.MessageFactory;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.SIPDialog;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class HelperIMS {
    String className = "HelperIMS";
    private static final Logger logger = LogManager.getLogger(HelperIMS.class);
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Constants.MAX_POOL_SIZE);
    private SipProvider sipProvider;
    private String activeHAPhysicalIp;
    private String remoteHAPhysicalIp;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipStack sipStack;
    public static final ZoneId systemZone = ZoneId.systemDefault();
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
    private ReadWriteLock extensionLock = new ReentrantReadWriteLock();
    private ReadWriteLock rluLock = new ReentrantReadWriteLock();
    private ReadWriteLock inboundGatewaylock = new ReentrantReadWriteLock();
    public ConcurrentHashMap<String, List<String>> extensionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<Object>> rluMap = new ConcurrentHashMap();
    private Set<String> rluVirtualIpSet = ConcurrentHashMap.newKeySet();
    private ArrayList<String> inboundGatewayIpList = new ArrayList();
    private ConcurrentHashMap<String, SipProvider> sipProviders = new ConcurrentHashMap();
    public HashSet<String> logFilterUserSet = new HashSet();
    public HashSet<String> domainSet = new HashSet();
    public HashSet<String> validUserAgentSet = new HashSet();
    public HashSet<String> blockedUserAgentSet = new HashSet();
    public static long noOfOldDayCallback = TimeUnit.HOURS.toMillis(24L);
    public static AtomicBoolean controlIsHere = new AtomicBoolean(false);
    public static final String IPV4 = "IP4";
    public static final String IPV6 = "IP6";
    public static final String sendLog = "Send";
    public static final String receivedLog = "Received";
    public static final String debugLevel = "debug";
    public static final String infoLevel = "info";
    public static final String warnLevel = "warn";
    public static final String errorLevel = "error";
    public static final String fatalLevel = "fatal";
    public static final String trying = "trying";
    public static final String ringing = "ringing";
    public static final String confirmed = "confirmed";
    public static final String stale = "stale";
    public static final String cancelled = "cancelled";
    public static final String unavailable = "unavailable";
    public static final String declined = "declined";
    public static final String terminated = "terminated";
    public static final String early = "early";
    public static final String unregistered = "Unregistered";
    public static final String registered = "registered";
    public static final String hold = "Hold";
    public static final String available = "Available";
    public static final String call = "Call";
    public static final String talk = "Talk";
    public static final String ring = "Ring";
    public static final String initiator = "initiator";
    public static final String recipient = "recipient";
    public static final String eventPresence = "presence";
    public static final String eventDialog = "dialog";
    public static final String keypressed = "keypressed";
    public static final String on_the_phone = "On The Phone";
    public static final Set<String> VALID_ACTIVE_STATES = new HashSet<String>(Arrays.asList("trying", "ringing", "confirmed"));
    public static final Set<String> DISCONNECTED_STATES = new HashSet<String>(Arrays.asList("stale", "cancelled", "unavailable", "declined", "terminated"));

    public void addSipProvider(String ipAddress, int port, String transport, SipProvider sipProvider) {
        this.sipProviders.put(ipAddress + ":" + transport, sipProvider);
    }

    public void setExtensionMap(ConcurrentHashMap<String, List<String>> extensionMap1) {
        try {
            if (this.extensionLock.writeLock().tryLock(2L, TimeUnit.SECONDS)) {
                try {
                    this.extensionMap.clear();
                    this.extensionMap.putAll(extensionMap1);
                }
                catch (Exception e) {
                    logger.error("Error while holding lock in setExtensionMap {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
                finally {
                    this.extensionLock.writeLock().unlock();
                }
            } else {
                logger.info("Unable to get write lock in setExtensionMap method");
            }
            if (this.extensionMap.size() >= 1) {
                String keys = this.extensionMap.keySet().stream().collect(Collectors.joining(", "));
                logger.info("Extensions: {}\n", (Object)keys);
            } else {
                logger.info("Extensions List is Empty");
            }
        }
        catch (Exception e) {
            logger.error("Error in setExtensionMap {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public void setRluVirtualIpSet(Set<String> rluVirtualIpSet) {
        try {
            this.rluVirtualIpSet.clear();
            this.rluVirtualIpSet.addAll(rluVirtualIpSet);
        }
        catch (Exception e) {
            logger.error("Error in loading setRluVirtualIpSet {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public void setRluMap(ConcurrentHashMap<String, List<Object>> rluMap1) {
        try {
            if (this.rluLock.writeLock().tryLock(2L, TimeUnit.SECONDS)) {
                try {
                    this.rluMap.clear();
                    this.rluMap.putAll(rluMap1);
                }
                catch (Exception e) {
                    logger.error("Error while holding lock in setRluMap {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
                finally {
                    this.rluLock.writeLock().unlock();
                }
            } else {
                logger.info("Unable to get write lock in setRluMap method");
            }
            this.rluMap.forEach((key, value) -> logger.info("Rlu - {} & virtualIp - {}", key, value.get(0)));
            logger.info("");
        }
        catch (Exception e) {
            logger.error("Error in setRluMap {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public void setInboundGatewayIpwithSubnet(ArrayList<String> inboundGatewayEnableIpList) {
        try {
            if (this.inboundGatewaylock.writeLock().tryLock(2L, TimeUnit.SECONDS)) {
                try {
                    this.inboundGatewayIpList.clear();
                    this.inboundGatewayIpList.addAll(inboundGatewayEnableIpList);
                }
                catch (Exception e) {
                    logger.error("Error while holding lock in setInboundGatewayIpwithSubnet {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
                finally {
                    this.inboundGatewaylock.writeLock().unlock();
                }
            } else {
                logger.info("Unable to get write lock in setInboundGatewayIpwithSubnet method");
            }
            logger.info("InboundGatewayIpList are : {}\n", (Object)this.inboundGatewayIpList.toString());
        }
        catch (Exception e) {
            logger.error("Error in setInboundGatewayIpwithSubnet {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    public String getVirtualIP(String user) {
        try {
            String virtualIp;
            List rluList;
            String rluName;
            List extensionData;
            if (user == null || user.isEmpty()) {
                return null;
            }
            if (this.extensionMap.containsKey(user) && (extensionData = (List)this.extensionMap.get(user)) != null && extensionData.size() >= 1 && (rluName = (String)extensionData.get(1)) != null && rluName.length() > 0 && this.rluMap.containsKey(rluName.trim().toLowerCase()) && (rluList = (List)this.rluMap.get(rluName.trim().toLowerCase())) != null && !rluList.isEmpty() && (virtualIp = (String)rluList.get(0)) != null && !virtualIp.isEmpty()) {
                return virtualIp;
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to get VirtualIp of user: {}", (Object)user, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return null;
    }

    public boolean isFromInboundGatewayIP(String ipAddress) {
        try {
            if (this.inboundGatewayIpList == null || this.inboundGatewayIpList.isEmpty()) {
                return false;
            }
            return this.inboundGatewayIpList.stream().anyMatch(subnet -> this.isIpInSubnet(subnet, ipAddress));
        }
        catch (Exception ex) {
            logger.error("Error in isFromInboundGatewayIP Method: {} , Error: {}", (Object)ipAddress, (Object)ex.getLocalizedMessage(), (Object)ex);
            return false;
        }
    }

    private boolean isIpInSubnet(String subnet, String ipAddress) {
        try {
            SubnetUtils subnetUtils = new SubnetUtils(subnet);
            subnetUtils.setInclusiveHostCount(true);
            return subnetUtils.getInfo().isInRange(ipAddress);
        }
        catch (Exception e) {
            logger.error("Invalid subnet format: {}", (Object)subnet, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkUserType(String user, String ip) {
        try {
            if (!this.extensionLock.readLock().tryLock(2L, TimeUnit.SECONDS)) {
                logger.info("Unable to get read lock in checkUserType method");
                return false;
            }
            try {
                List userList = (List)this.extensionMap.get(user);
                if (userList == null) return false;
                if (userList.isEmpty()) return false;
                if (userList.get(3) == null) return false;
                String userType = (String)userList.get(3);
                if (Constants.SIPSERVER_ADDRESS.equals(ip) && (userType.equals("pa") || userType.equals("conference") || userType.equals("switchacd") || userType.equals("acd") || userType.equals("dialplan"))) {
                    boolean bl = true;
                    return bl;
                }
                if (Constants.CONFERENCESERVER_ADDRESS.equals(ip) && userType.equals("ec")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                logger.error("Error while in Lock in checkUserType Method -: toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
                return false;
            }
            finally {
                this.extensionLock.readLock().unlock();
            }
        }
        catch (Exception ex) {
            logger.error("Error in checkUserType Method -: toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        return false;
    }

    public boolean checkExtensionGivenType(String user, String type) {
        String functionName = "checkExtensionGivenType";
        try {
            String userType;
            List userList;
            if (type != null && user != null && !type.isEmpty() && !user.isEmpty() && (userList = (List)this.extensionMap.get(user)) != null && !userList.isEmpty() && userList.get(3) != null && (userType = (String)userList.get(3)).equalsIgnoreCase(type)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error in {} method for user {}  & type {}", (Object)functionName, (Object)user, (Object)type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isVolteVonr(String user) {
        try {
            if (!this.extensionLock.readLock().tryLock(2L, TimeUnit.SECONDS)) return false;
            try {
                List userList = (List)this.extensionMap.get(user);
                if (userList == null) return false;
                if (userList.isEmpty()) return false;
                if (userList.get(4) == null) return false;
                String subType = ((String)userList.get(4)).toLowerCase();
                if (!"volte".equals(subType)) {
                    if (!"vonr".equals(subType)) return false;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                logger.error("Error while in Lock in isVolteVonr Method - toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
                return false;
            }
            finally {
                this.extensionLock.readLock().unlock();
            }
        }
        catch (Exception ex) {
            logger.error("Error while in isVolteVonr Method - toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSgwUser(String user) {
        try {
            if (!this.extensionLock.readLock().tryLock(2L, TimeUnit.SECONDS)) return false;
            try {
                List userList = (List)this.extensionMap.get(user);
                if (userList == null) return false;
                if (userList.isEmpty()) return false;
                if (userList.get(5) == null) return false;
                if (!((String)userList.get(5)).equals("true")) return false;
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                logger.error("Error while in lock in isSgwUser Method -: toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
                return false;
            }
            finally {
                this.extensionLock.readLock().unlock();
            }
        }
        catch (Exception ex) {
            logger.error("Error in isSgwUser Method -: toUser: {} Error: {}", (Object)user, (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        return false;
    }

    public void buildUserAgentSet() {
        String[] validUserAgentArray;
        this.validUserAgentSet.add(Constants.USER_AGENT);
        this.validUserAgentSet.add("iriscloud");
        if (Constants.USERAGENTLIST == null) {
            return;
        }
        for (String arr : validUserAgentArray = Constants.USERAGENTLIST.toLowerCase().split(",")) {
            if ((arr = arr.trim()).isEmpty()) continue;
            this.validUserAgentSet.add(arr.trim());
        }
    }

    public void loadDomainSet() {
        try {
            String[] domainArray;
            this.domainSet.add("127.0.0.1");
            if (Constants.DOMAINNAMELIST == null || Constants.DOMAINNAMELIST.isEmpty()) {
                return;
            }
            for (String arr : domainArray = Constants.DOMAINNAMELIST.toLowerCase().split(",")) {
                this.domainSet.add(arr.trim());
            }
        }
        catch (Exception e) {
            logger.error("Error while loading DomainList in loadDomainList {}", (Throwable)e);
        }
    }

    public boolean isUserInMySystem(String user) {
        try {
            if (this.extensionMap.containsKey(user)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while checking user:{} from extensionMap in helperIMS {} ", (Object)user, (Object)e);
        }
        return false;
    }

    public String extractSipURIfromContact(String contact) {
        try {
            int lastidx;
            if (contact == null || contact.length() <= 0) {
                logger.info("In extractSipURIfromContact method contact is null. Returning null.");
                return null;
            }
            if (this.addressFactory != null) {
                int idx = contact.indexOf(60);
                String stringAddress = contact.substring(idx).trim();
                Address address = this.addressFactory.createAddress(stringAddress);
                SipURI sipURI = (SipURI)address.getURI();
                sipURI.removeParameter("fs_path");
                return sipURI.toString();
            }
            int idx1 = contact.indexOf("sip");
            if (idx1 == -1) {
                return null;
            }
            String updatedContact = contact.substring(idx1);
            int idx2 = updatedContact.indexOf(59);
            if (idx2 != -1) {
                updatedContact = updatedContact.substring(0, idx2);
            }
            if ((lastidx = updatedContact.lastIndexOf(62)) != -1) {
                updatedContact = updatedContact.substring(0, lastidx);
            }
            return updatedContact;
        }
        catch (Exception e) {
            logger.error("Error in extractSipURIfromContact method {}.Returning null. - > \n{}", (Object)contact, (Object)e);
            return null;
        }
    }

    public String getNextHop(Request request) {
        try {
            if (request == null) {
                return null;
            }
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            if (routeHeader != null) {
                SipURI routeUri = (SipURI)routeHeader.getAddress().getURI();
                String Ip = routeUri.getHost();
                int port = routeUri.getPort();
                if (port <= 0) {
                    port = 5060;
                }
                return Ip + ":" + port;
            }
            SipURI requestUri = (SipURI)request.getRequestURI();
            String Ip = requestUri.getHost();
            int port = requestUri.getPort();
            if (port <= 0) {
                port = 5060;
            }
            return Ip + ":" + port;
        }
        catch (Exception e) {
            logger.error("Error while finding nextHop in getNextHop method for this request \n{}. \nError is {}", (Object)request, (Object)e.getLocalizedMessage());
            return "";
        }
    }

    public boolean isValidLogUser(String user) {
        try {
            if (this.logFilterUserSet.isEmpty() || user == null || this.logFilterUserSet.contains(user)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while finding valid Log user from logfilterUserSet for {}- > {} \n{}", (Object)user, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return false;
    }

    public HashSet<String> setLogFilterForUser(String user) {
        this.logFilterUserSet.add(user);
        return new HashSet<String>(this.logFilterUserSet);
    }

    public HashSet<String> getLogFilterUserSet() {
        return new HashSet<String>(this.logFilterUserSet);
    }

    public HashSet<String> removeLogFilterForUser(String user, boolean isRemoveAll) {
        if (isRemoveAll) {
            this.logFilterUserSet.clear();
        } else {
            this.logFilterUserSet.remove(user);
        }
        return new HashSet<String>(this.logFilterUserSet);
    }

    public HashSet<String> addBlockUserAgentForUser(String user) {
        this.blockedUserAgentSet.add(user);
        return new HashSet<String>(this.blockedUserAgentSet);
    }

    public HashSet<String> removeBlockUserAgentForUser(String user, boolean isRemoveAll) {
        if (isRemoveAll) {
            this.blockedUserAgentSet.clear();
        } else {
            this.blockedUserAgentSet.remove(user);
        }
        return new HashSet<String>(this.blockedUserAgentSet);
    }

    public HashSet<String> getBlockedUserAgentSet() {
        return new HashSet<String>(this.blockedUserAgentSet);
    }

    public String getISTfromEpoch(Long epoch, TimeUnit timeUnit) {
        if (timeUnit.equals((Object)TimeUnit.MILLISECONDS)) {
            return Instant.ofEpochMilli(epoch).atZone(systemZone).toLocalDateTime().format(dateTimeFormatter).toString();
        }
        return Instant.ofEpochSecond(epoch).atZone(systemZone).toLocalDateTime().format(dateTimeFormatter).toString();
    }

    public void printRequestLog(String className, String functionName, String sendOrReceive, Request request, String remoteIpPort, String fromUser, String toUser) {
        if (this.isValidLogUser(fromUser) || this.isValidLogUser(toUser)) {
            if (sendOrReceive.equals(receivedLog)) {
                logger.info("In {}[{}] Received {} request from : {}, callId : {}\n{} ", (Object)className, (Object)functionName, (Object)request.getMethod(), (Object)remoteIpPort, (Object)((CallIdHeader)request.getHeader("Call-ID")).getCallId(), (Object)request);
            } else {
                remoteIpPort = this.getNextHop(request);
                logger.info("In {}[{}] Send {} request to : {}, callId : {}\n{} ", (Object)className, (Object)functionName, (Object)request.getMethod(), (Object)remoteIpPort, (Object)((CallIdHeader)request.getHeader("Call-ID")).getCallId(), (Object)request);
            }
        }
    }

    public void printResponseLog(String className, String functionName, String sendOrReceive, Response response, String remoteIpPort, String fromUser, String toUser) {
        if (this.isValidLogUser(fromUser) || this.isValidLogUser(toUser)) {
            if (sendOrReceive.equals(receivedLog)) {
                logger.info("In {}[{}] Received {}->{} response from : {}, callId : {}\n{} ", (Object)className, (Object)functionName, (Object)response.getStatusCode(), (Object)((CSeqHeader)response.getHeader("CSeq")).getMethod(), (Object)remoteIpPort, (Object)((CallIdHeader)response.getHeader("Call-ID")).getCallId(), (Object)response);
            } else {
                logger.info("In {}[{}] Send {} {} -> {} response for callId : {}\n{} ", (Object)className, (Object)functionName, (Object)response.getStatusCode(), (Object)response.getReasonPhrase(), (Object)((CSeqHeader)response.getHeader("CSeq")).getMethod(), (Object)((CallIdHeader)response.getHeader("Call-ID")).getCallId(), (Object)response);
            }
        }
    }

    public void printCustomLogs(String className, String functionName, String logLevel, String fromUser, String toUser, String texttoPrint) {
        if (this.isValidLogUser(fromUser) || this.isValidLogUser(toUser)) {
            if (logLevel.equals(infoLevel)) {
                logger.info("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            } else if (logLevel.equals(debugLevel)) {
                logger.debug("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            } else if (logLevel.equals(warnLevel)) {
                logger.warn("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            } else if (logLevel.equals(errorLevel)) {
                logger.error("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            } else if (logLevel.equals(fatalLevel)) {
                logger.fatal("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            } else {
                logger.info("{}[{}] {}", (Object)className, (Object)functionName, (Object)texttoPrint);
            }
        }
    }

    public void addRecordRouteHeader(Request request, String listeningIp, int listeningPort, String listeningTransport, String receivedFromMethod, String fromUser, String toUser) {
        String functionName = "addRecordRouteHeader";
        try {
            if (request == null || listeningIp == null || listeningPort <= 0 || listeningTransport == null || listeningIp.length() <= 0 || listeningTransport.length() <= 0) {
                this.printCustomLogs(this.className, functionName, infoLevel, fromUser, toUser, "Null/Empty in  ReceivedFromMethod : " + receivedFromMethod + " ListeningIpPort : " + listeningIp + ":" + listeningPort + " Listening Transport : " + listeningTransport + " Request : \n" + request);
                return;
            }
            RecordRouteHeader recordRouteHeader = (RecordRouteHeader)request.getHeader("Record-Route");
            if (recordRouteHeader == null) {
                SipURI forwardURI = this.getAddressFactory().createSipURI(null, listeningIp);
                forwardURI.setPort(listeningPort);
                forwardURI.setTransportParam(listeningTransport);
                forwardURI.setLrParam();
                Address address = this.getAddressFactory().createAddress((URI)forwardURI);
                recordRouteHeader = this.getHeaderFactory().createRecordRouteHeader(address);
                request.addFirst((Header)recordRouteHeader);
            } else if (!this.isMatchingRecordRoute(recordRouteHeader, listeningTransport)) {
                SipURI forwardURI = this.getAddressFactory().createSipURI(null, listeningIp);
                forwardURI.setPort(listeningPort);
                forwardURI.setTransportParam(listeningTransport);
                forwardURI.setLrParam();
                Address address = this.getAddressFactory().createAddress((URI)forwardURI);
                RecordRouteHeader recordRouteHeader2 = this.getHeaderFactory().createRecordRouteHeader(address);
                request.addFirst((Header)recordRouteHeader2);
            }
        }
        catch (Exception e) {
            logger.error("Error in addRecordRouteHeader Method received from {} ->{} in \n{}", (Object)receivedFromMethod, (Object)e.getMessage(), (Object)request, (Object)e);
        }
    }

    public boolean isMatchingRecordRoute(RecordRouteHeader recordRouteHeader, String transport) {
        String functionName = "isMatchingRecordRoute";
        if (recordRouteHeader == null) {
            return false;
        }
        SipURI uri = (SipURI)recordRouteHeader.getAddress().getURI();
        if (uri.getPort() <= 0) {
            uri.setPort(5060);
        }
        String recordRouteIPAddress = uri.getHost() + ":" + uri.getPort();
        int listeningPort = this.getPortAccordingToTransport(transport, "listeningPort");
        return recordRouteIPAddress.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS + ":" + listeningPort) || recordRouteIPAddress.equalsIgnoreCase(Constants.PUBLIC_IP_ADDRESS + ":" + listeningPort) || this.domainSet.contains(uri.getHost().toLowerCase());
    }

    public Request removeRouteHeaders(Request request, String receivedFromMethod) {
        String functionName = "removeRouteHeaders";
        try {
            RouteHeader routeHeader;
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            ListIterator listIterator = request.getHeaders("Route");
            while (listIterator.hasNext() && this.isMatchingRoute(routeHeader = (RouteHeader)listIterator.next(), viaHeaderTransport)) {
                request.removeFirst("Route");
                listIterator = request.getHeaders("Route");
            }
        }
        catch (Exception e) {
            logger.error("Error in removeRouteHeaders Method received from {}", (Object)receivedFromMethod, (Object)e.getMessage(), (Object)e);
        }
        return request;
    }

    public boolean isMatchingRoute(RouteHeader route, String transport) {
        String functionName = "isMatchingRoute";
        if (route == null) {
            return false;
        }
        SipURI uri = (SipURI)route.getAddress().getURI();
        if (uri.getPort() <= 0) {
            uri.setPort(5060);
        }
        String routeIPAddress = uri.getHost() + ":" + uri.getPort();
        int listeningPort = this.getPortAccordingToTransport(transport, "listeningPort");
        return routeIPAddress.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS + ":" + listeningPort) || routeIPAddress.equalsIgnoreCase(Constants.PUBLIC_IP_ADDRESS + ":" + listeningPort) || this.domainSet.contains(uri.getHost().toLowerCase()) || Constants.IMS_MODE.equals("SUBSCRIBER-SERVER") && routeIPAddress.equalsIgnoreCase(Constants.FORWARDING_IP_ADDRESS_WITH_PORT);
    }

    public int getPortAccordingToTransport(String transport, String type) {
        String functionName = "getPortAccordingToTransport";
        transport = transport.toUpperCase();
        if (type.equals("listeningPort")) {
            int port = Constants.LISTEN_UDP_PORT;
            switch (transport) {
                case "TLS": {
                    port = Constants.LISTEN_TLS_PORT;
                    break;
                }
                case "TCP": {
                    port = Constants.LISTEN_TCP_PORT;
                    break;
                }
                default: {
                    port = Constants.LISTEN_UDP_PORT;
                }
            }
            return port;
        }
        if (type.equals("sipRegistrarPort")) {
            int port = Constants.SIPREGISTRAR_PORT;
            switch (transport) {
                case "TLS": {
                    port = Constants.SIPREGISTRAR_TLSPORT;
                    break;
                }
                case "TCP": {
                    port = Constants.SIPREGISTRAR_TCPPORT;
                    break;
                }
                default: {
                    port = Constants.SIPREGISTRAR_PORT;
                }
            }
            return port;
        }
        return Constants.LISTEN_UDP_PORT;
    }

    public Request setUserAgentHeaderRequest(Request request, String calleeMethod) {
        try {
            if (Constants.IMS_MODE.equalsIgnoreCase("IMSV2-SERVER") && request.getMethod().equalsIgnoreCase("REGISTER") && request.getHeader("User-Agent") != null) {
                return request;
            }
            UserAgentHeader userAgentHeader = null;
            if (!Constants.USER_AGENT.isEmpty()) {
                ArrayList<String> productList = new ArrayList<String>();
                productList.add(Constants.USER_AGENT);
                userAgentHeader = this.headerFactory.createUserAgentHeader(productList);
                request.setHeader((Header)userAgentHeader);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in setUserAgentHeaderRequest Method: {} Error: {}", (Object)calleeMethod, (Object)request.getMethod(), (Object)e.getMessage());
        }
        return request;
    }

    public Response setUserAgentHeaderResponse(Response response, String calleeMethod) {
        String functionName = "setUserAgentHeaderResponse";
        try {
            if (!Constants.USER_AGENT.isEmpty()) {
                ArrayList<String> productList = new ArrayList<String>();
                productList.add(Constants.USER_AGENT);
                UserAgentHeader userAgentHeader = this.headerFactory.createUserAgentHeader(productList);
                response.setHeader((Header)userAgentHeader);
            }
        }
        catch (Exception e) {
            logger.error("from {} Error in setUserAgentHeaderResponse Method: {} Error: {}", (Object)calleeMethod, (Object)response.getStatusCode(), (Object)e.getMessage());
        }
        return response;
    }

    public Request handleMaxForwardheader(Request request, String method) {
        String functionName = "handleMaxForwardHeader";
        try {
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)request.getHeader("Max-Forwards");
            if (maxForwardsHeader == null) {
                maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
            }
            maxForwardsHeader.decrementMaxForwards();
            request.setHeader((Header)maxForwardsHeader);
        }
        catch (Exception e) {
            logger.error(" Error while trying to decrease maxForward in handleMaxForwardheader Method: {} -> {}", (Object)method, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return request;
    }

    public Request addReceivedParamInViaHeader(Request request, String method, String proxyIP) {
        String functionName = "addReceiveParamInViaHeader";
        try {
            ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
            viaHeader.setReceived(proxyIP);
        }
        catch (Exception e) {
            logger.error(" Error while trying to add received param in Via Header in addReceivedParamInViaHeader Method: {} -> {}", (Object)method, (Object)e.getLocalizedMessage(), (Object)e);
        }
        return request;
    }

    public boolean checkLoopInRequest(Request request, String remoteIpPort, String callId, String method, String fromUser, String toUser) {
        int viaPort;
        String functionName = "CheckLoopInRequest";
        this.printCustomLogs(this.className, functionName, debugLevel, fromUser, toUser, "Received: " + method + " callid: " + callId);
        if (remoteIpPort.equalsIgnoreCase(Constants.LISTENING_UDPADDRESS) || remoteIpPort.equalsIgnoreCase(Constants.LISTENING_TCPADDRESS) || remoteIpPort.equalsIgnoreCase(Constants.LISTENING_TLSADDRESS)) {
            this.printCustomLogs(this.className, functionName, infoLevel, fromUser, toUser, "Returning TRUE for: " + method + " callid: " + callId);
            return true;
        }
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        String transport = viaHeader.getTransport() != null ? viaHeader.getTransport() : "UDP";
        int listeningPort = this.getPortAccordingToTransport(transport, "listeningPort");
        int n = viaPort = viaHeader.getPort() <= 0 ? 5060 : viaHeader.getPort();
        if ((viaHeader.getHost() + ":" + viaPort).equals(Constants.LISTEN_IP_ADDRESS + ":" + listeningPort) || this.domainSet.contains(viaHeader.getHost()) && viaPort == listeningPort) {
            this.printCustomLogs(this.className, functionName, infoLevel, fromUser, toUser, "Returning TRUE for: " + method + " callid: " + callId);
            return true;
        }
        return false;
    }

    public boolean isFromRegistrar(String remoteIP, int remotePort) {
        return remoteIP.equals(Constants.SIPREGISTRAR_IP) || remoteIP.equals(Constants.SIPSERVER_IP) || remoteIP.equals(Constants.CONFERENCING_SERVER_IP) || remoteIP.equals(Constants.PUBLIC_IP_ADDRESS) || this.domainSet.contains(remoteIP);
    }

    public void handleContactForNAT(Request request, Response response, String proxyIP, int proxyPort, String type, boolean updateExisting) {
        block15: {
            String functionName = "handleContactForNAT";
            if (type.equals("request") && request != null) {
                try {
                    String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
                    String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
                    ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
                    if (contactHeader == null) {
                        SipURI contactUri = this.addressFactory.createSipURI(fromUser, proxyIP);
                        contactUri.setPort(proxyPort);
                        contactUri.setTransportParam(viaHeaderTransport);
                        Address contactAddress = this.addressFactory.createAddress((URI)contactUri);
                        contactHeader = this.headerFactory.createContactHeader(contactAddress);
                        request.addHeader((Header)contactHeader);
                        break block15;
                    }
                    if (contactHeader.getAddress().isWildcard()) {
                        SipURI contactUri = this.addressFactory.createSipURI(fromUser, proxyIP);
                        contactUri.setPort(proxyPort);
                        contactUri.setTransportParam(viaHeaderTransport);
                        Address contactAddress = this.addressFactory.createAddress((URI)contactUri);
                        contactHeader = this.headerFactory.createContactHeader(contactAddress);
                    } else if (updateExisting) {
                        SipURI contactUri = (SipURI)contactHeader.getAddress().getURI();
                        contactUri.setHost(proxyIP);
                        contactUri.setPort(proxyPort);
                        contactUri.setTransportParam(viaHeaderTransport);
                    }
                    request.setHeader((Header)contactHeader);
                }
                catch (Exception e) {
                    logger.error("Error while changing contact in request in handleContactForNAT method for request {},{}", (Object)request, (Object)e);
                }
            } else if (type.equals("response") && response != null) {
                try {
                    String viaHeaderTransport = ((ViaHeader)response.getHeader("Via")).getTransport().toUpperCase();
                    ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
                    if (contactHeader == null) {
                        SipURI contactUri = this.addressFactory.createSipURI(null, proxyIP);
                        contactUri.setPort(proxyPort);
                        contactUri.setTransportParam(viaHeaderTransport);
                        Address contactAddress = this.addressFactory.createAddress((URI)contactUri);
                        contactHeader = this.headerFactory.createContactHeader(contactAddress);
                        response.addHeader((Header)contactHeader);
                    } else {
                        if (contactHeader.getAddress().isWildcard()) {
                            SipURI contactUri = this.addressFactory.createSipURI(null, proxyIP);
                            contactUri.setPort(proxyPort);
                            contactUri.setTransportParam(viaHeaderTransport);
                            Address contactAddress = this.addressFactory.createAddress((URI)contactUri);
                            contactHeader = this.headerFactory.createContactHeader(contactAddress);
                        } else {
                            SipURI contactUri = (SipURI)contactHeader.getAddress().getURI();
                            contactUri.setHost(proxyIP);
                            contactUri.setPort(proxyPort);
                            contactUri.setTransportParam(viaHeaderTransport);
                        }
                        response.setHeader((Header)contactHeader);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while changing contact in response in handleContactForNAT method for response {}, {}", (Object)response, (Object)e);
                }
            }
        }
    }

    public void modifySDP(Request request, Response response, String type, String ipVersion, String newIp) {
        String functionName = "modifySDP";
        if (type.equals("request") && request != null) {
            try {
                byte[] content;
                int contentLength;
                ContentLengthHeader contentLengthHeader = (ContentLengthHeader)request.getHeader("Content-Length");
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
                if (contentTypeHeader == null) {
                    contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                }
                if (contentLengthHeader != null && (contentLength = contentLengthHeader.getContentLength()) > 0 && (content = request.getRawContent()) != null) {
                    String sdpContent = new String(content);
                    sdpContent = sdpContent.replaceAll("o=(\\S+) (\\S+) (\\S+) IN \\S+ \\S+", "o=$1 $2 $3 IN " + ipVersion + " " + newIp);
                    sdpContent = sdpContent.replaceAll("c=IN \\S+ \\S+", "c=IN " + ipVersion + " " + newIp);
                    request.setContent((Object)sdpContent, contentTypeHeader);
                    ContentLengthHeader newContentLengthHeader = this.headerFactory.createContentLengthHeader(sdpContent.length());
                    request.setHeader((Header)newContentLengthHeader);
                }
            }
            catch (Exception e) {
                logger.error("Error while changing sdp in request in modifySDP method for request {},{}", (Object)request, (Object)e);
            }
        } else if (type.equals("response") && response != null) {
            try {
                byte[] content;
                int contentLength;
                ContentLengthHeader contentLengthHeader = (ContentLengthHeader)response.getHeader("Content-Length");
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)response.getHeader("Content-Type");
                if (contentTypeHeader == null) {
                    contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
                }
                if (contentLengthHeader != null && (contentLength = contentLengthHeader.getContentLength()) > 0 && (content = response.getRawContent()) != null) {
                    String sdpContent = new String(content);
                    sdpContent = sdpContent.replaceAll("o=(\\S+) (\\S+) (\\S+) IN \\S+ \\S+", "o=$1 $2 $3 IN " + ipVersion + " " + newIp);
                    sdpContent = sdpContent.replaceAll("c=IN \\S+ \\S+", "c=IN " + ipVersion + " " + newIp);
                    response.setContent((Object)sdpContent, contentTypeHeader);
                    ContentLengthHeader newContentLengthHeader = this.headerFactory.createContentLengthHeader(sdpContent.length());
                    response.setHeader((Header)newContentLengthHeader);
                }
            }
            catch (Exception e) {
                logger.error("Error while changing sdp in response in modifySDP method for response {},{}", (Object)request, (Object)e);
            }
        }
    }

    public void deleteSipStackDialog(String callId, String fromTag, String toTag) {
        String functionName = "deleteSipStackDialog";
        if (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER")) {
            return;
        }
        this.scheduler.schedule(() -> {
            SipStackImpl sipStackImpl = (SipStackImpl)this.getSipStack();
            if (fromTag == null || toTag == null || fromTag.isEmpty() || toTag.isEmpty()) {
                sipStackImpl.getDialogs().forEach(dialog -> {
                    if (dialog.getCallId().getCallId().equals(callId)) {
                        this.printCustomLogs(this.className, functionName, infoLevel, ((SipURI)dialog.getLocalParty().getURI()).getUser(), ((SipURI)dialog.getRemoteParty().getURI()).getUser(), "Forcefully deleted dialog from sipStack dialogId: " + dialog.getDialogId());
                        dialog.delete();
                    }
                });
            } else {
                String dialogId1 = callId + ":" + fromTag + ":" + toTag;
                String dialogId2 = callId + ":" + toTag + ":" + fromTag;
                if (sipStackImpl != null) {
                    SIPDialog sipDialog1 = sipStackImpl.getDialog(dialogId1);
                    SIPDialog sipDialog2 = sipStackImpl.getDialog(dialogId2);
                    if (sipDialog1 != null) {
                        this.printCustomLogs(this.className, functionName, infoLevel, ((SipURI)sipDialog1.getLocalParty().getURI()).getUser(), ((SipURI)sipDialog1.getRemoteParty().getURI()).getUser(), "Forcefully deleted dialog from sipStack dialogId: " + sipDialog1.getDialogId());
                        sipDialog1.delete();
                    }
                    if (sipDialog2 != null) {
                        this.printCustomLogs(this.className, functionName, infoLevel, ((SipURI)sipDialog2.getLocalParty().getURI()).getUser(), ((SipURI)sipDialog2.getRemoteParty().getURI()).getUser(), "Forcefully deleted dialog from sipStack dialogId: " + sipDialog2.getDialogId());
                        sipDialog2.delete();
                    }
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void setNoOfOldDaysCallBack(int noOfDays) {
        if (noOfDays < 1) {
            noOfDays = 1;
        }
        noOfOldDayCallback = TimeUnit.HOURS.toMillis(noOfDays * 24);
    }

    public String toBlfPresenceState(String state) {
        String presenceState = available;
        switch (state) {
            case "trying": {
                presenceState = call;
                break;
            }
            case "early": {
                presenceState = call;
                break;
            }
            case "ringing": {
                presenceState = call;
                break;
            }
            case "confirmed": {
                presenceState = talk;
                break;
            }
            case "Hold": {
                presenceState = hold;
                break;
            }
            default: {
                presenceState = available;
            }
        }
        return presenceState;
    }

    public String toBlfDialogState(String state) {
        String dialogState = terminated;
        switch (state) {
            case "trying": {
                dialogState = early;
                break;
            }
            case "early": {
                dialogState = early;
                break;
            }
            case "ringing": {
                dialogState = early;
                break;
            }
            case "confirmed": {
                dialogState = confirmed;
                break;
            }
            default: {
                dialogState = terminated;
            }
        }
        return dialogState;
    }

    public String presenceToDialogEventCallState(String callState) {
        callState = callState.contains(hold) || callState.contains(talk) ? confirmed : (callState.contains(call) || callState.contains(ring) ? early : terminated);
        return callState;
    }

    public String getUnrecognizedHeaderValue(Request request, String headerName, String callingMethod) {
        String functionName = "getUnrecognizedHeaderValue";
        String headerValue = "alert-internal";
        try {
            if (request != null && headerName != null && !headerName.isEmpty()) {
                ListIterator unrecognizedHeaderList = request.getUnrecognizedHeaders();
                while (unrecognizedHeaderList.hasNext()) {
                    String header = (String)unrecognizedHeaderList.next();
                    if (header == null || header.isEmpty() || !header.contains(headerName)) continue;
                    headerValue = header.split(":", -1)[1].trim();
                    return headerValue;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in {} method \n {}", (Object)functionName, (Object)e);
        }
        return headerValue;
    }

    public void fetchAndSetMasterHostname() {
        try {
            String MASTER_HOSTNAME_API_URL = "http://" + Constants.LISTEN_IP_ADDRESS + "/hostname";
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.getForEntity(MASTER_HOSTNAME_API_URL, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                Constants.MASTER_HOSTNAME = ((String)response.getBody()).trim();
            }
        }
        catch (Exception e) {
            logger.warn("Exception while fetching Master hostname from API");
        }
    }

    public String getClassName() {
        return this.className;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public SipProvider getSipProvider() {
        return this.sipProvider;
    }

    public String getActiveHAPhysicalIp() {
        return this.activeHAPhysicalIp;
    }

    public String getRemoteHAPhysicalIp() {
        return this.remoteHAPhysicalIp;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public ReadWriteLock getExtensionLock() {
        return this.extensionLock;
    }

    public ReadWriteLock getRluLock() {
        return this.rluLock;
    }

    public ReadWriteLock getInboundGatewaylock() {
        return this.inboundGatewaylock;
    }

    public ConcurrentHashMap<String, List<String>> getExtensionMap() {
        return this.extensionMap;
    }

    public ConcurrentHashMap<String, List<Object>> getRluMap() {
        return this.rluMap;
    }

    public Set<String> getRluVirtualIpSet() {
        return this.rluVirtualIpSet;
    }

    public ArrayList<String> getInboundGatewayIpList() {
        return this.inboundGatewayIpList;
    }

    public ConcurrentHashMap<String, SipProvider> getSipProviders() {
        return this.sipProviders;
    }

    public HashSet<String> getDomainSet() {
        return this.domainSet;
    }

    public HashSet<String> getValidUserAgentSet() {
        return this.validUserAgentSet;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void setSipProvider(SipProvider sipProvider) {
        this.sipProvider = sipProvider;
    }

    public void setActiveHAPhysicalIp(String activeHAPhysicalIp) {
        this.activeHAPhysicalIp = activeHAPhysicalIp;
    }

    public void setRemoteHAPhysicalIp(String remoteHAPhysicalIp) {
        this.remoteHAPhysicalIp = remoteHAPhysicalIp;
    }

    public void setAddressFactory(AddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    public void setHeaderFactory(HeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public void setExtensionLock(ReadWriteLock extensionLock) {
        this.extensionLock = extensionLock;
    }

    public void setRluLock(ReadWriteLock rluLock) {
        this.rluLock = rluLock;
    }

    public void setInboundGatewaylock(ReadWriteLock inboundGatewaylock) {
        this.inboundGatewaylock = inboundGatewaylock;
    }

    public void setInboundGatewayIpList(ArrayList<String> inboundGatewayIpList) {
        this.inboundGatewayIpList = inboundGatewayIpList;
    }

    public void setSipProviders(ConcurrentHashMap<String, SipProvider> sipProviders) {
        this.sipProviders = sipProviders;
    }

    public void setLogFilterUserSet(HashSet<String> logFilterUserSet) {
        this.logFilterUserSet = logFilterUserSet;
    }

    public void setDomainSet(HashSet<String> domainSet) {
        this.domainSet = domainSet;
    }

    public void setValidUserAgentSet(HashSet<String> validUserAgentSet) {
        this.validUserAgentSet = validUserAgentSet;
    }

    public void setBlockedUserAgentSet(HashSet<String> blockedUserAgentSet) {
        this.blockedUserAgentSet = blockedUserAgentSet;
    }
}

