/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableV2StateMachine;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMS;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.ImsV2ServerIMS;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentLengthHeader;
import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.interfaces.sip.header.ReferToHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.header.extensions.ReferredByHeader;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.model.CallbackObject;
import com.coraltele.model.StateDialog;
import com.coraltele.service.FeatureIMSService;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Conditional(value={EnableV2StateMachine.class})
public class FeatureIMSStateMachine {
    private static final Logger logger = LogManager.getLogger(FeatureIMSStateMachine.class);
    private static String className = "FeatureIMSStateMachine";
    @Autowired
    private HelperIMS helperIMS;
    @Autowired(required=false)
    private FeatureIMS featureIMS;
    @Autowired(required=false)
    private ImsV2ServerIMS imsV2ServerIMS;
    @Autowired(required=false)
    private FeatureIMSService featureIMSService;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Constants.MAX_POOL_SIZE);
    private ScheduledExecutorService releaseScheduler = Executors.newScheduledThreadPool(Constants.MAX_POOL_SIZE);
    private ConcurrentHashMap<String, StateDialog> stateMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> linkKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> associateKeyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentSkipListSet<String>> userMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> backwardcallbackMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> forwardcallbackMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentSkipListSet<CallbackObject>> callbackMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Boolean> callbackInProgress = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> mediaTypeMap = new ConcurrentHashMap();
    private static final int MAX_RETRIES = 2;
    private static final long LOCK_RETRY_DELAY_MS = 50L;

    @Scheduled(fixedDelay=10000L)
    public void RemoveCallBackafter24Hours() {
        String functionName = "RemoveCallBackafter24Hours";
        try {
            AtomicInteger removedCount = new AtomicInteger();
            long now = System.currentTimeMillis();
            this.callbackMap.forEach((user, set) -> {
                List expiredList = set.stream().filter(cbObject -> now - cbObject.getEpoch() > HelperIMS.noOfOldDayCallback).collect(Collectors.toList());
                for (CallbackObject cbo : expiredList) {
                    String fromUser = cbo.getFromUser();
                    String toUser = cbo.getToUser();
                    this.removeFromCallBackMapWithTime(fromUser, toUser);
                    this.removeFromCallBackMapWithTime(toUser, fromUser);
                    set.remove(cbo);
                    removedCount.incrementAndGet();
                }
                if (set.isEmpty()) {
                    this.callbackMap.remove(user);
                }
            });
            if (removedCount.get() > 0) {
                this.helperIMS.printCustomLogs(className, functionName, "info", null, null, "Removed " + removedCount.get() + " callbacks after " + TimeUnit.MILLISECONDS.toHours(HelperIMS.noOfOldDayCallback) + " hours");
            }
        }
        catch (Exception e) {
            logger.error("error while removing callback from {} method {} ", (Object)functionName, (Object)e.getMessage());
        }
    }

    public void onInviteUpdate(SIPDialog inviteDialog, boolean fromRegistrar, String receivedFromUser, String receivedToUser) {
        String functionName = "onInviteUpdate";
        try {
            Request request;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved INVITE dialog for DialogCallId: " + inviteDialog.getCallId().getCallId() + " fromRegistrar: " + fromRegistrar + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Long epochMillis = System.currentTimeMillis();
            CallIdHeader callIdHeader = inviteDialog.getCallId();
            String callID = callIdHeader.getCallId();
            Address toHeader = inviteDialog.getLocalParty();
            Address fromHeader = inviteDialog.getRemoteParty();
            SipURI fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
            SipURI toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
            String fromUser = fromURI != null ? fromURI.getUser() : null;
            String toUser = toURI != null ? toURI.getUser() : null;
            long cSeqNumber = inviteDialog.getRemoteSeqNumber();
            String fromTag = inviteDialog.getRemoteTag();
            String toTag = inviteDialog.getLocalTag();
            Request request2 = request = inviteDialog.getLastTransaction() != null ? inviteDialog.getLastTransaction().getRequest() : null;
            if (request == null || request.getRequestURI() == null) {
                this.helperIMS.printCustomLogs(className, functionName, "error", fromUser, toUser, "Request or RequestURI is null for callId: " + callID);
                return;
            }
            Address contactHeader = ((ContactHeader)request.getHeader("Contact")).getAddress();
            SipURI requestUri = (SipURI)request.getRequestURI();
            ReferredByHeader referredByHeader = (ReferredByHeader)request.getHeader("Referred-By");
            String linkCallId = Optional.ofNullable((ExtensionHeader)request.getHeader("X-coral_sbc_callid")).map(ExtensionHeader::getValue).orElse(null);
            String xCallType = Optional.ofNullable((ExtensionHeader)request.getHeader("X-Call-Type")).map(ExtensionHeader::getValue).orElse(null);
            String callDirection = this.callDirectionCheck(fromUser, toUser);
            if (!this.stateMap.containsKey(callID)) {
                StateDialog linkStateDialog;
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "No Existing StateDialog is found, creating new for callId : " + callID);
                StateDialog inviteStateDialog = new StateDialog();
                inviteStateDialog.setCallId(callID);
                inviteStateDialog.setState("trying");
                inviteStateDialog.setLocalUser(fromUser);
                inviteStateDialog.setRemoteUser(toUser);
                inviteStateDialog.setLocalNumber(fromURI != null ? fromURI.toString() : null);
                inviteStateDialog.setRemoteNumber(toURI != null ? toURI.toString() : null);
                inviteStateDialog.setLocalTag(fromTag);
                inviteStateDialog.setLocalContact(contactHeader.getURI().toString());
                inviteStateDialog.setEpoch(String.valueOf(epochMillis));
                inviteStateDialog.setEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                inviteStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                inviteStateDialog.setCallDirection(callDirection);
                inviteStateDialog.setDirection(fromRegistrar ? "recipient" : "initiator");
                inviteStateDialog.setFSUUID(fromRegistrar ? callID : null);
                inviteStateDialog.setCallType(xCallType != null ? xCallType : "regular");
                String resolvedLinkKey = this.resolveLinkKey(linkCallId);
                if (resolvedLinkKey != null && (linkStateDialog = (StateDialog)this.stateMap.get(resolvedLinkKey)) != null) {
                    Set callIds;
                    String linkIdToUse;
                    String direction = "initiator".equals(linkStateDialog.getDirection()) ? "recipient" : "initiator";
                    inviteStateDialog.setDirection(direction);
                    if ("initiator".equals(direction) && linkStateDialog.getLinkCallId() != null) {
                        this.linkKeyMap.remove(linkStateDialog.getLinkCallId());
                        linkIdToUse = inviteStateDialog.getCallId();
                        linkStateDialog.setLinkCallId(linkIdToUse);
                        inviteStateDialog.setLinkCallId(linkIdToUse);
                    } else {
                        linkIdToUse = resolvedLinkKey;
                        if (linkStateDialog.getLinkCallId() != null && (callIds = (Set)this.linkKeyMap.get(linkStateDialog.getLinkCallId())) != null) {
                            callIds.removeIf(id -> !id.equals(linkStateDialog.getCallId()));
                            callIds.add(inviteStateDialog.getCallId());
                        }
                        linkStateDialog.setLinkCallId(linkIdToUse);
                        inviteStateDialog.setLinkCallId(linkIdToUse);
                    }
                    callIds = this.linkKeyMap.computeIfAbsent(linkIdToUse, k -> ConcurrentHashMap.newKeySet());
                    callIds.add(inviteStateDialog.getCallId());
                    callIds.add(linkStateDialog.getCallId());
                    if (direction.equals("initiator")) {
                        linkStateDialog.setLocalUser(toUser);
                        linkStateDialog.setRemoteUser(fromUser);
                        inviteStateDialog.setLocalUser(toUser);
                        inviteStateDialog.setRemoteUser(fromUser);
                    } else {
                        linkStateDialog.setLocalUser(fromUser);
                        linkStateDialog.setRemoteUser(toUser);
                    }
                    inviteStateDialog.setLocalContact(linkStateDialog.getLocalContact());
                    inviteStateDialog.setRemoteContact(requestUri.toString());
                    linkStateDialog.setRemoteContact(requestUri.toString());
                }
                if (referredByHeader != null) {
                    StateDialog replacesStateDialog;
                    String replaceCallID = this.findReplaceHeader(referredByHeader.toString(), "token", receivedFromUser, receivedToUser);
                    StateDialog stateDialog = replacesStateDialog = replaceCallID != null ? (StateDialog)this.stateMap.get(replaceCallID) : null;
                    if (replacesStateDialog != null) {
                        inviteStateDialog.setReferredBy(replacesStateDialog.getReferredBy());
                        inviteStateDialog.setReferTo(replacesStateDialog.getReferTo());
                        inviteStateDialog.setTransferredBy(replacesStateDialog.getTransferredBy());
                        inviteStateDialog.setTransferredTo(replacesStateDialog.getTransferredTo());
                        inviteStateDialog.setTransferType(replacesStateDialog.getTransferType());
                    }
                }
                this.stateMap.put(callID, inviteStateDialog);
                this.userMap.computeIfAbsent(inviteStateDialog.getLocalUser(), k -> new ConcurrentSkipListSet()).add(inviteStateDialog.getRemoteUser());
                this.userMap.computeIfAbsent(inviteStateDialog.getRemoteUser(), k -> new ConcurrentSkipListSet()).add(inviteStateDialog.getLocalUser());
            } else {
                StateDialog inviteStateDialog = (StateDialog)this.stateMap.get(callID);
                this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Existing StateDialog is found for callId : " + callID);
                if (inviteStateDialog != null) {
                    this.updateStateWithLock(inviteStateDialog, () -> {
                        boolean holdRequest = this.isHoldRequest(request);
                        inviteStateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                        if (toTag != null) {
                            inviteStateDialog.setHoldState(holdRequest ? "true" : "false");
                            inviteStateDialog.setHoldBy(holdRequest ? fromUser : null);
                            inviteStateDialog.setHoldTo(holdRequest ? toUser : null);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in onInviteUpdate method inviteDialogCallID : {} ", (Object)e.getLocalizedMessage(), (Object)inviteDialog.getCallId().getCallId(), (Object)e);
        }
    }

    private String resolveLinkKey(String linkCallId) {
        if (linkCallId == null) {
            return null;
        }
        StateDialog dialog = (StateDialog)this.stateMap.get(linkCallId);
        if (dialog != null && HelperIMS.VALID_ACTIVE_STATES.contains(dialog.getState())) {
            return linkCallId;
        }
        String prevKey = this.findKeyByAssociateLinkCallId(linkCallId);
        return prevKey != null ? prevKey : null;
    }

    private String callDirectionCheck(String fromExtension, String toExtension) {
        String functionName = "callDirectionCheck";
        try {
            this.helperIMS.printCustomLogs(className, functionName, "info", fromExtension, toExtension, "Recieved  params from : " + fromExtension + " and to : " + toExtension + " extension.");
            if (fromExtension != null && toExtension != null) {
                if (this.helperIMS.extensionMap.containsKey(fromExtension) && this.helperIMS.extensionMap.containsKey(toExtension)) {
                    String fromType = (String)((List)this.helperIMS.extensionMap.get(fromExtension)).get(3);
                    String toType = (String)((List)this.helperIMS.extensionMap.get(toExtension)).get(3);
                    if (this.isInternal(fromType) && this.isInternal(toType)) {
                        return "INT";
                    }
                    if (this.isInternal(fromType)) {
                        return toType;
                    }
                    if (this.isInternal(toType)) {
                        return fromType;
                    }
                    return fromType;
                }
                if (this.helperIMS.extensionMap.containsKey(fromExtension)) {
                    return "OUT";
                }
                if (this.helperIMS.extensionMap.containsKey(toExtension)) {
                    return "IN";
                }
            }
        }
        catch (Exception e) {
            logger.error("Receved Error :{}  in callDirectionCheck Method while processing from : {} and to : {} extensions", (Object)e.getLocalizedMessage(), (Object)fromExtension, (Object)toExtension, (Object)e);
        }
        return "INT";
    }

    private boolean isInternal(String extensionType) {
        return extensionType.equalsIgnoreCase("phone") || extensionType.equalsIgnoreCase("agent") || extensionType.equalsIgnoreCase("fax") || extensionType.equalsIgnoreCase("remoteUser");
    }

    private boolean isHoldRequest(Request request) {
        String sdpContent;
        byte[] content;
        int contentLength;
        ContentLengthHeader contentLengthHeader = (ContentLengthHeader)request.getHeader("Content-Length");
        return contentLengthHeader != null && (contentLength = contentLengthHeader.getContentLength()) > 0 && (content = request.getRawContent()) != null && ((sdpContent = new String(content)).contains("a=inactive") || sdpContent.contains("a=sendonly"));
    }

    public void onReferUpdate(SIPDialog referDialog, ReferToHeader referToHeader, ReferredByHeader referredByHeader, String receivedFromUser, String receivedTouser) {
        String functionName = "onReferUpdate";
        try {
            StateDialog replacekeyDialog;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedTouser, "Received REFER dialog for DialogCallId : " + referDialog.getCallId().getCallId() + ",\n referToHeader : " + referToHeader.getAddress().getURI().toString() + ",\nreferByHeader : " + referredByHeader.getAddress().toString() + ",\nreceivedFromUser: " + receivedFromUser + " receivedToUser: " + receivedTouser);
            String callID = referDialog.getCallId().getCallId();
            StateDialog referStateDialog = (StateDialog)this.stateMap.get(callID);
            long cSeqNumber = referDialog.getRemoteSeqNumber();
            String replaceCallID = this.findReplaceHeader(referToHeader.getAddress().getURI().toString(), "Replaces", receivedFromUser, receivedTouser);
            if (referStateDialog == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedTouser, "No Existing StateDialog is found for key : " + callID);
                return;
            }
            this.updateStateWithLock(referStateDialog, () -> this.updateStateDialog(referStateDialog, cSeqNumber, referToHeader, referredByHeader, replaceCallID, receivedFromUser, receivedTouser));
            if (replaceCallID != null && (replacekeyDialog = (StateDialog)this.stateMap.get(replaceCallID)) != null) {
                this.updateStateWithLock(replacekeyDialog, () -> this.updateStateDialog(replacekeyDialog, Long.parseLong(replacekeyDialog.getCseqNumber()), referToHeader, referredByHeader, replaceCallID, receivedFromUser, receivedTouser));
                this.findTransferType(referStateDialog, replacekeyDialog, replacekeyDialog.getState());
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in onReferUpdate method referDialogCallID : {} ", (Object)e.getLocalizedMessage(), (Object)referDialog.getCallId().getCallId(), (Object)e);
        }
    }

    private void findTransferType(StateDialog stateDialog, StateDialog replacekeyDialog, String state) {
        Set set;
        StateDialog replaceLinkedDialog;
        String transferType = "ringing".equals(state) ? "semiAttended_transfer" : "attended_transfer";
        stateDialog.setTransferType(transferType);
        replacekeyDialog.setTransferType(transferType);
        String stateLinkedCallId = this.findOtherCallIdByCallId(stateDialog.getCallId());
        String replaceLinkedCallId = this.findOtherCallIdByCallId(replacekeyDialog.getCallId());
        StateDialog stateLinkedDialog = stateLinkedCallId == null ? null : (StateDialog)this.stateMap.get(stateLinkedCallId);
        StateDialog stateDialog2 = replaceLinkedDialog = replaceLinkedCallId == null ? null : (StateDialog)this.stateMap.get(replaceLinkedCallId);
        if (stateLinkedDialog == null || replaceLinkedDialog == null) {
            return;
        }
        Optional.ofNullable(stateLinkedDialog.getAssociateLinkCallId()).ifPresent(this.associateKeyMap::remove);
        Optional.ofNullable(replaceLinkedDialog.getAssociateLinkCallId()).ifPresent(this.associateKeyMap::remove);
        stateLinkedDialog.setTransferType(transferType);
        replaceLinkedDialog.setTransferType(transferType);
        replaceLinkedDialog.setDirection(stateDialog.getDirection());
        stateLinkedDialog.setAssociateLinkCallId(replacekeyDialog.getLinkCallId());
        replaceLinkedDialog.setAssociateLinkCallId(stateDialog.getLinkCallId());
        if ("initiator".equals(replaceLinkedDialog.getDirection())) {
            this.linkKeyMap.remove(stateDialog.getLinkCallId());
            this.linkKeyMap.remove(replacekeyDialog.getLinkCallId());
            replaceLinkedDialog.setLinkCallId(replaceLinkedCallId);
            stateLinkedDialog.setLinkCallId(replaceLinkedCallId);
            replaceLinkedDialog.setLocalUser(replaceLinkedDialog.getRemoteUser());
            replaceLinkedDialog.setRemoteUser(stateLinkedDialog.getRemoteUser());
            stateLinkedDialog.setLocalUser(replaceLinkedDialog.getLocalUser());
            this.userMap.computeIfAbsent(replaceLinkedDialog.getLocalUser(), k -> new ConcurrentSkipListSet()).add(stateLinkedDialog.getRemoteUser());
            this.userMap.computeIfAbsent(replaceLinkedDialog.getRemoteUser(), k -> new ConcurrentSkipListSet()).add(replaceLinkedDialog.getLocalUser());
            set = this.linkKeyMap.computeIfAbsent(replaceLinkedCallId, k -> ConcurrentHashMap.newKeySet());
            set.add(stateLinkedCallId);
            set.add(replaceLinkedCallId);
        } else if ("initiator".equals(stateLinkedDialog.getDirection())) {
            this.linkKeyMap.remove(replacekeyDialog.getLinkCallId());
            stateLinkedDialog.setLinkCallId(stateLinkedCallId);
            replaceLinkedDialog.setLinkCallId(stateLinkedCallId);
            stateLinkedDialog.setRemoteUser(replaceLinkedDialog.getRemoteUser());
            replaceLinkedDialog.setLocalUser(stateLinkedDialog.getLocalUser());
            this.userMap.computeIfAbsent(replaceLinkedDialog.getLocalUser(), k -> new ConcurrentSkipListSet()).add(stateLinkedDialog.getRemoteUser());
            this.userMap.computeIfAbsent(replaceLinkedDialog.getRemoteUser(), k -> new ConcurrentSkipListSet()).add(replaceLinkedDialog.getLocalUser());
            set = (Set)this.linkKeyMap.get(stateLinkedCallId);
            if (set != null) {
                set.removeIf(id -> !id.equals(stateLinkedDialog.getCallId()));
                set.add(replaceLinkedDialog.getCallId());
            }
        }
        String associateKeyForState = stateLinkedDialog.getAssociateLinkCallId();
        String associateKeyForReplace = replaceLinkedDialog.getAssociateLinkCallId();
        if (associateKeyForState != null) {
            this.associateKeyMap.put(associateKeyForState, stateLinkedDialog.getCallId());
        }
        if (associateKeyForReplace != null) {
            this.associateKeyMap.put(associateKeyForReplace, replaceLinkedDialog.getCallId());
        }
    }

    private void updateStateDialog(StateDialog stateDialog, long cSeqNumber, ReferToHeader referToHeader, ReferredByHeader referredByHeader, String replaceCallID, String receivedFromUser, String receivedToUser) {
        String functionName = "updateStateDialog";
        try {
            String linkCallId;
            StateDialog linkStateDialog;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Received stateDialog for callid: " + stateDialog.getCallId() + " cseqNumber: " + cSeqNumber + " \nreferToHeader: " + referToHeader + " \nreferredByHeader: " + referredByHeader + " \nreplaceCallID: " + replaceCallID + " \nReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            String referredBy = referredByHeader.getAddress().getURI().toString();
            String referToUri = FeatureIMSStateMachine.extractSipUri((String)referToHeader.getAddress().getURI().toString());
            String transferredBy = ((SipURI)referredByHeader.getAddress().getURI()).getUser();
            String transferredTo = ((SipURI)referToHeader.getAddress().getURI()).getUser();
            String cSeqString = String.valueOf(cSeqNumber);
            stateDialog.setCseqNumber(cSeqString);
            stateDialog.setReferredBy(referredBy);
            stateDialog.setReferTo(referToUri);
            stateDialog.setTransferredBy(transferredBy);
            stateDialog.setTransferredTo(transferredTo);
            if (replaceCallID == null) {
                stateDialog.setTransferType("blind_transfer");
            }
            StateDialog stateDialog2 = linkStateDialog = (linkCallId = this.findOtherCallIdByCallId(stateDialog.getCallId())) != null ? (StateDialog)this.stateMap.get(linkCallId) : null;
            if (linkStateDialog != null) {
                try {
                    this.updateStateWithLock(linkStateDialog, () -> {
                        linkStateDialog.setCseqNumber(cSeqString);
                        linkStateDialog.setReferredBy(referredBy);
                        linkStateDialog.setReferTo(referToUri);
                        linkStateDialog.setTransferredBy(transferredBy);
                        linkStateDialog.setTransferredTo(transferredTo);
                        if (replaceCallID == null) {
                            linkStateDialog.setTransferType("blind_transfer");
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("Error updating linkStateDialog in updateStateDialog function for linkCallId {}: {}", (Object)linkCallId, (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in updateStateDialog method for StateDialog callid: " + stateDialog.getCallId() + " cseqNumber: " + cSeqNumber + " \nreferToHeader: " + referToHeader + " \nreferredByHeader: " + referredByHeader + " \nreplaceCallID: " + replaceCallID + " \nReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser + "\t" + e.getMessage() + "\n" + e);
        }
    }

    public void onByeUpdate(SIPDialog byeDialog, boolean fromRegistrar, String receivedFromUser, String receivedToUser) {
        String functionName = "onByeUpdate";
        try {
            String key;
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved BYE dialog for DialogCallId: " + byeDialog.getCallId().getCallId() + " fromRegistrar: " + fromRegistrar + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Long epochMillis = System.currentTimeMillis();
            CallIdHeader callIdHeader = byeDialog.getCallId();
            String callID = callIdHeader.getCallId();
            Address toHeader = byeDialog.getLocalParty();
            Address fromHeader = byeDialog.getRemoteParty();
            SipURI fromURI = (SipURI)fromHeader.getURI();
            SipURI toURI = (SipURI)toHeader.getURI();
            String toUser = toURI.getUser();
            String fromUser = fromURI.getUser();
            long cSeqNumber = byeDialog.getRemoteSeqNumber();
            StateDialog stateDialog = (StateDialog)this.stateMap.get(callID);
            if (stateDialog != null) {
                if (HelperIMS.DISCONNECTED_STATES.contains(stateDialog.getState())) {
                    return;
                }
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                    stateDialog.setState("stale");
                    stateDialog.setDisconnectedBy(fromUser);
                    stateDialog.setDisconnectedTo(toUser);
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                });
            }
            this.scheduleRemoveDialog(callID, receivedFromUser, receivedToUser);
            String string = key = fromRegistrar ? toUser : fromUser;
            if (key == null) {
                return;
            }
            if (this.backwardcallbackMap.containsKey(key)) {
                this.scheduler.schedule(() -> this.initiateCallBack(key, "backwardcallbackMap"), 2L, TimeUnit.SECONDS);
            } else if (this.forwardcallbackMap.containsKey(key)) {
                this.scheduler.schedule(() -> this.initiateCallBack(key, "forwardcallbackMap"), 2L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in onByeUpdate method ByeDialogCallID : {} ", (Object)e.getLocalizedMessage(), (Object)byeDialog.getCallId().getCallId(), (Object)e);
        }
    }

    public void onCancelUpdate(SIPDialog cancelDialog, boolean fromRegistrar, String receivedFromUser, String receivedToUser) {
        String functionName = "onCancelUpdate";
        try {
            this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Recieved CANCEL dialog for DialogCallId: " + cancelDialog.getCallId().getCallId() + " fromRegistrar: " + fromRegistrar + " ReceivedFromUser: " + receivedFromUser + " ReceivedToUser: " + receivedToUser);
            Long epochMillis = System.currentTimeMillis();
            CallIdHeader callIdHeader = cancelDialog.getCallId();
            String callID = callIdHeader.getCallId();
            Address toHeader = cancelDialog.getLocalParty();
            Address fromHeader = cancelDialog.getRemoteParty();
            SipURI fromURI = (SipURI)fromHeader.getURI();
            SipURI toURI = (SipURI)toHeader.getURI();
            long cSeqNumber = cancelDialog.getRemoteSeqNumber();
            StateDialog stateDialog = (StateDialog)this.stateMap.get(callID);
            if (stateDialog != null && cSeqNumber >= Long.parseLong(stateDialog.getCseqNumber())) {
                if (HelperIMS.DISCONNECTED_STATES.contains(stateDialog.getState())) {
                    return;
                }
                if (fromRegistrar && stateDialog.getCallType().equals("callback")) {
                    this.removeFromCallBackMap(stateDialog.getLocalUser(), stateDialog.getRemoteUser());
                    this.removeFromCallBackMap(stateDialog.getRemoteUser(), stateDialog.getLocalUser());
                    if (stateDialog.getState().equals("trying")) {
                        ConcurrentLinkedDeque deque = this.forwardcallbackMap.computeIfAbsent(stateDialog.getRemoteUser(), k -> new ConcurrentLinkedDeque());
                        if (!deque.contains(stateDialog.getLocalUser())) {
                            deque.addLast(stateDialog.getLocalUser());
                            if (Constants.HA_SYNC.booleanValue()) {
                                this.featureIMSService.publishCallbackOnRedis(stateDialog.getLocalUser(), stateDialog.getRemoteUser(), "forward", "add", "");
                            }
                        }
                        this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "In cancelDialog Callback Initiator is Not Available. Stopping callback for initiatedBy: " + stateDialog.getRemoteUser() + " initiatedTo: " + stateDialog.getLocalUser());
                    } else {
                        this.removeFromOriginalCallbackMap(receivedFromUser, receivedToUser);
                        if (Constants.HA_SYNC.booleanValue()) {
                            this.featureIMSService.publishCallbackWithTimeOnRedis(receivedFromUser, receivedToUser, "", System.currentTimeMillis(), "remove");
                        }
                        this.mediaTypeMap.remove(stateDialog.getLocalUser() + ":" + stateDialog.getRemoteUser());
                        this.mediaTypeMap.remove(stateDialog.getRemoteUser() + ":" + stateDialog.getLocalUser());
                    }
                    this.scheduler.schedule(() -> this.initiateCallBack(stateDialog.getLocalUser(), "backwardcallbackMap"), 2L, TimeUnit.SECONDS);
                }
                this.updateStateWithLock(stateDialog, () -> {
                    stateDialog.setCseqNumber(String.valueOf(cSeqNumber));
                    stateDialog.setState("cancelled");
                    stateDialog.setDisconnectedBy(fromURI != null ? fromURI.getUser() : null);
                    stateDialog.setDisconnectedTo(toURI != null ? toURI.getUser() : null);
                    stateDialog.setEndEpoch(String.valueOf(epochMillis));
                    stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
                });
            }
            this.scheduleRemoveDialog(callID, receivedFromUser, receivedToUser);
            if (!fromRegistrar && this.backwardcallbackMap.containsKey(fromURI.getUser())) {
                this.scheduler.schedule(() -> this.initiateCallBack(fromURI.getUser(), "backwardcallbackMap"), 2L, TimeUnit.SECONDS);
            } else if (!fromRegistrar && this.forwardcallbackMap.containsKey(fromURI.getUser())) {
                this.scheduler.schedule(() -> this.initiateCallBack(fromURI.getUser(), "forwardcallbackMap"), 2L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in onCancelUpdate method CancelDialogCallId : {} ", (Object)e.getLocalizedMessage(), (Object)cancelDialog.getCallId().getCallId(), (Object)e);
        }
    }

    public void updateResponse(SIPDialog responseDialog, boolean fromRegistrar, String receivedFromUser, String receivedToUser) {
        String functionName = "updateResponse";
        this.helperIMS.printCustomLogs(className, functionName, "info", receivedFromUser, receivedToUser, "Received " + responseDialog.getMethod().toUpperCase() + " response Dialog for DialogCallId : " + responseDialog.getCallId().getCallId() + " fromRegistrar: " + fromRegistrar + " receivedfromUser: " + receivedFromUser + " receivedTouser: " + receivedToUser);
        Long epochMillis = System.currentTimeMillis();
        try {
            if (responseDialog != null && responseDialog.getLastResponseMethod().equals("INVITE")) {
                this.handleInviteResponse(responseDialog, epochMillis, fromRegistrar, receivedFromUser, receivedToUser);
            }
        }
        catch (Exception e) {
            logger.error("Error : {} in updateResponse method ResponseDialogCallId : {} ", (Object)e.getLocalizedMessage(), (Object)responseDialog.getCallId().getCallId(), (Object)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleInviteResponse(SIPDialog responseDialog, Long epochMillis, boolean fromRegistrar, String receivedFromUser, String receivedToUser) throws Exception {
        functionName = "hanldeInviteResponse";
        callID = responseDialog.getCallId().getCallId();
        this.helperIMS.printCustomLogs(FeatureIMSStateMachine.className, functionName, "info", receivedFromUser, receivedToUser, "Received INVITE response Dialog for DialogCallId : " + callID + " fromRegistrar: " + fromRegistrar + " receivedfromUser: " + receivedFromUser + " receivedTouser: " + receivedToUser);
        stateDialog = (StateDialog)this.stateMap.get(callID);
        if (stateDialog == null) {
            return;
        }
        toHeader = responseDialog.getRemoteParty();
        fromHeader = responseDialog.getLocalParty();
        fromURI = fromHeader != null ? (SipURI)fromHeader.getURI() : null;
        toURI = toHeader != null ? (SipURI)toHeader.getURI() : null;
        toTag = responseDialog.getRemoteTag();
        statusCode = responseDialog.getLastResponseStatusCode();
        v0 = response = responseDialog.getLastTransaction() != null ? responseDialog.getLastTransaction().getResponse() : null;
        if (HelperIMS.DISCONNECTED_STATES.contains(stateDialog.getState())) {
            FeatureIMSStateMachine.logger.info("Disconnected state found in handleInviteResponse " + stateDialog.getState());
            return;
        }
        switch (statusCode) {
            case 180: 
            case 183: {
                this.updateStateWithLock(stateDialog, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$24(com.coraltele.model.StateDialog java.lang.Long java.lang.String ), ()V)((FeatureIMSStateMachine)this, (StateDialog)stateDialog, (Long)epochMillis, (String)toTag));
                break;
            }
            case 200: {
                if (!HelperIMS.VALID_ACTIVE_STATES.contains(stateDialog.getState())) break;
                this.updateStateWithLock(stateDialog, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$25(com.coraltele.model.StateDialog java.lang.Long com.coraltele.interfaces.sip.message.Response java.lang.String java.lang.String ), ()V)((FeatureIMSStateMachine)this, (StateDialog)stateDialog, (Long)epochMillis, (Response)response, (String)receivedFromUser, (String)receivedToUser));
                break;
            }
            case 407: {
                break;
            }
            case 403: 
            case 480: {
                if (!this.backwardcallbackMap.containsKey(fromURI.getUser())) ** GOTO lbl32
                this.scheduler.schedule((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$26(com.coraltele.interfaces.sip.address.SipURI ), ()V)((FeatureIMSStateMachine)this, (SipURI)fromURI), 2L, TimeUnit.SECONDS);
                ** GOTO lbl35
lbl32:
                // 1 sources

                if (this.forwardcallbackMap.containsKey(fromURI.getUser())) {
                    this.scheduler.schedule((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$27(com.coraltele.interfaces.sip.address.SipURI ), ()V)((FeatureIMSStateMachine)this, (SipURI)fromURI), 2L, TimeUnit.SECONDS);
                }
            }
lbl35:
            // 5 sources

            case 486: 
            case 487: {
                if (statusCode == 487 && stateDialog.getState().equals("cancelled")) {
                    return;
                }
                this.updateStateWithLock(stateDialog, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$28(com.coraltele.model.StateDialog int com.coraltele.interfaces.sip.address.SipURI com.coraltele.interfaces.sip.address.SipURI java.lang.Long ), ()V)((FeatureIMSStateMachine)this, (StateDialog)stateDialog, (int)statusCode, (SipURI)toURI, (SipURI)fromURI, (Long)epochMillis));
                if ((statusCode == 486 || statusCode == 487) && stateDialog.getCallType().equals("callback")) {
                    localUser = stateDialog.getLocalUser();
                    remoteUser = stateDialog.getRemoteUser();
                    this.removeFromCallBackMap(localUser, remoteUser);
                    this.removeFromCallBackMap(remoteUser, localUser);
                    this.removeFromOriginalCallbackMap(localUser, remoteUser);
                    if (Constants.HA_SYNC.booleanValue()) {
                        this.featureIMSService.publishCallbackWithTimeOnRedis(receivedFromUser, receivedToUser, "", System.currentTimeMillis(), "remove");
                    }
                    this.mediaTypeMap.remove(localUser + ":" + remoteUser);
                    this.mediaTypeMap.remove(remoteUser + ":" + localUser);
                    this.scheduler.schedule((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$29(java.lang.String ), ()V)((FeatureIMSStateMachine)this, (String)localUser), 2L, TimeUnit.SECONDS);
                }
                this.scheduleRemoveDialog(callID, receivedFromUser, receivedToUser);
                break;
            }
            default: {
                if (statusCode < 400) break;
                this.updateStateWithLock(stateDialog, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleInviteResponse$30(com.coraltele.model.StateDialog com.coraltele.interfaces.sip.address.SipURI com.coraltele.interfaces.sip.address.SipURI java.lang.Long ), ()V)((FeatureIMSStateMachine)this, (StateDialog)stateDialog, (SipURI)fromURI, (SipURI)toURI, (Long)epochMillis));
                this.scheduleRemoveDialog(callID, receivedFromUser, receivedToUser);
            }
        }
    }

    private void removeFromCallBackMap(String from, String to) {
        this.backwardcallbackMap.computeIfPresent(from, (k, set) -> {
            set.remove(to);
            if (Constants.HA_SYNC.booleanValue()) {
                this.featureIMSService.publishCallbackOnRedis(to, from, "backward", "remove", "");
            }
            return set.isEmpty() ? null : set;
        });
        this.forwardcallbackMap.computeIfPresent(to, (k, set) -> {
            set.remove(from);
            if (Constants.HA_SYNC.booleanValue()) {
                this.featureIMSService.publishCallbackOnRedis(from, to, "forward", "remove", "");
            }
            return set.isEmpty() ? null : set;
        });
    }

    private void removeFromCallBackMapWithTime(String from, String to) {
        this.backwardcallbackMap.computeIfPresent(from, (k, set) -> {
            set.remove(to);
            return set.isEmpty() ? null : set;
        });
        this.forwardcallbackMap.computeIfPresent(to, (k, set) -> {
            set.remove(from);
            return set.isEmpty() ? null : set;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateWithLock(StateDialog stateDialog, Runnable task) throws Exception {
        String functionName = "updateStateWithLock";
        String callId = stateDialog.getCallId();
        for (int i = 0; i < 2; ++i) {
            try {
                if (stateDialog.getLock().tryLock(1000L, TimeUnit.MILLISECONDS)) {
                    try {
                        task.run();
                        return;
                    }
                    finally {
                        stateDialog.getLock().unlock();
                    }
                }
                this.helperIMS.printCustomLogs(className, functionName, "debug", stateDialog.getLocalUser(), stateDialog.getRemoteUser(), "Failed to acquire lock for Dialog: " + callId + " on attempt -> " + (i + 1) + "/" + 2 + ". Retrying..");
                if (i >= 1) continue;
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                logger.error("Error during task execution for dialog {}: {}", (Object)callId, (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        this.helperIMS.printCustomLogs(className, functionName, "warn", stateDialog.getLocalUser(), stateDialog.getRemoteUser(), "Failed to acquire lock for Dialog: " + callId + " after " + 2 + " attempt.");
    }

    private void scheduleRemoveDialog(String callId, String fromUser, String toUser) {
        String functionName = "scheduleRemoveDialog";
        try {
            if (this.stateMap.get(callId) == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "CallId : " + callId + " is not found in StateMap");
                return;
            }
            this.scheduler.schedule(() -> {
                StateDialog dialog = (StateDialog)this.stateMap.get(callId);
                if (dialog != null) {
                    Set callIds;
                    this.stateMap.remove(callId);
                    this.removeCallFromUserMap(dialog.getLocalUser(), dialog.getRemoteUser());
                    if (dialog.getAssociateLinkCallId() != null) {
                        this.associateKeyMap.remove(dialog.getAssociateLinkCallId(), callId);
                    }
                    if (dialog.getLinkCallId() != null && dialog.getDirection().equals("initiator")) {
                        this.linkKeyMap.remove(dialog.getLinkCallId());
                    } else if (dialog.getLinkCallId() != null && (callIds = (Set)this.linkKeyMap.get(dialog.getLinkCallId())) != null) {
                        callIds.remove(callId);
                        if (callIds.isEmpty()) {
                            this.linkKeyMap.remove(dialog.getLinkCallId());
                        }
                    }
                }
            }, 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Error in scheduleRemoveDialog for callId : {} ,{}", (Object)callId, (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    private void removeCallFromUserMap(String user1, String user2) {
        if (user1 == null || user2 == null) {
            return;
        }
        Set set1 = (Set)this.userMap.get(user1);
        Set set2 = (Set)this.userMap.get(user2);
        if (set1 != null) {
            set1.remove(user2);
            if (set1.isEmpty()) {
                this.userMap.remove(user1);
            }
        }
        if (set2 != null) {
            set2.remove(user1);
            if (set2.isEmpty()) {
                this.userMap.remove(user2);
            }
        }
    }

    public String findReplaceHeader(String input, String fieldName, String fromUser, String toUser) {
        String functionName = "findReplaceHeader";
        if (input == null || input.isEmpty() || fieldName == null || fieldName.isEmpty()) {
            this.helperIMS.printCustomLogs(className, functionName, "warn", fromUser, toUser, "Invalid input or fieldName: input= " + input + ", key= " + fieldName);
            return null;
        }
        try {
            String decodedInput = URLDecoder.decode(input, "UTF-8");
            String pattern = fieldName + "=([^;]+)";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(decodedInput);
            if (m.find()) {
                String replacesCallID = m.group(1);
                return replacesCallID.trim();
            }
        }
        catch (Exception e) {
            logger.error("Error in {} - {} \n{}", (Object)functionName, (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private static String extractSipUri(String input) {
        int questionMarkIndex = input.indexOf(63);
        if (questionMarkIndex != -1) {
            return input.substring(0, questionMarkIndex);
        }
        return input;
    }

    public String findOtherCallIdByCallId(String callId) {
        if (callId == null) {
            return null;
        }
        StateDialog current = (StateDialog)this.stateMap.get(callId);
        if (current == null || current.getLinkCallId() == null) {
            return null;
        }
        Set callIds = (Set)this.linkKeyMap.get(current.getLinkCallId());
        if (callIds == null) {
            return null;
        }
        for (String otherId : callIds) {
            if (otherId.equals(callId)) continue;
            return otherId;
        }
        return null;
    }

    private String findKeyByAssociateLinkCallId(String associateLinkCallId) {
        return (String)this.associateKeyMap.get(associateLinkCallId);
    }

    public List<StateDialog> getchannel() {
        return new ArrayList<StateDialog>(this.stateMap.values());
    }

    public ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> mergeAllCallbackMaps() {
        ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> cbMap = new ConcurrentHashMap<String, ConcurrentLinkedDeque<String>>();
        try {
            this.backwardcallbackMap.forEach((key, value) -> cbMap.put((String)key, new ConcurrentLinkedDeque(value)));
            this.forwardcallbackMap.forEach((key, value) -> {
                cbMap.computeIfAbsent((String)key, k -> new ConcurrentLinkedDeque());
                ConcurrentLinkedDeque deque = (ConcurrentLinkedDeque)cbMap.get(key);
                for (String val : value) {
                    if (deque.contains(val)) continue;
                    deque.addLast(val);
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while merging callback maps in FeatureIMSStateMachine: {}", (Object)e.getMessage(), (Object)e);
        }
        return cbMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateCallBack(String user, String typeofMap) {
        String functionName = "initiateCallBack";
        this.helperIMS.printCustomLogs(className, functionName, "info", user, user, "Received callback Initiation for user " + user);
        if (typeofMap.equals("backwardcallbackMap")) {
            String cbInitiatedTo = user;
            Deque cbInitiatedBySet = this.backwardcallbackMap.getOrDefault(cbInitiatedTo, new ConcurrentLinkedDeque());
            for (String cbInitiatedBy : cbInitiatedBySet) {
                ConcurrentLinkedDeque deque;
                boolean is_cbInitiatedTo_Busy = this.isUserInActiveDialog(cbInitiatedTo);
                boolean is_cbInitiatedBy_Busy = this.isUserInActiveDialog(cbInitiatedBy);
                boolean is_cbInitiatedTo_Register = false;
                boolean is_cbInitiatedBy_Register = false;
                if (Constants.IMS_MODE.equals("IMSV2-SERVER") && Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                    is_cbInitiatedTo_Register = this.imsV2ServerIMS.isUserRegistered(cbInitiatedTo);
                    is_cbInitiatedBy_Register = this.imsV2ServerIMS.isUserRegistered(cbInitiatedBy);
                } else {
                    is_cbInitiatedTo_Register = this.featureIMS.isUserRegistered(cbInitiatedTo);
                    is_cbInitiatedBy_Register = this.featureIMS.isUserRegistered(cbInitiatedBy);
                }
                if (!is_cbInitiatedTo_Busy && !is_cbInitiatedBy_Busy && is_cbInitiatedTo_Register && is_cbInitiatedBy_Register) {
                    if (this.callbackInProgress.putIfAbsent(cbInitiatedBy, true) == null) {
                        try {
                            this.callbackCommandCreation(cbInitiatedBy, cbInitiatedTo);
                        }
                        finally {
                            this.callbackInProgress.remove(cbInitiatedBy);
                        }
                    } else {
                        deque = this.forwardcallbackMap.computeIfAbsent(cbInitiatedBy, k -> new ConcurrentLinkedDeque());
                        if (!deque.contains(cbInitiatedTo)) {
                            deque.addLast(cbInitiatedTo);
                            if (Constants.HA_SYNC.booleanValue()) {
                                this.featureIMSService.publishCallbackOnRedis(cbInitiatedTo, cbInitiatedBy, "forward", "add", "");
                            }
                        }
                        this.backwardcallbackMap.computeIfPresent(cbInitiatedTo, (key, currentDeque) -> {
                            currentDeque.remove(cbInitiatedBy);
                            if (Constants.HA_SYNC.booleanValue()) {
                                this.featureIMSService.publishCallbackOnRedis(cbInitiatedBy, cbInitiatedTo, "backward", "remove", "");
                            }
                            return currentDeque.isEmpty() ? null : currentDeque;
                        });
                        this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Callback already in progress for " + cbInitiatedTo + ". Added in forwardMap for skipping duplicate trigger.");
                    }
                    return;
                }
                if (is_cbInitiatedTo_Busy || !is_cbInitiatedTo_Register) {
                    this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "In backwardcallback map Callback receiver : " + cbInitiatedTo + " is busy or unregistered.Stopping callback attempts for callback initiatedBy: " + cbInitiatedBy + " intiatedTo: " + cbInitiatedTo);
                    return;
                }
                if (!is_cbInitiatedBy_Busy && is_cbInitiatedBy_Register) continue;
                deque = this.forwardcallbackMap.computeIfAbsent(cbInitiatedBy, k -> new ConcurrentLinkedDeque());
                if (!deque.contains(cbInitiatedTo)) {
                    deque.addLast(cbInitiatedTo);
                    if (Constants.HA_SYNC.booleanValue()) {
                        this.featureIMSService.publishCallbackOnRedis(cbInitiatedTo, cbInitiatedBy, "forward", "add", "");
                    }
                }
                this.backwardcallbackMap.computeIfPresent(cbInitiatedTo, (key, currentDeque) -> {
                    currentDeque.remove(cbInitiatedBy);
                    if (Constants.HA_SYNC.booleanValue()) {
                        this.featureIMSService.publishCallbackOnRedis(cbInitiatedBy, cbInitiatedTo, "backward", "remove", "");
                    }
                    return currentDeque.isEmpty() ? null : currentDeque;
                });
                this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "In backwardcallback map Callback initiator : " + cbInitiatedBy + " is busy or unregistered.Stopping callback attempts for callback initiatedBy: " + cbInitiatedBy + " intiatedTo: " + cbInitiatedTo);
            }
        } else {
            String cbInitiatedBy = user;
            Deque cbInitiatedToSet = this.forwardcallbackMap.getOrDefault(cbInitiatedBy, new ConcurrentLinkedDeque());
            for (String cbInitiatedTo : cbInitiatedToSet) {
                ConcurrentLinkedDeque deque;
                boolean is_cbInitiatedTo_Busy = this.isUserInActiveDialog(cbInitiatedTo);
                boolean is_cbInitiatedBy_Busy = this.isUserInActiveDialog(cbInitiatedBy);
                boolean is_cbInitiatedBy_Register = false;
                boolean is_cbInitiatedTo_Register = false;
                if (Constants.IMS_MODE.equals("IMSV2-SERVER") && Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                    is_cbInitiatedBy_Register = this.imsV2ServerIMS.isUserRegistered(cbInitiatedBy);
                    is_cbInitiatedTo_Register = this.imsV2ServerIMS.isUserRegistered(cbInitiatedTo);
                } else {
                    is_cbInitiatedBy_Register = this.featureIMS.isUserRegistered(cbInitiatedBy);
                    is_cbInitiatedTo_Register = this.featureIMS.isUserRegistered(cbInitiatedTo);
                }
                if (!is_cbInitiatedTo_Busy && !is_cbInitiatedBy_Busy && is_cbInitiatedTo_Register && is_cbInitiatedBy_Register) {
                    if (this.callbackInProgress.putIfAbsent(cbInitiatedTo, true) == null) {
                        try {
                            this.callbackCommandCreation(cbInitiatedBy, cbInitiatedTo);
                        }
                        finally {
                            this.callbackInProgress.remove(cbInitiatedTo);
                        }
                    } else {
                        deque = this.backwardcallbackMap.computeIfAbsent(cbInitiatedTo, k -> new ConcurrentLinkedDeque());
                        if (!deque.contains(cbInitiatedBy)) {
                            deque.addLast(cbInitiatedBy);
                            if (Constants.HA_SYNC.booleanValue()) {
                                this.featureIMSService.publishCallbackOnRedis(cbInitiatedBy, cbInitiatedTo, "backward", "add", "");
                            }
                        }
                        this.forwardcallbackMap.computeIfPresent(cbInitiatedBy, (key, currentDeque) -> {
                            currentDeque.remove(cbInitiatedTo);
                            if (Constants.HA_SYNC.booleanValue()) {
                                this.featureIMSService.publishCallbackOnRedis(cbInitiatedTo, cbInitiatedBy, "forward", "remove", "");
                            }
                            return currentDeque.isEmpty() ? null : currentDeque;
                        });
                        this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Callback already in progress for " + cbInitiatedTo + ". Added in backwardMap for skipping duplicate trigger.");
                    }
                    return;
                }
                if (is_cbInitiatedTo_Busy || !is_cbInitiatedTo_Register) {
                    deque = this.backwardcallbackMap.computeIfAbsent(cbInitiatedTo, k -> new ConcurrentLinkedDeque());
                    if (!deque.contains(cbInitiatedBy)) {
                        deque.addLast(cbInitiatedBy);
                        if (Constants.HA_SYNC.booleanValue()) {
                            this.featureIMSService.publishCallbackOnRedis(cbInitiatedBy, cbInitiatedTo, "backward", "add", "");
                        }
                    }
                    this.forwardcallbackMap.computeIfPresent(cbInitiatedBy, (key, currentDeque) -> {
                        currentDeque.remove(cbInitiatedTo);
                        if (Constants.HA_SYNC.booleanValue()) {
                            this.featureIMSService.publishCallbackOnRedis(cbInitiatedTo, cbInitiatedBy, "forward", "remove", "");
                        }
                        return currentDeque.isEmpty() ? null : currentDeque;
                    });
                    this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "In forwardcallback map Callback initiator : " + cbInitiatedTo + " is busy or unregistered.Stopping callback attempts for callback initiatedBy: " + cbInitiatedTo + " intiatedTo: " + cbInitiatedBy);
                    continue;
                }
                if (!is_cbInitiatedBy_Busy && is_cbInitiatedBy_Register) continue;
                this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "In forwardcallback map Callback receiver : " + cbInitiatedBy + " is busy or unregistered.Stopping callback attempts for callback initiatedBy: " + cbInitiatedTo + " intiatedTo: " + cbInitiatedBy);
                return;
            }
        }
    }

    private void callbackCommandCreation(String cbInitiatedBy, String cbInitiatedTo) {
        String functionName = "callbackCommandCreation";
        try {
            String originateCmd;
            this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedTo, cbInitiatedBy, "Received callback command creation for: " + cbInitiatedBy + " to: " + cbInitiatedTo);
            String callUUID = UUID.randomUUID().toString();
            String str = cbInitiatedBy + ":" + cbInitiatedTo;
            String mediaType = this.mediaTypeMap.getOrDefault(str, "audio");
            String v2ip = Constants.LISTEN_IP_ADDRESS;
            if (Constants.IMS_MODE.equals("IMSV2-SERVER") && Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                if ("video".equalsIgnoreCase(mediaType)) {
                    originateCmd = String.format("bgapi originate {origination_uuid=%s,origination_caller_id_name='CB-CallBack',origination_caller_id_number=%s,sip_h_X-Call-Type=callback,alert_info='alert-callback',callbackuser=%s,sip_h_X-ForwardRoute=true}sofia/internal/%s@%s %s XML v2callback", callUUID, cbInitiatedTo, cbInitiatedBy, cbInitiatedBy, v2ip, cbInitiatedTo);
                    this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Video Callback command created for callID [" + callUUID + "] from [" + cbInitiatedBy + "] to [" + cbInitiatedTo + "], mediaType: " + mediaType + " command:\n " + originateCmd);
                } else {
                    originateCmd = String.format("bgapi originate {origination_uuid=%s,origination_caller_id_name='CB-CallBack',origination_caller_id_number=%s,sip_h_X-Call-Type=callback,absolute_codec_string='PCMU,PCMA',alert_info='alert-callback',callbackuser=%s,sip_h_X-ForwardRoute=true}sofia/internal/%s@%s %s XML v2callback", callUUID, cbInitiatedTo, cbInitiatedBy, cbInitiatedBy, v2ip, cbInitiatedTo);
                    this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Audio Callback created for callID [" + callUUID + "] from [" + cbInitiatedBy + "] to [" + cbInitiatedTo + "], mediaType: " + mediaType + " command:\n " + originateCmd);
                }
            } else if ("video".equalsIgnoreCase(mediaType)) {
                originateCmd = String.format("bgapi originate {origination_uuid=%s,origination_caller_id_name='CB-CallBack',origination_caller_id_number=%s,sip_h_X-Call-Type=callback,alert_info='alert-callback',callbackuser=%s}user/%s %s XML v2callback", callUUID, cbInitiatedTo, cbInitiatedBy, cbInitiatedBy, cbInitiatedTo);
                this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Video Callback command created for callID [" + callUUID + "] from [" + cbInitiatedBy + "] to [" + cbInitiatedTo + "], mediaType: " + mediaType + " command:\n " + originateCmd);
            } else {
                originateCmd = String.format("bgapi originate {origination_uuid=%s,origination_caller_id_name='CB-CallBack',origination_caller_id_number=%s,sip_h_X-Call-Type=callback,absolute_codec_string='PCMU,PCMA',alert_info='alert-callback',callbackuser=%s}user/%s %s XML v2callback", callUUID, cbInitiatedTo, cbInitiatedBy, cbInitiatedBy, cbInitiatedTo);
                this.helperIMS.printCustomLogs(className, functionName, "info", cbInitiatedBy, cbInitiatedTo, "Audio Callback created for callID [" + callUUID + "] from [" + cbInitiatedBy + "] to [" + cbInitiatedTo + "], mediaType: " + mediaType + " command:\n " + originateCmd);
            }
            this.getSwitchInfo(originateCmd);
        }
        catch (Exception e) {
            logger.error("Error during callbackCommand creation {}", (Throwable)e);
        }
    }

    private void getSwitchInfo(String cmd) {
        String functionName = "getSwitchInfo";
        try {
            String[] cmd1 = new String[]{"fs_cli", "-x", cmd};
            Process p = Runtime.getRuntime().exec(cmd1);
            this.helperIMS.printCustomLogs(className, functionName, "info", null, null, "Executed callback command : " + cmd1);
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isUserInActiveDialog(String user) {
        return this.stateMap.values().stream().filter(dialog -> HelperIMS.VALID_ACTIVE_STATES.contains(dialog.getState())).anyMatch(dialog -> user.equals(dialog.getLocalUser()) || user.equals(dialog.getRemoteUser()));
    }

    public ConcurrentHashMap<String, ConcurrentSkipListSet<String>> getUserMap() {
        return this.userMap;
    }

    public ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> getForwardCallBack() {
        return this.forwardcallbackMap;
    }

    public ConcurrentHashMap<String, ConcurrentSkipListSet<CallbackObject>> getCallBackMap() {
        return this.callbackMap;
    }

    public ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> getBackwardCallBack() {
        return this.backwardcallbackMap;
    }

    public void releaseDialog(String callId) {
        StateDialog linkStateDialog;
        if (callId == null) {
            return;
        }
        StateDialog stateDialog = (StateDialog)this.stateMap.get(callId);
        String linkedKey = stateDialog != null ? this.findOtherCallIdByCallId(callId) : null;
        StateDialog stateDialog2 = linkStateDialog = linkedKey != null ? (StateDialog)this.stateMap.get(linkedKey) : null;
        if (stateDialog != null) {
            try {
                this.updateStateWithLock(stateDialog, () -> stateDialog.setState("stale"));
            }
            catch (Exception e) {
                logger.error("Error updating stateDialog for callId {}: {}", (Object)callId, (Object)e.getMessage(), (Object)e);
            }
        }
        if (linkStateDialog != null) {
            try {
                this.updateStateWithLock(linkStateDialog, () -> linkStateDialog.setState("stale"));
            }
            catch (Exception e) {
                logger.error("Error updating linkStateDialog for callId {}: {}", (Object)linkedKey, (Object)e.getMessage(), (Object)e);
            }
        }
        if (stateDialog != null) {
            this.scheduleRemoveDialog(callId, stateDialog.getLocalUser(), stateDialog.getRemoteUser());
        }
        if (linkStateDialog != null) {
            this.scheduleRemoveDialog(linkedKey, linkStateDialog.getLocalUser(), linkStateDialog.getRemoteUser());
        }
    }

    public String[] getUsersfromCallId(String callId) {
        StateDialog stateDialog;
        StateDialog stateDialog2 = stateDialog = callId != null ? (StateDialog)this.stateMap.get(callId) : null;
        if (stateDialog != null) {
            String[] users = new String[]{stateDialog.getLocalUser(), stateDialog.getRemoteUser()};
            return users;
        }
        return null;
    }

    public String getCallStatusFromStateMachine(String key) {
        String callStatus = "Available";
        if (this.stateMap.containsKey(key)) {
            StateDialog stateDialog = (StateDialog)this.stateMap.get(key);
            if (stateDialog.getDirection().equals("initiator")) {
                if (stateDialog.getState().equalsIgnoreCase("ringing")) {
                    callStatus = "Call";
                } else if (stateDialog.getState().equalsIgnoreCase("confirmed")) {
                    callStatus = stateDialog.getHoldState() == null || stateDialog.getHoldState().equals("false") ? "Talk" : "Hold";
                }
            } else if (stateDialog.getState().equalsIgnoreCase("ringing")) {
                callStatus = "Ring";
            } else if (stateDialog.getState().equalsIgnoreCase("confirmed")) {
                callStatus = stateDialog.getHoldState() == null || stateDialog.getHoldState().equals("false") ? "Talk" : "Hold";
            }
        }
        return callStatus;
    }

    public String[] findCurrentUser(String callId) {
        if (this.stateMap.containsKey(callId)) {
            StateDialog sd = (StateDialog)this.stateMap.get(callId);
            if (sd.getDirection().equals("initiator")) {
                return new String[]{sd.getLocalUser(), sd.getRemoteUser()};
            }
            return new String[]{sd.getRemoteUser(), sd.getLocalUser()};
        }
        return null;
    }

    public boolean hasOtherActiveCallLegs(String user, String currentCallId) {
        StateDialog sd = (StateDialog)this.stateMap.get(currentCallId);
        if (sd == null) {
            return false;
        }
        String linkCallId = sd.getLinkCallId();
        return this.stateMap.values().stream().filter(s -> s.getLinkCallId() != null).filter(s -> !Objects.equals(s.getLinkCallId(), linkCallId)).anyMatch(s -> {
            if ("initiator".equalsIgnoreCase(s.getDirection())) {
                return user.equals(s.getLocalUser()) && this.isActiveState(s.getState());
            }
            return user.equals(s.getRemoteUser()) && this.isActiveState(s.getState());
        });
    }

    public boolean hasOtherConfirmCallLegs(String user, String currentCallId) {
        StateDialog sd = (StateDialog)this.stateMap.get(currentCallId);
        if (sd == null) {
            return false;
        }
        String linkCallId = sd.getLinkCallId();
        return this.stateMap.values().stream().filter(s -> s.getLinkCallId() != null).filter(s -> !Objects.equals(s.getLinkCallId(), linkCallId)).anyMatch(s -> {
            if ("initiator".equalsIgnoreCase(s.getDirection())) {
                return user.equals(s.getLocalUser()) && this.isConfirmedState(s.getState());
            }
            return user.equals(s.getRemoteUser()) && this.isConfirmedState(s.getState());
        });
    }

    public String[] getUsers_StateAndOtherUser(String user) {
        for (StateDialog dialog : this.stateMap.values()) {
            if (user.equals(dialog.getLocalUser())) {
                if ("true".equals(dialog.getHoldState())) {
                    return new String[]{"Hold", dialog.getRemoteUser()};
                }
                return new String[]{dialog.getState(), dialog.getRemoteUser()};
            }
            if (!user.equals(dialog.getRemoteUser())) continue;
            if ("true".equals(dialog.getHoldState())) {
                return new String[]{"Hold", dialog.getLocalUser()};
            }
            return new String[]{dialog.getState(), dialog.getLocalUser()};
        }
        return new String[]{"stale", " "};
    }

    public String[] getUsers_StateAndCallId(String user) {
        for (StateDialog dialog : this.stateMap.values()) {
            if (!user.equals(dialog.getLocalUser()) && !user.equals(dialog.getRemoteUser())) continue;
            return new String[]{dialog.getState(), dialog.getCallId()};
        }
        return new String[]{"stale", " "};
    }

    private boolean isActiveState(String state) {
        String lower = state.toLowerCase();
        return lower.equals("confirmed") || lower.equals("ringing") || lower.equals("trying");
    }

    private boolean isConfirmedState(String state) {
        String lower = state.toLowerCase();
        return lower.equals("confirmed");
    }

    public void releaseTerminatedDialog(String callId, String localUser, String remoteUser) {
        String functionName = "releaseTerminatedDialog";
        if (callId == null || callId.isEmpty()) {
            return;
        }
        if (this.stateMap.containsKey(callId) && !HelperIMS.DISCONNECTED_STATES.contains(((StateDialog)this.stateMap.get(callId)).getState())) {
            ((StateDialog)this.stateMap.get(callId)).setState("stale");
            this.releaseScheduler.schedule(() -> {
                StateDialog dialog = (StateDialog)this.stateMap.get(callId);
                if (dialog != null) {
                    this.stateMap.remove(callId);
                    this.helperIMS.printCustomLogs(className, functionName, "info", localUser, remoteUser, "Removing StateDialog forcefully for callid: " + callId + " ,localUser: " + localUser + " ,remoteUser: " + remoteUser);
                    this.removeCallFromUserMap(dialog.getLocalUser(), dialog.getRemoteUser());
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    public void setInOriginalCallbackMap(String fromUser, String toUser, String mediaType, long epoch) {
        String functionName = "setInOriginalCallbackMap";
        try {
            CallbackObject newCallback = new CallbackObject(fromUser, toUser, mediaType, epoch, this.helperIMS.getISTfromEpoch(Long.valueOf(epoch), TimeUnit.MILLISECONDS));
            ConcurrentSkipListSet skipList = this.callbackMap.computeIfAbsent(toUser, k -> new ConcurrentSkipListSet());
            skipList.removeIf(cb -> cb.getFromUser().equals(fromUser));
            skipList.add(newCallback);
            this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Added " + mediaType + " callback between " + fromUser + " & " + toUser + " at: " + newCallback.getScheduledAt());
        }
        catch (Exception e) {
            logger.error("Error in {} \n{}", (Object)functionName, (Object)e);
        }
    }

    public void removeFromOriginalCallbackMap(String fromUser, String toUser) {
        String functionName = "removeFromOGCallbackMap";
        try {
            this.callbackMap.computeIfPresent(toUser, (key, set) -> {
                set.removeIf(cb -> cb.getFromUser().equals(fromUser) && cb.getToUser().equals(toUser) || cb.getFromUser().equals(toUser) && cb.getToUser().equals(fromUser));
                return set.isEmpty() ? null : set;
            });
            this.callbackMap.computeIfPresent(fromUser, (key, set) -> {
                set.removeIf(cb -> cb.getFromUser().equals(fromUser) && cb.getToUser().equals(toUser) || cb.getFromUser().equals(toUser) && cb.getToUser().equals(fromUser));
                return set.isEmpty() ? null : set;
            });
            this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Removed callback(s) between " + fromUser + " & " + toUser);
        }
        catch (Exception e) {
            logger.error("Error in {} \n{}", (Object)functionName, (Object)e);
        }
    }

    public HelperIMS getHelperIMS() {
        return this.helperIMS;
    }

    public FeatureIMS getFeatureIMS() {
        return this.featureIMS;
    }

    public ImsV2ServerIMS getImsV2ServerIMS() {
        return this.imsV2ServerIMS;
    }

    public FeatureIMSService getFeatureIMSService() {
        return this.featureIMSService;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public ScheduledExecutorService getReleaseScheduler() {
        return this.releaseScheduler;
    }

    public ConcurrentHashMap<String, StateDialog> getStateMap() {
        return this.stateMap;
    }

    public ConcurrentHashMap<String, Set<String>> getLinkKeyMap() {
        return this.linkKeyMap;
    }

    public ConcurrentHashMap<String, String> getAssociateKeyMap() {
        return this.associateKeyMap;
    }

    public ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> getBackwardcallbackMap() {
        return this.backwardcallbackMap;
    }

    public ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> getForwardcallbackMap() {
        return this.forwardcallbackMap;
    }

    public ConcurrentHashMap<String, Boolean> getCallbackInProgress() {
        return this.callbackInProgress;
    }

    public ConcurrentHashMap<String, String> getMediaTypeMap() {
        return this.mediaTypeMap;
    }

    public void setHelperIMS(HelperIMS helperIMS) {
        this.helperIMS = helperIMS;
    }

    public void setFeatureIMS(FeatureIMS featureIMS) {
        this.featureIMS = featureIMS;
    }

    public void setImsV2ServerIMS(ImsV2ServerIMS imsV2ServerIMS) {
        this.imsV2ServerIMS = imsV2ServerIMS;
    }

    public void setFeatureIMSService(FeatureIMSService featureIMSService) {
        this.featureIMSService = featureIMSService;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void setReleaseScheduler(ScheduledExecutorService releaseScheduler) {
        this.releaseScheduler = releaseScheduler;
    }

    public void setStateMap(ConcurrentHashMap<String, StateDialog> stateMap) {
        this.stateMap = stateMap;
    }

    public void setLinkKeyMap(ConcurrentHashMap<String, Set<String>> linkKeyMap) {
        this.linkKeyMap = linkKeyMap;
    }

    public void setAssociateKeyMap(ConcurrentHashMap<String, String> associateKeyMap) {
        this.associateKeyMap = associateKeyMap;
    }

    private /* synthetic */ void lambda$handleInviteResponse$30(StateDialog stateDialog, SipURI fromURI, SipURI toURI, Long epochMillis) {
        stateDialog.setState("terminated");
        stateDialog.setDisconnectedBy(fromURI.getUser());
        stateDialog.setDisconnectedTo(toURI.getUser());
        stateDialog.setEndEpoch(String.valueOf(epochMillis));
        stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
    }

    private /* synthetic */ void lambda$handleInviteResponse$29(String localUser) {
        this.initiateCallBack(localUser, "backwardcallbackMap");
    }

    private /* synthetic */ void lambda$handleInviteResponse$28(StateDialog stateDialog, int statusCode, SipURI toURI, SipURI fromURI, Long epochMillis) {
        stateDialog.setState(statusCode == 480 ? "unavailable" : (statusCode == 486 ? "declined" : "cancelled"));
        stateDialog.setDisconnectedBy(toURI.getUser());
        stateDialog.setDisconnectedTo(fromURI.getUser());
        stateDialog.setEndEpoch(String.valueOf(epochMillis));
        stateDialog.setEndEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
    }

    private /* synthetic */ void lambda$handleInviteResponse$27(SipURI fromURI) {
        this.initiateCallBack(fromURI.getUser(), "forwardcallbackMap");
    }

    private /* synthetic */ void lambda$handleInviteResponse$26(SipURI fromURI) {
        this.initiateCallBack(fromURI.getUser(), "backwardcallbackMap");
    }

    private /* synthetic */ void lambda$handleInviteResponse$25(StateDialog stateDialog, Long epochMillis, Response response, String receivedFromUser, String receivedToUser) {
        stateDialog.setState("confirmed");
        stateDialog.setAnswerEpoch(String.valueOf(epochMillis));
        stateDialog.setAnswerEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
        stateDialog.setIsAnswered("true");
        if (response != null) {
            String in_Reply_Cause = Optional.ofNullable((ExtensionHeader)response.getHeader("In-REPLY-CAUSE")).map(ExtensionHeader::getValue).orElse(null);
            String fSUUId = Optional.ofNullable((ExtensionHeader)response.getHeader("X-FSUUID")).map(ExtensionHeader::getValue).orElse(null);
            if (fSUUId != null) {
                stateDialog.setFSUUID(fSUUId);
            }
            if (in_Reply_Cause == null && stateDialog.getState().equals("confirmed")) {
                String localUser = stateDialog.getLocalUser();
                String remoteUser = stateDialog.getRemoteUser();
                this.removeFromCallBackMap(localUser, remoteUser);
                this.removeFromCallBackMap(remoteUser, localUser);
                this.removeFromOriginalCallbackMap(localUser, remoteUser);
                if (Constants.HA_SYNC.booleanValue()) {
                    this.featureIMSService.publishCallbackWithTimeOnRedis(receivedFromUser, receivedToUser, "", System.currentTimeMillis(), "remove");
                }
                this.mediaTypeMap.remove(localUser + ":" + remoteUser);
                this.mediaTypeMap.remove(remoteUser + ":" + localUser);
            }
        }
    }

    private /* synthetic */ void lambda$handleInviteResponse$24(StateDialog stateDialog, Long epochMillis, String toTag) {
        stateDialog.setRingEpoch(String.valueOf(epochMillis));
        stateDialog.setRingEpochDate(this.helperIMS.getISTfromEpoch(epochMillis, TimeUnit.MILLISECONDS));
        stateDialog.setState("ringing");
        stateDialog.setRemoteTag(toTag);
    }
}

