/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.condition.EnableFEATUREIMS_SERVER;
import com.coraltele.db.telephony.main.entity.SipSubscription;
import com.coraltele.db.telephony.main.repository.SipSubscriptionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMSStateMachine;
import com.coraltele.ims.HelperIMS;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ResponseEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.address.Address;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.address.URI;
import com.coraltele.interfaces.sip.header.AcceptHeader;
import com.coraltele.interfaces.sip.header.AlertInfoHeader;
import com.coraltele.interfaces.sip.header.AuthorizationHeader;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.ContactHeader;
import com.coraltele.interfaces.sip.header.ContentTypeHeader;
import com.coraltele.interfaces.sip.header.EventHeader;
import com.coraltele.interfaces.sip.header.ExpiresHeader;
import com.coraltele.interfaces.sip.header.ExtensionHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.Header;
import com.coraltele.interfaces.sip.header.MaxForwardsHeader;
import com.coraltele.interfaces.sip.header.RecordRouteHeader;
import com.coraltele.interfaces.sip.header.ReferToHeader;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.header.SubscriptionStateHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.ViaHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.RequestEventExt;
import com.coraltele.javax.sip.ResponseEventExt;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.Utils;
import com.coraltele.javax.sip.header.HeaderFactoryImpl;
import com.coraltele.javax.sip.header.extensions.ReferredByHeader;
import com.coraltele.javax.sip.header.ims.PathHeader;
import com.coraltele.javax.sip.message.SIPRequest;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.service.FeatureIMSService;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableFEATUREIMS_SERVER.class})
public class FeatureIMS {
    private static String className = "FeatureIMS";
    private static final Logger logger = LogManager.getLogger(FeatureIMS.class);
    @Autowired
    private HelperIMS helperIMS;
    @Autowired
    private FeatureIMSService featureIMSService;
    @Autowired
    private SipSubscriptionRepository sipSubscriptionRepository;
    @Autowired
    private Optional<FeatureIMSStateMachine> featureIMSStateMachine;
    ScheduledThreadPoolExecutor featureIMSScheduler = null;
    BlockingQueue<Runnable> featureIMSQueue = null;
    ThreadPoolExecutor featureIMSExecutor = null;
    BlockingQueue<Runnable> stateMachineQueue = null;
    ThreadPoolExecutor stateMachineExecutor = null;
    public ConcurrentHashMap<String, ConcurrentHashMap<String, FeatureIMSService.RegisterObject>> userRegisterMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FeatureIMSService.SubscribeObject> subscribeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> call_uuidMap = new ConcurrentHashMap();

    public FeatureIMS() {
        this.featureIMSScheduler = new ScheduledThreadPoolExecutor(Constants.MAX_POOL_SIZE);
        this.featureIMSQueue = new LinkedBlockingQueue(100);
        this.featureIMSExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.featureIMSQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        logger.info("Initialized featureIMSExecutor with core: {}, max: {}", (Object)Constants.CORE_POOL_SIZE, (Object)Constants.MAX_POOL_SIZE);
        this.stateMachineQueue = new LinkedBlockingQueue(100);
        this.stateMachineExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.stateMachineQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        logger.info("Initialized stateMachineExecutor with core: {}, max: {}", (Object)Constants.CORE_POOL_SIZE, (Object)Constants.MAX_POOL_SIZE);
    }

    protected void featureIMSRequest(RequestEvent requestEvent) {
        try {
            this.featureIMSExecutor.submit(() -> this.handleFeatureIMSRequest(requestEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling featureIMSRequest {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected void featureIMSResponse(ResponseEvent responseEvent) {
        try {
            this.featureIMSExecutor.submit(() -> this.handleFeatureIMSResponse(responseEvent));
        }
        catch (Exception e) {
            logger.error("Error while handling featureIMSResponse {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected void handleFeatureIMSRequest(RequestEvent requestEvent) {
        String functionName = "handleFetureIMSRequest";
        boolean fromRegistrar = false;
        Request request = requestEvent.getRequest();
        CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callID = callIDHeader.getCallId();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        String remoteIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
        int remotePort = ((RequestEventExt)requestEvent).getRemotePort();
        String remoteIpPort = remoteIP + ":" + remotePort;
        String method = request.getMethod();
        if (!method.equalsIgnoreCase("OPTIONS") && !method.equalsIgnoreCase("INFO")) {
            this.helperIMS.printRequestLog(className, functionName, "Received", request, remoteIpPort, fromUser, toUser);
        }
        if (this.helperIMS.checkLoopInRequest(request, remoteIpPort, callID, request.getMethod(), fromUser, toUser)) {
            this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Loop Detected !!. Dropping the request !! \n" + request.toString());
            if (request.getMethod().equals("INVITE") || request.getMethod().equals("ACK") || request.getMethod().equals("CANCEL") || request.getMethod().equals("BYE")) {
                this.removefrom_calluuidMap(callID);
            }
            if (requestEvent.getServerTransaction() != null) {
                try {
                    requestEvent.getServerTransaction().terminate();
                }
                catch (Exception e) {
                    logger.error("Error while terminating loop detected transaction {}", (Throwable)e);
                }
            }
            return;
        }
        request = this.helperIMS.setUserAgentHeaderRequest(request, functionName);
        request = this.helperIMS.addReceivedParamInViaHeader(request, functionName, remoteIP);
        if (((MaxForwardsHeader)(request = this.helperIMS.handleMaxForwardheader(request, functionName)).getHeader("Max-Forwards")).getMaxForwards() <= 0) {
            this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "MaxForwards becomes to 0 so Dropping the request \n" + request);
        }
        if (this.helperIMS.isFromRegistrar(remoteIP, remotePort)) {
            fromRegistrar = true;
        }
        try {
            switch (request.getMethod()) {
                case "REGISTER": {
                    this.handleRegisterRequest(requestEvent);
                    break;
                }
                case "INVITE": {
                    this.handleInviteRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "BYE": {
                    this.handleByeRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "ACK": {
                    this.handleAckRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "CANCEL": {
                    this.handleCancelRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    this.handleSubscribeRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "REFER": {
                    this.handleReferRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "INFO": {
                    this.handleInfoRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "OPTIONS": {
                    this.handleOptionRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "MESSAGE": {
                    break;
                }
                case "UPDATE": {
                    this.handleUpdateRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "PUBLISH": {
                    this.handlePublishRequest(requestEvent, fromRegistrar);
                    break;
                }
                case "PRACK": {
                    break;
                }
                default: {
                    logger.error("Unhandled handleFeatureIMSRequest {}", (Object)request.getMethod());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleFeatureIMSRequest Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleRegisterRequest(RequestEvent requestEvent) {
        String functionName = "handleRegisterRequest";
        try {
            String userVirtualIP;
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            int listeningPort = Constants.LISTEN_UDP_PORT;
            int port = Constants.SIPREGISTRAR_PORT;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            String displayName = fromHeader.getAddress().getDisplayName();
            String domainName = ((SipURI)fromHeader.getAddress().getURI()).getHost();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            port = this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort");
            listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            AuthorizationHeader authorizationHeader = (AuthorizationHeader)request.getHeader("Authorization");
            if (authorizationHeader != null && authorizationHeader.getRealm() != null) {
                domainName = authorizationHeader.getRealm();
            }
            String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
            int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
            if (Constants.NAT.booleanValue()) {
                this.helperIMS.handleContactForNAT(request, null, proxyIP, proxyPort, "request", true);
            } else {
                this.helperIMS.handleContactForNAT(request, null, proxyIP, proxyPort, "request", false);
            }
            if (expiresHeader == null) {
                expiresHeader = contactHeader.getExpires() != -1 ? this.helperIMS.getHeaderFactory().createExpiresHeader(contactHeader.getExpires()) : this.helperIMS.getHeaderFactory().createExpiresHeader(0);
                request.setExpires(expiresHeader);
            }
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, " ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (Constants.RLUREGISTRATION_SYNC.booleanValue() && (userVirtualIP = this.helperIMS.getVirtualIP(fromUser)) != null) {
                if (userVirtualIP.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS) || userVirtualIP.equalsIgnoreCase(Constants.SIPREGISTRAR_IP)) {
                    this.asyncRegisterRequest(requestEvent);
                } else {
                    port = Constants.RLUREGISTRAR_PORT;
                }
            }
            Request registerRequest = (Request)request.clone();
            registerRequest = this.helperIMS.removeRouteHeaders(registerRequest, request.getMethod() + ":" + callID);
            SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)toHeader.getAddress().getURI()).getUser(), Constants.SIPREGISTRAR_IP);
            requestURI.setPort(port);
            requestURI.setTransportParam(viaHeaderTransport);
            registerRequest.setRequestURI((URI)requestURI);
            SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(((SipURI)fromHeader.getAddress().getURI()).getUser(), Constants.SIPREGISTRAR_IP);
            forwardURI.setPort(port);
            forwardURI.setTransportParam(viaHeaderTransport);
            forwardURI.setLrParam();
            Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
            RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
            registerRequest.addFirst((Header)routeHeader);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            registerRequest.addFirst((Header)viaHeader);
            SipURI pathURI = this.helperIMS.getAddressFactory().createSipURI(null, listeningIp);
            pathURI.setPort(listeningPort);
            pathURI.setTransportParam(viaHeaderTransport);
            pathURI.setLrParam();
            Address pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
            PathHeader newPathHeader = headerFactoryImpl.createPathHeader(pathAddress);
            registerRequest.addFirst((Header)newPathHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(registerRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            this.helperIMS.printRequestLog(className, functionName, "Send", registerRequest, null, fromUser, toUser);
            String encodedPathURI = URLEncoder.encode(pathAddress.toString(), StandardCharsets.UTF_8.name());
            ContactHeader localContactHeader = (ContactHeader)registerRequest.getHeader("Contact");
            ContactHeader clonedContactHeader = (ContactHeader)localContactHeader.clone();
            SipURI clonedContactUri = (SipURI)clonedContactHeader.getAddress().getURI();
            clonedContactUri.setParameter("fs_path", encodedPathURI);
            if (displayName == null || displayName.length() <= 0) {
                displayName = fromUser;
            }
            String contactWithPath = "\"" + displayName + "\" " + clonedContactHeader.getAddress();
            this.insertOrUpdateinUserRegisterMap(fromUser, callID, this.featureIMSService.makeRegisterObject(callID, fromUser, contactWithPath, listeningIp, String.valueOf(listeningPort), viaHeaderTransport, expiresHeader.getExpires(), domainName, localContactHeader.getAddress().getURI().toString()));
        }
        catch (Exception e) {
            logger.error("handleRegisterRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void asyncRegisterRequest(RequestEvent requestEvent) {
        String functionName = "asyncRegisterRequest";
        try {
            this.featureIMSExecutor.submit(() -> {
                Request request = requestEvent.getRequest();
                if (this.helperIMS.getRluVirtualIpSet() != null && !this.helperIMS.getRluVirtualIpSet().isEmpty()) {
                    String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
                    String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
                    for (String rluVirtualIP : this.helperIMS.getRluVirtualIpSet()) {
                        if (rluVirtualIP == null || rluVirtualIP.equals(Constants.LISTEN_IP_ADDRESS) || rluVirtualIP.equals(Constants.SIPREGISTRAR_IP)) continue;
                        this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, fromUser, "Initiated ForkRequest for toUser : " + fromUser + " Sent to " + rluVirtualIP + " for callId: " + callId);
                        this.forkRegisterRequest(requestEvent, rluVirtualIP);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while handling asyncRegisterRequest {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void forkRegisterRequest(RequestEvent requestEvent, String rluVirtualIP) {
        String functionName = "forkRegisterRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            String listeningIp = Constants.LISTEN_IP_ADDRESS;
            int listeningPort = Constants.LISTEN_UDP_PORT;
            Request request = (Request)requestEvent.getRequest().clone();
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            Request forkRequest = (Request)request.clone();
            forkRequest = this.helperIMS.removeRouteHeaders(forkRequest, request.getMethod() + ":" + callID);
            forkRequest.removeFirst("Authorization");
            SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(fromUser, rluVirtualIP);
            requestURI.setPort(listeningPort);
            requestURI.setTransportParam(viaHeaderTransport);
            forkRequest.setRequestURI((URI)requestURI);
            SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(fromUser, rluVirtualIP);
            forwardURI.setPort(listeningPort);
            forwardURI.setTransportParam(viaHeaderTransport);
            forwardURI.setLrParam();
            Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
            RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
            forkRequest.addFirst((Header)routeHeader);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(listeningIp, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            forkRequest.addFirst((Header)viaHeader);
            SipURI pathURI = this.helperIMS.getAddressFactory().createSipURI(null, listeningIp);
            pathURI.setPort(listeningPort);
            pathURI.setLrParam();
            pathURI.setTransportParam(viaHeaderTransport);
            Address pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
            PathHeader pathHeader = headerFactoryImpl.createPathHeader(pathAddress);
            forkRequest.addFirst((Header)pathHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(forkRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            this.helperIMS.printRequestLog(className, functionName, "Send", forkRequest, null, fromUser, fromUser);
        }
        catch (Exception e) {
            logger.error("forkRegisterRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleInviteRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String remotePartyId = Optional.ofNullable((ExtensionHeader)request.getHeader("Remote-Party-ID")).map(ExtensionHeader::getValue).orElse(null);
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            Address fromAddress = fromHeader.getAddress();
            String fromUser = ((SipURI)fromAddress.getURI()).getUser();
            String fromName = fromAddress.getDisplayName();
            if (fromName != null && !fromName.isEmpty() && fromName.equalsIgnoreCase("Unavailable")) {
                fromName = fromUser;
                fromAddress.setDisplayName(fromName);
            }
            if (remotePartyId != null && !remotePartyId.isEmpty() && (remotePartyId.contains("Unavailable") || remotePartyId.contains("unavailable"))) {
                remotePartyId = remotePartyId.replace("Unavailable", fromUser);
                remotePartyId = remotePartyId.replace("unavailable", fromUser);
                Header newRemotePartyIdHeader = this.helperIMS.getHeaderFactory().createHeader("Remote-Party-ID", remotePartyId);
                request.removeHeader("Remote-Party-ID");
                request.addHeader(newRemotePartyIdHeader);
            }
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            AlertInfoHeader alertInfoHeader = (AlertInfoHeader)request.getHeader("Alert-Info");
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: {}" + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (this.helperIMS.checkExtensionGivenType(toUser, "enm")) {
                Response response = this.helperIMS.getMessageFactory().createResponse(480, request);
                response.setReasonPhrase("ENM Triggered successfully");
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                } else {
                    sipProvider.sendResponse(response);
                }
                this.featureIMSExecutor.submit(() -> this.sendCustomNotify(fromUser, toUser));
                return;
            }
            Request inviteRequest = null;
            inviteRequest = (Request)request.clone();
            inviteRequest = this.helperIMS.removeRouteHeaders(inviteRequest, request.getMethod() + ":" + callID);
            if (fromRegistrar && alertInfoHeader == null) {
                String alertInfoValue = this.helperIMS.getUnrecognizedHeaderValue(request, "Alert-Info", "handleInviteRequest");
                alertInfoValue = alertInfoValue.replaceAll("^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$", "");
                SipURI alertInfoURI = this.helperIMS.getAddressFactory().createSipURI(toUser, Constants.LISTEN_IP_ADDRESS);
                alertInfoHeader = this.helperIMS.getHeaderFactory().createAlertInfoHeader((URI)alertInfoURI);
                alertInfoHeader.setParameter("info", alertInfoValue);
                inviteRequest.setHeader((Header)alertInfoHeader);
            }
            SipURI requestURI = (SipURI)inviteRequest.getRequestURI();
            if (!fromRegistrar && requestEvent.getDialog() == null) {
                requestURI.setHost(Constants.SIPREGISTRAR_IP);
                requestURI.setPort(this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort"));
                requestURI.setTransportParam(viaHeaderTransport);
                inviteRequest.setRequestURI((URI)requestURI);
            }
            if (Constants.NAT.booleanValue()) {
                if (fromRegistrar) {
                    this.helperIMS.modifySDP(inviteRequest, null, "request", "IP4", Constants.PUBLIC_IP_ADDRESS);
                }
                if (!fromRegistrar) {
                    String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                    int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                    this.helperIMS.handleContactForNAT(inviteRequest, null, proxyIP, proxyPort, "request", true);
                }
                this.helperIMS.addRecordRouteHeader(inviteRequest, Constants.PUBLIC_IP_ADDRESS, listeningPort, viaHeaderTransport, "handleInviteRequest", fromUser, toUser);
            } else {
                this.helperIMS.addRecordRouteHeader(inviteRequest, Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, "handleInviteRequest", fromUser, toUser);
            }
            if (requestEvent.getDialog() != null) {
                inviteRequest = this.updateIpPortInRequestURI(inviteRequest, viaHeaderTransport, fromUser, toUser);
            }
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            inviteRequest.addFirst((Header)viaHeader);
            ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(inviteRequest);
            clientTransaction.setApplicationData((Object)serverTransaction);
            serverTransaction.setApplicationData((Object)clientTransaction);
            SIPDialog clientDialog = (SIPDialog)clientTransaction.getDialog();
            SIPDialog serverDialog = (SIPDialog)serverTransaction.getDialog();
            if (toHeader.getTag() != null && requestEvent.getDialog() == null && serverDialog.getRemoteTarget() == null && serverDialog != null && request.getHeader("Contact") != null) {
                serverDialog.setRemoteTarget((ContactHeader)request.getHeader("Contact"));
            }
            if (serverDialog != null && clientDialog != null) {
                clientDialog.setApplicationData((Object)serverDialog);
                serverDialog.setApplicationData((Object)clientDialog);
            }
            clientTransaction.sendRequest();
            this.helperIMS.printRequestLog(className, functionName, "Send", inviteRequest, null, fromUser, toUser);
            if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue() && requestEvent.getDialog() == null && fromRegistrar) {
                String X_coral_sbc_callid = Optional.ofNullable((ExtensionHeader)request.getHeader("X-coral_sbc_callid")).map(ExtensionHeader::getValue).orElse(null);
                String X_FSUUID = Optional.ofNullable((ExtensionHeader)request.getHeader("X-FSUUID")).map(ExtensionHeader::getValue).orElse(null);
                if (toHeader.getTag() == null) {
                    this.call_uuidMap.put(callID, callID);
                    if (X_FSUUID != null && X_coral_sbc_callid != null) {
                        this.call_uuidMap.put(X_coral_sbc_callid, X_FSUUID);
                    }
                } else if (toHeader.getTag() != null && X_FSUUID != null && X_coral_sbc_callid != null) {
                    this.call_uuidMap.put(callID, callID);
                    this.call_uuidMap.put(X_coral_sbc_callid, X_FSUUID);
                }
            }
            if (Constants.V2STATE_MACHINE.booleanValue()) {
                SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
                this.stateMachineExecutor.submit(() -> {
                    try {
                        ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onInviteUpdate(dialog, fromRegistrar, fromUser, toUser);
                    }
                    catch (Exception e) {
                        logger.error("Error while calling featureIMSStateMachine.onInviteUpdate for callID: {}", (Object)callID, (Object)e);
                    }
                });
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleInviteRequest Method: {}  callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleByeRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleByeRequest";
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callID = callIDHeader.getCallId();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
        int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
        try {
            Request byeRequest = (Request)request.clone();
            byeRequest = this.helperIMS.removeRouteHeaders(byeRequest, request.getMethod() + ":" + callID);
            byeRequest = this.updateIpPortInRequestURI(byeRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            byeRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(byeRequest);
                ct.setApplicationData((Object)serverTransaction);
                SIPDialog sipDialog = (SIPDialog)ct.getDialog();
                if (sipDialog != null) {
                    sipDialog.sendRequest(ct);
                } else {
                    sipProvider.sendRequest(byeRequest);
                }
            } else {
                sipProvider.sendRequest(byeRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", byeRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleByeRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
            try {
                if (this.call_uuidMap.containsKey(callID)) {
                    this.featureIMSExecutor.submit(() -> {
                        this.SyncRecoveryData((String)this.call_uuidMap.get(callID), "BYE");
                        this.removefrom_calluuidMap(callID);
                    });
                } else {
                    this.helperIMS.printCustomLogs(className, functionName, "warn", fromUser, toUser, "Uuid is not present in call_uuidMap. Sending callid : " + callID + " for RecoverySync operation for BYE method.");
                    this.featureIMSExecutor.submit(() -> {
                        this.SyncRecoveryData(callID, "BYE");
                        this.removefrom_calluuidMap(callID);
                    });
                }
            }
            catch (Exception e) {
                logger.error("Error while submitting recoverysync task to featureIMSexecutor thread {}", (Throwable)e);
            }
        }
        if (Constants.V2STATE_MACHINE.booleanValue() && serverTransaction != null && serverTransaction.getDialog() != null) {
            SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
            this.stateMachineExecutor.submit(() -> {
                try {
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onByeUpdate(dialog, fromRegistrar, fromUser, toUser);
                }
                catch (Exception e) {
                    logger.error("Error while calling featureIMSStateMachine.onByeUpdate for callID: {}", (Object)callID, (Object)e);
                }
            });
        }
    }

    private void handleAckRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleAckRequest";
        Request request = requestEvent.getRequest();
        CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callID = callIDHeader.getCallId();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
            if (!this.call_uuidMap.containsKey(callID)) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "UUID is missing in map .Skipping Sync for this callId " + callID);
                return;
            }
            try {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "scheduling recoveryDatasync thread with delay for callID " + callID);
                this.featureIMSScheduler.schedule(() -> this.SyncRecoveryData((String)this.call_uuidMap.get(callID), "INVITE"), (long)Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                logger.error("Error in {} while creating thread for SyncRecoveryData in INVITE {}", (Object)callID, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void handleCancelRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleCancelRequest";
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        Request request = requestEvent.getRequest();
        String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "No associated serverTransaction found for callid:" + callID + ".Dropping the request \n" + request);
                return;
            }
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            SIPDialog serverDialog = (SIPDialog)serverTransaction.getDialog();
            SIPDialog clientDialog = serverDialog != null ? (SIPDialog)serverDialog.getApplicationData() : null;
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            response = this.helperIMS.setUserAgentHeaderResponse(response, request.getMethod());
            serverTransaction.sendResponse(response);
            this.helperIMS.printResponseLog(className, functionName, "Send", response, null, fromUser, toUser);
            Request cancelRequest = (Request)request.clone();
            cancelRequest = this.helperIMS.removeRouteHeaders(cancelRequest, request.getMethod() + ":" + callID);
            if (!fromRegistrar) {
                SipURI requestURI = (SipURI)cancelRequest.getRequestURI();
                requestURI.setHost(Constants.SIPREGISTRAR_IP);
                requestURI.setPort(this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort"));
                requestURI.setTransportParam(viaHeaderTransport);
                cancelRequest.setRequestURI((URI)requestURI);
            }
            String topMostViaBranch = null;
            if (clientDialog != null && clientDialog.getLastTransaction() != null) {
                topMostViaBranch = clientDialog.getLastTransaction().getBranchId();
            } else if (clientDialog != null && clientDialog.getFirstTransactionInt() != null) {
                topMostViaBranch = clientDialog.getFirstTransactionInt().getBranchId();
            } else if (clientDialog != null && clientDialog.getLastResponseTopMostVia() != null) {
                topMostViaBranch = clientDialog.getLastResponseTopMostVia().getBranch();
            } else {
                String sipClientDialogID = ((SIPRequest)cancelRequest).getDialogId(false);
                SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
                SIPDialog sipClientDialog = sipStackImpl.getDialog(sipClientDialogID);
                if (sipClientDialog == null) {
                    sipClientDialog = sipStackImpl.getEarlyDialog(sipClientDialogID);
                }
                if (sipClientDialog != null && sipClientDialog.getLastTransaction() != null) {
                    topMostViaBranch = sipClientDialog.getLastTransaction().getBranchId();
                }
            }
            if (topMostViaBranch == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "No associated Transaction found . Dropping cancel Request for callId" + callID + " \n" + cancelRequest);
                return;
            }
            cancelRequest = this.updateIpPortInRequestURI(cancelRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, topMostViaBranch);
            viaHeader.setRPort();
            cancelRequest.addFirst((Header)viaHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(cancelRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            this.helperIMS.printRequestLog(className, functionName, "Send", cancelRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleCancelRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        this.removefrom_calluuidMap(((CallIdHeader)requestEvent.getRequest().getHeader("Call-ID")).getCallId());
        if (Constants.V2STATE_MACHINE.booleanValue() && serverTransaction != null && serverTransaction.getDialog() != null) {
            SIPDialog dialog = (SIPDialog)serverTransaction.getDialog();
            this.stateMachineExecutor.submit(() -> {
                try {
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onCancelUpdate(dialog, fromRegistrar, fromUser, toUser);
                }
                catch (Exception e) {
                    logger.error("Error while calling featureIMSStateMachine.onCancelUpdate in catch for ", (Throwable)e);
                }
            });
        }
    }

    private void handleReferRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleReferRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ReferToHeader referToHeader = (ReferToHeader)request.getHeader("Refer-To");
            ReferredByHeader referredByHeader = (ReferredByHeader)request.getHeader("Referred-By");
            SipURI referredByUri = (SipURI)referredByHeader.getAddress().getURI();
            referredByUri.setHost(Constants.LISTEN_IP_ADDRESS);
            referredByUri.setPort(listeningPort);
            referredByUri.setTransportParam(viaHeaderTransport);
            String replacesValue = referredByUri.getHeader("Replaces");
            if (replacesValue == null || replacesValue.isEmpty()) {
                String encodedCallId = URLEncoder.encode(callID, StandardCharsets.UTF_8.name());
                referredByHeader.setParameter("token", encodedCallId);
            }
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request referRequest = (Request)request.clone();
            referRequest = this.helperIMS.removeRouteHeaders(referRequest, request.getMethod() + ":" + callID);
            if (Constants.NAT.booleanValue()) {
                String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                this.helperIMS.handleContactForNAT(referRequest, null, proxyIP, proxyPort, "request", true);
            }
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            referRequest.addFirst((Header)viaHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(referRequest);
            ct.setApplicationData((Object)serverTransaction);
            ct.sendRequest();
            this.helperIMS.printRequestLog(className, functionName, "Send", referRequest, null, fromUser, toUser);
            if (Constants.V2STATE_MACHINE.booleanValue() && !fromRegistrar) {
                SIPDialog dialog = (SIPDialog)requestEvent.getDialog();
                this.stateMachineExecutor.submit(() -> {
                    try {
                        ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).onReferUpdate(dialog, referToHeader, referredByHeader, fromUser, toUser);
                    }
                    catch (Exception e) {
                        logger.error("Error while calling featureIMSStateMachine.onReferUpdate for callID: {}", (Object)callID, (Object)e);
                    }
                });
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleReferRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        try {
            Request request = requestEvent.getRequest();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            if (eventHeader != null && eventHeader.getEventType().equals("message-summary")) {
                this.handleRegisterNotifyRequest(requestEvent, fromRegistrar);
            } else if (eventHeader != null && eventHeader.getEventType().equals("refer")) {
                this.handleReferNotifyRequest(requestEvent, fromRegistrar);
            } else if (eventHeader != null && eventHeader.getEventType().equals("talk")) {
                this.handleAutoAnswerNotifyRequest(requestEvent, fromRegistrar);
            } else {
                this.handleSubscribeNotifyRequest(requestEvent, fromRegistrar);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleRegisterNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleRegisterNotifyRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            int listeningPort = Constants.LISTEN_UDP_PORT;
            Request request = requestEvent.getRequest();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            Request registerNotifyRequest = (Request)request.clone();
            registerNotifyRequest = this.helperIMS.removeRouteHeaders(registerNotifyRequest, request.getMethod() + ":" + callID);
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            registerNotifyRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(registerNotifyRequest);
                clientTransaction.setApplicationData((Object)serverTransaction);
                Dialog dialog = clientTransaction.getDialog();
                if (dialog != null) {
                    dialog.sendRequest(clientTransaction);
                } else {
                    serverTransaction.terminate();
                    clientTransaction.terminate();
                    sipProvider.sendRequest(registerNotifyRequest);
                }
            } else {
                sipProvider.sendRequest(registerNotifyRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", registerNotifyRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleRegisterNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleReferNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleReferNotifyRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            Request referNotifyRequest = null;
            referNotifyRequest = (Request)request.clone();
            referNotifyRequest = this.helperIMS.removeRouteHeaders(referNotifyRequest, request.getMethod() + ":" + callID);
            referNotifyRequest = this.updateIpPortInRequestURI(referNotifyRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            referNotifyRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(referNotifyRequest);
                ct.setApplicationData((Object)serverTransaction);
                Dialog dialog = ct.getDialog();
                dialog.sendRequest(ct);
            } else {
                sipProvider.sendRequest(referNotifyRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", referNotifyRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleReferNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleAutoAnswerNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleAutoAnswerNotifyRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            Request autoAnswerNotifyRequest = null;
            autoAnswerNotifyRequest = (Request)request.clone();
            autoAnswerNotifyRequest = this.helperIMS.removeRouteHeaders(autoAnswerNotifyRequest, request.getMethod() + ":" + callID);
            autoAnswerNotifyRequest = this.updateIpPortInRequestURI(autoAnswerNotifyRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            autoAnswerNotifyRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(autoAnswerNotifyRequest);
                ct.setApplicationData((Object)serverTransaction);
                Dialog dialog = ct.getDialog();
                dialog.sendRequest(ct);
            } else {
                sipProvider.sendRequest(autoAnswerNotifyRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", autoAnswerNotifyRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleAutoAnswerNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleSubscribeNotifyRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleSubscribeNotifyRequest";
        try {
            String virtualIp;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            SubscriptionStateHeader subscriptionState = (SubscriptionStateHeader)request.getHeader("Subscription-State");
            ServerTransaction serverTransaction = (ServerTransaction)((SIPRequest)request).getTransaction();
            Request subscribeNotifyRequest = null;
            SipURI forwardURI = null;
            subscribeNotifyRequest = (Request)request.clone();
            subscribeNotifyRequest = this.helperIMS.removeRouteHeaders(subscribeNotifyRequest, request.getMethod() + ":" + callID);
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            if (serverTransaction == null) {
                sipProvider.sendResponse(response);
            }
            if (!(eventHeader != null || subscriptionState != null && subscriptionState.getState().equalsIgnoreCase("terminated"))) {
                eventHeader = this.helperIMS.getHeaderFactory().createEventHeader("dialog");
                subscribeNotifyRequest.addFirst((Header)eventHeader);
            }
            if ((virtualIp = this.helperIMS.getVirtualIP(toUser)) != null && !virtualIp.equalsIgnoreCase(Constants.SIPREGISTRAR_IP) && !virtualIp.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS) && expiresHeader == null) {
                forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, virtualIp);
                forwardURI.setPort(listeningPort);
                forwardURI.setTransportParam(viaHeaderTransport);
                forwardURI.setLrParam();
                Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
                RouteHeader routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(address);
                subscribeNotifyRequest.addFirst((Header)routeHeader);
            }
            subscribeNotifyRequest = this.updateIpPortInRequestURI(subscribeNotifyRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            subscribeNotifyRequest.addFirst((Header)viaHeader);
            if (subscriptionState != null && subscriptionState.getState().equalsIgnoreCase("terminated")) {
                if (serverTransaction != null) {
                    serverTransaction.terminate();
                }
                sipProvider.sendRequest(subscribeNotifyRequest);
            } else if (serverTransaction != null) {
                ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(subscribeNotifyRequest);
                clientTransaction.setApplicationData((Object)serverTransaction);
                if (clientTransaction.getDialog() != null) {
                    Dialog clientDialog = clientTransaction.getDialog();
                    clientDialog.sendRequest(clientTransaction);
                } else {
                    clientTransaction.terminate();
                    serverTransaction.terminate();
                    sipProvider.sendRequest(subscribeNotifyRequest);
                }
            } else {
                sipProvider.sendRequest(subscribeNotifyRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", subscribeNotifyRequest, null, fromUser, toUser);
            if (subscriptionState != null && subscriptionState.getState().equalsIgnoreCase("terminated")) {
                String clientDialogID = ((SIPRequest)subscribeNotifyRequest).getDialogId(false);
                String serverDialogID = ((SIPRequest)subscribeNotifyRequest).getDialogId(true);
                SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
                SIPDialog clientSipDialog = sipStackImpl.getDialog(clientDialogID);
                SIPDialog serverSipDialog = sipStackImpl.getDialog(serverDialogID);
                if (clientSipDialog != null) {
                    clientSipDialog.setState(3);
                }
                if (serverSipDialog != null) {
                    serverSipDialog.setState(3);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in handleSubscribeNotifyRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleSubscribeRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleSubscribeRequest";
        try {
            String virtualIP = null;
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            RecordRouteHeader recordRouteHeader = (RecordRouteHeader)request.getHeader("Record-Route");
            ServerTransaction serverTransaction = (ServerTransaction)((SIPRequest)request).getTransaction();
            HeaderFactoryImpl headerFactoryImpl = (HeaderFactoryImpl)this.helperIMS.getHeaderFactory();
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            AcceptHeader acceptHeader = (AcceptHeader)request.getHeader("Accept");
            ExpiresHeader expiresHeader = (ExpiresHeader)request.getHeader("Expires");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String displayName = fromHeader.getAddress().getDisplayName();
            String domainName = ((SipURI)fromHeader.getAddress().getURI()).getHost();
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            AuthorizationHeader authorizationHeader = (AuthorizationHeader)request.getHeader("Authorization");
            if (authorizationHeader != null && authorizationHeader.getRealm() != null) {
                domainName = authorizationHeader.getRealm();
            }
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (eventHeader == null) {
                eventHeader = acceptHeader != null && acceptHeader.getContentSubType().equalsIgnoreCase("simple-messsage-summary") ? this.helperIMS.getHeaderFactory().createEventHeader("message-summary") : this.helperIMS.getHeaderFactory().createEventHeader("dialog");
                request.addHeader((Header)eventHeader);
            }
            if (acceptHeader == null) {
                acceptHeader = eventHeader.getEventType().equals("message-summary") ? this.helperIMS.getHeaderFactory().createAcceptHeader("application", "simple-message-summary") : this.helperIMS.getHeaderFactory().createAcceptHeader("application", "dialog-info+xml");
                request.addHeader((Header)acceptHeader);
            }
            Request subscribeRequest = null;
            subscribeRequest = (Request)request.clone();
            subscribeRequest = this.helperIMS.removeRouteHeaders(subscribeRequest, request.getMethod() + ":" + callID);
            if (Constants.NAT.booleanValue()) {
                String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                this.helperIMS.handleContactForNAT(subscribeRequest, null, proxyIP, proxyPort, "request", true);
            }
            if (!fromRegistrar) {
                SipURI requestURI = this.helperIMS.getAddressFactory().createSipURI(toUser, Constants.SIPREGISTRAR_IP);
                requestURI.setPort(this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort"));
                virtualIP = this.helperIMS.getVirtualIP(toUser);
                if (virtualIP == null || virtualIP.equalsIgnoreCase(Constants.SIPREGISTRAR_IP) || virtualIP.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS)) {
                    requestURI = this.helperIMS.getAddressFactory().createSipURI(toUser, Constants.SIPREGISTRAR_IP);
                    requestURI.setPort(this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort"));
                } else {
                    requestURI = this.helperIMS.getAddressFactory().createSipURI(toUser, virtualIP);
                    requestURI.setPort(listeningPort);
                }
                requestURI.setTransportParam(viaHeaderTransport);
                subscribeRequest.setRequestURI((URI)requestURI);
            }
            SipURI pathURI = null;
            Address pathAddress = null;
            if (toHeader.getTag() == null) {
                pathURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                pathURI.setPort(listeningPort);
                pathURI.setLrParam();
                pathURI.setTransportParam(viaHeaderTransport);
                pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
                PathHeader pathHeader = headerFactoryImpl.createPathHeader(pathAddress);
                subscribeRequest.addFirst((Header)pathHeader);
            }
            SipURI forwardURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
            forwardURI.setPort(listeningPort);
            forwardURI.setLrParam();
            forwardURI.setTransportParam(viaHeaderTransport);
            Address address = this.helperIMS.getAddressFactory().createAddress((URI)forwardURI);
            recordRouteHeader = this.helperIMS.getHeaderFactory().createRecordRouteHeader(address);
            subscribeRequest.addFirst((Header)recordRouteHeader);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            subscribeRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(subscribeRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                sipProvider.sendRequest(subscribeRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", subscribeRequest, null, fromUser, toUser);
            if (Constants.HA_SYNC.booleanValue() && (virtualIP == null || virtualIP.equalsIgnoreCase(Constants.SIPREGISTRAR_IP) || virtualIP.equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS))) {
                if (pathURI == null || pathAddress == null) {
                    pathURI = this.helperIMS.getAddressFactory().createSipURI(null, Constants.LISTEN_IP_ADDRESS);
                    pathURI.setPort(listeningPort);
                    pathURI.setLrParam();
                    pathURI.setTransportParam(viaHeaderTransport);
                    pathAddress = this.helperIMS.getAddressFactory().createAddress((URI)pathURI);
                }
                ContactHeader localContactHeader = (ContactHeader)subscribeRequest.getHeader("Contact");
                ContactHeader clonedContactHeader = (ContactHeader)localContactHeader.clone();
                SipURI ClonedContactUri = (SipURI)clonedContactHeader.getAddress().getURI();
                String encodedPathURI = URLEncoder.encode(pathAddress.toString(), StandardCharsets.UTF_8.name());
                ClonedContactUri.setParameter("fs_path", encodedPathURI);
                if (displayName == null || displayName.length() <= 0) {
                    displayName = fromUser;
                }
                String contactWithPath = "\"" + displayName + "\" " + clonedContactHeader.getAddress();
                String event = eventHeader != null ? eventHeader.getEventType() : null;
                String accept = acceptHeader != null ? acceptHeader.toString() : null;
                String via = viaHeader.toString();
                String from = fromHeader.toString();
                String acceptValue = accept != null ? accept.substring(accept.indexOf(":") + 2).trim() : null;
                String viaValue = via.substring(via.indexOf(":") + 2).trim();
                String fromValue = from.substring(from.indexOf(":") + 2).trim();
                this.subscribeMap.put(callID, this.featureIMSService.makeSubscribeObject(fromUser, toUser, event, contactWithPath, callID, fromValue, viaValue, expiresHeader.getExpires(), Constants.USER_AGENT, acceptValue, Constants.LISTEN_IP_ADDRESS, String.valueOf(listeningPort), "", domainName, localContactHeader.getAddress().getURI().toString()));
            }
        }
        catch (Exception ex) {
            logger.error("Error in hanldeSubscribeRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleInfoRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleInfoRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid:" + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            if (Constants.NAT.booleanValue()) {
                String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                this.helperIMS.handleContactForNAT(request, null, proxyIP, proxyPort, "request", true);
            }
            Request infoRequest = null;
            infoRequest = (Request)request.clone();
            infoRequest = this.helperIMS.removeRouteHeaders(infoRequest, request.getMethod() + ":" + callID);
            infoRequest = this.updateIpPortInRequestURI(infoRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            infoRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(infoRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                sipProvider.sendRequest(infoRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", infoRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleInfoRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handleOptionRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleOptionRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Response response = this.helperIMS.getMessageFactory().createResponse(200, request);
            response = this.helperIMS.setUserAgentHeaderResponse(response, request.getMethod());
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            logger.error("handleOptionRequest Error while forwarding Request{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleUpdateRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handleUpdateRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request updateRequest = null;
            updateRequest = (Request)request.clone();
            if (Constants.NAT.booleanValue()) {
                String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                this.helperIMS.handleContactForNAT(updateRequest, null, proxyIP, proxyPort, "request", true);
            }
            updateRequest = this.helperIMS.removeRouteHeaders(updateRequest, request.getMethod() + ":" + callID);
            updateRequest = this.updateIpPortInRequestURI(updateRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            updateRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(updateRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                sipProvider.sendRequest(updateRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", updateRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handleUpdateRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void handlePublishRequest(RequestEvent requestEvent, boolean fromRegistrar) {
        String functionName = "handlePublishRequest";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            CallIdHeader callIDHeader = (CallIdHeader)request.getHeader("Call-ID");
            String callID = callIDHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String viaHeaderTransport = ((ViaHeader)request.getHeader("Via")).getTransport().toUpperCase();
            int listeningPort = this.getPortAccordingToTransport(viaHeaderTransport, "listeningPort");
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction == null) {
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "ServerTransaction is null for callid: " + callID);
                serverTransaction = sipProvider.getNewServerTransaction(request);
            }
            Request publishRequest = null;
            publishRequest = (Request)request.clone();
            if (Constants.NAT.booleanValue()) {
                String proxyIP = ((RequestEventExt)requestEvent).getRemoteIpAddress();
                int proxyPort = ((RequestEventExt)requestEvent).getRemotePort();
                this.helperIMS.handleContactForNAT(publishRequest, null, proxyIP, proxyPort, "request", true);
            }
            if (!fromRegistrar) {
                SipURI requestURI = (SipURI)publishRequest.getRequestURI();
                requestURI.setHost(Constants.SIPREGISTRAR_IP);
                requestURI.setPort(this.getPortAccordingToTransport(viaHeaderTransport, "sipRegistrarPort"));
                requestURI.setTransportParam(viaHeaderTransport);
                publishRequest.setRequestURI((URI)requestURI);
            }
            publishRequest = this.helperIMS.removeRouteHeaders(publishRequest, request.getMethod() + ":" + callID);
            publishRequest = this.updateIpPortInRequestURI(publishRequest, viaHeaderTransport, fromUser, toUser);
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listeningPort, viaHeaderTransport, null);
            viaHeader.setRPort();
            publishRequest.addFirst((Header)viaHeader);
            if (serverTransaction != null) {
                ClientTransaction ct = sipProvider.getNewClientTransaction(publishRequest);
                ct.setApplicationData((Object)serverTransaction);
                ct.sendRequest();
            } else {
                sipProvider.sendRequest(publishRequest);
            }
            this.helperIMS.printRequestLog(className, functionName, "Send", publishRequest, null, fromUser, toUser);
        }
        catch (Exception ex) {
            logger.error("Error in handlePublishRequest Method: {} : callID: {} Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)requestEvent.getRequest().getHeader("Call-ID"), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    protected void handleFeatureIMSResponse(ResponseEvent responseEvent) {
        String functionName = "handleFeatureIMSResponse";
        Response response = responseEvent.getResponse();
        Response newResponse = null;
        try {
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            String methodName = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
            boolean fromRegistrar = false;
            String remoteIp = ((ResponseEventExt)responseEvent).getRemoteIpAddress();
            int remotePort = ((ResponseEventExt)responseEvent).getRemotePort();
            String remoteIpPort = remoteIp + ":" + remotePort;
            this.helperIMS.printResponseLog(className, functionName, "Received", response, remoteIpPort, fromUser, toUser);
            response = this.helperIMS.setUserAgentHeaderResponse(response, methodName);
            if (response.getStatusCode() == 100) {
                return;
            }
            String remoteIP = ((ResponseEventExt)responseEvent).getRemoteIpAddress();
            if (this.helperIMS.isFromRegistrar(remoteIP, remotePort)) {
                fromRegistrar = true;
            }
            switch (methodName) {
                case "REGISTER": {
                    this.handleRegisterResponse(responseEvent, fromRegistrar);
                    break;
                }
                case "INVITE": {
                    this.handleInviteResponse(responseEvent, fromRegistrar);
                    break;
                }
                case "SUBSCRIBE": {
                    this.handleSubscribeResponse(responseEvent);
                    break;
                }
                case "BYE": {
                    this.handleByeResponse(responseEvent);
                    break;
                }
                case "CANCEL": {
                    break;
                }
                case "REFER": {
                    this.handleReferResponse(responseEvent);
                    break;
                }
                case "NOTIFY": {
                    this.handleNotifyResponse(responseEvent);
                    break;
                }
                case "INFO": {
                    this.handleInfoResponse(responseEvent);
                    break;
                }
                case "UPDATE": {
                    this.handleUpdateResponse(responseEvent);
                    break;
                }
                case "PUBLISH": {
                    this.handlePublishResponse(responseEvent);
                    break;
                }
                default: {
                    SipProvider p = (SipProvider)responseEvent.getSource();
                    response.removeFirst("Via");
                    if (response.getHeader("Via") == null) {
                        this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing in to forward \n" + newResponse);
                        return;
                    }
                    if (responseEvent.getClientTransaction() != null && responseEvent.getClientTransaction().getApplicationData() != null) {
                        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
                        ServerTransaction serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                        serverTransaction.sendResponse(newResponse);
                    } else {
                        p.sendResponse(response);
                    }
                    this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "In default way Send Response \n" + newResponse);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in handleFeatureIMSResponse Error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInfoResponse(ResponseEvent responseEvent) {
        String functionName = "handleInfoResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response infoResponse = null;
            infoResponse = (Response)response.clone();
            infoResponse.removeFirst("Via");
            if (infoResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the infoResponse \n" + infoResponse);
                return;
            }
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(infoResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(infoResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", infoResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleInfoResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleUpdateResponse(ResponseEvent responseEvent) {
        String functionName = "handleUpdateResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response updateResponse = null;
            updateResponse = (Response)response.clone();
            updateResponse.removeFirst("Via");
            if (updateResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the updateResponse \n" + updateResponse);
                return;
            }
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(updateResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(updateResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", updateResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleUpdateResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleSubscribeResponse(ResponseEvent responseEvent) {
        String functionName = "handleSubscribeResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            String callID = callIdHeader.getCallId();
            clientTransaction = responseEvent.getClientTransaction();
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            String viaHeaderString = viaHeader.toString();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response subscribeResponse = null;
            subscribeResponse = (Response)response.clone();
            subscribeResponse.removeFirst("Via");
            if (subscribeResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the subscribeRequest \n" + subscribeResponse);
                return;
            }
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(subscribeResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(subscribeResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", subscribeResponse, null, fromUser, toUser);
            if (Constants.HA_SYNC.booleanValue()) {
                String finalCallID = callID;
                int statusCode = response.getStatusCode();
                String viaValue = viaHeaderString.substring(viaHeaderString.indexOf(":") + 2).trim();
                int remotePort = viaHeader.getRPort() > 0 ? viaHeader.getRPort() : viaHeader.getPort();
                String finalToHeader = toHeader != null ? toHeader.toString() : null;
                try {
                    this.featureIMSExecutor.submit(() -> this.pushtoPassiveServer(finalCallID, statusCode, "SUBSCRIBE", finalToHeader, remotePort, viaValue));
                }
                catch (Exception e) {
                    logger.error("Error occured while creating thread for pushtoPassiveServer in handleSubscribeResponse");
                }
            }
        }
        catch (Exception e) {
            logger.error("handleSubscribeResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleNotifyResponse(ResponseEvent responseEvent) {
        String functionName = "handleNotifyResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response notifyResponse = null;
            notifyResponse = (Response)response.clone();
            notifyResponse.removeFirst("Via");
            if (notifyResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the notifyRequest \n" + notifyResponse);
                return;
            }
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(notifyResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(notifyResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", notifyResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleNotifyResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleInviteResponse(ResponseEvent responseEvent, boolean fromRegistrar) {
        block13: {
            String functionName = "handleInviteResponse";
            try {
                ClientTransaction clientTransaction = null;
                ServerTransaction serverTransaction = null;
                Response response = responseEvent.getResponse();
                int responseStatusCode = response.getStatusCode();
                CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                String callID = callIdHeader.getCallId();
                String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
                String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
                if (Constants.NAT.booleanValue()) {
                    String proxyIP = ((ResponseEventExt)responseEvent).getRemoteIpAddress();
                    int proxyPort = ((ResponseEventExt)responseEvent).getRemotePort();
                    this.helperIMS.handleContactForNAT(null, response, proxyIP, proxyPort, "response", true);
                    if (fromRegistrar && responseStatusCode >= 100 && responseStatusCode < 300) {
                        this.helperIMS.modifySDP(null, response, "response", "IP4", Constants.PUBLIC_IP_ADDRESS);
                    }
                }
                Response inviteResponse = null;
                inviteResponse = (Response)response.clone();
                clientTransaction = responseEvent.getClientTransaction();
                if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                    serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                    if (responseStatusCode >= 200 && responseStatusCode < 300) {
                        this.handleInviteAckRequest(responseEvent, fromRegistrar);
                    }
                    inviteResponse.removeFirst("Via");
                    if (inviteResponse.getHeader("Via") == null) {
                        this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the inviteRequest \n" + inviteResponse);
                        return;
                    }
                    serverTransaction.sendResponse(inviteResponse);
                    this.helperIMS.printResponseLog(className, functionName, "Send", inviteResponse, null, fromUser, toUser);
                    if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
                        if (responseStatusCode >= 200 && responseStatusCode < 300 && fromRegistrar) {
                            String X_FSUUID = Optional.ofNullable((ExtensionHeader)response.getHeader("X-FSUUID")).map(ExtensionHeader::getValue).orElse(null);
                            if (X_FSUUID != null) {
                                this.call_uuidMap.put(callID, X_FSUUID);
                            }
                        } else if (responseStatusCode >= 300) {
                            this.removefrom_calluuidMap(callID);
                        }
                    }
                    if (Constants.V2STATE_MACHINE.booleanValue()) {
                        SIPDialog dialog = (SIPDialog)responseEvent.getDialog();
                        this.stateMachineExecutor.submit(() -> {
                            try {
                                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).updateResponse(dialog, fromRegistrar, fromUser, toUser);
                            }
                            catch (Exception e) {
                                logger.error("Error while calling featureIMSStateMachine.updateResponse for callID: {}", (Object)callID, (Object)e);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                logger.error("handleInviteResponse Error while {}", (Object)e.getMessage(), (Object)e);
                if (!Constants.HA_SYNC.booleanValue() || !Constants.RECOVERYSYNC_PACKETS.booleanValue() || responseEvent.getResponse().getStatusCode() < 300) break block13;
                this.removefrom_calluuidMap(((CallIdHeader)responseEvent.getResponse().getHeader("Call-ID")).getCallId());
            }
        }
    }

    private void handleInviteAckRequest(ResponseEvent responseEvent, boolean fromRegistrar) {
        String functionName = "handleInviteAckRequest";
        try {
            Request ackRequest = null;
            Response originalResponse = responseEvent.getResponse();
            ViaHeader viaHeader = (ViaHeader)originalResponse.getHeader("Via");
            CallIdHeader callIdHeader = (CallIdHeader)originalResponse.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)originalResponse.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)originalResponse.getHeader("To")).getAddress().getURI()).getUser();
            Response response = (Response)originalResponse.clone();
            ClientTransaction ct = responseEvent.getClientTransaction();
            if (ct == null || ct.getDialog() == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Client Transaction is missing. Cannot create Ack for this 200 Invite Response\n" + originalResponse);
                return;
            }
            SIPDialog dialog = (SIPDialog)ct.getDialog();
            CSeqHeader responseCSeq = (CSeqHeader)response.getHeader("CSeq");
            ackRequest = dialog.createAck(responseCSeq.getSeqNumber());
            ackRequest = this.helperIMS.setUserAgentHeaderRequest(ackRequest, "handleInviteAckRequest");
            ackRequest = this.helperIMS.handleMaxForwardheader(ackRequest, ackRequest.getMethod());
            ackRequest = this.helperIMS.removeRouteHeaders(ackRequest, ackRequest.getMethod() + ":" + callID);
            ackRequest = this.updateIpPortInRequestURI(ackRequest, viaHeader.getTransport(), fromUser, toUser);
            ((ViaHeader)ackRequest.getHeader("Via")).removeParameter("rport");
            ((ViaHeader)ackRequest.getHeader("Via")).removeParameter("received");
            dialog.sendAck(ackRequest);
            this.helperIMS.printRequestLog(className, functionName, "Send", ackRequest, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleInviteAckRequest Error while :{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleByeResponse(ResponseEvent responseEvent) {
        String functionName = "handleByeResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response byeResponse = null;
            byeResponse = (Response)response.clone();
            byeResponse.removeFirst("Via");
            if (byeResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the byeResponse \n" + byeResponse);
                return;
            }
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(byeResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(byeResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", byeResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleByeResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleRegisterResponse(ResponseEvent responseEvent, boolean fromRegistrar) {
        String functionName = "handleRegisterResponse";
        if (!fromRegistrar) {
            return;
        }
        Response response = responseEvent.getResponse();
        String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
        String callID = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
        int statusCode = response.getStatusCode();
        int remotePort = ((ViaHeader)response.getHeader("Via")).getRPort() > 0 ? ((ViaHeader)response.getHeader("Via")).getRPort() : ((ViaHeader)response.getHeader("Via")).getPort();
        try {
            ClientTransaction ct = responseEvent.getClientTransaction();
            Response registerResponse = (Response)response.clone();
            registerResponse.removeFirst("Via");
            if (registerResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the registerResponse \n" + registerResponse);
                return;
            }
            this.handleMultipleContacts(registerResponse);
            if (ct != null && ct.getApplicationData() != null) {
                ServerTransaction st = (ServerTransaction)ct.getApplicationData();
                st.sendResponse(registerResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(registerResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", registerResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handleRegisterResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
        if (statusCode >= 200 && statusCode <= 299) {
            this.removeFromUserRegisterMapIfZero(fromUser, callID, remotePort);
        } else {
            this.removeFromUserRegisterMap(fromUser, callID);
        }
    }

    private void handleCancelResponse(ResponseEvent responseEvent) {
        String functionName = "handleCancelResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response cancelResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                cancelResponse = (Response)response.clone();
                cancelResponse.removeFirst("Via");
                if (cancelResponse.getHeader("Via") == null) {
                    this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the cancelResponse \n" + cancelResponse);
                    return;
                }
                serverTransaction.sendResponse(cancelResponse);
                this.helperIMS.printResponseLog(className, functionName, "Send", cancelResponse, null, fromUser, toUser);
            }
        }
        catch (Exception e) {
            logger.error("handleCancelResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleReferResponse(ResponseEvent responseEvent) {
        String functionName = "handleReferResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response referResponse = null;
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                referResponse = (Response)response.clone();
                referResponse.removeFirst("Via");
                if (referResponse.getHeader("Via") == null) {
                    this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the referResponse \n" + referResponse);
                    return;
                }
                serverTransaction.sendResponse(referResponse);
                this.helperIMS.printResponseLog(className, functionName, "Send", referResponse, null, fromUser, toUser);
            }
        }
        catch (Exception e) {
            logger.error("handleReferResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handlePublishResponse(ResponseEvent responseEvent) {
        String functionName = "handlePublishResponse";
        try {
            ClientTransaction clientTransaction = null;
            ServerTransaction serverTransaction = null;
            Response response = responseEvent.getResponse();
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            String callID = callIdHeader.getCallId();
            String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
            Response publishResponse = null;
            publishResponse = (Response)response.clone();
            publishResponse.removeFirst("Via");
            if (publishResponse.getHeader("Via") == null) {
                this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Via Header is missing.Dropping the publishResponse \n" + publishResponse);
                return;
            }
            clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction != null && clientTransaction.getApplicationData() != null) {
                serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                serverTransaction.sendResponse(publishResponse);
            } else {
                SipProvider p = (SipProvider)responseEvent.getSource();
                p.sendResponse(publishResponse);
            }
            this.helperIMS.printResponseLog(className, functionName, "Send", publishResponse, null, fromUser, toUser);
        }
        catch (Exception e) {
            logger.error("handlePublishResponse Error while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void handleMultipleContacts(Response response) {
        String functionName = "handleMultipleContacts";
        try {
            String fromuser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            String viaHost = viaHeader.getHost();
            int viaPort = viaHeader.getPort() <= 0 ? 5060 : viaHeader.getPort();
            int viaRemotePort = viaHeader.getRPort() <= 0 ? viaPort : viaHeader.getRPort();
            ListIterator listIterator = response.getHeaders("Contact");
            while (listIterator.hasNext()) {
                int contactPort;
                ContactHeader contact = (ContactHeader)listIterator.next();
                SipURI contactUri = (SipURI)contact.getAddress().getURI();
                String contactHost = contactUri.getHost();
                int n = contactPort = contactUri.getPort() <= 0 ? 5060 : contactUri.getPort();
                if (contactHost.equals(viaHost) && (contactPort == viaPort || contactPort == viaRemotePort)) continue;
                listIterator.remove();
            }
            listIterator = response.getHeaders("Contact");
            if (!listIterator.hasNext()) {
                SipURI sipURI = this.helperIMS.getAddressFactory().createSipURI(fromuser, viaHost);
                sipURI.setPort(viaPort);
                sipURI.setTransportParam(viaHeader.getTransport());
                Address address = this.helperIMS.getAddressFactory().createAddress((URI)sipURI);
                ContactHeader contactHeader = this.helperIMS.getHeaderFactory().createContactHeader(address);
                response.addHeader((Header)contactHeader);
            }
        }
        catch (Exception e) {
            logger.error("Error in handleMultipleContacts method while {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void pushtoPassiveServer(String callID, int statusCode, String method, String toHeaderString, int remotePort, String viaValue) {
        String functionName = "pushtoPassiveServer";
        if (callID == null || statusCode == 0 || method == null || toHeaderString == null) {
            return;
        }
        if (method.equals("SUBSCRIBE")) {
            try {
                if (this.subscribeMap.containsKey(callID)) {
                    if (statusCode >= 200 && statusCode < 300) {
                        String toValue = toHeaderString.substring(toHeaderString.indexOf(":") + 2).trim();
                        FeatureIMSService.SubscribeObject subscribeObjectToPublish = (FeatureIMSService.SubscribeObject)this.subscribeMap.get(callID);
                        if (subscribeObjectToPublish != null) {
                            subscribeObjectToPublish.setFullTo(toValue);
                            subscribeObjectToPublish.setNetworkPort(String.valueOf(remotePort));
                            subscribeObjectToPublish.setFullVia(viaValue);
                            this.featureIMSService.publishSubscriptionOnRedis((FeatureIMSService.SubscribeObject)this.subscribeMap.get(callID));
                            this.helperIMS.printCustomLogs(className, functionName, "debug", null, null, "Subscription published to redis for callId: " + callID);
                        } else {
                            this.helperIMS.printCustomLogs(className, functionName, "warn", null, null, "SubscribeObject was null for user " + toHeaderString + " Dropping the publish operation. ");
                        }
                    }
                    this.subscribeMap.remove(callID);
                }
            }
            catch (Exception e) {
                logger.error("Error in pushtoPassiveServer method {} for CallID {}: {}", (Object)method, (Object)callID, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void SyncRecoveryData(String uuid, String method) {
        String functionName = "SyncRecoveryData";
        if (uuid == null || uuid.isEmpty()) {
            this.helperIMS.printCustomLogs(className, functionName, "warn", null, null, "Uuid is null/empty. Skipping RecoverySync operation for : " + method);
            return;
        }
        if (method.equals("INVITE")) {
            this.featureIMSService.fetchAndPublishRecoveryData(uuid);
        } else if (method.equals("BYE")) {
            this.featureIMSService.publishToRemoveRecoveryData(uuid);
        }
    }

    public Map<String, String> getCallUuidMap() {
        return new HashMap<String, String>(this.call_uuidMap);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, FeatureIMSService.RegisterObject>> getUserRegisterMap() {
        return new ConcurrentHashMap<String, ConcurrentHashMap<String, FeatureIMSService.RegisterObject>>(this.userRegisterMap);
    }

    private void removefrom_calluuidMap(String callId) {
        String functionName = "removeFrom_calluudiMap";
        if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
            if (this.call_uuidMap.containsKey(callId)) {
                this.call_uuidMap.remove(callId);
            }
            this.helperIMS.printCustomLogs(className, functionName, "debug", null, null, "Removed callid: " + callId);
        }
    }

    public void insertOrUpdateinUserRegisterMap(String userId, String callId, FeatureIMSService.RegisterObject registerObject) {
        String functionName = "insertOrUpdateinUserRegisterMap";
        if (Constants.MULTIPLE_REGISTRATIONS.booleanValue()) {
            this.userRegisterMap.compute(userId, (uid, callIdMap) -> {
                if (callIdMap == null) {
                    callIdMap = new ConcurrentHashMap<String, FeatureIMSService.RegisterObject>();
                }
                callIdMap.put(callId, registerObject);
                if (this.helperIMS != null) {
                    this.helperIMS.printCustomLogs(className, functionName, "info", userId, userId, "In multiple registrations added/updated " + userId + " -> " + callId);
                }
                return callIdMap;
            });
        } else {
            this.userRegisterMap.compute(userId, (uid, oldMap) -> {
                ConcurrentHashMap<String, FeatureIMSService.RegisterObject> newMap = new ConcurrentHashMap<String, FeatureIMSService.RegisterObject>();
                newMap.put(callId, registerObject);
                if (this.helperIMS != null) {
                    this.helperIMS.printCustomLogs(className, functionName, "info", userId, userId, "In single registrations added/updated " + userId + " -> " + callId);
                }
                return newMap;
            });
        }
    }

    private void removeFromUserRegisterMapIfZero(String userId, String callId, int remotePort) {
        String functionName = "removeFromUserRegisterMapIfZero";
        this.userRegisterMap.computeIfPresent(userId, (uid, callIdMap) -> {
            FeatureIMSService.RegisterObject registerObject = (FeatureIMSService.RegisterObject)callIdMap.get(callId);
            if (registerObject != null) {
                registerObject.setNetworkPort(String.valueOf(remotePort));
                if (Constants.HA_SYNC.booleanValue()) {
                    try {
                        this.featureIMSExecutor.submit(() -> this.featureIMSService.publishRegistrationOnRedis(registerObject));
                    }
                    catch (Exception e) {
                        logger.error("Error while scheduling publishRegistrationOnRedis", (Throwable)e);
                    }
                }
                if (registerObject.getExpireHeaderInSeconds() == 0L) {
                    callIdMap.remove(callId);
                    if (this.helperIMS != null) {
                        this.helperIMS.printCustomLogs(className, functionName, "info", userId, userId, "On 200 OK Removed  " + userId + " -> " + callId);
                    }
                }
            }
            return callIdMap.isEmpty() ? null : callIdMap;
        });
    }

    public void removeFromUserRegisterMap(String userId, String callId) {
        String functionName = "removeFromUserRegisterMap";
        this.userRegisterMap.computeIfPresent(userId, (uid, callIdMap) -> {
            callIdMap.remove(callId);
            this.helperIMS.printCustomLogs(className, functionName, "info", userId, userId, "Removed " + userId + " -> " + callId);
            return callIdMap.isEmpty() ? null : callIdMap;
        });
    }

    public boolean isUserRegistered(String user) {
        String functionName = "isUserRegistered";
        ConcurrentHashMap callMap = (ConcurrentHashMap)this.userRegisterMap.get(user);
        if (callMap == null || callMap.isEmpty()) {
            return false;
        }
        long currentEpochSeconds = System.currentTimeMillis() / 1000L;
        for (FeatureIMSService.RegisterObject registerObject : callMap.values()) {
            if (registerObject == null || registerObject.getExpireAtInSecondsEpoch() <= currentEpochSeconds) continue;
            return true;
        }
        return false;
    }

    private int getPortAccordingToTransport(String transport, String type) {
        String functionName = "getPortAccordingToTransport";
        transport = transport.toUpperCase();
        if (type.equals("listeningPort")) {
            int port = Constants.LISTEN_UDP_PORT;
            switch (transport) {
                case "TLS": {
                    port = Constants.LISTEN_TLS_PORT;
                    break;
                }
                case "TCP": {
                    port = Constants.LISTEN_TCP_PORT;
                    break;
                }
                default: {
                    port = Constants.LISTEN_UDP_PORT;
                }
            }
            return port;
        }
        if (type.equals("sipRegistrarPort")) {
            int port = Constants.SIPREGISTRAR_PORT;
            switch (transport) {
                case "TLS": {
                    port = Constants.SIPREGISTRAR_TLSPORT;
                    break;
                }
                case "TCP": {
                    port = Constants.SIPREGISTRAR_TCPPORT;
                    break;
                }
                default: {
                    port = Constants.SIPREGISTRAR_PORT;
                }
            }
            return port;
        }
        return Constants.LISTEN_UDP_PORT;
    }

    private Request updateIpPortInRequestURI(Request request, String listeningTransport, String fromUser, String toUser) {
        String functionName = "updateIpPortInRequestURI";
        try {
            if (listeningTransport.equalsIgnoreCase("UDP")) {
                return request;
            }
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            if (routeHeader != null) {
                SipURI routeURI = (SipURI)routeHeader.getAddress().getURI();
                String routeUser = routeURI.getUser();
                this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "RouteHeader: " + routeURI.toString() + " in Request: \n" + request);
                if (routeURI.getHost().equals(Constants.SIPSERVER_IP) || routeURI.getHost().equals(Constants.PUBLIC_IP_ADDRESS) || routeURI.getHost().equals(Constants.SIPREGISTRAR_IP) || routeURI.getHost().equals(Constants.CONFERENCING_SERVER_IP) || this.helperIMS.domainSet.contains(routeURI.getHost())) {
                    return request;
                }
                if (routeUser != null && !routeUser.isEmpty() && this.userRegisterMap.containsKey(routeUser) && this.isUserRegistered(routeUser)) {
                    int routeUriPort = routeURI.getPort() <= 0 ? 5060 : routeURI.getPort();
                    SipURI actualContactURI = this.getUserContact(routeUser, routeURI.getHost(), routeUriPort);
                    routeURI = actualContactURI != null ? actualContactURI : routeURI;
                    routeURI.setLrParam();
                    request.removeFirst("Route");
                    request.addFirst((Header)routeHeader);
                }
                return request;
            }
            SipURI requestUri = (SipURI)request.getRequestURI();
            this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "RequestURI: " + requestUri.toString() + " in Request: \n" + request);
            if (requestUri.getHost().equals(Constants.SIPSERVER_IP) || requestUri.getHost().equals(Constants.PUBLIC_IP_ADDRESS) || requestUri.getHost().equals(Constants.SIPREGISTRAR_IP) || requestUri.getHost().equals(Constants.CONFERENCING_SERVER_IP) || this.helperIMS.domainSet.contains(requestUri.getHost())) {
                return request;
            }
            if (this.userRegisterMap.containsKey(toUser) && this.isUserRegistered(toUser)) {
                int requestUriPort = requestUri.getPort() <= 0 ? 5060 : requestUri.getPort();
                SipURI actualContactURI = this.getUserContact(toUser, requestUri.getHost(), requestUriPort);
                requestUri = actualContactURI != null ? actualContactURI : requestUri;
                request.setRequestURI((URI)requestUri);
            }
        }
        catch (Exception ex) {
            logger.error("Error in UpdatePortInRequest Method: {} CallId :{}, Error: {}", (Object)request.getMethod(), (Object)((CallIdHeader)request.getHeader("Call-ID")).getCallId(), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
        return request;
    }

    private SipURI getUserContact(String user, String receivedIp, int receivedPort) {
        String functionName = "getUserContact";
        ConcurrentHashMap callMap = (ConcurrentHashMap)this.userRegisterMap.get(user);
        if (callMap == null || callMap.isEmpty()) {
            return null;
        }
        SipURI firstContactURI = null;
        for (FeatureIMSService.RegisterObject registerObject : callMap.values()) {
            if (registerObject == null || registerObject.getContact() == null || registerObject.getContact().length() <= 0) continue;
            try {
                String contactHost;
                SipURI contactURI = (SipURI)this.helperIMS.getAddressFactory().createURI(registerObject.getContact());
                if (firstContactURI == null) {
                    firstContactURI = contactURI;
                }
                if (!(contactHost = contactURI.getHost()).equalsIgnoreCase(receivedIp)) continue;
                return contactURI;
            }
            catch (Exception e) {
                logger.error("Error in getUserContact method while finding contact for user:{}, recievedIp:{}, recievedPort:{}. --> {} \n{}", (Object)user, (Object)receivedIp, (Object)receivedPort, (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return firstContactURI;
    }

    public void releaseTerminatedDialog(String callId, String localUser, String remoteUser) {
        if (this.featureIMSStateMachine.isPresent()) {
            this.stateMachineExecutor.submit(() -> {
                try {
                    ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).releaseTerminatedDialog(callId, localUser, remoteUser);
                }
                catch (Exception e) {
                    logger.error("Error while releasing Dialogs from StateMachine {}", (Throwable)e);
                }
            });
        }
    }

    public void shutdownExecutor() {
        this.featureIMSExecutor.shutdown();
        this.featureIMSScheduler.shutdown();
        this.stateMachineExecutor.shutdown();
        try {
            List<Runnable> droppedTasks;
            if (!this.featureIMSExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                droppedTasks = this.featureIMSExecutor.shutdownNow();
                logger.warn("FeatureIMSExecutor was abruptly shut down. {} tasks were dropped.", (Object)droppedTasks.size());
                droppedTasks.forEach(task -> logger.info("FeatureIMSExecutor Dropped task: {}", (Object)task.toString()));
            } else {
                logger.info("FeatureIMSExecutor shutdown complete.");
            }
            if (!this.featureIMSScheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                droppedTasks = this.featureIMSScheduler.shutdownNow();
                logger.warn("FeatureIMSScheduler was abruptly shut down. {} tasks were dropped.", (Object)droppedTasks.size());
                droppedTasks.forEach(task -> logger.info("FeatureIMSScheduler Dropped task: {}", (Object)task.toString()));
            } else {
                logger.info("FeatureIMSScheduler shutdown complete.");
            }
            if (!this.stateMachineExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                droppedTasks = this.stateMachineExecutor.shutdownNow();
                logger.warn("StateMachineExecutor was abruptly shut down. {} tasks were dropped.", (Object)droppedTasks.size());
                droppedTasks.forEach(task -> logger.info("StateMachineExecutor Dropped task: {}", (Object)task.toString()));
            } else {
                logger.info("StateMachineExecutor thread pool shutdown complete.");
            }
        }
        catch (InterruptedException e) {
            logger.error("Shutdown interrupted: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
            this.featureIMSExecutor.shutdownNow();
            this.featureIMSScheduler.shutdownNow();
            this.stateMachineExecutor.shutdownNow();
        }
        catch (Exception e) {
            logger.error("Exception in shutdownExecutor method : {}", (Object)e.getMessage(), (Object)e);
            this.featureIMSExecutor.shutdownNow();
            this.featureIMSScheduler.shutdownNow();
            this.stateMachineExecutor.shutdownNow();
        }
    }

    public void sendCustomNotify(String user, String keyPressed) {
        String functionName = "sendCustomNotify";
        try {
            List list = this.sipSubscriptionRepository.findBySubToUser(user);
            for (SipSubscription sipSubscriptionEntity : list) {
                this.createAndSendNotify(sipSubscriptionEntity, keyPressed);
            }
        }
        catch (Exception e) {
            logger.error("Error in {} for {}", (Object)functionName, (Object)e);
        }
    }

    public void createAndSendNotify(SipSubscription sipSubscriptionEntity, String keyPressed) {
        String functionName = "createAndSendNotify";
        try {
            String branchId = Utils.getInstance().generateBranchId();
            String tag1 = Utils.getInstance().generateTag();
            String tag2 = Utils.getInstance().generateTag();
            String contactWithPath = sipSubscriptionEntity.getContact();
            contactWithPath = contactWithPath.substring(contactWithPath.indexOf("<"));
            Address contactWPath = this.helperIMS.getAddressFactory().createAddress(contactWithPath);
            SipURI contactUri = (SipURI)contactWPath.getURI();
            String fs_path = contactUri.getParameter("fs_path");
            contactUri.removeParameter("fs_path");
            RouteHeader routeHeader = null;
            if (fs_path != null) {
                String decodedPathURI = URLDecoder.decode(fs_path, StandardCharsets.UTF_8.name());
                Address routeAddress = this.helperIMS.getAddressFactory().createAddress(decodedPathURI);
                routeHeader = this.helperIMS.getHeaderFactory().createRouteHeader(routeAddress);
            }
            MaxForwardsHeader maxForwardsHeader = this.helperIMS.getHeaderFactory().createMaxForwardsHeader(70);
            String fullVia = sipSubscriptionEntity.getFullVia();
            String transport = "UDP";
            transport = this.getValueFromRegex(fullVia, "SIP/2\\.0/([A-Z]+)");
            transport = transport.toUpperCase();
            int listenPort = this.getPortAccordingToTransport(transport, "listeningPort");
            ArrayList<ViaHeader> listVia = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.helperIMS.getHeaderFactory().createViaHeader(Constants.LISTEN_IP_ADDRESS, listenPort, transport, branchId);
            listVia.add(viaHeader);
            String fullTo = sipSubscriptionEntity.getFullTo();
            int indexOftoTag = fullTo.lastIndexOf(";tag");
            String toTag = indexOftoTag > 0 ? fullTo.substring(indexOftoTag + 5) : tag1;
            fullTo = indexOftoTag > 0 ? fullTo.substring(0, indexOftoTag) : fullTo;
            Address toAddress = this.helperIMS.getAddressFactory().createAddress(fullTo);
            FromHeader fromHeader = this.helperIMS.getHeaderFactory().createFromHeader(toAddress, toTag);
            String fullFrom = sipSubscriptionEntity.getFullFrom();
            int indexOffromTag = fullFrom.lastIndexOf(";tag");
            String fromTag = indexOffromTag > 0 ? fullFrom.substring(indexOffromTag + 5) : tag2;
            fullFrom = indexOffromTag > 0 ? fullFrom.substring(0, indexOffromTag) : fullFrom;
            Address fromAddress = this.helperIMS.getAddressFactory().createAddress(fullFrom);
            ToHeader toHeader = this.helperIMS.getHeaderFactory().createToHeader(fromAddress, fromTag);
            CallIdHeader callIdHeader = this.helperIMS.getHeaderFactory().createCallIdHeader(sipSubscriptionEntity.getCallId());
            CSeqHeader cSeqHeader = this.helperIMS.getHeaderFactory().createCSeqHeader(1L, "NOTIFY");
            SipURI contactHeaderURI = this.helperIMS.getAddressFactory().createSipURI(sipSubscriptionEntity.getSubToUser(), Constants.LISTEN_IP_ADDRESS);
            contactHeaderURI.setPort(listenPort);
            contactHeaderURI.setTransportParam(transport);
            Address contactHeaderAddress = this.helperIMS.getAddressFactory().createAddress((URI)contactHeaderURI);
            ContactHeader contactHeader = this.helperIMS.getHeaderFactory().createContactHeader(contactHeaderAddress);
            EventHeader eventHeader = this.helperIMS.getHeaderFactory().createEventHeader("dialog");
            SubscriptionStateHeader subscriptionStateHeader = this.helperIMS.getHeaderFactory().createSubscriptionStateHeader("active");
            long expireTime = sipSubscriptionEntity.getExpires();
            long currentTimeinSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            long diff = expireTime > currentTimeinSeconds ? expireTime - currentTimeinSeconds : 0L;
            subscriptionStateHeader.setExpires((int)diff);
            Header keyPressedHeader = this.helperIMS.getHeaderFactory().createHeader("keypressed", keyPressed);
            String content = "";
            byte[] contentBytes = content.getBytes();
            ContentTypeHeader contentTypeHeader = this.helperIMS.getHeaderFactory().createContentTypeHeader("application", "dtmf-relay");
            Request notifyRequest = this.helperIMS.getMessageFactory().createRequest((URI)contactUri, "NOTIFY", callIdHeader, cSeqHeader, fromHeader, toHeader, listVia, maxForwardsHeader, contentTypeHeader, contentBytes);
            if (routeHeader != null) {
                notifyRequest.addHeader((Header)routeHeader);
            }
            notifyRequest.addHeader((Header)contactHeader);
            notifyRequest = this.helperIMS.setUserAgentHeaderRequest(notifyRequest, functionName);
            notifyRequest.addHeader((Header)eventHeader);
            notifyRequest.addHeader((Header)subscriptionStateHeader);
            notifyRequest.addHeader(keyPressedHeader);
            notifyRequest = this.helperIMS.removeRouteHeaders(notifyRequest, "NOTIFY:" + callIdHeader.getCallId());
            this.helperIMS.printRequestLog(className, functionName, "Send", notifyRequest, null, sipSubscriptionEntity.getSipUser(), sipSubscriptionEntity.getSubToUser());
            SipProvider sipProvider = (SipProvider)this.helperIMS.getSipProviders().get(Constants.LISTEN_IP_ADDRESS + ":" + transport);
            if (sipProvider != null) {
                sipProvider.sendRequest(notifyRequest);
            }
        }
        catch (Exception e) {
            logger.error("Error while sending custom notify {}", (Throwable)e);
        }
    }

    public String getValueFromRegex(String value, String regex) {
        Matcher m2 = Pattern.compile(regex).matcher(value);
        if (m2.find()) {
            return m2.group(1);
        }
        return null;
    }
}

