/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ims;

import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMS;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.ImsV2ServerIMS;
import com.coraltele.ims.SbcIMS;
import com.coraltele.ims.SubscribeIMS;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.DialogTerminatedEvent;
import com.coraltele.interfaces.sip.IOExceptionEvent;
import com.coraltele.interfaces.sip.ListeningPoint;
import com.coraltele.interfaces.sip.RequestEvent;
import com.coraltele.interfaces.sip.ResponseEvent;
import com.coraltele.interfaces.sip.ServerTransaction;
import com.coraltele.interfaces.sip.SipFactory;
import com.coraltele.interfaces.sip.SipListener;
import com.coraltele.interfaces.sip.SipProvider;
import com.coraltele.interfaces.sip.TimeoutEvent;
import com.coraltele.interfaces.sip.TransactionTerminatedEvent;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.header.CSeqHeader;
import com.coraltele.interfaces.sip.header.CallIdHeader;
import com.coraltele.interfaces.sip.header.FromHeader;
import com.coraltele.interfaces.sip.header.ToHeader;
import com.coraltele.interfaces.sip.header.UserAgentHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.interfaces.sip.message.Response;
import com.coraltele.javax.sip.ResponseEventExt;
import com.coraltele.javax.sip.stack.SIPDialog;
import com.coraltele.service.BackgroundTaskService;
import com.coraltele.service.FeatureIMSService;
import com.coraltele.service.IMSV2ServerService;
import com.coraltele.service.LoadDatabaseService;
import com.coraltele.service.RegistrationCleanupService;
import com.coraltele.service.SubscribeIMSService;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"helperIMS"})
public class ApplicationIMS
implements SipListener {
    private static final Logger logger = LogManager.getLogger(ApplicationIMS.class);
    private static String className = "ApplicationIMS";
    @Autowired
    HelperIMS helperIMS;
    @Autowired
    private Optional<SubscribeIMS> subscribeIMS;
    @Autowired
    private Optional<ImsV2ServerIMS> imsV2ServerIMS;
    @Autowired
    private Optional<FeatureIMS> featureIMS;
    @Autowired
    private Optional<FeatureIMSService> featureIMSService;
    @Autowired
    private Optional<SubscribeIMSService> subscribeIMSService;
    @Autowired
    private Optional<IMSV2ServerService> imsV2ServerService;
    @Autowired
    private Optional<SbcIMS> sbcIMS;
    @Autowired
    private Optional<RegistrationCleanupService> registrationCleanupService;
    @Autowired
    private Optional<BackgroundTaskService> backgroundTaskService;
    @Autowired
    private Optional<LoadDatabaseService> loadDatabaseService;

    @PostConstruct
    public void init() {
        try {
            this.loadValues();
            SipFactory sipFactory = SipFactory.getInstance();
            sipFactory.setPathName("com.coraltele");
            Properties properties = new Properties();
            properties.setProperty("javax.sip.STACK_NAME", "Coral-IMSV2-Stack");
            properties.setProperty("com.coraltele.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "true");
            properties.setProperty("com.coraltele.javax.sip.MIN_KEEPALIVE_TIME_SECONDS", "10");
            properties.setProperty("com.coraltele.javax.sip.CACHE_CLIENT_CONNECTIONS", "true");
            properties.setProperty("com.coraltele.javax.sip.CACHE_SERVER_CONNECTIONS", "true");
            properties.setProperty("com.coraltele.javax.sip.REENTRANT_LISTENER", "true");
            if ((Constants.IMS_MODE.equals("IMSV2-SERVER") || Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) && Constants.LISTEN_ON_TLS.booleanValue()) {
                properties.setProperty("javax.net.ssl.keyStore", Constants.CORALKEYSTORE_FILEPATH);
                properties.setProperty("javax.net.ssl.keyStorePassword", Constants.CORALKEYSTORE_PASS);
                properties.setProperty("javax.net.ssl.keyStoreType", "jks");
                properties.setProperty("javax.net.ssl.trustStore", Constants.CORALKEYSTORE_FILEPATH);
                properties.setProperty("javax.sip.TLS_CLIENT_AUTH_TYPE", "Disabled");
                properties.setProperty("com.coraltele.javax.sip.TLS_CLIENT_PROTOCOLS", "TLSv1.2,TLSv1.3");
            }
            if (Constants.SCALABILITY.equalsIgnoreCase("LOW")) {
                properties.setProperty("com.coraltele.javax.sip.THREAD_POOL_SIZE", String.valueOf(2));
                properties.setProperty("com.coraltele.javax.sip.REENTRANT_LISTENER", "false");
            }
            this.helperIMS.setSipStack(sipFactory.createSipStack(properties));
            this.helperIMS.setAddressFactory(sipFactory.createAddressFactory());
            this.helperIMS.setHeaderFactory(sipFactory.createHeaderFactory());
            this.helperIMS.setMessageFactory(sipFactory.createMessageFactory());
            if (Constants.IMS_MODE.equals("IMSV2-SERVER") || Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) {
                this.initializeMultipleListeningPoint();
            } else {
                SipProvider sipProvider = this.initializeListeningPoint(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), "UDP");
                this.helperIMS.setSipProvider(sipProvider);
            }
        }
        catch (Exception e) {
            logger.error("Error while starting SIP Stack {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        String localUser = null;
        String remoteUser = null;
        String fromTag = null;
        String toTag = null;
        if (dialogTerminatedEvent.getDialog() != null) {
            fromTag = dialogTerminatedEvent.getDialog().getLocalTag();
            toTag = dialogTerminatedEvent.getDialog().getRemoteTag();
            localUser = dialogTerminatedEvent.getDialog().getLocalParty() != null ? ((SipURI)dialogTerminatedEvent.getDialog().getLocalParty().getURI()).getUser() : null;
            String string = remoteUser = dialogTerminatedEvent.getDialog().getRemoteParty() != null ? ((SipURI)dialogTerminatedEvent.getDialog().getRemoteParty().getURI()).getUser() : null;
        }
        if (this.helperIMS.isValidLogUser(localUser) || this.helperIMS.isValidLogUser(remoteUser)) {
            logger.info("Dialog Terminated for : {} ", (Object)dialogTerminatedEvent.getDialog().getDialogId());
        }
        if (((SIPDialog)dialogTerminatedEvent.getDialog()).getLastResponseStatusCode() != 407) {
            this.releaseTerminatedDialog(dialogTerminatedEvent.getDialog().getCallId().getCallId(), localUser, remoteUser);
            this.helperIMS.deleteSipStackDialog(dialogTerminatedEvent.getDialog().getCallId().getCallId(), fromTag, toTag);
        }
    }

    public void processIOException(IOExceptionEvent arg0) {
        logger.error("Unable to send packet Terminated for : {} : {} : {} ", (Object)arg0.getHost(), (Object)arg0.getPort(), (Object)arg0.getTransport());
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request;
        if (!HelperIMS.controlIsHere.get()) {
            HelperIMS.controlIsHere.set(true);
            logger.info("ControlIsHere set to true On first Request in ApplicationIMS");
            this.activatePersistence();
        }
        if (this.isValidRequest(request = requestEvent.getRequest())) {
            if (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER")) {
                if (request.getMethod().equals("SUBSCRIBE")) {
                    ((SubscribeIMS)this.subscribeIMS.get()).processRequest(requestEvent);
                }
            } else if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                ((ImsV2ServerIMS)this.imsV2ServerIMS.get()).handleIMSV2Request(requestEvent);
            } else if (Constants.IMS_MODE.equals("IMSV2-SBC")) {
                ((SbcIMS)this.sbcIMS.get()).handleSbcIMSRequest(requestEvent);
            } else {
                ((FeatureIMS)this.featureIMS.get()).handleFeatureIMSRequest(requestEvent);
            }
        } else {
            this.serviceUnavailableResponse(requestEvent);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        Response response = responseEvent.getResponse();
        CSeqHeader sequenceHeader = (CSeqHeader)response.getHeader("CSeq");
        if (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER")) {
            if (sequenceHeader.getMethod().equals("NOTIFY")) {
                this.processNotifyResponse(responseEvent);
            }
        } else if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
            ((ImsV2ServerIMS)this.imsV2ServerIMS.get()).handleIMSV2Response(responseEvent);
        } else if (Constants.IMS_MODE.equals("IMSV2-SBC")) {
            ((SbcIMS)this.sbcIMS.get()).handleSbcIMSResponse(responseEvent);
        } else {
            ((FeatureIMS)this.featureIMS.get()).handleFeatureIMSResponse(responseEvent);
        }
    }

    public void processNotifyResponse(ResponseEvent responseEvent) {
        String functionName = "processNotifyResponse";
        String remoteIpPort = ((ResponseEventExt)responseEvent).getRemoteIpAddress() + ":" + ((ResponseEventExt)responseEvent).getRemotePort();
        Response response = responseEvent.getResponse();
        int status = response.getStatusCode();
        String fromUser = ((SipURI)((FromHeader)response.getHeader("From")).getAddress().getURI()).getUser();
        String toUser = ((SipURI)((ToHeader)response.getHeader("To")).getAddress().getURI()).getUser();
        long packetSequence = ((CSeqHeader)response.getHeader("CSeq")).getSeqNumber();
        this.helperIMS.printResponseLog(className, functionName, "Received", response, remoteIpPort, fromUser, toUser);
        if (status >= 200 && status < 300) {
            ((SubscribeIMS)this.subscribeIMS.get()).updateNotify("delivered", fromUser, toUser, packetSequence);
        } else if (status >= 300) {
            if (status == 408) {
                ((SubscribeIMS)this.subscribeIMS.get()).updateNotify("timeout", fromUser, toUser, packetSequence);
            } else if (status == 481) {
                ((SubscribeIMS)this.subscribeIMS.get()).updateNotify("re-request", fromUser, toUser, packetSequence);
            } else {
                ((SubscribeIMS)this.subscribeIMS.get()).updateNotify("error", fromUser, toUser, packetSequence);
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        String functionName = "processTimeout";
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        Request request = transaction.getRequest();
        FromHeader fromHeader = request == null ? null : (FromHeader)request.getHeader("From");
        ToHeader toHeader = request == null ? null : (ToHeader)request.getHeader("To");
        String fromUser = fromHeader == null ? null : ((SipURI)fromHeader.getAddress().getURI()).getUser();
        String toUser = toHeader == null ? null : ((SipURI)toHeader.getAddress().getURI()).getUser();
        String callId = request == null ? null : ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        this.helperIMS.printCustomLogs(className, functionName, "error", fromUser, toUser, "Process TimeOut for CallId:" + callId + " forRequest:\n" + request);
        this.releaseTerminatedDialog(callId, fromUser, toUser);
        this.helperIMS.deleteSipStackDialog(callId, fromHeader == null ? null : fromHeader.getTag(), toHeader == null ? null : toHeader.getTag());
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        String functionName = "processTransactionTerminated";
        if (transactionTerminatedEvent.isServerTransaction()) {
            ServerTransaction transaction = transactionTerminatedEvent.getServerTransaction();
            Request request = transaction == null ? null : transaction.getRequest();
            String fromUser = request == null ? null : ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = request == null ? null : ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String callId = request == null ? null : ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            long cseq = request == null ? null : Long.valueOf(((CSeqHeader)request.getHeader("CSeq")).getSeqNumber());
            this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "Server Transaction Terminated for CallId:" + callId + " CseqNumber: " + cseq + " Fromuser: " + fromUser + " Touser:" + toUser);
        } else {
            ClientTransaction transaction = transactionTerminatedEvent.getClientTransaction();
            Request request = transaction == null ? null : transaction.getRequest();
            String fromUser = request == null ? null : ((SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI()).getUser();
            String toUser = request == null ? null : ((SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI()).getUser();
            String callId = request == null ? null : ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            long cseq = request == null ? null : Long.valueOf(((CSeqHeader)request.getHeader("CSeq")).getSeqNumber());
            this.helperIMS.printCustomLogs(className, functionName, "debug", fromUser, toUser, "Client Transaction Terminated for CallId:" + callId + " CseqNumber: " + cseq + " Fromuser: " + fromUser + " Touser:" + toUser);
        }
    }

    private void initializeMultipleListeningPoint() {
        try {
            SipProvider sipProvider;
            if (Constants.LISTEN_ON_UDP.booleanValue()) {
                sipProvider = this.initializeListeningPoint(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), "UDP");
                this.helperIMS.addSipProvider(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_UDP_PORT.intValue(), "UDP", sipProvider);
                this.helperIMS.setSipProvider(sipProvider);
            }
            if (Constants.LISTEN_ON_TCP.booleanValue()) {
                sipProvider = this.initializeListeningPoint(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_TCP_PORT.intValue(), "TCP");
                this.helperIMS.addSipProvider(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_TCP_PORT.intValue(), "TCP", sipProvider);
            }
            if (Constants.LISTEN_ON_TLS.booleanValue()) {
                sipProvider = this.initializeListeningPoint(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_TLS_PORT.intValue(), "TLS");
                this.helperIMS.addSipProvider(Constants.LISTEN_IP_ADDRESS, Constants.LISTEN_TLS_PORT.intValue(), "TLS", sipProvider);
            }
            if (this.helperIMS.getSipProviders().size() >= 1) {
                String keys = this.helperIMS.getSipProviders().keySet().stream().collect(Collectors.joining(", "));
                logger.info("SipProvider list are : {}", (Object)keys);
            } else {
                logger.info("SipProvider List is Empty");
            }
        }
        catch (Exception e) {
            logger.error("Error in initializeMultipleListeningPoint Method {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private SipProvider initializeListeningPoint(String listenIpAddress, int port, String transport) {
        try {
            ListeningPoint listeningPoint = this.helperIMS.getSipStack().createListeningPoint(listenIpAddress, port, transport);
            SipProvider sipProvider = this.helperIMS.getSipStack().createSipProvider(listeningPoint);
            sipProvider.addSipListener((SipListener)this);
            sipProvider.setAutomaticDialogSupportEnabled(true);
            return sipProvider;
        }
        catch (Exception e) {
            logger.error("Error in initializeListeningPoint Method {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private boolean isValidRequest(Request request) {
        if (this.helperIMS.validUserAgentSet.isEmpty() || this.helperIMS.validUserAgentSet.size() == 2) {
            return true;
        }
        try {
            if (request.getMethod().equalsIgnoreCase("INVITE")) {
                UserAgentHeader userAgentHeader = (UserAgentHeader)request.getHeader("User-Agent");
                if (userAgentHeader == null) {
                    return false;
                }
                ListIterator listIterator = userAgentHeader.getProduct();
                while (listIterator.hasNext()) {
                    String target = ((String)listIterator.next()).toLowerCase();
                    for (String prefix : this.helperIMS.validUserAgentSet) {
                        if (prefix.isEmpty() || !target.contains(prefix)) continue;
                        return true;
                    }
                }
                return false;
            }
            UserAgentHeader userAgentHeader = (UserAgentHeader)request.getHeader("User-Agent");
            if (userAgentHeader == null) {
                return true;
            }
            ListIterator listIterator = userAgentHeader.getProduct();
            while (listIterator.hasNext()) {
                String target = ((String)listIterator.next()).toLowerCase();
                for (String prefix : this.helperIMS.validUserAgentSet) {
                    if (prefix.isEmpty() || !target.contains(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.error("Error in isValidUserAgent Method {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private void serviceUnavailableResponse(RequestEvent requestEvent) {
        String functionName = "serviceUnavailableResponse";
        try {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            UserAgentHeader userAgentHeader = (UserAgentHeader)request.getHeader("User-Agent");
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipURI)fromHeader.getAddress().getURI()).getUser();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipURI)toHeader.getAddress().getURI()).getUser();
            Response response = this.helperIMS.getMessageFactory().createResponse(503, requestEvent.getRequest());
            if (requestEvent.getServerTransaction() != null) {
                requestEvent.getServerTransaction().sendResponse(response);
                requestEvent.getServerTransaction().terminate();
            } else {
                sipProvider.sendResponse(response);
            }
            if (userAgentHeader != null) {
                ListIterator listIterator = userAgentHeader.getProduct();
                while (listIterator.hasNext()) {
                    String target = ((String)listIterator.next()).toLowerCase();
                    if (this.helperIMS.blockedUserAgentSet.contains(target)) continue;
                    this.helperIMS.printCustomLogs(className, functionName, "info", fromUser, toUser, "Send 503 response for: " + request.getMethod() + ", FromUser: " + fromUser + ", ToUser: " + toUser + ", UserAgent: " + target);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in serviceUnavailableResponse Method: {}  , Error: {}", (Object)requestEvent.getRequest().getMethod(), (Object)ex.getLocalizedMessage(), (Object)ex);
        }
    }

    private void loadValues() {
        try {
            this.helperIMS.fetchAndSetMasterHostname();
            this.helperIMS.buildUserAgentSet();
            this.helperIMS.loadDomainSet();
            if (this.loadDatabaseService.isPresent()) {
                ((LoadDatabaseService)this.loadDatabaseService.get()).loadDataFromDatabase();
            }
            if (this.backgroundTaskService.isPresent()) {
                ((BackgroundTaskService)this.backgroundTaskService.get()).startLivenessScheduler();
            }
            if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) {
                if (this.featureIMSService.isPresent()) {
                    ((FeatureIMSService)this.featureIMSService.get()).setSipServerProfileName();
                    if (Constants.HOSTNAME.equals(Constants.MASTER_HOSTNAME)) {
                        ((FeatureIMSService)this.featureIMSService.get()).loadCallbackFromRedis();
                        ((FeatureIMSService)this.featureIMSService.get()).startRedisScheduler();
                    }
                }
            } else if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                if (this.imsV2ServerService.isPresent()) {
                    ((ImsV2ServerIMS)this.imsV2ServerIMS.get()).routeVia();
                    if (Constants.HOSTNAME.equals(Constants.MASTER_HOSTNAME)) {
                        ((IMSV2ServerService)this.imsV2ServerService.get()).loadRegisterMap();
                        ((IMSV2ServerService)this.imsV2ServerService.get()).loadSubscribePacketFromRedis();
                        ((IMSV2ServerService)this.imsV2ServerService.get()).loadCallbackFromRedis();
                        ((IMSV2ServerService)this.imsV2ServerService.get()).startRedisScheduler();
                    }
                }
                if (this.registrationCleanupService.isPresent()) {
                    ((RegistrationCleanupService)this.registrationCleanupService.get()).startThread();
                }
            } else if (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER") && this.subscribeIMSService.isPresent()) {
                ((SubscribeIMSService)this.subscribeIMSService.get()).loadSubscribePacketFromDatabase();
                ((SubscribeIMSService)this.subscribeIMSService.get()).scheduleSubscriptionSave();
            }
        }
        catch (Exception e) {
            logger.error("Error in loadValues method {}", (Throwable)e);
        }
    }

    public void releaseTerminatedDialog(String callId, String localUser, String remoteUser) {
        if (!Constants.V2STATE_MACHINE.booleanValue()) {
            return;
        }
        if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
            ((ImsV2ServerIMS)this.imsV2ServerIMS.get()).releaseTerminatedDialog(callId, localUser, remoteUser);
        } else if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) {
            ((FeatureIMS)this.featureIMS.get()).releaseTerminatedDialog(callId, localUser, remoteUser);
        } else {
            return;
        }
    }

    public void activatePersistence() {
        try {
            this.helperIMS.fetchAndSetMasterHostname();
            if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                if (this.imsV2ServerService.isPresent()) {
                    if (Constants.HOSTNAME.equals(Constants.MASTER_HOSTNAME)) {
                        ((IMSV2ServerService)this.imsV2ServerService.get()).startRedisScheduler();
                    } else {
                        logger.info("Stopping redis scheduler from application IMS as it is not master. MasterHostname: {} and localHostname: {}", (Object)Constants.MASTER_HOSTNAME, (Object)Constants.HOSTNAME);
                        HelperIMS.controlIsHere.set(false);
                        HelperIMS.controlIsHere.set(false);
                    }
                }
            } else if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER") && this.featureIMSService.isPresent()) {
                if (Constants.HOSTNAME.equals(Constants.MASTER_HOSTNAME)) {
                    ((FeatureIMSService)this.featureIMSService.get()).startRedisScheduler();
                    ((FeatureIMSService)this.featureIMSService.get()).publishControlShiftOnRedis();
                } else {
                    logger.info("Stopping redis scheduler from application IMS as it is not master. MasterHostname: {} and localHostname: {}", (Object)Constants.MASTER_HOSTNAME, (Object)Constants.HOSTNAME);
                    HelperIMS.controlIsHere.set(false);
                    ((FeatureIMSService)this.featureIMSService.get()).stopSchedulerSaveAfterControlShift();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in activatePersistence method {}", (Throwable)e);
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onContextClosed(ContextClosedEvent event) {
        logger.info("ContextClosedEvent received. Starting graceful shutdown.");
        try {
            if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                if (this.imsV2ServerService.isPresent()) {
                    // empty if block
                }
            } else if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER") && this.featureIMSService.isPresent()) {
                ((FeatureIMSService)this.featureIMSService.get()).stopSchedulerSaveAfterControlShift();
                ((FeatureIMSService)this.featureIMSService.get()).saveCallbackOnRedis();
            }
        }
        catch (Exception e) {
            logger.error("Error during shutdown save", (Throwable)e);
        }
    }

    @PreDestroy
    public void stopSchedulers() {
        try {
            if (this.backgroundTaskService.isPresent()) {
                ((BackgroundTaskService)this.backgroundTaskService.get()).shutdownScheduler();
            }
            if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                if (this.imsV2ServerService.isPresent()) {
                    ((IMSV2ServerService)this.imsV2ServerService.get()).stopScheduledRegistrationAndSubscriptionSave();
                }
                if (this.registrationCleanupService.isPresent()) {
                    ((RegistrationCleanupService)this.registrationCleanupService.get()).stopThread();
                }
            } else if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) {
                ((FeatureIMS)this.featureIMS.get()).shutdownExecutor();
                if (this.featureIMSService.isPresent()) {
                    ((FeatureIMSService)this.featureIMSService.get()).stopSchedulerSave();
                }
            } else if (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER") && this.subscribeIMSService.isPresent()) {
                ((SubscribeIMSService)this.subscribeIMSService.get()).stopScheduledSubscriptionSave();
            }
        }
        catch (Exception e) {
            logger.error("Error in stopSchedulers method {}", (Throwable)e);
        }
    }
}

