/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private String secret;
    private int jwtExpirationInMs;
    private int refreshExpirationDateInMs;
    private String refreshSecret;

    @Value(value="${jwt.secret}")
    public void setSecret(String secret) {
        this.secret = secret + "-369df322-9c0b-4a05-a739-a0d01d67cce2";
        this.refreshSecret = secret + "-cc455a0a-1730-4347-b98c-dfdef0aff0cf";
    }

    @Value(value="${jwt.expiration}")
    public void setJwtExpirationInMs(int jwtExpiration) {
        this.jwtExpirationInMs = jwtExpiration * 1000;
        this.refreshExpirationDateInMs = jwtExpiration * 1000 + 300000;
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
    }

    private Claims getAllClaimsFromRefreshToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.refreshSecret).parseClaimsJws(token).getBody();
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    public <T> T getClaimFromRefreshToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromRefreshToken(token);
        return claimsResolver.apply(claims);
    }

    public String getUsernameFromToken(String token) {
        return (String)this.getClaimFromToken(token, Claims::getSubject);
    }

    public String getUsernameFromRefreshToken(String token) {
        return (String)this.getClaimFromRefreshToken(token, Claims::getSubject);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.jwtExpirationInMs)).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String doGenerateRefreshToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.refreshExpirationDateInMs)).signWith(SignatureAlgorithm.HS512, this.refreshSecret).compact();
    }

    public String generateToken(UserDetails userDetails) {
        HashMap claims = new HashMap();
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    public String generateRefreshToken(UserDetails userDetails) {
        HashMap claims = new HashMap();
        return this.doGenerateRefreshToken(claims, userDetails.getUsername());
    }

    public boolean validateToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public boolean validateRefreshToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.refreshSecret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public Date getExpirationDateFromToken(String token) {
        return (Date)this.getClaimFromToken(token, Claims::getExpiration);
    }

    public String getSecret() {
        return this.secret;
    }

    public int getJwtExpirationInMs() {
        return this.jwtExpirationInMs;
    }

    public int getRefreshExpirationDateInMs() {
        return this.refreshExpirationDateInMs;
    }

    public String getRefreshSecret() {
        return this.refreshSecret;
    }

    public void setRefreshExpirationDateInMs(int refreshExpirationDateInMs) {
        this.refreshExpirationDateInMs = refreshExpirationDateInMs;
    }

    public void setRefreshSecret(String refreshSecret) {
        this.refreshSecret = refreshSecret;
    }
}

