/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.core;

import com.coraltele.core.ThreadAuditor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadAuditor {
    private Map<Thread, ThreadHandle> threadHandles = new ConcurrentHashMap();
    private long pingIntervalInMillisecs = 0L;

    public long getPingIntervalInMillisecs() {
        return this.pingIntervalInMillisecs;
    }

    public void setPingIntervalInMillisecs(long value) {
        this.pingIntervalInMillisecs = value;
    }

    public boolean isEnabled() {
        return this.pingIntervalInMillisecs > 0L;
    }

    public ThreadHandle addCurrentThread() {
        ThreadHandle threadHandle = new ThreadHandle(this, this);
        if (this.isEnabled()) {
            this.threadHandles.put(Thread.currentThread(), threadHandle);
        }
        return threadHandle;
    }

    public void removeThread(Thread thread) {
        this.threadHandles.remove(thread);
    }

    public void ping(ThreadHandle threadHandle) {
        threadHandle.setThreadActive(true);
    }

    public void reset() {
        this.threadHandles.clear();
    }

    public String auditThreads() {
        String auditReport = null;
        for (ThreadHandle threadHandle : this.threadHandles.values()) {
            if (!threadHandle.isThreadActive()) {
                Thread thread = threadHandle.getThread();
                if (auditReport == null) {
                    auditReport = "Thread Auditor Report:\n";
                }
                auditReport = auditReport + "   Thread [" + thread.getName() + "] has failed to respond to an audit request.\n";
            }
            threadHandle.setThreadActive(false);
        }
        return auditReport;
    }

    public synchronized String toString() {
        String toString = "Thread Auditor - List of monitored threads:\n";
        for (ThreadHandle threadHandle : this.threadHandles.values()) {
            toString = toString + "   " + threadHandle.toString() + "\n";
        }
        return toString;
    }
}

