/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.core;

import com.coraltele.core.CommonLogger;
import com.coraltele.core.Debug;
import com.coraltele.core.StackLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

public class LogWriter
implements StackLogger {
    private Logger logger;
    private String stackName;
    private String logFileName = null;
    private volatile boolean needsLogging = false;
    private int lineCount;
    protected int traceLevel = 0;
    private String buildTimeStamp;
    private Properties configurationProperties;

    public void logStackTrace() {
        this.logStackTrace(32);
    }

    public void logStackTrace(int traceLevel) {
        if (this.needsLogging) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] ste = new Exception().getStackTrace();
            for (int i = 1; i < ste.length; ++i) {
                String callFrame = "[" + ste[i].getFileName() + ":" + ste[i].getLineNumber() + "]";
                pw.print(callFrame);
            }
            pw.close();
            String stackTrace = sw.getBuffer().toString();
            Level level = this.getLevel(traceLevel);
            this.logger.log(level, stackTrace);
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addAppender(Appender appender) {
    }

    public void logException(Throwable ex) {
        if (this.needsLogging) {
            this.getLogger().error(ex.getMessage(), ex);
        }
    }

    private void countLines(String message) {
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++this.lineCount;
        }
    }

    private String enhanceMessage(String message) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        StackTraceElement elem = stackTrace[3];
        String className = elem.getClassName();
        String methodName = elem.getMethodName();
        String fileName = elem.getFileName();
        int lineNumber = elem.getLineNumber();
        String newMessage = className + "." + methodName + "(" + fileName + ":" + lineNumber + ") [" + message + "]";
        return newMessage;
    }

    public void logDebug(String message) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug("BUILD TIMESTAMP = " + this.buildTimeStamp);
                this.getLogger().debug("Config Propeties = " + this.configurationProperties);
            }
            this.countLines(newMessage);
            this.getLogger().debug(newMessage);
        }
    }

    public void logTrace(String message) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug("BUILD TIMESTAMP = " + this.buildTimeStamp);
                this.getLogger().debug("Config Propeties = " + this.configurationProperties);
            }
            this.countLines(newMessage);
            this.getLogger().trace(newMessage);
        }
    }

    private void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void logFatalError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.fatal(newMsg);
    }

    public void logError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.error(newMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStackProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        String logLevel = configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        this.logFileName = configurationProperties.getProperty("gov.nist.javax.sip.DEBUG_LOG");
        this.stackName = configurationProperties.getProperty("javax.sip.STACK_NAME");
        String category = configurationProperties.getProperty("gov.nist.javax.sip.LOG4J_LOGGER_NAME", this.stackName);
        this.logger = LogManager.getLogger((String)category);
        if (logLevel != null) {
            if (logLevel.equals("LOG4J")) {
                CommonLogger.useLegacyLogger = false;
                return;
            } else {
                try {
                    int ll = 0;
                    if (logLevel.equals("TRACE")) {
                        ll = 32;
                        Debug.debug = true;
                        Debug.setStackLogger((StackLogger)this);
                    } else if (logLevel.equals("DEBUG")) {
                        ll = 32;
                    } else if (logLevel.equals("INFO")) {
                        ll = 16;
                    } else if (logLevel.equals("ERROR")) {
                        ll = 4;
                    } else if (logLevel.equals("NONE") || logLevel.equals("OFF")) {
                        ll = 0;
                    } else {
                        ll = Integer.parseInt(logLevel);
                        if (ll > 32) {
                            Debug.debug = true;
                            Debug.setStackLogger((StackLogger)this);
                        }
                    }
                    this.setTraceLevel(ll);
                    this.needsLogging = true;
                    if (this.needsLogging && this.logFileName == null) return;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    System.err.println("LogWriter: Bad integer " + logLevel);
                    System.err.println("logging dislabled ");
                    this.needsLogging = false;
                }
            }
            return;
        } else {
            this.needsLogging = false;
            {
                // empty if block
            }
        }
    }

    public boolean isLoggingEnabled() {
        return this.needsLogging;
    }

    public boolean isLoggingEnabled(int logLevel) {
        return this.needsLogging && logLevel <= this.traceLevel;
    }

    public void logError(String message, Exception ex) {
        Logger logger = this.getLogger();
        logger.error(message, (Throwable)ex);
    }

    public void logWarning(String string) {
        this.getLogger().warn(string);
    }

    public void logInfo(String string) {
        this.getLogger().info(string);
    }

    public void disableLogging() {
        this.needsLogging = false;
    }

    public void enableLogging() {
        this.needsLogging = true;
    }

    public void setBuildTimeStamp(String buildTimeStamp) {
        this.buildTimeStamp = buildTimeStamp;
    }

    public Level getLogPriority() {
        return this.getLevel(this.traceLevel);
    }

    public Level getLevel(int traceLevel) {
        if (traceLevel == 16) {
            return Level.INFO;
        }
        if (traceLevel == 4) {
            return Level.ERROR;
        }
        if (traceLevel == 32) {
            return Level.DEBUG;
        }
        if (traceLevel == 64) {
            return Level.ALL;
        }
        return Level.OFF;
    }

    public String getLoggerName() {
        if (this.logger != null) {
            return this.logger.getName();
        }
        return null;
    }
}

