/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.db.users.entity.User;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.users.repository"}, entityManagerFactoryRef="usersEntityManagerFactory", transactionManagerRef="usersTransactionManager")
public class UsersDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.users")
    public DataSourceProperties usersDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource usersDataSource() {
        return this.usersDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"usersEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean usersEntityManagerFactory(EntityManagerFactoryBuilder builder) {
        return builder.dataSource(this.usersDataSource()).packages(new Class[]{User.class}).build();
    }

    @Bean(name={"usersTransactionManager"})
    public PlatformTransactionManager usersTransactionManager(@Qualifier(value="usersEntityManagerFactory") LocalContainerEntityManagerFactoryBean usersEntityManagerFactory) {
        return new JpaTransactionManager(usersEntityManagerFactory.getObject());
    }
}

