/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.telephony.pbx.repository", "com.coraltele.db.telephony.main.repository", "com.coraltele.db.telephony.uc.repository"}, entityManagerFactoryRef="switchEntityManagerFactory", transactionManagerRef="switchTransactionManager")
public class SwitchDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.switch")
    public DataSourceProperties switchDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource switchDataSource(@Qualifier(value="switchDataSourceProperties") DataSourceProperties switchDataSourceProperties) {
        return this.switchDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"switchEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean switchEntityManagerFactory(@Qualifier(value="switchDataSource") DataSource switchDataSource, EntityManagerFactoryBuilder builder) {
        return builder.dataSource(switchDataSource).packages(new String[]{"com.coraltele.db.telephony.main.entity", "com.coraltele.db.telephony.pbx.entity", "com.coraltele.db.telephony.uc.entity"}).build();
    }

    @Bean
    public PlatformTransactionManager switchTransactionManager(@Qualifier(value="switchEntityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory.getObject());
    }

    @Bean(name={"switchJdbcTemplate"})
    public JdbcTemplate telemetryJdbcTemplate(@Qualifier(value="switchDataSource") DataSource switchDataSource) {
        return new JdbcTemplate(switchDataSource);
    }
}

