/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.condition.EnableRedisPubSub;
import com.coraltele.condition.EnableSUBSCRIBER_SERVER;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.SubscribeIMS;
import com.coraltele.messaging.ExtensionUpdateSubscriber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@Conditional(value={EnableRedisPubSub.class, EnableSUBSCRIBER_SERVER.class})
public class RedisConfigforSubscribeIMS {
    @Autowired
    SubscribeIMS subscribeIMS;
    @Autowired
    HelperIMS helperIMS;

    @Bean
    JedisConnectionFactory jedisConnectionFactory() {
        return new JedisConnectionFactory();
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        template.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        return template;
    }

    @Bean
    MessageListenerAdapter messageListener() {
        return new MessageListenerAdapter((Object)new ExtensionUpdateSubscriber(this.subscribeIMS, this.helperIMS));
    }

    @Bean
    RedisMessageListenerContainer redisContainer() {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        container.addMessageListener((MessageListener)this.messageListener(), (Topic)this.extensionUpdateChannel());
        return container;
    }

    @Bean
    ChannelTopic enbChannel() {
        return new ChannelTopic("enb-channel");
    }

    @Bean
    ChannelTopic extensionUpdateChannel() {
        return new ChannelTopic("extension-update");
    }
}

