/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.condition.EnableIMSV2orFeatureIMS;
import com.coraltele.condition.EnableRedisPubSub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@Conditional(value={EnableRedisPubSub.class, EnableIMSV2orFeatureIMS.class})
public class RedisConfigforIMSV2SERVERorFeatureIMS {
    private static final Logger logger = LogManager.getLogger(RedisConfigforIMSV2SERVERorFeatureIMS.class);

    @Bean
    @Primary
    JedisConnectionFactory dbJedisConnectionFactory() {
        try {
            RedisStandaloneConfiguration dbConfig = new RedisStandaloneConfiguration();
            dbConfig.setHostName("127.0.0.1");
            dbConfig.setPort(6379);
            return new JedisConnectionFactory(dbConfig);
        }
        catch (Exception e) {
            logger.error("Failed to create Redis localhost connection", (Throwable)e);
            return null;
        }
    }

    @Bean(value={"localRedisTemplate"})
    public RedisTemplate<String, Object> redisTemplate() {
        try {
            JedisConnectionFactory connectionFactory = this.dbJedisConnectionFactory();
            if (connectionFactory == null) {
                logger.warn("Redis connection factory is null, publish template can not created.");
                return null;
            }
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
            template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
            return template;
        }
        catch (Exception e) {
            logger.error("Failed to create Redis publish template", (Throwable)e);
            return null;
        }
    }
}

