/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.condition.EnableFEATUREIMS_SERVER;
import com.coraltele.condition.EnableHASync;
import com.coraltele.condition.EnableRedisPubSub;
import com.coraltele.db.telephony.main.repository.RecoveryRepository;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepository;
import com.coraltele.db.telephony.main.repository.SipSubscriptionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.messaging.CallbackMessageListener;
import com.coraltele.messaging.ControlSyncMessageListener;
import com.coraltele.messaging.RecoveryMessageListener;
import com.coraltele.messaging.RegistrationMessageListener;
import com.coraltele.messaging.SubscriptionMessageListener;
import com.coraltele.service.FeatureIMSService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@Conditional(value={EnableRedisPubSub.class, EnableHASync.class, EnableFEATUREIMS_SERVER.class})
public class RedisConfigforHASync {
    private static final Logger logger = LogManager.getLogger(RedisConfigforHASync.class);
    @Value(value="${redis.registrationHASyncChannel}")
    private String registrationHASyncChannel;
    @Value(value="${redis.callbackHASyncChannel}")
    private String callbackHASyncChannel;
    @Value(value="${redis.callbackWithTimeAddHASyncChannel}")
    private String callbackWithTimeAddHASyncChannel;
    @Value(value="${redis.callbackWithTimeRemoveHASyncChannel}")
    private String callbackWithTimeRemoveHASyncChannel;
    @Value(value="${redis.subscriptionHASyncChannel}")
    private String subscriptionHASyncChannel;
    @Value(value="${redis.recoveryAddHASyncChannel}")
    private String recoveryAddHASyncChannel;
    @Value(value="${redis.recoveryRemoveHASyncChannel}")
    private String recoveryRemoveHASyncChannel;
    @Value(value="${redis.controlHASyncChannel}")
    private String controlHASyncChannel;
    @Autowired
    private SipRegistrationRepository sipRegistrationRepository;
    @Autowired
    private SipSubscriptionRepository sipSubscriptionRepository;
    @Autowired
    private RecoveryRepository recoveryRepository;
    @Autowired
    private FeatureIMSService featureIMSService;

    @Bean(name={"jedisConnectionFactoryPubSub"})
    public JedisConnectionFactory jedisConnectionFactoryPubSub() {
        try {
            RedisStandaloneConfiguration remoteConfig1 = new RedisStandaloneConfiguration();
            remoteConfig1.setHostName(Constants.REDIS_IP);
            remoteConfig1.setPort(Constants.REDIS_PORT.intValue());
            return new JedisConnectionFactory(remoteConfig1);
        }
        catch (Exception e) {
            logger.error("Failed to create Redis PUBLISH connection", (Throwable)e);
            return null;
        }
    }

    @Bean(name={"redisTemplate"})
    public RedisTemplate<String, Object> pubSubRedisTemplate() {
        try {
            JedisConnectionFactory connectionFactory = this.jedisConnectionFactoryPubSub();
            if (connectionFactory == null) {
                logger.warn("Redis connection factory is null, Pub-Sub template can not created.");
                return null;
            }
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
            template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
            return template;
        }
        catch (Exception e) {
            logger.error("Failed to create Redis Pub-Sub template", (Throwable)e);
            return null;
        }
    }

    @Bean
    public RegistrationMessageListener MessageListener() {
        return new RegistrationMessageListener(this.sipRegistrationRepository, this.featureIMSService);
    }

    @Bean(name={"registrationListenerAdapter"})
    public MessageListenerAdapter registrationListenerAdapter(RegistrationMessageListener registrationMessageListener) {
        return new MessageListenerAdapter((Object)registrationMessageListener);
    }

    @Bean
    public CallbackMessageListener callbackMessageListener() {
        return new CallbackMessageListener(this.featureIMSService);
    }

    @Bean(name={"callbackListenerAdapter"})
    public MessageListenerAdapter callbackListenerAdapter(CallbackMessageListener callbackMessageListener) {
        return new MessageListenerAdapter((Object)callbackMessageListener);
    }

    @Bean
    public SubscriptionMessageListener subscriptionMessageListener() {
        return new SubscriptionMessageListener(this.sipSubscriptionRepository);
    }

    @Bean(name={"subscriptionListenerAdapter"})
    public MessageListenerAdapter subscriptionListenerAdapter(SubscriptionMessageListener subscriptionMessageListener) {
        return new MessageListenerAdapter((Object)subscriptionMessageListener);
    }

    @Bean
    public RecoveryMessageListener recoveryMessageListener() {
        return new RecoveryMessageListener(this.recoveryRepository);
    }

    @Bean(name={"recoveryMessageListenerAdapter"})
    public MessageListenerAdapter recoveryMessageListenerAdapter(RecoveryMessageListener recoveryMessageListener) {
        return new MessageListenerAdapter((Object)recoveryMessageListener);
    }

    @Bean
    public ControlSyncMessageListener controlSyncMessageListener() {
        return new ControlSyncMessageListener(this.featureIMSService);
    }

    @Bean(name={"controlSyncListenerAdapter"})
    public MessageListenerAdapter controlSyncListenerAdapter(ControlSyncMessageListener controlSyncMessageListener) {
        return new MessageListenerAdapter((Object)controlSyncMessageListener);
    }

    @Bean
    public RedisMessageListenerContainer redisContainer(@Qualifier(value="registrationListenerAdapter") MessageListenerAdapter registrationListenerAdapter, @Qualifier(value="callbackListenerAdapter") MessageListenerAdapter callbackListenerAdapter, @Qualifier(value="subscriptionListenerAdapter") MessageListenerAdapter subscriptionListenerAdapter, @Qualifier(value="recoveryMessageListenerAdapter") MessageListenerAdapter recoveryMessageListenerAdapter, @Qualifier(value="controlSyncListenerAdapter") MessageListenerAdapter controlSyncListenerAdapter) {
        try {
            JedisConnectionFactory connectionFactory = this.jedisConnectionFactoryPubSub();
            if (connectionFactory == null) {
                logger.warn("Redis connection factory is null, listener container not created in redisContainer method");
                return null;
            }
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory((RedisConnectionFactory)connectionFactory);
            container.addMessageListener((MessageListener)registrationListenerAdapter, (Topic)this.RegistrationHASyncChannel());
            container.addMessageListener((MessageListener)callbackListenerAdapter, (Topic)this.callbackHASyncChannel());
            container.addMessageListener((MessageListener)callbackListenerAdapter, (Topic)this.callbackWithTimeAddHASyncChannel());
            container.addMessageListener((MessageListener)callbackListenerAdapter, (Topic)this.callbackWithTimeRemoveHASyncChannel());
            container.addMessageListener((MessageListener)subscriptionListenerAdapter, (Topic)this.SubscriptionHASyncChannel());
            container.addMessageListener((MessageListener)recoveryMessageListenerAdapter, (Topic)this.recoveryAddHASyncChannel());
            container.addMessageListener((MessageListener)recoveryMessageListenerAdapter, (Topic)this.recoveryRemoveHASyncChannel());
            container.addMessageListener((MessageListener)controlSyncListenerAdapter, (Topic)this.controlHASSyncChannel());
            return container;
        }
        catch (RedisConnectionFailureException e) {
            logger.error("Redis is not available. Message listener container will not be initialized.", (Throwable)e);
            return null;
        }
    }

    @Bean
    public ChannelTopic RegistrationHASyncChannel() {
        return new ChannelTopic(this.registrationHASyncChannel);
    }

    @Bean
    public ChannelTopic callbackWithTimeAddHASyncChannel() {
        return new ChannelTopic(this.callbackWithTimeAddHASyncChannel);
    }

    @Bean
    public ChannelTopic callbackWithTimeRemoveHASyncChannel() {
        return new ChannelTopic(this.callbackWithTimeRemoveHASyncChannel);
    }

    @Bean
    public ChannelTopic callbackHASyncChannel() {
        return new ChannelTopic(this.callbackHASyncChannel);
    }

    @Bean
    public ChannelTopic SubscriptionHASyncChannel() {
        return new ChannelTopic(this.subscriptionHASyncChannel);
    }

    @Bean
    public ChannelTopic recoveryAddHASyncChannel() {
        return new ChannelTopic(this.recoveryAddHASyncChannel);
    }

    @Bean
    public ChannelTopic recoveryRemoveHASyncChannel() {
        return new ChannelTopic(this.recoveryRemoveHASyncChannel);
    }

    @Bean
    public ChannelTopic controlHASSyncChannel() {
        return new ChannelTopic(this.controlHASyncChannel);
    }
}

