/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.api;

import com.coraltele.condition.EnableV2StateMachine;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMS;
import com.coraltele.ims.FeatureIMSStateMachine;
import com.coraltele.ims.ImsV2ServerIMS;
import com.coraltele.ims.V2StateMachine;
import com.coraltele.service.FeatureIMSService;
import com.coraltele.service.GeneralApiService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2"})
@RestController
@Conditional(value={EnableV2StateMachine.class})
public class StateMachineController {
    @Autowired
    private Optional<V2StateMachine> v2StateMachine;
    @Autowired
    private Optional<FeatureIMSStateMachine> featureIMSStateMachine;
    @Autowired
    private Optional<ImsV2ServerIMS> imsV2ServerIMS;
    @Autowired
    private Optional<FeatureIMS> featureIMS;
    @Autowired
    private Optional<FeatureIMSService> featureIMSService;
    @Autowired
    private GeneralApiService generalApiService;

    @GetMapping(value={"/channel"})
    public ResponseEntity<String> channelStateDialog() {
        try {
            List stateDialogList = null;
            if (!this.v2StateMachine.isPresent() && !this.featureIMSStateMachine.isPresent()) {
                return ResponseEntity.badRequest().body((Object)"Invalid API");
            }
            if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER") || Constants.IMS_MODE.equals("IMSV2-SERVER") && Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue()) {
                stateDialogList = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getchannel();
            } else if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
                stateDialogList = ((V2StateMachine)this.v2StateMachine.get()).getchannel();
            }
            if (stateDialogList == null) {
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"No state dialogs available");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)stateDialogList);
            return ResponseEntity.ok((Object)json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error converting to JSON");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Internal Server Error");
        }
    }

    @GetMapping(value={"/callBack/{from}/{to}"})
    public ResponseEntity<String> handleCallbackWithDefault(@PathVariable String from, @PathVariable String to) {
        return this.handleCallback(from, to, "audio");
    }

    @GetMapping(value={"/callBack/{from}/{to}/{mediaType}"})
    public ResponseEntity<String> handleCallback(@PathVariable String from, @PathVariable String to, @PathVariable String mediaType) {
        if (this.featureIMSStateMachine.isPresent()) {
            ConcurrentLinkedDeque deque = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getBackwardcallbackMap().computeIfAbsent(to, k -> new ConcurrentLinkedDeque());
            if (!deque.contains(from)) {
                deque.addLast(from);
                if (Constants.HA_SYNC.booleanValue()) {
                    ((FeatureIMSService)this.featureIMSService.get()).publishCallbackOnRedis(from, to, "backward", "add", mediaType);
                }
            }
            long epoch = System.currentTimeMillis();
            ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).setInOriginalCallbackMap(from, to, mediaType, epoch);
            if (Constants.HA_SYNC.booleanValue()) {
                ((FeatureIMSService)this.featureIMSService.get()).publishCallbackWithTimeOnRedis(from, to, mediaType, epoch, "add");
            }
            ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getMediaTypeMap().put(from + ":" + to, mediaType);
            return ResponseEntity.ok((Object)(mediaType + " Callback has been scheduled from " + from + " -> " + to));
        }
        return ResponseEntity.badRequest().body((Object)"Invalid API");
    }

    @GetMapping(value={"/relations"})
    public ResponseEntity<?> getUserRelations() {
        if (this.featureIMSStateMachine.isPresent()) {
            return ResponseEntity.ok((Object)((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getUserMap());
        }
        return ResponseEntity.badRequest().body((Object)"Invalid API");
    }

    @GetMapping(value={"/forwardcallback"})
    public ResponseEntity<?> getCallBacks() {
        if (this.featureIMSStateMachine.isPresent()) {
            return ResponseEntity.ok((Object)((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getForwardCallBack());
        }
        return ResponseEntity.badRequest().body((Object)"Invalid API");
    }

    @GetMapping(value={"/getCallback"})
    public ResponseEntity<?> getAllCallbacks() {
        if (this.featureIMSStateMachine.isPresent()) {
            ConcurrentHashMap map = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap();
            List allCallbacks = map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            return ResponseEntity.ok(allCallbacks);
        }
        return ResponseEntity.badRequest().body((Object)"FeatureIMSStateMachine not initialized");
    }

    @GetMapping(value={"/getCallback/{key}"})
    public ResponseEntity<?> getCallbacksByKey(@PathVariable String key) {
        if (this.featureIMSStateMachine.isPresent()) {
            ConcurrentHashMap map = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap();
            if (map == null || map.isEmpty()) {
                return ResponseEntity.ok((Object)"Callback map is empty");
            }
            ConcurrentSkipListSet set = (ConcurrentSkipListSet)map.get(key);
            if (set == null || set.isEmpty()) {
                return ResponseEntity.ok((Object)("No callbacks found for key: " + key));
            }
            ArrayList result = new ArrayList(set);
            return ResponseEntity.ok(result);
        }
        return ResponseEntity.badRequest().body((Object)"FeatureIMSStateMachine not initialized");
    }

    @GetMapping(value={"/backwardcallback"})
    public ResponseEntity<?> getBackwardCallBacks() {
        if (this.featureIMSStateMachine.isPresent()) {
            return ResponseEntity.ok((Object)((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getBackwardCallBack());
        }
        return ResponseEntity.badRequest().body((Object)"Invalid API");
    }

    @GetMapping(value={"/releaseDialog/{callId}"})
    public ResponseEntity<?> releaseDialog(@PathVariable String callId) {
        if (!Constants.V2STATE_MACHINE.booleanValue()) {
            return ResponseEntity.badRequest().body((Object)"Invalid API");
        }
        if (Constants.IMS_MODE.equals("FEATUREIMS-SERVER")) {
            ((FeatureIMS)this.featureIMS.get()).releaseTerminatedDialog(callId, null, null);
        } else if (Constants.IMS_MODE.equals("IMSV2-SERVER")) {
            ((ImsV2ServerIMS)this.imsV2ServerIMS.get()).releaseTerminatedDialog(callId, null, null);
        }
        return ResponseEntity.ok().body((Object)"OK");
    }

    @PostMapping(value={"/reloadDatabase"})
    public String reloadDatabase() {
        return this.generalApiService.reloadDatabase();
    }
}

