/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.api;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.ims.V2StateMachine;
import com.coraltele.model.StateDialog;
import com.coraltele.service.IMSV2ServerService;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Conditional(value={EnableIMSV2_SERVER.class})
@RequestMapping(value={"/imsv2"})
public class ImsV2ServerController {
    private static final Logger logger = LogManager.getLogger(ImsV2ServerController.class);
    @Autowired
    Optional<IMSV2ServerService> imsV2ServerService;
    @Autowired
    Optional<V2StateMachine> v2StateMachine;

    @GetMapping(value={"/showregistrations"})
    public ResponseEntity<?> showRegistrations() {
        logger.info("showRegistrations api hit successfully");
        if (!this.imsV2ServerService.isPresent()) {
            return ResponseEntity.badRequest().body((Object)"Invalid API");
        }
        ConcurrentHashMap map = ((IMSV2ServerService)this.imsV2ServerService.get()).showRegistrationData();
        if (map == null || map.isEmpty()) {
            logger.info("No registrations are available to show");
            return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).body((Object)"No registrations available");
        }
        logger.info("Returning {} registration(s)", (Object)map.size());
        return ResponseEntity.ok((Object)map);
    }

    @GetMapping(value={"/registrationState"})
    public ResponseEntity<List<Object>> getAllPhoneExtensions() {
        return ResponseEntity.ok((Object)((IMSV2ServerService)this.imsV2ServerService.get()).getPhoneExtensionData(null));
    }

    @GetMapping(value={"/registrationState/{extension}"})
    public ResponseEntity<List<Object>> getPhoneExtensionById(@PathVariable String extension) {
        return ResponseEntity.ok((Object)((IMSV2ServerService)this.imsV2ServerService.get()).getPhoneExtensionData(extension));
    }

    @GetMapping(value={"/releaseblf/{callId}"})
    public ResponseEntity<String> releaseCall(@PathVariable String callId) {
        if (!this.imsV2ServerService.isPresent()) {
            return ResponseEntity.badRequest().body((Object)"Invalid API");
        }
        if (callId == null || callId.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)"CallId is missing or invalid.");
        }
        logger.info("releaseblf API hit with call id {}", (Object)callId);
        try {
            ((IMSV2ServerService)this.imsV2ServerService.get()).releaseblf(callId);
            return ResponseEntity.ok((Object)"BLF released successfully");
        }
        catch (Exception e) {
            logger.error("Error occurred in releaseCall API", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error occurred in API");
        }
    }

    @GetMapping(value={"/dialogs/{callId}"})
    public ResponseEntity<List<StateDialog>> getCallDetailByCallId(@PathVariable String callId) {
        List dialogs = ((V2StateMachine)this.v2StateMachine.get()).getDialogsByCallId(callId);
        if (dialogs.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)dialogs);
    }

    @GetMapping(value={"/dialogs/user/{user}"})
    public ResponseEntity<List<StateDialog>> getCallDetailByUser(@PathVariable String user) {
        try {
            List dialogs = ((V2StateMachine)this.v2StateMachine.get()).getDialogsByUser(user);
            if (dialogs.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.ok((Object)dialogs);
        }
        catch (Exception e) {
            logger.error("Error fetching dialogs for user {}: {}", (Object)user, (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/v2Subscriptions"})
    public ResponseEntity<?> getUserRelations() {
        return ResponseEntity.ok((Object)((IMSV2ServerService)this.imsV2ServerService.get()).getSubscriptionMapData(null));
    }

    @GetMapping(value={"/v2Subscriptions/{extension}"})
    public ResponseEntity<?> getUserRelations(@PathVariable String extension) {
        return ResponseEntity.ok((Object)((IMSV2ServerService)this.imsV2ServerService.get()).getSubscriptionMapData(extension));
    }
}

