/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.api;

import com.coraltele.IMS;
import com.coraltele.ims.HelperIMS;
import com.coraltele.service.GeneralApiService;
import com.coraltele.service.HealthService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/imsv2"})
public class GeneralApiController {
    private static final Logger logger = LogManager.getLogger(GeneralApiController.class);
    @Autowired
    private GeneralApiService generalApiService;
    @Autowired
    private HelperIMS helperIMS;
    @Autowired
    private HealthService healthService;

    @GetMapping(value={""})
    public ResponseEntity<Map<String, Object>> listingAPIs() {
        return this.generalApiService.getAPIlist();
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<Map<String, Object>> fullHealth() {
        try {
            Map snapshot = this.healthService.fullHealthSnapshot();
            return ResponseEntity.ok((Object)snapshot);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body(Collections.singletonMap("error", e.getMessage()));
        }
    }

    @GetMapping(value={"/configuration"})
    public ResponseEntity<Map<String, Object>> getConfigurations() {
        return ResponseEntity.ok((Object)IMS.buildConfigurations());
    }

    @PostMapping(value={"/loglevel"})
    public String setLogLevel(@RequestParam String level) {
        return this.generalApiService.setRootLogLevel(level);
    }

    @GetMapping(value={"/viewLogFilter"}, produces={"text/plain"})
    public ResponseEntity<?> viewAllLogFilter() {
        return this.generalApiService.viewAllLogFilter();
    }

    @GetMapping(value={"/setLogFilter/{user}"}, produces={"text/plain"})
    public ResponseEntity<?> setLogFilterForUser(@PathVariable String user) {
        return this.generalApiService.setLogFilterForUser(user);
    }

    @GetMapping(value={"/removeLogFilter"}, produces={"text/plain"})
    public ResponseEntity<?> removeAllLogFilter() {
        return this.generalApiService.removeLogFilter(null, true);
    }

    @GetMapping(value={"/removeLogFilter/{user}"}, produces={"text/plain"})
    public ResponseEntity<?> removeLogFilterForUser(@PathVariable String user) {
        return this.generalApiService.removeLogFilter(user, false);
    }

    @GetMapping(value={"/viewValidUserAgent"}, produces={"text/plain"})
    public ResponseEntity<?> viewAllValidUserAgent() {
        return this.generalApiService.viewAllValidUserAgent();
    }

    @GetMapping(value={"/viewBlockedUserAgent"}, produces={"text/plain"})
    public ResponseEntity<?> viewAllBlockedUserAgent() {
        return this.generalApiService.viewAllBlockedUserAgent();
    }

    @GetMapping(value={"/blockUserAgent/{user}"}, produces={"text/plain"})
    public ResponseEntity<?> addBlockUserAgentForUser(@PathVariable String user) {
        return this.generalApiService.addBlockUserAgentForUser(user);
    }

    @GetMapping(value={"/removeBlockUserAgent"}, produces={"text/plain"})
    public ResponseEntity<?> removeAllBlockUserAgent() {
        return this.generalApiService.removeBlockUserAgent(null, true);
    }

    @GetMapping(value={"/removeBlockUserAgent/{user}"}, produces={"text/plain"})
    public ResponseEntity<?> removeBlockUserAgentForUser(@PathVariable String user) {
        return this.generalApiService.removeBlockUserAgent(user, false);
    }

    @GetMapping(value={"/showDialogs"})
    public ResponseEntity<?> showDialogs() {
        return this.generalApiService.showDialogs();
    }

    @GetMapping(value={"/showExtension/{extension}"})
    public ResponseEntity<?> showExtensions(@PathVariable String extension) {
        List extensionlist = (List)this.helperIMS.getExtensionMap().get(extension);
        if (extensionlist != null && extensionlist.size() > 0) {
            return ResponseEntity.ok((Object)extensionlist);
        }
        return ResponseEntity.ok().body((Object)("Extension: " + extension + " not found in Map"));
    }
}

