/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.api;

import com.coraltele.condition.EnableFEATUREIMS_SERVER;
import com.coraltele.helper.Constants;
import com.coraltele.service.FeatureIMSService;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Conditional(value={EnableFEATUREIMS_SERVER.class})
@RequestMapping(value={"/imsv2"})
public class FeatureIMSController {
    private static final Logger logger = LogManager.getLogger(FeatureIMSController.class);
    @Autowired
    private FeatureIMSService featureIMSService;

    @GetMapping(value={"/showuuid"})
    public ResponseEntity<?> showuuid() {
        if (Constants.HA_SYNC.booleanValue()) {
            Map map = this.featureIMSService.getCallUuidMap();
            logger.info("Returning {} uuid's map", (Object)map.size());
            return ResponseEntity.ok((Object)map);
        }
        return ResponseEntity.badRequest().body((Object)"Invalid API");
    }

    @GetMapping(value={"/showregistrations"})
    public ResponseEntity<?> showRegistration() {
        return ResponseEntity.ok((Object)this.featureIMSService.getRegisterMap());
    }

    @GetMapping(value={"/registrationState"})
    public ResponseEntity<List<Object>> getAllPhoneExtensions() {
        return ResponseEntity.ok((Object)this.featureIMSService.getPhoneExtensionData(null));
    }

    @GetMapping(value={"/registrationState/{extension}"})
    public ResponseEntity<List<Object>> getPhoneExtensionById(@PathVariable String extension) {
        return ResponseEntity.ok((Object)this.featureIMSService.getPhoneExtensionData(extension));
    }

    @GetMapping(value={"/showprofilename"})
    public ResponseEntity<?> showProfileName() {
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        response.put("Debian Version", Constants.DEBIAN_VERSION);
        response.put("ProfileName", FeatureIMSService.SIPSERVER_PROFILENAME);
        response.put("DomainName", FeatureIMSService.SIPSERVER_DOMAINNAME);
        response.put("CurrentControlName", FeatureIMSService.CURRENT_RLUCODENAME);
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/showprofilename/{user}"})
    public ResponseEntity<?> showProfileName(@PathVariable String user) {
        if (user != null && user.length() > 0) {
            LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
            response.put("User", user);
            response.put("ProfileName", this.featureIMSService.getSipServerProfileName(user));
            response.put("DomainName", FeatureIMSService.SIPSERVER_DOMAINNAME);
            response.put("CurrentControlName", FeatureIMSService.CURRENT_RLUCODENAME);
            response.put("Debian Version", Constants.DEBIAN_VERSION);
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.badRequest().body(Collections.singletonMap("error", "user is null or Empty"));
    }

    @GetMapping(value={"/virtualIp/{user}"})
    public ResponseEntity<?> getVirtualIp(@PathVariable String user) {
        String virtualIP = this.featureIMSService.getVirtualIP(user);
        return ResponseEntity.ok().body((Object)("VirtualIP for user : " + user + " is: " + virtualIP));
    }

    @GetMapping(value={"/showrecoveryuuidlist"})
    public HashSet<String> getMethodName() {
        return this.featureIMSService.recoveryUuidList;
    }

    public ResponseEntity<?> getList(@PathVariable String user) {
        String virtualIP = this.featureIMSService.getVirtualIP(user);
        return ResponseEntity.ok().body((Object)("VirtualIP for user : " + user + " is: " + virtualIP));
    }

    @PostMapping(value={"/recovery"})
    public ResponseEntity<?> updateStatus(@RequestParam String status, @RequestParam String uuid, HttpServletRequest request) {
        String clientIp = this.getClientIp(request);
        logger.info("Received status={}, uuid={} from={} .", (Object)status, (Object)uuid, (Object)clientIp);
        if (Constants.HA_SYNC.booleanValue() && !Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
            this.featureIMSService.syncRecovery(status, uuid);
            return ResponseEntity.ok((Object)("Received uuid : " + uuid + " successfully in IMSV2"));
        }
        if (Constants.HA_SYNC.booleanValue() && Constants.RECOVERYSYNC_PACKETS.booleanValue()) {
            return ResponseEntity.ok((Object)("Received uuid : " + uuid + " successfully in IMSV2. But Sync is done with Packets."));
        }
        return ResponseEntity.ok().body((Object)("Received uuid : " + uuid + " successfully in IMSV2. But Sync is off"));
    }

    private String getClientIp(HttpServletRequest request) {
        String forwarded = request.getHeader("X-Forwarded-For");
        if (forwarded != null && !forwarded.isEmpty()) {
            return forwarded.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

