/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele;

import com.coraltele.helper.Constants;
import com.coraltele.service.BranchAndJarInfoService;
import com.coraltele.service.FeatureIMSService;
import com.coraltele.service.VersionService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableScheduling
public class IMS {
    private static final Logger logger = LogManager.getLogger(IMS.class);
    private static final String IMS_V2 = "IMS-V2";
    private static final String HOSTNAME_API_URL = "http://127.0.0.1/hostname";
    private static final String CSVERSION_URL = "http://127.0.0.1:8080/configuration/";

    public static void main(String[] args) {
        IMS.readProperties();
        ConfigurableApplicationContext context = SpringApplication.run(IMS.class, (String[])args);
        IMS.initialize_GIT_INFO((ApplicationContext)context);
        IMS.logAllConfigurations();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer placeholderConfigurer() {
        PropertySourcesPlaceholderConfigurer propsConfig = new PropertySourcesPlaceholderConfigurer();
        propsConfig.setLocation((Resource)new ClassPathResource("git.properties"));
        propsConfig.setIgnoreResourceNotFound(true);
        propsConfig.setIgnoreUnresolvablePlaceholders(true);
        return propsConfig;
    }

    private static void logAllConfigurations() {
        logger.info("============================ Configuration Values : Start ============================");
        logger.info("{} ==> HOSTNAME : {}", (Object)"IMS-V2", (Object)Constants.HOSTNAME);
        logger.info("{} ==> USER-AGENT {}", (Object)"IMS-V2", (Object)Constants.USER_AGENT);
        logger.info("{} ==> MASTER-HOSTNAME : {}", (Object)"IMS-V2", (Object)Constants.MASTER_HOSTNAME);
        logger.info("{} ==> IMS-MODE {}", (Object)"IMS-V2", (Object)Constants.IMS_MODE);
        logger.info("{} ==> IMSV2SERVER-ROUTE {}", (Object)"IMS-V2", (Object)Constants.IMSV2SERVER_ROUTE);
        logger.info("{} ==> V2STATE-MACHINE {}", (Object)"IMS-V2", (Object)Constants.V2STATE_MACHINE);
        logger.info("{} ==> SCALABILITY {}", (Object)"IMS-V2", (Object)Constants.SCALABILITY);
        logger.info("{} ==> HA-SYNC {}", (Object)"IMS-V2", (Object)Constants.HA_SYNC);
        logger.info("{} ==> REDIS-IP:REDIS-PORT {}:{}", (Object)"IMS-V2", (Object)Constants.REDIS_IP, (Object)Constants.REDIS_PORT);
        logger.info("{} ==> RECOVERYSYNC-PACKETS {}", (Object)"IMS-V2", (Object)Constants.RECOVERYSYNC_PACKETS);
        logger.info("{} ==> MULTIPLE-REGISTRATIONS {}", (Object)"IMS-V2", (Object)Constants.MULTIPLE_REGISTRATIONS);
        logger.info("{} ==> IMS-TRANSPORT-MODE {}", (Object)"IMS-V2", (Object)Constants.IMS_TRANSPORT_MODE);
        logger.info("{} ==> PUBLIC-IP-ADDRESS {}", (Object)"IMS-V2", (Object)Constants.PUBLIC_IP_ADDRESS);
        logger.info("{} ==> DOMAINNAMELIST {}", (Object)"IMS-V2", (Object)Constants.DOMAINNAMELIST);
        logger.info("{} ==> LISTEN-IP-ADDRESS {}", (Object)"IMS-V2", (Object)Constants.LISTEN_IP_ADDRESS);
        logger.info("{} ==> LISTEN-UDP-PORT {}", (Object)"IMS-V2", (Object)Constants.LISTEN_UDP_PORT);
        logger.info("{} ==> LISTEN-TCP-PORT {}", (Object)"IMS-V2", (Object)Constants.LISTEN_TCP_PORT);
        logger.info("{} ==> LISTEN-TLS-PORT {}", (Object)"IMS-V2", (Object)Constants.LISTEN_TLS_PORT);
        logger.info("{} ==> SIPREGISTRAR-IP:PORT:TRANSPORT {}", (Object)"IMS-V2", (Object)(Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT + ":" + Constants.SIPREGISTRAR_TRANSPORT));
        logger.info("{} ==> SIPSERVER-IP:PORT:TRANSPORT {}", (Object)"IMS-V2", (Object)(Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_PORT + ":" + Constants.SIPSERVER_TRANSPORT));
        logger.info("{} ==> CONFERENCING-SERVER-IP:PORT:TRANSPORT {}", (Object)"IMS-V2", (Object)(Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_PORT + ":" + Constants.CONFERENCINGSERVER_TRANSPORT));
        logger.info("{} ==> FORWARDING-IP:PORT {}", (Object)"IMS-V2", (Object)(Constants.FORWARDING_IP_ADDRESS + ":" + Constants.FORWARDING_PORT));
        logger.info("{} ==> RLUREGISTRATION-SYNC {}", (Object)"IMS-V2", (Object)Constants.RLUREGISTRATION_SYNC);
        logger.info("{} ==> RLUREGISTRAR-PORT {}", (Object)"IMS-V2", (Object)Constants.RLUREGISTRAR_PORT);
        logger.info("{} ==> SUBSCRIBER_SAVE_TIMER_IN_MINUTES {}", (Object)"IMS-V2", (Object)Constants.SUBSCRIBER_SAVE_TIMER_IN_MINUTES);
        logger.info("{} ==> BACKGROUND_TASK_TIMER_IN_MINUTES {}", (Object)"IMS-V2", (Object)Constants.BACKGROUND_TASK_TIMER_IN_MINUTES);
        logger.info("{} ==> REGISTRATION_SAVE_TIMER_IN_MINUTES {}", (Object)"IMS-V2", (Object)Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES);
        logger.info("{} ==> THREADDELAY-RECOVERYSYNC-MILLISECONDS {}", (Object)"IMS-V2", (Object)Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS);
        logger.info("{} ==> USERAGENTLIST {}", (Object)"IMS-V2", (Object)Constants.USERAGENTLIST);
        logger.info("{} ==> DEBIAN_VERSION : {}", (Object)"IMS-V2", (Object)Constants.DEBIAN_VERSION);
        logger.info("{} ==> SIPSERVER-PROFILENAME {}", (Object)"IMS-V2", (Object)FeatureIMSService.SIPSERVER_PROFILENAME);
        logger.info("{} ==> SIPSERVER-DOMAINNAME {}", (Object)"IMS-V2", (Object)FeatureIMSService.SIPSERVER_DOMAINNAME);
        logger.info("{} ==> BUILD-TIME : {}", (Object)"IMS-V2", (Object)Constants.BUILD_TIME);
        logger.info("{} ==> BRANCH-NAME : {}", (Object)"IMS-V2", (Object)Constants.GIT_BRANCHNAME);
        IMS.buildConfigurations().forEach((k, v) -> logger.info("{} ==> {}", k, v));
        logger.info("============================ Configuration Values : End   ============================");
    }

    private static void readProperties() {
        String clusterConfiguration = "/etc/default/coral";
        try {
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            Constants.PUBLIC_IP_ADDRESS = configuration.node("IMS-V2").get("PUBLIC-IP-ADDRESS", "");
            Constants.LISTEN_IP_ADDRESS = configuration.node("IMS-V2").get("LISTEN-IP-ADDRESS", "127.0.0.1");
            Constants.LISTEN_UDP_PORT = configuration.node("IMS-V2").getInt("LISTEN-UDP-PORT", 5060);
            Constants.LISTEN_TCP_PORT = configuration.node("IMS-V2").getInt("LISTEN-TCP-PORT", 5060);
            Constants.LISTEN_TLS_PORT = configuration.node("IMS-V2").getInt("LISTEN-TLS-PORT", 5061);
            Constants.IMS_TRANSPORT_MODE = configuration.node("IMS-V2").get("IMS-TRANSPORT-MODE", "UDP");
            Constants.SUBSCRIBER_SAVE_TIMER_IN_MINUTES = configuration.node("IMS-V2").getInt("SUBSCRIBER_SAVE_TIMER_IN_MINUTES", 10);
            Constants.BACKGROUND_TASK_TIMER_IN_MINUTES = configuration.node("IMS-V2").getInt("BACKGROUND_TASK_TIMER_IN_MINUTES", 0);
            Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES = configuration.node("IMS-V2").getInt("REGISTRATION_SAVE_TIMER_IN_MINUTES", 10);
            Constants.FORWARDING_IP_ADDRESS = configuration.node("IMS-V2").get("FORWARDING-IP-ADDRESS", "");
            Constants.FORWARDING_PORT = configuration.node("IMS-V2").getInt("FORWARDING-PORT", 0);
            Constants.FORWARDING_IP_ADDRESS_WITH_PORT = Constants.FORWARDING_IP_ADDRESS + ":" + Constants.FORWARDING_PORT;
            Constants.IMS_MODE = configuration.node("IMS-V2").get("IMS-MODE", "FEATUREIMS-SERVER");
            Constants.IMSV2SERVER_ROUTE = configuration.node("IMS-V2").get("IMSV2SERVER-ROUTE", "");
            Constants.SIPREGISTRAR_IP = configuration.node("IMS-V2").get("SIPREGISTRAR-IP", "");
            Constants.SIPREGISTRAR_PORT = configuration.node("IMS-V2").getInt("SIPREGISTRAR-PORT", 5060);
            Constants.SIPREGISTRAR_TRANSPORT = configuration.node("IMS-V2").get("SIPREGISTRAR-TRANSPORT", "UDP");
            Constants.RLUREGISTRATION_SYNC = configuration.node("IMS-V2").getBoolean("RLUREGISTRATION-SYNC", false);
            Constants.RLUREGISTRAR_PORT = configuration.node("IMS-V2").getInt("RLUREGISTRAR-PORT", 5062);
            Constants.CONFERENCING_SERVER_IP = configuration.node("IMS-V2").get("CONFERENCING-SERVER-IP", "");
            Constants.CONFERENCING_SERVER_PORT = configuration.node("IMS-V2").getInt("CONFERENCING-SERVER-PORT", 5060);
            Constants.CONFERENCINGSERVER_TRANSPORT = configuration.node("IMS-V2").get("CONFERENCINGSERVER-TRANSPORT", "UDP");
            Constants.SIPSERVER_IP = configuration.node("IMS-V2").get("SIPSERVER-IP", "");
            Constants.SIPSERVER_PORT = configuration.node("IMS-V2").getInt("SIPSERVER-PORT", 5060);
            Constants.SIPSERVER_TRANSPORT = configuration.node("IMS-V2").get("SIPSERVER-TRANSPORT", "UDP");
            Constants.V2STATE_MACHINE = configuration.node("IMS-V2").getBoolean("V2STATE-MACHINE", true);
            Constants.DOMAINNAMELIST = configuration.node("IMS-V2").get("DOMAINNAMELIST", null);
            Constants.USERAGENTLIST = configuration.node("IMS-V2").get("USERAGENTLIST", null);
            Constants.CORALKEYSTORE_PASS = configuration.node("IMS-V2").get("CORALKEYSTORE-PASS", "redhat");
            Constants.SCALABILITY = configuration.node("IMS-V2").get("SCALABILITY", "HIGH");
            Constants.HA_SYNC = configuration.node("IMS-V2").getBoolean("HA-SYNC", true);
            Constants.RECOVERYSYNC_PACKETS = configuration.node("IMS-V2").getBoolean("RECOVERYSYNC-PACKETS", false);
            Constants.MULTIPLE_REGISTRATIONS = configuration.node("IMS-V2").getBoolean("MULTIPLE-REGISTRATIONS", false);
            Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS = configuration.node("IMS-V2").getInt("THREADDELAY-RECOVERYSYNC-MILLISECONDS", 1000);
            Constants.CORALKEYSTORE_PASS = configuration.node("IMS-V2").get("CORALKEYSTORE-PASS", "redhat");
            Constants.CORALKEYSTORE_FILEPATH = configuration.node("IMS-V2").get("CORALKEYSTORE-FILEPATH", "/etc/coraltele/certs/coralkeystore.jks");
            Constants.SIPREGISTRAR_TCPPORT = configuration.node("IMS-V2").getInt("SIPREGISTRAR-TCPPORT", 5060);
            Constants.SIPREGISTRAR_TLSPORT = configuration.node("IMS-V2").getInt("SIPREGISTRAR-TLSPORT", 5061);
            Constants.SIPSERVER_TCPPORT = configuration.node("IMS-V2").getInt("SIPSERVER-TCPPORT", 5060);
            Constants.SIPSERVER_TLSPORT = configuration.node("IMS-V2").getInt("SIPSERVER_TLSPORT", 5061);
            Constants.CONFERENCING_SERVER_TCPPORT = configuration.node("IMS-V2").getInt("CONFERENCING-SERVER-TCPPORT", 5060);
            Constants.CONFERENCING_SERVER_TLSPORT = configuration.node("IMS-V2").getInt("CONFERENCING-SERVER-TLSPORT", 5061);
            Constants.REDIS_IP = configuration.node("IMS-V2").get("REDIS-IP", "127.0.0.1");
            Constants.REDIS_PORT = configuration.node("IMS-V2").getInt("REDIS-PORT", 6379);
            IMS.initializeSpecificConstantValue();
            IMS.getDebianVersion();
        }
        catch (Exception e) {
            logger.error("Error while reading properties {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void initializeSpecificConstantValue() {
        try {
            if (Constants.IMS_MODE != null && !Constants.IMS_MODE.isEmpty()) {
                Constants.IMS_MODE.trim();
            }
            IMS.fetchAndSetHostname();
            if (Constants.SCALABILITY.isEmpty() || Constants.SCALABILITY.equalsIgnoreCase("LOW")) {
                Constants.SCALABILITY = "LOW";
                Constants.CORE_POOL_SIZE = 10;
                Constants.MAX_POOL_SIZE = 20;
                Constants.KEEP_ALIVE_TIME = 10L;
            } else if (Constants.SCALABILITY.equalsIgnoreCase("MEDIUM")) {
                Constants.CORE_POOL_SIZE = 30;
                Constants.MAX_POOL_SIZE = 50;
                Constants.KEEP_ALIVE_TIME = 10L;
            } else if (Constants.SCALABILITY.equalsIgnoreCase("HIGH")) {
                Constants.CORE_POOL_SIZE = 50;
                Constants.MAX_POOL_SIZE = 70;
                Constants.KEEP_ALIVE_TIME = 10L;
            }
            if (Constants.PUBLIC_IP_ADDRESS.length() > 0) {
                Constants.NAT = true;
            } else {
                Constants.PUBLIC_IP_ADDRESS = Constants.LISTEN_IP_ADDRESS;
            }
            String[] listenTransport = Constants.IMS_TRANSPORT_MODE.toUpperCase().split(",");
            if (listenTransport.length <= 0) {
                Constants.LISTEN_ON_UDP = true;
            }
            for (String transport : listenTransport) {
                if (transport.equals("UDP")) {
                    Constants.LISTEN_ON_UDP = true;
                    continue;
                }
                if (transport.equals("TCP")) {
                    Constants.LISTEN_ON_TCP = true;
                    continue;
                }
                if (!transport.equals("TLS")) continue;
                Constants.LISTEN_ON_TLS = true;
                if (Constants.CORALKEYSTORE_FILEPATH.length() > 0) continue;
                Constants.CORALKEYSTORE_FILEPATH = "/etc/coraltele/certs/coralkeystore.jks";
                Constants.CORALKEYSTORE_PASS = "redhat";
            }
            if (!(Constants.LISTEN_ON_UDP.booleanValue() || Constants.LISTEN_ON_TCP.booleanValue() || Constants.LISTEN_ON_TLS.booleanValue())) {
                Constants.LISTEN_ON_UDP = true;
            }
            if (Constants.IMS_MODE.equalsIgnoreCase("IMSV2-SERVER")) {
                Constants.IMS_MODE = "IMSV2-SERVER";
                Constants.HA_SYNC = Boolean.FALSE;
                if (Constants.CONFERENCING_SERVER_IP == null || Constants.CONFERENCING_SERVER_IP.length() <= 0) {
                    Constants.CONFERENCING_SERVER_IP = Constants.SIPSERVER_IP;
                    Constants.CONFERENCING_SERVER_PORT = Constants.SIPSERVER_PORT;
                    Constants.CONFERENCINGSERVER_TRANSPORT = Constants.SIPSERVER_TRANSPORT;
                }
                if (Constants.SIPREGISTRAR_IP == null || Constants.SIPREGISTRAR_IP.length() <= 0) {
                    Constants.SIPREGISTRAR_IP = Constants.SIPSERVER_IP;
                    Constants.SIPREGISTRAR_PORT = Constants.SIPSERVER_PORT;
                    Constants.SIPREGISTRAR_TRANSPORT = Constants.SIPSERVER_TRANSPORT;
                }
                Constants.SIPREGISTRAR_ADDRESS = Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT;
                Constants.SIPSERVER_ADDRESS = Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_PORT;
                Constants.CONFERENCESERVER_ADDRESS = Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_PORT;
                if (Constants.IMSV2SERVER_ROUTE.equalsIgnoreCase("SIPSERVER")) {
                    Constants.IMSV2_ROUTETO_SIPSERVER = true;
                }
            } else if (Constants.IMS_MODE.equalsIgnoreCase("SUBSCRIBER-SERVER")) {
                Constants.V2STATE_MACHINE = false;
                Constants.IMS_MODE = "SUBSCRIBER-SERVER";
                Constants.HA_SYNC = Boolean.FALSE;
            } else if (Constants.IMS_MODE.equalsIgnoreCase("IMSV2-SBC")) {
                Constants.V2STATE_MACHINE = false;
                Constants.IMS_MODE = "IMSV2-SBC";
                Constants.HA_SYNC = Boolean.FALSE;
            } else {
                if (Constants.IMS_MODE == null || Constants.IMS_MODE.length() <= 0) {
                    Constants.IMS_MODE = "FEATUREIMS-SERVER";
                }
                if (Constants.SIPREGISTRAR_IP == null || Constants.SIPREGISTRAR_IP.length() <= 0) {
                    System.out.println("\nExiting the application. SIPREGISTRAR-IP is missing in coral file. Please fill the IP and restart the Application.\n");
                    System.exit(0);
                }
                if (Constants.CONFERENCING_SERVER_IP == null || Constants.CONFERENCING_SERVER_IP.length() <= 0) {
                    Constants.CONFERENCING_SERVER_IP = Constants.SIPREGISTRAR_IP;
                    Constants.CONFERENCING_SERVER_PORT = Constants.SIPREGISTRAR_PORT;
                    Constants.CONFERENCING_SERVER_TCPPORT = Constants.SIPREGISTRAR_TCPPORT;
                    Constants.CONFERENCING_SERVER_TLSPORT = Constants.SIPREGISTRAR_TLSPORT;
                }
                if (Constants.SIPSERVER_IP == null || Constants.SIPSERVER_IP.length() <= 0) {
                    Constants.SIPSERVER_IP = Constants.SIPREGISTRAR_IP;
                    Constants.SIPSERVER_PORT = Constants.SIPREGISTRAR_PORT;
                    Constants.SIPSERVER_TCPPORT = Constants.SIPREGISTRAR_TCPPORT;
                    Constants.SIPSERVER_TLSPORT = Constants.SIPREGISTRAR_TLSPORT;
                }
                Constants.SIPREGISTRAR_ADDRESS = Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT;
                Constants.SIPSERVER_ADDRESS = Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_PORT;
                Constants.CONFERENCESERVER_ADDRESS = Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_PORT;
                Constants.SIPREGISTRAR_TCPADDRESS = Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_TCPPORT;
                Constants.SIPREGISTRAR_TLSADDRESS = Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_TLSPORT;
                Constants.SIPSERVER_TCPADDRESS = Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_TCPPORT;
                Constants.SIPSERVER_TLSADDRESS = Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_TLSPORT;
                Constants.CONFERENCESERVER_TCPADDRESS = Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_TCPPORT;
                Constants.CONFERENCESERVER_TLSADDRESS = Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_TLSPORT;
            }
        }
        catch (Exception e) {
            logger.error("Error in initializeSpecificConstantValue method {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void fetchAndSetHostname() {
        block21: {
            try {
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity response = restTemplate.getForEntity("http://127.0.0.1/hostname", String.class, new Object[0]);
                if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                    Constants.HOSTNAME = ((String)response.getBody()).trim();
                    break block21;
                }
                String output1 = "";
                String[] cmd = new String[]{"/bbin/sh", "-c", "hostname"};
                Process process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output1 = line.trim();
                    }
                }
                if (!output1.isEmpty()) {
                    Constants.HOSTNAME = output1;
                }
            }
            catch (Exception e) {
                logger.warn("Exception while fetching hostname from API");
                try {
                    String output1 = "";
                    String[] cmd = new String[]{"/bin/sh", "-c", "hostname"};
                    Process process = Runtime.getRuntime().exec(cmd);
                    process.waitFor();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            output1 = line.trim();
                        }
                    }
                    if (!output1.isEmpty()) {
                        Constants.HOSTNAME = output1;
                    }
                }
                catch (Exception e1) {
                    logger.warn("Error while fetching hostname from commandLine");
                    try {
                        Constants.HOSTNAME = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception e2) {
                        logger.warn("Error while fetching hostname from InetAddress {}", (Throwable)e2);
                    }
                }
            }
        }
    }

    private static void getDebianVersion() {
        String line = "";
        String output1 = "";
        try {
            String[] Ipstr = new String[]{"/bin/sh", "-c", "cat /etc/issue | grep Debian | awk '{print $3}'"};
            Process ls = Runtime.getRuntime().exec(Ipstr);
            ls.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(ls.getInputStream()));
            while ((line = buf.readLine()) != null) {
                output1 = line;
            }
        }
        catch (Exception e) {
            logger.error("Exception to fetch getDebianVersion:" + e.getMessage());
        }
        if (output1.length() > 0) {
            Constants.DEBIAN_VERSION = output1.trim();
        }
    }

    public static Map<String, Object> buildConfigurations() {
        LinkedHashMap config = new LinkedHashMap();
        LinkedHashMap<String, Object> defaultConfig = new LinkedHashMap<String, Object>();
        defaultConfig.put("IMS-MODE", Constants.IMS_MODE);
        defaultConfig.put("IMS-TRANSPORT-MODE", Constants.IMS_TRANSPORT_MODE);
        defaultConfig.put("SIPREGISTRAR", Constants.SIPREGISTRAR_IP + ":" + Constants.SIPREGISTRAR_PORT + ":" + Constants.SIPREGISTRAR_TRANSPORT);
        defaultConfig.put("SIPSERVER", Constants.SIPSERVER_IP + ":" + Constants.SIPSERVER_PORT + ":" + Constants.SIPSERVER_TRANSPORT);
        defaultConfig.put("CONFERENCING-SERVER", Constants.CONFERENCING_SERVER_IP + ":" + Constants.CONFERENCING_SERVER_PORT + ":" + Constants.CONFERENCINGSERVER_TRANSPORT);
        defaultConfig.put("FORWARDING-IP:PORT", Constants.FORWARDING_IP_ADDRESS + ":" + Constants.FORWARDING_PORT);
        defaultConfig.put("PUBLIC-IP-ADDRESS", Constants.PUBLIC_IP_ADDRESS);
        defaultConfig.put("LISTEN-IP-ADDRESS", Constants.LISTEN_IP_ADDRESS);
        defaultConfig.put("LISTEN-UDP-PORT", Constants.LISTEN_UDP_PORT);
        defaultConfig.put("LISTEN-TCP-PORT", Constants.LISTEN_TCP_PORT);
        defaultConfig.put("LISTEN-TLS-PORT", Constants.LISTEN_TLS_PORT);
        defaultConfig.put("RLUREGISTRAR-PORT", Constants.RLUREGISTRAR_PORT);
        defaultConfig.put("DOMAINNAMELIST", Constants.DOMAINNAMELIST);
        defaultConfig.put("Version", Constants.USER_AGENT);
        defaultConfig.put("IMSV2SERVER-ROUTE", Constants.IMSV2SERVER_ROUTE);
        defaultConfig.put("V2STATE-MACHINE", Constants.V2STATE_MACHINE);
        defaultConfig.put("HA-SYNC", Constants.HA_SYNC);
        defaultConfig.put("REDIS-IP", Constants.REDIS_IP);
        defaultConfig.put("REDIS-PORT", Constants.REDIS_PORT);
        defaultConfig.put("RECOVERYSYNC-PACKETS", Constants.RECOVERYSYNC_PACKETS);
        defaultConfig.put("MULTIPLE-REGISTRATIONS", Constants.MULTIPLE_REGISTRATIONS);
        defaultConfig.put("RLUREGISTRATION-SYNC", Constants.RLUREGISTRATION_SYNC);
        defaultConfig.put("SCALABILITY", Constants.SCALABILITY);
        defaultConfig.put("SUBSCRIBER_SAVE_TIMER_IN_MINUTES", Constants.SUBSCRIBER_SAVE_TIMER_IN_MINUTES);
        defaultConfig.put("BACKGROUND_TASK_TIMER_IN_MINUTES", Constants.BACKGROUND_TASK_TIMER_IN_MINUTES);
        defaultConfig.put("REGISTRATION_SAVE_TIMER_IN_MINUTES", Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES);
        defaultConfig.put("THREADDELAY_RECOVERYSYNC_MILLISECONDS", Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS);
        LinkedHashMap<String, String> derivedConfig = new LinkedHashMap<String, String>();
        derivedConfig.put("HOSTNAME", Constants.HOSTNAME);
        derivedConfig.put("USERAGENTLIST", Constants.USERAGENTLIST);
        derivedConfig.put("DEBIAN_VERSION", Constants.DEBIAN_VERSION);
        derivedConfig.put("SIPSERVER-PROFILENAME", FeatureIMSService.SIPSERVER_PROFILENAME);
        derivedConfig.put("SIPSERVER-DOMAINNAME", FeatureIMSService.SIPSERVER_DOMAINNAME);
        derivedConfig.put("BUILD-TIME", Constants.BUILD_TIME);
        derivedConfig.put("BRANCH-NAME", Constants.GIT_BRANCHNAME);
        config.put("defaultConfigurations", Collections.unmodifiableMap(defaultConfig));
        config.put("derivedConfigurations", Collections.unmodifiableMap(derivedConfig));
        return Collections.unmodifiableMap(config);
    }

    private static void initialize_GIT_INFO(ApplicationContext context) {
        try {
            VersionService versionService;
            BranchAndJarInfoService branchAndJarInfoService = (BranchAndJarInfoService)context.getBean(BranchAndJarInfoService.class);
            if (branchAndJarInfoService != null) {
                Constants.GIT_BRANCHNAME = branchAndJarInfoService.getBranchName();
                Constants.BUILD_TIME = branchAndJarInfoService.getBuildTime();
            }
            Constants.USER_AGENT = (versionService = (VersionService)context.getBean(VersionService.class)) != null && versionService.getCurrentVersion() != null ? versionService.getCurrentVersion() : "";
            Constants.USER_AGENT = Constants.USER_AGENT + "_" + Constants.HOSTNAME;
            IMS.getCsVersion();
        }
        catch (Exception e) {
            logger.error("Error in initialize_GIT_INFO method {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void getCsVersion() {
        try {
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.getForEntity("http://127.0.0.1:8080/configuration/", String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                String csVersion = ((String)response.getBody()).trim();
                Constants.USER_AGENT = Constants.USER_AGENT + "_CS" + csVersion;
                logger.info("CallServer Version {}", (Object)csVersion);
            }
        }
        catch (Exception e) {
            logger.warn("Error in getCsVersion {}", (Object)e.getMessage());
        }
    }
}

