/*
 * Decompiled with CFR 0.152.
 */
package coralcliservices;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class callbackservice {
    static final Logger log = Logger.getLogger((String)callbackservice.class.getSimpleName());
    private static String callbackversion = "1.0.0.24";
    private static String ipport = "8080";
    private static String sipserver;
    private static int sipport;
    private static int callbackport;
    private static String pwd;
    private static Socket serverSocket;
    private static String jdbcDriver;
    private static String jdbcUrl;
    private static String jdbcUser;
    private static String jdbcPassword;
    private static String coralappsUser;
    private static String coralappsPwd;
    private static String coralappUrl;
    private static String serverCode;
    private static String attachedIP;
    private static int noofoldday_callback;
    private static int maxtry_callback;
    private static boolean isSystemConfigFetch;

    static {
        callbackport = 0;
        pwd = "ClueCon";
        serverSocket = null;
        jdbcDriver = "";
        jdbcUrl = "";
        jdbcUser = "";
        jdbcPassword = "";
        coralappsUser = "";
        coralappsPwd = "";
        coralappUrl = "";
        serverCode = "";
        attachedIP = "";
        isSystemConfigFetch = false;
    }

    private static boolean readConfig() {
        boolean sucess;
        block13: {
            Properties prop = new Properties();
            FileInputStream input = null;
            sucess = false;
            String fileName = "/etc/coraltele/conf/app.config";
            try {
                try {
                    input = new FileInputStream(fileName);
                    prop.load(input);
                    jdbcDriver = prop.getProperty("jdbcdriver") != null ? prop.getProperty("jdbcdriver") : "";
                    jdbcUrl = prop.getProperty("jdbcUrl") != null ? prop.getProperty("jdbcUrl") : "";
                    jdbcUser = prop.getProperty("jdbcuser") != null ? prop.getProperty("jdbcuser") : "";
                    jdbcPassword = prop.getProperty("jdbcpassword") != null ? prop.getProperty("jdbcpassword") : "";
                    sipserver = prop.getProperty("sipserver") != null ? prop.getProperty("sipserver") : "";
                    sipport = Integer.parseInt(prop.getProperty("sipport") != null ? prop.getProperty("sipport") : "8021");
                    coralappsPwd = prop.getProperty("coralappspassword") != null ? prop.getProperty("coralappspassword") : "";
                    coralappUrl = prop.getProperty("coralappsurl") != null ? prop.getProperty("coralappsurl") : "";
                    coralappsUser = prop.getProperty("coralappsuser") != null ? prop.getProperty("coralappsuser") : "";
                    serverCode = prop.getProperty("servercode") != null ? prop.getProperty("servercode") : "s1";
                    callbackport = Integer.parseInt(prop.getProperty("callbackport") != null ? prop.getProperty("callbackport") : "0");
                    if (serverCode.isEmpty()) {
                        serverCode = "s1";
                    }
                    sucess = true;
                }
                catch (IOException ex) {
                    log.error((Object)("Exception at loading config Error:" + ex.getMessage()));
                    if (input == null) break block13;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception at loading config Error:" + e.getMessage()));
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception at loading config Error:" + e.getMessage()));
                    }
                }
            }
        }
        return sucess;
    }

    private static Connection getSwitchdbConnection() {
        Connection conn = null;
        try {
            Class.forName(jdbcDriver);
            try {
                conn = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
            }
            catch (SQLException e) {
                log.error((Object)("Exception at Create SwitchdbConnection() Error:" + e.getMessage()));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Exception at Create DBClass  for SwitchdbConnection Error:" + e.getMessage()));
        }
        return conn;
    }

    private static Connection getCoralappsdbConnection() {
        Connection conn = null;
        try {
            Class.forName(jdbcDriver);
            try {
                conn = DriverManager.getConnection(coralappUrl, coralappsUser, coralappsPwd);
            }
            catch (SQLException e) {
                log.error((Object)("Exception at Create CoralappsdbConnection() Error:" + e.getMessage()));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Exception at Create DBClass for CoralappsdbConnection Error:" + e.getMessage()));
        }
        return conn;
    }

    private static Socket create_Socket_stream(String ip, int port, String pwd) {
        Socket sSocket = null;
        String inputLine = "";
        if (ip.isEmpty() && port == 0) {
            log.debug((Object)("Error at ip: " + ip + " and port: " + Integer.toString(port)));
            return sSocket;
        }
        try {
            sSocket = new Socket(ip, port);
            if (sSocket.isConnected()) {
                log.debug((Object)"socket_stream connected");
            } else {
                log.debug((Object)"socket_stream not connected");
            }
            PrintWriter out = new PrintWriter(sSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(sSocket.getInputStream()));
            Thread.sleep(500L);
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.equalsIgnoreCase("Content-Type: auth/request")) continue;
                out.write("auth " + pwd + "\n\n");
                out.flush();
                break;
            }
        }
        catch (SocketException e) {
            log.error((Object)("SocketException at create_Socket_stream message:" + e.getMessage()));
        }
        catch (UnknownHostException e) {
            log.error((Object)("UnknownHostException at create_Socket_stream message:" + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("IOException at create_Socket_stream message:" + e.getMessage()));
        }
        catch (InterruptedException e) {
            log.error((Object)("InterruptedException at create_Socket_stream message:" + e.getMessage()));
        }
        return sSocket;
    }

    private static String send_socket_stream(Socket sock, String cmd) {
        String data;
        block7: {
            data = "";
            try {
                String inputLine = "";
                if (sock.isConnected()) {
                    PrintWriter out = new PrintWriter(sock.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    out.write(String.valueOf(cmd) + "\n\n");
                    out.flush();
                    int contentLength = 0;
                    while ((inputLine = in.readLine()) != null) {
                        if (contentLength > 0) {
                            data = String.valueOf(data) + inputLine + "\n";
                        }
                        if (inputLine.contains("Content-Length")) {
                            String[] values = inputLine.split(":");
                            contentLength = Integer.parseInt(values[1].trim());
                        }
                        if (contentLength <= 0 || data.length() < contentLength) {
                            continue;
                        }
                        break block7;
                    }
                    break block7;
                }
                log.debug((Object)"socket not connected (may be die)");
            }
            catch (IOException e) {
                log.error((Object)("IOException at send_socket_stream message:" + e.getMessage()));
                data = "";
            }
        }
        return data;
    }

    private static boolean isSocketStreamConnected(Socket sock) {
        String switchCmd;
        boolean isConnected = false;
        String data = "";
        if (sock != null && !(data = callbackservice.send_socket_stream(sock, switchCmd = "api status")).isEmpty()) {
            isConnected = true;
        }
        return isConnected;
    }

    private static boolean isDbConnected(Connection conn) {
        boolean isConnected = false;
        String qry = "select 1 as count";
        PreparedStatement query = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                query = conn.prepareStatement(qry);
                rs = query.executeQuery();
                while (rs.next()) {
                    isConnected = true;
                }
            }
            catch (SQLException e) {
                log.error((Object)("SQLException at isDbconnected() :" + e.getMessage()));
            }
        } else {
            log.error((Object)"Exist due get NULL connection");
        }
        return isConnected;
    }

    private static void makecall(Socket sock, String command) {
        try {
            String cmd = "";
            cmd = command;
            log.debug((Object)("Execute Command: " + cmd));
            callbackservice.send_socket_stream(sock, "api bgapi " + cmd);
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            log.error((Object)("exception at makecall () :" + e.getMessage()));
        }
    }

    public static void main(String[] args) {
        System.out.println("version:" + callbackversion);
        PropertyConfigurator.configure((String)"/etc/coraltele/logproperties/callback.properties");
        log.debug((Object)("Callback version is :" + callbackversion));
        boolean switchdb = false;
        boolean coralappsdb = false;
        String qry = "";
        Statement query = null;
        ResultSet rs = null;
        String rlucode = "";
        boolean isfromuserActive = false;
        boolean istoUserActive = false;
        String callbackdummynumber = "";
        Connection coralappsConn = null;
        Connection switchConn = null;
        Connection customConnection = null;
        if (!callbackservice.readConfig()) {
            log.debug((Object)"Error to read config parameter");
            return;
        }
        attachedIP = callbackservice.getAttachedIpInfo();
        log.debug((Object)("Finding Attached IP Info:" + attachedIP));
        serverSocket = callbackservice.create_Socket_stream(sipserver, sipport, pwd);
        coralappsConn = callbackservice.getCoralappsdbConnection();
        switchConn = callbackservice.getSwitchdbConnection();
        while (true) {
            block49: {
                if (!callbackservice.isSocketStreamConnected(serverSocket)) {
                    log.debug((Object)"socket not connected");
                    try {
                        serverSocket = callbackservice.create_Socket_stream(sipserver, sipport, pwd);
                        if (serverSocket == null) {
                            log.debug((Object)"socket still not connected waiting to conneceted");
                        } else if (serverSocket.isConnected()) {
                            log.debug((Object)"socket now connected waiting to conneceted");
                        } else {
                            log.debug((Object)"socket still not connected waiting to conneceted");
                        }
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"current thread InterruptedException");
                    }
                    catch (Exception e) {
                        log.error((Object)("exception at while isSocketstreamconnected( a)" + e.getMessage()));
                    }
                    continue;
                }
                while (!(switchdb = callbackservice.isDbConnected(switchConn)) || !(coralappsdb = callbackservice.isDbConnected(coralappsConn))) {
                    log.debug((Object)"database not connected");
                    try {
                        if (!switchdb) {
                            switchConn = callbackservice.getSwitchdbConnection();
                            if (switchConn == null) {
                                log.debug((Object)"switch database still not connected ... Trying to connected");
                            } else {
                                log.debug((Object)"switch database connected ... waiting to connected");
                            }
                        }
                        if (!coralappsdb) {
                            coralappsConn = callbackservice.getCoralappsdbConnection();
                            if (coralappsConn == null) {
                                log.debug((Object)"coralapps database still not connected ... Trying to connected");
                            } else {
                                log.debug((Object)"coralapps database connected ... waiting to connected");
                            }
                        }
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("current thread InterruptedException :" + e.getMessage()));
                    }
                    catch (Exception e) {
                        log.error((Object)("exception at while switchdb() :" + e.getMessage()));
                    }
                }
                if (!isSystemConfigFetch) {
                    if (!callbackservice.systemConfig(switchConn)) {
                        log.debug((Object)"system config read error");
                        return;
                    }
                    log.debug((Object)("SystemConfig getparam maxtry:" + Integer.toString(maxtry_callback) + " noofoldday_callback:" + Integer.toString(noofoldday_callback)));
                    isSystemConfigFetch = true;
                }
                try {
                    try {
                        boolean isSameRLUCall = false;
                        String callerrlucode = "";
                        String fromuser = "";
                        String touser = "";
                        String _rluip = "";
                        int callbackid = 0;
                        isfromuserActive = false;
                        istoUserActive = false;
                        int __nooftry = 0;
                        rlucode = "";
                        callbackdummynumber = "";
                        qry = "select id,fromuser,touser,nooftry,callbackdummynumber from pbx.t_callback where expired = false and waitforactivity = false and coalesce(fromuser,'')<>'' and coalesce(touser,'')<>'' and createdon::date > (now() - interval '" + Integer.toString(noofoldday_callback) + " day')::date";
                        query = switchConn.prepareStatement(qry);
                        rs = query.executeQuery();
                        while (rs.next()) {
                            fromuser = rs.getString("fromuser") != null ? rs.getString("fromuser") : "";
                            touser = rs.getString("touser") != null ? rs.getString("touser") : "";
                            callbackid = rs.getInt("id");
                            __nooftry = rs.getInt("nooftry");
                            if (__nooftry >= maxtry_callback && callbackservice.checkmaxtryCallBack(switchConn, callbackid)) {
                                log.debug((Object)("skip callbackcall for fromuser:" + fromuser + " touser:" + touser + " callbackid:" + Integer.toString(callbackid) + " due to maxtry attempted"));
                                break;
                            }
                            log.debug((Object)("initiate callback for fromuser:" + fromuser + " touser:" + touser + " callbackid:" + Integer.toString(callbackid)));
                            callerrlucode = callbackservice.getRluCode(switchConn, fromuser);
                            rlucode = callbackservice.getRluCode(switchConn, touser);
                            callbackdummynumber = rs.getString("callbackdummynumber") != null ? rs.getString("callbackdummynumber") : "";
                            log.debug((Object)("touser:" + touser + " rlucode:" + rlucode));
                            String[] rluinfo = callbackservice.checkRluInfo(switchConn, fromuser, rlucode, serverCode).split(",", -1);
                            log.debug((Object)("Fromuser:" + fromuser + " ,rlunodeip:" + rluinfo[0] + ",rlucode:" + rluinfo[1]));
                            _rluip = rluinfo[0];
                            if (!_rluip.isEmpty()) {
                                log.debug((Object)("Fromuser:" + fromuser + " defind on rluserver:" + _rluip));
                                log.debug((Object)("Fromuser:" + fromuser + " trying to connect custom connection from:" + _rluip));
                                customConnection = callbackservice.getRluConnection(callbackservice.getManagementIp(_rluip, ipport));
                                if (customConnection != null) {
                                    isfromuserActive = callbackservice.isactive(customConnection, fromuser);
                                    istoUserActive = callbackservice.isactive(switchConn, touser);
                                } else {
                                    log.debug((Object)("Fromuser:" + fromuser + " failed to make custom connection from:" + _rluip));
                                    log.debug((Object)"Callback can not be apply for failed remote rlu connection");
                                    isfromuserActive = true;
                                }
                                callbackservice.closeConnection(customConnection);
                            } else {
                                isSameRLUCall = true;
                                log.debug((Object)("Fromuser:" + fromuser + " defind on currentserver"));
                                isfromuserActive = callbackservice.isactive(switchConn, fromuser);
                                istoUserActive = callbackservice.isactive(switchConn, touser);
                            }
                            if (!isfromuserActive && !istoUserActive) {
                                log.debug((Object)("preparing callbackcall fromuser:" + fromuser + " touser:" + touser));
                                callbackservice.updatetryattempt(switchConn, callbackid, ++__nooftry, fromuser, touser);
                                callbackservice.initiateCall(switchConn, fromuser, touser, callbackid, _rluip, rlucode, __nooftry, isSameRLUCall, callbackdummynumber);
                                continue;
                            }
                            log.debug((Object)("Failed to prepare callbackcall fromuser:" + fromuser + " touser:" + touser + " due to active any call either fromuser or touser"));
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("fetching callback data error:" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            break block49;
                        }
                        catch (Exception e2) {
                            log.error((Object)("fetching callback data error:" + e2.getMessage()));
                        }
                        break block49;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("fetching callback data error:" + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("fetching callback data error:" + e.getMessage()));
                }
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)("current thread InterruptedException :" + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Exception at while Dialoutrs.next () " + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private static boolean checkmaxtryCallBack(Connection switchconn, int cbid) {
        PreparedStatement query = null;
        String qry = "";
        boolean isupdate = false;
        try {
            try {
                qry = "delete from pbx.t_callback where id=?";
                query = switchconn.prepareStatement(qry);
                query.setInt(1, cbid);
                if (query.executeUpdate() > 0) {
                    isupdate = true;
                }
            }
            catch (SQLException e) {
                log.error((Object)("Exception in checkmaxtryCallBack error:" + e.getMessage()));
                try {
                    if (query != null) {
                        query.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)("Exception in checkmaxtryCallBack error:" + e2.getMessage()));
                }
            }
        }
        finally {
            try {
                if (query != null) {
                    query.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception in checkmaxtryCallBack error:" + e.getMessage()));
            }
        }
        return isupdate;
    }

    private static String getManagementIp(String virtualIp, String port) {
        String cmd = "w3m -dump http://" + virtualIp + ":" + port + "/dialplan | grep eth1|awk -F: '{print $2}'";
        String _ret = "";
        String str = "";
        String pstr = "";
        try {
            log.debug((Object)("ExecuteCommand:" + cmd));
            String[] finalcommand = callbackservice.readfullcommmand(cmd);
            log.debug((Object)("Final Command => " + finalcommand[0] + "  " + finalcommand[1] + "  " + finalcommand[2]));
            Process p = Runtime.getRuntime().exec(finalcommand);
            p.waitFor();
            BufferedReader outbuf = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((str = outbuf.readLine()) != null) {
                pstr = String.valueOf(pstr) + str;
            }
            _ret = pstr = pstr.trim();
            log.debug((Object)("ManagementIP:" + _ret + " for virtualip:" + virtualIp));
        }
        catch (IOException e) {
            log.error((Object)("exception in fetching managementip from command:" + cmd));
        }
        catch (Exception e) {
            log.error((Object)("exception in fetching managementip from command:" + cmd));
        }
        return _ret;
    }

    private static String[] readfullcommmand(String cmd) {
        String[] returnValue = new String[]{"/bin/bash", "-c", cmd};
        return returnValue;
    }

    private static Connection getRluConnection(String jdbcip) {
        Connection tempConn = null;
        if (!jdbcip.isEmpty()) {
            try {
                Class.forName("org.postgresql.Driver");
                try {
                    log.debug((Object)("preparing databaseconnection from ip:" + jdbcip));
                    tempConn = DriverManager.getConnection("jdbc:postgresql://" + jdbcip + ":5432/switch", jdbcUser, jdbcPassword);
                }
                catch (SQLException e) {
                    log.error((Object)("Exception at module getRluConnection from databaseConnection Error:" + e.getMessage()));
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Exception at module getRluConnection at Create DBClass Error:" + e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)("Exception at module getRluConnection at Create DBClass Error:" + e.getMessage()));
            }
        }
        return tempConn;
    }

    private static String checkcallbackcall(Connection _switchConn, Connection _coralconn, int callid, String callee, String caller) {
        int retry;
        boolean maxattemptreach;
        boolean iscbanswer;
        String rtrStr;
        block54: {
            boolean iscbattend;
            String qry;
            PreparedStatement query;
            block52: {
                query = null;
                ResultSet rs = null;
                qry = "";
                rtrStr = "";
                iscbanswer = false;
                iscbattend = false;
                maxattemptreach = false;
                int billsec = 0;
                retry = 0;
                String bleg_uuid = "";
                try {
                    try {
                        qry = "select billsec,bleg_uuid,nooftry from pbx.t_cdr where coral_dialid=? and coral_app='callbackcall' order by start_stamp desc limit 1";
                        query = _coralconn.prepareStatement(qry);
                        query.setInt(1, callid);
                        rs = query.executeQuery();
                        while (rs.next()) {
                            iscbattend = true;
                            billsec = rs.getInt("billsec");
                            bleg_uuid = rs.getString("bleg_uuid") != null ? rs.getString("bleg_uuid") : "";
                            retry = rs.getInt("nooftry");
                            if (!bleg_uuid.isEmpty() && billsec > 0) {
                                iscbanswer = true;
                            }
                            if (retry < maxtry_callback) continue;
                            log.debug((Object)("coraldial_id:" + Integer.toString(callid) + " reach to maximum attempt:" + Integer.toString(retry)));
                            maxattemptreach = true;
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("checking checkcallbackcall error:" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            break block52;
                        }
                        catch (Exception e2) {
                            log.error((Object)("checking checkcallbackcall error:" + e2.getMessage()));
                        }
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("checking checkcallbackcall error:" + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("checking checkcallbackcall error:" + e.getMessage()));
                }
            }
            if (iscbanswer) {
                try {
                    try {
                        qry = "delete from pbx.t_callback where id=?";
                        query = _switchConn.prepareStatement(qry);
                        query.setInt(1, callid);
                        if (query.executeUpdate() > 0) {
                            log.debug((Object)("deleted call back callbackcall for:" + callee + " from:" + caller + " calbackid=" + callid));
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            break block54;
                        }
                        catch (Exception e3) {
                            log.error((Object)("deleting checkcallbackcall error:" + e3.getMessage()));
                        }
                        break block54;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                }
            } else if (iscbattend) {
                try {
                    try {
                        if (query != null) {
                            query.close();
                        }
                        qry = "update pbx.t_callback set nooftry = ? where id=?";
                        query = _switchConn.prepareStatement(qry);
                        query.setInt(1, retry);
                        query.setInt(2, callid);
                        if (query.executeUpdate() > 0) {
                            log.debug((Object)("update call back callbackcall for:" + callee + " from:" + caller + " calbackid=" + callid + " to nooftry:" + Integer.toString(retry)));
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            break block54;
                        }
                        catch (Exception e4) {
                            log.error((Object)("deleting checkcallbackcall error:" + e4.getMessage()));
                        }
                        break block54;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("deleting checkcallbackcall error:" + e.getMessage()));
                }
            }
        }
        if (maxattemptreach) {
            iscbanswer = true;
        }
        rtrStr = String.valueOf(Boolean.toString(iscbanswer)) + "," + Integer.toString(retry);
        return rtrStr;
    }

    private static void initiateCall(Connection switchconn, String fromcaller, String tocallee, int cbid, String rluip, String _rlucode, int _nooftry, boolean sameServer, String dummyNumber) {
        String dialstring = "";
        String caller_parameters = "";
        if (rluip.isEmpty()) {
            String switchip = callbackservice.getswitchIPinfo();
            caller_parameters = "{ringback=\\'%(2000,4000,440.0,480.0)\\',origination_caller_id_name=CallBackCall,origination_caller_id_number=" + tocallee + ",ignore_early_media=true,originate_timeout=30,hangup_after_bridge=true,absolute_codec_string='PCMU,PCMA',coral_dialid=" + cbid + ",coral_app=callbackcall,nooftry=" + _nooftry + ",callbackuser=" + fromcaller + ",sip_h_X-coral_callbackcall=true,sip_h_X-coral_callbackid=" + cbid + ",sip_h_X-coral_fromuser=" + fromcaller + ",sip_h_X-coral_touser=" + tocallee + "}";
            if (!dummyNumber.isEmpty()) {
                caller_parameters = caller_parameters.replace(tocallee, dummyNumber);
            }
            if (_rlucode.isEmpty()) {
                _rlucode = "internal";
            }
            if (sameServer) {
                log.debug((Object)("Same Server CallBack initiate fromUser:" + fromcaller + ",touser:" + tocallee));
                dialstring = "originate " + caller_parameters + "user/" + fromcaller + " " + tocallee + " XML callback";
            } else {
                dialstring = "originate " + caller_parameters + "sofia/" + _rlucode + "/" + fromcaller + "@" + switchip + (callbackport != 0 ? ":" + Integer.toString(callbackport) : "") + " " + tocallee + " XML callback";
            }
        } else {
            caller_parameters = "{ringback=\\'%(2000,4000,440.0,480.0)\\',origination_caller_id_name=CallBackCall,origination_caller_id_number=" + tocallee + ",ignore_early_media=true,originate_timeout=30,hangup_after_bridge=true,absolute_codec_string='PCMU,PCMA',coral_dialid=" + cbid + ",coral_app=callbackcall,nooftry=" + _nooftry + ",callbackuser=" + fromcaller + ",sip_h_X-coral_callbackcall=true,sip_h_X-coral_callbackid=" + cbid + ",sip_h_X-coral_callbackrlu=" + _rlucode + ",sip_h_X-coral_fromuser=" + fromcaller + ",sip_h_X-coral_touser=" + tocallee + "}";
            if (!dummyNumber.isEmpty()) {
                caller_parameters = caller_parameters.replace(tocallee, dummyNumber);
            }
            log.debug((Object)("from calling rlu node:" + rluip + ",rlucode=" + _rlucode));
            if (_rlucode.isEmpty()) {
                _rlucode = "internal";
            }
            dialstring = "originate " + caller_parameters + "sofia/" + _rlucode + "/" + fromcaller + "@" + rluip + ":9090 " + tocallee + " XML callback";
        }
        if (!dialstring.isEmpty()) {
            callbackservice.makecall(serverSocket, dialstring);
        }
    }

    private static String getRluCode(Connection conn, String num) {
        String rlucode;
        block18: {
            PreparedStatement query = null;
            ResultSet gwData = null;
            rlucode = "";
            try {
                try {
                    String qry = "select rlucode from pbx.extensions where extension = ?";
                    query = conn.prepareStatement(qry);
                    query.setString(1, num);
                    gwData = query.executeQuery();
                    while (gwData.next()) {
                        String string = rlucode = gwData.getString("rlucode") != null ? gwData.getString("rlucode") : "";
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Exception procedure getCallerRluCode Error:-" + e.getMessage()));
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (gwData != null) {
                            gwData.close();
                        }
                        break block18;
                    }
                    catch (SQLException ex) {
                        log.error((Object)("Exception at getCallerRluCode for [Ext:" + num + "] " + ex.getMessage()));
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (gwData != null) {
                        gwData.close();
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)("Exception at getCallerRluCode for [Ext:" + num + "] " + ex.getMessage()));
                }
                throw throwable;
            }
            try {
                if (query != null) {
                    query.close();
                }
                if (gwData != null) {
                    gwData.close();
                }
            }
            catch (SQLException ex) {
                log.error((Object)("Exception at getCallerRluCode for [Ext:" + num + "] " + ex.getMessage()));
            }
        }
        return rlucode.trim();
    }

    private static String getCallerIDName(Connection conn, String num) {
        String name;
        block39: {
            String qry;
            ResultSet gwData;
            PreparedStatement query;
            block37: {
                name = "";
                query = null;
                gwData = null;
                try {
                    try {
                        qry = "select name,phone from pbx.m_vipmaster where officeext = ? and coalesce(name,'')<> '' and coalesce(phone,'0') <> '0' and coalesce(phone,'') <> '' order by phone desc,id desc limit 1";
                        query = conn.prepareStatement(qry);
                        query.setString(1, num);
                        gwData = query.executeQuery();
                        while (gwData.next()) {
                            String string = name = gwData.getString("name") != null ? gwData.getString("name") : "";
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("Exception procedure getCallerIDName Error:-" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            if (gwData != null) {
                                gwData.close();
                            }
                            break block37;
                        }
                        catch (SQLException ex) {
                            log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (gwData != null) {
                            gwData.close();
                        }
                    }
                    catch (SQLException ex) {
                        log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (gwData != null) {
                        gwData.close();
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                }
            }
            if (name.isEmpty()) {
                try {
                    try {
                        qry = "select name from pbx.extensions where extension = ?";
                        query = conn.prepareStatement(qry);
                        query.setString(1, num);
                        gwData = query.executeQuery();
                        while (gwData.next()) {
                            String string = name = gwData.getString("name") != null ? gwData.getString("name") : "";
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("Exception procedure getCallerIDName Error:-" + e.getMessage()));
                        try {
                            if (query != null) {
                                query.close();
                            }
                            if (gwData != null) {
                                gwData.close();
                            }
                            break block39;
                        }
                        catch (SQLException ex) {
                            log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (gwData != null) {
                            gwData.close();
                        }
                    }
                    catch (SQLException ex) {
                        log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (gwData != null) {
                        gwData.close();
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)("Exception at getCallerIDName for [Ext:" + num + "] " + ex.getMessage()));
                }
            }
        }
        if (name.isEmpty()) {
            name = num;
        }
        return name;
    }

    private static String checkRluInfo(Connection _conn, String fromExt, String torlucode, String _servercode) {
        String rtrstr;
        String ipaddress;
        block20: {
            PreparedStatement query = null;
            ResultSet rs = null;
            String qry = "";
            String _tmpvirtuelip = "";
            String _tmpipaddress = "";
            ipaddress = "";
            String currentstatus = "";
            String failovergateway = "";
            rtrstr = "";
            String _rlucode = "";
            boolean rlustatus = false;
            try {
                try {
                    qry = "select a.rlucode,c.rlustatus,c.currentstatus,c.ctrlwithcurrentserver,b.failovergateway,extension_type,c.virtualip vertualip,c.ipaddress from pbx.extensions a left join pbx.m_rlufailovergateway b on upper(coalesce(a.rlucode,'x')) = upper(coalesce(b.rlucode,'y')) and coalesce(b.rlucode,'') <> '' and servercode=? left join pbx.m_control_rluserver c on upper(coalesce(a.rlucode,'x')) = upper(coalesce(c.rlucode,'y')) and coalesce(c.rlucode,'') <> '' where extension=? limit 1";
                    query = _conn.prepareStatement(qry);
                    query.setString(1, _servercode);
                    query.setString(2, fromExt);
                    rs = query.executeQuery();
                    while (rs.next()) {
                        _tmpvirtuelip = rs.getString("vertualip") != null ? rs.getString("vertualip") : "";
                        _tmpipaddress = rs.getString("ipaddress") != null ? rs.getString("ipaddress") : "";
                        currentstatus = rs.getString("currentstatus") != null ? rs.getString("currentstatus") : "";
                        rlustatus = rs.getBoolean("rlustatus");
                        String string = _rlucode = rs.getString("rlucode") != null ? rs.getString("rlucode") : "";
                        if (!(torlucode.equalsIgnoreCase(_rlucode) || torlucode.isEmpty() || _rlucode.isEmpty() || _tmpvirtuelip.isEmpty() || callbackservice.isIpOnServer(_tmpvirtuelip, _tmpipaddress))) {
                            ipaddress = _tmpvirtuelip.isEmpty() ? _tmpipaddress : _tmpvirtuelip;
                        } else {
                            _rlucode = "";
                        }
                        if ((!currentstatus.equalsIgnoreCase("backup") || rlustatus) && !currentstatus.equalsIgnoreCase("fault")) continue;
                        String string2 = failovergateway = rs.getString("failovergateway") != null ? rs.getString("failovergateway") : "";
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Exception in getting checkRluInfo for number:" + fromExt + " " + e.getMessage()));
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        break block20;
                    }
                    catch (Exception e2) {
                        log.error((Object)("Exception in getting checkRluInfo for number:" + fromExt + " " + e2.getMessage()));
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception in getting checkRluInfo for number:" + fromExt + " " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                if (query != null) {
                    query.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception in getting checkRluInfo for number:" + fromExt + " " + e.getMessage()));
            }
        }
        rtrstr = String.valueOf(ipaddress) + "," + torlucode.trim();
        return rtrstr;
    }

    private static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in closing connection  :" + e.getMessage()));
        }
    }

    private static String getAttachedIpInfo() {
        String line = "";
        String output = "";
        try {
            String[] Ipstr = new String[]{"/bin/sh", "-c", "ip -o -4 addr list  | grep global |awk '{print $2\":\" $4}' | cut -d/ -f1"};
            Process ls = Runtime.getRuntime().exec(Ipstr);
            ls.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(ls.getInputStream()));
            while ((line = buf.readLine()) != null) {
                output = output.isEmpty() ? line : String.valueOf(output) + "," + line;
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception to fetch getAttachedIpInfo():" + e.getMessage()));
        }
        return output;
    }

    private static boolean isIpOnServer(String virtualip, String ipaddress) {
        boolean isFound = false;
        log.debug((Object)("isIpOnServer get virtualip:" + virtualip + ",ipaddress:" + ipaddress + ",CurrentServer AttachedIP:" + attachedIP));
        try {
            if (!virtualip.isEmpty() && !attachedIP.isEmpty() && attachedIP.contains(virtualip)) {
                isFound = true;
                log.debug((Object)("Found attachIP for nodeip:" + virtualip + ", with attachIP:" + attachedIP));
            }
            log.debug((Object)("isIpOnServer get virtualip:" + virtualip + ",attachedIP:" + attachedIP + " not matched........"));
            if (!ipaddress.isEmpty() && !isFound && !attachedIP.isEmpty() && attachedIP.contains(ipaddress)) {
                isFound = true;
                log.debug((Object)("Found attachIP for ipaddress:" + ipaddress + ", with attachIP:" + attachedIP));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in isIpOnServer Error:" + e));
        }
        return isFound;
    }

    private static boolean isactive(Connection conn, String ext) {
        PreparedStatement query = null;
        ResultSet rs = null;
        String qry = "";
        boolean isfound = false;
        try {
            try {
                qry = "select count(*) cnt from basic_calls where (cid_num=? or b_dest=? or dest=?)";
                query = conn.prepareStatement(qry);
                query.setString(1, ext);
                query.setString(2, ext);
                query.setString(3, ext);
                rs = query.executeQuery();
                while (rs.next()) {
                    boolean bl = isfound = rs.getInt("cnt") > 0;
                }
            }
            catch (SQLException e) {
                log.error((Object)("checking isactive user for Extension:" + ext + " error:" + e.getMessage()));
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)("checking isactive user for Extension:" + ext + " error:" + e2.getMessage()));
                }
            }
        }
        finally {
            try {
                if (query != null) {
                    query.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("checking isactive user for Extension:" + ext + " error:" + e.getMessage()));
            }
        }
        return isfound;
    }

    private static boolean systemConfig(Connection conn) {
        boolean issuccess;
        block20: {
            issuccess = false;
            String qry = "";
            PreparedStatement query = null;
            ResultSet userData = null;
            try {
                try {
                    qry = "select maxtry_callback,noofoldday_callback from pbx.m_systemconfigs";
                    query = conn.prepareStatement(qry);
                    userData = query.executeQuery();
                    while (userData.next()) {
                        maxtry_callback = userData.getInt("maxtry_callback");
                        noofoldday_callback = userData.getInt("noofoldday_callback");
                        issuccess = true;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception at systemConfig Error: " + e.getMessage()));
                    try {
                        if (query != null) {
                            query.close();
                        }
                        if (userData != null) {
                            userData.close();
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        log.error((Object)("Exception at systemConfig Error: " + ex.getMessage()));
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (userData != null) {
                        userData.close();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Exception at systemConfig Error: " + ex.getMessage()));
                }
                throw throwable;
            }
            try {
                if (query != null) {
                    query.close();
                }
                if (userData != null) {
                    userData.close();
                }
            }
            catch (Exception ex) {
                log.error((Object)("Exception at systemConfig Error: " + ex.getMessage()));
            }
        }
        if (maxtry_callback == 0) {
            maxtry_callback = 1;
        }
        if (noofoldday_callback == 0) {
            noofoldday_callback = 1;
        }
        return issuccess;
    }

    private static void updatetryattempt(Connection _coralconn, int callid, int retry, String caller, String callee) {
        PreparedStatement query = null;
        String qry = "";
        try {
            try {
                qry = "update pbx.t_callback set nooftry = ? where id=?";
                query = _coralconn.prepareStatement(qry);
                query.setInt(1, retry);
                query.setInt(2, callid);
                if (query.executeUpdate() > 0) {
                    log.debug((Object)("update call back callbackcall for:" + callee + " from:" + caller + " calbackid=" + callid + " to nooftry:" + Integer.toString(retry)));
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception at updatetryattempt Error: " + e.getMessage()));
                try {
                    if (query != null) {
                        query.close();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Exception at updatetryattempt Error: " + ex.getMessage()));
                }
            }
        }
        finally {
            try {
                if (query != null) {
                    query.close();
                }
            }
            catch (Exception ex) {
                log.error((Object)("Exception at updatetryattempt Error: " + ex.getMessage()));
            }
        }
    }

    private static String getswitchIPinfo() {
        String rtrval = "";
        String str = "";
        String pstr = "";
        String cmd = "global_getvar local_ip_v4";
        try {
            String[] cmd1 = new String[]{"fs_cli", "-x", cmd};
            Process p = Runtime.getRuntime().exec(cmd1);
            p.waitFor();
            BufferedReader outbuf = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((str = outbuf.readLine()) != null) {
                pstr = String.valueOf(pstr) + str;
            }
            rtrval = pstr;
        }
        catch (IOException e) {
            log.error((Object)("IOException at getswitchIPinfo() :" + e.getMessage()));
        }
        catch (InterruptedException e) {
            log.error((Object)("InterruptedException at getswitchIpinfo() :" + e.getMessage()));
        }
        return rtrval;
    }
}

