/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.security;

import com.coraltele.security.APIUserPrincipal;
import com.coraltele.security.ApiKeyAuthenticationToken;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class ApiKeyAuthenticationFilter
implements Filter {
    public static String authMethod;
    public static String authKey;
    public static Boolean secureAPI;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String apiKey;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && (apiKey = this.getApiKey((HttpServletRequest)request)) != null) {
            if (apiKey.equals(authKey) && !authKey.isEmpty() || !secureAPI.booleanValue()) {
                ApiKeyAuthenticationToken apiToken = new ApiKeyAuthenticationToken(apiKey, (Collection)AuthorityUtils.NO_AUTHORITIES);
                SecurityContextHolder.getContext().setAuthentication((Authentication)apiToken);
                UserDetails userDetails = this.loadUserByUsername((HttpServletRequest)request);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                APIUserPrincipal userInfo = (APIUserPrincipal)userDetails;
                if (userInfo.getUsername().isEmpty() || userInfo.getAgentNumber().isEmpty() || userInfo.getAgentIP().isEmpty() && userInfo.getWorkstationID().isEmpty()) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setStatus(401);
                    httpResponse.getWriter().write("Invalid Agent Details");
                    return;
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            } else {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(401);
                httpResponse.getWriter().write("Invalid API Key");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private String getApiKey(HttpServletRequest httpRequest) {
        String apiKey = null;
        String authHeader = httpRequest.getHeader("Authorization");
        if (authHeader != null && (authHeader = authHeader.trim()).toLowerCase().startsWith(authMethod + " ")) {
            apiKey = authHeader.substring(authMethod.length()).trim();
        }
        return apiKey;
    }

    public UserDetails loadUserByUsername(HttpServletRequest httpRequest) {
        return new APIUserPrincipal(httpRequest.getHeader("agentID"), httpRequest.getHeader("agentName"), httpRequest.getHeader("agentIP"), httpRequest.getHeader("agentNumber"), httpRequest.getHeader("componentID"));
    }
}

