/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restclient;

import com.coraltele.security.ApiKeyAuthenticationFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    Environment env;

    protected void configure(HttpSecurity http) throws Exception {
        String apiSecured = this.env.getProperty("apiSecured", "true");
        ApiKeyAuthenticationFilter.authMethod = "api-key";
        ApiKeyAuthenticationFilter.secureAPI = !apiSecured.equals("false");
        ApiKeyAuthenticationFilter.authKey = ApiKeyAuthenticationFilter.secureAPI != false ? this.env.getProperty("apiKey", "") : "no-key";
        http.headers().httpStrictTransportSecurity().includeSubDomains(true).maxAgeInSeconds(31536000L).and().contentSecurityPolicy("script-src 'self' https://pbx.coraltele.com; object-src https://pbx.coraltele.com; report-uri /csp-report-endpoint/").reportOnly().and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.SAME_ORIGIN).and().contentTypeOptions().and().frameOptions().sameOrigin();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/api/**").cors().and()).csrf().disable()).addFilterBefore((Filter)new ApiKeyAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().anyRequest()).fullyAuthenticated();
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/api/**", new CorsConfiguration().applyPermitDefaultValues());
        return source;
    }
}

