/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.systems.api;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.oc.api.ConferenceMember;
import com.coraltele.oc.api.ReadXMLFile;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.systems.api.ConferenceDetails;
import com.coraltele.restapi.systems.api.FilterList;
import com.coraltele.restapi.systems.api.MessagePublisher;
import com.coraltele.restapi.systems.api.RecordingInfo;
import com.coraltele.restapi.systems.api.SystemController;
import com.coraltele.restapi.systems.api.ValidateAppUserResponse;
import com.coraltele.restapi.systems.api.commandDialer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/system"})
public class SystemController {
    private static final Logger logger = Logger.getLogger(SystemController.class);
    private static final String sbcFilePath = "/etc/coraltelecom/sbc.default";
    private static final String CallServerFilePath = "/etc/coraltele/conf/app.config";
    private commandDialer objCommandDialer = new commandDialer();
    private static String __activeMQType = "SIPREC.Record";
    private static String __activeMQServer = "tcp://192.168.20.9:9890";
    private static long __messageexpirytime = 0L;
    private static final Pattern LINE_SEP_PATTERN = Pattern.compile("\\R");
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest request;
    @Autowired
    @Qualifier(value="dataSourceKamailio")
    private DataSource dsKamailio;
    @Autowired
    @Qualifier(value="dataSourceBilling")
    private DataSource dsBilling;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dsUsers")
    private DataSource dsUsers;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SystemController() {
        SystemController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private void updateConfigurationFile(String _filepath, String propertyName, String newPropertyValue) {
        try {
            if (!propertyName.isEmpty() && !_filepath.isEmpty()) {
                Properties prop = new Properties();
                FileOutputStream output = null;
                FileInputStream in = new FileInputStream(_filepath);
                prop.load(in);
                in.close();
                output = new FileOutputStream(_filepath);
                prop.setProperty(propertyName, newPropertyValue);
                prop.store(output, null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updateConfigurationFile. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void findAndReplace(String _filepath, String oldString, String newString) {
        try {
            if (!oldString.isEmpty() && !_filepath.isEmpty()) {
                Path path = Paths.get(_filepath, new String[0]);
                Stream<String> lines = Files.lines(path);
                List replaced = lines.map(line -> line.replaceAll(oldString, newString)).collect(Collectors.toList());
                Files.write(path, replaced, new OpenOption[0]);
                lines.close();
            }
        }
        catch (IOException ex) {
            logger.error((Object)("Error in findAndReplace. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in findAndReplace. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    @GetMapping(path={"/verifysipserver"}, produces={"application/json"})
    public ResponseEntity<String> verifySipServer(HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Verify Sip Server";
        logger.info((Object)responseMessage);
        try {
            this.findAndReplace("/etc/coraltelecom/sbc.default", "callserver=-A WITH_SBCDIALPLAN", "callserver=-A WITH_SIPSERVER");
            this.findAndReplace("/etc/coraltele/conf/app.config", "tunnelport=5057", "tunnelport=5058");
            this.findAndReplace("/etc/coraltele/conf/app.config", "tunnelport=5059", "tunnelport=5058");
            this.executecommand("systemctl restart sbc.service");
            this.executecommand("service callserver restart");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Sip Server OK");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in verify Sip Server. Error -> " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)ex.getMessage());
        }
    }

    @GetMapping(path={"/verifysbc"}, produces={"application/json"})
    public ResponseEntity<String> verifySBC(HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Verify Sip Server";
        logger.info((Object)responseMessage);
        try {
            this.findAndReplace("/etc/coraltelecom/sbc.default", "callserver=-A WITH_SIPSERVER", "callserver=-A WITH_SBCDIALPLAN");
            this.findAndReplace("/etc/coraltele/conf/app.config", "tunnelport=5057", "tunnelport=5059");
            this.findAndReplace("/etc/coraltele/conf/app.config", "tunnelport=5058", "tunnelport=5059");
            this.executecommand("systemctl restart sbc.service");
            this.executecommand("service callserver restart");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"SBC Server OK");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in verify Sip Server. Error -> " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)ex.getMessage());
        }
    }

    public int executecommand(String command) {
        int _ret = 1;
        try {
            Object[] finalcommand = SystemController.readfullcommmandbash((String)command);
            logger.info((Object)("cmd : " + Arrays.toString(finalcommand)));
            Process p = Runtime.getRuntime().exec((String[])finalcommand);
            p.waitFor();
            _ret = 0;
        }
        catch (InterruptedException ie) {
            logger.error((Object)("Error in executecommand(); Error" + ie.getMessage()));
        }
        catch (Exception ii) {
            logger.error((Object)("Error in executecommand(); Error" + ii.getMessage()));
        }
        return _ret;
    }

    public static String[] readfullcommmandbash(String cmd) {
        String[] cmd1 = new String[]{"/bin/bash", "-c", cmd};
        return cmd1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(path={"/generatetoken"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> generateToken(@RequestParam(value="userName") String userName, @RequestParam(defaultValue="") String authKey) {
        logger.info((Object)("Request for generating JWT token authKey & userName : " + authKey + ", " + userName));
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        String sql = "";
        int jwtExpiryInSeconds = 30;
        int userId = 0;
        Connection conn = null;
        int roleId = 0;
        try {
            if (userName.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)("Request come for generatetoken from server : " + this.getClientIpAddress(this.request)));
            if (!this.getClientIpAddress(this.request).equalsIgnoreCase("127.0.0.1") && !this.getClientIpAddress(this.request).equalsIgnoreCase("localhost")) {
                logger.error((Object)"Request from local server is allowed only");
                objCommonResponse = new CommonResponseObject(1, "Request from local server is allowed only", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (authKey.isEmpty()) {
                logger.info((Object)"No authKey Provided. Will genearte at server side");
                authKey = UUID.randomUUID().toString() + "-jWT-" + UUID.randomUUID().toString();
                logger.info((Object)("Request for generating JWT token authKey : " + authKey));
            }
            try {
                CoralMeetSystemConfig meetconfig = this.meetConfig;
                if (meetconfig != null) {
                    jwtExpiryInSeconds = meetconfig.getJwtExpiryInSeconds();
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting jwt expiry. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                sql = "WITH a as(select id from m_user where lower(username) = lower(?))INSERT into m_user(username, description,enabled,createdby)SELECT ?,?,?,? WHERE NOT EXISTS (SELECT id FROM a);";
                db.update(sql, new Object[]{userName.toLowerCase(), userName, userName.toUpperCase(), 1, "SystemUser"});
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating new user. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            try {
                sql = "select id from m_user where username = ?";
                try {
                    userId = (Integer)db.query(sql, new Object[]{userName}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in fetching user details. Error -> " + ex.getMessage()), (Throwable)ex);
                    objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating new user. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            String systemUserRole = SystemController.getSystemUserRoles((String)userName);
            if (!systemUserRole.isEmpty()) {
                logger.info((Object)("System Roles : " + systemUserRole));
                String[] systemUserRoles = systemUserRole.split("\\s+");
                if (systemUserRoles.length > 0) {
                    for (String role : systemUserRoles) {
                        if (role.isEmpty()) continue;
                        try {
                            conn = db.getDataSource().getConnection();
                            sql = "WITH a as(select id from m_role where lower(shortcode) = lower(?))\r\nINSERT into m_role(shortcode, description,enabled)SELECT ?, ?,? WHERE NOT EXISTS (SELECT id FROM a)RETURNING id ;";
                            PreparedStatement prpState = conn.prepareStatement(sql);
                            prpState.setString(1, role.toLowerCase());
                            prpState.setString(2, role);
                            prpState.setString(3, role.toUpperCase());
                            prpState.setInt(4, 1);
                            ResultSet rs = prpState.executeQuery();
                            if (rs.next()) {
                                roleId = rs.getInt(1);
                            }
                            if (roleId <= 0 || userId <= 0) continue;
                            sql = "insert into m_userrole(\"user\",role) select ?,?";
                            db.update(sql, new Object[]{userId, roleId});
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in creating new code. Error -> " + ex.getMessage()), (Throwable)ex);
                            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                            ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            return responseEntity;
                        }
                        finally {
                            if (conn != null) {
                                conn.close();
                            }
                        }
                    }
                }
            }
            try {
                sql = "insert into m_user_token(createdby,username,jwtauthkey,jwttokengeneratedtime,jwttokenvalidtill) Values('API',?,?,extract(epoch from now()::timestamp(0) with time zone),(extract(epoch from now()::timestamp(0) with time zone) + ?))";
                db.update(sql, new Object[]{userName, authKey, jwtExpiryInSeconds});
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)("authKey genearted for userName : " + userName + ", " + authKey));
            objCommonResponse = new CommonResponseObject(0, "AuthKey generated", authKey);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    private static String getSystemUserRoles(String userName) {
        String _ret = "";
        try {
            String str = "";
            String pstr = "";
            String cmd = "";
            try {
                cmd = "groups " + userName + " | awk -F: '{print $2}'";
                String[] finalcommand = SystemController.readfullcommmand((String)cmd);
                logger.info((Object)(finalcommand[0] + " | " + finalcommand[1] + " | " + finalcommand[2]));
                Process p = Runtime.getRuntime().exec(finalcommand);
                p.waitFor();
                BufferedReader outbuf = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((str = outbuf.readLine()) != null) {
                    pstr = pstr + str;
                }
                _ret = pstr = pstr.trim();
                logger.info((Object)("getSystemUserRoles : " + _ret));
            }
            catch (IOException ex) {
                logger.error((Object)("Error in getSystemUserRoles : " + ex.getMessage()), (Throwable)ex);
            }
            catch (InterruptedException ex) {
                logger.error((Object)("Error in getSystemUserRoles : " + ex.getMessage()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getSystemUserRoles : " + ex.getMessage()), (Throwable)ex);
        }
        return _ret;
    }

    private static String[] readfullcommmand(String cmd) {
        String[] returnValue = new String[]{"/bin/bash", "-c", cmd};
        return returnValue;
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    @PostMapping(path={"/validateappuser"}, produces={"application/json"})
    public ResponseEntity<ValidateAppUserResponse> validateAppUser(@RequestParam(value="user") String userName, @RequestParam(value="password") String password, @RequestParam(defaultValue="") String token) {
        logger.info((Object)("Request for validating app user,token : " + userName + ", " + token));
        ValidateAppUserResponse objCommonResponse = new ValidateAppUserResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        String sql = "";
        String userPassword = "";
        String appNMSURL = "";
        String appCMSURL = "";
        String appIMSURL = "";
        String appEPCURL = "";
        String appMGWURL = "";
        try {
            if (userName.isEmpty() || password.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new ValidateAppUserResponse(0, null, null, null, null, null, null, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
            }
            sql = "select password from m_user where username = ? and coalesce(password,'') <> ''";
            try {
                userPassword = (String)db.query(sql, new Object[]{userName}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in fetching user details. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new ValidateAppUserResponse(0, null, null, null, null, null, null, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
            }
            if (userPassword.isEmpty()) {
                logger.info((Object)"Invalid Username : ");
                objCommonResponse = new ValidateAppUserResponse(0, null, null, null, null, null, null, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
            }
            try {
                CoralMeetSystemConfig meetconfig = this.meetConfig;
                if (meetconfig != null) {
                    appNMSURL = meetconfig.getAppnmsurl();
                    appCMSURL = meetconfig.getAppcmsurl();
                    appIMSURL = meetconfig.getAppimsurl();
                    appEPCURL = meetconfig.getAppepcurl();
                    appMGWURL = meetconfig.getAppmgwurl();
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting jwt expiry. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            if (passwordEncoder.matches((CharSequence)password, userPassword)) {
                logger.info((Object)"Valid Username : ");
                try {
                    if (!token.isEmpty()) {
                        sql = "update m_user set jwtauthkey = ?,jwttokengeneratedtime = extract(epoch from now()::timestamp(0) with time zone) where username = lower(?); ";
                        db.update(sql, new Object[]{token, userName});
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                objCommonResponse = new ValidateAppUserResponse(1, userName, UUID.randomUUID().toString(), appNMSURL, appCMSURL, appIMSURL, appEPCURL, appMGWURL);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)"Invalid Password : ");
            objCommonResponse = new ValidateAppUserResponse(0, null, null, null, null, null, null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ValidateAppUserResponse(1, ex.getMessage(), null, null, null, null, null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updatetoken"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> updateToken(@RequestParam(value="user") String userName, @RequestParam(value="token") String token) {
        logger.info((Object)("Request for validating app user,token : " + userName + ", " + token));
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        String sql = "";
        try {
            if (userName.isEmpty() || token.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
            }
            try {
                sql = "update m_user set jwtauthkey = ?,jwttokengeneratedtime = extract(epoch from now()::timestamp(0) with time zone) where username = lower(?); ";
                db.update(sql, new Object[]{token, userName});
            }
            catch (Exception ex) {
                logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
            }
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/buildcallcenterdata"}, produces={"application/json"})
    public ResponseEntity<String> buildCallcenterData(HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        logger.info((Object)"Request for buildcallcenterdata");
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        JdbcTemplate dbUsers = new JdbcTemplate(this.dsUsers);
        String command = "";
        String sql = "";
        String defaultqueue = "";
        List allAgentData = null;
        boolean isondemand = false;
        String mappedextension = "";
        String agentid = "";
        String extension = "";
        String agentName = "";
        int maxnoanswer = 0;
        int wrapuptime = 0;
        int rejectdelaytime = 0;
        int busydelaytime = 0;
        int noanswerdelaytime = 0;
        int calltimeout = 0;
        boolean autoans = false;
        boolean do_not_disturb = false;
        try {
            sql = "select distinct a.username,coalesce(a.description,'') description,\r\ncoalesce(a.contactno,'') contactno,coalesce(a.isondemand,false) isondemand,a.maxnoanswer,a.wrapuptime,a.rejectdelaytime,a.busydelaytime,\r\na.noanswerdelaytime,a.calltimeout,coalesce(a.autoans,false)autoans,coalesce(a.do_not_disturb,false)do_not_disturb\r\nfrom m_user a\r\ninner join m_userrole b on a.id = b.user\r\ninner join m_role c on b.role = c.id\r\nwhere coalesce(c.shortcode,'') = 'ROLE_AGENT' and coalesce(a.username,'') <> ''";
            allAgentData = dbUsers.queryForList(sql);
            for (Map users : allAgentData) {
                try {
                    agentid = users.get("username").toString();
                    agentName = users.get("description").toString();
                    extension = users.get("contactno").toString();
                    isondemand = Boolean.parseBoolean(users.get("isondemand").toString());
                    maxnoanswer = Integer.parseInt(users.get("maxnoanswer").toString());
                    wrapuptime = Integer.parseInt(users.get("wrapuptime").toString());
                    rejectdelaytime = Integer.parseInt(users.get("rejectdelaytime").toString());
                    busydelaytime = Integer.parseInt(users.get("busydelaytime").toString());
                    noanswerdelaytime = Integer.parseInt(users.get("noanswerdelaytime").toString());
                    calltimeout = Integer.parseInt(users.get("calltimeout").toString());
                    autoans = Boolean.parseBoolean(users.get("autoans").toString());
                    do_not_disturb = Boolean.parseBoolean(users.get("do_not_disturb").toString());
                    if (agentid.isEmpty()) continue;
                    extension = extension.isEmpty() ? "999999999" : extension;
                    sql = "select coalesce(agentqueue,'') agentqueue from pbx.m_agentqueue where agent = ?";
                    defaultqueue = (String)db.query(sql, new Object[]{mappedextension}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    command = "fs_cli -x \"callcenter_config agent set status '" + agentid + "' 'Logged Out'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"user create " + agentid + "\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"user update " + agentid + " roleagent add " + extension + "\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent create " + agentid + "\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " maxnoanswer '" + maxnoanswer + "'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " wraptime '" + wrapuptime + "'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " rejectdelaytime '" + rejectdelaytime + "'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " busydelaytime '" + busydelaytime + "'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " noanswerdelaytime '" + noanswerdelaytime + "'\"";
                    this.objCommandDialer.executecommand(command);
                    Thread.sleep(100L);
                    if (!defaultqueue.isEmpty()) {
                        sql = "delete from tiers where queue = ?";
                        dbCoralApps.update(sql, new Object[]{defaultqueue});
                        sql = "delete from tiers where agent = ? and queue::int > 1000";
                        dbCoralApps.update(sql, new Object[]{agentid});
                    }
                    Thread.sleep(100L);
                    command = "fs_cli -x \"callcenter_config tier add " + defaultqueue + " " + agentid + " 1 1\"";
                    this.objCommandDialer.executecommand(command);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " addqueue " + defaultqueue + " level 1 position 1\"";
                    this.objCommandDialer.executecommand(command);
                    CoralMeetSystemConfig meetconfig = this.meetConfig;
                    if (meetconfig != null) {
                        command = Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? "fs_cli -x \"callcenter_config agent set contact '" + agentid + "' '[call_timeout=" + calltimeout + "]sofia/internal/" + extension + "@" + meetconfig.getSbcip() + "'\"" : "fs_cli -x \"callcenter_config agent set contact '" + agentid + "' '[call_timeout=" + calltimeout + "]user/" + extension + "'\"";
                        logger.info((Object)("agent contact update command : " + command));
                    } else {
                        command = "fs_cli -x \"callcenter_config agent set contact '" + agentid + "' '[call_timeout=" + calltimeout + "]user/" + extension + "'\"";
                    }
                    this.objCommandDialer.executecommand(command);
                    try {
                        sql = "WITH updatestatus AS ( UPDATE users.m_users SET extension = ?, firstname = ?, isondemand = ?";
                        sql = sql + " WHERE loginid = ? RETURNING * ) INSERT INTO users.m_users (loginid,extension,firstname,isondemand, maxnoanswer, wrapuptime, rejectdelaytime,\r\n\tbusydelaytime, noanswerdelaytime, calltimeout, autoans, do_not_disturb)  SELECT ?,?,?,?,?,?,?,?,?,?,?,? WHERE NOT EXISTS (SELECT * FROM updatestatus)";
                        logger.info((Object)("Query : " + sql));
                        dbCoralApps.update(sql, new Object[]{Integer.parseInt(extension), agentName, isondemand, agentid, agentid, Integer.parseInt(extension), agentName, isondemand, maxnoanswer, wrapuptime, rejectdelaytime, busydelaytime, noanswerdelaytime, calltimeout, autoans, do_not_disturb});
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in updating extension in users.m_users. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in buildcallcenterdata Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Done");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent login. Error -> " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Error -> " + ex.getMessage()));
        }
    }

    @PostMapping(path={"/startrecording"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> startRecording(@RequestParam(value="callid") String callid, @RequestParam(value="sourceport") String sourcePort, @RequestParam(value="destinationport") String destinationPort, @RequestParam(value="recordingfilename") String recordingFileName) {
        String message = String.format("Request for start recording. callid : %s, source port : %s, destination port : %s, recording file name : %s", callid, sourcePort, destinationPort, recordingFileName);
        logger.info((Object)message);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String _amqMessageInJson = "";
        int responseStatus = -1;
        try {
            if (callid.isEmpty()) {
                logger.info((Object)"Invalid Input");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            RecordingInfo objRecordingInfo = new RecordingInfo();
            objRecordingInfo.setCallid(callid);
            objRecordingInfo.setSourcePort(sourcePort);
            objRecordingInfo.setDestinationPort(destinationPort);
            objRecordingInfo.setRecordingFileName(recordingFileName);
            objRecordingInfo.setRecordingState(0);
            ObjectMapper mapper = new ObjectMapper();
            _amqMessageInJson = mapper.writeValueAsString((Object)objRecordingInfo);
            if (!_amqMessageInJson.isEmpty()) {
                String _queueName = __activeMQType + ".0";
                MessagePublisher _msgpublisher = new MessagePublisher();
                responseStatus = _msgpublisher.publishMessage(__activeMQServer, _queueName, _amqMessageInJson, __messageexpirytime);
            }
            objCommonResponse = new CommonResponseObject(responseStatus, responseStatus == 0 ? "Start recording information queued" : "Error in queuing start recording information", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in  queuing start recording information. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/stoprecording"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> stopRecording(@RequestParam(value="callid") String callid, @RequestParam(value="sourceport") String sourcePort, @RequestParam(value="destinationport") String destinationPort, @RequestParam(value="recordingfilename") String recordingFileName) {
        String message = String.format("Request for stop recording. callid : %s, source port : %s, destination port : %s, recording file name : %s", callid, sourcePort, destinationPort, recordingFileName);
        logger.info((Object)message);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String _amqMessageInJson = "";
        int responseStatus = -1;
        try {
            if (callid.isEmpty()) {
                logger.info((Object)"Invalid Input");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            RecordingInfo objRecordingInfo = new RecordingInfo();
            objRecordingInfo.setCallid(callid);
            objRecordingInfo.setSourcePort(sourcePort);
            objRecordingInfo.setDestinationPort(destinationPort);
            objRecordingInfo.setRecordingFileName(recordingFileName);
            objRecordingInfo.setRecordingState(2);
            ObjectMapper mapper = new ObjectMapper();
            _amqMessageInJson = mapper.writeValueAsString((Object)objRecordingInfo);
            if (!_amqMessageInJson.isEmpty()) {
                String _queueName = __activeMQType + ".2";
                MessagePublisher _msgpublisher = new MessagePublisher();
                responseStatus = _msgpublisher.publishMessage(__activeMQServer, _queueName, _amqMessageInJson, __messageexpirytime);
            }
            objCommonResponse = new CommonResponseObject(responseStatus, responseStatus == 0 ? "Stop recording information queued" : "Error in queuing stop recording information", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in queuing stop recording information. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/getSwitchSDP"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> getSwitchSDP(@RequestParam(value="callId") String callId) {
        logger.info((Object)("Request for fetching sdp for callid : " + callId));
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String sql = "";
        String sdp = "";
        JSONArray jsonArray = new JSONArray();
        try {
            if (callId.isEmpty()) {
                logger.info((Object)"Invalid Input");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            sql = "select coalesce(sdp,'') sdp from pbx.t_switchsdp where uuid = ? and coalesce(sdp,'') <> '';";
            sdp = (String)db.query(sql, new Object[]{callId}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!sdp.isEmpty()) {
                String[] sdpArray;
                for (String element : sdpArray = LINE_SEP_PATTERN.split(sdp)) {
                    jsonArray.put((Object)element);
                }
            }
            String sdpResponse = jsonArray.toString();
            logger.info((Object)("SDP Returned -> " + sdpResponse));
            objCommonResponse = new CommonResponseObject(0, "OK", sdpResponse);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(path={"/generateRemoteToken"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> generateRemoteToken(@RequestParam(value="userName") String userName, @RequestParam(defaultValue="") String authKey) {
        logger.info((Object)("Request for generating JWT token authKey & userName : " + authKey + ", " + userName));
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        String sql = "";
        int jwtExpiryInSeconds = 30;
        int userId = 0;
        Connection conn = null;
        int roleId = 0;
        try {
            if (userName.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)("Request come for generatetoken from server : " + this.getClientIpAddress(this.request)));
            if (!this.getClientIpAddress(this.request).equalsIgnoreCase("127.0.0.1") && !this.getClientIpAddress(this.request).equalsIgnoreCase("localhost")) {
                logger.error((Object)"Request from local server is allowed only");
                objCommonResponse = new CommonResponseObject(1, "Request from local server is allowed only", null);
            }
            if (authKey.isEmpty()) {
                logger.info((Object)"No authKey Provided. Will genearte at server side");
                authKey = UUID.randomUUID().toString() + "-jWT-" + UUID.randomUUID().toString();
                logger.info((Object)("Request for generating JWT token authKey : " + authKey));
            }
            try {
                CoralMeetSystemConfig meetconfig = this.meetConfig;
                if (meetconfig != null) {
                    jwtExpiryInSeconds = meetconfig.getJwtExpiryInSeconds();
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting jwt expiry. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                sql = "WITH a as(select id from m_user where lower(username) = lower(?))INSERT into m_user(username, description,enabled,createdby)SELECT ?,?,?,? WHERE NOT EXISTS (SELECT id FROM a);";
                db.update(sql, new Object[]{userName.toLowerCase(), userName, userName.toUpperCase(), 1, "SystemUser"});
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating new user. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            try {
                sql = "select id from m_user where username = ?";
                try {
                    userId = (Integer)db.query(sql, new Object[]{userName}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in fetching user details. Error -> " + ex.getMessage()), (Throwable)ex);
                    objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating new user. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            String systemUserRole = SystemController.getSystemUserRoles((String)userName);
            if (!systemUserRole.isEmpty()) {
                logger.info((Object)("System Roles : " + systemUserRole));
                String[] systemUserRoles = systemUserRole.split("\\s+");
                if (systemUserRoles.length > 0) {
                    for (String role : systemUserRoles) {
                        if (role.isEmpty()) continue;
                        try {
                            conn = db.getDataSource().getConnection();
                            sql = "WITH a as(select id from m_role where lower(shortcode) = lower(?))\r\nINSERT into m_role(shortcode, description,enabled)SELECT ?, ?,? WHERE NOT EXISTS (SELECT id FROM a)RETURNING id ;";
                            PreparedStatement prpState = conn.prepareStatement(sql);
                            prpState.setString(1, role.toLowerCase());
                            prpState.setString(2, role);
                            prpState.setString(3, role.toUpperCase());
                            prpState.setInt(4, 1);
                            ResultSet rs = prpState.executeQuery();
                            if (rs.next()) {
                                roleId = rs.getInt(1);
                            }
                            if (roleId <= 0 || userId <= 0) continue;
                            sql = "insert into m_userrole(\"user\",role) select ?,?";
                            db.update(sql, new Object[]{userId, roleId});
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in creating new code. Error -> " + ex.getMessage()), (Throwable)ex);
                            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                            ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            return responseEntity;
                        }
                        finally {
                            if (conn != null) {
                                conn.close();
                            }
                        }
                    }
                }
            }
            try {
                sql = "insert into m_user_token(createdby,username,jwtauthkey,jwttokengeneratedtime,jwttokenvalidtill) Values('APIRemote',?,?,extract(epoch from now()::timestamp(0) with time zone),(extract(epoch from now()::timestamp(0) with time zone) + ?))";
                db.update(sql, new Object[]{userName, authKey, jwtExpiryInSeconds});
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)("authKey genearted for userName : " + userName + ", " + authKey));
            objCommonResponse = new CommonResponseObject(0, "AuthKey generated", authKey);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/reboot"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> reboot(@RequestParam(value="userName") String userName, @RequestParam(value="authKey") String authKey) {
        logger.info((Object)("Request for system reboot with authKey & userName : " + authKey + ", " + userName));
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        int isAuthKeyMatched = 0;
        String response = "";
        try {
            if (userName.isEmpty() || authKey.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)("Request come for reboot from server : " + this.getClientIpAddress(this.request)));
            isAuthKeyMatched = (Integer)db.queryForObject("Select count(*) from m_user_token where createdby = 'APIRemote' and username = ? and jwtauthkey = ? and  jwttokenvalidtill > extract(epoch from now()::timestamp(0) with time zone)", new Object[]{userName, authKey}, Integer.class);
            if (isAuthKeyMatched == 1) {
                String s;
                logger.info((Object)"Valid request for rebooting the system, so extecute reboot command.");
                logger.info((Object)(userName + " initiated reboot "));
                String cmd = "reboot";
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command(cmd.split(" "));
                Process process = pb.start();
                process.waitFor();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    response = response + "\r\n" + s;
                    logger.info((Object)("Reboot : " + s));
                }
                BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((s = stdError.readLine()) != null) {
                    response = response + "\r\n" + s;
                    logger.error((Object)("Reboot : " + s));
                }
                objCommonResponse = new CommonResponseObject(0, "Reboot : " + response, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            logger.info((Object)"Invalid request for rebooting the system, so no need to extecute reboot command.");
            objCommonResponse = new CommonResponseObject(1, "Invalid request for rebooting the system, so no need to extecute reboot command.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in processing reboot request. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/addMember"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> addMember(@RequestBody ConferenceDetails objConferenceDetails) {
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (objConferenceDetails == null) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        logger.info((Object)("Request for adding Member with uuid & callerNumber : " + objConferenceDetails.getConferenceUniqueId() + ", " + objConferenceDetails.getCallerCallerIdNumber()));
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            if (objConferenceDetails.getConferenceUniqueId().isEmpty() || objConferenceDetails.getCallerCallerIdNumber().isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            String qry = "insert into pbx.t_conferencedetails(\r\nconferencename,conferenceaction,conferenceuuid,caller_id_number,caller_id_name,membertype,\r\ncaller_uuid,memberid,conferencesize,memberremoved,conferencefinished)values(?,?,?,?,?,?,?,?,?,?,?)";
            db.update(qry, new Object[]{objConferenceDetails.getConferenceName(), objConferenceDetails.getAction(), objConferenceDetails.getConferenceUniqueId(), objConferenceDetails.getCallerCallerIdNumber(), objConferenceDetails.getCallerUsername(), objConferenceDetails.getMemberType(), objConferenceDetails.getMemberUniqueId(), objConferenceDetails.getMemberId(), objConferenceDetails.getConferenceSize(), 0, 0});
            logger.info((Object)"Member Added");
            objCommonResponse = new CommonResponseObject(0, "Member Added", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in adding member details. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/removeMember"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> removeMember(@RequestBody ConferenceDetails objConferenceDetails) {
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (objConferenceDetails == null) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        logger.info((Object)("Request for removing Member with uuid & callerNumber : " + objConferenceDetails.getConferenceUniqueId() + ", " + objConferenceDetails.getMemberUniqueId()));
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            if (objConferenceDetails.getConferenceUniqueId().isEmpty() || objConferenceDetails.getMemberUniqueId().isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            String qry = "update pbx.t_conferencedetails set memberremoved = 1,memberremovedat = current_timestamp,conferencesize = ? where conferenceuuid = ?  and caller_uuid = ?";
            db.update(qry, new Object[]{objConferenceDetails.getConferenceSize(), objConferenceDetails.getConferenceUniqueId(), objConferenceDetails.getMemberUniqueId()});
            logger.info((Object)"Member removed");
            objCommonResponse = new CommonResponseObject(0, "Member Removed", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in processing member removed request. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/conferenceDestroyed"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> conferenceDestroyed(@RequestBody ConferenceDetails objConferenceDetails) {
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (objConferenceDetails == null) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        logger.info((Object)("Request for conference destroy with uuid" + objConferenceDetails.getConferenceUniqueId()));
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            if (objConferenceDetails.getConferenceUniqueId().isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            String qry = "update pbx.t_conferencedetails set conferencefinished = 1,conferencefinishedat = current_timestamp, conferencesize = ? where conferenceuuid = ?";
            db.update(qry, new Object[]{objConferenceDetails.getConferenceSize(), objConferenceDetails.getConferenceUniqueId()});
            logger.info((Object)"Conference Destroyed");
            objCommonResponse = new CommonResponseObject(0, "Conference Destroyed", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in processing conferenceDestroyed request. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public ArrayList<ConferenceMember> getConferenceMemberDetail(ArrayList<ConferenceMember> _list, String contactNumber) {
        ArrayList<ConferenceMember> _objrowparticipantslist = new ArrayList<ConferenceMember>();
        List _finalList = new ArrayList();
        try {
            if (_list.size() > 0) {
                6 filter = new /* Unavailable Anonymous Inner Class!! */;
                _finalList = new FilterList().filterList(_list, (FilterList.Filter)filter, (Object)contactNumber);
                _objrowparticipantslist.addAll(_finalList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getConferenceMemberDetail() " + ex.getMessage()), (Throwable)ex);
        }
        return _objrowparticipantslist;
    }

    public ArrayList<ConferenceMember> getConferenceMemberTalking(ArrayList<ConferenceMember> _list) {
        logger.info((Object)("ConferenceMemberTalking List " + _list.size()));
        ArrayList<ConferenceMember> _objrowparticipantslist = new ArrayList<ConferenceMember>();
        List _finalList = new ArrayList();
        try {
            if (_list.size() > 0) {
                7 filter = new /* Unavailable Anonymous Inner Class!! */;
                _finalList = new FilterList().filterList(_list, (FilterList.Filter)filter, (Object)"");
                logger.info((Object)("_finalList List " + _list.size()));
                _objrowparticipantslist.addAll(_finalList);
                logger.info((Object)("_objrowparticipantslist List " + _objrowparticipantslist.size()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getConferenceMemberTalking() " + ex.getMessage()), (Throwable)ex);
        }
        return _objrowparticipantslist;
    }

    public int executeConferenceCommand(String conferencenumber, String conferenceAction, String participantId) {
        int response = 1;
        String command = "";
        try {
            command = participantId.equalsIgnoreCase("na") ? "conference " + conferencenumber + " " + conferenceAction : "conference " + conferencenumber + " " + conferenceAction + " " + participantId;
            if (!command.isEmpty()) {
                command = "fs_cli -x \"" + command + "\"";
                response = this.objCommandDialer.executeconferencecommand(command);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in executing conference command for : " + conferencenumber + ", " + participantId + ". Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return response;
    }

    @PostMapping(path={"/activatePTT"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> activatePTT(@RequestParam(value="sipUser") String sipUser, @RequestParam(value="sipContact") String sipContact, @RequestParam(value="conferenceRoom") String conferenceRoom, @RequestParam(value="PTTAcquire") String _PTTAcquire) {
        String message = String.format("Request for activating/deactivating PTT. sipUser : %s, source sipContact : %s, conferenceRoom : %s, PTTAcquire : %s", sipUser, sipContact, conferenceRoom, _PTTAcquire);
        logger.info((Object)message);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String command = "";
        commandDialer objCommandDialer = new commandDialer();
        ArrayList listConferenceMember = new ArrayList();
        ArrayList _objrowparticipantslistDetails = new ArrayList();
        ArrayList _objrowparticipantslistTalkingOnly = new ArrayList();
        ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
        int PTTAcquire = -1;
        try {
            block30: {
                if (sipUser.isEmpty() || sipContact.isEmpty() || conferenceRoom.isEmpty()) {
                    logger.info((Object)"Invalid Input");
                    objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
                String conferenceData = "";
                try {
                    PTTAcquire = Integer.parseInt(_PTTAcquire);
                    command = "conference " + conferenceRoom + " xml_list";
                    conferenceData = objCommandDialer.getConferenceMemeberList(command);
                    if (conferenceData == null || conferenceData.isEmpty() || !conferenceData.startsWith("<?xml")) break block30;
                    logger.info((Object)"Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        if (listConferenceMember.size() <= 0) break block30;
                        _objrowparticipantslistDetails = this.getConferenceMemberDetail(listConferenceMember, sipContact);
                        if (PTTAcquire == 1) {
                            try {
                                if (_objrowparticipantslistDetails != null) {
                                    if (_objrowparticipantslistDetails.size() == 1) {
                                        String _participantid = "";
                                        _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                        if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                            logger.info((Object)("Following Request Comming For Releasing PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                            this.executeConferenceCommand(conferenceRoom, "mute", _participantid);
                                            this.executeConferenceCommand(conferenceRoom, "vmute", _participantid);
                                        } else {
                                            logger.info((Object)("_participantid is Empty " + _participantid + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        }
                                    } else {
                                        logger.info((Object)("_objrowparticipantslistDetails Size <> 1  " + _objrowparticipantslistDetails.size() + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                    }
                                } else {
                                    logger.info((Object)("_objrowparticipantslistDetails = null  " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                }
                                objCommonResponse = new CommonResponseObject(1, "Speaking access revoked.", null);
                                break block30;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in activatePTT " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in activatePTT " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                        }
                        _objrowparticipantslistTalkingOnly = this.getConferenceMemberTalking(listConferenceMember);
                        String _message = "";
                        if (_objrowparticipantslistTalkingOnly.size() > 0) {
                            logger.info((Object)("_objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                            try {
                                for (ConferenceMember _ConferenceMember : _objrowparticipantslistTalkingOnly) {
                                    if (!_ConferenceMember.isCan_speak()) continue;
                                    _message = _message + "\n";
                                    _message = _message + _ConferenceMember.getCaller_id_number() + " : " + _ConferenceMember.getCaller_id_name();
                                }
                                if (!_message.isEmpty()) {
                                    _message = "Following(s) is currently Speaking in Conference." + _message + "\nPlease ask them then to Push Release PTT First";
                                    logger.info((Object)_message);
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in activatePTT " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in activatePTT " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                            objCommonResponse = new CommonResponseObject(2, _message, null);
                            break block30;
                        }
                        logger.info((Object)("Count objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                        try {
                            if (_objrowparticipantslistDetails != null) {
                                if (_objrowparticipantslistDetails.size() == 1) {
                                    String _participantid = "";
                                    _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                    if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                        logger.info((Object)("Following Request Comming For Aquiring PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        this.executeConferenceCommand(conferenceRoom, "unmute", _participantid);
                                        this.executeConferenceCommand(conferenceRoom, "unvmute", _participantid);
                                        message = "Speak access granted";
                                        objCommonResponse = new CommonResponseObject(0, message, null);
                                    }
                                } else if (_objrowparticipantslistDetails.size() > 1) {
                                    message = "Total " + _objrowparticipantslistDetails.size() + " Records Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                } else {
                                    message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                }
                            } else {
                                message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                logger.info((Object)message);
                                objCommonResponse = new CommonResponseObject(1, message, null);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in activatePTT " + ex.getMessage()), (Throwable)ex);
                            objCommonResponse = new CommonResponseObject(1, "Error in activatePTT " + ex.getMessage(), null);
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in activatePTT " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error in activatePTT " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/mutehp/{sipUser}/{type}/{conferenceRoom}"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> mutehp(@PathVariable(value="sipUser") String sipUser, @PathVariable(value="type") String type, @PathVariable(value="conferenceRoom") String conferenceRoom) {
        String message = String.format("Request for mutehp. sipUser : %s, source type : %s, conferenceRoom : %s", sipUser, type, conferenceRoom);
        logger.info((Object)message);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String command = "";
        commandDialer objCommandDialer = new commandDialer();
        ArrayList listConferenceMember = new ArrayList();
        ArrayList _objrowparticipantslistDetails = new ArrayList();
        ArrayList _objrowparticipantslistTalkingOnly = new ArrayList();
        ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
        int PTTAcquire = -1;
        String sipContact = sipUser;
        try {
            block30: {
                if (sipUser.isEmpty() || type.isEmpty() || conferenceRoom.isEmpty()) {
                    logger.info((Object)"Invalid Input");
                    objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
                String conferenceData = "";
                try {
                    PTTAcquire = 1;
                    command = "conference " + conferenceRoom + " xml_list";
                    conferenceData = objCommandDialer.getConferenceMemeberList(command);
                    if (conferenceData == null || conferenceData.isEmpty() || !conferenceData.startsWith("<?xml")) break block30;
                    logger.info((Object)"Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        if (listConferenceMember.size() <= 0) break block30;
                        _objrowparticipantslistDetails = this.getConferenceMemberDetail(listConferenceMember, sipContact);
                        if (PTTAcquire == 1) {
                            try {
                                if (_objrowparticipantslistDetails != null) {
                                    if (_objrowparticipantslistDetails.size() == 1) {
                                        String _participantid = "";
                                        _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                        if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                            logger.info((Object)("Following Request Comming For Releasing PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                            this.executeConferenceCommand(conferenceRoom, "mute", _participantid);
                                            this.executeConferenceCommand(conferenceRoom, "vmute", _participantid);
                                        } else {
                                            logger.info((Object)("_participantid is Empty " + _participantid + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        }
                                    } else {
                                        logger.info((Object)("_objrowparticipantslistDetails Size <> 1  " + _objrowparticipantslistDetails.size() + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                    }
                                } else {
                                    logger.info((Object)("_objrowparticipantslistDetails = null  " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                }
                                objCommonResponse = new CommonResponseObject(1, "Speaking access revoked.", null);
                                break block30;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in mutehp " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in mutehp " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                        }
                        _objrowparticipantslistTalkingOnly = this.getConferenceMemberTalking(listConferenceMember);
                        String _message = "";
                        if (_objrowparticipantslistTalkingOnly.size() > 0) {
                            logger.info((Object)("_objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                            try {
                                for (ConferenceMember _ConferenceMember : _objrowparticipantslistTalkingOnly) {
                                    if (!_ConferenceMember.isCan_speak()) continue;
                                    _message = _message + "\n";
                                    _message = _message + _ConferenceMember.getCaller_id_number() + " : " + _ConferenceMember.getCaller_id_name();
                                }
                                if (!_message.isEmpty()) {
                                    _message = "Following(s) is currently Speaking in Conference." + _message + "\nPlease ask them then to Push Release PTT First";
                                    logger.info((Object)_message);
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in mutehp " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in mutehp " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                            objCommonResponse = new CommonResponseObject(2, _message, null);
                            break block30;
                        }
                        logger.info((Object)("Count objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                        try {
                            if (_objrowparticipantslistDetails != null) {
                                if (_objrowparticipantslistDetails.size() == 1) {
                                    String _participantid = "";
                                    _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                    if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                        logger.info((Object)("Following Request Comming For Aquiring PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        this.executeConferenceCommand(conferenceRoom, "unmute", _participantid);
                                        this.executeConferenceCommand(conferenceRoom, "unvmute", _participantid);
                                        message = "Speak access granted";
                                        objCommonResponse = new CommonResponseObject(0, message, null);
                                    }
                                } else if (_objrowparticipantslistDetails.size() > 1) {
                                    message = "Total " + _objrowparticipantslistDetails.size() + " Records Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                } else {
                                    message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                }
                            } else {
                                message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                logger.info((Object)message);
                                objCommonResponse = new CommonResponseObject(1, message, null);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in mutehp " + ex.getMessage()), (Throwable)ex);
                            objCommonResponse = new CommonResponseObject(1, "Error in mutehp " + ex.getMessage(), null);
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in mutehp " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error in mutehp " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/unmutehp/{sipUser}/{type}/{conferenceRoom}"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> unmutehp(@PathVariable(value="sipUser") String sipUser, @PathVariable(value="type") String type, @PathVariable(value="conferenceRoom") String conferenceRoom) {
        String message = String.format("Request for unmutehp. sipUser : %s, source type : %s, conferenceRoom : %s", sipUser, type, conferenceRoom);
        logger.info((Object)message);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String command = "";
        commandDialer objCommandDialer = new commandDialer();
        ArrayList listConferenceMember = new ArrayList();
        ArrayList _objrowparticipantslistDetails = new ArrayList();
        ArrayList _objrowparticipantslistTalkingOnly = new ArrayList();
        ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
        int PTTAcquire = -1;
        String sipContact = sipUser;
        try {
            block30: {
                if (sipUser.isEmpty() || type.isEmpty() || conferenceRoom.isEmpty()) {
                    logger.info((Object)"Invalid Input");
                    objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
                String conferenceData = "";
                try {
                    PTTAcquire = 0;
                    command = "conference " + conferenceRoom + " xml_list";
                    conferenceData = objCommandDialer.getConferenceMemeberList(command);
                    if (conferenceData == null || conferenceData.isEmpty() || !conferenceData.startsWith("<?xml")) break block30;
                    logger.info((Object)"Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        if (listConferenceMember.size() <= 0) break block30;
                        _objrowparticipantslistDetails = this.getConferenceMemberDetail(listConferenceMember, sipContact);
                        if (PTTAcquire == 1) {
                            try {
                                if (_objrowparticipantslistDetails != null) {
                                    if (_objrowparticipantslistDetails.size() == 1) {
                                        String _participantid = "";
                                        _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                        if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                            logger.info((Object)("Following Request Comming For Releasing PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                            this.executeConferenceCommand(conferenceRoom, "mute", _participantid);
                                            this.executeConferenceCommand(conferenceRoom, "vmute", _participantid);
                                        } else {
                                            logger.info((Object)("_participantid is Empty " + _participantid + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        }
                                    } else {
                                        logger.info((Object)("_objrowparticipantslistDetails Size <> 1  " + _objrowparticipantslistDetails.size() + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                    }
                                } else {
                                    logger.info((Object)("_objrowparticipantslistDetails = null  " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                }
                                objCommonResponse = new CommonResponseObject(1, "Speaking access revoked.", null);
                                break block30;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in unmutehp " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in unmutehp " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                        }
                        _objrowparticipantslistTalkingOnly = this.getConferenceMemberTalking(listConferenceMember);
                        String _message = "";
                        if (_objrowparticipantslistTalkingOnly.size() > 0) {
                            logger.info((Object)("_objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                            try {
                                for (ConferenceMember _ConferenceMember : _objrowparticipantslistTalkingOnly) {
                                    if (!_ConferenceMember.isCan_speak()) continue;
                                    _message = _message + "\n";
                                    _message = _message + _ConferenceMember.getCaller_id_number() + " : " + _ConferenceMember.getCaller_id_name();
                                }
                                if (!_message.isEmpty()) {
                                    _message = "Following(s) is currently Speaking in Conference." + _message + "\nPlease ask them then to Push Release PTT First";
                                    logger.info((Object)_message);
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in unmutehp " + ex.getMessage()), (Throwable)ex);
                                objCommonResponse = new CommonResponseObject(1, "Error in unmutehp " + ex.getMessage(), null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                            }
                            objCommonResponse = new CommonResponseObject(2, _message, null);
                            break block30;
                        }
                        logger.info((Object)("Count objrowparticipantslistTalkingOnly List " + _objrowparticipantslistTalkingOnly.size()));
                        try {
                            if (_objrowparticipantslistDetails != null) {
                                if (_objrowparticipantslistDetails.size() == 1) {
                                    String _participantid = "";
                                    _participantid = ((ConferenceMember)_objrowparticipantslistDetails.get(0)).getId();
                                    if (!_participantid.isEmpty() && !conferenceRoom.isEmpty()) {
                                        logger.info((Object)("Following Request Comming For Aquiring PTT " + sipUser + ", " + sipContact + ", " + conferenceRoom + ", " + PTTAcquire));
                                        this.executeConferenceCommand(conferenceRoom, "unmute", _participantid);
                                        this.executeConferenceCommand(conferenceRoom, "unvmute", _participantid);
                                        message = "Speak access granted";
                                        objCommonResponse = new CommonResponseObject(0, message, null);
                                    }
                                } else if (_objrowparticipantslistDetails.size() > 1) {
                                    message = "Total " + _objrowparticipantslistDetails.size() + " Records Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                } else {
                                    message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                    logger.info((Object)message);
                                    objCommonResponse = new CommonResponseObject(1, message, null);
                                }
                            } else {
                                message = "No Details Found For Participant in Conference Room. Participant Contact No Searched : " + sipContact + " , Conference Room : " + conferenceRoom;
                                logger.info((Object)message);
                                objCommonResponse = new CommonResponseObject(1, message, null);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in unmutehp " + ex.getMessage()), (Throwable)ex);
                            objCommonResponse = new CommonResponseObject(1, "Error in unmutehp " + ex.getMessage(), null);
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in unmutehp " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, "Error in unmutehp " + ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }
}

