/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.systems.api;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.codec.binary.Base64;

public class MessagePublisher
extends Thread {
    private static Logger logger = Logger.getLogger(MessagePublisher.class);

    public int publishMessage(String p_serverurl, String p_queueName, String p_message, long p_messageExpiry) {
        int ret = 1;
        if (!(p_serverurl.isEmpty() || p_queueName.isEmpty() || p_message.isEmpty())) {
            logger.info((Object)("Entered into Message Loop : " + p_serverurl + ", Queue Name => " + p_queueName));
            try {
                String url = p_serverurl;
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(url);
                Connection connection = connectionFactory.createConnection();
                connection.start();
                Session session = connection.createSession(false, 3);
                Queue destination = session.createQueue(p_queueName);
                MessageProducer producer = session.createProducer((Destination)destination);
                producer.setDeliveryMode(1);
                if (p_messageExpiry > 0L) {
                    producer.setTimeToLive(p_messageExpiry);
                }
                TextMessage message = session.createTextMessage(this.encodeMessage(p_message));
                producer.send((Message)message);
                try {
                    if (producer != null) {
                        producer.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in closing producer : " + p_serverurl + ", Error : => " + ex.getMessage()), (Throwable)ex);
                }
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in closing session : " + p_serverurl + ", Error : => " + ex.getMessage()), (Throwable)ex);
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in closing connection : " + p_serverurl + ", Error : => " + ex.getMessage()), (Throwable)ex);
                }
                ret = 0;
                logger.info((Object)("Record Added to " + p_queueName + " => Ended in Message Loop : " + p_serverurl + ", Queue Name => " + p_queueName));
            }
            catch (Exception ex) {
                logger.error((Object)("Error in closing connection : " + p_serverurl + ", Error : => " + ex.getMessage()), (Throwable)ex);
            }
        }
        return ret;
    }

    private String encodeMessage(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.encodeBase64((byte[])p_message.getBytes());
            _ret = new String(bytesEncoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in encodeMessage : , Error : => " + ex.getMessage()), (Throwable)ex);
        }
        return _ret;
    }
}

