/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.qtalk.api;

import com.coraltele.config.env.databaseUtilities;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.qtalk.api.CoralMeetBookedRoomDetails;
import com.coraltele.restapi.qtalk.api.CoralMeetLicenseDetails;
import com.coraltele.restapi.qtalk.api.CoralMeetRoomStatus;
import com.coraltele.restapi.qtalk.api.EncryptDecrypt;
import com.coraltele.restapi.qtalk.api.IsActualOwner;
import com.coraltele.restapi.qtalk.api.ResponseObject;
import com.coraltele.restapi.qtalk.api.RoomWiseMaximumParticipant;
import com.coraltele.restapi.qtalk.api.UpdateRoomStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/qtalk/v1"})
public class ControllerCoralMeet {
    private static final Logger logger = Logger.getLogger(ControllerCoralMeet.class);
    private static long defaultMeetingDuration = 300L;
    private static long MeetingDuration = 18000L;
    private static long freeRoomDuration = 1800L;
    private static List<String> reservedUsers = new ArrayList();
    private static String CIPHER_NAME = "AES/CBC/PKCS5PADDING";
    private static int CIPHER_KEY_LEN = 16;
    private static String CIPHER_KEY = "c0R@L#m$#%([Q^Tk";
    private static String CIPHER_IV = "Qu#@L#m$#%([Q^Tk";
    private static int defaultMaxUserLimit = 15;
    private static int defaultMaxUserLimitForRoomType1 = 30;
    @Autowired
    DataSource dsUseCIPHER_KEYrs;
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest request;
    @Autowired
    ServletContext servletContext;
    @Autowired
    WebInvocationPrivilegeEvaluator privilegeEvaluator;
    @Autowired
    @Qualifier(value="dataSourceBilling")
    private DataSource dsBilling;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dsUsers")
    private DataSource dsUsers;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ControllerCoralMeet() {
        ControllerCoralMeet.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
        reservedUsers.add("jvb");
        reservedUsers.add("focus");
        reservedUsers.add("jigasi");
    }

    @GetMapping(path={"/getroomwisemaxoccupants/{roomid}"}, produces={"application/json"})
    public ResponseEntity<RoomWiseMaximumParticipant> getroomwisemaxoccupants(@PathVariable(value="roomid") String roomid) {
        logger.info((Object)("Request for checking room wise max occupants for : room id : " + roomid));
        RoomWiseMaximumParticipant objRoomWiseMaximumParticipant = new RoomWiseMaximumParticipant();
        objRoomWiseMaximumParticipant = new RoomWiseMaximumParticipant(0);
        if (!roomid.isEmpty()) {
            int max_occupants = 0;
            String qry = "";
            int roomtype = 0;
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            qry = "select coalesce(roomtype,0) roomtype from coralmeet.m_coralmeetrandomroomstatus where (name||pin::text)= ? limit 1";
            try {
                roomtype = (Integer)db.query(qry, new Object[]{roomid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                max_occupants = roomtype == 1 ? defaultMaxUserLimitForRoomType1 : defaultMaxUserLimit;
                objRoomWiseMaximumParticipant = new RoomWiseMaximumParticipant(max_occupants);
                logger.info((Object)("Max Occupants limit for : room id : " + max_occupants));
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objRoomWiseMaximumParticipant);
            }
            catch (Exception ex) {
                objRoomWiseMaximumParticipant = new RoomWiseMaximumParticipant(1);
                logger.info((Object)("Max Occupants limit for : room id : " + max_occupants));
                logger.error((Object)("Error in fetching room wise max occupants for : room id : " + roomid + ", Error : " + ex.getMessage()), (Throwable)ex);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objRoomWiseMaximumParticipant);
    }

    @GetMapping(path={"/isactualowner/{roomid}/{stats_id}"}, produces={"application/json"})
    public ResponseEntity<IsActualOwner> isactualowner(@PathVariable(value="roomid") String roomid, @PathVariable(value="stats_id") String stats_id) {
        logger.info((Object)("Request for checking room's actual owner for : room id : " + roomid));
        IsActualOwner objIsActualOwner = new IsActualOwner();
        objIsActualOwner = new IsActualOwner(0);
        if (!roomid.isEmpty() && !stats_id.isEmpty()) {
            String mail_owner = "";
            int validroom = 0;
            String qry = "";
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            qry = "select count(*) from coralmeet.m_coralmeetrandomroomstatus where (name||pin::text)= ? and roomexpired = 0";
            validroom = (Integer)db.queryForObject(qry, new Object[]{roomid}, Integer.class);
            if (validroom == 0) {
                objIsActualOwner = new IsActualOwner(-1);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objIsActualOwner);
            }
            qry = "select coalesce(mail_owner,'') mail_owner from coralmeet.m_coralmeetrandomroomstatus where (name||pin::text)= ? limit 1";
            try {
                mail_owner = (String)db.query(qry, new Object[]{roomid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                if (mail_owner.isEmpty()) {
                    qry = "update coralmeet.m_coralmeetrandomroomstatus set mail_owner = ? where (name||pin::text)= ?";
                    db.update(qry, new Object[]{stats_id, roomid});
                    objIsActualOwner = new IsActualOwner(1);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objIsActualOwner);
                }
                if (mail_owner.equals(stats_id)) {
                    objIsActualOwner = new IsActualOwner(1);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objIsActualOwner);
                }
                objIsActualOwner = new IsActualOwner(0);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objIsActualOwner);
            }
            catch (Exception ex) {
                objIsActualOwner = new IsActualOwner(0);
                logger.error((Object)("Error in fetching room's actual owner for : room id : " + roomid + ", Error : " + ex.getMessage()), (Throwable)ex);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objIsActualOwner);
    }

    @GetMapping(path={"/muc_occupant_joined/{roomid}/{jid}/{display_name}/{audio_muted}/{video_muted}/{moderator}"}, produces={"application/json"})
    public ResponseEntity<UpdateRoomStatus> muc_occupant_joined(@PathVariable(value="roomid") String roomid, @PathVariable(value="jid") String jid, @PathVariable(value="display_name") String display_name, @PathVariable(value="audio_muted") String audio_muted, @PathVariable(value="video_muted") String video_muted, @PathVariable(value="moderator") int moderator) {
        logger.info((Object)("Participant has been entered the room : " + roomid + ", jid  : " + jid + ", display_name  : " + display_name + ", audio_muted  : " + audio_muted + ", video_muted  : " + video_muted + ", moderator  : " + moderator));
        String meetingid = "";
        String p_mail_owner = "";
        String p_start_time = "";
        long p_duration = 0L;
        String p_username = "";
        String p_emailid = "";
        int ismoderator = 0;
        long p_meetingpin = 0L;
        String p_clientIPAddress = "";
        String p_clientAgents = "";
        boolean p_audio_muted = false;
        boolean p_video_muted = false;
        String p_videotype = "";
        boolean p_handraised = false;
        try {
            display_name = URLDecoder.decode(display_name, "UTF-8");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in participant entering the room : room id : " + roomid + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        UpdateRoomStatus objUpdateRoomStatus = new UpdateRoomStatus();
        objUpdateRoomStatus = new UpdateRoomStatus(0);
        if (!roomid.isEmpty() && !jid.isEmpty()) {
            if (roomid.length() == 12) {
                meetingid = roomid.substring(0, 8);
                p_meetingpin = Long.parseLong(roomid.substring(8, 12));
            } else {
                meetingid = roomid;
                p_meetingpin = 0L;
            }
            p_mail_owner = jid;
            p_duration = 0L;
            p_username = display_name;
            ismoderator = moderator == 1 ? 1 : 0;
            p_audio_muted = Boolean.parseBoolean(audio_muted);
            p_video_muted = Boolean.parseBoolean(video_muted);
            try {
                this.createconferencedetails(meetingid, p_mail_owner, p_start_time, p_duration, p_username, p_emailid, ismoderator, p_meetingpin, p_clientIPAddress, p_clientAgents, "", 1, false, false, "camera", false);
                objUpdateRoomStatus = new UpdateRoomStatus(1);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating conference details : " + meetingid + " : " + meetingid + " : " + display_name + " " + jid + ", Error : " + ex.getMessage()), (Throwable)ex);
                objUpdateRoomStatus = new UpdateRoomStatus(0);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
    }

    @GetMapping(path={"/muc_occupant_left/{roomid}/{jid}"}, produces={"application/json"})
    public ResponseEntity<UpdateRoomStatus> muc_occupant_left(@PathVariable(value="roomid") String roomid, @PathVariable(value="jid") String jid) {
        logger.info((Object)("Participant left the entered the room : " + roomid + ", jid  : " + jid));
        String meetingid = "";
        String p_mail_owner = "";
        String p_start_time = "";
        long p_duration = 0L;
        String p_username = "";
        String p_emailid = "";
        int ismoderator = 0;
        long p_meetingpin = 0L;
        String p_clientIPAddress = "";
        String p_clientAgents = "";
        boolean p_audio_muted = false;
        boolean p_video_muted = false;
        String p_videotype = "";
        boolean p_handraised = false;
        String display_name = "";
        String qry = "";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        UpdateRoomStatus objUpdateRoomStatus = new UpdateRoomStatus();
        objUpdateRoomStatus = new UpdateRoomStatus(0);
        if (!roomid.isEmpty() && !jid.isEmpty()) {
            if (roomid.length() == 12) {
                meetingid = roomid.substring(0, 8);
                p_meetingpin = Long.parseLong(roomid.substring(8, 12));
            } else {
                meetingid = roomid;
                p_meetingpin = 0L;
            }
            logger.info((Object)("display_name : " + display_name));
            qry = "select coalesce(username,'') username from coralmeet.t_conferencesummary where coalesce(name,'') = ? and coalesce(mail_owner,'') = ? order by id desc limit 1";
            try {
                p_mail_owner = jid;
                p_username = display_name = (String)db.query(qry, new Object[]{meetingid, jid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in fetching username for room name : " + roomid + ", jid : " + jid), (Throwable)ex);
            }
            logger.info((Object)("display_name : " + p_username));
            try {
                this.createconferencedetails(meetingid, p_mail_owner, p_start_time, p_duration, p_username, p_emailid, ismoderator, p_meetingpin, p_clientIPAddress, p_clientAgents, "", 0, false, false, "camera", false);
                objUpdateRoomStatus = new UpdateRoomStatus(1);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating conference details : " + meetingid + " : " + meetingid + " : " + display_name + " " + jid + ", Error : " + ex.getMessage()), (Throwable)ex);
                objUpdateRoomStatus = new UpdateRoomStatus(0);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
    }

    @GetMapping(path={"/muc_room_destroyed/{roomid}"}, produces={"application/json"})
    public ResponseEntity<UpdateRoomStatus> muc_room_destroyed(@PathVariable(value="roomid") String roomid) {
        logger.info((Object)("Room Destroyed : " + roomid));
        String meetingid = "";
        String p_mail_owner = "";
        String p_start_time = "";
        long p_duration = 0L;
        String p_username = "";
        String p_emailid = "";
        int ismoderator = 0;
        long p_meetingpin = 0L;
        String p_clientIPAddress = "";
        String p_clientAgents = "";
        boolean p_audio_muted = false;
        boolean p_video_muted = false;
        String p_videotype = "";
        boolean p_handraised = false;
        String display_name = "";
        UpdateRoomStatus objUpdateRoomStatus = new UpdateRoomStatus();
        objUpdateRoomStatus = new UpdateRoomStatus(0);
        if (!roomid.isEmpty()) {
            if (roomid.length() == 12) {
                meetingid = roomid.substring(0, 8);
                p_meetingpin = Long.parseLong(roomid.substring(8, 12));
            } else {
                meetingid = roomid;
                p_meetingpin = 0L;
            }
            try {
                this.createconferencedetails(meetingid, p_mail_owner, p_start_time, p_duration, p_username, p_emailid, ismoderator, p_meetingpin, p_clientIPAddress, p_clientAgents, "", 2, false, false, "camera", false);
                objUpdateRoomStatus = new UpdateRoomStatus(1);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating conference details : " + meetingid + " : " + meetingid + ", Error : " + ex.getMessage()), (Throwable)ex);
                objUpdateRoomStatus = new UpdateRoomStatus(0);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
    }

    @GetMapping(path={"/muc_occupant_pre_change/{roomid}/{jid}/{display_name}/{audio_muted}/{video_muted}/{videotype}/{handraised}"}, produces={"application/json"})
    public ResponseEntity<UpdateRoomStatus> muc_occupant_pre_change(@PathVariable(value="roomid") String roomid, @PathVariable(value="jid") String jid, @PathVariable(value="display_name") String display_name, @PathVariable(value="audio_muted") String audio_muted, @PathVariable(value="video_muted") String video_muted, @PathVariable(value="videotype") String video_type, @PathVariable(value="handraised") String handraised) {
        logger.info((Object)("Participant has been entered the room : " + roomid + ", jid  : " + jid + ", display_name  : " + display_name + ", audio_muted  : " + audio_muted + ", video_muted  : " + video_muted + ", video_type  : " + video_type + ", handraised  : " + handraised));
        String meetingid = "";
        String p_mail_owner = "";
        String p_start_time = "";
        long p_duration = 0L;
        String p_username = "";
        String p_emailid = "";
        int ismoderator = 0;
        long p_meetingpin = 0L;
        String p_clientIPAddress = "";
        String p_clientAgents = "";
        boolean p_audio_muted = false;
        boolean p_video_muted = false;
        String p_videotype = "";
        boolean p_handraised = false;
        try {
            display_name = URLDecoder.decode(display_name, "UTF-8");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in participant entering the room : room id : " + roomid + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        UpdateRoomStatus objUpdateRoomStatus = new UpdateRoomStatus();
        objUpdateRoomStatus = new UpdateRoomStatus(0);
        if (!roomid.isEmpty() && !jid.isEmpty()) {
            if (roomid.length() == 12) {
                meetingid = roomid.substring(0, 8);
                p_meetingpin = Long.parseLong(roomid.substring(8, 12));
            } else {
                meetingid = roomid;
                p_meetingpin = 0L;
            }
            p_mail_owner = jid;
            p_duration = 0L;
            p_username = display_name;
            ismoderator = ismoderator == 1 ? 1 : 0;
            p_audio_muted = Boolean.parseBoolean(audio_muted);
            p_video_muted = Boolean.parseBoolean(video_muted);
            p_videotype = video_type;
            p_handraised = Boolean.parseBoolean(handraised);
            try {
                this.createconferencedetails(meetingid, p_mail_owner, p_start_time, p_duration, p_username, p_emailid, ismoderator, p_meetingpin, p_clientIPAddress, p_clientAgents, "", 1, p_audio_muted, p_video_muted, p_videotype, p_handraised);
                objUpdateRoomStatus = new UpdateRoomStatus(1);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in creating conference details : " + meetingid + " : " + meetingid + " : " + display_name + " " + jid + ", Error : " + ex.getMessage()), (Throwable)ex);
                objUpdateRoomStatus = new UpdateRoomStatus(0);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objUpdateRoomStatus);
    }

    @GetMapping(path={"/conference/{conflict_id}"}, produces={"application/json"})
    public ResponseEntity<CoralMeetRoomStatus> getConferenceRoomStatus(@PathVariable(value="conflict_id") long conflict_id) {
        logger.info((Object)("Request for checking room status for : conflict_id : " + conflict_id));
        if (conflict_id > 0L) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat conferenceStartTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmm'Z'");
            List roomDetails = null;
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            try {
                String qry = "select id,coalesce(name,'') as name,coalesce(mail_owner,'') mail_owner,start_time::timestamp,duration,coalesce(message,'') message\r\nfrom coralmeet.m_coralmeetroomstatus where id = ? order by id desc limit 1 ;";
                roomDetails = db.queryForList(qry, new Object[]{conflict_id});
                for (Map objRoom : roomDetails) {
                    try {
                        logger.info((Object)("Room details sent for : conflict_id : " + conflict_id));
                        CoralMeetRoomStatus objCoralMeetRoomStatus = new CoralMeetRoomStatus(Long.parseLong(objRoom.get("id").toString()), objRoom.get("name").toString(), objRoom.get("mail_owner").toString(), conferenceStartTime.format(formatter.parse(objRoom.get("start_time").toString())).toString(), Long.parseLong(objRoom.get("duration").toString()), objRoom.get("message").toString(), 0L, null);
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCoralMeetRoomStatus);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error checking room status for : conflict_id : " + conflict_id + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error checking room status for : conflict_id : " + conflict_id + ex.getMessage()), (Throwable)ex);
            }
        }
        CoralMeetRoomStatus objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "No data found for room id : " + conflict_id, 0L, null);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCoralMeetRoomStatus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(path={"/conference"}, produces={"application/json"})
    public ResponseEntity<CoralMeetRoomStatus> createConferenceRoom(@RequestParam(value="name") String name, @RequestParam(value="start_time") String start_time, @RequestParam(value="mail_owner", defaultValue="NA") String mail_owner) {
        CoralMeetRoomStatus objCoralMeetRoomStatus;
        logger.info((Object)("Request for creating room : name,start_time,mail_owner : " + name + ", " + start_time + ", " + mail_owner));
        long roomAlreadyExist = 0L;
        SimpleDateFormat formatter6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        long headerid = 0L;
        String qry = "";
        String clientIPAddress = "";
        String clientAgents = "";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        long pin = 0L;
        long duration = 0L;
        String emailid = "";
        String _roomowner = "";
        if (mail_owner.isEmpty() || mail_owner.equals("NA")) {
            logger.error((Object)("You are not authorized to create new conference, Contact administrator : name,start_time,mail_owner : " + name + ", " + start_time + ", " + mail_owner));
            CoralMeetRoomStatus objCoralMeetRoomStatus2 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "You are not authorized to create new conference, Contact administrator.!", 0L, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus2);
        }
        if (name.isEmpty() || start_time.isEmpty()) {
            logger.error((Object)("Invalid request for creating room : name,start_time,mail_owner : " + name + ", " + start_time + ", " + mail_owner));
            CoralMeetRoomStatus objCoralMeetRoomStatus3 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Invalid request for creating conference room. Contact administrator.!", 0L, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)objCoralMeetRoomStatus3);
        }
        List roomDetails = null;
        qry = "select pin,duration,emailid from coralmeet.m_coralmeetrandomroomstatus where name||pin = ? and roomexpired = 0 and bookingdatefromepoch <= extract(epoch from now()::timestamp(0) with time zone) and bookingdatetoepoch > extract(epoch from now()::timestamp(0) with time zone) and name = ? limit 1 ;";
        try {
            logger.info((Object)("============= Meeting ID ============ : " + name));
            _roomowner = mail_owner.split("@")[0];
            roomDetails = db.queryForList(qry, new Object[]{name, _roomowner});
            for (Object objRoom : roomDetails) {
                pin = Long.parseLong(objRoom.get("pin").toString());
                duration = Long.parseLong(objRoom.get("duration").toString());
                emailid = objRoom.get("emailid").toString();
            }
        }
        catch (Exception ex) {
            pin = 0L;
            logger.error((Object)("Room is not booked by you, So try booking room again., room name : " + name + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        if (pin == 0L) {
            logger.error((Object)("Room is not booked by you, So try booking room again., room name : " + name));
            objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Room is not booked by you, So try booking room again., room name : " + name, roomAlreadyExist, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)objCoralMeetRoomStatus);
        }
        logger.info((Object)("PIN : " + pin + ", DURATION : " + duration + ", EMAIL : " + emailid));
        qry = "select id from coralmeet.m_coralmeetroomstatus where lower(name) = ?";
        try {
            roomAlreadyExist = (Long)db.query(qry, new Object[]{name.toLowerCase()}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            roomAlreadyExist = 1L;
            logger.error((Object)("Error in checking either room already exist, room name : " + name), (Throwable)ex);
        }
        if (roomAlreadyExist > 0L) {
            logger.error((Object)("Room is already created : " + name + " with roomid : " + roomAlreadyExist));
            objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Room is already created : " + name, roomAlreadyExist, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)objCoralMeetRoomStatus);
        }
        try {
            Object objRoom;
            try {
                clientIPAddress = this.getClientIpAddress(this.request);
                clientAgents = this.request.getHeader("User-Agent");
                logger.info((Object)("Request comes from ip & user agent : " + clientIPAddress + ", " + clientAgents));
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting client ip address  : " + name + ", " + start_time + ", " + mail_owner));
            }
            qry = "insert into coralmeet.m_coralmeetroomstatus(name,mail_owner,start_time,duration,registeredip,registeredbrowseragent,pin,username,emailid) values(?,?,?,?,?,?,?,?,?);";
            Connection connection = db.getDataSource().getConnection();
            objRoom = null;
            try (PreparedStatement statement = connection.prepareStatement(qry, 1);){
                try {
                    Date startTime = formatter6.parse(start_time);
                    logger.info((Object)("Final start_time : " + startTime));
                    Timestamp startTimestamp = startTime == null ? null : new Timestamp(startTime.getTime());
                    logger.info((Object)("Final startTimestamp : " + startTimestamp));
                    statement.setString(1, name);
                    statement.setString(2, mail_owner);
                    statement.setTimestamp(3, startTimestamp);
                    statement.setLong(4, duration);
                    statement.setString(5, clientIPAddress);
                    statement.setString(6, clientAgents);
                    statement.setLong(7, pin);
                    statement.setString(8, _roomowner);
                    statement.setString(9, emailid);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in parsing start_time : " + name + ", " + start_time + ", " + mail_owner), (Throwable)ex);
                    CoralMeetRoomStatus objCoralMeetRoomStatus4 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in parsing start_time : " + name + ", " + start_time + ", " + mail_owner + ", Error : " + ex.getMessage(), 0L, null);
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus4);
                    if (statement != null) {
                        if (var23_27 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var23_27.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                    if (connection == null) return responseEntity;
                    if (objRoom == null) {
                        connection.close();
                        return responseEntity;
                    }
                    try {
                        connection.close();
                        return responseEntity;
                    }
                    catch (Throwable throwable) {
                        ((Throwable)objRoom).addSuppressed(throwable);
                        return responseEntity;
                    }
                }
                int affectedRows = statement.executeUpdate();
                if (affectedRows == 0) {
                    logger.error((Object)("Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner));
                    CoralMeetRoomStatus objCoralMeetRoomStatus5 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner, 0L, null);
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus5);
                    return responseEntity;
                }
                try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                    if (!generatedKeys.next()) {
                        logger.error((Object)("Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner));
                        CoralMeetRoomStatus objCoralMeetRoomStatus6 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner, 0L, null);
                        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus6);
                        return responseEntity;
                    }
                    headerid = generatedKeys.getLong(1);
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable) {
                objRoom = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (objRoom != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)objRoom).addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            if (headerid > 0L) {
                logger.info((Object)"Conference room created sucessfully");
                objCoralMeetRoomStatus = new CoralMeetRoomStatus(headerid, name, mail_owner.isEmpty() ? "Coral" : mail_owner, start_time, duration, "Conference room created sucessfully", 0L, Long.toString(pin));
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCoralMeetRoomStatus);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner), (Throwable)ex);
            CoralMeetRoomStatus objCoralMeetRoomStatus7 = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner + ", Error : " + ex.getMessage(), 0L, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus7);
        }
        objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in creating room, Contact Administrator : " + name + ", " + start_time + ", " + mail_owner, 0L, null);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus);
    }

    /*
     * Exception decompiling
     */
    @PostMapping(path={"/createconferenceroom"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> createRandomConferenceRoom(@RequestParam(value="username") String username, @RequestParam(value="roomtype", defaultValue="0") int roomtype, @RequestParam(value="roomid", defaultValue="0") String roomidString, @RequestParam(value="date", defaultValue="") String date, @RequestParam(value="fromtime", defaultValue="") String fromtime, @RequestParam(value="totime", defaultValue="") String totime, @RequestParam(value="moderatoremail", defaultValue="") String moderatoremail) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 40[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @PostMapping(path={"/createconferenceroomv1"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> createRandomConferenceRoomV1(@RequestParam(value="username") String username, @RequestParam(value="roomtype", defaultValue="0") int roomtype, @RequestParam(value="roomid", defaultValue="0") String roomidString, @RequestParam(value="date", defaultValue="") String date, @RequestParam(value="fromtime", defaultValue="") String fromtime, @RequestParam(value="totime", defaultValue="") String totime, @RequestParam(value="moderatoremail", defaultValue="") String moderatoremail, @RequestParam(value="todate", defaultValue="") String todate, @RequestParam(value="repeat", defaultValue="0") String repeatString, @RequestParam(value="daystorepeat", defaultValue="0000000") String daystorepeat, @RequestParam(value="repeatrecordid", defaultValue="0") long repeatrecordid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 41[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] readfullcommmand(String cmd) {
        String[] cmd1 = new String[]{"/bin/sh", "-c", cmd};
        return cmd1;
    }

    public static void executeProsodyUserCommand(String cmd) throws IOException {
        String data = "";
        String s = "";
        try {
            String[] finalcommand = ControllerCoralMeet.readfullcommmand((String)cmd);
            logger.info((Object)(finalcommand[0] + finalcommand[1] + finalcommand[2]));
            Process p = Runtime.getRuntime().exec(finalcommand);
            p.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = br.readLine()) != null) {
                data = s + "\n" + data;
            }
            logger.info((Object)("data : " + data));
            p.destroy();
            if (!data.trim().isEmpty()) {
                logger.error((Object)("Exception in createProsodyUser : " + data));
                throw new IOException(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in createProsodyUser :" + ex.getMessage()));
            throw new IOException(ex.getMessage());
        }
    }

    public static String decrypt(String data) throws IOException {
        String returnValue = "";
        try {
            Base64 base64 = new Base64();
            String[] parts = data.split(":");
            IvParameterSpec iv = new IvParameterSpec(base64.decode(parts[1]));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(2, (Key)skeySpec, iv);
            byte[] decodedEncryptedData = base64.decode(parts[0]);
            byte[] original = cipher.doFinal(decodedEncryptedData);
            returnValue = new String(original);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in decrypt :" + ex.getMessage()), (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
        return returnValue;
    }

    public static String encrypt(String data) {
        try {
            Base64 base64 = new Base64();
            if (CIPHER_KEY.length() < CIPHER_KEY_LEN) {
                int numPad = CIPHER_KEY_LEN - CIPHER_KEY.length();
                for (int i = 0; i < numPad; ++i) {
                    CIPHER_KEY = CIPHER_KEY + "0";
                }
            } else if (CIPHER_KEY.length() > CIPHER_KEY_LEN) {
                CIPHER_KEY = CIPHER_KEY.substring(0, CIPHER_KEY_LEN);
            }
            IvParameterSpec initVector = new IvParameterSpec(CIPHER_IV.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(1, (Key)skeySpec, initVector);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            String base64_EncryptedData = base64.encodeToString(encryptedData);
            String base64_IV = base64.encodeToString(CIPHER_IV.getBytes("UTF-8"));
            return base64_EncryptedData + ":" + base64_IV;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in encrypt :" + ex.getMessage()), (Throwable)ex);
            return "";
        }
    }

    private String convertDateFormat(String inputDate) {
        String output = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat outputformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            date = df.parse(inputDate);
            output = outputformat.format(date);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in convertDateFormat : " + inputDate + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return output;
    }

    private long convertDateToEpoch(String inputDate) {
        long output = 0L;
        Date date = null;
        try {
            SimpleDateFormat stringtodate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = stringtodate.parse(inputDate);
            output = date.getTime();
            output /= 1000L;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in convertDateToEpoch : " + inputDate + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return output;
    }

    @GetMapping(path={"/conference/validateroom/{roomname}"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> validateroomname(@PathVariable(value="roomname") String roomname) {
        logger.info((Object)("Request for validating room name : roomname : " + roomname));
        ResponseObject objResponse = new ResponseObject();
        int isvalidroom = 0;
        if (!roomname.isEmpty()) {
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            try {
                String qry = "select count(*) from coralmeet.m_coralmeetrandomroomstatus where name = ? and roomexpired = 0;";
                isvalidroom = (Integer)db.queryForObject(qry, new Object[]{roomname}, Integer.class);
                if (isvalidroom > 0) {
                    logger.info((Object)("Room name is valid" + roomname));
                    objResponse = new ResponseObject(0, "Room name is valid", "VALID_ROOM");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in validating room name : roomname : " + roomname + ", Error : " + ex.getMessage()), (Throwable)ex);
            }
        }
        logger.info((Object)("Invalid room name. Redirecting to expired.php" + roomname));
        try {
            URL requestURL = new URL(this.request.getRequestURL().toString());
            String host = requestURL.getHost();
            if (!host.isEmpty()) {
                String uri = "";
                uri = "http://" + host + "/qTalk/expired.php";
                URI finaluri = new URI(uri);
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.add("Cache-Control", "no-cache");
                httpHeaders.setLocation(finaluri);
                return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.SEE_OTHER);
            }
        }
        catch (MalformedURLException ex) {
            logger.error((Object)("Error in validating room name : roomname : " + roomname + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in validating room name : roomname : " + roomname + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        objResponse = new ResponseObject(1, "Invalid room name.", "INVALID_ROOM");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @DeleteMapping(path={"/conference/{id}"}, produces={"application/json"})
    public ResponseEntity<CoralMeetRoomStatus> deleteConferenceRoom(@PathVariable(value="id") long id) {
        logger.info((Object)("Gracefully deleting request for room id : " + id));
        String qry = "";
        String roomname = "";
        long pin = 0L;
        String _prosodydomain = "";
        if (id > 0L) {
            try {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                qry = "select pin from coralmeet.m_coralmeetroomstatus where id = ?";
                try {
                    pin = (Long)db.query(qry, new Object[]{id}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in fetching PIN details for room id : " + id + ", Error : " + ex.getMessage()), (Throwable)ex);
                }
                qry = "delete from coralmeet.m_coralmeetroomstatus where id = ?";
                db.update(qry, new Object[]{id});
                CoralMeetRoomStatus objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Room with id " + id + " deleted.", 0L, null);
                try {
                    qry = "select name from coralmeet.m_coralmeetrandomroomstatus where pin = ?";
                    try {
                        roomname = (String)db.query(qry, new Object[]{pin}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in fetching PIN details for room id : " + id + ", Error : " + ex.getMessage()), (Throwable)ex);
                    }
                    if (!roomname.isEmpty()) {
                        String usercommand;
                        CoralMeetSystemConfig meetconfig = this.meetConfig;
                        if (meetconfig != null) {
                            _prosodydomain = meetconfig.getProsodydomain();
                            logger.info((Object)("Prosody Server Domain : " + _prosodydomain));
                        }
                        if (!(usercommand = "prosodyctl deluser " + roomname + "@" + _prosodydomain).isEmpty() && !_prosodydomain.isEmpty()) {
                            ControllerCoralMeet.executeProsodyUserCommand((String)usercommand);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in deleting moderator access after conference got over " + ex.getMessage()), (Throwable)ex);
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCoralMeetRoomStatus);
            }
            catch (Exception ex) {
                CoralMeetRoomStatus objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Error in room id deletion : " + id + ", Error : " + ex.getMessage(), 0L, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus);
            }
        }
        CoralMeetRoomStatus objCoralMeetRoomStatus = new CoralMeetRoomStatus(0L, "", "", "", 0L, "Invalid room id for deletion : " + id, 0L, null);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)objCoralMeetRoomStatus);
    }

    @GetMapping(path={"/registration/{email}"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> isEmailExist(@PathVariable(value="email") String email) {
        ResponseObject objResponse;
        block10: {
            logger.info((Object)("Request for verifyig email id  : " + email));
            int isEmailExists = 0;
            objResponse = new ResponseObject();
            try {
                email = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)email));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objResponse = new ResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            logger.info((Object)("Request for verifyig email id  : " + email));
            if (email.isEmpty()) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (email.split("@").length != 2 && email.split(".").length != 2) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (!email.isEmpty()) {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                try {
                    String qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where lower(email) = ?;";
                    isEmailExists = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase()}, Integer.class);
                    if (isEmailExists > 0) {
                        objResponse = new ResponseObject(0, "Email already registered, please try with another email id", "EMAIL_NOT_AVAILABLE");
                        logger.info((Object)("Response for verifyig email id  : " + email + ", Response : Email already registered, please try with another email id. EMAIL_NOT_AVAILABLE"));
                    } else {
                        objResponse = new ResponseObject(0, "Email Id available.", "EMAIL_AVAILABLE");
                        logger.info((Object)("Response for verifyig email id  : " + email + ", Response : EMAIL_AVAILABLE"));
                    }
                    if (objResponse != null) {
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block10;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig email id  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Error verifyig email id  : " + email + ", Error : " + ex.getMessage(), "EMAIL_NOT_AVAILABLE");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            objResponse = new ResponseObject(1, "Please provide email id." + email, null);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @GetMapping(path={"/registration/{email}/{username}"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> isEmailExist(@PathVariable(value="email") String email, @PathVariable(value="username") String username) {
        ResponseObject objResponse;
        block12: {
            logger.info((Object)("Request for verifyig email id, username  : " + email + ", " + username));
            int isEmailExists = 0;
            objResponse = new ResponseObject();
            try {
                email = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)email));
                username = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)username));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objResponse = new ResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            logger.info((Object)("Request for verifyig email id  : " + email));
            if (email.isEmpty() || username.isEmpty()) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (email.split("@").length != 2 && email.split(".").length != 2) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (!email.isEmpty()) {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                try {
                    String qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where email = ?;";
                    isEmailExists = (Integer)db.queryForObject(qry, new Object[]{email}, Integer.class);
                    if (isEmailExists > 0) {
                        objResponse = new ResponseObject(0, "Email already exist", "EMAIL_NOT_AVAILABLE");
                        logger.info((Object)("Response for verifyig email id  : " + email + ", Response : EMAIL_NOT_AVAILABLE"));
                    } else {
                        qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where username = ?;";
                        isEmailExists = (Integer)db.queryForObject(qry, new Object[]{username}, Integer.class);
                        if (isEmailExists > 0) {
                            objResponse = new ResponseObject(0, "User already exist", "EMAIL_NOT_AVAILABLE");
                            logger.info((Object)("Response for verifyig user name  : " + username + ", Response : EMAIL_NOT_AVAILABLE"));
                        } else {
                            objResponse = new ResponseObject(0, "Email/User not found in db", "EMAIL_AVAILABLE");
                            logger.info((Object)("Response for verifyig user name  : " + username + ", Response : EMAIL_AVAILABLE"));
                        }
                    }
                    if (objResponse != null) {
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block12;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig email id  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Error verifyig email id  : " + email + ", Error : " + ex.getMessage(), "EMAIL_NOT_AVAILABLE");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            objResponse = new ResponseObject(1, "No Email Provided : " + email, null);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    /*
     * Exception decompiling
     */
    @PostMapping(path={"/registration/registeremail"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> registeruser(@RequestParam(value="email") String email) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(path={"/registration"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> registeruser(@RequestParam(value="email") String email, @RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        String _password = "***************";
        logger.info((Object)("Request for registering username & password : email,username,password : " + email + ", " + username + ", " + _password));
        int emailAlreadyExist = 1;
        String qry = "";
        long headerid = 0L;
        ResponseObject objResponse = new ResponseObject();
        int autoenableuser = 0;
        try {
            email = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)email));
            username = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)username));
            password = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)password));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objResponse = new ResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        logger.info((Object)("Request for registering username & password : email,username,password : " + email + ", " + username + ", " + _password));
        String clientIPAddress = "";
        String clientAgents = "";
        String verifyemailtext = "";
        String hashedPassword = "";
        String p_userpassword = "";
        if (email.isEmpty() || username.isEmpty() || password.isEmpty()) {
            objResponse = new ResponseObject(1, "Invalid Request!., Please provide all values.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        if (reservedUsers.contains(username)) {
            objResponse = new ResponseObject(1, "Please try with another username!.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        if (email.split("@").length != 2 && email.split(".").length != 2) {
            logger.info((Object)("Invalid email id  : " + email));
            objResponse = new ResponseObject(1, "Invalid email id!.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where lower(email) = ? and emailverified  = ?;";
        try {
            emailAlreadyExist = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase(), 1}, Integer.class);
        }
        catch (Exception ex) {
            emailAlreadyExist = 0;
            logger.error((Object)("Error in checking either email already exist, email : " + email), (Throwable)ex);
        }
        if (emailAlreadyExist == 0) {
            objResponse = new ResponseObject(0, "Email does not exists", "EMAIL_NOT_AVAILABLE");
            logger.info((Object)("Response for verifyig email id  : " + email + ", Email does not exists : EMAIL_NOT_AVAILABLE"));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        emailAlreadyExist = 0;
        qry = "";
        qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where lower(email) = ? and coalesce(username,'') <> '';";
        try {
            emailAlreadyExist = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase()}, Integer.class);
        }
        catch (Exception ex) {
            emailAlreadyExist = 1;
            logger.error((Object)("Error in checking either username already exist, email : " + email), (Throwable)ex);
        }
        if (emailAlreadyExist > 0) {
            objResponse = new ResponseObject(0, "User already exists for this email", "INVALID_REQUEST");
            logger.info((Object)("Response for verifyig username  : " + email + ", User already exists for this mail : INVALID_REQUEST"));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        emailAlreadyExist = 0;
        qry = "";
        qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where lower(username) = ?;";
        try {
            emailAlreadyExist = (Integer)db.queryForObject(qry, new Object[]{username.toLowerCase()}, Integer.class);
        }
        catch (Exception ex) {
            emailAlreadyExist = 1;
            logger.error((Object)("Error in checking either username already exist, email : " + email), (Throwable)ex);
        }
        if (emailAlreadyExist > 0) {
            objResponse = new ResponseObject(0, "Username already exists", "USER_NOT_AVAILABLE");
            logger.info((Object)("Response for verifyig username  : " + email + ", User already exists : USER_NOT_AVAILABLE"));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        try {
            clientIPAddress = this.getClientIpAddress(this.request);
            clientAgents = this.request.getHeader("User-Agent");
            logger.info((Object)("Request comes from ip & user agent : " + clientIPAddress + ", " + clientAgents));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting client ip address  : " + email + ", " + username + ", " + _password));
        }
        try {
            for (int emailtext = 0; emailtext < 3; ++emailtext) {
                verifyemailtext = verifyemailtext + ControllerCoralMeet.generateRandomStringByUUIDNoDash();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating verify email text  : " + email + ", " + username + ", " + _password));
        }
        try {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            hashedPassword = passwordEncoder.encode((CharSequence)password);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in creating new registration, Contact Administrator : " + email + ", " + username + ", " + _password));
            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        if (hashedPassword.isEmpty()) {
            logger.error((Object)("Error in creating new registration, Password not generated. Contact Administrator : " + email + ", " + username + ", " + _password));
            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        try {
            p_userpassword = EncryptDecrypt.encrypt((String)password);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in creating new registration, Contact Administrator : " + email + ", " + username + ", " + _password));
            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        try {
            CoralMeetSystemConfig meetconfig = this.meetConfig;
            if (meetconfig != null) {
                autoenableuser = meetconfig.getAutoenableuser();
                logger.info((Object)("autoenableuser : " + autoenableuser));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting autoenableuser value : " + email + ", " + username + ", " + _password));
        }
        try {
            qry = "";
            qry = "update coralmeet.m_coralmeetregisteredusers set username = ? ,password = ? ,registeredip = registeredip || ' : ' || ? ,registeredbrowseragent = registeredbrowseragent || ' : ' || ?, recordlastupdatedby = ?";
            if (autoenableuser == 1) {
                qry = qry + ",accountenabled = 1,remarks = 'AUTO_ENABLED_V'";
            }
            qry = qry + " where email = ?";
            try (Connection connection = db.getDataSource().getConnection();
                 PreparedStatement statement = connection.prepareStatement(qry, 1);){
                statement.setString(1, username);
                statement.setString(2, hashedPassword);
                statement.setString(3, clientIPAddress);
                statement.setString(4, clientAgents);
                statement.setString(5, p_userpassword);
                statement.setString(6, email);
                int affectedRows = statement.executeUpdate();
                if (affectedRows == 0) {
                    logger.error((Object)("Error in updating registration details, Contact Administrator : " + email + ", " + username + ", " + _password));
                    objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    return responseEntity;
                }
                if (connection != null) {
                    connection.close();
                }
            }
            logger.info((Object)"Your details updated sucessfully.");
            objResponse = new ResponseObject(0, "Username & password updated successfully", "USER_REGISTERED");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating registration details, Contact Administrator : " + email + ", " + username + ", " + _password));
            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
    }

    @GetMapping(path={"/registration/verifyuser/{verifycode}"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> isVerifiedUser(@PathVariable(value="verifycode") String verifycode) {
        ResponseObject objResponse;
        block13: {
            logger.info((Object)("Request for verifying user  : " + verifycode));
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            objResponse = new ResponseObject();
            int isVerifiedUser = 0;
            int emailverificationfor = 0;
            String emailid = "";
            if (!verifycode.isEmpty()) {
                try {
                    String qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where verifyemailtext = ? and (emailverified = ? or varificationforforgotpassword = ?) and (emailsent = ? or emailsentforvarificationforforgotpassword = ?);";
                    isVerifiedUser = (Integer)db.queryForObject(qry, new Object[]{verifycode, 0, 1, 1, 1}, Integer.class);
                    if (isVerifiedUser > 0) {
                        qry = "";
                        qry = "select case when (emailverified = 0 and varificationforforgotpassword = 1) then 1  when (emailverified = 1 and varificationforforgotpassword = 1) then 1 else 0 end as type from coralmeet.m_coralmeetregisteredusers where verifyemailtext = ?";
                        emailverificationfor = (Integer)db.query(qry, new Object[]{verifycode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                        qry = "";
                        qry = "select email from coralmeet.m_coralmeetregisteredusers where verifyemailtext = ?";
                        emailid = (String)db.query(qry, new Object[]{verifycode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                        qry = "";
                        try {
                            if (emailverificationfor == 0) {
                                qry = "update coralmeet.m_coralmeetregisteredusers set verifyemailtext = '',emailverified = ? where verifyemailtext = ?";
                                db.update(qry, new Object[]{1, verifycode});
                            } else {
                                qry = "update coralmeet.m_coralmeetregisteredusers set verifyemailtext = '',varificationforforgotpassword = ? ,emailsentforvarificationforforgotpassword = ? where verifyemailtext = ?";
                                db.update(qry, new Object[]{0, 0, verifycode});
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error verifyig user  : " + verifycode + ", Error : " + ex.getMessage()), (Throwable)ex);
                            objResponse = new ResponseObject(1, "System Uunable to verify you. Try again!.", "EMAIL_NOT_VERIFIED");
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                        }
                        String _data = emailverificationfor == 0 ? "EMAIL_VERIFIED" : "EMAIL_VERIFIED_RESET_PASSWORD";
                        objResponse = new ResponseObject(0, emailid, _data);
                        logger.info((Object)("Response for verifyig user  : " + verifycode + ", Response : " + _data));
                    } else {
                        objResponse = new ResponseObject(0, "Invalid request", "EMAIL_NOT_VERIFIED");
                        logger.info((Object)("Response for verifyig user  : " + verifycode + ", Response : EMAIL_NOT_VERIFIED"));
                    }
                    if (objResponse != null) {
                        URL requestURL = new URL(this.request.getRequestURL().toString());
                        String host = requestURL.getHost();
                        if (!host.isEmpty()) {
                            CoralMeetSystemConfig meetconfig = this.meetConfig;
                            if (meetconfig != null) {
                                host = meetconfig.getProsodydomain();
                                logger.info((Object)("host : " + host));
                            }
                            if (host.isEmpty()) {
                                logger.error((Object)"Server details not defined in system configuration., Contact administrator.");
                                objResponse = new ResponseObject(1, "Server details not defined in system configuration., Contact administrator.", "INVALID_REQUEST");
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                            String uri = "";
                            uri = objResponse.getData().equals("EMAIL_VERIFIED") ? "https://" + host + "/qTalk/register.php?email=" + objResponse.getMessage() : (objResponse.getData().equals("EMAIL_VERIFIED_RESET_PASSWORD") ? "https://" + host + "/qTalk/resetpassword.php?email=" + objResponse.getMessage() : "https://" + host + "/qTalk/notverified.php");
                            ArrayList<String> emailValue = new ArrayList<String>();
                            emailValue.add(objResponse.getMessage());
                            URI finaluri = new URI(uri);
                            HttpHeaders httpHeaders = new HttpHeaders();
                            httpHeaders.add("Cache-Control", "no-cache");
                            httpHeaders.setLocation(finaluri);
                            httpHeaders.put("email", emailValue);
                            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.SEE_OTHER);
                        }
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block13;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig user  : " + verifycode + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "EMAIL_NOT_VERIFIED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            logger.error((Object)("Please provide verifying string : " + verifycode));
            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "EMAIL_NOT_VERIFIED");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    public List<CoralMeetLicenseDetails> getLicenseDetails(JdbcTemplate db, String username) {
        ArrayList<CoralMeetLicenseDetails> licensedetails = new ArrayList<CoralMeetLicenseDetails>();
        List roomlicensedetails = null;
        String qry = "";
        if (db != null) {
            try {
                qry = "select firstname,roomtypeid,licensedforrooms from coralmeet.fn_getavailableroomcount(?);";
                roomlicensedetails = db.queryForList(qry, new Object[]{username.toLowerCase()});
                if (roomlicensedetails.size() > 0) {
                    for (Map objRoom : roomlicensedetails) {
                        try {
                            CoralMeetLicenseDetails objCoralMeetLicenseDetails = new CoralMeetLicenseDetails(objRoom.get("firstname").toString(), Integer.parseInt(objRoom.get("roomtypeid").toString()), Long.parseLong(objRoom.get("licensedforrooms").toString()));
                            licensedetails.add(objCoralMeetLicenseDetails);
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error while fetching license details(getLicenseDetails) for  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    logger.info((Object)("Total user wise license available : " + licensedetails.size()));
                } else {
                    logger.info((Object)("No user licesnce available for : " + username));
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error while fetching license details(getLicenseDetails) for  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
            }
        }
        return licensedetails;
    }

    @GetMapping(path={"/registration/validateuser/{username}/{password}"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> validateuser(@PathVariable(value="username") String username, @PathVariable(value="password") String password) {
        ResponseObject objResponse;
        block23: {
            logger.info((Object)("Request for validating user  : " + username));
            String _hashedPassword = "";
            objResponse = new ResponseObject();
            long conferenceroomlicensedfor = 0L;
            String validlicense = "";
            String successresponse = "1:0:0,0,0,0";
            long licensedforroomstype1 = 0L;
            try {
                username = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)username));
                password = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)password));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objResponse = new ResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            logger.info((Object)("Request for validating user  : " + username));
            if (!username.isEmpty() && !password.isEmpty()) {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                try {
                    String qry = "select coalesce(password,'') as password from coralmeet.m_coralmeetregisteredusers where accountenabled = ? and accountdisabledbysystem = ? and lower(username) = ?;";
                    _hashedPassword = (String)db.query(qry, new Object[]{1, 0, username.toLowerCase()}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    if (!_hashedPassword.isEmpty()) {
                        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                        if (passwordEncoder.matches((CharSequence)password, _hashedPassword)) {
                            try {
                                List licensedetails = new ArrayList();
                                CoralMeetSystemConfig meetconfig = this.meetConfig;
                                if (meetconfig != null) {
                                    conferenceroomlicensedfor = meetconfig.getMaximumconferenceroom();
                                    logger.info((Object)("Conference Room License Available For Creating Maximum : " + conferenceroomlicensedfor + " Room(s)"));
                                }
                                if (conferenceroomlicensedfor > 0L) {
                                    validlicense = "1";
                                    validlicense = validlicense + ":";
                                    validlicense = validlicense + conferenceroomlicensedfor;
                                    validlicense = validlicense + ":";
                                    validlicense = validlicense + "0,0,0,0";
                                } else {
                                    try {
                                        logger.info((Object)"Checking user wise license available or not.");
                                        licensedetails = this.getLicenseDetails(db, username);
                                        if (licensedetails.size() > 0) {
                                            for (CoralMeetLicenseDetails data : licensedetails) {
                                                if (data.getRoomtypeid() != 1) continue;
                                                licensedforroomstype1 = data.getLicensedforrooms();
                                                break;
                                            }
                                        }
                                        if (licensedforroomstype1 > 0L) {
                                            logger.info((Object)("Conference Room User Wise License Available For Creating Maximum : " + licensedforroomstype1 + " Room(s)"));
                                            validlicense = "1";
                                            validlicense = validlicense + ":";
                                            validlicense = validlicense + licensedforroomstype1;
                                            validlicense = validlicense + ":";
                                            validlicense = validlicense + "0,0,0,0";
                                        }
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)("Error while fetching license details for  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                                    }
                                }
                                if (!validlicense.isEmpty()) {
                                    successresponse = validlicense;
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error while fetching license details for  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                            }
                            try {
                                successresponse = ControllerCoralMeet.encrypt((String)successresponse);
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in encrypt response : " + ex.getMessage()), (Throwable)ex);
                                objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "USER_NOT_VERIFIED");
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                            objResponse = new ResponseObject(0, successresponse, "USER_VERIFIED");
                            logger.info((Object)("Response for validating user  : " + username + ", Valid user , Response : " + successresponse + ", USER_VERIFIED"));
                        } else {
                            objResponse = new ResponseObject(0, "Invalid password", "USER_NOT_VERIFIED");
                            logger.info((Object)("Response for validating user  : " + username + ", Invalid password, Response : USER_NOT_VERIFIED"));
                        }
                    } else {
                        objResponse = new ResponseObject(0, "Invalid user or admin not approved your request yet. Once approved mail will be sent to you.", "USER_NOT_VERIFIED");
                        logger.info((Object)("Response for validating user  : " + username + ", \"Invalid user or admin not approved your request yet. Once approved mail will be sent to you.\", Response : USER_NOT_VERIFIED"));
                    }
                    if (objResponse != null) {
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block23;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig user  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Error verifyig user  : " + username + ", Error : " + ex.getMessage(), "USER_NOT_VERIFIED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            logger.error((Object)("Please provide all details : " + username));
            objResponse = new ResponseObject(1, "Please provide all details!.", "USER_NOT_VERIFIED");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @PostMapping(path={"/registration/generateemailforpasswordchange"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> generateemailforpasswordchange(@RequestParam(value="email") String email) {
        ResponseObject objResponse;
        block16: {
            logger.info((Object)("Request for generating email/username for password reset for  email id  : " + email));
            String verifyemailtext = "";
            int isEmailExists = 0;
            objResponse = new ResponseObject();
            try {
                email = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)email));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objResponse = new ResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            logger.info((Object)("Request for generating email/username for password reset for email id  : " + email));
            if (email.isEmpty()) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (!email.isEmpty()) {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                try {
                    String qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where (lower(email) = ? or lower(username) = ?) and accountenabled = ? and accountdisabledbysystem = ? ;";
                    isEmailExists = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase(), email.toLowerCase(), 1, 0}, Integer.class);
                    if (isEmailExists > 0) {
                        qry = "";
                        qry = "update coralmeet.m_coralmeetregisteredusers set verifyemailtext = ?,varificationforforgotpassword = ?,emailsentforvarificationforforgotpassword = ?,passwordchangerequestepoch = extract(epoch from now()::timestamp(0) with time zone) where (lower(email) = ? or lower(username) = ?)";
                        try {
                            try {
                                for (int emailtext = 0; emailtext < 3; ++emailtext) {
                                    verifyemailtext = verifyemailtext + ControllerCoralMeet.generateRandomStringByUUIDNoDash();
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating verify email text  : " + email));
                            }
                            if (!verifyemailtext.isEmpty()) {
                                db.update(qry, new Object[]{verifyemailtext, 1, 0, email.toLowerCase(), email.toLowerCase()});
                            } else {
                                objResponse = new ResponseObject(0, "Error in link generation", "EMAIL_NOT_VERIFIED");
                                logger.info((Object)("Response for verifyig email id  : " + email + ",Error in link generation, Response : EMAIL_NOT_VERIFIED"));
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error verifyig user  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "EMAIL_NOT_VERIFIED");
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                        }
                        objResponse = new ResponseObject(0, "Email for password reset sent to you!.", "EMAIL_VERIFIED");
                        logger.info((Object)("Email for password reset sent to mail id belongs to : " + email + ", EMAIL_VERIFIED"));
                    } else {
                        objResponse = new ResponseObject(0, "Either you are not registered with us or user account is not enabled.", "USER_NOT_VERIFIED");
                        logger.info((Object)("Response for verifyig email id  : " + email + ", Either you are not registered with us or user account is not enabled. : USER_NOT_VERIFIED"));
                    }
                    if (objResponse != null) {
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block16;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig email id  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "USER_NOT_VERIFIED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            objResponse = new ResponseObject(1, "Please provide details!." + email, null);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @PostMapping(path={"/registration/passwordchange"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> passwordchange(@RequestParam(value="email") String email, @RequestParam(value="password") String password) {
        ResponseObject objResponse;
        block20: {
            logger.info((Object)("Request for updating password for email id  : " + email));
            String verifyemailtext = "";
            int isEmailExists = 0;
            String hashedPassword = "";
            String p_userpassword = "";
            String p_username = "";
            objResponse = new ResponseObject();
            try {
                email = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)email));
                password = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)password));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objResponse = new ResponseObject(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            logger.info((Object)("Request for updating password for email id  : " + email));
            if (email.split("@").length != 2 && email.split(".").length != 2) {
                logger.info((Object)("Invalid email id  : " + email));
                objResponse = new ResponseObject(1, "Invalid email id  : " + email, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
            }
            if (!email.isEmpty() && !password.isEmpty()) {
                JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
                try {
                    String qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where (lower(email) = ? or lower(username) = ?) and accountenabled = ? ;";
                    isEmailExists = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase(), email.toLowerCase(), 1}, Integer.class);
                    if (isEmailExists > 0) {
                        isEmailExists = 0;
                        qry = "select count(*) from coralmeet.m_coralmeetregisteredusers where (passwordchangerequestepoch + 300) > extract(epoch from now()::timestamp(0) with time zone) and (lower(email) = ? or lower(username) = ?) and accountenabled = ? ;";
                        isEmailExists = (Integer)db.queryForObject(qry, new Object[]{email.toLowerCase(), email.toLowerCase(), 1}, Integer.class);
                        if (isEmailExists == 0) {
                            objResponse = new ResponseObject(0, "You have not request for password change.", "EMAIL_NOT_VERIFIED");
                            logger.info((Object)("Response for verifyig email id  : " + email + ", Response : You have not request for password change. EMAIL_NOT_VERIFIED"));
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                        }
                        qry = "select coalesce(username,'') as username from coralmeet.m_coralmeetregisteredusers where accountenabled = ? and (lower(email) = ? or lower(username) = ?);";
                        p_username = (String)db.query(qry, new Object[]{1, email.toLowerCase(), email.toLowerCase()}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                        qry = "";
                        qry = "update coralmeet.m_coralmeetregisteredusers set password = ?, recordlastupdatedby = ?  where(lower(email) = ? or lower(username) = ?)";
                        try {
                            try {
                                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                                hashedPassword = passwordEncoder.encode((CharSequence)password);
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating password, Contact Administrator : " + email));
                                objResponse = new ResponseObject(1, "Error in updating password!. Try again" + email, null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                            try {
                                p_userpassword = EncryptDecrypt.encrypt((String)password);
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in creating new registration, Contact Administrator : " + email + ", "));
                                objResponse = new ResponseObject(1, "Error in updating password!. Try again", null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                            if (hashedPassword.isEmpty()) {
                                logger.error((Object)("Error in generating password, Contact Administrator : " + email));
                                objResponse = new ResponseObject(1, "Error in updating password!. Try again", null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                            try {
                                db.update(qry, new Object[]{hashedPassword, p_userpassword, email.toLowerCase(), email.toLowerCase()});
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in updating password, Contact Administrator : " + email));
                                objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", null);
                                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error verifyig user  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                            objResponse = new ResponseObject(1, "Sorry!. Some Error. Please give another try.", "EMAIL_NOT_VERIFIED");
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                        }
                        objResponse = new ResponseObject(0, "Password reset for email id : " + email, "PASSWORD_CHANGED");
                        logger.info((Object)("Password reset for email id : " + email + " : PASSWORD_CHANGED"));
                    } else {
                        objResponse = new ResponseObject(0, "Invalid email id.", "EMAIL_NOT_VERIFIED");
                        logger.info((Object)("Response for verifyig email id  : " + email + ", Response : EMAIL_NOT_VERIFIED"));
                    }
                    if (objResponse != null) {
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                    }
                    break block20;
                }
                catch (Exception ex) {
                    logger.error((Object)("Error verifyig email id  : " + email + ", Error : " + ex.getMessage()), (Throwable)ex);
                    objResponse = new ResponseObject(1, "Error verifyig email id  : " + email + ", Error : " + ex.getMessage(), "USER_NOT_VERIFIED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
                }
            }
            objResponse = new ResponseObject(1, "No Email Provided : " + email, null);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @PostMapping(path={"/registration/verifymeetingdetails"}, produces={"application/json"})
    public ResponseEntity<ResponseObject> verifymeetingdetails(@RequestParam(value="meetingid") String meetingid, @RequestParam(value="meetingpin") String meetingpin, @RequestParam(value="username") String username, @RequestParam(value="password", defaultValue="") String password) {
        logger.info((Object)("Request for verify meeting details : " + meetingid + " : " + meetingpin + " : " + username));
        String qry = "";
        ResponseObject objResponse = new ResponseObject();
        List meetingRoomDetails = null;
        boolean ismoderator = false;
        String _hashedPassword = "";
        int p_meetingpin = 0;
        String p_mail_owner = "";
        String p_start_time = "";
        long p_duration = 0L;
        String p_username = "";
        String p_emailid = "";
        String p_clientIPAddress = "";
        String p_clientAgents = "";
        try {
            p_meetingpin = Integer.parseInt(meetingpin);
        }
        catch (Exception ex) {
            p_meetingpin = 0;
            logger.error((Object)("Error in verify meeting pin : " + meetingid + " : " + meetingpin + " : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
            objResponse = new ResponseObject(1, "Invalid room details.", "INVALID_ROOM");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        if (meetingid.isEmpty() || p_meetingpin == 0 || username.isEmpty()) {
            logger.info((Object)"Invalid details. Redirecting to expired.php");
            objResponse = new ResponseObject(1, "Invalid room details.", "INVALID_ROOM");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        qry = "select mail_owner,start_time,duration,username,emailid from coralmeet.m_coralmeetroomstatus where name = ? and pin = ? and (start_time + duration * interval '1 second') > now()::timestamp(0) limit 1;";
        meetingRoomDetails = db.queryForList(qry, new Object[]{meetingid, p_meetingpin});
        if (meetingRoomDetails.size() == 0) {
            logger.info((Object)"Invalid details. Redirecting to expired.php");
            objResponse = new ResponseObject(1, "Invalid room details.", "INVALID_ROOM");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
        }
        logger.info((Object)"Valid room details, Participant is about to join metting room.");
        logger.info((Object)"============== Checking either participant is moderator or not ===========");
        if ((((Map)meetingRoomDetails.get(0)).get("username").toString().equalsIgnoreCase(username) || ((Map)meetingRoomDetails.get(0)).get("emailid").toString().equalsIgnoreCase(username)) && !password.isEmpty()) {
            qry = "select coalesce(password,'') as password from coralmeet.m_coralmeetregisteredusers where accountenabled = ? and accountdisabledbysystem = ? and (username = ? or email = ?);";
            _hashedPassword = (String)db.query(qry, new Object[]{1, 0, username, username}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!_hashedPassword.isEmpty()) {
                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                if (passwordEncoder.matches((CharSequence)password, _hashedPassword)) {
                    logger.info((Object)("Response for validating user  : " + username + ", Valid user : \"MODERATOR\", Response : USER_VERIFIED"));
                    ismoderator = true;
                } else {
                    logger.info((Object)("Response for validating user  : " + username + ", Invalid password, Response : USER_NOT_VERIFIED"));
                }
            } else {
                logger.info((Object)("Response for validating user  : " + username + ", \"Invalid user or admin not approved your request yet. Once approved mail will be sent to you.\", Response : USER_NOT_VERIFIED"));
            }
        }
        logger.info((Object)"============== Checking either participant is moderator or not end ===========");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat conferenceStartTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmm'Z'");
        p_mail_owner = ((Map)meetingRoomDetails.get(0)).get("mail_owner").toString();
        try {
            p_start_time = conferenceStartTime.format(formatter.parse(((Map)meetingRoomDetails.get(0)).get("start_time").toString()));
        }
        catch (ParseException ex) {
            logger.error((Object)("Error in parsing start_time  " + ex.getMessage()), (Throwable)ex);
        }
        p_duration = Long.parseLong(((Map)meetingRoomDetails.get(0)).get("duration").toString());
        p_username = ((Map)meetingRoomDetails.get(0)).get("username").toString();
        p_emailid = ((Map)meetingRoomDetails.get(0)).get("emailid").toString();
        try {
            p_clientIPAddress = this.getClientIpAddress(this.request);
            p_clientAgents = this.request.getHeader("User-Agent");
            logger.info((Object)("Request comes from ip & user agent : " + p_clientIPAddress + ", " + p_clientAgents));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting client ip address  " + ex.getMessage()), (Throwable)ex);
        }
        logger.info((Object)("Meeting ID : " + meetingid));
        logger.info((Object)("Meeting PIN : " + meetingpin));
        logger.info((Object)("UserName/Email ID : " + username));
        logger.info((Object)("Moderator : " + ismoderator));
        objResponse = new ResponseObject(0, "Valid room details.", "VALID_ROOM_DETAILS");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objResponse);
    }

    @GetMapping(path={"/registration/getbookedrooms/{date}/{username}"}, produces={"application/json"})
    public ResponseEntity<List<CoralMeetBookedRoomDetails>> getBookedRooms(@PathVariable(value="date") String date, @PathVariable(value="username") String username) {
        logger.info((Object)("Request for getting booked room list : date,username : " + date + ", " + username));
        long conferenceroomlicensedfor = 0L;
        int isuserlicense = -1;
        ArrayList<CoralMeetBookedRoomDetails> objCoralMeetBookedRoomDetails = new ArrayList<CoralMeetBookedRoomDetails>();
        try {
            username = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)username));
            date = ControllerCoralMeet.decrypt((String)ControllerCoralMeet.decodeString((String)date));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(objCoralMeetBookedRoomDetails);
        }
        logger.info((Object)("Request for getting booked room list : date,username : " + date + ", " + username));
        if (!date.isEmpty() && !username.isEmpty()) {
            List roomDetails = null;
            JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
            try {
                block15: {
                    CoralMeetSystemConfig meetconfig = this.meetConfig;
                    if (meetconfig != null) {
                        conferenceroomlicensedfor = meetconfig.getMaximumconferenceroom();
                        logger.info((Object)("Conference Room License Available For Creating Maximum : " + conferenceroomlicensedfor + " Room(s)"));
                    }
                    if (conferenceroomlicensedfor > 0L) {
                        isuserlicense = 0;
                    } else {
                        try {
                            logger.info((Object)"Checking user wise license available or not.");
                            List licensedetails = new ArrayList();
                            licensedetails = this.getLicenseDetails(db, username);
                            if (licensedetails.size() <= 0) break block15;
                            for (CoralMeetLicenseDetails data : licensedetails) {
                                if (data.getRoomtypeid() != 1) continue;
                                isuserlicense = 1;
                                break;
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error while fetching license details for  : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                if (isuserlicense > -1) {
                    String qry = "select roomtype,roomid,bookingdatefrom,bookingdateto from coralmeet.fn_getbookedroomdetails(?,?,?) order by roomtype,roomid,bookingdatefrom,bookingdateto;";
                    roomDetails = db.queryForList(qry, new Object[]{username.toLowerCase(), date, isuserlicense});
                    for (Map objRoom : roomDetails) {
                        try {
                            CoralMeetBookedRoomDetails objCoralMeetRoomStatus = new CoralMeetBookedRoomDetails(objRoom.get("roomtype").toString(), objRoom.get("roomid").toString(), objRoom.get("bookingdatefrom").toString(), objRoom.get("bookingdateto").toString());
                            objCoralMeetBookedRoomDetails.add(objCoralMeetRoomStatus);
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error checking Booked room list : date,username : " + date + ", " + username + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(objCoralMeetBookedRoomDetails);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error checking Booked room list : date,username : " + date + ", " + username + ex.getMessage()), (Throwable)ex);
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(objCoralMeetBookedRoomDetails);
    }

    public static String generateRandomStringByUUIDNoDash() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static String decodeString(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.decodeBase64((byte[])p_message.getBytes());
            _ret = new String(bytesEncoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    public void createconferencedetails(String name, String mail_owner, String start_time, long duration, String username, String emailid, int ismoderator, long pin, String registeredip, String registeredbrowseragent, String message, int inconference, boolean p_audio_muted, boolean p_video_muted, String p_videotype, boolean p_handraised) {
        logger.info((Object)"================= In createconferencedetails Function ====================");
        long roomAlreadyExist = 0L;
        SimpleDateFormat formatter6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        long headerid = 0L;
        String qry = "";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            qry = "insert into coralmeet.t_conferencedetails(name,mail_owner,start_time,duration,username,emailid,ismoderator,pin,registeredip,registeredbrowseragent,message,inconference,audio_muted,video_muted,videotype,desktopshared,handraised)values(?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            try (Connection connection = db.getDataSource().getConnection();
                 PreparedStatement statement = connection.prepareStatement(qry, 1);){
                try {
                    statement.setString(1, name);
                    statement.setString(2, mail_owner);
                    statement.setLong(3, duration);
                    statement.setString(4, username);
                    statement.setString(5, emailid);
                    statement.setInt(6, ismoderator);
                    statement.setLong(7, pin);
                    statement.setString(8, registeredip);
                    statement.setString(9, registeredbrowseragent);
                    statement.setString(10, message);
                    statement.setInt(11, inconference);
                    statement.setBoolean(12, p_audio_muted);
                    statement.setBoolean(13, p_video_muted);
                    statement.setString(14, p_videotype);
                    statement.setBoolean(15, p_videotype.equalsIgnoreCase("desktop"));
                    statement.setBoolean(16, p_handraised);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in createconferencedetails " + ex.getMessage()), (Throwable)ex);
                }
                int affectedRows = statement.executeUpdate();
                if (affectedRows == 0) {
                    logger.error((Object)"Error in createconferencedetails. No Record instered");
                } else {
                    logger.info((Object)"================== Conference record created ===================");
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in createconferencedetails " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)"Could not find current request via RequestContextHolder");
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }
}

