/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.pbxservice.api;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.pbxservice.api.XmlRPCClient;
import com.coraltele.restapi.pbxservice.api.commandDialer;
import java.io.IOException;
import java.security.Key;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/pbx/callcenter/v2"})
public class PBXServiceAPIControllerV2 {
    private static final Logger logger = Logger.getLogger(PBXServiceAPIControllerV2.class);
    private CommonResponseObject objCommonResponse = new CommonResponseObject();
    private commandDialer objCommandDialer = new commandDialer();
    private static int generatedblogs = 1;
    private static int CIPHER_KEY_LEN = 16;
    private static String CIPHER_NAME = "AES/CBC/PKCS5PADDING";
    private static String CIPHER_KEY = "P^%cR$%*&^([a_)(";
    private static String CIPHER_IV = "c)r@L~!@#%([c%R_";
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest servletrequest;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PBXServiceAPIControllerV2() {
        PBXServiceAPIControllerV2.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private static String decode(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.decodeBase64((byte[])p_message.getBytes());
            _ret = new String(bytesEncoded);
            logger.info((Object)_ret);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    public static String encrypt(String data) {
        try {
            Base64 base64 = new Base64();
            if (CIPHER_KEY.length() < CIPHER_KEY_LEN) {
                int numPad = CIPHER_KEY_LEN - CIPHER_KEY.length();
                for (int i = 0; i < numPad; ++i) {
                    CIPHER_KEY = CIPHER_KEY + "0";
                }
            } else if (CIPHER_KEY.length() > CIPHER_KEY_LEN) {
                CIPHER_KEY = CIPHER_KEY.substring(0, CIPHER_KEY_LEN);
            }
            IvParameterSpec initVector = new IvParameterSpec(CIPHER_IV.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(1, (Key)skeySpec, initVector);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            String base64_EncryptedData = base64.encodeToString(encryptedData);
            String base64_IV = base64.encodeToString(CIPHER_IV.getBytes("UTF-8"));
            return base64_EncryptedData + ":" + base64_IV;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in encrypt :" + ex.getMessage()), (Throwable)ex);
            return "";
        }
    }

    public static String decrypt(String data) throws IOException {
        String returnValue = "";
        try {
            Base64 base64 = new Base64();
            String[] parts = data.split(":");
            IvParameterSpec iv = new IvParameterSpec(base64.decode(parts[1]));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(2, (Key)skeySpec, iv);
            byte[] decodedEncryptedData = base64.decode(parts[0]);
            byte[] original = cipher.doFinal(decodedEncryptedData);
            returnValue = new String(original);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in decrypt :" + ex.getMessage()), (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
        return returnValue;
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }

    private void generateDBLogs(JdbcTemplate db, String requestuuid, String apiname, String request, int type, int responsestatus, String responsemessage, int iserror, String errormessage, HttpServletRequest servletrequest) {
        block6: {
            String sql = "";
            String clientIPAddress = "";
            String clientAgents = "";
            if (generatedblogs == 1 && db != null) {
                try {
                    if (type == 0) {
                        try {
                            clientIPAddress = this.getClientIpAddress(servletrequest);
                            clientAgents = servletrequest.getHeader("User-Agent");
                            logger.info((Object)("Request comes from ip & user agent : " + clientIPAddress + ", " + clientAgents));
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in getting client ip address  : " + ex.getMessage()), (Throwable)ex);
                        }
                        sql = "insert into pbx.t_crmpbxapirequestresponse(requestuuid,apiname,request,requestedip,requestedbrowseragent) Values(?,?,?,?,?)";
                        db.update(sql, new Object[]{requestuuid, apiname, request, clientIPAddress, clientAgents});
                        break block6;
                    }
                    sql = "update pbx.t_crmpbxapirequestresponse set responsestatus = ? , responsemessage = ?, iserror = ?, errormessage = ?,  requestendtime = now() where requestuuid = ?";
                    db.update(sql, new Object[]{responsestatus, responsemessage, iserror, errormessage, requestuuid});
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    @PostMapping(path={"/playmessage"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> playMessage(@RequestParam(value="mandalicode") String mandalicode, @RequestParam(value="visitcode") String visitcode, @RequestParam(value="visitnoteddate") String visitnoteddate, @RequestParam(value="memberphone") String memberphone, @RequestParam(value="visitcallid") String visitcallid) {
        logger.info((Object)("Request for playing message : mandalicode,visitcode,visitnoteddate,memberphone,visitcallid : " + mandalicode + ", " + visitcode + ", " + visitnoteddate + ", " + memberphone + ", " + visitcallid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "playmessage";
        String request = "";
        int _visitcallid = 0;
        String sql = "";
        int campaignid = 0;
        try {
            if (mandalicode.isEmpty() || memberphone.isEmpty() || visitcallid.isEmpty()) {
                logger.error((Object)"Please specify mandalicode,memberphone and visitcallid.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify mandalicode,memberphone and visitcallid.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            mandalicode = PBXServiceAPIControllerV2.decrypt((String)PBXServiceAPIControllerV2.decode((String)mandalicode));
            memberphone = PBXServiceAPIControllerV2.decrypt((String)PBXServiceAPIControllerV2.decode((String)memberphone));
            visitcallid = PBXServiceAPIControllerV2.decrypt((String)PBXServiceAPIControllerV2.decode((String)visitcallid));
            _visitcallid = Integer.parseInt(visitcallid);
            logger.info((Object)("Request for playing message : mandalicode,visitcode,visitnoteddate,memberphone,visitcallid : " + mandalicode + ", " + visitcode + ", " + visitnoteddate + ", " + memberphone + ", " + visitcallid));
            request = "Api : playmessage; Request Param : mandalicode,visitcode,visitnoteddate,memberphone,visitcallid; UUID : " + mandalicode + ", " + visitcode + ", " + visitnoteddate + ", " + memberphone + ", " + visitcallid + "; " + uuid;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding values. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            try {
                sql = "select id from callcenter.m_campaign where coalesce(campaign_type,0) = 3 order by id desc limit 1;";
                campaignid = (Integer)dbCoralApps.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting agent active calls. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            if (campaignid == 0) {
                responseStatus = 1;
                response = "No campaign defined in system";
                logger.info((Object)("Updating Server Time Status : " + responseStatus));
                this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            }
            if (campaignid > 0) {
                sql = "insert into callcenter.t_uploadleaddata(phonenumber,referid,valuetype,uuid,accountno,custom_fld_c_01,custom_fld_c_02,custom_fld_n_01,datauploadsource) select ?,?,'l',?,?,?,?,?,?;";
                dbCoralApps.update(sql, new Object[]{memberphone, campaignid, uuid, mandalicode, visitcode, visitnoteddate, _visitcallid, "playmessage"});
                sql = "insert into callcenter.m_dialout(createdby,createdon,phonenumber,fromtime,totime,isdisabled,status,campaign,t_uploadleaddata_id)\r\nselect distinct -1 createdby,now() createdon,a.phonenumber,'00:00:00'::time without time zone fromtime,'00:00:00'::time without time zone totime, \r\nfalse isdisabled,'' status,a.referid,a.id\r\nfrom callcenter.t_uploadleaddata a\r\ninner join callcenter.m_campaign b on a.referid = b.id where a.uuid = ?;";
                dbCoralApps.update(sql, new Object[]{uuid});
                responseStatus = 0;
                response = "Number has been queued for playing message";
                logger.info((Object)("Number has been queued for playing message Status : " + responseStatus));
                this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            } else {
                responseStatus = 1;
                response = "No campaign defined in system";
                logger.info((Object)("No campaign defined in system Status : " + responseStatus));
                this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            }
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in playing message. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/bridgeCustomer"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> bridgeCustomer(@RequestParam(value="customerNumber") String customerNumber, @RequestParam(value="addCode") String addCode) {
        String systemExtension = "";
        logger.info((Object)("Request for dial call : customerNumber; addCode; systemExtension : " + customerNumber + "; " + addCode + "; " + systemExtension));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        new JdbcTemplate(this.dsCallCenter);
        String apiname = "dial";
        String command = "";
        String request = "";
        String callerURI = "";
        String calleeURI = "";
        String manualdialoutstring = "";
        String sql = "";
        String callernumber = "";
        CoralMeetSystemConfig meetconfig = this.meetConfig;
        if (meetconfig != null) {
            manualdialoutstring = meetconfig.getManualdialoutstring();
            logger.info((Object)("Manual Dial Out String : " + manualdialoutstring));
        }
        if (manualdialoutstring.isEmpty()) {
            logger.error((Object)"Please specify manual dial out string in callserver.manager.conf");
            this.objCommonResponse = new CommonResponseObject(1, "Please specify manul dial settings", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            String string = systemExtension = systemExtension.isEmpty() ? "0000" : systemExtension;
            if (customerNumber.isEmpty() || addCode.isEmpty()) {
                logger.error((Object)"Please specify Customer number/ Add code.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify Customer number/ Add code.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding input. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            try {
                sql = "select extensionno from pbx.m_extension_addcode_tagging where addcode = ?";
                callernumber = (String)db.query(sql, new Object[]{addCode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting caller number. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            if (callernumber.isEmpty()) {
                logger.error((Object)"No addCode mapping found in DB.");
                this.objCommonResponse = new CommonResponseObject(1, "No addCode mapping found in DB.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (manualdialoutstring.isEmpty()) {
                manualdialoutstring = "user/#";
            }
            if (!manualdialoutstring.isEmpty()) {
                callerURI = manualdialoutstring.replace("#", callernumber);
                calleeURI = manualdialoutstring.replace("#", customerNumber);
            }
            command = "{origination_caller_id_number=";
            command = command + systemExtension;
            command = command + "}";
            command = command + callerURI;
            command = command + " &bridge(";
            command = command + calleeURI;
            command = command + ")";
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
            responseStatus = 0;
            response = "Call has been dial to  : " + callernumber + " & " + customerNumber;
            logger.info((Object)("Originate call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in bridgeCustomer. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }
}

