/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.pbxservice.api;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.pbxservice.api.ActiveCalls;
import com.coraltele.restapi.pbxservice.api.XmlRPCClient;
import com.coraltele.restapi.pbxservice.api.commandDialer;
import com.coraltele.restapi.pbxservice.api.rowOCExtCurrentStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.tomcat.util.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/pbx/callcenter/v1"})
public class PBXServiceAPIController {
    private static final Logger logger = Logger.getLogger(PBXServiceAPIController.class);
    private CommonResponseObject objCommonResponse = new CommonResponseObject();
    private commandDialer objCommandDialer = new commandDialer();
    private static int generatedblogs = 1;
    private static int CIPHER_KEY_LEN = 16;
    private static String CIPHER_NAME = "AES/CBC/PKCS5PADDING";
    private static String CIPHER_KEY = "p@*CR$%*&^([a~^I";
    private static String CIPHER_IV = "C)r@L#m$#%([C^rM";
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest servletrequest;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dsUsers")
    private DataSource dsUsers;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PBXServiceAPIController() {
        PBXServiceAPIController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private static String decode(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.decodeBase64((byte[])p_message.getBytes());
            _ret = new String(bytesEncoded);
            logger.info((Object)_ret);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    public static String encrypt(String data) {
        try {
            Base64 base64 = new Base64();
            if (CIPHER_KEY.length() < CIPHER_KEY_LEN) {
                int numPad = CIPHER_KEY_LEN - CIPHER_KEY.length();
                for (int i = 0; i < numPad; ++i) {
                    CIPHER_KEY = CIPHER_KEY + "0";
                }
            } else if (CIPHER_KEY.length() > CIPHER_KEY_LEN) {
                CIPHER_KEY = CIPHER_KEY.substring(0, CIPHER_KEY_LEN);
            }
            IvParameterSpec initVector = new IvParameterSpec(CIPHER_IV.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(1, (Key)skeySpec, initVector);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            String base64_EncryptedData = base64.encodeToString(encryptedData);
            String base64_IV = base64.encodeToString(CIPHER_IV.getBytes("UTF-8"));
            return base64_EncryptedData + ":" + base64_IV;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in encrypt :" + ex.getMessage()), (Throwable)ex);
            return "";
        }
    }

    public static String decrypt(String data) throws IOException {
        String returnValue = "";
        try {
            Base64 base64 = new Base64();
            String[] parts = data.split(":");
            IvParameterSpec iv = new IvParameterSpec(base64.decode(parts[1]));
            SecretKeySpec skeySpec = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            cipher.init(2, (Key)skeySpec, iv);
            byte[] decodedEncryptedData = base64.decode(parts[0]);
            byte[] original = cipher.doFinal(decodedEncryptedData);
            returnValue = new String(original);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in decrypt :" + ex.getMessage()), (Throwable)ex);
            throw new IOException(ex.getMessage());
        }
        return returnValue;
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }

    private void generateDBLogs(JdbcTemplate db, String requestuuid, String apiname, String request, int type, int responsestatus, String responsemessage, int iserror, String errormessage, HttpServletRequest servletrequest) {
        block6: {
            String sql = "";
            String clientIPAddress = "";
            String clientAgents = "";
            if (generatedblogs == 1 && db != null) {
                try {
                    if (type == 0) {
                        try {
                            clientIPAddress = this.getClientIpAddress(servletrequest);
                            clientAgents = servletrequest.getHeader("User-Agent");
                            logger.info((Object)("Request comes from ip & user agent : " + clientIPAddress + ", " + clientAgents));
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in getting client ip address  : " + ex.getMessage()), (Throwable)ex);
                        }
                        sql = "insert into pbx.t_crmpbxapirequestresponse(requestuuid,apiname,request,requestedip,requestedbrowseragent) Values(?,?,?,?,?)";
                        db.update(sql, new Object[]{requestuuid, apiname, request, clientIPAddress, clientAgents});
                        break block6;
                    }
                    sql = "update pbx.t_crmpbxapirequestresponse set responsestatus = ? , responsemessage = ?, iserror = ?, errormessage = ?,  requestendtime = now() where requestuuid = ?";
                    db.update(sql, new Object[]{responsestatus, responsemessage, iserror, errormessage, requestuuid});
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    @GetMapping(path={"/pbxhealthstatus"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> pbxHealthStatus() {
        String responseMessage = "Request for pbxHealthStatus";
        logger.info((Object)responseMessage);
        String sipserverstatus = "DOWN";
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "pbxhealthstatus";
        String request = "Api : pbxHealthStatus; Request Param : ; UUID : " + uuid;
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            sipserverstatus = this.objCommandDialer.getSipServerStatus();
            logger.info((Object)("PBXHealth Status : " + sipserverstatus));
            responseStatus = sipserverstatus.equalsIgnoreCase("UP") ? 0 : 1;
            response = sipserverstatus;
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting sip server status. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/setpbxservertime"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> setPbxServerTime(@RequestParam(value="newtime") String newtime) {
        logger.info((Object)("Request for changing server time : newtime : " + newtime));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "setpbxservertime";
        String command = "";
        String request = "";
        try {
            if (newtime.isEmpty()) {
                logger.error((Object)"Please specify new server time you want to set");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify new server time you want to set", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            newtime = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)newtime));
            command = "date -s \"" + newtime + "\"";
            request = "Api : setpbxservertime; Request Param : newtime; UUID : " + newtime + "; " + uuid;
            logger.info((Object)("Request for changing server time : newtime : " + newtime));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding newtime. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            command = "hwclock --systohc";
            responseStatus = this.objCommandDialer.executecommand(command);
            command = "hwclock --hctosys";
            responseStatus = this.objCommandDialer.executecommand(command);
            command = "fsctl sync_clock";
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Server time changed" : "Error in changing server time";
            logger.info((Object)("Updating Server Time Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in changing server time. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    public List<ActiveCalls> getactivecalls(JdbcTemplate db) {
        ArrayList<ActiveCalls> returnValue = new ArrayList<ActiveCalls>();
        List activeCallsList = null;
        String sql = "";
        try {
            sql = "select direction,extension,destination,state,uuid,created,calleruuid,calleeuuid from api_activecalls;";
            activeCallsList = db.queryForList(sql);
            for (Map _activecalls : activeCallsList) {
                try {
                    ActiveCalls _objrowActiveCalls = new ActiveCalls(_activecalls.get("direction").toString(), _activecalls.get("extension").toString(), _activecalls.get("destination").toString(), _activecalls.get("state").toString(), _activecalls.get("uuid").toString(), _activecalls.get("created").toString(), _activecalls.get("calleruuid").toString(), _activecalls.get("calleeuuid").toString());
                    returnValue.add(_objrowActiveCalls);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting active calls from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting active calls. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return returnValue;
    }

    @GetMapping(path={"/getactivecalls"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> getActiveCalls() {
        String responseMessage = "Request for getActiveCalls";
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "getActiveCalls";
        String request = "Api : getActiveCalls; Request Param : ; UUID : " + uuid;
        List listActiveCalls = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            listActiveCalls = this.getactivecalls(db);
            responseStatus = 0;
            response = "Active Calls List";
            String data = mapper.writeValueAsString(listActiveCalls);
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, data);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting active calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/killactivecalls"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> killActiveCalls(@RequestParam(value="uuid") String p_uuid) {
        logger.info((Object)("Request for kill active call : calluuid : " + p_uuid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "killactivecalls";
        String command = "";
        String request = "";
        try {
            if (p_uuid.isEmpty()) {
                logger.error((Object)"Please specify uuid you want to destroy");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid you want to destroy", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if ((p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid))).isEmpty()) {
                logger.error((Object)"Please specify uuid you want to destroy");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid you want to destroy", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            command = "fs_cli -x \"uuid_kill " + p_uuid + "\"";
            request = "Api : killactivecalls; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for kill active call : calluuid : " + p_uuid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Call Disconnected" : "Error in Call Disconnection";
            logger.info((Object)("Kill active call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in Killing active call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/holdcall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> holdCall(@RequestParam(value="uuid") String p_uuid) {
        logger.info((Object)("Request for hold call : calluuid : " + p_uuid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "holdcall";
        String command = "";
        String request = "";
        try {
            if (p_uuid.isEmpty()) {
                logger.error((Object)"Please specify uuid you want to hold");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid you want to hold", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid));
            command = "fs_cli -x \"uuid_hold " + p_uuid + "\"";
            request = "Api : holdcall; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for hold call : calluuid : " + p_uuid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Call on Hold" : "Error in Holding Call";
            logger.info((Object)("Hold call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/unholdcall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> unHoldCall(@RequestParam(value="uuid") String p_uuid) {
        logger.info((Object)("Request for Un-hold call : calluuid : " + p_uuid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "unholdcall";
        String command = "";
        String request = "";
        try {
            if (p_uuid.isEmpty()) {
                logger.error((Object)"Please specify uuid you want to UN-hold");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid you want to UN-hold", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid));
            command = "fs_cli -x \"uuid_hold off " + p_uuid + "\"";
            request = "Api : unholdcall; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for UN-hold call : calluuid : " + p_uuid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Call Un-Hold" : "Error in Un-Holding Call";
            logger.info((Object)("UN-Hold call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in un holding call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/originatecall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> originateCall(@RequestParam(value="callerextension") String callerextension, @RequestParam(value="callername") String callername, @RequestParam(value="calleenumber") String calleenumber) {
        logger.info((Object)("Request for originate call : callerextension; callername; calleenumber : " + callerextension + "; " + callername + "; " + calleenumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "originatecall";
        String command = "";
        String request = "";
        String manualdialoutstring = "";
        String sql = "";
        String manualDialOutExtension = "64";
        CoralMeetSystemConfig meetconfig = this.meetConfig;
        if (meetconfig != null) {
            manualdialoutstring = meetconfig.getManualdialoutstring();
            logger.info((Object)("Manual Dial Out String : " + manualdialoutstring));
        }
        if (manualdialoutstring.isEmpty()) {
            logger.error((Object)"Please specify manual dial out string in callserver.manager.conf");
            this.objCommonResponse = new CommonResponseObject(1, "Please specify manul dial settings", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            if (callerextension.isEmpty() || calleenumber.isEmpty()) {
                logger.error((Object)"Please specify caller extension and callee number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify caller extension and callee number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            callerextension = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)callerextension));
            calleenumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)calleenumber));
            logger.info((Object)("Request for originate call : callerextension; callername; calleenumber : " + callerextension + "; " + callername + "; " + calleenumber));
            request = "Api : originatecall; Request Param : callerextension; callername; calleenumber : " + callerextension + "; " + callername + "; " + calleenumber;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding input. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            sql = "select count(*) from callcenter.m_dnd where phoneno = ?;";
            int isDND = (Integer)dbCoralApps.queryForObject(sql, new Object[]{calleenumber}, Integer.class);
            if (isDND > 0) {
                logger.error((Object)("Could Not Connect Call As Do-Not-Disturb is activated on this number : " + calleenumber));
                this.generateDBLogs(db, uuid, apiname, "", 1, 1, "Could Not Connect Call As Do-Not-Disturb is activated on this number : " + calleenumber, 1, "DND is set on number " + calleenumber, this.servletrequest);
                this.objCommonResponse = new CommonResponseObject(1, "Could Not Connect Call As Do-Not-Disturb is activated on this number : " + calleenumber, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (manualdialoutstring.isEmpty()) {
                manualdialoutstring = "user/#";
            }
            if (!manualdialoutstring.isEmpty()) {
                manualdialoutstring = manualdialoutstring.replace("#", calleenumber);
            }
            command = "{origination_caller_id_number=";
            command = command + callerextension;
            command = command + ",coral_call_direction=dialout,cc_side=member,coral_master_queue='";
            command = command + manualDialOutExtension;
            command = command + "'}";
            command = command + manualdialoutstring;
            command = command + "  ";
            command = command + callerextension;
            command = command + " XML manual";
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
            responseStatus = 0;
            response = "Call has been originated to  : " + calleenumber;
            logger.info((Object)("Originate call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in originating call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/agentlogin"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> agentLogin(@RequestParam(value="agentid") String agentid, @RequestParam(value="extension") String extension, @RequestParam(value="ipaddress") String ipaddress) {
        logger.info((Object)("Request for agent login : agentid; extension; ipaddress : " + agentid + "; " + extension + "; " + ipaddress + "; "));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        JdbcTemplate dbUsers = new JdbcTemplate(this.dsUsers);
        String apiname = "agentlogin";
        String command = "";
        String request = "";
        String sql = "";
        String queuesystemname = "";
        int calltimeout = 0;
        String mappedextension = "";
        String defaultqueue = "";
        boolean isondemand = false;
        try {
            if (agentid.isEmpty() || extension.isEmpty() || ipaddress.isEmpty()) {
                logger.error((Object)"Please specify agentid, extension and ip address you want to login");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentid, extension and ip address you want to login", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            extension = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)extension));
            ipaddress = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)ipaddress));
            if (agentid.isEmpty() || extension.isEmpty() || ipaddress.isEmpty()) {
                logger.error((Object)"Please specify agentid, extension and ip address you want to login");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentid, extension and ip address you want to login", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " status login\"";
            request = "Api : agentlogin; Request Param : agentid; " + agentid + "; " + uuid;
            logger.info((Object)("Request for agent login : agentid; extension; ipaddress : " + agentid + "; " + extension + "; " + ipaddress + "; "));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            String string = response = responseStatus == 0 ? "Agent Loggin" : "Error in Login";
            if (responseStatus == 0) {
                try {
                    sql = "select isondemand from users.m_users where loginid = ?";
                    isondemand = (Boolean)dbCoralApps.query(sql, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting isondemand data. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                try {
                    sql = "select coalesce(queuesystemname,'') queuesystemname from callcenter.m_ipextensiontagging where ipaddress = ? limit 1;";
                    queuesystemname = (String)dbCoralApps.query(sql, new Object[]{ipaddress}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting ip extension mapping data. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                try {
                    sql = "select coalesce(extensionno,'') extensionno from callcenter.m_ipextensiontagging where coalesce(ipaddress,'') = ? limit 1;";
                    mappedextension = (String)dbCoralApps.query(sql, new Object[]{ipaddress}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting ip extension mapping data. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                if (!mappedextension.isEmpty()) {
                    extension = mappedextension;
                    try {
                        List otheragentswithsameextesnion = null;
                        sql = "select distinct loginid from(\r\n\tselect name as loginid,case when coalesce(usercontact,'') = '' then coalesce(operatorcontact,'') else coalesce(usercontact,'') end as extension\r\n\tfrom\r\n\t(\r\n\t\tselect name,contact,\r\n\t\tsplit_part(split_part(contact,'user/',2),'@',1) usercontact,\r\n\t\tsplit_part(split_part(contact,'internal/',2),'@',1) operatorcontact\r\n\t\tfrom agents\r\n\t)a \r\n)a\r\nwhere coalesce(loginid,'') <> '' and extension = ?";
                        otheragentswithsameextesnion = dbCoralApps.queryForList(sql, new Object[]{mappedextension});
                        for (Map _tiers : otheragentswithsameextesnion) {
                            try {
                                String otherAgentid = _tiers.get("loginid").toString();
                                if (otherAgentid.equalsIgnoreCase(agentid)) continue;
                                Thread.sleep(100L);
                                command = "fs_cli -x \"callcenter_config agent set status '" + _tiers.get("loginid").toString() + "' 'Logged Out'\"";
                                responseStatus = this.objCommandDialer.executecommand(command);
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in deleting agent from queue. " + _tiers + " Error -> " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting tier data. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                    try {
                        sql = "select coalesce(agentqueue,'') agentqueue from pbx.m_agentqueue where agent = ?";
                        defaultqueue = (String)db.query(sql, new Object[]{mappedextension}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                        if (!defaultqueue.isEmpty()) {
                            sql = "delete from tiers where queue = ?";
                            dbCoralApps.update(sql, new Object[]{defaultqueue});
                            sql = "delete from tiers where agent = ? and queue::int > 1000";
                            dbCoralApps.update(sql, new Object[]{agentid});
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting default queue data. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                    Thread.sleep(100L);
                    command = "fs_cli -x \"callcenter_config tier add " + defaultqueue + " " + agentid + " 1 1\"";
                    responseStatus = this.objCommandDialer.executecommand(command);
                    command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " addqueue " + queuesystemname + " level 1 position 1\"";
                    responseStatus = this.objCommandDialer.executecommand(command);
                    try {
                        sql = "select coalesce(callTimeOut,0) calltimeout from users.m_users where loginid = ?;";
                        calltimeout = (Integer)dbCoralApps.query(sql, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting call time out. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                    if (!mappedextension.isEmpty()) {
                        command = "fs_cli -x \"callcenter_config agent set contact '" + agentid + "' '[call_timeout=" + calltimeout + "]user/" + extension + "'\"";
                        responseStatus = this.objCommandDialer.executecommand(command);
                        try {
                            sql = "update m_user set contactno = ? where username = ?";
                            dbUsers.update(sql, new Object[]{extension, agentid});
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in updating contact no in m_user. Error -> " + ex.getMessage()), (Throwable)ex);
                        }
                        response = responseStatus == 0 ? "Agent Loggin,New extension assigned to him on ip mapping basis -> " + extension : "Error in Login";
                    }
                    try {
                        Thread.sleep(100L);
                        String status = "Available";
                        String state = "Waiting";
                        if (isondemand) {
                            status = "Available (On Demand)";
                        }
                        command = "fs_cli -x \"callcenter_config agent set status '" + agentid + "' '" + status + "'";
                        responseStatus = this.objCommandDialer.executecommand(command);
                        command = "fs_cli -x \"callcenter_config agent set state '" + agentid + "' '" + state + "'";
                        responseStatus = this.objCommandDialer.executecommand(command);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in seting agent status. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            logger.info((Object)("Agent Loggin Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent login. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/agentloginv1"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> agentLoginV1(@RequestParam(value="agentid") String agentid) {
        logger.info((Object)("Request for agent login : agentid : " + agentid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "agentlogin";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty()) {
                logger.error((Object)"Please specify agentid you want to login");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentid you want to login", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " status login\"";
            request = "Api : agentlogin; Request Param : agentid; " + agentid + "; " + uuid;
            logger.info((Object)("Request for agent login : agentid : " + agentid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent Loggined" : "Error in Login";
            logger.info((Object)("Agent Loggin Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent login. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/agentlogout"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> agentLogout(@RequestParam(value="agentid") String agentid) {
        logger.info((Object)("Request for agent logout : agentid : " + agentid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "agentlogout";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty()) {
                logger.error((Object)"Please specify agentid you want to logged out");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentid you want to logged out", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " status logout\"";
            request = "Api : agentlogout; Request Param : agentid; " + agentid + "; " + uuid;
            logger.info((Object)("Request for agent log out : agentid : " + agentid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent Logged Out." : "Error in Login Out.";
            logger.info((Object)("Agent Logout Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent login out. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/agentbreak"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> agentBreak(@RequestParam(value="agentid") String agentid) {
        logger.info((Object)("Request for sent agent on break : agentid : " + agentid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "agentbreak";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty()) {
                logger.error((Object)"Please specify agentid you want to send on break");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentid you want to send on break", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            command = "fs_cli -x \"callcenter_config agent set status '" + agentid + "' 'On Break'\"";
            request = "Api : agentbreak; Request Param : agentid; " + agentid + "; " + uuid;
            logger.info((Object)("Request for send agent On Break : agentid : " + agentid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent Sent On-Break." : "Error in Sending Agent On-Break";
            logger.info((Object)("Agent Loggin Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in sending agent on-break. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/createinboundqueue"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> createInBoundQueue(@RequestParam(value="queueid") String queueid, @RequestParam(value="queuename") String queuename) {
        logger.info((Object)("Request for creating inbound queue : queuid, queuename : " + queueid + ", " + queuename));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "createinboundqueue";
        String command = "";
        String request = "";
        try {
            if (queueid.isEmpty() || queuename.isEmpty()) {
                logger.error((Object)"Please specify queueid and queuename you want to create.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify queueid and queuename you want to create.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            queueid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)queueid));
            queuename = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)queuename));
            command = "/usr/local/cliserver/cliserver \"queue create " + queueid + " '" + queuename + "'\"";
            request = "Api : createinboundqueue; Request Param : queuid, queuename; " + queueid + "; " + queuename + "; " + uuid;
            logger.info((Object)("Request for creating inbound queue : queuid, queuename : " + queueid + ", " + queuename));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding queuid or queuename. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Queue Created." : "Error in Creating Queue.";
            logger.info((Object)("Queue Creating Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in queue creation. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/createagent"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> createAgent(@RequestParam(value="agentid") String agentid, @RequestParam(value="agentext") String agentext) {
        logger.info((Object)("Request for creating agent : agentid, agentext : " + agentid + ", " + agentext));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "createagent";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty() || agentext.isEmpty()) {
                logger.error((Object)"Please specify agentid and agent extension you want to create.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify queueid and queuename you want to create.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            agentext = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentext));
            command = "/usr/local/cliserver/cliserver \"useragent create " + agentid + "\"";
            request = "Api : createagent; Request Param : agentid, agentext; " + agentid + "; " + agentext + "; " + uuid;
            logger.info((Object)("Request for creating inbound queue : agentid, agentext : " + agentid + ", " + agentext));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid or agent extension. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent Created." : "Error in Creating Agent.";
            logger.info((Object)("Queue Creating Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent creation. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/tagagent"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> tagAgent(@RequestParam(value="agentid") String agentid, @RequestParam(value="queueid") String queueid) {
        logger.info((Object)("Request for tagging agent : agentid, queueid : " + agentid + ", " + queueid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "tagagent";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty() || queueid.isEmpty()) {
                logger.error((Object)"Please specify agentid and agent extension you want to create.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify queueid and queuename you want to create.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            queueid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)queueid));
            command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " addqueue " + queueid + " level 1 position 1\"";
            request = "Api : tagagent; Request Param : agentid, queueid; " + agentid + "; " + queueid + "; " + uuid;
            logger.info((Object)("Request for creating inbound queue : agentid, queueid : " + agentid + ", " + queueid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid or queue id. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent Tagged." : "Error in Agent Tagging.";
            logger.info((Object)("Agent Tagging Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent tagging. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/untagagent"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> unTagAgent(@RequestParam(value="agentid") String agentid, @RequestParam(value="queueid") String queueid) {
        logger.info((Object)("Request for un-tagging agent : agentid, queueid : " + agentid + ", " + queueid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "untagagent";
        String command = "";
        String request = "";
        try {
            if (agentid.isEmpty() || queueid.isEmpty()) {
                logger.error((Object)"Please specify agentid and agent extension you want to create.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify queueid and queuename you want to create.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            queueid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)queueid));
            command = "/usr/local/cliserver/cliserver \"useragent update " + agentid + " delqueue " + queueid + "\"";
            request = "Api : untagagent; Request Param : agentid, queueid; " + agentid + "; " + queueid + "; " + uuid;
            logger.info((Object)("Request for creating inbound queue : agentid, queueid : " + agentid + ", " + queueid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentid or queue id. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Agent UN-Tagged." : "Error in Agent UN-Tagging.";
            logger.info((Object)("Agent Un-Tagging Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in agent un-tagging. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/blocknumber"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> blockNumber(@RequestParam(value="number") String number) {
        logger.info((Object)("Request for blocking number : number : " + number));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "blocknumber";
        String command = "";
        String request = "";
        try {
            if (number.isEmpty()) {
                logger.error((Object)"Please specify number you want to block");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify number you want to block", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            number = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)number));
            command = "/usr/local/cliserver/cliserver \"denylist add " + number + "\"";
            request = "Api : blocknumber; Request Param : number; " + number + "; " + uuid;
            logger.info((Object)("Request for blocking number : number : " + number));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding number to be blocked. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Number Blocked." : "Error in Blocking Number";
            logger.info((Object)("Blocking Number Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in blocking number. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/unblocknumber"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> unBlockNumber(@RequestParam(value="number") String number) {
        logger.info((Object)("Request for Un-blocking number : number : " + number));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "unblocknumber";
        String command = "";
        String request = "";
        try {
            if (number.isEmpty()) {
                logger.error((Object)"Please specify number you want to Un-block");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify number you want to Un-block", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            number = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)number));
            command = "/usr/local/cliserver/cliserver \"denylist delete " + number + "\"";
            request = "Api : unblocknumber; Request Param : number; " + number + "; " + uuid;
            logger.info((Object)("Request for Un-blocking number : number : " + number));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding number to be Un-blocked. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Number Un-Blocked." : "Error in Un-Blocking Number";
            logger.info((Object)("Unblocking Number Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in un-blocking number. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/registeruser"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> registerUser(@RequestParam(value="loginid") String loginid) {
        logger.info((Object)("Request for registering user : loginid : " + loginid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "registeruser";
        String command = "";
        String request = "";
        try {
            if (loginid.isEmpty()) {
                logger.error((Object)"Please specify loginid");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify loginid", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            loginid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)loginid));
            command = "/usr/local/cliserver/cliserver \"user create " + loginid + "\"";
            request = "Api : registeruser; Request Param : loginid; " + loginid + "; " + uuid;
            logger.info((Object)("Request for registering user : loginid : " + loginid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding loginid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "User registered successfully." : "Error in Registering User";
            logger.info((Object)("Registering User Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in registering user. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/resetpassword"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> resetPassword(@RequestParam(value="loginid") String loginid, @RequestParam(value="'newpassword'") String newpassword) {
        logger.info((Object)("Request for reseting user password : number : " + loginid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "registeruser";
        String command = "";
        String request = "";
        try {
            if (loginid.isEmpty() || newpassword.isEmpty()) {
                logger.error((Object)"Please specify loginid & password");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify loginid & password", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            loginid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)loginid));
            newpassword = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)newpassword));
            command = "/usr/local/cliserver/cliserver \"user update " + loginid + " pwd " + newpassword + "\"";
            request = "Api : registeruser; Request Param : loginid; password" + loginid + "; *****; " + uuid;
            logger.info((Object)("Request for reseting user password : number : " + loginid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding loginid or password. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Password reset successfully." : "Error in reseting User Password";
            logger.info((Object)("Reseting User Password Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in registering user password. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/startcallbarging"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> startCallBarging(@RequestParam(value="agentid") String agentid, @RequestParam(value="supervisorextension") String supervisorextension) {
        logger.info((Object)("Request for start call barging : agentid; supervisorextension : " + agentid + "; " + supervisorextension));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "startcallbarging";
        String command = "";
        String request = "";
        String sql = "";
        List members = null;
        String sessionUUid = "";
        String callUUId = "";
        String callCallerId = "";
        try {
            if (agentid.isEmpty() || supervisorextension.isEmpty()) {
                logger.error((Object)"Please define agentid and agent extension number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please define agentid and agent extension number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentid));
            supervisorextension = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)supervisorextension));
            logger.info((Object)("Request for start call barging : agentid; agentextension : " + agentid + "; " + supervisorextension));
            if (agentid.isEmpty() || supervisorextension.isEmpty()) {
                logger.error((Object)"Please define agentid and agent extension number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please define agentid and agent extension number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                sql = "select coalesce(cid_number,'')cid_number,coalesce(session_uuid,'') session_uuid from members a where serving_agent = ? limit 1";
                members = dbCoralApps.queryForList(sql, new Object[]{agentid});
                for (Map _member : members) {
                    try {
                        sessionUUid = _member.get("session_uuid").toString();
                        callCallerId = _member.get("cid_number").toString();
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting active calls from db. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting agent active calls. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                sql = "select coalesce(a.caller_uuid,'') caller_uuid from calls a where a.caller_uuid = ? limit 1;";
                callUUId = (String)db.query(sql, new Object[]{sessionUUid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting agent active calls. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            if (callCallerId.isEmpty() || callUUId.isEmpty()) {
                logger.error((Object)"Agent is not talking to anyone, So can not barging.");
                this.objCommonResponse = new CommonResponseObject(1, "Agent is not talking to anyone, So can not barging.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            command = "{origination_caller_id_number=";
            command = command + callCallerId;
            command = command + "}";
            command = command + "user/";
            command = command + supervisorextension;
            command = command + " ";
            command = command + "&eavesdrop(";
            command = command + callUUId;
            command = command + ")";
            request = "Api : startcallbarging; Request Param :  agentid; agentextension : " + agentid + "; " + supervisorextension + "; " + uuid;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
            response = (responseStatus = 0) == 0 ? "Barging API Executed." : "Error in Executing Barging API";
            logger.info((Object)("Barging API Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in starting call barging. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/startcallbargingv1"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> startCallBargingv1(@RequestParam(value="uuid") String p_uuid, @RequestParam(value="bargingonnumber") String bargingonnumber, @RequestParam(value="bargingbynumber") String bargingbynumber) {
        logger.info((Object)("Request for start call barging : calluuid; bargingonnumber; bargingbynumber : " + p_uuid + "; " + bargingonnumber + "; " + bargingbynumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "startcallbarging";
        String command = "";
        String request = "";
        String bargingcode = "";
        String sql = "";
        int type = -1;
        try {
            sql = "select extension from pbx.extensions where extension_type = 'bargin' limit 1;";
            bargingcode = (String)db.queryForObject(sql, String.class);
            if (bargingcode.isEmpty()) {
                logger.error((Object)"Please define barging code at system level.");
                this.objCommonResponse = new CommonResponseObject(1, "Please define barging code at system level.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (p_uuid.isEmpty() && bargingbynumber.isEmpty() || bargingonnumber.isEmpty()) {
                logger.error((Object)"Please specify barging call uuid or bargingbynumber & bargingonnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify barging call uuid or bargingbynumber & bargingonnumber.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (!p_uuid.isEmpty() && !bargingonnumber.isEmpty()) {
                p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid));
                bargingonnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)bargingonnumber));
                command = "fs_cli -x \"uuid_transfer " + p_uuid + "" + bargingcode + "*" + bargingonnumber + "\"";
                type = 0;
            } else if (!bargingbynumber.isEmpty() && !bargingonnumber.isEmpty()) {
                bargingbynumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)bargingbynumber));
                bargingonnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)bargingonnumber));
                command = "originate {origination_caller_id_number=";
                command = command + bargingbynumber;
                command = command + "'}";
                command = command + "user/";
                command = command + bargingbynumber;
                command = command + " ";
                command = command + bargingcode;
                command = command + "*";
                command = command + bargingonnumber;
                type = 1;
            }
            request = "Api : startcallbarging; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for start call barging : calluuid; bargingonnumber; bargingbynumber : " + p_uuid + "; " + bargingonnumber + "; " + bargingbynumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            if (type == 0) {
                responseStatus = this.objCommandDialer.executecommand(command);
            } else if (type == 1) {
                XmlRPCClient obj = new XmlRPCClient();
                if (!command.isEmpty()) {
                    obj.executeCommandAsync("freeswitch.api", "originate", command);
                }
                responseStatus = 0;
            }
            response = responseStatus == 0 ? "Barging API Executed." : "Error in Executing Barging API";
            logger.info((Object)("Barging API Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in starting call barging. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/endcallbarging"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> endCallBarging(@RequestParam(value="uuid") String p_uuid) {
        logger.info((Object)("Request for end call barging : calluuid : " + p_uuid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "endcallbarging";
        String command = "";
        String request = "";
        try {
            if (p_uuid.isEmpty()) {
                logger.error((Object)"Please specify uuid.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid));
            command = "fs_cli -x \"uuid_kill " + p_uuid + "\"";
            request = "Api : endcallbarging; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for end call barging : calluuid : " + p_uuid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Call Disconnected" : "Error in Call Disconnection";
            logger.info((Object)("End call barging Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in ending call barging. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/queuetransfercall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> queueTransferCall(@RequestParam(value="calleridnumber") String calleridnumber, @RequestParam(value="uuid") String p_uuid, @RequestParam(value="agentextnum") String agentextension, @RequestParam(value="transfernumber") String transfertonumber) {
        logger.info((Object)("Request for queue transfer call : calleridnumber; calluuid; agentextension; transfertonumber  : " + calleridnumber + "; " + p_uuid + "; " + agentextension + "; " + transfertonumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "queueTransferCall";
        String command = "";
        String request = "";
        try {
            if (p_uuid.isEmpty() || transfertonumber.isEmpty()) {
                logger.error((Object)"Please specify uuid & Transfer To Number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid & Transfer To Number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            p_uuid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)p_uuid));
            calleridnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)calleridnumber));
            agentextension = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentextension));
            transfertonumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)transfertonumber));
            if (p_uuid.isEmpty() || transfertonumber.isEmpty()) {
                logger.error((Object)"Please specify uuid & Transfer To Number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid & Transfer To Number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            command = "fs_cli -x \"uuid_transfer " + p_uuid + " " + transfertonumber + " XML calltransfer\"";
            request = "Api : queueTransferCall; Request Param : CallUUID; UUID : " + p_uuid + "; " + uuid;
            logger.info((Object)("Request for queue transfer call : calleridnumber; calluuid; agentextension; transfertonumber  : " + calleridnumber + "; " + p_uuid + "; " + agentextension + "; " + transfertonumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding calluuid or transfertonumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Call Trasferred." : "Error in Call Disconnection";
            logger.info((Object)("Queue Call Transfer Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in queue transfer call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/conference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> conference(@RequestParam(value="agentnumber") String agentnumber) {
        String apiname;
        JdbcTemplate db;
        String uuid;
        String response;
        int responseStatus;
        block26: {
            logger.info((Object)("Request for start three party conference call : agentnumber : " + agentnumber));
            responseStatus = -1;
            response = "";
            this.objCommonResponse = new CommonResponseObject();
            uuid = UUID.randomUUID().toString();
            db = new JdbcTemplate(this.dsSwitch);
            JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
            apiname = "conference";
            String command = "";
            String request = "";
            List operatorextensionStatus = new ArrayList();
            String rluCode = "";
            String virtualIp = "";
            String isanyholdcaller = "";
            String holdqueue = "";
            try {
                if (agentnumber.isEmpty()) {
                    logger.error((Object)"Please specify agent extension.");
                    this.objCommonResponse = new CommonResponseObject(1, "Please specify agent extension.", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber));
                request = "Api : conference; Request Param : agentnumber : " + agentnumber + "; " + uuid;
                logger.info((Object)("Request for start three party conference call : agentnumber : " + agentnumber));
            }
            catch (Exception ex) {
                logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                CoralMeetSystemConfig meetconfig;
                holdqueue = this.findHoldQueue(db, agentnumber);
                if (!holdqueue.isEmpty()) {
                    isanyholdcaller = this.isThereAnyHold(dbCoralApps, agentnumber, holdqueue);
                }
                operatorextensionStatus = this.getOperatorStatus(db, agentnumber);
                rluCode = this.getRluCode(db, agentnumber);
                virtualIp = "";
                if (!rluCode.isEmpty()) {
                    virtualIp = this.getVertualIp(db, rluCode);
                }
                if (rluCode.isEmpty()) {
                    rluCode = "internal";
                }
                if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                    virtualIp = Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4");
                    logger.info((Object)("Final Virtual Ip : " + virtualIp));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error in getting operator status.");
                this.objCommonResponse = new CommonResponseObject(1, "Error in getting operator status.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (operatorextensionStatus != null) {
                if (((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) {
                    logger.error((Object)"Operator is not talking to anyone. 3 Party Conference can be set with one active call and one hold number.");
                    this.objCommonResponse = new CommonResponseObject(1, "Operator is not talking to anyone. 3 Party Conference can be set with one active call and one hold number.", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            } else {
                logger.error((Object)"Operator is not talking to anyone. 3 Party Conference can be set with one active call and one hold number.");
                this.objCommonResponse = new CommonResponseObject(1, "Operator is not talking to anyone. 3 Party Conference can be set with one active call and one hold number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                if (operatorextensionStatus == null) break block26;
                if (!isanyholdcaller.isEmpty()) {
                    if (((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIsringing() != 1 && ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) break block26;
                    try {
                        String operatoruuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getFirstextensionuuid();
                        String targetuuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextensionuuid();
                        String thirdpartynumber = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextension();
                        if (!(targetuuid.isEmpty() || operatoruuid.isEmpty() || thirdpartynumber.isEmpty())) {
                            command = operatoruuid + " -both conference:" + operatoruuid + "@oc inline";
                            XmlRPCClient obj = new XmlRPCClient();
                            if (!command.isEmpty()) {
                                obj.executeCommand("freeswitch.api", "uuid_transfer", command);
                            }
                            command = "luarun threepartyconference.lua " + operatoruuid + " " + isanyholdcaller + " " + targetuuid + " " + thirdpartynumber;
                            command = "fs_cli -x \"" + command + "\"";
                            this.objCommandDialer.executecommand(command);
                            command = isanyholdcaller + " conference:" + operatoruuid + "@oc inline";
                            obj = new XmlRPCClient();
                            if (!command.isEmpty()) {
                                obj.executeCommand("freeswitch.api", "uuid_transfer", command);
                            }
                            break block26;
                        }
                        logger.error((Object)"No Party found for setting 3 party confrence");
                        this.objCommonResponse = new CommonResponseObject(1, "No Party found for setting 3 party confrence", null);
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                        this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                }
                logger.error((Object)"No hold party found. 3 Party Conference can be set with one active call and one hold number.");
                this.objCommonResponse = new CommonResponseObject(1, "No hold party found. 3 Party Conference can be set with one active call and one hold number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        try {
            responseStatus = 0;
            response = "Three Party Conference Started.";
            logger.info((Object)("Conference Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in conference call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/callcenterholdcall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> callcenterHoldCall(@RequestParam(value="agentnumber") String agentnumber) {
        logger.info((Object)("Request for callcenter hold call : agentnumber : " + agentnumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "callcenterholdcall";
        String command = "";
        String request = "";
        String isanyholdcaller = "";
        String holdqueue = "";
        String parkuuid = "";
        Connection switchConn = null;
        String qry = "";
        ResultSet rs = null;
        Statement query = null;
        try {
            if (agentnumber.isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if ((agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber))).isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            request = "Api : callcenterholdcall; Request Param : agentnumber; UUID : " + agentnumber + "; " + uuid;
            logger.info((Object)("Request for callcenter hold call : agentnumber : " + agentnumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            holdqueue = this.findHoldQueue(db, agentnumber);
            if (!holdqueue.isEmpty()) {
                isanyholdcaller = this.isThereAnyHold(dbCoralApps, agentnumber, holdqueue);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting hold party details. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        if (!isanyholdcaller.isEmpty()) {
            logger.error((Object)"Only one party can be on hold.");
            this.objCommonResponse = new CommonResponseObject(1, "Only one party can be on hold.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (holdqueue.isEmpty()) {
            logger.error((Object)"No Hold queue defined for holding the party.");
            this.objCommonResponse = new CommonResponseObject(1, "No Hold queue defined for holding the party.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            XmlRPCClient obj;
            switchConn = db.getDataSource().getConnection();
            qry = "select b.cid_num,b.dest,b.caller_uuid,b.callee_uuid from v_oc_activecalls b where (b.dest = ? or b.cid_num = ?)";
            query = switchConn.prepareStatement(qry);
            query.setString(1, agentnumber);
            query.setString(2, agentnumber);
            rs = query.executeQuery();
            while (rs.next()) {
                String _dest = "";
                String _calleruuid = "";
                String _calleeuuid = "";
                _dest = rs.getString("dest") != null ? rs.getString("dest") : "";
                _calleruuid = rs.getString("caller_uuid") != null ? rs.getString("caller_uuid") : "";
                _calleeuuid = rs.getString("callee_uuid") != null ? rs.getString("callee_uuid") : "";
                parkuuid = _dest.equalsIgnoreCase(agentnumber) ? _calleruuid : _calleeuuid;
                logger.info((Object)("Request for callcenter hold call : _dest, _calleruuid, _calleeuuid, parkuuid: " + _dest + ", " + _calleruuid + ", " + _calleeuuid + ", " + parkuuid));
            }
            logger.info((Object)("Request for callcenter hold call : parkuuid, agentnumber : " + parkuuid + ", " + agentnumber));
            if (!parkuuid.isEmpty() && !agentnumber.isEmpty()) {
                command = parkuuid + " " + agentnumber + " XML ochold inline";
                obj = new XmlRPCClient();
                if (!command.isEmpty()) {
                    obj.executeCommand("freeswitch.api", "uuid_transfer", command);
                }
            }
            if (parkuuid.isEmpty() && isanyholdcaller.isEmpty()) {
                logger.error((Object)"No Party found for hold or pick-up");
                this.objCommonResponse = new CommonResponseObject(1, "No Party found for hold or pick-up", null);
                obj = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                return obj;
            }
            responseStatus = 0;
            response = responseStatus == 0 ? "Call on Hold" : "Error in Holding Call";
            logger.info((Object)("Hold call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            ResponseEntity ex = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            return ex;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            return responseEntity;
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (switchConn != null) {
                try {
                    switchConn.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    @PostMapping(path={"/callcenterunholdcall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> callcenterUnHoldCall(@RequestParam(value="agentnumber") String agentnumber) throws InterruptedException {
        logger.info((Object)("Request for callcenter UN-hold call : agentnumber : " + agentnumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "callcenterunholdcall";
        String command = "";
        String request = "";
        String isanyholdcaller = "";
        String holdqueue = "";
        try {
            if (agentnumber.isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if ((agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber))).isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            request = "Api : callcenterunholdcall; Request Param : agentnumber; UUID : " + agentnumber + "; " + uuid;
            logger.info((Object)("Request for callcenter hold call : agentnumber : " + agentnumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            holdqueue = this.findHoldQueue(db, agentnumber);
            if (!holdqueue.isEmpty()) {
                isanyholdcaller = this.isThereAnyHold(dbCoralApps, agentnumber, holdqueue);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting hold party details. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        if (isanyholdcaller.isEmpty()) {
            logger.error((Object)"No one is there to UN-hold.");
            this.objCommonResponse = new CommonResponseObject(1, "No one is there to UN-hold.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (holdqueue.isEmpty()) {
            logger.error((Object)"No Hold queue defined for holding the party.");
            this.objCommonResponse = new CommonResponseObject(1, "No Hold queue defined for holding the party.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            if (!isanyholdcaller.isEmpty() && !holdqueue.isEmpty()) {
                XmlRPCClient obj = new XmlRPCClient();
                String operatoruuid = "";
                command = "{origination_caller_id_number=" + agentnumber + ",sip_auto_answer=true}user/" + agentnumber + " callcenter:opwithhold inline";
                obj = new XmlRPCClient();
                if (!command.isEmpty()) {
                    obj.executeCommand("freeswitch.api", "originate", command);
                }
                for (int _try = 0; _try < 3 && operatoruuid.isEmpty(); ++_try) {
                    operatoruuid = this.findOperatrorWithHoldUUID(dbCoralApps, agentnumber, "opwithhold");
                    if (!operatoruuid.isEmpty()) continue;
                    Thread.sleep(1000L);
                }
                if (!operatoruuid.isEmpty()) {
                    command = operatoruuid + " " + isanyholdcaller;
                    obj = new XmlRPCClient();
                    if (!command.isEmpty()) {
                        obj.executeCommand("freeswitch.api", "uuid_bridge", command);
                    }
                }
            }
            response = (responseStatus = 0) == 0 ? "Call Un-Holded" : "Error in Un-Holding Call";
            logger.info((Object)("Hold call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/conferencewr"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> conferenceWR(@RequestParam(value="agentextension") String agentnumber, @RequestParam(value="thirdpartynumber") String thirdpartynumber) {
        String apiname;
        JdbcTemplate db;
        String uuid;
        String response;
        int responseStatus;
        block22: {
            logger.info((Object)("Request for start three party conference call while ringing : agentnumber; thirdpartynumber  : " + agentnumber + "; " + thirdpartynumber));
            responseStatus = -1;
            response = "";
            this.objCommonResponse = new CommonResponseObject();
            uuid = UUID.randomUUID().toString();
            db = new JdbcTemplate(this.dsSwitch);
            apiname = "conferencewr";
            String command = "";
            String request = "";
            List operatorextensionStatus = new ArrayList();
            String rluCode = "";
            String virtualIp = "";
            try {
                if (agentnumber.isEmpty() || thirdpartynumber.isEmpty()) {
                    logger.error((Object)"Please specify uuid & Transfer To Number.");
                    this.objCommonResponse = new CommonResponseObject(1, "Please specify uuid & Transfer To Number.", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber));
                thirdpartynumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)thirdpartynumber));
                request = "Api : conferencewr; Request Param : agentnumber; thirdpartynumber : " + agentnumber + "; " + thirdpartynumber + "; " + uuid;
                logger.info((Object)("Request for start three party conference call : agentnumber; thirdpartynumber  : " + agentnumber + "; " + thirdpartynumber));
            }
            catch (Exception ex) {
                logger.error((Object)("Error in decoding agentnumber or thirdpartynumber. Error -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                CoralMeetSystemConfig meetconfig;
                operatorextensionStatus = this.getOperatorStatus(db, agentnumber);
                rluCode = this.getRluCode(db, agentnumber);
                virtualIp = "";
                if (!rluCode.isEmpty()) {
                    virtualIp = this.getVertualIp(db, rluCode);
                }
                if (rluCode.isEmpty()) {
                    rluCode = "internal";
                }
                if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                    virtualIp = Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4");
                    logger.info((Object)("Final Virtual Ip : " + virtualIp));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error in getting operator status.");
                this.objCommonResponse = new CommonResponseObject(1, "Error in getting operator status.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (operatorextensionStatus != null && ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) {
                logger.error((Object)"Operator is not talking to anyone. 3 Party Conference while ringing can be set with one active call and one non-busy number.");
                this.objCommonResponse = new CommonResponseObject(1, "Operator is not talking to anyone. 3 Party Conference while ringing can be set with one active call and one non-busy number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                if (operatorextensionStatus == null || ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) break block22;
                try {
                    String operatoruuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getFirstextensionuuid();
                    String targetuuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextensionuuid();
                    if (!((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextensionuuid().isEmpty() && !operatoruuid.isEmpty()) {
                        command = operatoruuid + " -both conference:" + operatoruuid + "@oc+flags{mintwo} inline";
                        XmlRPCClient obj = new XmlRPCClient();
                        if (!command.isEmpty()) {
                            obj.executeCommand("freeswitch.api", "uuid_transfer", command);
                        }
                        command = "luarun threepartyconferencewr.lua " + operatoruuid + " " + targetuuid + " " + thirdpartynumber;
                        command = "fs_cli -x \"" + command + "\"";
                        this.objCommandDialer.executecommand(command);
                        command = "{origination_caller_id_number=" + agentnumber + ",origination_caller_id_name='occonferencecall'}sofia/" + rluCode + "/" + thirdpartynumber + "@" + virtualIp + " conference:" + operatoruuid + " inline";
                        obj = new XmlRPCClient();
                        if (!command.isEmpty()) {
                            obj.executeCommand("freeswitch.api", "originate", command);
                        }
                        break block22;
                    }
                    logger.error((Object)"No Party found for setting 3 party confrence");
                    this.objCommonResponse = new CommonResponseObject(1, "No Party found for setting 3 party confrence", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                    this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        try {
            responseStatus = 0;
            response = "Three Party Conference Started.";
            logger.info((Object)("Conferencewr Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in conferencewr call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/ipextensionmapping"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> ipExtensionMapping(@RequestParam(value="ipaddress") String ipaddress, @RequestParam(value="extension") String extension, @RequestParam(value="queueid") String queueid) {
        logger.info((Object)("Request for end ip extension mapping : ipextensionmapping : " + ipaddress + "; " + extension + "," + queueid));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "ipextensionmapping";
        String request = "";
        String sql = "";
        try {
            if (ipaddress.isEmpty() || extension.isEmpty() || queueid.isEmpty()) {
                logger.error((Object)"Please specify ipaddress or extension or queueid.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify ipaddress or extension or queueid.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            ipaddress = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)ipaddress));
            extension = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)extension));
            queueid = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)queueid));
            if (ipaddress.isEmpty() || extension.isEmpty() || queueid.isEmpty()) {
                logger.error((Object)"Please specify ipaddress or extension or queueid.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify ipaddress or extension or queueid.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            request = "Api : ipextensionmapping; Request Param : ipaddress; extension; queueid; UUID : " + ipaddress + "; " + extension + "; " + queueid + "; " + uuid;
            logger.info((Object)("Request for end ip extension mapping : ipextensionmapping : " + ipaddress + "; " + extension + "," + queueid));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding request param. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            sql = "delete from callcenter.m_ipextensiontagging where (ipaddress = ? or extensionno = ?);";
            dbCoralApps.update(sql, new Object[]{ipaddress, extension});
            sql = "insert into callcenter.m_ipextensiontagging(ipaddress,extensionno,queuesystemname) Values(?,?,?)";
            dbCoralApps.update(sql, new Object[]{ipaddress, extension, queueid});
            responseStatus = 0;
            response = responseStatus == 0 ? "Mapping Done." : "Error in Mapping.";
            logger.info((Object)("ipExtensionMapping Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in ipExtensionMapping. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<rowOCExtCurrentStatus> getOperatorStatus(JdbcTemplate db, String operatorextension) throws SQLException {
        ArrayList<rowOCExtCurrentStatus> _return = new ArrayList<rowOCExtCurrentStatus>();
        String secondpartyext = "";
        String operatorext = "";
        String secondpartyuuid = "";
        String operatoruuid = "";
        String currentstate = "";
        Connection switchConn = null;
        String qry = "";
        ResultSet rs = null;
        Statement query = null;
        String ocActiveCallsSource = "v_oc_activecalls";
        try {
            switchConn = db.getDataSource().getConnection();
        }
        catch (SQLException ex) {
            logger.error((Object)("Error in getOperatorStatus(); Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            if (switchConn != null) {
                String _currentstate;
                String _calleeuuid;
                String _calleruuid;
                String _dest;
                String _cidnum;
                qry = "select b.cid_num,b.dest,b.caller_uuid,b.callee_uuid,state from " + ocActiveCallsSource + " b  where  (b.dest = ?  or b.cid_num = ?) union all select cid_num,cid_num dest,uuid caller_uuid, uuid callee_uuid,callstate from channels  where (context != 'conferenceserver' and context != 'attxfer') and (application = 'conference' or application_data like 'joinconference.lua%') and cid_num = ?";
                query = switchConn.prepareStatement(qry);
                query.setString(1, operatorextension);
                query.setString(2, operatorextension);
                query.setString(3, operatorextension);
                rs = query.executeQuery();
                while (rs.next()) {
                    _cidnum = "";
                    _dest = "";
                    _calleruuid = "";
                    _calleeuuid = "";
                    _currentstate = "";
                    _cidnum = rs.getString("cid_num") != null ? rs.getString("cid_num") : "";
                    _dest = rs.getString("dest") != null ? rs.getString("dest") : "";
                    _currentstate = rs.getString("state") != null ? rs.getString("state") : "";
                    _calleruuid = rs.getString("caller_uuid") != null ? rs.getString("caller_uuid") : "";
                    String string = _calleeuuid = rs.getString("callee_uuid") != null ? rs.getString("callee_uuid") : "";
                    if (_dest.contentEquals(operatorextension)) {
                        secondpartyuuid = _calleruuid;
                        operatoruuid = _calleeuuid;
                        secondpartyext = _cidnum;
                        operatorext = _dest;
                        currentstate = _currentstate;
                    } else {
                        secondpartyuuid = _calleeuuid;
                        operatoruuid = _calleruuid;
                        secondpartyext = _dest;
                        operatorext = _cidnum;
                        currentstate = _currentstate;
                    }
                    if (secondpartyuuid.isEmpty() || operatoruuid.isEmpty()) continue;
                    break;
                }
                if (!secondpartyuuid.isEmpty() && !operatoruuid.isEmpty()) {
                    _return.add(new rowOCExtCurrentStatus(Integer.valueOf(0), Integer.valueOf(1), currentstate, operatorext, secondpartyext, operatoruuid, secondpartyuuid));
                } else {
                    logger.info((Object)"Getting Records Ringing For Operator");
                    qry = "";
                    query = null;
                    rs = null;
                    qry = "select  b.dest, a.cid_num, a.uuid caller_uuid, b.uuid callee_uuid, a.created, a.callstate state from channels a inner join channels b on a.uuid = b.call_uuid where b.callstate IN ('RINGING','EARLY') and (a.coral_original_num = ?) and a.context != 'conferenceserver'  and a.context != 'attxfer' and a.cid_name <> 'occonferencecall' ";
                    query = switchConn.prepareStatement(qry);
                    query.setString(1, operatorextension);
                    rs = query.executeQuery();
                    while (rs.next()) {
                        _cidnum = "";
                        _dest = "";
                        _calleruuid = "";
                        _calleeuuid = "";
                        _currentstate = "";
                        _cidnum = rs.getString("cid_num") != null ? rs.getString("cid_num") : "";
                        _dest = rs.getString("dest") != null ? rs.getString("dest") : "";
                        _currentstate = rs.getString("state") != null ? rs.getString("state") : "";
                        _calleruuid = rs.getString("caller_uuid") != null ? rs.getString("caller_uuid") : "";
                        String string = _calleeuuid = rs.getString("callee_uuid") != null ? rs.getString("callee_uuid") : "";
                        if (_dest.contentEquals(operatorextension)) {
                            secondpartyuuid = _calleruuid;
                            operatoruuid = _calleeuuid;
                            secondpartyext = _cidnum;
                            operatorext = _dest;
                            currentstate = _currentstate;
                        } else {
                            secondpartyuuid = _calleeuuid;
                            operatoruuid = _calleruuid;
                            secondpartyext = _dest;
                            operatorext = _cidnum;
                            currentstate = _currentstate;
                        }
                        if (secondpartyuuid.isEmpty() || operatoruuid.isEmpty()) continue;
                        break;
                    }
                    if (!secondpartyuuid.isEmpty() && !operatoruuid.isEmpty()) {
                        _return.add(new rowOCExtCurrentStatus(Integer.valueOf(1), Integer.valueOf(0), currentstate, operatorext, secondpartyext, operatoruuid, secondpartyuuid));
                    } else if (secondpartyuuid.isEmpty() && operatoruuid.isEmpty()) {
                        logger.info((Object)"Getting Records DialBusy For Operator");
                        qry = "";
                        query = null;
                        rs = null;
                        qry = "select  a.dest, a.cid_num, a.uuid caller_uuid, a.uuid callee_uuid, a.created, a.callstate state from channels a where a.context = 'dialbusy' and (a.coral_original_num = ?) and a.context != 'conferenceserver'  and a.context != 'attxfer' and a.cid_name <> 'occonferencecall' ";
                        query = switchConn.prepareStatement(qry);
                        query.setString(1, operatorextension);
                        rs = query.executeQuery();
                        while (rs.next()) {
                            _cidnum = "";
                            _dest = "";
                            _calleruuid = "";
                            _calleeuuid = "";
                            _currentstate = "";
                            _cidnum = rs.getString("cid_num") != null ? rs.getString("cid_num") : "";
                            _dest = rs.getString("dest") != null ? rs.getString("dest") : "";
                            _currentstate = rs.getString("state") != null ? rs.getString("state") : "";
                            _calleruuid = rs.getString("caller_uuid") != null ? rs.getString("caller_uuid") : "";
                            String string = _calleeuuid = rs.getString("callee_uuid") != null ? rs.getString("callee_uuid") : "";
                            if (_dest.contentEquals(operatorextension)) {
                                secondpartyuuid = _calleruuid;
                                operatoruuid = _calleeuuid;
                                secondpartyext = _cidnum;
                                operatorext = _dest;
                                currentstate = _currentstate;
                            } else {
                                secondpartyuuid = _calleeuuid;
                                operatoruuid = _calleruuid;
                                secondpartyext = _dest;
                                operatorext = _cidnum;
                                currentstate = _currentstate;
                            }
                            if (secondpartyuuid.isEmpty() || operatoruuid.isEmpty()) continue;
                            break;
                        }
                        if (!secondpartyuuid.isEmpty() && !operatoruuid.isEmpty()) {
                            _return.add(new rowOCExtCurrentStatus(Integer.valueOf(1), Integer.valueOf(-1), currentstate, operatorext, secondpartyext, operatoruuid, secondpartyuuid));
                        } else if (secondpartyuuid.isEmpty() && operatoruuid.isEmpty()) {
                            logger.info((Object)"Getting Record for EI");
                            qry = "";
                            query = null;
                            rs = null;
                            qry = "select'EI' dest,a.cid_num,a.uuid caller_uuid,a.uuid callee_uuid,a.created,a.callstate state from channels a where a.context = 'noanswer' and a.application = 'playback' and a.coral_original_num = ? limit 1";
                            query = switchConn.prepareStatement(qry);
                            query.setString(1, operatorextension);
                            rs = query.executeQuery();
                            while (rs.next()) {
                                _cidnum = "";
                                _dest = "";
                                _calleruuid = "";
                                _calleeuuid = "";
                                _currentstate = "";
                                _cidnum = rs.getString("cid_num") != null ? rs.getString("cid_num") : "";
                                _dest = rs.getString("dest") != null ? rs.getString("dest") : "";
                                _currentstate = rs.getString("state") != null ? rs.getString("state") : "";
                                _calleruuid = rs.getString("caller_uuid") != null ? rs.getString("caller_uuid") : "";
                                String string = _calleeuuid = rs.getString("callee_uuid") != null ? rs.getString("callee_uuid") : "";
                                if (_dest.contentEquals(operatorextension)) {
                                    secondpartyuuid = _calleruuid;
                                    operatoruuid = _calleeuuid;
                                    secondpartyext = _cidnum;
                                    operatorext = _dest;
                                    currentstate = _currentstate;
                                } else {
                                    secondpartyuuid = _calleeuuid;
                                    operatoruuid = _calleruuid;
                                    secondpartyext = _dest;
                                    operatorext = _cidnum;
                                    currentstate = _currentstate;
                                }
                                if (secondpartyuuid.isEmpty() || operatoruuid.isEmpty()) continue;
                                break;
                            }
                            logger.info((Object)("_cidnum : " + operatorext + " _dest : " + secondpartyext + " secondpartyuuid : " + secondpartyuuid));
                            if (!secondpartyuuid.isEmpty() && !operatoruuid.isEmpty()) {
                                _return.add(new rowOCExtCurrentStatus(Integer.valueOf(1), Integer.valueOf(-1), currentstate, operatorext, secondpartyext, operatoruuid, secondpartyuuid));
                            } else {
                                _return.add(new rowOCExtCurrentStatus(Integer.valueOf(0), Integer.valueOf(0), "", "", "", "", ""));
                            }
                        } else {
                            _return.add(new rowOCExtCurrentStatus(Integer.valueOf(0), Integer.valueOf(0), "", "", "", "", ""));
                        }
                    } else {
                        _return.add(new rowOCExtCurrentStatus(Integer.valueOf(0), Integer.valueOf(0), "", "", "", "", ""));
                    }
                }
            }
        }
        catch (Exception ex) {
            _return.add(new rowOCExtCurrentStatus(Integer.valueOf(0), Integer.valueOf(0), "", "", "", "", ""));
            logger.error((Object)("Error in getOperatorStatus(); Error -> " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (query != null) {
                query.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (switchConn != null) {
                switchConn.close();
            }
        }
        return _return;
    }

    @PostMapping(path={"/autopickupphone"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> autoPickupPhone(@RequestParam(value="agentnumber") String agentnumber) throws InterruptedException {
        logger.info((Object)("Request for auto pickup phone : agentnumber : " + agentnumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "autopickupphone";
        String command = "";
        String request = "";
        String qry = "";
        String agentuuid = "";
        try {
            if (agentnumber.isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if ((agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber))).isEmpty()) {
                logger.error((Object)"Please specify agentnumber.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agentnumber", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            request = "Api : autopickupphone; Request Param : agentnumber; UUID : " + agentnumber + "; " + uuid;
            logger.info((Object)("Request for auto pickup phone : agentnumber : " + agentnumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            qry = "select uuid from channels where coral_original_num = ? and callstate = 'RINGING' order by created desc limit 1";
            agentuuid = (String)db.query(qry, new Object[]{agentnumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding uuid for call ringing on agent : " + agentnumber + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        if (agentuuid.isEmpty()) {
            logger.error((Object)("No call is ringing on this agent number : " + agentnumber));
            this.objCommonResponse = new CommonResponseObject(1, "No call is ringing on this agent number : " + agentnumber, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            command = "fs_cli -x \"uuid_phone_event " + agentuuid + " talk\"";
            responseStatus = this.objCommandDialer.executecommand(command);
            response = responseStatus == 0 ? "Auto PickUp API Called" : "Error in Auto PickUp API";
            logger.info((Object)("Hold call Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in holding call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @GetMapping(path={"/getplayresource/{resourceid}"}, produces={"application/json"})
    public void getPlayResource(@PathVariable(value="resourceid") Long resourceId, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for getplayresource";
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbCoralApps = new JdbcTemplate(this.dsCallCenter);
        String apiname = "getplayresource";
        String request = "Api : getplayresource; Request Param : resourceid; UUID : " + resourceId + ", " + uuid;
        String filePath = "";
        String qry = "";
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            qry = "select coalesce(cc_record_filename,'') cc_record_filename from pbx.fn_getcc_record_filename(?) limit 1";
            filePath = (String)dbCoralApps.query(qry, new Object[]{resourceId}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding file path for cdrid : " + resourceId + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        try {
            if (filePath != null) {
                String _fileType;
                if (!filePath.isEmpty() && ((_fileType = FilenameUtils.getExtension((String)filePath)).contentEquals("wav") || _fileType.contentEquals("mp3"))) {
                    File file = new File(filePath);
                    byte[] buffer = null;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        buffer = new byte[fis.available()];
                        fis.read(buffer);
                        fis.close();
                        if (_fileType.contentEquals("wav")) {
                            httpresponse.setContentType("audio/vnd.wave");
                        } else {
                            httpresponse.setContentType("audio/mpeg");
                        }
                        try {
                            httpresponse.getOutputStream().write(buffer);
                        }
                        catch (IOException ex) {
                            logger.error((Object)("Error in streaming audio file. Error -> " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        logger.error((Object)("Error in streaming audio file. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                    catch (IOException ex) {
                        logger.error((Object)("Error in streaming audio file. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            } else {
                logger.info((Object)("No file path for cdrid : " + resourceId));
            }
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in streaming audio file. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
        }
    }

    public String isThereAnyHold(JdbcTemplate db, String operatorextension, String holdqueue) {
        String qry = "";
        String holdpartyuuid = "";
        try {
            qry = "Select session_uuid,cid_number from members where queue = ? and state <> 'Abandoned' limit 1";
            holdpartyuuid = (String)db.query(qry, new Object[]{holdqueue}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding is there any hold by : " + operatorextension + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return holdpartyuuid;
    }

    public String findHoldQueue(JdbcTemplate db, String operatorextension) {
        String holdqueue = "";
        String qry = "";
        try {
            qry = "select coalesce(column9,'') holdqueue from pbx.extensions where extension = ? limit 1";
            holdqueue = (String)db.query(qry, new Object[]{operatorextension}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding hold queue for agent : " + operatorextension + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        if (holdqueue.isEmpty()) {
            holdqueue = operatorextension + "_ch";
        }
        return holdqueue;
    }

    public String findOperatrorWithHoldUUID(JdbcTemplate db, String operatorextension, String queue) {
        String qry = "";
        String sessionuuid = "";
        try {
            qry = "Select session_uuid from members where queue = ? and cid_number = ? and state <> 'Abandoned' order by joined_epoch desc limit 1 ";
            sessionuuid = (String)db.query(qry, new Object[]{queue, operatorextension}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding agent with hold uuid for agent : " + operatorextension + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return sessionuuid;
    }

    public String getRluCode(JdbcTemplate db, String operatorextension) {
        String _rluCode = "";
        String qry = "";
        try {
            qry = "select coalesce(rlucode,'') rlucode from pbx.extensions where extension = ? limit 1;";
            _rluCode = (String)db.query(qry, new Object[]{operatorextension}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding rlu code for agent number : " + operatorextension + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return _rluCode;
    }

    public String getVertualIp(JdbcTemplate db, String rlucode) {
        String _getVertualIp = "";
        String qry = "";
        try {
            qry = "select coalesce(virtualip,'') virtualip from pbx.m_control_rluserver where rlucode = ? limit 1;";
            _getVertualIp = (String)db.query(qry, new Object[]{rlucode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in finding virtual ip for rlu : " + rlucode + ", Error : " + ex.getMessage()), (Throwable)ex);
        }
        return _getVertualIp;
    }

    @PostMapping(path={"/startmultipartyconference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> startMultiPartyConference(@RequestParam(value="agentnumber") String agentnumber) {
        String apiname;
        JdbcTemplate db;
        String uuid;
        String response;
        int responseStatus;
        block23: {
            logger.info((Object)("Request for start multi party conference call : agentnumber : " + agentnumber));
            responseStatus = -1;
            response = "";
            this.objCommonResponse = new CommonResponseObject();
            uuid = UUID.randomUUID().toString();
            db = new JdbcTemplate(this.dsSwitch);
            apiname = "startmultipartyconference";
            String command = "";
            String request = "";
            List operatorextensionStatus = new ArrayList();
            String rluCode = "";
            String virtualIp = "";
            String conferenceCode = "";
            try {
                if (agentnumber.isEmpty()) {
                    logger.error((Object)"Please specify agent extension.");
                    this.objCommonResponse = new CommonResponseObject(1, "Please specify agent extension.", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber));
                request = "Api : conference; Request Param : agentnumber : " + agentnumber + "; " + uuid;
                logger.info((Object)("Request for start multi party conference call : agentnumber : " + agentnumber));
            }
            catch (Exception ex) {
                logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            try {
                CoralMeetSystemConfig meetconfig;
                conferenceCode = "conf_" + agentnumber + "_01";
                operatorextensionStatus = this.getOperatorStatus(db, agentnumber);
                rluCode = this.getRluCode(db, agentnumber);
                virtualIp = "";
                if (!rluCode.isEmpty()) {
                    virtualIp = this.getVertualIp(db, rluCode);
                }
                if (rluCode.isEmpty()) {
                    rluCode = "internal";
                }
                if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                    virtualIp = Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4");
                    logger.info((Object)("Final Virtual Ip : " + virtualIp));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error in getting operator status.");
                this.objCommonResponse = new CommonResponseObject(1, "Error in getting operator status.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (operatorextensionStatus != null) {
                if (((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) {
                    logger.error((Object)"Operator is not talking to anyone. MultiParty Conference can be set with one active call and one hold number.");
                    this.objCommonResponse = new CommonResponseObject(1, "Operator is not talking to anyone. MultiParty Conference can be set with one active call and one hold number.", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            } else {
                logger.error((Object)"Operator is not talking to anyone. MultiParty Conference can be set with one active call and one hold number.");
                this.objCommonResponse = new CommonResponseObject(1, "Operator is not talking to anyone. MultiParty Conference can be set with one active call and one hold number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                if (operatorextensionStatus == null || ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getIstalking() != 1) break block23;
                try {
                    String operatoruuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getFirstextensionuuid();
                    String targetuuid = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextensionuuid();
                    String thirdpartynumber = ((rowOCExtCurrentStatus)operatorextensionStatus.get(0)).getSecondextension();
                    if (!(targetuuid.isEmpty() || operatoruuid.isEmpty() || thirdpartynumber.isEmpty())) {
                        command = targetuuid + "  conference:" + conferenceCode + "@oc inline";
                        XmlRPCClient obj = new XmlRPCClient();
                        if (!command.isEmpty()) {
                            obj.executeCommand("freeswitch.api", "uuid_transfer", command);
                        }
                        break block23;
                    }
                    logger.error((Object)"No Party found for setting Multi party confrence");
                    this.objCommonResponse = new CommonResponseObject(1, "No Party found for setting Multi party confrence", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                    this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        try {
            responseStatus = 0;
            response = "Multi Party Conference Started.";
            logger.info((Object)("Conference Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in Multi party conference call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/joinmultipartyconference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> joinMultiPartyConference(@RequestParam(value="agentnumber") String agentnumber) {
        logger.info((Object)("Request for join multi party conference call : agentnumber : " + agentnumber));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "joinmultipartyconference";
        String command = "";
        String request = "";
        String conferenceCode = "";
        try {
            if (agentnumber.isEmpty()) {
                logger.error((Object)"Please specify agent extension.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agent extension.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber));
            request = "Api : conference; Request Param : agentnumber : " + agentnumber + "; " + uuid;
            logger.info((Object)("Request for join multi party conference call : agentnumber : " + agentnumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            conferenceCode = "conf_" + agentnumber + "_01";
            command = "{origination_callee_id_name=";
            command = command + agentnumber;
            command = command + ",origination_caller_id_number=";
            command = command + agentnumber;
            command = command + ",ignore_early_media=false}user/";
            command = command + agentnumber;
            command = command + " &lua('joinconference.lua ";
            command = command + conferenceCode;
            command = command + "')";
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in conference -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            responseStatus = 0;
            response = "Agent joined to his/her multi party conference.";
            logger.info((Object)("Conference Status : " + responseStatus));
            this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            try {
                this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in join multi party conference call. Error -> " + ex.getMessage()), (Throwable)ex);
            this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/addinmultipartyconference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> addInMultiPartyConference(@RequestParam(value="agentnumber") String agentnumber, @RequestParam(value="number") String number) {
        logger.info((Object)("Request for adding number in ongoing multi party conference call : agentnumber : " + agentnumber + ", Number : " + number));
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new CommonResponseObject();
        String uuid = UUID.randomUUID().toString();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String apiname = "addinmultipartyconference";
        String command = "";
        String request = "";
        String rluCode = "";
        String virtualIp = "";
        String conferenceCode = "";
        try {
            if (agentnumber.isEmpty()) {
                logger.error((Object)"Please specify agent extension.");
                this.objCommonResponse = new CommonResponseObject(1, "Please specify agent extension.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            agentnumber = PBXServiceAPIController.decrypt((String)PBXServiceAPIController.decode((String)agentnumber));
            request = "Api : conference; Request Param : agentnumber : " + agentnumber + "; " + uuid;
            logger.info((Object)("Request for adding number in ongoing multi party conference call : agentnumber : " + agentnumber + ", Number : " + number));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decoding agentnumber. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.generateDBLogs(db, uuid, apiname, request, 0, 0, "", 0, "", this.servletrequest);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            CoralMeetSystemConfig meetconfig;
            rluCode = this.getRluCode(db, agentnumber);
            virtualIp = "";
            if (!rluCode.isEmpty()) {
                virtualIp = this.getVertualIp(db, rluCode);
            }
            if (rluCode.isEmpty()) {
                rluCode = "internal";
            }
            if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                virtualIp = Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4");
                logger.info((Object)("Final Virtual Ip : " + virtualIp));
            }
            conferenceCode = "conf_" + agentnumber + "_01";
            command = "{origination_callee_id_name=";
            command = command + number;
            command = command + ",origination_caller_id_number=";
            command = command + agentnumber;
            command = command + ",origination_caller_id_name='occonferencecall'}sofia/";
            command = command + rluCode;
            command = command + "/";
            command = command + number;
            command = command + "@";
            command = command + virtualIp;
            command = command + " &conference(";
            command = command + conferenceCode;
            command = command + ")";
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
            try {
                responseStatus = 0;
                response = "Number added in multi party conference.";
                logger.info((Object)("Number added in multi party conference Status : " + responseStatus));
                this.objCommonResponse = new CommonResponseObject(responseStatus, response, null);
                try {
                    this.generateDBLogs(db, uuid, apiname, "", 1, responseStatus, response, 0, "", this.servletrequest);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in generating Database logs. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in join multi party conference call. Error -> " + ex.getMessage()), (Throwable)ex);
                this.generateDBLogs(db, uuid, apiname, "", 1, 1, ex.getMessage(), 1, ex.getMessage(), this.servletrequest);
                this.objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getting operator status.");
            this.objCommonResponse = new CommonResponseObject(1, "Error in getting operator status.", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }
}

