/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.coralucphone;

import com.coraltele.common.objects.ProperNamingUtil;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.oc.api.commandDialer;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.coralucphone.APIStatusResponse;
import com.coraltele.restapi.coralucphone.BuddyStatus;
import com.coraltele.restapi.coralucphone.BuddyStatusResponse;
import com.coraltele.restapi.coralucphone.BuddyStatusStateMachine;
import com.coraltele.restapi.coralucphone.CalleeDetailsForFMS;
import com.coraltele.restapi.coralucphone.Channel;
import com.coraltele.restapi.coralucphone.CommandResponse;
import com.coraltele.restapi.coralucphone.EncryptPassword;
import com.coraltele.restapi.coralucphone.MasterCodeResponse;
import com.coraltele.restapi.coralucphone.MediaTypeUtils;
import com.coraltele.restapi.coralucphone.NotificationDetails;
import com.coraltele.restapi.coralucphone.NotificationListResponse;
import com.coraltele.restapi.coralucphone.ParkedMemberResponse;
import com.coraltele.restapi.coralucphone.ParkedMembers;
import com.coraltele.restapi.coralucphone.PendingVoiceMailDetails;
import com.coraltele.restapi.coralucphone.PendingVoiceMailDetailsResponse;
import com.coraltele.restapi.coralucphone.ShortCodeList;
import com.coraltele.restapi.coralucphone.SipServerAPIObject;
import com.coraltele.restapi.coralucphone.SipServerFeatureCode;
import com.coraltele.restapi.coralucphone.UCActivatedFeatureList;
import com.coraltele.restapi.coralucphone.UCActivatedFeatureListResponse;
import com.coraltele.restapi.coralucphone.UCFeatureListAdmin;
import com.coraltele.restapi.pbxservice.api.XmlRPCClient;
import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.DeliveryPriority;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.PushType;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.eatthepath.pushy.apns.util.TokenUtil;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/coraluc/phoneapi/v1"})
public class CoralUCPhoneController {
    private static final Logger logger = Logger.getLogger(CoralUCPhoneController.class);
    private BuddyStatusResponse objCommonResponse = new BuddyStatusResponse();
    public static String mPushNotificationMessage = "Call Attemped From";
    private commandDialer objCommandDialer = new commandDialer();
    private static String CIPHER_KEY = "C234567890123456";
    private static String CIPHER_IV = "1234567890123456";
    private static String CIPHER_KEY_REG = "D234567890123786";
    private static String CIPHER_IV_REG = "1234567890123786";
    private SimpleApnsPushNotification pushNotification;
    private static String certificatePassword = "coral@123#456";
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest servletrequest;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dataSourceKamailio")
    private DataSource dsKamailio;
    @Autowired
    @Qualifier(value="dataSourceBilling")
    private DataSource dsBilling;
    @Autowired
    ResourceLoader resourceLoader;
    databaseUtilities db;
    private static BeanPropertyRowMapper<ShortCodeList> rowShortCodeList = new /* Unavailable Anonymous Inner Class!! */;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CoralUCPhoneController() {
        CoralUCPhoneController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private static String Base64decode(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.getDecoder().decode(p_message.getBytes());
            _ret = new String(bytesEncoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    private static byte[] decode(String p_message) {
        try {
            byte[] bytesdecoded = Base64.getDecoder().decode(p_message);
            return bytesdecoded;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decode : , Error : => " + ex.getMessage()));
            return null;
        }
    }

    public static byte[] encrypt(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
        cipher.init(1, (Key)key, new IvParameterSpec(CIPHER_IV.getBytes("UTF-8")));
        return cipher.doFinal(plainText.getBytes("UTF-8"));
    }

    public static String decrypt(byte[] cipherText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
        cipher.init(2, (Key)key, new IvParameterSpec(CIPHER_IV.getBytes("UTF-8")));
        return new String(cipher.doFinal(cipherText), "UTF-8");
    }

    public static byte[] encryptReg(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY_REG.getBytes("UTF-8"), "AES");
        cipher.init(1, (Key)key, new IvParameterSpec(CIPHER_IV_REG.getBytes("UTF-8")));
        return cipher.doFinal(plainText.getBytes("UTF-8"));
    }

    public static String decryptReg(byte[] cipherText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY_REG.getBytes("UTF-8"), "AES");
        cipher.init(2, (Key)key, new IvParameterSpec(CIPHER_IV_REG.getBytes("UTF-8")));
        return new String(cipher.doFinal(cipherText), "UTF-8");
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }

    private void postRealTimeData(String localNumber) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Channel objChannel = new Channel();
            objChannel.setLocalNumber(localNumber);
            objChannel.setUpdateType("userAvailable");
            String json = objectMapper.writeValueAsString((Object)objChannel);
            this.sendUpdateChannelPost(json);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in postRealTimeData() : " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void sendUpdateChannelPost(String data) throws Exception {
        String updateChannelURL = "";
        CoralMeetSystemConfig meetconfig = this.meetConfig;
        if (meetconfig != null) {
            updateChannelURL = meetconfig.getUpdateChannelUrl();
        }
        if (updateChannelURL.isEmpty()) {
            return;
        }
        HttpPost post = new HttpPost(updateChannelURL);
        StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            logger.info((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception ex) {
            logger.error((Object)("Error while sending update channel to websocket server. " + ex.getMessage()), (Throwable)ex);
        }
    }

    public List<BuddyStatus> getBuddyStatusV3(JdbcTemplate db, String contact, String stateMachineUrl) {
        ArrayList<BuddyStatus> returnValue = new ArrayList<BuddyStatus>();
        List buddyStatusList = null;
        String sql = "";
        String companycode = "";
        List objBuddyStatusMachine = new ArrayList();
        String myRemoteParty = "";
        try {
            sql = "select coalesce(company,'') companycode from pbx.extensions where extension = ? limit 1;";
            companycode = (String)db.query(sql, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            try {
                String output;
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                Client client = Client.create();
                WebResource webResource = client.resource(stateMachineUrl);
                ClientResponse response = (ClientResponse)webResource.type("application/json").get(ClientResponse.class);
                if (response.getStatus() != 200) {
                    logger.error((Object)("Failed : HTTP error code : " + response.getStatus()));
                }
                if (!(output = (String)response.getEntity(String.class)).isEmpty()) {
                    objBuddyStatusMachine = (List)mapper.readValue(output, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Exception at getBuddyStatusV3(). Error:" + ex.getMessage()), (Throwable)ex);
            }
            sql = "select a.contact,a.name,contactdata,expires from(select a.extension contact, \r\ncase when coalesce(b.name,'') != '' then coalesce(b.name,'') else case when coalesce(a.name,'') = '' then 'NA (' || a.extension || ')' else coalesce(a.name,'') end end as name,\r\ncoalesce(split_part(c.contact,';',1),'') as contactdata ,c.expires\r\nfrom pbx.extensions a\r\nleft join pbx.m_vipmaster b on a.extension = coalesce(b.officeext,'')\r\nleft join lateral(select contact,expires from location c where username = a.extension order by id desc limit 1)c on 1=1\r\nwhere a.extension_type = 'phone' and a.extension <> ?";
            if (companycode.equalsIgnoreCase("coralvip")) {
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact});
            } else if (contact.equals("xyZ47DE")) {
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact});
            } else {
                sql = sql + " and coalesce(company,'')::text = ?";
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact, companycode});
            }
            for (Map _buddyCalls : buddyStatusList) {
                try {
                    BuddyStatus objBuddyStatus;
                    String expires;
                    String status = "Not Registered";
                    String statusColor = "grey";
                    String statusColorhex = "";
                    String contactNumber = _buddyCalls.get("contact").toString();
                    String contactData = _buddyCalls.get("contactdata").toString();
                    String string = expires = _buddyCalls.get("expires") == null ? "" : _buddyCalls.get("expires").toString();
                    if (objBuddyStatusMachine != null && objBuddyStatusMachine.size() > 0) {
                        for (BuddyStatusStateMachine obj : objBuddyStatusMachine) {
                            if (!contactNumber.equalsIgnoreCase(obj.getNumber())) continue;
                            if (obj.getRegistrationStatus() == null) break;
                            if (!obj.getRegistrationStatus().toString().equalsIgnoreCase("Registered")) continue;
                            if (obj.getActiveCallId() != null) {
                                if (!obj.getActiveCallId().isEmpty()) {
                                    if (obj.getCallStatus() != null && (obj.getCallStatus().equalsIgnoreCase("early") || obj.getCallStatus().equalsIgnoreCase("trying"))) {
                                        status = "Registered";
                                        statusColor = "orange";
                                        statusColorhex = obj.getPresenceStatus();
                                        break;
                                    }
                                    if (obj.getRemoteParty() != null) {
                                        if (obj.getRemoteParty().equals(contact)) {
                                            myRemoteParty = obj.getRemoteParty();
                                            status = "Registered";
                                            statusColor = "brown";
                                            statusColorhex = obj.getPresenceStatus();
                                            break;
                                        }
                                        if (myRemoteParty.equalsIgnoreCase(obj.getNumber())) {
                                            statusColor = "brown";
                                            statusColorhex = obj.getPresenceStatus();
                                        } else {
                                            statusColor = "red";
                                            statusColorhex = obj.getPresenceStatus();
                                        }
                                        status = "Registered";
                                        break;
                                    }
                                    status = "Registered";
                                    statusColor = "red";
                                    statusColorhex = obj.getPresenceStatus();
                                    break;
                                }
                                status = "Registered";
                                statusColor = "green";
                                statusColorhex = obj.getPresenceStatus();
                                break;
                            }
                            status = "Registered";
                            statusColor = "green";
                            statusColorhex = obj.getPresenceStatus();
                            break;
                        }
                    }
                    if (this.meetConfig.getMakeBuddyNameProper() == 1) {
                        objBuddyStatus = new BuddyStatus(contactNumber, ProperNamingUtil.capitalize((String)_buddyCalls.get("name").toString().toLowerCase(), (String)"of"), status, statusColor, statusColorhex, contactData, expires);
                        returnValue.add(objBuddyStatus);
                        continue;
                    }
                    objBuddyStatus = new BuddyStatus(contactNumber, _buddyCalls.get("name").toString(), status, statusColor, statusColorhex, contactData, expires);
                    returnValue.add(objBuddyStatus);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting buddy status from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting buddy status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        returnValue.sort((s1, s2) -> s1.getName().compareTo(s2.getName()));
        return returnValue;
    }

    public List<BuddyStatus> getBuddyStatusV2(JdbcTemplate db, String contact, JdbcTemplate dbKamailio) {
        ArrayList<BuddyStatus> returnValue = new ArrayList<BuddyStatus>();
        List buddyStatusList = null;
        String sql = "";
        String companycode = "";
        try {
            sql = "select coalesce(company,'') companycode from pbx.extensions where extension = ? limit 1;";
            companycode = (String)db.query(sql, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select a.contact,a.name,contactdata,expires from(select a.extension contact, \r\ncase when coalesce(b.name,'') != '' then coalesce(b.name,'') else case when coalesce(a.name,'') = '' then 'NA (' || a.extension || ')' else coalesce(a.name,'') end end as name,\r\ncoalesce(split_part(c.contact,';',1),'') as contactdata ,c.expires\r\nfrom pbx.extensions a\r\nleft join pbx.m_vipmaster b on a.extension = coalesce(b.officeext,'')\r\nleft join location c on a.extension = c.username\r\nwhere a.extension_type = 'phone' and a.extension <> ?";
            if (companycode.equalsIgnoreCase("coralvip")) {
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact});
            } else if (contact.equals("xyZ47DE")) {
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact});
            } else {
                sql = sql + " and coalesce(company,'')::text = ?";
                sql = sql + " )a order by a.name,a.contact";
                buddyStatusList = db.queryForList(sql, new Object[]{contact, companycode});
            }
            List onlineNumbers = this.FindSBCOnlineNumbers();
            for (Map _buddyCalls : buddyStatusList) {
                try {
                    BuddyStatus objBuddyStatus;
                    String expires;
                    String status = "Not Registered";
                    String statusColor = "grey";
                    String statusColorhex = "#808080";
                    String contactNumber = _buddyCalls.get("contact").toString();
                    String contactData = _buddyCalls.get("contactdata").toString();
                    String string = expires = _buddyCalls.get("expires") == null ? "" : _buddyCalls.get("expires").toString();
                    if (onlineNumbers.size() > 0) {
                        for (String extension : onlineNumbers) {
                            if (!contactNumber.equalsIgnoreCase(extension)) continue;
                            status = "Registered";
                            statusColor = "green";
                            statusColorhex = "#008000";
                            break;
                        }
                    }
                    if (this.meetConfig.getMakeBuddyNameProper() == 1) {
                        objBuddyStatus = new BuddyStatus(contactNumber, ProperNamingUtil.capitalize((String)_buddyCalls.get("name").toString().toLowerCase(), (String)"of"), status, statusColor, statusColorhex, contactData, expires);
                        returnValue.add(objBuddyStatus);
                        continue;
                    }
                    objBuddyStatus = new BuddyStatus(contactNumber, _buddyCalls.get("name").toString(), status, statusColor, statusColorhex, contactData, expires);
                    returnValue.add(objBuddyStatus);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting buddy status from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting buddy status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        returnValue.sort((s1, s2) -> s1.getName().compareTo(s2.getName()));
        return returnValue;
    }

    public List<BuddyStatus> getBuddyStatus(JdbcTemplate db, String contact) {
        ArrayList<BuddyStatus> returnValue = new ArrayList<BuddyStatus>();
        List buddyStatusList = null;
        String sql = "";
        String companycode = "";
        try {
            sql = "select coalesce(company,'') companycode from pbx.extensions where extension = ? limit 1;";
            companycode = (String)db.query(sql, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select a.contact,a.name,a.status,\r\ncase a.status when 'Registered' then 'green' else 'grey' end statuscolor,\r\ncase a.status when 'Registered' then '#008000' else '#808080' end statuscolorhex\r\nfrom(select a.extension contact,case when coalesce(a.name,'') = '' then 'NA (' || a.extension || ')' else coalesce(a.name,'') end as name,\r\n\tcase when coalesce(b.sip_user,'')  <> '' then 'Registered' else 'Not Registered' end status\r\n\tfrom pbx.extensions a left join sip_registrations b on a.extension = b.sip_user\r\n\twhere a.extension_type = 'phone' and a.extension <> ? and coalesce(company,'')::text = ?)a order by a.name,a.contact;";
            buddyStatusList = db.queryForList(sql, new Object[]{contact, companycode});
            for (Map _buddyCalls : buddyStatusList) {
                try {
                    BuddyStatus objBuddyStatus;
                    if (this.meetConfig.getMakeBuddyNameProper() == 1) {
                        objBuddyStatus = new BuddyStatus(_buddyCalls.get("contact").toString(), ProperNamingUtil.capitalize((String)_buddyCalls.get("name").toString().toLowerCase(), (String)"of"), _buddyCalls.get("status").toString(), _buddyCalls.get("statuscolor").toString(), _buddyCalls.get("statuscolorhex").toString(), "", "");
                        returnValue.add(objBuddyStatus);
                        continue;
                    }
                    objBuddyStatus = new BuddyStatus(_buddyCalls.get("contact").toString(), _buddyCalls.get("name").toString(), _buddyCalls.get("status").toString(), _buddyCalls.get("statuscolor").toString(), _buddyCalls.get("statuscolorhex").toString(), "", "");
                    returnValue.add(objBuddyStatus);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting buddy status from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting buddy status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        returnValue.sort((s1, s2) -> s1.getName().compareTo(s2.getName()));
        return returnValue;
    }

    @GetMapping(path={"/getstatuslist/{contact}"}, produces={"application/json"})
    public ResponseEntity<BuddyStatusResponse> getStatusList(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Buddy Status List, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        this.objCommonResponse = new BuddyStatusResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbKamailio = new JdbcTemplate(this.dsKamailio);
        List listBuddyStatus = new ArrayList();
        boolean dataFromMediaServer = false;
        String stateMachineUrl = "";
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            logger.info((Object)("Request for Buddy Status List, By contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new BuddyStatusResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            this.postRealTimeData(contact);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in postRealTimeData() : " + ex.getMessage()), (Throwable)ex);
        }
        if (contact.isEmpty()) {
            this.objCommonResponse = new BuddyStatusResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            if (this.meetConfig != null && this.meetConfig.getDatafrommediaserver() == 1) {
                dataFromMediaServer = true;
            }
            if (dataFromMediaServer) {
                listBuddyStatus = this.getBuddyStatus(db, contact);
            } else {
                try {
                    CoralMeetSystemConfig meetconfig = this.meetConfig;
                    if (meetconfig != null) {
                        stateMachineUrl = meetconfig.getStatemachineurl().trim();
                        stateMachineUrl = stateMachineUrl + "/extension";
                        logger.info((Object)("StateMachine  : " + stateMachineUrl));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in finding configuration. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                listBuddyStatus = stateMachineUrl.isEmpty() ? this.getBuddyStatusV2(db, contact, dbKamailio) : this.getBuddyStatusV3(db, contact, stateMachineUrl);
            }
            responseStatus = 0;
            response = "Buddy Status List";
            this.objCommonResponse = new BuddyStatusResponse(responseStatus, response, listBuddyStatus);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting buddy calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new BuddyStatusResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/getmissedcalldeatils"}, produces={"application/json"})
    public ResponseEntity<NotificationListResponse> getMissedCallsDetails(@RequestParam(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Missed Calls List, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        NotificationListResponse objCommonResponse = new NotificationListResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbBilling = new JdbcTemplate(this.dsBilling);
        ArrayList listNotificationDetails = new ArrayList();
        boolean dataFromMediaServer = false;
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new NotificationListResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            this.postRealTimeData(contact);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in postRealTimeData() : " + ex.getMessage()), (Throwable)ex);
        }
        if (contact.isEmpty()) {
            objCommonResponse = new NotificationListResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            NotificationDetails _allNotificationDetails = new NotificationDetails();
            if (this.meetConfig != null && this.meetConfig.getDatafrommediaserver() == 1) {
                dataFromMediaServer = true;
            }
            listNotificationDetails = dataFromMediaServer ? _allNotificationDetails.getMissedCallDetailsFromMediaServer(dbBilling, contact) : _allNotificationDetails.getMissedCallDetailsFromMediaServer(dbBilling, contact);
            responseStatus = 0;
            response = "Missed Call List";
            objCommonResponse = new NotificationListResponse(responseStatus, response, (List)listNotificationDetails);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new NotificationListResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updatefeature"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateFeature(@RequestParam(value="contact") String contact, @RequestParam(value="featurecode") String featurecode, @RequestParam(value="featurecodedata") String featurecodedata, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for updating feature, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String cliCommand = "";
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            featurecode = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)featurecode)));
            featurecodedata = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)featurecodedata)));
            if ((featurecode.startsWith("callforward") || featurecode.startsWith("followme")) && (featurecodedata.isEmpty() || featurecodedata.equalsIgnoreCase("na"))) {
                featurecodedata = "";
            }
            if (contact.isEmpty() || featurecode.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (featurecode.equalsIgnoreCase("dialout")) {
                cliCommand = this.updateRecords("dialing-intercom", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("diallocal")) {
                cliCommand = this.updateRecords("dialing-local", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dialstd")) {
                cliCommand = this.updateRecords("dialing-std", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dialisd")) {
                cliCommand = this.updateRecords("dialing-isd", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dnd")) {
                cliCommand = this.updateRecords("dnd", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("callforward-always")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-all", false, "", contact) : this.updateRecords("fwd-all", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("callforward-noanswer")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-all", false, "", contact) : this.updateRecords("fwd-all", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("callforward-busy")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-busy", false, "", contact) : this.updateRecords("fwd-busy", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("followme")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("follow-me", false, "", contact) : this.updateRecords("follow-me", true, featurecodedata, contact);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (!cliCommand.isEmpty()) {
                logger.info((Object)("cliCommand : " + cliCommand));
                this.commandaction(cliCommand, contact, db, "");
            }
            responseStatus = 0;
            response = "Feature updated successully";
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    private String updateRecords(String key, boolean option, String val, String extension) {
        String cliCommand = "";
        if (key == "dialing-intercom" && option) {
            cliCommand = "extension update " + extension + " dial intercom on";
        } else if (key == "dialing-intercom" && !option) {
            cliCommand = "extension update " + extension + " dial intercom off";
        }
        if (key == "dialing-isd" && option) {
            cliCommand = "extension update " + extension + " dial isd on";
        } else if (key == "dialing-isd" && !option) {
            cliCommand = "extension update " + extension + " dial isd off";
        }
        if (key == "dialing-std" && option) {
            cliCommand = "extension update " + extension + " dial std on";
        } else if (key == "dialing-std" && !option) {
            cliCommand = "extension update " + extension + " dial std off";
        }
        if (key == "dialing-local" && option) {
            cliCommand = "extension update " + extension + " dial local on";
        } else if (key == "dialing-local" && !option) {
            cliCommand = "extension update " + extension + " dial local off";
        }
        if (key == "dnd" && option) {
            cliCommand = "extension update " + extension + " dnd on";
        } else if (key == "dnd" && !option) {
            cliCommand = "extension update " + extension + " dnd off";
        }
        if (key == "VM" && option) {
            cliCommand = "extension update " + extension + " vm on";
        } else if (key == "VM" && !option) {
            cliCommand = "extension update " + extension + " vm off";
        }
        if (key == "fwd-no-ans" && option) {
            cliCommand = "extension update " + extension + " cfna " + val + "";
        } else if (key == "fwd-no-ans" && !option) {
            cliCommand = "extension update " + extension + " cfna reset";
        }
        if (key == "fwd-busy" && option) {
            cliCommand = "extension update " + extension + " cfb " + val + "";
        } else if (key == "fwd-busy" && !option) {
            cliCommand = "extension update " + extension + " cfb reset";
        }
        if (key == "fwd-all" && option) {
            cliCommand = "extension update " + extension + " cfa " + val + "";
        } else if (key == "fwd-all" && !option) {
            cliCommand = "extension update " + extension + " cfa reset";
        }
        if (key == "follow-me" && option) {
            cliCommand = "extension update " + extension + " fm " + val + "";
        } else if (key == "follow-me" && !option) {
            cliCommand = "extension update " + extension + " fm reset";
        }
        return cliCommand;
    }

    public void commandaction(String _clicommand, String loggedinuser, JdbcTemplate db, String type) {
        EncryptPassword encrptpasswprd = new EncryptPassword();
        try {
            String outputfilename = "";
            String scode = "";
            String _clicommandencrypt = "";
            try {
                CoralMeetSystemConfig meetconfig = this.meetConfig;
                if (meetconfig != null) {
                    scode = meetconfig.getServercode();
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in commandaction. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            long epochtime = System.currentTimeMillis();
            outputfilename = epochtime + "-" + scode;
            _clicommandencrypt = encrptpasswprd.encrypt(_clicommand);
            this.dbinsert(loggedinuser, outputfilename, _clicommandencrypt, scode, db, type);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in commandaction. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    public void dbinsert(String loggedinuser, String outfilename, String clicommand, String servercode, JdbcTemplate db, String type) {
        loggedinuser = !type.isEmpty() ? "UCAPPID" : "UCAPP-" + loggedinuser;
        String sql = "";
        try {
            sql = "INSERT INTO pbx.t_cliservercommandslog(recordcreatedby,outputfilename,outputfilepath,clicommand,servercode)VALUES (?,?,?,?,?)";
            db.update(sql, new Object[]{loggedinuser, outfilename, "", clicommand, servercode});
        }
        catch (Exception ex) {
            logger.error((Object)("Error in dbinsert. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    @GetMapping(path={"/getucfeaturelist/{contact}"}, produces={"application/json"})
    public ResponseEntity<UCActivatedFeatureListResponse> getUCFeatureList(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for UC Feature List, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        UCActivatedFeatureListResponse objCommonResponse = new UCActivatedFeatureListResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            logger.info((Object)("Request for UC Feature List, By contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new UCActivatedFeatureListResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (contact.isEmpty()) {
            objCommonResponse = new UCActivatedFeatureListResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        ArrayList<UCActivatedFeatureList> returnValue = new ArrayList<UCActivatedFeatureList>();
        List ucFeatureStatusList = null;
        String sql = "";
        try {
            sql = "select extension,coalesce(service_code,'') servicecode,coalesce(data,'') featuredata from pbx.extensions_services where extension = ?";
            ucFeatureStatusList = db.queryForList(sql, new Object[]{contact});
            for (Map _featureCalls : ucFeatureStatusList) {
                try {
                    UCActivatedFeatureList objUCFeature = new UCActivatedFeatureList(_featureCalls.get("extension").toString(), _featureCalls.get("servicecode").toString(), _featureCalls.get("featuredata").toString());
                    returnValue.add(objUCFeature);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting UC feature list from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting UC feature list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = 0;
            response = "UC Activated Feature List";
            objCommonResponse = new UCActivatedFeatureListResponse(responseStatus, response, returnValue);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting UC Feature List. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new UCActivatedFeatureListResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getmastercodelist"}, produces={"application/json"})
    public ResponseEntity<MasterCodeResponse> getMasterCodeList(HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Master Code List";
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        MasterCodeResponse objCommonResponse = new MasterCodeResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String swipeCode = "";
        String vmcode = "";
        String valetParkCode = "";
        String callPickUp = "";
        String callPickUpGroup = "";
        String sql = "";
        List shortCodeList = new ArrayList();
        String callpickuptransfer = "";
        String ccp = "";
        String pccp = "";
        int waitingTimeForOutgoing = 15;
        try {
            sql = "select coalesce(extension,'') callswipecode from pbx.extensions where extension_type = 'csbe' limit 1;";
            swipeCode = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select coalesce(extension,'') callswipecode from pbx.extensions where extension_type = 'vmwacs' limit 1;";
            vmcode = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select coalesce(extension,'') valetparkcode from pbx.extensions where extension_type = 'cpp' limit 1;";
            valetParkCode = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select string_agg(extension,',') callpickup from pbx.extensions where extension_type = 'cpe';";
            callPickUp = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select string_agg(extension,',') callpickupgroup from pbx.extensions where extension_type = 'cpg';";
            callPickUpGroup = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select coalesce(extension,'') ccp from pbx.extensions where extension_type = 'ccp' limit 1;";
            ccp = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select coalesce(extension,'') pccp from pbx.extensions where extension_type = 'pccp' limit 1;";
            pccp = (String)db.query(sql, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            try {
                sql = "select a.id,a.description,a.shortcode,b.extension digits from  (select id,description,shortcode from pbx.m_actioncodelist  union select id,description,shortcode from pbx.codemaster) a inner join pbx.extensions b on a.shortcode = b.extension_type order by id;";
                shortCodeList = db.query(sql, (RowMapper)rowShortCodeList);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting short code list. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting master code list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new MasterCodeResponse(1, ex.getMessage(), "", "", "", "", "", "", "", "", null, waitingTimeForOutgoing);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            CoralMeetSystemConfig meetconfig = this.meetConfig;
            if (meetconfig != null) {
                waitingTimeForOutgoing = meetconfig.getWaitingTimeForOutgoing();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting waitingTimeForOutgoing. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            responseStatus = 0;
            response = "Master Code List";
            objCommonResponse = new MasterCodeResponse(responseStatus, response, swipeCode, vmcode, valetParkCode, callPickUp, callPickUpGroup, callpickuptransfer, ccp, pccp, shortCodeList, waitingTimeForOutgoing);
            ObjectMapper mapper = new ObjectMapper();
            logger.info((Object)("Response For Master Code List " + mapper.writeValueAsString((Object)objCommonResponse)));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting UC Feature List. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new MasterCodeResponse(1, ex.getMessage(), "", "", "", "", "", "", "", "", null, waitingTimeForOutgoing);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public List<PendingVoiceMailDetails> getPendingVoiceMailList(JdbcTemplate db, String contact) {
        ArrayList<PendingVoiceMailDetails> returnValue = new ArrayList<PendingVoiceMailDetails>();
        List pendingVoiceMailDetailsList = null;
        String sql = "";
        try {
            sql = "select coalesce(file_path,'') file_path,coralid,coalesce(cid_number,'') cid_number,created_epoch from voicemail_msgs where username = ? and coalesce(file_path,'') <> '' and read_epoch = 0 and to_timestamp(created_epoch)::date >= (now()::date - 3) order by read_flags,coralid desc";
            pendingVoiceMailDetailsList = db.queryForList(sql, new Object[]{contact});
            for (Map _voiceMails : pendingVoiceMailDetailsList) {
                try {
                    PendingVoiceMailDetails objPendingVoiceMailDetails = new PendingVoiceMailDetails(Long.parseLong(_voiceMails.get("coralid").toString()), _voiceMails.get("cid_number").toString(), _voiceMails.get("file_path").toString(), Long.parseLong(_voiceMails.get("created_epoch").toString()));
                    returnValue.add(objPendingVoiceMailDetails);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting pending voice mails from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting pending voice mails. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return returnValue;
    }

    @GetMapping(path={"/getpendingvoicemails/{contact}"}, produces={"application/json"})
    public ResponseEntity<PendingVoiceMailDetailsResponse> getPendingVoiceMails(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        PendingVoiceMailDetailsResponse objCommonResponse = new PendingVoiceMailDetailsResponse();
        if (!(this.meetConfig == null || this.meetConfig.getVoicemailserver().isEmpty() || this.meetConfig.getVoicemailserver().equals("127.0.0.1") || this.meetConfig.getVoicemailserver().equals("localhost"))) {
            logger.info((Object)"External voice mail server is defined, so accessing voice mail details from there.");
            objCommonResponse = this.PushVoiceMailRequestToVoiceMailServer(contact, this.meetConfig.getVoicemailserver());
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        String responseMessage = "Request for pending voice mail list, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        List listPendingVoiceMailDetails = new ArrayList();
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            logger.info((Object)("Request for pending voice mail list, By contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new PendingVoiceMailDetailsResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (contact.isEmpty()) {
            objCommonResponse = new PendingVoiceMailDetailsResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            listPendingVoiceMailDetails = this.getPendingVoiceMailList(db, contact);
            responseStatus = 0;
            response = "Pending Voicemail List";
            logger.info((Object)("Pending Voicemail List : " + listPendingVoiceMailDetails.size()));
            objCommonResponse = new PendingVoiceMailDetailsResponse(responseStatus, response, listPendingVoiceMailDetails);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting pending mails lists. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new PendingVoiceMailDetailsResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(value={"/downloadvoicemail"})
    public void downloadPendingVoiceMail(HttpServletResponse response, @RequestParam(defaultValue="") String contact, @RequestParam(defaultValue="") String coralrecordid, @RequestParam(defaultValue="") String filePath) {
        if (!(this.meetConfig == null || this.meetConfig.getVoicemailserver().isEmpty() || this.meetConfig.getVoicemailserver().equals("127.0.0.1") || this.meetConfig.getVoicemailserver().equals("localhost"))) {
            logger.info((Object)"External voice mail server is defined, so downloading voice mail from voice mail server.");
            String url = this.DownloadVoiceMailFromVoiceMailServer(contact, this.meetConfig.getVoicemailserver(), coralrecordid, filePath);
            try {
                BufferedInputStream inStream = new BufferedInputStream(new URL(url).openStream());
                BufferedOutputStream outStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.flush();
                inStream.close();
                return;
            }
            catch (IOException ex) {
                logger.error((Object)("Error in downloadPendingVoiceMail. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in downloadPendingVoiceMail. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        String cid_number = "";
        int created_epoch = 0;
        int coralid = 0;
        String sql = "";
        String responseMessage = "Request for downloadPendingVoiceMail, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            coralrecordid = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)coralrecordid)));
            filePath = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)filePath)));
            coralid = Integer.parseInt(coralrecordid);
            logger.info((Object)("Request for downloadPendingVoiceMail, By contact no,recordid,filePath -> " + contact + ", " + coralrecordid + ", " + filePath));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            return;
        }
        if (contact.isEmpty()) {
            logger.info((Object)"Invalid Input : Empty Contact Number.");
            return;
        }
        try {
            if (filePath.isEmpty() || coralid == 0) {
                logger.info((Object)("No pending voice mail for -> " + contact));
                return;
            }
            MediaType mediaType = MediaTypeUtils.getMediaTypeForFileName((ServletContext)this.servletContext, (String)filePath);
            File file = new File(filePath);
            response.setContentType(mediaType.getType());
            response.setHeader("Content-Disposition", "attachment;filename=" + cid_number + "_" + created_epoch + "_" + file.getName());
            response.setContentLength((int)file.length());
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream outStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            outStream.flush();
            inStream.close();
            sql = "update voicemail_msgs set read_epoch = extract(epoch from now()::timestamp(0)) where coralid = ?";
            db.update(sql, new Object[]{coralid});
        }
        catch (Exception ex) {
            logger.error((Object)("Error in downloadPendingVoiceMail. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    @GetMapping(value={"/downloadvoicemailv1"})
    public void downloadPendingVoiceMailV1(HttpServletResponse response, @RequestParam(defaultValue="") String contact, @RequestParam(defaultValue="") String coralrecordid) {
        String cid_number = "";
        int created_epoch = 0;
        int coralid = 0;
        String sql = "";
        String filePath = "";
        String responseMessage = "Request for downloadPendingVoiceMail, By contact no -> " + contact;
        logger.info((Object)responseMessage);
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            coralrecordid = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)coralrecordid)));
            coralid = Integer.parseInt(coralrecordid);
            sql = "select coalesce(file_path,'') file_path from voicemail_msgs where coralid = ? limit 1;";
            filePath = (String)db.query(sql, new Object[]{coralid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            logger.info((Object)("Request for downloadPendingVoiceMail, By contact no,recordid,filePathc -> " + contact + ", " + coralrecordid + ", " + filePath));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            return;
        }
        if (contact.isEmpty()) {
            logger.info((Object)"Invalid Input : Empty Contact Number.");
            return;
        }
        try {
            if (filePath.isEmpty() || coralid == 0) {
                logger.info((Object)("No pending voice mail for -> " + contact));
                return;
            }
            MediaType mediaType = MediaTypeUtils.getMediaTypeForFileName((ServletContext)this.servletContext, (String)filePath);
            File file = new File(filePath);
            response.setContentType(mediaType.getType());
            response.setHeader("Content-Disposition", "attachment;filename=" + cid_number + "_" + created_epoch + "_" + file.getName());
            response.setContentLength((int)file.length());
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream outStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            outStream.flush();
            inStream.close();
            sql = "update voicemail_msgs set read_epoch = extract(epoch from now()::timestamp(0)) where coralid = ?";
            db.update(sql, new Object[]{coralid});
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting UC Feature List. Error -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    @PostMapping(path={"/pushfmsnotificationtoserver"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> pushFMSNotificationToServer(@RequestParam(value="caller") String caller, @RequestParam(value="callee") String callee, @RequestParam(defaultValue="") String callid, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Push Notification To Google Server, By caller, callee -> " + caller + ", " + callee;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String deviceType = "";
        try {
            if (caller.isEmpty() || callee.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            CalleeDetailsForFMS objCalleeDetailsForFMS = this.GetCalleeDeatils(db, callee);
            deviceType = objCalleeDetailsForFMS.getDevicetype();
            if (deviceType.equalsIgnoreCase("ios")) {
                this.PushNotificationMessageToAPNSV1(callee, objCalleeDetailsForFMS.getAppid(), caller, callid, objCalleeDetailsForFMS.isApnsdev());
            } else {
                this.PushDataMessageToGoogleServerAsync(callee, caller, objCalleeDetailsForFMS.getAppid());
            }
            responseStatus = 0;
            response = "Message Pushed to Server.";
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Push Notification To Google Server. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/pushwakeupnotificationtodevice"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> pushwakeupnotificationtodevice(HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Push Wakeup Notification To Android Devices";
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String deviceType = "";
        List buddyStatusList = null;
        String sql = "";
        String callee = "";
        String calleename = "";
        String appid = "";
        try {
            sql = "select extension,coalesce(Name,'') extensionanme,coalesce(column14,'') devicetype,coalesce(applicationid,'') applicationid\r\nfrom pbx.extensions where coalesce(applicationid,'') <> ''";
            buddyStatusList = db.queryForList(sql);
            logger.info((Object)"###################################################################################");
            for (Map _buddyCalls : buddyStatusList) {
                try {
                    callee = _buddyCalls.get("extension").toString();
                    calleename = _buddyCalls.get("extensionanme").toString();
                    appid = _buddyCalls.get("applicationid").toString();
                    deviceType = _buddyCalls.get("devicetype").toString();
                    if (deviceType.equalsIgnoreCase("ios")) {
                        logger.info((Object)(calleename + "(" + callee + ") is using ios, No need to send wakeup message"));
                        continue;
                    }
                    this.PushDataMessageToGoogleServerAsync(callee, calleename, appid);
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting extension from db. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            logger.info((Object)"###################################################################################");
            responseStatus = 0;
            response = "Message Pushed to All Android Device.";
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in Push Wakeup Notification To Android Devices. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public CalleeDetailsForFMS GetCalleeDeatils(JdbcTemplate db, String caller_Destination_Number) {
        logger.info((Object)("Trying to find out Callee Details : " + caller_Destination_Number));
        CalleeDetailsForFMS objCalleeDetailsForFMS = new CalleeDetailsForFMS();
        String sql = "";
        try {
            String apndDevUsers = "";
            if (this.meetConfig != null && !this.meetConfig.getApnsdevuser().isEmpty()) {
                apndDevUsers = this.meetConfig.getApnsdevuser().trim();
            }
            List calleeDetails = null;
            sql = "select coalesce(applicationid,'') applicationid,coalesce(column14,'') devicetype from pbx.extensions where coalesce(extension,'') = ? limit 1;";
            calleeDetails = db.queryForList(sql, new Object[]{caller_Destination_Number});
            if (calleeDetails.size() > 0) {
                for (Map obj : calleeDetails) {
                    try {
                        objCalleeDetailsForFMS.setNumber(caller_Destination_Number);
                        objCalleeDetailsForFMS.setDevicetype(obj.get("devicetype").toString());
                        objCalleeDetailsForFMS.setAppid(obj.get("applicationid").toString());
                        boolean apndDev = ("," + apndDevUsers + ",").contains("," + caller_Destination_Number + ",");
                        objCalleeDetailsForFMS.setApnsdev(apndDev);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Callee details. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return objCalleeDetailsForFMS;
    }

    public void PushDataMessageToGoogleServerAsync(String callee, String calleename, String appID) {
        try {
            String body = "{\r\n\"data\":{\r\n  \"message\" : \"WAKEUP.\",\r\n  \"title\" : \"New Call\",\r\n},\r\n\"android\":{\r\n  \"priority\":\"high\"\r\n},\r\n\"apns\":{\r\n  \"headers\":{\r\n\t\"apns-priority\":\"10\"\r\n  }\r\n},\r\n\"priority\":10,\r\n  \"to\":\"" + appID + "\"\r\n}";
            Client client = Client.create();
            AsyncWebResource webResource = client.asyncResource("https://fcm.googleapis.com/fcm/send");
            Future response = ((AsyncWebResource.Builder)webResource.header("Content-Type", (Object)"application/json").header("Authorization", (Object)"key=AAAAGVilguA:APA91bEJ1TNZ8krhAY1gHNCFLxhU-9DeTWJ5AIxFY8fCNMajTfN6G40Ls0eR8lq1EnO-pUSmESfaAXtvvBKwrXg7AK07-A0tLGEv6Ed89Zbdd9lGwbd4HN_jFttGSjdIedNdN1KtngOA")).post(ClientResponse.class, (Object)body);
            if (((ClientResponse)response.get()).getStatus() != 200) {
                logger.error((Object)("Failed : HTTP error code : " + ((ClientResponse)response.get()).getStatus()));
                throw new RuntimeException("Failed : HTTP error code : " + ((ClientResponse)response.get()).getStatus());
            }
            String output = (String)((ClientResponse)response.get()).getEntity(String.class);
            logger.info((Object)("Regular Wakeup Message Sent To. -> : " + calleename + "(" + callee + ") , Response -> " + output));
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at PushMessageToGoogleServerAsync(), Unable to Send Message to Ext. -> " + calleename + "(" + callee + "). Error:" + ex.getMessage()), (Throwable)ex);
        }
    }

    public void PushNotificationMessageToGoogleServerAsync(String extension, String appID, String Caller_Caller_ID_Number) {
        try {
            if (extension.isEmpty() || appID.isEmpty() || Caller_Caller_ID_Number.isEmpty()) {
                logger.info((Object)"Please send all required details");
                return;
            }
            String message = mPushNotificationMessage;
            if (this.meetConfig != null && !this.meetConfig.getPushnotificationmessage().isEmpty()) {
                message = this.meetConfig.getPushnotificationmessage().trim();
            }
            message = message + " ";
            message = message + Caller_Caller_ID_Number;
            logger.info((Object)"In PushMessageToGoogleServerAsync() Method");
            String body = "{\r\n  \"data\":{\r\n    \"title\":\"CALL\",\r\n    \"message\":\"" + message + "\"\r\n  },\r\n\r\n\"notification\":{\r\n  \"body\" : \"" + message + "\",\r\n  \"title\" : \"CALL\",\r\n},\r\n\"android\":{\r\n  \"priority\":\"high\"\r\n},\r\n\"apns\":{\r\n  \"headers\":{\r\n\t\"apns-priority\":\"10\"\r\n  }\r\n},\r\n\"priority\":10,\r\n  \"to\":\"" + appID + "\"\r\n}";
            logger.info((Object)("In PushMessageToGoogleServerAsync() Request Created. --> " + body));
            Client client = Client.create();
            AsyncWebResource webResource = client.asyncResource("https://fcm.googleapis.com/fcm/send");
            Future response = ((AsyncWebResource.Builder)webResource.header("Content-Type", (Object)"application/json").header("Authorization", (Object)"key=AAAAGVilguA:APA91bEJ1TNZ8krhAY1gHNCFLxhU-9DeTWJ5AIxFY8fCNMajTfN6G40Ls0eR8lq1EnO-pUSmESfaAXtvvBKwrXg7AK07-A0tLGEv6Ed89Zbdd9lGwbd4HN_jFttGSjdIedNdN1KtngOA")).post(ClientResponse.class, (Object)body);
            if (((ClientResponse)response.get()).getStatus() != 200) {
                logger.error((Object)("Failed : HTTP error code : " + ((ClientResponse)response.get()).getStatus()));
                throw new RuntimeException("Failed : HTTP error code : " + ((ClientResponse)response.get()).getStatus());
            }
            String output = (String)((ClientResponse)response.get()).getEntity(String.class);
            logger.info((Object)("PushMessageToGoogleServerAsync Output For Ext. -> : " + extension + ", Response -> " + output));
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at PushMessageToGoogleServerAsync(), Unable to Send Message to Ext. -> " + extension + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
    }

    public void PushNotificationMessageToAPNS(String extension, String appID, String Caller_Caller_ID_Number, String callid, boolean isapnsdev) {
        try {
            logger.info((Object)"In PushNotificationMessageToAPNS() Method");
            if (extension.isEmpty() || appID.isEmpty() || Caller_Caller_ID_Number.isEmpty() || callid.isEmpty()) {
                logger.info((Object)("PushNotificationMessageToAPNS : Please send all required details: callid : " + callid));
                return;
            }
            String message = mPushNotificationMessage;
            if (this.meetConfig != null && !this.meetConfig.getPushnotificationmessage().isEmpty()) {
                message = this.meetConfig.getPushnotificationmessage().trim();
            }
            message = message + " ";
            message = message + Caller_Caller_ID_Number;
            InputStream caertificate = this.loadDirectory("com.coraltele.clouduc._voip.p12");
            ApnsClient apnsClient = new ApnsClientBuilder().setApnsServer(isapnsdev ? "api.sandbox.push.apple.com" : "api.push.apple.com").setClientCredentials(caertificate, certificatePassword).build();
            String payload = "{\"aps\":{\"call-id\":\"" + callid + "\",\"alert\":\"" + message + "\",\"badge\":0,\"sound\":\"default\"}}";
            String token = TokenUtil.sanitizeTokenString((String)appID);
            this.pushNotification = new SimpleApnsPushNotification(token, "com.coraltele.coraluc.voip", payload, null, DeliveryPriority.IMMEDIATE, PushType.VOIP);
            PushNotificationFuture sendNotificationFuture = apnsClient.sendNotification((ApnsPushNotification)this.pushNotification);
            try {
                PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)sendNotificationFuture.get();
                if (pushNotificationResponse.isAccepted()) {
                    logger.info((Object)"Push notification accepted by APNs gateway.");
                } else {
                    logger.error((Object)("Notification rejected by the APNs gateway: " + pushNotificationResponse.getRejectionReason()));
                    pushNotificationResponse.getTokenInvalidationTimestamp().ifPresent(timestamp -> logger.error((Object)("\t\u2026and the token is invalid as of " + timestamp)));
                }
            }
            catch (ExecutionException ex) {
                logger.error((Object)("PushNotificationMessageToAPNS(), Failed to send push notification." + ex.getMessage()), (Throwable)ex);
            }
            sendNotificationFuture.whenComplete((response, cause) -> {
                if (response != null) {
                    logger.info((Object)("PushNotificationMessageToAPNS Output For Ext. -> : " + extension + ", Response -> " + response));
                } else {
                    cause.printStackTrace();
                }
            });
            apnsClient.close();
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at PushNotificationMessageToAPNS(), Unable to Send Message to Ext. -> " + extension + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
    }

    public void PushNotificationMessageToAPNSV1(String extension, String appID, String Caller_Caller_ID_Number, String callid, boolean isapnsdev) {
        try {
            logger.info((Object)"In PushNotificationMessageToAPNSV1() Method");
            if (extension.isEmpty() || appID.isEmpty() || Caller_Caller_ID_Number.isEmpty() || callid.isEmpty()) {
                logger.info((Object)("PushNotificationMessageToAPNSV1 : Please send all required details: callid : " + callid));
                return;
            }
            String message = mPushNotificationMessage;
            String topic = "com.coraltele.sanchar.voip";
            if (this.meetConfig != null && !this.meetConfig.getPushnotificationmessage().isEmpty()) {
                message = this.meetConfig.getPushnotificationmessage().trim();
                topic = this.meetConfig.getApnTopic();
            }
            message = message + " ";
            message = message + Caller_Caller_ID_Number;
            String certificateToBeLoad = "voip.p12";
            certificateToBeLoad = isapnsdev ? "/etc/coraltelecom/voip_dev.p12" : "/etc/coraltelecom/voip_prod.p12";
            logger.info((Object)("PushNotificationMessageToAPNSV1. Loading Certificate from path : " + certificateToBeLoad + ", for topic : " + topic));
            InputStream certificate = this.loadDirectoryFromPath(certificateToBeLoad);
            ApnsClient apnsClient = new ApnsClientBuilder().setApnsServer(isapnsdev ? "api.sandbox.push.apple.com" : "api.push.apple.com").setClientCredentials(certificate, certificatePassword).build();
            String payload = "{\"aps\":{\"call-id\":\"" + callid + "\",\"callUUID\":\"" + callid + "\",\"alert\":\"" + message + "\",\"badge\":0,\"sound\":\"default\"}}";
            String token = TokenUtil.sanitizeTokenString((String)appID);
            this.pushNotification = new SimpleApnsPushNotification(token, topic, payload, null, DeliveryPriority.IMMEDIATE, PushType.VOIP);
            PushNotificationFuture sendNotificationFuture = apnsClient.sendNotification((ApnsPushNotification)this.pushNotification);
            try {
                PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)sendNotificationFuture.get();
                if (pushNotificationResponse.isAccepted()) {
                    logger.info((Object)"Push notification accepted by APNs gateway.");
                } else {
                    logger.error((Object)("Notification rejected by the APNs gateway: " + pushNotificationResponse.getRejectionReason()));
                    pushNotificationResponse.getTokenInvalidationTimestamp().ifPresent(timestamp -> logger.error((Object)("\t\u2026and the token is invalid as of " + timestamp)));
                }
            }
            catch (ExecutionException ex) {
                logger.error((Object)("PushNotificationMessageToAPNSV1(), Failed to send push notification." + ex.getMessage()), (Throwable)ex);
            }
            sendNotificationFuture.whenComplete((response, cause) -> {
                if (response != null) {
                    logger.info((Object)("PushNotificationMessageToAPNSV1 Output For Ext. -> : " + extension + ", Response -> " + response));
                } else {
                    cause.printStackTrace();
                }
            });
            apnsClient.close();
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at PushNotificationMessageToAPNSV1(), Unable to Send Message to Ext. -> " + extension + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
    }

    InputStream loadDirectory(String path) {
        Resource resource = this.resourceLoader.getResource("classpath:" + path);
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            logger.error((Object)("Issue with loading path " + path + " as file : " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    InputStream loadDirectoryFromPath(String path) {
        File file = new File(path);
        try {
            return new FileInputStream(file);
        }
        catch (IOException ex) {
            logger.error((Object)("Issue with loading path " + path + " as file : " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @GetMapping(path={"/getcalleestatus/{contact}"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> getCalleeStatus(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Callee Status For contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "3";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbKamailio = new JdbcTemplate(this.dsKamailio);
        try {
            logger.info((Object)("Request for Callee Status For contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (contact.isEmpty()) {
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            response = Integer.toString(this.getCalleeStatusFromDB(db, contact, dbKamailio));
            responseStatus = 0;
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting callee status. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getcalleestatusstr/{contact}"}, produces={"application/json"})
    public String getCalleeStatusStr(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Callee Status For contact no -> " + contact;
        logger.info((Object)responseMessage);
        String response = "3";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        JdbcTemplate dbKamailio = new JdbcTemplate(this.dsKamailio);
        try {
            logger.info((Object)("Request for Callee Status For contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            return "-1";
        }
        if (contact.isEmpty()) {
            return "-1";
        }
        try {
            response = Integer.toString(this.getCalleeStatusFromDB(db, contact, dbKamailio));
            return response;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting callee status. Error -> " + ex.getMessage()), (Throwable)ex);
            return "-1";
        }
    }

    public int getCalleeStatusFromDB(JdbcTemplate db, String contact, JdbcTemplate dbKamailio) {
        int returnValue = 3;
        String sql = "";
        int subscriberExist = 0;
        try {
            sql = "select count(*) from subscriber where username = ?";
            subscriberExist = (Integer)dbKamailio.queryForObject(sql, new Object[]{contact}, Integer.class);
            if (subscriberExist == 0) {
                return 3;
            }
            sql = "select count(*) from pbx.extensions where extension  = ? and coalesce(applicationid,'') <> '';";
            subscriberExist = (Integer)db.queryForObject(sql, new Object[]{contact}, Integer.class);
            returnValue = subscriberExist == 1 ? 1 : 2;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting buddy status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return returnValue;
    }

    public PendingVoiceMailDetailsResponse PushVoiceMailRequestToVoiceMailServer(String contact, String voicemailserverip) {
        PendingVoiceMailDetailsResponse objCommonResponse = new PendingVoiceMailDetailsResponse();
        String voiceMailServerIp = "";
        try {
            voiceMailServerIp = "http://" + voicemailserverip.trim() + ":8061/coraluc/phoneapi/v1/getpendingvoicemails/";
            voiceMailServerIp = voiceMailServerIp + contact;
            if (voiceMailServerIp.isEmpty() || contact.isEmpty()) {
                logger.info((Object)"Please send all required details");
                return objCommonResponse;
            }
            logger.info((Object)("In PushVoiceMailRequestToVoiceMailServer() Method, Voice Mail Server IP : " + voiceMailServerIp));
            String body = "";
            logger.info((Object)("In PushVoiceMailRequestToVoiceMailServer() Request Created. --> " + body));
            DefaultClientConfig defaultClientConfig = new DefaultClientConfig();
            defaultClientConfig.getClasses().add(JacksonJsonProvider.class);
            Client client = Client.create((ClientConfig)defaultClientConfig);
            WebResource webResource = client.resource(voiceMailServerIp);
            ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
            if (response.getStatus() != 200) {
                logger.error((Object)("Failed : HTTP error code : " + response.getStatus()));
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            ObjectMapper mapper = new ObjectMapper();
            objCommonResponse = (PendingVoiceMailDetailsResponse)mapper.readValue((String)response.getEntity(String.class), PendingVoiceMailDetailsResponse.class);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at PushVoiceMailRequestToVoiceMailServer(), Unable to get voice mail details for. -> " + contact + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
        return objCommonResponse;
    }

    public String DownloadVoiceMailFromVoiceMailServer(String contact, String voicemailserverip, String coralrecordid, String filePath) {
        String voiceMailServerIp = "";
        try {
            voiceMailServerIp = "http://" + voicemailserverip.trim() + ":8061/coraluc/phoneapi/v1/downloadvoicemail";
            voiceMailServerIp = voiceMailServerIp + "?";
            voiceMailServerIp = voiceMailServerIp + "contact=";
            voiceMailServerIp = voiceMailServerIp + contact;
            voiceMailServerIp = voiceMailServerIp + "&";
            voiceMailServerIp = voiceMailServerIp + "coralrecordid=";
            voiceMailServerIp = voiceMailServerIp + coralrecordid;
            voiceMailServerIp = voiceMailServerIp + "&";
            voiceMailServerIp = voiceMailServerIp + "filePath=";
            voiceMailServerIp = voiceMailServerIp + filePath;
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at DownloadVoiceMailFromVoiceMailServer(), Unable to get voice mail details for. -> " + contact + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
        return voiceMailServerIp;
    }

    @PostMapping(path={"/updatetoken"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateToken(@RequestParam(value="contact") String contact, @RequestParam(value="token") String token, @RequestParam(defaultValue="") String mobileos, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for updating token, By caller, token -> " + contact + ", " + token;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            token = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)token)));
            if (!mobileos.isEmpty()) {
                mobileos = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)mobileos)));
            }
            responseMessage = "Request for updating token, By caller, token -> " + contact + ", " + token + ", " + mobileos;
            logger.info((Object)responseMessage);
            if (contact.isEmpty() || token.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            String sql = "";
            try {
                String cliCommand = "";
                cliCommand = "extension update " + contact + " applicationid " + token;
                try {
                    if (!cliCommand.isEmpty()) {
                        logger.info((Object)("cliCommand : " + cliCommand));
                        this.commandaction(cliCommand, contact, db, "UCAPPID");
                    }
                    responseStatus = 0;
                    response = "Token command registered successully";
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                sql = "update pbx.extensions set applicationid = ?,column14 = ? where coalesce(extension,'') = ?;";
                db.update(sql, new Object[]{token, mobileos, contact});
                responseStatus = 0;
                response = "Token Updated On Server.";
            }
            catch (Exception ex) {
                logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
                responseStatus = 1;
                response = "Error. In Token Updation On Server.";
            }
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updatetokeninternal"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateTokenInternal(@RequestParam(value="contact") String contact, @RequestParam(value="token") String token, @RequestParam(defaultValue="") String mobileos, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for updating token, By caller, token -> " + contact + ", " + token + ", " + mobileos;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            if (contact.isEmpty() || token.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            String sql = "";
            try {
                sql = "update pbx.extensions set applicationid = ?,column14 = ? where coalesce(extension,'') = ?;";
                db.update(sql, new Object[]{token, mobileos, contact});
                responseStatus = 0;
                response = "Token Updated On Server.";
            }
            catch (Exception ex) {
                logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
                responseStatus = 1;
                response = "Error. In Token Updation On Server.";
            }
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating token. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updatefeatureinternal"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateFeatureInternal(@RequestParam(value="contact") String contact, @RequestParam(value="featurecode") String featurecode, @RequestParam(value="featurecodedata") String featurecodedata, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for updating feature, By contact no -> " + contact + ", " + featurecode + ", " + featurecodedata;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String cliCommand = "";
        try {
            String[] _loginid = contact.split(",");
            String[] _featurecode = featurecode.split(",");
            String[] _featurecodedata = featurecodedata.split(",");
            contact = _loginid[0];
            featurecode = _featurecode[0];
            featurecodedata = _featurecodedata[0];
            responseMessage = "Request for updating feature, By contact no -> " + contact + ", " + featurecode + ", " + featurecodedata;
            logger.info((Object)responseMessage);
            if ((featurecode.startsWith("callforward") || featurecode.startsWith("followme")) && (featurecodedata.isEmpty() || featurecodedata.equalsIgnoreCase("na"))) {
                featurecodedata = "";
            }
            if (contact.isEmpty() || featurecode.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (featurecode.equalsIgnoreCase("dialout")) {
                cliCommand = this.updateRecords("dialing-intercom", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("diallocal")) {
                cliCommand = this.updateRecords("dialing-local", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dialstd")) {
                cliCommand = this.updateRecords("dialing-std", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dialisd")) {
                cliCommand = this.updateRecords("dialing-isd", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("dnd")) {
                cliCommand = this.updateRecords("dnd", featurecodedata.equalsIgnoreCase("true"), "", contact);
            } else if (featurecode.equalsIgnoreCase("callforward-always")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-all", false, "", contact) : this.updateRecords("fwd-all", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("callforward-noanswer")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-all", false, "", contact) : this.updateRecords("fwd-all", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("callforward-busy")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("fwd-busy", false, "", contact) : this.updateRecords("fwd-busy", true, featurecodedata, contact);
            } else if (featurecode.equalsIgnoreCase("followme")) {
                cliCommand = featurecodedata == "" ? this.updateRecords("follow-me", false, "", contact) : this.updateRecords("follow-me", true, featurecodedata, contact);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (!cliCommand.isEmpty()) {
                logger.info((Object)("cliCommand : " + cliCommand));
                this.commandaction(cliCommand, contact, db, "");
            }
            responseStatus = 0;
            response = "Feature updated successully";
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getucfeatureadmin/{contact}"}, produces={"application/json"})
    public ResponseEntity<UCFeatureListAdmin> getUCFeatureListAdmin(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for UC Feature Restricted by Admin, for contact no -> " + contact;
        logger.info((Object)responseMessage);
        UCFeatureListAdmin objCommonResponse = new UCFeatureListAdmin();
        int videorightrestricted = 0;
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String sipServerURL = "";
        SipServerFeatureCode objSipServerFeatureCode = new SipServerFeatureCode();
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            logger.info((Object)("Request for UC Feature List, By contact no -> " + contact));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new UCFeatureListAdmin(0, 0, 0, 0, 0, 0, 0, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (contact.isEmpty()) {
            objCommonResponse = new UCFeatureListAdmin(0, 0, 0, 0, 0, 0, 0, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            CoralMeetSystemConfig meetconfig = this.meetConfig;
            if (meetconfig != null) {
                sipServerURL = meetconfig.getSipserverurl().trim();
                sipServerURL = sipServerURL + "/featurestatus";
                logger.info((Object)("sipServerURL : " + sipServerURL));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in commandaction. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        if (sipServerURL.isEmpty()) {
            objCommonResponse = new UCFeatureListAdmin(0, 0, 0, 0, 0, 0, 0, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            String output;
            ObjectMapper mapper = new ObjectMapper();
            SipServerAPIObject obj = new SipServerAPIObject();
            obj.setExtension(contact);
            String body = mapper.writeValueAsString((Object)obj);
            sipServerURL = sipServerURL + "?extension=" + contact;
            logger.info((Object)("API Body : " + sipServerURL + ", " + body));
            Client client = Client.create();
            WebResource webResource = client.resource(sipServerURL);
            ClientResponse response = (ClientResponse)webResource.type("application/x-www-form-urlencoded").post(ClientResponse.class);
            if (response.getStatus() != 200) {
                logger.error((Object)("Failed : HTTP error code : " + response.getStatus()));
            }
            if (!(output = (String)response.getEntity(String.class)).isEmpty()) {
                objSipServerFeatureCode = (SipServerFeatureCode)mapper.readValue(output, SipServerFeatureCode.class);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Exception at getUCFeatureListAdmin(), Unable to get Feature state for EXT. -> " + contact + ". Error:" + ex.getMessage()), (Throwable)ex);
        }
        try {
            String sql = "select coalesce(enablevideocall,false) enablevideocall from pbx.extensions where extension_type = 'phone' and extension = ? limit 1;";
            videorightrestricted = (Integer)db.query(sql, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            objCommonResponse = objSipServerFeatureCode != null ? new UCFeatureListAdmin(objSipServerFeatureCode.getDnd(), objSipServerFeatureCode.getCfa(), objSipServerFeatureCode.getFollowme(), objSipServerFeatureCode.getLocal(), objSipServerFeatureCode.getIntercom(), objSipServerFeatureCode.getStd(), objSipServerFeatureCode.getIsd(), videorightrestricted) : new UCFeatureListAdmin(0, 0, 0, 0, 0, 0, 0, videorightrestricted);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting UC Feature Restricted by Admin. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new UCFeatureListAdmin(0, 0, 0, 0, 0, 0, 0, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updateregistrationstatus"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateRegistrationStatus(@RequestParam(value="number") String number, @RequestParam(defaultValue="") String contact, @RequestParam(defaultValue="") String wanIp, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String carrier;
        int isappuser;
        String imeinumber;
        String sql;
        JdbcTemplate db;
        CommandResponse objCommonResponse;
        String response;
        int responseStatus;
        block34: {
            String responseMessage = "Request for updating registration status, For number -> " + number + ", " + contact + ", wanIp : " + wanIp;
            logger.info((Object)responseMessage);
            responseStatus = -1;
            response = "";
            objCommonResponse = new CommandResponse();
            db = new JdbcTemplate(this.dsSwitch);
            sql = "";
            imeinumber = "";
            isappuser = 0;
            boolean isIOSApp = false;
            carrier = "";
            try {
                contact = CoralUCPhoneController.Base64decode((String)contact);
                logger.info((Object)("Request for updating registration status, For number -> " + number + ", " + contact));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            }
            try {
                if (number.isEmpty()) {
                    logger.info((Object)"Invalid Input : ");
                    objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            try {
                sql = "select coalesce(carrier,'') carrier from waninterfaces where coalesce(wanip,'') = ?";
                carrier = (String)db.query(sql, new Object[]{wanIp}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in finding out carrier : " + ex.getMessage()), (Throwable)ex);
            }
            try {
                if (contact.isEmpty()) break block34;
                String pnpridArray = "";
                String pnprovider = "";
                if (contact.contains("pn-prid=")) {
                    pnpridArray = contact.split("pn-prid=").length > 1 ? contact.split("pn-prid=")[1] : "";
                    String string = pnprovider = contact.split("pn-provider=").length > 1 ? contact.split("pn-provider=")[1] : "";
                    if (pnprovider != null && !pnprovider.isEmpty()) {
                        pnprovider = pnprovider.split(";")[0];
                        logger.info((Object)("pnprovider : " + pnprovider));
                        if (pnprovider.toLowerCase().startsWith("apns")) {
                            isIOSApp = true;
                        }
                    }
                } else {
                    String string = pnpridArray = contact.split("remote&").length > 1 ? contact.split("remote&")[1] : "";
                }
                if (isIOSApp) {
                    String pnpridValue = "";
                    if (pnpridArray == null || pnpridArray.isEmpty()) break block34;
                    pnpridValue = pnpridArray.split(";")[0];
                    if (pnpridValue != null && !pnpridValue.isEmpty()) {
                        pnpridValue = pnpridValue.split(":voip")[0];
                    }
                    logger.info((Object)("IOS token : " + pnpridValue));
                    if (pnpridValue.isEmpty()) break block34;
                    String cliCommand = "";
                    cliCommand = "extension update " + number + " applicationid " + pnpridValue;
                    try {
                        if (!cliCommand.isEmpty()) {
                            logger.info((Object)("cliCommand : " + cliCommand));
                            this.commandaction(cliCommand, number, db, "UCAPPID");
                        }
                        responseStatus = 0;
                        response = "Token command registered successully";
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                    sql = "update pbx.extensions set applicationid = ?,column14 = ? where coalesce(extension,'') = ?;";
                    db.update(sql, new Object[]{pnpridValue, "ios", number});
                    logger.info((Object)"Token and OS updated in extension table.");
                    break block34;
                }
                String appIdTag = "";
                if (contact.contains("pn-prid=")) {
                    appIdTag = "pn-prid=";
                } else if (contact.contains("pn-tok=")) {
                    appIdTag = "pn-tok=";
                }
                if (appIdTag.isEmpty()) break block34;
                String pntokArray = contact.split(appIdTag).length > 1 ? contact.split(appIdTag)[1] : "";
                String pntokValue = "";
                if (pntokArray == null || pntokArray.isEmpty()) break block34;
                pntokValue = pntokArray.split(";")[0];
                logger.info((Object)("Android token : " + pntokValue));
                if (pntokValue.isEmpty()) break block34;
                String cliCommand = "";
                cliCommand = "extension update " + number + " applicationid " + pntokValue;
                try {
                    if (!cliCommand.isEmpty()) {
                        logger.info((Object)("cliCommand : " + cliCommand));
                        this.commandaction(cliCommand, number, db, "UCAPPID");
                    }
                    responseStatus = 0;
                    response = "Token command registered successully";
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting missed calls lists. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                sql = "update pbx.extensions set applicationid = ?,column14 = '' where coalesce(extension,'') = ?;";
                db.update(sql, new Object[]{pntokValue, number});
                logger.info((Object)"Token and OS updated in extension table.");
            }
            catch (Exception ex) {
                logger.error((Object)("Error in updating applicationid. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        try {
            sql = "select coalesce(imeinumber,'') imeinumber from pbx.extensions where coalesce(imeinumber,'') <> '' and extension = ?";
            imeinumber = (String)db.query(sql, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select count(*) count from pbx.extensions where extension = ? and coalesce(applicationid,'') <> '';";
            isappuser = (Integer)db.query(sql, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (imeinumber.isEmpty()) {
                sql = "insert into pbx.t_registrationstatus(requesttype,registeredip,sip_user,sip_contact,createdby,datasyncedtoip)values(?,?,?,?,?,?);";
                db.update(sql, new Object[]{"insert", "127.0.0.1", number, contact, carrier, wanIp});
                responseStatus = 0;
                response = "Registration Status Updated.";
            } else if (!contact.isEmpty()) {
                String imeiArray = contact.split("app-imei=").length > 1 ? contact.split("app-imei=")[1] : "";
                String imeiValue = "";
                if (imeiArray != null && !imeiArray.isEmpty()) {
                    imeiValue = imeiArray.split(";")[0];
                    logger.info((Object)("imeiValue : " + imeiValue));
                    imeiValue = CoralUCPhoneController.decryptReg((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)imeiValue)));
                    imeinumber = "," + imeinumber + ",";
                    imeiValue = "," + imeiValue + ",";
                    logger.info((Object)("imeinumber : " + imeinumber + ", imeiValue : " + imeiValue));
                    if (imeinumber.contains(imeiValue)) {
                        sql = "insert into pbx.t_registrationstatus(requesttype,registeredip,sip_user,sip_contact,createdby,datasyncedtoip)values(?,?,?,?,?,?);";
                        db.update(sql, new Object[]{"insert", "127.0.0.1", number, contact, carrier, wanIp});
                        responseStatus = 0;
                        response = "Registration Status Updated.";
                        logger.info((Object)"Registration Status Updated.");
                    } else {
                        responseStatus = 403;
                        response = "Invalid IMEI.Un-Authorized access.";
                        logger.info((Object)"Invalid IMEI.Un-Authorized access..");
                    }
                } else {
                    responseStatus = 403;
                    response = "Invalid IMEI.Un-Authorized access.";
                    logger.info((Object)"Invalid IMEI.Un-Authorized access..");
                }
            } else {
                responseStatus = 403;
                response = "Invalid IMEI.Un-Authorized access.";
                logger.info((Object)"Invalid IMEI.Un-Authorized access..");
            }
            objCommonResponse = new CommandResponse(responseStatus == 0 && isappuser > 0 ? 2 : responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating registration status. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getparkedmemberslist/{number}"}, produces={"application/json"})
    public ResponseEntity<ParkedMemberResponse> getParkedMembersList(@PathVariable(value="number") String number, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for getting parked member list, For number -> " + number;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ParkedMemberResponse objCommonResponse = new ParkedMemberResponse();
        String command = "";
        String parkedData = "";
        ArrayList listParkedMembers = new ArrayList();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            try {
                number = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)number)));
                logger.info((Object)("Request for getting parked member list, For number -> " + number));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new ParkedMemberResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (number.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new ParkedMemberResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ParkedMemberResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            command = "valet_info";
            parkedData = this.objCommandDialer.getParkedMembersList(command);
            logger.info((Object)("Parked Memeber Data : " + parkedData));
            if (parkedData != null && !parkedData.isEmpty() && !parkedData.equals("<lots></lots>")) {
                try {
                    listParkedMembers = this.ReadParkedMemeberList(parkedData, number, db);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting parked member list. Error -> " + ex.getMessage()), (Throwable)ex);
                    objCommonResponse = new ParkedMemberResponse(1, ex.getMessage(), null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
                }
            }
            logger.info((Object)("Total Parked Member Found : " + listParkedMembers.size()));
            responseStatus = 0;
            response = "" + listParkedMembers.size();
            objCommonResponse = new ParkedMemberResponse(responseStatus, response, (List)listParkedMembers);
            logger.info((Object)"Parked Member Found.");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting parked member list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ParkedMemberResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public ArrayList<ParkedMembers> ReadParkedMemeberList(String xmlFile, String contact, JdbcTemplate db) {
        String lotName = "";
        String sessionuuid = "";
        String slot = "";
        String name = "";
        String parkedat = "";
        int parkedepoch = 0;
        String otherparty = "";
        ArrayList<ParkedMembers> returnValue = new ArrayList<ParkedMembers>();
        if (!xmlFile.isEmpty()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(xmlFile.replaceAll("\n", "")));
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nListLots = doc.getElementsByTagName("lot");
                for (int templots = 0; templots < nListLots.getLength(); ++templots) {
                    Node nNodelots = nListLots.item(templots);
                    if (nNodelots.getNodeType() != 1 || nNodelots.getAttributes().getNamedItem("name") == null || (lotName = nNodelots.getAttributes().getNamedItem("name").getNodeValue()).isEmpty() || !lotName.equals("pplot_" + contact)) continue;
                    NodeList nListExt = doc.getElementsByTagName("extension");
                    for (int tempExt = 0; tempExt < nListExt.getLength(); ++tempExt) {
                        Node nNodeExt = nListExt.item(tempExt);
                        if (nNodeExt.getNodeType() != 1) continue;
                        Element eElement = (Element)nNodeExt;
                        sessionuuid = eElement.getAttribute("uuid");
                        slot = eElement.getTextContent();
                        String parkedbyNumber = lotName.split("_")[1];
                        String slotOwnerNumber = slot.substring(0, slot.length() - 3);
                        if (lotName.isEmpty() || !lotName.equals("pplot_" + contact) || !parkedbyNumber.equals(slotOwnerNumber)) continue;
                        if (!sessionuuid.isEmpty()) {
                            try {
                                List parkedMemberList = null;
                                String sql = "select cast(a.created as time) created,a.created_epoch,coalesce(case when coalesce(b.contactname,'') = '' then a.cid_num else coalesce(b.contactname,'') end,'') as name,a.cid_num otherparty\r\nfrom channels a\r\nleft join pbx.directorylist b on a.coral_original_num = coalesce(b.contactno,'y')\r\nwhere uuid = ?";
                                parkedMemberList = db.queryForList(sql, new Object[]{sessionuuid});
                                if (parkedMemberList.size() > 0) {
                                    for (Map obj : parkedMemberList) {
                                        try {
                                            name = obj.get("name").toString();
                                            parkedat = obj.get("created").toString();
                                            parkedepoch = Integer.parseInt(obj.get("created_epoch").toString());
                                            otherparty = obj.get("otherparty").toString();
                                        }
                                        catch (Exception ex) {
                                            logger.error((Object)("Error " + ex.getMessage()), (Throwable)ex);
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        ParkedMembers objParkedMembers = new ParkedMembers();
                        objParkedMembers.setContact(contact);
                        objParkedMembers.setLot(lotName);
                        objParkedMembers.setName(name.isEmpty() ? contact : name);
                        objParkedMembers.setSlot(slot);
                        objParkedMembers.setSessionuuid(sessionuuid);
                        objParkedMembers.setParkedtime(parkedat);
                        objParkedMembers.setParkedepoch(parkedepoch);
                        objParkedMembers.setOtherparty(otherparty);
                        returnValue.add(objParkedMembers);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error " + ex.getMessage()), (Throwable)ex);
            }
        }
        returnValue.sort((s1, s2) -> s1.getParkedepoch() - s2.getParkedepoch());
        return returnValue;
    }

    @PostMapping(path={"/startattendanttransfer"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> startAttendantTransfer(@RequestParam(value="number") String number, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for attendant transfer, Form number -> " + number;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String holdpartyuuid = "";
        String talkingpartyuuid = "";
        String sql = "";
        try {
            try {
                number = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)number)));
                logger.info((Object)("Request for attendant transfer, Form number -> " + number));
            }
            catch (Exception ex) {
                logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (number.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            sql = "select b.uuid from channels a inner join channels b on a.call_uuid = b.call_uuid where a.coral_original_num = ?  and a.uuid <> b.uuid and a.callstate = 'HELD' order by a.created_epoch desc limit 1;";
            holdpartyuuid = (String)db.query(sql, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select b.uuid from channels a inner join channels b on a.call_uuid = b.call_uuid where a.coral_original_num = ?  and a.uuid <> b.uuid and a.callstate = 'ACTIVE' order by a.created_epoch desc limit 1;";
            talkingpartyuuid = (String)db.query(sql, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!holdpartyuuid.isEmpty() && !talkingpartyuuid.isEmpty()) {
                String command = "fs_cli -x \"uuid_bridge " + holdpartyuuid + " " + talkingpartyuuid + "\"";
                this.objCommandDialer.executecommand(command);
                responseStatus = 0;
                response = "Attendant Transfer Done.";
            } else {
                responseStatus = 1;
                response = "Error!!! In Attendant Transfer.";
            }
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            logger.info((Object)"Registration Status Updated.");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in attendant transfer. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public List<String> FindSBCOnlineNumbers() {
        ArrayList<String> listOnlineNumbers = new ArrayList<String>();
        String cmd = "sudo kamctl online";
        logger.info((Object)("Executing command : " + cmd));
        String rtrval = "";
        String str = "";
        String pstr = "";
        try {
            String[] finalcommand = this.readfullcommmand(cmd);
            Process p = Runtime.getRuntime().exec(finalcommand);
            p.waitFor();
            BufferedReader outbuf = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((str = outbuf.readLine()) != null) {
                pstr = pstr + str + "\n";
            }
            rtrval = pstr;
        }
        catch (IOException ex) {
            logger.error((Object)("Error in FindSBCOnlineNumbers() " + ex.getMessage()), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            logger.error((Object)("Error in FindSBCOnlineNumbers() " + ex.getMessage()), (Throwable)ex);
        }
        if (!rtrval.isEmpty()) {
            String[] registrationlist1 = rtrval.split("\n");
            listOnlineNumbers = new ArrayList<String>(Arrays.asList(registrationlist1));
            logger.info((Object)("Total Online User Found : " + listOnlineNumbers.size()));
        }
        return listOnlineNumbers;
    }

    public String[] readfullcommmand(String cmd) {
        String[] cmd1 = new String[]{"/bin/sh", "-c", cmd};
        return cmd1;
    }

    @PostMapping(path={"/validateSecureCode"}, produces={"application/json"})
    public ResponseEntity<APIStatusResponse> validateSecureCode(@RequestParam(value="secureCode") String secureCode, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for validating secure code -> " + secureCode;
        logger.info((Object)responseMessage);
        String response = "";
        APIStatusResponse objAPIStatusResponse = new APIStatusResponse();
        try {
            secureCode = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)secureCode)));
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objAPIStatusResponse.setStatus("Error");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objAPIStatusResponse);
        }
        if (secureCode.isEmpty()) {
            logger.info((Object)"Invalid Input ");
            objAPIStatusResponse.setStatus("Error");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objAPIStatusResponse);
        }
        try {
            if (this.meetConfig != null && !this.meetConfig.getSecureCode().isEmpty()) {
                response = this.meetConfig.getSecureCode().equalsIgnoreCase(secureCode) ? "OK" : "Invalid Secure Code";
            }
            objAPIStatusResponse.setStatus(response);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objAPIStatusResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in validating secure code. Error -> " + ex.getMessage()), (Throwable)ex);
            objAPIStatusResponse.setStatus("Error");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objAPIStatusResponse);
        }
    }

    @PostMapping(path={"/releaseChannel"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> releaseChannel(@RequestParam(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "releaseChannel : Request for releasing old stuck channel, By caller -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            responseMessage = "releaseChannel : Request for releasing old stuck channel, By caller -> " + contact;
            logger.info((Object)responseMessage);
            if (contact.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (this.meetConfig != null && this.meetConfig.getReleaseStuckChannels() == 0) {
                objCommonResponse = new CommandResponse(0, "Releasing stuck channels process has been stopped.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            Channel objChannel = new Channel();
            objChannel.setLocalNumber(contact);
            objChannel.setUpdateType("releaseChannel");
            String json = objectMapper.writeValueAsString((Object)objChannel);
            this.sendUpdateChannelPost(json);
            responseStatus = 0;
            response = "releaseChannel : Old stuck channel request enqueued..";
            logger.info((Object)response);
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("releaseChannel : Error in releasing old stuck channel. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getcarrier/{contact}"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updateFeature(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for fetching carrier, for contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String sql = "";
        String carrier = "";
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            if (contact.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            sql = "select coalesce(createdby,'') carrier from pbx.t_registrationstatus where coalesce(sip_user,'') = ? order by id desc limit 1;";
            carrier = (String)db.query(sql, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            responseStatus = 0;
            response = carrier;
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting carrier. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/updatePresenceStatus"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> updatePresenceStatus(@RequestParam(value="contact") String contact, @RequestParam(value="status") String status, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for updating presence status, By caller, status -> " + contact + ", " + status;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        String stateMachineUrl = "";
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            status = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)status)));
            responseMessage = "Request for updating presence status, By caller, status -> " + contact + ", " + status;
            logger.info((Object)responseMessage);
            if (contact.isEmpty() || status.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            CoralMeetSystemConfig meetconfig = this.meetConfig;
            if (meetconfig != null) {
                stateMachineUrl = meetconfig.getStatemachineurl().trim();
                stateMachineUrl = stateMachineUrl + "/updatePresenceStatus";
                logger.info((Object)("StateMachine  : " + stateMachineUrl));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("number=" + contact + "&status=" + status);
            String body = sb.toString();
            Client client = Client.create();
            WebResource webResource = client.resource(stateMachineUrl);
            ClientResponse apiResponse = (ClientResponse)webResource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)body);
            if (apiResponse.getStatus() != 200) {
                logger.error((Object)("Failed : HTTP error code : " + apiResponse.getStatus()));
                responseStatus = 1;
                response = Integer.toString(apiResponse.getStatus());
            } else {
                responseStatus = 0;
            }
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating presence status. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/switchToSecureCall"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> switchToSecureCall(@RequestParam(value="contact") String contact, @RequestParam(value="number1") String number1, @RequestParam(value="number2") String number2, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for switiching to secure call, By caller, number1 & number2 -> " + contact + ", " + number1 + ", " + number2;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        String virtualIP = "";
        String command = "";
        String rluCode = "";
        String qry = "";
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        try {
            contact = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)contact)));
            number1 = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)number1)));
            number2 = CoralUCPhoneController.decrypt((byte[])CoralUCPhoneController.decode((String)CoralUCPhoneController.Base64decode((String)number2)));
            responseMessage = "Request for switiching to secure call, By caller, number1 & number2 -> " + contact + ", " + number1 + ", " + number2;
            logger.info((Object)responseMessage);
            if (contact.isEmpty() || number1.isEmpty() || number2.isEmpty()) {
                logger.info((Object)"Invalid Input : ");
                objCommonResponse = new CommandResponse(1, "Invalid Input", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Invalid Input : " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            CoralMeetSystemConfig meetconfig = this.meetConfig;
            if (meetconfig != null) {
                virtualIP = meetconfig.getSbcip();
                logger.info((Object)("SBC IP  : " + virtualIP));
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{number1}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            rluCode = !rluCode.isEmpty() ? "internal_" + rluCode.trim() : "internal";
            if (!virtualIP.isEmpty()) {
                command = "{origination_callee_id_name=";
                command = command + number2;
                command = command + ",origination_caller_id_number='";
                command = command + number2;
                command = command + "',sip_h_X-securecall=1}sofia/";
                command = command + rluCode;
                command = command + "/";
                command = command + number1;
                command = command + "@";
                command = command + virtualIP;
                command = command + " &bridge(";
                command = command + "{origination_callee_id_name=";
                command = command + number1;
                command = command + ",origination_caller_id_number='";
                command = command + number1;
                command = command + "',sip_h_X-securecall=1}sofia/";
                command = command + rluCode;
                command = command + "/";
                command = command + number2;
                command = command + "@";
                command = command + virtualIP;
                command = command + ")";
            }
            XmlRPCClient obj = new XmlRPCClient();
            if (!command.isEmpty()) {
                obj.executeCommandAsync("freeswitch.api", "originate", command);
            }
            responseStatus = 0;
            response = "Switch to secure call command executed.";
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating presence status. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getcalleename/{contact}"}, produces={"application/json"})
    public ResponseEntity<CommandResponse> getCalleeName(@PathVariable(value="contact") String contact, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Callee Name For contact no -> " + contact;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommandResponse objCommonResponse = new CommandResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String calleeName = "";
        String qry = "";
        if (contact.isEmpty()) {
            objCommonResponse = new CommandResponse(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            qry = "select coalesce(contactname,contactno) as contactname from pbx.directorylist where contactno = right(?,10) limit 1;";
            calleeName = (String)db.query(qry, new Object[]{contact}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            response = calleeName = !calleeName.isEmpty() ? calleeName : contact;
            responseStatus = 0;
            responseMessage = "Callee Name found for contact no -> " + contact + " is " + calleeName;
            logger.info((Object)responseMessage);
            objCommonResponse = new CommandResponse(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting callee status. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommandResponse(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }
}

