/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.restapi.complaint.hospital;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.common.objects.ComplaintCountResponse;
import com.coraltele.common.objects.ComplaintHistoryResponse;
import com.coraltele.common.objects.HospitalComplaint;
import com.coraltele.common.objects.HospitalFormField;
import com.coraltele.common.objects.HospitalFormFieldDAO;
import com.coraltele.common.objects.HospitalFormFields;
import com.coraltele.common.objects.HospitalServiceDAO;
import com.coraltele.common.objects.ServiceAgentList;
import com.coraltele.common.objects.ValidUserResponse;
import com.coraltele.config.env.SecurityUtils;
import com.coraltele.config.env.databaseUtilities;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.tomcat.util.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/complaint/hospital/v1"})
public class HospitalComplaintController {
    private static final Logger logger = Logger.getLogger(HospitalComplaintController.class);
    private CommonResponseObject objCommonResponse = new CommonResponseObject();
    private ValidUserResponse objValidUserResponse = new ValidUserResponse();
    private static final int dailyOTPLimitPerUser = 10;
    private static final int otpValidUpTo = 600;
    private static final int escalationTime = 120;
    private final String profilePicDirectory = "/mnt/cms/hospital/profilepic";
    private final String appIconDirectory = "/mnt/cms/hospital/appicon";
    @Autowired
    private HospitalServiceDAO hospitalServiceDAO;
    @Autowired
    private HospitalFormFieldDAO hospitalFormFieldDAO;
    @Autowired
    HttpServletRequest request;
    @Autowired
    @Qualifier(value="dsUsers")
    private DataSource dsUsers;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HospitalComplaintController() {
        HospitalComplaintController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private static String decodeString(String p_message) {
        String _ret = "";
        try {
            byte[] bytesdecoded = Base64.decodeBase64((byte[])p_message.getBytes());
            _ret = new String(bytesdecoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    @PostMapping(path={"/registermobilenumber"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> registerMobileNumber(@RequestParam(value="mobilenumber", defaultValue="0") String mobilenumber) {
        block13: {
            String responseMessage = "Request for mobile number registeration : " + mobilenumber;
            logger.info((Object)responseMessage);
            int alreadyregistered = 0;
            String sql = "";
            long otp = 0L;
            String clientip = "";
            int affectedRows = 0;
            long actualMobileNumber = 0L;
            this.objCommonResponse = new CommonResponseObject();
            try {
                mobilenumber = SecurityUtils.decrypt((String)mobilenumber);
                logger.info((Object)("Request for mobile number registeration : " + mobilenumber));
                responseMessage = responseMessage + " <--> " + mobilenumber;
            }
            catch (Exception ex) {
                logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (mobilenumber == null || mobilenumber.isEmpty() || mobilenumber.equals("0") || mobilenumber.length() < 10) {
                logger.error((Object)"Please provide valid mobile number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                actualMobileNumber = Long.parseLong(mobilenumber.substring(mobilenumber.length() - 10));
                logger.info((Object)("Actual Mobile Number : " + actualMobileNumber));
            }
            catch (Exception ex) {
                logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (actualMobileNumber > 0L) {
                JdbcTemplate db = new JdbcTemplate(this.dsUsers);
                sql = "select count(*) from m_user where coalesce(applicationname,'') = 'CMS-H' and mobilenumber = ?;";
                try {
                    alreadyregistered = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber}, Integer.class);
                    if (alreadyregistered > 0) {
                        logger.error((Object)"This mobile number is already registered. Use userid and password to Login.");
                        this.objCommonResponse = new CommonResponseObject(1, "This mobile number is already registered. Use userid and password to Login.", "USER_ALREADY_EXISTS");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    sql = "Insert into m_user(username,mobilenumber,applicationname) values(?,?,?)";
                    affectedRows = db.update(sql, new Object[]{actualMobileNumber, actualMobileNumber, "CMS-H"});
                    if (affectedRows <= 0) break block13;
                    otp = HospitalComplaintController.generateuniquerandomNumber((JdbcTemplate)db, (int)4, (String)"m_otpdetails", (String)"otp");
                    try {
                        clientip = this.getClientIpAddress(this.request);
                        logger.info((Object)("Request comes from ip : " + clientip));
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting client ip address  : " + mobilenumber));
                    }
                    if (otp > 0L) {
                        sql = "Insert into m_otpdetails(mobilenumber,otp,clientip,epoch) values(?,?,?,extract(epoch from now()::timestamp(0) with time zone))";
                        affectedRows = db.update(sql, new Object[]{actualMobileNumber, otp, clientip});
                        if (affectedRows > 0) {
                            String additionMessage = "Use OTP : " + otp;
                            logger.info((Object)("Mobile number registered : " + responseMessage + ", OTP : " + additionMessage));
                            this.objCommonResponse = new CommonResponseObject(0, "Otp will be sent to you. " + additionMessage, "MOBILENUMBER_REGISTERED");
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                        }
                        break block13;
                    }
                    logger.info((Object)("Mobile number registered, Error in OTP generation. Request OTP again. : " + responseMessage));
                    this.objCommonResponse = new CommonResponseObject(1, "Mobile number registered, Error in OTP generation. Request OTP again", "OTP_NOT_GENERATED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                    this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            }
        }
        this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
    }

    @GetMapping(path={"/requestotp/{mobilenumber}"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> requestOTP(@PathVariable(value="mobilenumber") String mobilenumber) {
        block14: {
            String responseMessage = "Request OTP for mobile number : " + mobilenumber;
            logger.info((Object)responseMessage);
            int alreadyregistered = 0;
            String sql = "";
            long otp = 0L;
            String clientip = "";
            int affectedRows = 0;
            int totalotpsendsofar = 0;
            long actualMobileNumber = 0L;
            this.objCommonResponse = new CommonResponseObject();
            try {
                mobilenumber = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)mobilenumber));
                logger.info((Object)("Request OTP for mobile number : " + mobilenumber));
                responseMessage = responseMessage + " <--> " + mobilenumber;
            }
            catch (Exception ex) {
                logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (mobilenumber.isEmpty() || mobilenumber.equals("0") || mobilenumber.length() < 10) {
                logger.error((Object)"Please provide valid mobile number.");
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                actualMobileNumber = Long.parseLong(mobilenumber.substring(mobilenumber.length() - 10));
                logger.info((Object)("Actual Mobile Number : " + actualMobileNumber));
            }
            catch (Exception ex) {
                logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (actualMobileNumber > 0L) {
                JdbcTemplate db = new JdbcTemplate(this.dsUsers);
                sql = "select count(*) from m_user where coalesce(applicationname,'') = 'CMS-H' and mobilenumber = ?;";
                try {
                    alreadyregistered = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber}, Integer.class);
                    if (alreadyregistered == 0) {
                        logger.error((Object)"This mobile number is not registered with us. Please registered first.");
                        this.objCommonResponse = new CommonResponseObject(1, "This mobile number is not registered with us. Please registered first.", "USER_NOT_EXISTS");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    sql = "select count(*) from m_otpdetails where mobilenumber = ? and createdon::date = now()::date;";
                    totalotpsendsofar = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber}, Integer.class);
                    if (totalotpsendsofar >= 10) {
                        logger.error((Object)"Your daily OTP limit i.e. \"10\" has been exceeded.");
                        this.objCommonResponse = new CommonResponseObject(1, "Your daily OTP limit i.e. \"10\" has been exceeded.", "OTP_LIMIT_EXCEEDED");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    otp = HospitalComplaintController.generateuniquerandomNumber((JdbcTemplate)db, (int)4, (String)"m_otpdetails", (String)"otp");
                    try {
                        clientip = this.getClientIpAddress(this.request);
                        logger.info((Object)("Request comes from ip : " + clientip));
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting client ip address  : " + mobilenumber));
                    }
                    if (otp > 0L) {
                        sql = "update m_otpdetails set otpvalidated = 2, otpvalidatedon = now() where otpvalidated = 0 and mobilenumber = ?";
                        affectedRows = db.update(sql, new Object[]{actualMobileNumber});
                        sql = "Insert into m_otpdetails(mobilenumber,otp,clientip,epoch) values(?,?,?,extract(epoch from now()::timestamp(0) with time zone))";
                        affectedRows = db.update(sql, new Object[]{actualMobileNumber, otp, clientip});
                        if (affectedRows > 0) {
                            String additionMessage = "Use OTP : " + otp;
                            logger.info((Object)("OTP generated : " + responseMessage + ", OTP : " + additionMessage));
                            this.objCommonResponse = new CommonResponseObject(0, "OTP generated." + additionMessage, "OTP_GENERATED");
                            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                        }
                        break block14;
                    }
                    logger.info((Object)("Error in OTP generation. Request OTP again. : " + responseMessage));
                    this.objCommonResponse = new CommonResponseObject(1, "Error in OTP generation. Request OTP again", "OTP_NOT_GENERATED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                    this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
            }
            logger.error((Object)"Please provide valid mobile number.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        return null;
    }

    @GetMapping(path={"/validateotp/{mobilenumber}/{otp}"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> validateOTP(@PathVariable(value="mobilenumber") String mobilenumber, @PathVariable(value="otp") String p_otp) {
        String responseMessage = "Request OTP Validation number : " + mobilenumber + ", OTP : " + p_otp;
        logger.info((Object)responseMessage);
        int alreadyregistered = 0;
        String sql = "";
        int isvalidotp = 0;
        long actualMobileNumber = 0L;
        int otp = 0;
        this.objCommonResponse = new CommonResponseObject();
        try {
            mobilenumber = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)mobilenumber));
            String strotp = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)p_otp));
            otp = strotp.isEmpty() ? 0 : Integer.parseInt(strotp);
            logger.info((Object)("Request OTP Validation number : " + mobilenumber + ", OTP : " + otp));
            responseMessage = responseMessage + " <--> " + mobilenumber + ", " + otp;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (mobilenumber.isEmpty() || mobilenumber.equals("0") || mobilenumber.length() < 10) {
            logger.error((Object)"Please provide valid mobile number.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            actualMobileNumber = Long.parseLong(mobilenumber.substring(mobilenumber.length() - 10));
            logger.info((Object)("Actual Mobile Number : " + actualMobileNumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (actualMobileNumber > 0L && otp > 0) {
            JdbcTemplate db = new JdbcTemplate(this.dsUsers);
            sql = "select count(*) from m_user where coalesce(applicationname,'') = 'CMS-H' and mobilenumber = ?;";
            try {
                alreadyregistered = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber}, Integer.class);
                if (alreadyregistered == 0) {
                    logger.error((Object)"This mobile number is not registered with us. Please registered first.");
                    this.objCommonResponse = new CommonResponseObject(1, "This mobile number is not registered with us. Please registered first.", "USER_NOT_EXISTS");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                sql = "select count(*) from m_otpdetails where mobilenumber = ? and otp = ? and \r\nepoch + ? >= extract (epoch from now()::timestamp(0) with time zone) and otpvalidated = 0;";
                isvalidotp = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber, otp, 600}, Integer.class);
                if (isvalidotp == 1) {
                    logger.info((Object)("OTP is Validated : " + responseMessage));
                    this.objCommonResponse = new CommonResponseObject(0, "Valid OTP", "OTP_VALIDATED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                logger.info((Object)("Invalid OTP : " + responseMessage));
                this.objCommonResponse = new CommonResponseObject(1, "InValid OTP", "OTP_NOT_VALIDATED");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        logger.error((Object)"Please provide valid mobile number/OTP.");
        this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number/OTP.", "INVALID_MOBILENUMBER");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
    }

    @PostMapping(path={"/registermobileuser"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> registerMobileUser(@RequestParam(value="mobilenumber", defaultValue="0") String mobilenumber, @RequestParam(value="username", defaultValue="") String username, @RequestParam(value="password", defaultValue="") String password) {
        String responseMessage = "Request for mobile user registeration : " + mobilenumber + ", " + username;
        logger.info((Object)responseMessage);
        int alreadyregistered = 0;
        String sql = "";
        int affectedRows = 0;
        long actualMobileNumber = 0L;
        String hashedPassword = "";
        this.objCommonResponse = new CommonResponseObject();
        try {
            mobilenumber = SecurityUtils.decrypt((String)mobilenumber);
            username = SecurityUtils.decrypt((String)username);
            password = SecurityUtils.decrypt((String)password);
            logger.info((Object)("Request for mobile user registeration : " + mobilenumber + ", " + username));
            responseMessage = responseMessage + " <--> " + mobilenumber + ", " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (mobilenumber.isEmpty() || mobilenumber.equals("0") || mobilenumber.length() < 10) {
            logger.error((Object)"Please provide valid mobile number.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number.", "INVALID_MOBILENUMBER");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        try {
            actualMobileNumber = Long.parseLong(mobilenumber.substring(mobilenumber.length() - 10));
            logger.info((Object)("Actual Mobile Number : " + actualMobileNumber));
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (actualMobileNumber > 0L && !username.isEmpty() && !password.isEmpty()) {
            JdbcTemplate db = new JdbcTemplate(this.dsUsers);
            sql = "select count(*) from m_user where coalesce(applicationname,'') = 'CMS-H' and mobilenumber = ?;";
            try {
                alreadyregistered = (Integer)db.queryForObject(sql, new Object[]{actualMobileNumber}, Integer.class);
                if (alreadyregistered == 0) {
                    logger.error((Object)"This mobile number is not registered with us. Please registered first.");
                    this.objCommonResponse = new CommonResponseObject(1, "This mobile number is not registered with us. Please registered first.", "USER_NOT_EXISTS");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                try {
                    BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                    hashedPassword = passwordEncoder.encode((CharSequence)password);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in password generation : " + mobilenumber + ", " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                    this.objCommonResponse = new CommonResponseObject(1, "Error in password generation.", "EXCEPTION");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                if (hashedPassword.isEmpty()) {
                    logger.error((Object)("Error in password generation : " + mobilenumber + ", " + username));
                    this.objCommonResponse = new CommonResponseObject(1, "Error in password generation.", "EXCEPTION");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                sql = "update m_user set username = ? , password = ?, lastpasswordchange = now()::date,enabled = 1 where coalesce(applicationname,'') = 'CMS-H' and mobilenumber = ?";
                affectedRows = db.update(sql, new Object[]{username, hashedPassword, actualMobileNumber});
                if (affectedRows > 0) {
                    sql = "insert into m_userrole(\"user\",role) select a.id usernameid,b.id roleid\r\n from m_user a cross join m_role b where b.shortcode = 'ROLE_PATIENT'\r\n and coalesce(a.applicationname,'') = 'CMS-H' and a.username = ?";
                    affectedRows = db.update(sql, new Object[]{username});
                    if (affectedRows > 0) {
                        logger.error((Object)("User registered successfully : " + mobilenumber + ", " + username));
                        this.objCommonResponse = new CommonResponseObject(0, "User registered successfully", "USER_REGISTERED");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    logger.error((Object)("User registered but error in role assignment : " + mobilenumber + ", " + username));
                    this.objCommonResponse = new CommonResponseObject(1, "User registered but error in role assignment", "EXCEPTION");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                logger.error((Object)("Error in user registration : " + mobilenumber + ", " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Error in user registration.", "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (DuplicateKeyException ex) {
                logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Duplicate!!!, Username \"" + username + "\" already exists. Try another Username.", "USER_ALREADY_EXISTS");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        logger.error((Object)"Please provide valid mobile number/UserName/Password.");
        this.objCommonResponse = new CommonResponseObject(1, "Please provide valid mobile number/UserName/Password.", "INVALID_DETAILS");
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
    }

    @PostMapping(path={"/resetpassword"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> resetPassword(@RequestParam(value="username", defaultValue="") String username, @RequestParam(value="password", defaultValue="") String password) {
        String responseMessage = "Request for changing login password for username : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        int affectedRows = 0;
        String hashedPassword = "";
        this.objCommonResponse = new CommonResponseObject();
        try {
            username = SecurityUtils.decrypt((String)username);
            password = SecurityUtils.decrypt((String)password);
            logger.info((Object)("Request for changing login password for username : " + username));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (username.isEmpty() || password.isEmpty()) {
            logger.error((Object)"Please provide valid username or password.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username or password.", "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        sql = "select count(*) from m_user where coalesce(applicationname,'') = 'CMS-H' and username = ? and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                hashedPassword = passwordEncoder.encode((CharSequence)password);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in password generation : " + username + ", Error : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error in password generation.", "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (hashedPassword.isEmpty()) {
                logger.error((Object)("Error in password generation : " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Error in password generation.", "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            sql = "update m_user set password = ?, lastpasswordchange = now()::date where coalesce(applicationname,'') = 'CMS-H' and username = ?";
            affectedRows = db.update(sql, new Object[]{hashedPassword, username});
            if (affectedRows > 0) {
                logger.error((Object)("Password changes successfully : " + username));
                this.objCommonResponse = new CommonResponseObject(0, "Password changed successfully", "PASSWORD_CHANGED");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            logger.error((Object)("Error in changing password : " + username));
            this.objCommonResponse = new CommonResponseObject(1, "Error in changing password.", "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/login"}, produces={"application/json"})
    public ResponseEntity<ValidUserResponse> login(@RequestParam(value="username", defaultValue="") String username, @RequestParam(value="password", defaultValue="") String password) {
        String responseMessage = "Request for login for username : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        String hashedPassword = "";
        this.objValidUserResponse = new ValidUserResponse();
        try {
            username = SecurityUtils.decrypt((String)username);
            password = SecurityUtils.decrypt((String)password);
            logger.info((Object)("Request for login for username : " + username));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objValidUserResponse = new ValidUserResponse(1, "Please provide valid input.", 0, null, null, null, null, null, null, null, null, null, "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
        }
        if (username.isEmpty() || password.isEmpty()) {
            logger.error((Object)"Please provide valid username or password.");
            this.objValidUserResponse = new ValidUserResponse(1, "Please provide valid username or password.", 0, null, null, null, null, null, null, null, null, null, "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objValidUserResponse = new ValidUserResponse(1, "Invalid username. " + username, 0, null, null, null, null, null, null, null, null, null, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
            }
            String qry = "select coalesce(password,'') as password from m_user where username = ?;";
            hashedPassword = (String)db.query(qry, new Object[]{username}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!hashedPassword.isEmpty()) {
                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                if (passwordEncoder.matches((CharSequence)password, hashedPassword)) {
                    String profilename = "";
                    String profilepic = "";
                    String userrole = "";
                    String appicon = null;
                    String token = null;
                    List userInfo = null;
                    qry = "select coalesce(a.description,username) profilename,a.profilepicuuid,c.shortcode\r\nfrom m_user a inner join m_userrole b on a.id = b.user\r\ninner join m_role c on c.id = b.role where a.username = ? limit 1 ;";
                    userInfo = db.queryForList(qry, new Object[]{username});
                    for (Map data : userInfo) {
                        try {
                            profilename = data.get("profilename").toString();
                            profilepic = data.get("profilepicuuid").toString();
                            userrole = data.get("shortcode").toString();
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error finding user info for : username : " + username + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    if (!userrole.isEmpty()) {
                        String clientip = "";
                        try {
                            clientip = this.getClientIpAddress(this.request);
                            logger.info((Object)("Request comes from ip : " + clientip));
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Error in getting client ip address  : " + username));
                        }
                        sql = "update m_user set lastlogon = now()::date,lastlogonip = ? where coalesce(applicationname,'') = 'CMS-H' and username = ?";
                        db.update(sql, new Object[]{clientip, username});
                        logger.info((Object)(responseMessage + " : Valid User , Client IP : " + clientip));
                        profilename = profilename.isEmpty() ? null : profilename;
                        profilepic = !profilepic.isEmpty() ? this.request.getRequestURL().toString().replace("/login", "/") + "getimage/" + profilepic : null;
                        appicon = this.request.getRequestURL().toString().replace("/login", "/") + "getappicon";
                        this.objValidUserResponse = new ValidUserResponse(0, "Valid user", 120, appicon, token, this.hospitalServiceDAO.getAllHospitalServices(), userrole, profilename, profilepic, "NO", null, this.hospitalFormFieldDAO.getAllHospitalFormFields(), "USER_VERIFIED");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
                    }
                    logger.info((Object)(responseMessage + " : Invalid user"));
                    this.objValidUserResponse = new ValidUserResponse(1, "Invalid user", 0, null, null, null, null, null, null, null, null, null, "USER_NOT_VERIFIED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
                }
                logger.info((Object)(responseMessage + " : Invalid password"));
                this.objValidUserResponse = new ValidUserResponse(1, "Invalid password", 0, null, null, null, null, null, null, null, null, null, "USER_NOT_VERIFIED");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
            }
            logger.info((Object)(responseMessage + " : Invalid user, No password is defined for user."));
            this.objValidUserResponse = new ValidUserResponse(1, "Invalid user,No password is defined for user.", 0, null, null, null, null, null, null, null, null, null, "USER_NOT_VERIFIED");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objValidUserResponse = new ValidUserResponse(1, "Error : " + ex.getMessage(), 0, null, null, null, null, null, null, null, null, null, "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objValidUserResponse);
        }
    }

    @PostMapping(path={"/updateprofilepic"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> updateProfilePic(@RequestParam(value="username", defaultValue="") String username, @RequestParam(name="profileimgtag", required=false) MultipartFile multiPart) {
        String responseMessage = "Request for updating profile pic for username : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        String profilePicUUID = "";
        int affectedRows = 0;
        this.objCommonResponse = new CommonResponseObject();
        try {
            username = SecurityUtils.decrypt((String)username);
            logger.info((Object)("Request for updating profile pic for username : " + username));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (username.isEmpty() || multiPart == null) {
            logger.error((Object)"Please provide valid username or profile pic.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username or profile pic.", "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            String qry = "select coalesce(profilepicuuid,'') as profilepicuuid from m_user where username = ?;";
            profilePicUUID = (String)db.query(qry, new Object[]{username}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            try {
                if (profilePicUUID.isEmpty()) {
                    profilePicUUID = UUID.randomUUID().toString();
                }
                File convFile = new File("/mnt/cms/hospital/profilepic/" + profilePicUUID);
                multiPart.transferTo(convFile);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in uploading profile pic : " + username + ex.getMessage()), (Throwable)ex);
            }
            sql = "update m_user set profilePicUUID = ? where coalesce(applicationname,'') = 'CMS-H' and username = ?";
            affectedRows = db.update(sql, new Object[]{profilePicUUID, username});
            if (affectedRows > 0) {
                logger.error((Object)("Profile pic changed successfully : " + username));
                this.objCommonResponse = new CommonResponseObject(0, "Profile pic changed successfully", "PROFILE_PIC_CHANGED");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            logger.error((Object)("Error in changing profile picture. : " + username));
            this.objCommonResponse = new CommonResponseObject(1, "Error in changing profile picture.", "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @GetMapping(value={"/getimage/{imageId}"}, produces={"image/gif"})
    @ResponseBody
    public byte[] getAvatar(HttpServletRequest request, @PathVariable(value="imageId") String imageId) {
        try {
            String fileName = imageId;
            String fullFileName = "/mnt/cms/hospital/profilepic/" + fileName;
            File f = new File(fullFileName);
            if (!f.exists()) {
                fullFileName = "/mnt/cms/hospital/profilepic/generic.jpg";
            }
            if ((f = new File(fullFileName)).exists()) {
                FileInputStream fileAvatar = new FileInputStream(fullFileName);
                BufferedImage imgAvatar = ImageIO.read(fileAvatar);
                ByteArrayOutputStream imgRender = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)imgAvatar, "gif", imgRender);
                return imgRender.toByteArray();
            }
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)(ex.getMessage() + "in getimage"), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)(ex.getMessage() + "in getimage"), (Throwable)ex);
        }
        return null;
    }

    @GetMapping(value={"/getappicon"}, produces={"image/gif"})
    @ResponseBody
    public byte[] getAppIcon(HttpServletRequest request) {
        try {
            String fileName = "appicon.png";
            String fullFileName = "/mnt/cms/hospital/appicon/" + fileName;
            File f = new File(fullFileName);
            if (!f.exists()) {
                fullFileName = "/mnt/cms/hospital/appicon/generic.jpg";
            }
            if ((f = new File(fullFileName)).exists()) {
                FileInputStream fileAvatar = new FileInputStream(fullFileName);
                BufferedImage imgAvatar = ImageIO.read(fileAvatar);
                ByteArrayOutputStream imgRender = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)imgAvatar, "gif", imgRender);
                return imgRender.toByteArray();
            }
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)(ex.getMessage() + "in getimage"), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)(ex.getMessage() + "in getimage"), (Throwable)ex);
        }
        return null;
    }

    @PostMapping(path={"/updateprofile"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> updateProfile(@RequestParam(value="username", defaultValue="") String username, @RequestParam(name="profilename", defaultValue="") String profilename, @RequestParam(name="profileemailid", defaultValue="") String profileemailid) {
        String responseMessage = "Request for updating profile details for username : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        int affectedRows = 0;
        this.objCommonResponse = new CommonResponseObject();
        try {
            username = SecurityUtils.decrypt((String)username);
            profilename = SecurityUtils.decrypt((String)profilename);
            profileemailid = SecurityUtils.decrypt((String)profileemailid);
            logger.info((Object)("Request for updating profile details for username : " + username));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (username.isEmpty()) {
            logger.error((Object)"Please provide valid username.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username.", "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            sql = "update m_user set description = ?, emailid = ? where coalesce(applicationname,'') = 'CMS-H' and username = ?";
            affectedRows = db.update(sql, new Object[]{profilename, profileemailid, username});
            if (affectedRows > 0) {
                logger.error((Object)("Profile details updated successfully : " + username));
                this.objCommonResponse = new CommonResponseObject(0, "Profile details updated successfully", "PROFILE_DETAILS_CHANGED");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            logger.error((Object)("Error in changing profile details : " + username));
            this.objCommonResponse = new CommonResponseObject(1, "Error in changing profile details.", "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @PostMapping(path={"/complaint"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> complaint(@RequestParam(value="username", defaultValue="") String username, @RequestParam(name="complaintjson", defaultValue="") String complaintjson, @RequestParam(name="signature", defaultValue="") String signature, @RequestParam(name="pic1", defaultValue="") String pic1, @RequestParam(name="pic2", defaultValue="") String pic2, @RequestParam(name="extraremarks", defaultValue="") String extraremarks) {
        HospitalFormFields formFieldsData;
        String uhid;
        String patientname;
        String service;
        String mobilenumber;
        String remarks;
        long complaintno;
        int affectedRows;
        String sql;
        int userexists;
        String responseMessage;
        block31: {
            responseMessage = "Request for registering complaint by username : " + username;
            logger.info((Object)responseMessage);
            userexists = 0;
            sql = "";
            affectedRows = 0;
            complaintno = 0L;
            remarks = "";
            mobilenumber = "";
            service = "";
            patientname = "";
            uhid = "";
            formFieldsData = new HospitalFormFields();
            this.objCommonResponse = new CommonResponseObject();
            try {
                username = SecurityUtils.decrypt((String)username);
                complaintjson = SecurityUtils.decrypt((String)complaintjson);
                if (!complaintjson.isEmpty()) {
                    complaintjson = "{\r\n\t\"hospitalFormFieldsList\":" + complaintjson + "}";
                }
                if (!signature.isEmpty()) {
                    signature = SecurityUtils.decrypt((String)signature);
                }
                responseMessage = responseMessage + " <--> " + username;
                logger.info((Object)("Request for registering complaint by username : " + username + ", Complaint data : " + complaintjson));
            }
            catch (Exception ex) {
                logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            if (username.isEmpty() || complaintjson.isEmpty()) {
                logger.error((Object)"Please provide valid username or complaint data.");
                this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username or complaint data.", "INVALID_DETAILS");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            try {
                ObjectMapper mapper = new ObjectMapper();
                formFieldsData = (HospitalFormFields)mapper.readValue(complaintjson, HospitalFormFields.class);
                if (formFieldsData.getHospitalFormFieldsList() != null) {
                    if (formFieldsData.getHospitalFormFieldsList().size() == 0) {
                        logger.error((Object)"Invalid complaint data.");
                        this.objCommonResponse = new CommonResponseObject(1, "Invalid complaint data.", "INVALID_INPUT");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    break block31;
                }
                logger.error((Object)"Invalid complaint data.");
                this.objCommonResponse = new CommonResponseObject(1, "Invalid complaint data.", "INVALID_INPUT");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in parsing complaint data : " + ex.getMessage()), (Throwable)ex);
                this.objCommonResponse = new CommonResponseObject(1, "Error in parsing complaint data.", "INVALID_INPUT");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            String columnname = "";
            String columnvalue = "";
            for (HospitalFormField fields : formFieldsData.getHospitalFormFieldsList()) {
                if (fields.getKey().isEmpty()) continue;
                if (fields.getKey().equals("service")) {
                    service = fields.getValue().trim();
                } else if (fields.getKey().equals("mobilenumber")) {
                    mobilenumber = fields.getValue().trim();
                } else if (fields.getKey().equals("remarks")) {
                    remarks = fields.getValue().trim();
                } else if (fields.getKey().equals("name")) {
                    patientname = fields.getValue().trim();
                } else if (fields.getKey().equals("uhid")) {
                    uhid = fields.getValue().trim();
                }
                if (fields.getDatatype().equals("C") || fields.getDatatype().equals("M") || fields.getDatatype().equals("A")) {
                    columnname = columnname + fields.getKey().trim();
                    columnname = columnname + ",";
                    columnvalue = columnvalue + (fields.getValue() == null ? "''" : "'" + fields.getValue().trim() + "'");
                    columnvalue = columnvalue + ",";
                    continue;
                }
                if (fields.getDatatype().equals("N")) {
                    columnname = columnname + fields.getKey().trim();
                    columnname = columnname + ",";
                    columnvalue = columnvalue + (fields.getValue() == null ? Integer.valueOf(0) : fields.getValue().trim());
                    columnvalue = columnvalue + ",";
                    continue;
                }
                if (!fields.getDatatype().equals("B")) continue;
                columnname = columnname + fields.getKey().trim();
                columnname = columnname + ",";
                columnvalue = columnvalue + (fields.getValue() == null ? "'false'" : "'" + fields.getValue().trim() + "'");
                columnvalue = columnvalue + ",";
            }
            if (!columnname.isEmpty() && !service.isEmpty()) {
                Date cNow = new Date();
                SimpleDateFormat cmsdate = new SimpleDateFormat("yyMMdd");
                try {
                    complaintno = Long.parseLong(cmsdate.format(cNow) + HospitalComplaintController.generateComplaintNo((JdbcTemplate)dbSwitch));
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in Generating Complaint No : , Error : " + ex.getMessage()), (Throwable)ex);
                }
                columnname = columnname + "complaintraiseddby,complaintno,signature,pic1,pic2,extraremarks";
                columnvalue = columnvalue + "'" + username + "'," + complaintno + ",'" + signature + "','" + pic1 + "','" + pic2 + "','" + extraremarks + "'";
                sql = "insert into complaint.t_complaints(";
                sql = sql + columnname;
                sql = sql + ") values(";
                sql = sql + columnvalue;
                sql = sql + ");";
                logger.info((Object)("sql : " + sql));
                if (!sql.isEmpty()) {
                    affectedRows = dbSwitch.update(sql);
                }
                if (affectedRows > 0) {
                    try {
                        sql = "insert into pbx.t_cdr (uuid,coral_dialid,coral_billaccount,coral_balance,column1,column2,column5,column6,column7,column8,column9,column10,cc_queue,cc_agent_type,coral_app) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        Object[] param1 = new Object[]{UUID.randomUUID().toString(), complaintno, mobilenumber, 0, service, service, patientname, uhid, signature, pic1, pic2, extraremarks, "APP", username, "ivrsupport"};
                        int[] type1 = new int[]{1111, -5, 12, 4, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
                        dbSwitch.update(sql, param1, type1);
                        sql = "insert into complaint.m_complainthistory (complaintno,actor,action,actiondate,remarks) values(?,?,?,now(),?)";
                        Object[] param = new Object[]{complaintno, username, "New registration", remarks};
                        int[] type = new int[]{-5, 12, 12, 12};
                        dbSwitch.update(sql, param, type);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
                        this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
                        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                    }
                    logger.error((Object)("Complaint registered successfully : " + username + ", Complaint no : " + complaintno));
                    this.objCommonResponse = new CommonResponseObject(0, "Complaint registered successfully, Complaint no : " + complaintno, "COMPLAINT_REGISTERED");
                    return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
                }
                logger.error((Object)("Error in registering complaint : " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Error in registering complaint.", "EXCEPTION");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            logger.error((Object)("Error in registering complaint, Empty data. : " + username));
            this.objCommonResponse = new CommonResponseObject(1, "Error in registering complaint. Empty data.", "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @GetMapping(path={"/getcomplainthistory/{username}/{date}/{usertype}"}, produces={"application/json"})
    public ResponseEntity<ComplaintHistoryResponse> getComplaintHistory(@PathVariable(value="username") String username, @PathVariable(value="date") String date, @PathVariable(value="usertype") String usertype) {
        String responseMessage = "Request for complaint history username : " + username + ", date : " + date + ", usertype : " + usertype;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        ComplaintHistoryResponse objComplaintHistoryResponse = new ComplaintHistoryResponse();
        ArrayList<HospitalComplaint> listHospitalComplaintHistory = new ArrayList<HospitalComplaint>();
        try {
            username = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)username));
            logger.info((Object)("Request for complaint history username : " + username));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            objComplaintHistoryResponse = new ComplaintHistoryResponse(1, "Please provide valid input.", null, null, null, null, "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintHistoryResponse);
        }
        if (username.isEmpty()) {
            logger.error((Object)"Please provide valid username.");
            objComplaintHistoryResponse = new ComplaintHistoryResponse(1, "Please provide valid username.", null, null, null, null, "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintHistoryResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                objComplaintHistoryResponse = new ComplaintHistoryResponse(1, "Please provide valid username.", null, null, null, null, "INVALID_DETAILS");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintHistoryResponse);
            }
            List userInfo = null;
            String string = usertype = usertype.isEmpty() ? "P" : usertype;
            if (usertype.equals("H")) {
                sql = "select a.id,a.compsource,a.complainttype service,a.complaintno,\r\n a.complainttime,a.complaintdesc,a.currentstatus,a.pendingat,\r\n coalesce(a.complaintcreatedby,'')complaintcreatedby,coalesce(a.patientname,'') patientname,coalesce(a.uhid,'')uhid\r\n ,coalesce(a.signature,'')signature,coalesce(a.pic1,'')pic1,coalesce(a.pic2,'')pic2,coalesce(a.extraremarks,'')extraremarks From complaint.v_complaintdetails a where a.complainttime::date::text = ?";
                userInfo = dbSwitch.queryForList(sql, new Object[]{date});
            } else if (usertype.equals("S")) {
                sql = "select a.id,a.compsource,a.complainttype service,a.complaintno,\r\n a.complainttime,a.complaintdesc,a.currentstatus,a.pendingat,\r\n coalesce(a.complaintcreatedby,'')complaintcreatedby,coalesce(a.patientname,'') patientname,coalesce(a.uhid,'')uhid\r\n ,coalesce(a.signature,'')signature,coalesce(a.pic1,'')pic1,coalesce(a.pic2,'')pic2,coalesce(a.extraremarks,'')extraremarks From complaint.v_complaintdetails a where a.agentid = ? and a.complainttime::date::text = ?";
                userInfo = dbSwitch.queryForList(sql, new Object[]{username, date});
            } else {
                sql = "select a.id,a.compsource,a.complainttype service,a.complaintno,\r\n a.complainttime,a.complaintdesc,a.currentstatus,a.pendingat,\r\n coalesce(a.complaintcreatedby,'')complaintcreatedby,coalesce(a.patientname,'') patientname,coalesce(a.uhid,'')uhid\r\n ,coalesce(a.signature,'')signature,coalesce(a.pic1,'')pic1,coalesce(a.pic2,'')pic2,coalesce(a.extraremarks,'')extraremarks From complaint.v_complaintdetails a where a.complaintcreatedby = ? and a.complainttime::date::text = ?";
                userInfo = dbSwitch.queryForList(sql, new Object[]{username, date});
            }
            for (Map data : userInfo) {
                try {
                    HospitalComplaint objHospitalComplaintHistory = new HospitalComplaint(Long.parseLong(data.get("id").toString()), data.get("compsource").toString(), data.get("service").toString(), Long.parseLong(data.get("complaintno").toString()), data.get("complainttime").toString(), data.get("complaintdesc").toString(), data.get("currentstatus").toString(), data.get("pendingat").toString(), data.get("complaintcreatedby").toString(), data.get("patientname").toString(), data.get("uhid").toString(), data.get("signature").toString(), data.get("pic1").toString(), data.get("pic2").toString(), data.get("extraremarks").toString());
                    listHospitalComplaintHistory.add(objHospitalComplaintHistory);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error fetching complaint history : username : " + username + ex.getMessage()), (Throwable)ex);
                }
            }
            objComplaintHistoryResponse = new ComplaintHistoryResponse(0, "OK", "complainttime", "[\"id\", \"compsource\",\"pendingat\",\"complaintdesc\"]", "[{\"id\": \"ID\",\"compsource\": \"Source\",\"service\": \"Service\",\"complaintno\": \"Request No\",\"complainttime\": \"Time\",\"complainttime\": \"Complaint Text\",\"currentstatus\": \"Status\",\"pendingat\": \"Pending At\",\"complaintcreatedby\": \"Creater\",\"patientname\": \"Name\",\"uhid\": \"UHID\"}]", listHospitalComplaintHistory, "OK");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintHistoryResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            objComplaintHistoryResponse = new ComplaintHistoryResponse(1, "Error Message : " + ex.getMessage(), null, null, null, null, "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintHistoryResponse);
        }
    }

    @PostMapping(path={"/closecomplaint"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> closeComplaint(@RequestParam(value="username", defaultValue="") String username, @RequestParam(name="complaintno", defaultValue="0") long complaintno, @RequestParam(value="remarks", defaultValue="") String remarks) {
        String responseMessage = "Request for closing complaint by username : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        this.objCommonResponse = new CommonResponseObject();
        try {
            username = SecurityUtils.decrypt((String)username);
            logger.info((Object)("Request for closing complaint by username : " + username + ", complaintno : " + complaintno));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (username.isEmpty() || complaintno == 0L) {
            logger.error((Object)"Please provide valid username or valid complaint no.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username or complaint no.", "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            sql = "update complaint.t_complaints set status = ? , lastactiontakenby = ? , lastactiontakenon = now() where complaintno = ?";
            dbSwitch.update(sql, new Object[]{3, username, complaintno});
            sql = "update pbx.t_cdr set coral_balance=? where coral_dialid=? and coral_app='ivrsupport'";
            Object[] param1 = new Object[]{3, complaintno};
            int[] type1 = new int[]{4, -5};
            dbSwitch.update(sql, param1, type1);
            sql = "insert into complaint.m_complainthistory (complaintno,actor,action,actiondate,remarks)  values(?,?,?,now(),?)";
            Object[] param2 = new Object[]{complaintno, username, "Task Closed", remarks.isEmpty() ? "Closed" : remarks};
            int[] type2 = new int[]{-5, 12, 12, 12};
            dbSwitch.update(sql, param2, type2);
            logger.error((Object)("Complaint closed successfully : " + username + ", Complaint no : " + complaintno));
            this.objCommonResponse = new CommonResponseObject(0, "Complaint closed successfully.", "COMPLAINT_CLOSED");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    @GetMapping(path={"/getcomplaintcount/{date}"}, produces={"application/json"})
    public ResponseEntity<ComplaintCountResponse> getComplaintCount(@PathVariable(value="date") String date) {
        String responseMessage = "Request for complaint count date : " + date;
        logger.info((Object)responseMessage);
        String sql = "";
        ComplaintCountResponse objComplaintCountResponse = new ComplaintCountResponse();
        try {
            date = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)date));
            logger.info((Object)("Request for complaint count date : " + date));
            responseMessage = responseMessage + " <--> " + date;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintCountResponse);
        }
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        try {
            List complaintsCount = null;
            sql = "select case when max(coral_balance) != 3 then max(complainttime)::date \r\nelse max(complaint.closedon(complaintno)::timestamp without time zone)::date end as complaintdate,\r\nsum(case when coral_balance = 0 then 1 else 0 end) \"pendingforassignment\",\r\nsum(case when coral_balance = 1 then 1 else 0 end) \"assignedtoagent\",\r\nsum(case when coral_balance = 2 then 1 else 0 end) \"pendingforapproval\",\r\nsum(case when coral_balance = 3 then 1 else 0 end) \"closed\"\r\n from complaint.v_complaintdetails where 1=1";
            sql = sql + "  and complaintdate::date::text = ? ";
            sql = sql + " group by complaintdate::date";
            complaintsCount = dbSwitch.queryForList(sql, new Object[]{date});
            for (Map data : complaintsCount) {
                try {
                    objComplaintCountResponse = new ComplaintCountResponse(data.get("complaintdate").toString(), Integer.parseInt(data.get("pendingforassignment").toString()), Integer.parseInt(data.get("assignedtoagent").toString()), Integer.parseInt(data.get("pendingforapproval").toString()), Integer.parseInt(data.get("closed").toString()));
                }
                catch (Exception ex) {
                    logger.error((Object)("Error fetching complaint count : date : " + date + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objComplaintCountResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(null);
        }
    }

    @GetMapping(path={"/getserviceagentlist/{service}"}, produces={"application/json"})
    public ResponseEntity<List<ServiceAgentList>> getServiceAgentList(@PathVariable(value="service") String service) {
        String responseMessage = "Request for service agent list service : " + service;
        logger.info((Object)responseMessage);
        String sql = "";
        ServiceAgentList objServiceAgentList = new ServiceAgentList();
        ArrayList<ServiceAgentList> listServiceAgentList = new ArrayList<ServiceAgentList>();
        try {
            service = SecurityUtils.decrypt((String)HospitalComplaintController.decodeString((String)service));
            logger.info((Object)("Request for service agent list : " + service));
            responseMessage = responseMessage + " <--> " + service;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(listServiceAgentList);
        }
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        try {
            List complaintsCount = null;
            sql = "select id,coalesce(deptname,'') service,coalesce(userid,'') serviceenggid,coalesce(description,'') serviceenggname\r\nfrom complaint.v_dept_engineer_list where coalesce(userid,'') <> '' and ('ALL' = ? or lower(deptname) = ?)\r\norder by id";
            complaintsCount = dbSwitch.queryForList(sql, new Object[]{service, service.toLowerCase()});
            for (Map data : complaintsCount) {
                try {
                    objServiceAgentList = new ServiceAgentList(Integer.valueOf(Integer.parseInt(data.get("id").toString())), data.get("service").toString(), data.get("serviceenggid").toString(), data.get("serviceenggname").toString());
                    listServiceAgentList.add(objServiceAgentList);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error fetching service agent list service : " + service + " Error : " + ex.getMessage()), (Throwable)ex);
                }
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(listServiceAgentList);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(null);
        }
    }

    @PostMapping(path={"/assigncomplaint"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> assignComplaint(@RequestParam(value="username", defaultValue="") String username, @RequestParam(name="complaintno", defaultValue="0") long complaintno, @RequestParam(value="remarks", defaultValue="") String remarks) {
        String responseMessage = "Request for assigning complaint to service agent : " + username;
        logger.info((Object)responseMessage);
        int userexists = 0;
        String sql = "";
        this.objCommonResponse = new CommonResponseObject();
        try {
            username = SecurityUtils.decrypt((String)username);
            logger.info((Object)("Request for assigining complaint to service agent : " + username + ", complaintno : " + complaintno));
            responseMessage = responseMessage + " <--> " + username;
        }
        catch (Exception ex) {
            logger.error((Object)("Please provide valid input. Error : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid input.", "INVALID_INPUT");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        if (username.isEmpty() || complaintno == 0L) {
            logger.error((Object)"Please provide valid username or valid complaint no.");
            this.objCommonResponse = new CommonResponseObject(1, "Please provide valid username or complaint no.", "INVALID_DETAILS");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        JdbcTemplate db = new JdbcTemplate(this.dsUsers);
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        sql = "select count(*) from m_user where username = ? and coalesce(applicationname,'') = 'CMS-H' and enabled = 1;";
        try {
            userexists = (Integer)db.queryForObject(sql, new Object[]{username}, Integer.class);
            if (userexists == 0) {
                logger.error((Object)("Invalid username. " + username));
                this.objCommonResponse = new CommonResponseObject(1, "Invalid username. " + username, "INVALID_USER");
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
            }
            sql = "update complaint.t_complaints set status = ? , lastactiontakenby = ? , lastactiontakenon = now() where complaintno = ?";
            dbSwitch.update(sql, new Object[]{1, username, complaintno});
            sql = "update pbx.t_cdr set coral_balance=?,cc_agent=? where coral_dialid=? and coral_app='ivrsupport'";
            Object[] param1 = new Object[]{1, username, complaintno};
            int[] type1 = new int[]{4, 12, -5};
            dbSwitch.update(sql, param1, type1);
            sql = "insert into complaint.m_complainthistory (complaintno,actor,action,actiondate,remarks,touser)  values(?,?,?,now(),?,?)";
            Object[] param2 = new Object[]{complaintno, username, "assigned to agent", remarks.isEmpty() ? "Assigned to agent." : remarks, username};
            int[] type2 = new int[]{-5, 12, 12, 12, 12};
            dbSwitch.update(sql, param2, type2);
            logger.error((Object)("Complaint assigned successfully : " + username + ", Complaint no : " + complaintno));
            this.objCommonResponse = new CommonResponseObject(0, "Complaint assigned successfully.", "COMPLAINT_ASSIGNED");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error : " + responseMessage + ", Error Message : " + ex.getMessage()), (Throwable)ex);
            this.objCommonResponse = new CommonResponseObject(1, "Error : " + ex.getMessage(), "EXCEPTION");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.objCommonResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateComplaintNo(JdbcTemplate db) {
        String cmsno = "";
        PreparedStatement query = null;
        ResultSet rs = null;
        String qry = "";
        Date cNow = new Date();
        int cmsCount = 0;
        boolean found = false;
        SimpleDateFormat vardate = new SimpleDateFormat("yyyy-MM-dd");
        Connection conn = null;
        try {
            conn = db.getDataSource().getConnection();
        }
        catch (Exception ex) {
            logger.error((Object)("Error in Getting Connection : " + ex.getMessage()), (Throwable)ex);
        }
        if (conn != null) {
            try {
                qry = "select varnum from pbx.generatecmsno where created_on::date=?::date";
                query = conn.prepareStatement(qry);
                query.setString(1, vardate.format(cNow));
                rs = query.executeQuery();
                while (rs.next()) {
                    found = true;
                    cmsCount = rs.getInt("varnum");
                }
                if (found) {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    cmsno = String.format("%03d", ++cmsCount);
                    qry = "update pbx.generatecmsno set varnum=? where created_on::date=?::date";
                    query = conn.prepareStatement(qry);
                    query.setInt(1, cmsCount);
                    query.setString(2, vardate.format(cNow));
                    query.executeUpdate();
                } else {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    cmsno = String.format("%03d", ++cmsCount);
                    qry = "insert into pbx.generatecmsno (created_on,varnum)values(now(),?)";
                    query = conn.prepareStatement(qry);
                    query.setInt(1, cmsCount);
                    query.executeUpdate();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)("Exception at module cmsRecodingComplaint of generateComplaintNo message:" + ex.getMessage()), (Throwable)ex);
            }
            finally {
                try {
                    if (query != null) {
                        query.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)("Exception at module cmsRecodingComplaint of generateComplaintNo message:" + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        return cmsno;
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }
}

