/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.oc.api;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class SendPacketToUDPServer {
    private static final Logger logger = Logger.getLogger(SendPacketToUDPServer.class);

    public void sendPacket(String hostName, int port, String command) {
        try {
            if (hostName.isEmpty() || port < 1 || command.isEmpty()) {
                logger.info((Object)String.format("Please provide details. hostName : %s, port : %d & command : %s.", hostName, port, command));
                return;
            }
            logger.info((Object)String.format("Detaild Provided are hostName : %s, port : %d & command : %s.", hostName, port, command));
            DatagramSocket theSocket = new DatagramSocket();
            InetAddress server = InetAddress.getByName(hostName);
            byte[] data = command.getBytes();
            logger.info((Object)("Sending Datagram Packet " + data + " to Server : " + server + " on port : " + port));
            DatagramPacket theOutput = new DatagramPacket(data, data.length, server, port);
            theSocket.send(theOutput);
        }
        catch (UnknownHostException uhex) {
            logger.error((Object)("Error in sendPacket() " + uhex.getMessage()), (Throwable)uhex);
        }
        catch (SocketException se) {
            logger.error((Object)("Error in sendPacket() " + se.getMessage()), (Throwable)se);
        }
        catch (IOException ioex) {
            logger.error((Object)("Error in sendPacket() " + ioex.getMessage()), (Throwable)ioex);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in sendPacket() " + ex.getMessage()), (Throwable)ex);
        }
    }
}

