/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.oc.api;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.oc.api.SendPacketToUDPServer;
import com.coraltele.oc.api.commandDialer;
import com.coraltele.oc.hardphone.ListOcOutgoingData;
import com.coraltele.oc.hardphone.OCSoapRPCCalls;
import com.coraltele.oc.hardphone.OCSoapRPCCallsImplService;
import com.coraltele.oc.hardphone.RowOCResponse;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.pbxservice.api.XmlRPCClient;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/ochardphone/api/v1"})
public class CoralOCHardPhoneController {
    private static final Logger logger = Logger.getLogger(CoralOCHardPhoneController.class);
    private commandDialer objCommandDialer = new commandDialer();
    private static OCSoapRPCCallsImplService client;
    private static OCSoapRPCCalls service;
    private static RowOCResponse ocResponse;
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest servletrequest;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    @Autowired
    @Qualifier(value="dataSourceBillingDB")
    private DataSource dsBillingDB;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CoralOCHardPhoneController() {
        CoralOCHardPhoneController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
        try {
            URL url = new URL("http://127.0.0.1:9998/OCSoapRPCCalls");
            client = new OCSoapRPCCallsImplService(url);
            service = client.getOCSoapRPCCallsImplPort();
        }
        catch (Exception ex) {
            logger.error((Object)("Error in Connecting OCSoapRPCCalls service." + ex.getMessage()), (Throwable)ex);
        }
    }

    private static String Base64decode(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.getDecoder().decode(p_message.getBytes());
            _ret = new String(bytesEncoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    private static byte[] decode(String p_message) {
        try {
            byte[] bytesdecoded = Base64.getDecoder().decode(p_message);
            return bytesdecoded;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decode : , Error : => " + ex.getMessage()));
            return null;
        }
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    @PostMapping(path={"/pickIncomingCall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> pickIncomingCall(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="acdgroup") String acdgroup, @RequestParam(value="calltype") String calltype, @RequestParam(value="targetsessionuuid") String targetsessionuuid, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for pickup call, -> " + operatorextension + ", " + acdgroup + ", " + calltype + ", " + targetsessionuuid;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || targetsessionuuid.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.pickIncomingCall(operatorextension, acdgroup, calltype, targetsessionuuid)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in picking call for : " + operatorextension + ", " + acdgroup + ", " + calltype + ", " + targetsessionuuid + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/makecall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> makeCall(@RequestParam(value="operatorid") String operatorid, @RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="targetextension") String targetextension, @RequestParam(value="acdgroup") String acdgroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for making call, -> " + operatorid + ", " + operatorextension + ", " + targetextension + ", " + acdgroup;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorid.isEmpty() || operatorextension.isEmpty() || targetextension.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.makeCall(operatorid, operatorextension, targetextension, acdgroup)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in making call for : " + operatorid + ", " + operatorextension + ", " + targetextension + ", " + acdgroup + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/holdCaller"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> holdCaller(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="acdgroup") String acdgroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for hold/unhold call, -> " + operatorextension + ", , " + acdgroup;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || acdgroup.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.holdCaller(operatorextension, acdgroup)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in hold/unhold call for : " + operatorextension + ", , " + acdgroup + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/park"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> park(@RequestParam(value="operatorextension") String operatorextension, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for park call, -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.park(operatorextension)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in park call for : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/releaseOperator"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> releaseOperator(@RequestParam(value="operatorextension") String operatorextension, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for release operator, -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.releaseOperator(operatorextension)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in release operator : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/patchNumber"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> patchNumber(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="targetsessionuuid") String targetsessionuuid, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for patch number, -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || targetsessionuuid.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.patchNumber(operatorextension, targetsessionuuid)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in patch number : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getOperatorOutGoingCall/{operatorextension}/{operatorname}/{acdgroup}"}, produces={"application/json"})
    public ListOcOutgoingData getOperatorOutGoingCall(@PathVariable(value="operatorextension") String operatorextension, @PathVariable(value="operatorname") String operatorname, @PathVariable(value="acdgroup") String acdgroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for getting operator outgoing calls, -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ListOcOutgoingData objCommonResponse = new ListOcOutgoingData();
        List responsedata = new ArrayList();
        if (operatorextension.isEmpty()) {
            objCommonResponse.setResponsecode(Integer.valueOf(1));
            objCommonResponse.setResponsemessage("Invalid Input");
            objCommonResponse.setResponsedata(responsedata);
            return objCommonResponse;
        }
        try {
            if (service != null && (objCommonResponse = service.getOperatorOutGoingCall(operatorextension, operatorname, acdgroup)) != null) {
                responseStatus = objCommonResponse.getResponsecode();
                response = objCommonResponse.getResponsemessage();
                responsedata = objCommonResponse.getResponsedata();
            }
            objCommonResponse.setResponsecode(Integer.valueOf(responseStatus));
            objCommonResponse.setResponsemessage(response);
            objCommonResponse.setResponsedata(responsedata);
            return objCommonResponse;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting operator calls : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse.setResponsecode(Integer.valueOf(1));
            objCommonResponse.setResponsemessage("Error in getting operator calls : " + operatorextension + ". Error -> " + ex.getMessage());
            objCommonResponse.setResponsedata(responsedata);
            return objCommonResponse;
        }
    }

    @PostMapping(path={"/transferAT"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> transferAT(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="acdgroup") String acdgroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for attendant transfer -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || acdgroup.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.transferAT(operatorextension, acdgroup)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in attendant transfer : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/threePartyConf"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> transferAT(@RequestParam(value="operatorextension") String operatorextension, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for start 3 party conference -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.threePartyConf(operatorextension)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in start 3 party conference : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/transfer"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> transferAT(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="transferextension") String transferextension, @RequestParam(value="acdgroup") String acdgroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for transfer -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || transferextension.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.transfer(operatorextension, transferextension, acdgroup)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in transfer : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/dialinconferencecommand"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> dialInConferenceCommand(@RequestParam(value="operatorid") String operatorid, @RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="conferenceRoom") String conferenceRoom, @RequestParam(value="extensions") String extensions, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for dial in conference -> " + operatorextension;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorid.isEmpty() || operatorextension.isEmpty() || conferenceRoom.isEmpty() || extensions.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (service != null && (ocResponse = service.dialinconferencecommand(operatorid, operatorextension, conferenceRoom, extensions)) != null) {
                responseStatus = ocResponse.getResponsecode();
                response = ocResponse.getResponsemessage();
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in dial in conference : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/operatorLogout"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> operatorLogout(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="operatorname") String operatorname, @RequestParam(value="acdgroup") String acdgroup, @RequestParam(value="operatorFullname") String operatorFullname, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for OperatorLogout -> " + operatorextension + ",operatorName:" + operatorname + ",acdgroup:" + acdgroup;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || operatorname.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Operator", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            String sql = "";
            logger.info((Object)("billing system create operator Logout entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname));
            JdbcTemplate dbBilling = new JdbcTemplate(this.dsBillingDB);
            sql = "insert into t_userstatus (curr_time,status,username,extensionno,userfullname)values(now(),?,?,?,?)";
            dbBilling.update(sql, new Object[]{"Logout", operatorname, operatorextension, operatorFullname});
            JdbcTemplate db = new JdbcTemplate(this.dsCallCenter);
            sql = "update agents set status ='Logged Out' where name=?";
            db.update(sql, new Object[]{operatorextension});
            responseStatus = 200;
            response = "updateSucessFully Logout";
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in transfer : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/operatorBreak"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> operatorBreak(@RequestParam(value="operatorextension") String operatorextension, @RequestParam(value="operatorname") String operatorname, @RequestParam(value="acdgroup") String acdgroup, @RequestParam(value="break") String isenable, @RequestParam(value="operatorFullname") String operatorFullname, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for operatorBreak -> " + operatorextension + ",operatorName:" + operatorname + ",acdgroup:" + acdgroup;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        String contactOperator = "";
        String operatorStatus = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        if (operatorextension.isEmpty() || operatorname.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Operator", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            String sql = "";
            JdbcTemplate dbBilling = new JdbcTemplate(this.dsBillingDB);
            JdbcTemplate db = new JdbcTemplate(this.dsCallCenter);
            sql = "select coalesce(extension,'') as extension from callcenter.operatormaster where operatorcode = ? limit 1;";
            contactOperator = (String)db.query(sql, new Object[]{operatorname}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (isenable.equalsIgnoreCase("true")) {
                logger.info((Object)("billing system create operatorBreak: " + isenable + " entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname));
                sql = "insert into t_userstatus (curr_time,status,username,extensionno,userfullname)values(now(),?,?,?,?)";
                dbBilling.update(sql, new Object[]{"BreakIn", operatorname, operatorextension, operatorFullname});
                if (!contactOperator.isEmpty()) {
                    sql = "update agents set status ='On Break' where name=?";
                    db.update(sql, new Object[]{operatorextension});
                    response = "Break Sucessfully";
                    logger.info((Object)("Sucessfully update operatorBreak: " + isenable + " entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname));
                } else {
                    logger.info((Object)("Unable to update callcenter operatorBreak: " + isenable + " entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname));
                }
            } else {
                logger.info((Object)("billing system create Available operatorBreak: " + isenable + " entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname));
                sql = "insert into t_userstatus (curr_time,status,username,extensionno,userfullname)values(now(),?,?,?,?)";
                dbBilling.update(sql, new Object[]{"BreakOut", operatorname, operatorextension, operatorFullname});
                if (!contactOperator.isEmpty()) {
                    sql = "select coalesce(operatorstatus,'') as operatorstatus from callcenter.operatormaster where operatorcode = ? limit 1;";
                    operatorStatus = (String)db.query(sql, new Object[]{operatorname}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    sql = operatorStatus.equalsIgnoreCase("loggedout") ? "update agents set state = 'Waiting' , status= 'Operator Pickup' where name=?" : "update agents set state = 'Waiting' , status= 'Available' where name=?";
                    db.update(sql, new Object[]{operatorextension});
                    response = "Loggedin Sucessfully";
                    logger.info((Object)("Sucessfully Login update from operatorBreak: " + isenable + " entry for operator:" + operatorname + ",for extension:" + operatorextension + " fullname:" + operatorFullname + " Status:" + (operatorStatus.equalsIgnoreCase("loggedout") ? "operatorpickup" : "Available")));
                }
            }
            responseStatus = 0;
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in transfer : " + operatorextension + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/dialinconference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> dialInConference(@RequestParam(value="conferenceroom") String conferenceroom, @RequestParam(value="number") String number, @RequestParam(defaultValue="") String agentnumber) {
        String responseMessage = "Request for dail number in conference. -> " + conferenceroom + ", " + number;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String rluCode = "";
        String virtualIp = "";
        int systemExtension = 0;
        String command = "";
        String dialingNumbers = "";
        int isEmergencyConferenceNumber = 0;
        int isEmergencyPhone = 0;
        String qry = "";
        String sipServerInfo = "";
        String conferenceName = "";
        String sipServicesUrl = "";
        String extensionType = "";
        if (conferenceroom.isEmpty() || number.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (agentnumber.isEmpty()) {
            agentnumber = "ConferenceCall";
        }
        try {
            String serverIp;
            CoralMeetSystemConfig meetconfig;
            if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                sipServicesUrl = meetconfig.getSipServicesURL();
                try {
                    qry = "select count(*) from pbx.extensions where extension = ?";
                    systemExtension = (Integer)db.queryForObject(qry, new Object[]{number}, Integer.class);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in finding either it is a system number or not : " + number + ", Error : " + ex.getMessage()), (Throwable)ex);
                }
                sipServerInfo = meetconfig.getSipserverinfo();
                virtualIp = systemExtension == 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSipserverinfo().isEmpty() ? meetconfig.getSipserverinfo() : (systemExtension > 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4"));
                logger.info((Object)("Final Virtual Ip : " + virtualIp));
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            rluCode = !rluCode.isEmpty() ? "internal_" + rluCode.trim() : "internal";
            qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
            extensionType = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = " select data from pbx.extensions where extension_type = 'ec' and extension = ? and coalesce(data,'') <> '' limit 1;";
            dialingNumbers = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = "select coalesce(contactname,'') contactname from pbx.directorylist where coalesce(contactno,'') = ? limit 1;";
            conferenceName = (String)db.query(qry, new Object[]{conferenceroom}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            String string = conferenceName = conferenceName.isEmpty() ? conferenceroom : conferenceName;
            if (!dialingNumbers.isEmpty()) {
                isEmergencyConferenceNumber = 1;
            }
            if ((isEmergencyPhone = ((Integer)db.queryForObject(qry = "select count(*) from  pbx.extensions where extension = ? and extension_type = 'emergencyphone';", new Object[]{number}, Integer.class)).intValue()) > 0) {
                isEmergencyConferenceNumber = 2;
            }
            XmlRPCClient obj = new XmlRPCClient();
            SendPacketToUDPServer objSendUDP = new SendPacketToUDPServer();
            if (isEmergencyConferenceNumber == 1) {
                logger.info((Object)String.format("The number %s is emergency conference number so inspite of ec number the group number list %s will be dialed.", number, dialingNumbers));
                for (String dialingNumber : dialingNumbers.split(",")) {
                    if (dialingNumber.isEmpty()) continue;
                    qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
                    extensionType = (String)db.query(qry, new Object[]{dialingNumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    if (!sipServicesUrl.isEmpty()) {
                        command = String.format("ORIGINATE %s %s %s %s %s", dialingNumber, conferenceroom, conferenceName, "emergencyphoneConf", extensionType);
                        String serverIp2 = sipServicesUrl.split(":")[0];
                        int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                        if (command.isEmpty()) continue;
                        objSendUDP.sendPacket(serverIp2, port, command);
                        continue;
                    }
                    command = "{origination_callee_id_name=";
                    command = command + dialingNumber;
                    command = command + ",origination_caller_id_number='";
                    command = command + agentnumber;
                    command = command + "',origination_caller_id_name='" + agentnumber + "'}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + dialingNumber;
                    command = command + "@";
                    command = command + virtualIp;
                    command = command + " ";
                    command = command + conferenceroom;
                    command = command + " ";
                    if ((command = command + "XML emergencyphoneConf").isEmpty()) continue;
                    obj.executeCommandAsync("freeswitch.api", "originate", command);
                }
                responseMessage = String.format("Number(s) %s is added in conference room %s.", dialingNumbers, conferenceroom);
            } else if (isEmergencyConferenceNumber == 2) {
                logger.info((Object)String.format("The number %s is emergency phone number so creating own conference for number %s.", number, number));
                if (!sipServicesUrl.isEmpty()) {
                    command = String.format("ORIGINATE %s %s %s %s %s", number, conferenceroom, "conference-bridge", "emergencyphoneConf", extensionType);
                    serverIp = sipServicesUrl.split(":")[0];
                    int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                    if (!command.isEmpty()) {
                        objSendUDP.sendPacket(serverIp, port, command);
                    }
                } else {
                    command = "{origination_callee_id_name=";
                    command = command + number;
                    command = command + ",origination_caller_id_number='";
                    command = command + agentnumber;
                    command = command + "',origination_caller_id_name='conference-bridge',sip_h_X-apiconferencebridge=true}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + number;
                    command = command + "@";
                    command = command + sipServerInfo;
                    command = command + " ";
                    command = command + conferenceroom;
                    command = command + " ";
                    if (!(command = command + "XML emergencyphoneConf").isEmpty()) {
                        obj.executeCommandAsync("freeswitch.api", "originate", command);
                    }
                }
                responseMessage = String.format("Number(s) %s is added in its own conference room %s.", number, number);
            } else {
                logger.info((Object)String.format("The number %s is  normal number so it will be dialed.", number));
                if (!sipServicesUrl.isEmpty()) {
                    command = String.format("ORIGINATE %s %s %s %s %s", number, conferenceroom, conferenceName, "emergencyphoneConf", extensionType);
                    serverIp = sipServicesUrl.split(":")[0];
                    int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                    if (!command.isEmpty()) {
                        objSendUDP.sendPacket(serverIp, port, command);
                    }
                } else {
                    logger.info((Object)String.format("Execute Command for number %s for sytemExtension: %d", number, systemExtension));
                    if (systemExtension == 0) {
                        command = "{origination_callee_id_name=";
                        command = command + number;
                        command = command + ",origination_caller_id_number='";
                        command = command + agentnumber;
                        command = command + "',origination_caller_id_name='dialtoConference'}sofia/";
                        command = command + rluCode;
                        command = command + "/";
                        command = command + number;
                        command = command + "@";
                        command = command + virtualIp;
                        command = command + " ";
                        command = command + conferenceroom;
                        command = command + " ";
                        command = command + "XML emergencyphoneConf";
                    } else {
                        command = "{origination_callee_id_name=";
                        command = command + number;
                        command = command + ",origination_caller_id_number='";
                        command = command + agentnumber;
                        command = command + "',origination_caller_id_name='" + agentnumber + "'}sofia/";
                        command = command + rluCode;
                        command = command + "/";
                        command = command + number;
                        command = command + "@";
                        command = command + virtualIp;
                        command = command + " ";
                        command = command + conferenceroom;
                        command = command + " ";
                        command = command + "XML emergencyphoneConf";
                    }
                    if (!command.isEmpty()) {
                        obj.executeCommandAsync("freeswitch.api", "originate", command);
                    }
                }
                responseMessage = String.format("Number %s is added in conference room %s.", number, conferenceroom);
            }
            try {
                logger.info((Object)responseMessage);
                objCommonResponse = new CommonResponseObject(0, responseMessage, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/dialingroupcall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> dialInGroupCall(@RequestParam(value="conferenceroom") String conferenceroom, @RequestParam(value="number") String number, @RequestParam(defaultValue="") String agentnumber) {
        String responseMessage = "Request for dialingroupcall number in conference. -> " + conferenceroom + ", " + number + "," + agentnumber;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String rluCode = "";
        String virtualIp = "";
        int systemExtension = 0;
        int checkGCsystemExtension = 0;
        String command = "";
        String dialingNumbers = "";
        boolean isGroupCallNumber = false;
        String qry = "";
        String sipServerInfo = "";
        String conferenceName = "";
        String sipServicesUrl = "";
        String extensionType = "";
        if (conferenceroom.isEmpty() || number.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (agentnumber.isEmpty()) {
            agentnumber = "ConferenceCall";
        }
        try {
            CoralMeetSystemConfig meetconfig;
            if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                sipServicesUrl = meetconfig.getSipServicesURL();
                try {
                    qry = "select count(*) from pbx.extensions where extension = ?";
                    systemExtension = (Integer)db.queryForObject(qry, new Object[]{number}, Integer.class);
                }
                catch (Exception ex) {
                    logger.error((Object)("[dialingroupcall] Error in finding either it is a system number or not : " + number + ", Error : " + ex.getMessage()), (Throwable)ex);
                }
                sipServerInfo = meetconfig.getSipserverinfo();
                virtualIp = systemExtension == 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSipserverinfo().isEmpty() ? meetconfig.getSipserverinfo() : (systemExtension > 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4"));
                logger.info((Object)("[dialingroupcall] Final Virtual Ip : " + virtualIp));
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            rluCode = !rluCode.isEmpty() ? "internal_" + rluCode.trim() : "internal";
            qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
            extensionType = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = " select data from pbx.extensions where extension_type = 'groupcall' and extension = ? and coalesce(data,'') <> '' limit 1;";
            dialingNumbers = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            String string = conferenceName = conferenceName.isEmpty() ? conferenceroom : conferenceName;
            if (!dialingNumbers.isEmpty()) {
                isGroupCallNumber = true;
            }
            XmlRPCClient obj = new XmlRPCClient();
            SendPacketToUDPServer objSendUDP = new SendPacketToUDPServer();
            if (isGroupCallNumber) {
                logger.info((Object)String.format("[dialingroupcall]  The number %s is GroupCall Number so  group number list %s will be dialed.", number, dialingNumbers));
                for (String dialingNumber : dialingNumbers.split(",")) {
                    if (dialingNumber.isEmpty()) continue;
                    try {
                        qry = "select count(*) from pbx.extensions where extension = ?";
                        checkGCsystemExtension = (Integer)db.queryForObject(qry, new Object[]{dialingNumber}, Integer.class);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error groupcall dialing finding either it is a system number or not : " + dialingNumber + ", Error : " + ex.getMessage()), (Throwable)ex);
                    }
                    qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
                    extensionType = (String)db.query(qry, new Object[]{dialingNumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    if (!sipServicesUrl.isEmpty()) {
                        command = String.format("ORIGINATE %s %s %s %s %s", dialingNumber, conferenceroom, conferenceName, "groupcall", extensionType);
                        String serverIp = sipServicesUrl.split(":")[0];
                        int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                        if (command.isEmpty()) continue;
                        objSendUDP.sendPacket(serverIp, port, command);
                        continue;
                    }
                    if (checkGCsystemExtension == 0) {
                        command = "{origination_callee_id_name=";
                        command = command + dialingNumber;
                        command = command + ",origination_caller_id_number='";
                        command = command + agentnumber;
                        command = command + "',origination_caller_id_name='dialtoConference'}sofia/";
                        command = command + rluCode;
                        command = command + "/";
                        command = command + dialingNumber;
                        command = command + "@";
                        command = command + sipServerInfo;
                        command = command + " ";
                        command = command + "&conference(" + conferenceroom + "@default+flags{nomoh})";
                    } else {
                        command = "{origination_callee_id_name=";
                        command = command + dialingNumber;
                        command = command + ",origination_caller_id_number='";
                        command = command + agentnumber;
                        command = command + "',origination_caller_id_name='" + agentnumber + "'}sofia/";
                        command = command + rluCode;
                        command = command + "/";
                        command = command + dialingNumber;
                        command = command + "@";
                        command = command + virtualIp;
                        command = command + " ";
                        command = command + "&conference(" + conferenceroom + "@default+flags{nomoh})";
                    }
                    if (command.isEmpty()) continue;
                    obj.executeCommandAsync("freeswitch.api", "originate", command);
                }
                responseMessage = String.format("[dialingroupcall] Number(s) %s is added in conference room %s.", dialingNumbers, conferenceroom);
            } else {
                logger.info((Object)String.format("[dialingroupcall] The number %s is  normal number so it will be dialed.", number));
                if (!sipServicesUrl.isEmpty()) {
                    command = String.format("ORIGINATE %s %s %s %s %s", number, conferenceroom, conferenceName, "emergencyphoneConf", extensionType);
                    String serverIp = sipServicesUrl.split(":")[0];
                    int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                    if (!command.isEmpty()) {
                        objSendUDP.sendPacket(serverIp, port, command);
                    }
                } else {
                    command = "{origination_callee_id_name=";
                    command = command + number;
                    command = command + ",origination_caller_id_number='";
                    command = command + agentnumber;
                    command = command + "',origination_caller_id_name='" + agentnumber + "'}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + number;
                    command = command + "@";
                    command = command + sipServerInfo;
                    command = command + " ";
                    if (!(command = command + "&conference(" + conferenceroom + "@default+flags{nomoh})").isEmpty()) {
                        obj.executeCommandAsync("freeswitch.api", "originate", command);
                    }
                }
                responseMessage = String.format("[dialingroupcall] Number %s is added in conference room %s.", number, conferenceroom);
            }
            try {
                logger.info((Object)responseMessage);
                objCommonResponse = new CommonResponseObject(0, responseMessage, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("[dialingroupcall] Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("[dialingroupcall] Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    static {
        ocResponse = new RowOCResponse();
    }
}

