/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.oc.api;

import com.coraltele.common.objects.CommonResponseObject;
import com.coraltele.common.objects.ProperNamingUtil;
import com.coraltele.config.env.databaseUtilities;
import com.coraltele.oc.api.ACDCallsList;
import com.coraltele.oc.api.ACDCallsListResponse;
import com.coraltele.oc.api.ConferenceListResponse;
import com.coraltele.oc.api.ConferenceMember;
import com.coraltele.oc.api.ConferenceStatusResponse;
import com.coraltele.oc.api.OperatorInitiatedCalls;
import com.coraltele.oc.api.ReadXMLFile;
import com.coraltele.oc.api.SendPacketToUDPServer;
import com.coraltele.oc.api.commandDialer;
import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import com.coraltele.restapi.pbxservice.api.XmlRPCClient;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/oc/api/v1"})
public class CoralOCController {
    private static final Logger logger = Logger.getLogger(CoralOCController.class);
    private commandDialer objCommandDialer = new commandDialer();
    private static String CIPHER_KEY = "C234567890123456";
    private static String CIPHER_IV = "1234567890123456";
    @Autowired
    private CoralMeetSystemConfig meetConfig;
    @Autowired
    HttpServletRequest servletrequest;
    @Autowired
    @Qualifier(value="dsSwitch")
    private DataSource dsSwitch;
    @Autowired
    @Qualifier(value="dsCallCenter")
    private DataSource dsCallCenter;
    databaseUtilities db;

    public static void Log4jPropertyConfigurator() {
        try {
            DOMConfigurator.configure((String)"/etc/coraltelecom/CRCPBXServiceAPI.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CoralOCController() {
        CoralOCController.Log4jPropertyConfigurator();
        this.db = new databaseUtilities();
    }

    private static String Base64decode(String p_message) {
        String _ret = "";
        try {
            byte[] bytesEncoded = Base64.getDecoder().decode(p_message.getBytes());
            _ret = new String(bytesEncoded);
        }
        catch (Exception ex) {
            _ret = p_message;
            logger.error((Object)("Error in decodeString : , Error : => " + ex.getMessage()));
        }
        return _ret;
    }

    private static byte[] decode(String p_message) {
        try {
            byte[] bytesdecoded = Base64.getDecoder().decode(p_message);
            return bytesdecoded;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decode : , Error : => " + ex.getMessage()));
            return null;
        }
    }

    public static byte[] encrypt(String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
        cipher.init(1, (Key)key, new IvParameterSpec(CIPHER_IV.getBytes("UTF-8")));
        return cipher.doFinal(plainText.getBytes("UTF-8"));
    }

    public static String decrypt(byte[] cipherText) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/pkcs5padding", "SunJCE");
        SecretKeySpec key = new SecretKeySpec(CIPHER_KEY.getBytes("UTF-8"), "AES");
        cipher.init(2, (Key)key, new IvParameterSpec(CIPHER_IV.getBytes("UTF-8")));
        return new String(cipher.doFinal(cipherText), "UTF-8");
    }

    public String getClientIpAddress(HttpServletRequest request) {
        String _ret = "";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        _ret = ip.trim();
        return _ret;
    }

    private static long generateuniquerandomNumber(JdbcTemplate db, int p_length, String p_table, String p_columnname) {
        long _randomnumber = 0L;
        int _duplicatenumber = 1;
        String qry = "";
        if (db != null && p_length > 0 && !p_table.isEmpty() && !p_columnname.isEmpty()) {
            try {
                for (int maxrepeat = 5; maxrepeat > 0 && (_duplicatenumber == 1 || _randomnumber == 0L); --maxrepeat) {
                    try {
                        _duplicatenumber = 1;
                        if (p_length == 4) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9000.0) + 1000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 6) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 900000.0) + 100000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        } else if (p_length == 8) {
                            try {
                                _randomnumber = (long)Math.floor(Math.random() * 9.0E7) + 10000000L;
                            }
                            catch (Exception ex) {
                                logger.error((Object)("Error in generating PIN  : " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        if ((_duplicatenumber = ((Integer)db.queryForObject(qry = "select count(*) from " + p_table + " where " + p_columnname + "::bigint = ?", new Object[]{_randomnumber}, Integer.class)).intValue()) <= 0) continue;
                        _randomnumber = 0L;
                        logger.info((Object)(p_length + " digit duplicate random number generated : " + _randomnumber));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                        _randomnumber = 0L;
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in generateuniquerandomNumber " + ex.getMessage()), (Throwable)ex);
                _randomnumber = 0L;
            }
        }
        logger.info((Object)(p_length + " digit random number generated : " + _randomnumber));
        return _randomnumber;
    }

    public ConferenceListResponse getConferenceStatus(JdbcTemplate db, String conferencenumber, String conferencegroup) {
        ConferenceMember objConferenceMember;
        String sql;
        ArrayList<ConferenceMember> ownerDetails;
        ArrayList<ConferenceMember> userNotDialed;
        ArrayList<ConferenceMember> userNotInConf;
        ArrayList<ConferenceMember> listConferenceMemberFinal;
        ConferenceListResponse returnValue;
        block31: {
            returnValue = new ConferenceListResponse();
            ArrayList listConferenceMember = new ArrayList();
            listConferenceMemberFinal = new ArrayList<ConferenceMember>();
            userNotInConf = new ArrayList<ConferenceMember>();
            userNotDialed = new ArrayList<ConferenceMember>();
            ownerDetails = new ArrayList<ConferenceMember>();
            ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
            sql = "";
            String command = "";
            String allcontactnumber = "";
            try {
                String conferenceData = "";
                try {
                    command = "conference " + conferencenumber + " xml_list";
                    conferenceData = this.objCommandDialer.getConferenceMemeberList(command);
                }
                catch (Exception exception) {
                    logger.error((Object)("Error in getting conference list. Error -> " + exception.getMessage()), (Throwable)exception);
                }
                if (conferenceData != null && !conferenceData.isEmpty() && conferenceData.startsWith("<?xml")) {
                    logger.info((Object)"Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        sql = "select coalesce(data, '') allnumber from pbx.extensions where extension = ?";
                        allcontactnumber = (String)db.query(sql, new Object[]{conferencegroup}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                        if (!allcontactnumber.isEmpty() && listConferenceMember.size() > 0) {
                            for (ConferenceMember conf : listConferenceMember) {
                                String CallerName = this.CallerName(db, conf.get_callernumber());
                                conf.set_callername(CallerName);
                                String CallerActualNumber = this.getCallerNumber(db, conf.getUuid(), conf.getCaller_id_number());
                                if (!CallerActualNumber.isEmpty()) {
                                    conf.set_callernumber(CallerActualNumber);
                                }
                                if (conf.get_callernumber().equalsIgnoreCase(conferencenumber)) {
                                    conf.set_ispartofgroup(2);
                                } else if (("," + allcontactnumber + ",").contains("," + conf.get_callernumber() + ",")) {
                                    conf.set_ispartofgroup(1);
                                }
                                listConferenceMemberFinal.add(conf);
                            }
                        }
                        break block31;
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error in getting conference list. Error -> " + exception.getMessage()), (Throwable)exception);
                        break block31;
                    }
                }
                logger.info((Object)"No Conference detail found");
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        for (ConferenceMember conferenceMember : listConferenceMemberFinal) {
            logger.info((Object)("listConferenceMemberFinal : " + conferenceMember.getCaller_id_number()));
        }
        try {
            List userNotInConfMap = null;
            sql = "select distinct\r\ncase when (coalesce(cid_num,'')  != ? and coalesce(dest,'') != ?) and Status = '2' Then '3' else coalesce(a.Status,'') end Status,\r\ncoalesce(number,'')number,coalesce(partyname,'')partyname,coalesce(cid_num,'')cid_num,coalesce(dest,'')dest from(\r\nselect \r\ncase when coalesce(d.callstate,coalesce(c.callstate,'RINGING')) IN ('RINGING','EARLY') then '2'\r\nelse case when coalesce(d.callstate,coalesce(c.callstate,'RINGING')) = 'ACTIVE' Then '3' end end Status,\r\na.allnumber number,''::text partyname,\r\ncoalesce(d.dest,coalesce(c.cid_num,'')) cid_num,coalesce(d.cid_num,coalesce(c.dest,'')) dest,coalesce(d.initial_cid_num,coalesce(c.initial_cid_num,''))initial_cid_num\r\nfrom (\r\nselect regexp_split_to_table(data, ',') allnumber from pbx.extensions where extension = ?\r\n) as a\r\ninner join channels b on a.allnumber = b.coral_original_num \r\nleft join channels c on b.uuid = c.call_uuid and coalesce(c.coral_original_num,'') <> coalesce(c.dest,'')\r\nleft join channels d on d.uuid = b.call_uuid and coalesce(d.coral_original_num,'') <> coalesce(d.dest,'')\r\n)a;";
            userNotInConfMap = db.queryForList(sql, new Object[]{conferencenumber, conferencenumber, conferencegroup});
            for (Map _userNotInConf : userNotInConfMap) {
                try {
                    objConferenceMember = new ConferenceMember(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, _userNotInConf.get("number").toString(), this.CallerName(db, _userNotInConf.get("number").toString()), _userNotInConf.get("dest").toString(), _userNotInConf.get("Status").toString(), 1, false, false, null);
                    userNotInConf.add(objConferenceMember);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting User Not in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting User Not in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        for (ConferenceMember conferenceMember : userNotInConf) {
            logger.info((Object)("userNotInConf : " + conferenceMember.getCaller_id_number()));
        }
        try {
            List userNotDialedMap = null;
            sql = "select '1' Status,coalesce(a.allnumber,'') number,''::text partyname,coalesce(b.cid_num,'') cid_num,coalesce(b.dest,'') dest\r\nfrom (\r\n    select regexp_split_to_table(data, ',') allnumber from pbx.extensions where extension = ?\r\n) as a\r\nleft join channels b on a.allnumber = b.coral_original_num and b.application = 'conference' and coalesce(b.coral_original_num,'') <> coalesce(b.dest,'')\r\n where coalesce(b.coral_original_num,'') = '';";
            userNotDialedMap = db.queryForList(sql, new Object[]{conferencegroup});
            for (Map _userNotInConf : userNotDialedMap) {
                try {
                    objConferenceMember = new ConferenceMember(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, _userNotInConf.get("number").toString(), this.CallerName(db, _userNotInConf.get("number").toString()), _userNotInConf.get("dest").toString(), _userNotInConf.get("Status").toString(), 1, false, false, null);
                    userNotDialed.add(objConferenceMember);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting User Not Dialed list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting User Not Dialed list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        for (ConferenceMember conferenceMember : userNotDialed) {
            logger.info((Object)("userNotDialed : " + conferenceMember.getCaller_id_number()));
        }
        try {
            String CallerName = this.CallerName(db, conferencenumber);
            ConferenceMember conferenceMember = new ConferenceMember(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, conferencenumber, CallerName, "", "1", 2, false, false, null);
            ownerDetails.add(conferenceMember);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Owner list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        for (ConferenceMember conferenceMember : ownerDetails) {
            logger.info((Object)("ownerDetails : " + conferenceMember.getCaller_id_number()));
        }
        try {
            Stream stream1 = listConferenceMemberFinal.stream();
            Stream stream = userNotInConf.stream();
            Stream stream3 = userNotDialed.stream();
            Stream stream4 = ownerDetails.stream();
            Stream resultingStream = Stream.concat(stream1, stream).filter(CoralOCController.distinctByKey(ConferenceMember::get_callernumber));
            Stream resultingStream2 = Stream.concat(stream3, stream4).filter(CoralOCController.distinctByKey(ConferenceMember::get_callernumber));
            Stream finalStream = Stream.concat(resultingStream, resultingStream2).filter(CoralOCController.distinctByKey(ConferenceMember::get_callernumber));
            returnValue = new ConferenceListResponse(listConferenceMemberFinal.size(), finalStream.collect(Collectors.toList()));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Conference Status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return returnValue;
    }

    public ConferenceListResponse getConferenceStatusV1(JdbcTemplate db, String conferencenumber) {
        ArrayList<ConferenceMember> listConferenceMemberFinalWithHandRaisedStatus;
        String sql;
        ArrayList<ConferenceMember> ringingParticipant;
        ArrayList<ConferenceMember> ownerDetails;
        ArrayList<ConferenceMember> listConferenceMemberFinal;
        ConferenceListResponse returnValue;
        block30: {
            returnValue = new ConferenceListResponse();
            ArrayList listConferenceMember = new ArrayList();
            listConferenceMemberFinal = new ArrayList<ConferenceMember>();
            ownerDetails = new ArrayList<ConferenceMember>();
            ringingParticipant = new ArrayList<ConferenceMember>();
            ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
            sql = "";
            String command = "";
            listConferenceMemberFinalWithHandRaisedStatus = new ArrayList<ConferenceMember>();
            try {
                String conferenceData = "";
                try {
                    command = "conference " + conferencenumber + " xml_list";
                    conferenceData = this.objCommandDialer.getConferenceMemeberList(command);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                if (conferenceData != null && !conferenceData.isEmpty() && conferenceData.startsWith("<?xml")) {
                    logger.info((Object)"Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        if (listConferenceMember.size() > 0) {
                            for (ConferenceMember conferenceMember : listConferenceMember) {
                                if (conferenceMember.get_callernumber().equalsIgnoreCase("siprec")) continue;
                                String CallerName = this.CallerName(db, conferenceMember.get_callernumber());
                                conferenceMember.set_callername(CallerName);
                                String CallerActualNumber = this.getCallerNumber(db, conferenceMember.getUuid(), conferenceMember.getCaller_id_number());
                                if (!CallerActualNumber.isEmpty()) {
                                    conferenceMember.set_callernumber(CallerActualNumber);
                                }
                                conferenceMember.set_ispartofgroup(1);
                                listConferenceMemberFinal.add(conferenceMember);
                            }
                        }
                        break block30;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                        break block30;
                    }
                }
                logger.info((Object)"No Conference detail found");
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            }
        }
        for (ConferenceMember obj : listConferenceMemberFinal) {
            logger.info((Object)("listConferenceMemberFinal : " + obj.getCaller_id_number()));
        }
        String CallerName = this.CallerName(db, conferencenumber);
        try {
            ConferenceMember objConferenceMember = new ConferenceMember(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, conferencenumber, CallerName, "", "1", 2, false, false, null);
            ownerDetails.add(objConferenceMember);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Owner list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        for (ConferenceMember conferenceMember : ownerDetails) {
            logger.info((Object)("ownerDetails : " + conferenceMember.getCaller_id_number()));
        }
        try {
            List ringingInConference = null;
            sql = "select distinct uuid,coral_original_num,(extract(epoch from now()::timestamp(0) with time zone) - created_epoch)::text jointime from channels where coalesce(application,'') <> 'conference' and coalesce(callstate,'') in ('RINGING','EARLY') and coalesce(coral_original_num,'') <> '' and coalesce(cid_num,'') = ?;";
            ringingInConference = db.queryForList(sql, new Object[]{conferencenumber});
            for (Map _ringingInConference : ringingInConference) {
                try {
                    ConferenceMember objConferenceMember = new ConferenceMember(null, null, null, null, null, null, null, null, null, null, null, _ringingInConference.get("uuid").toString(), null, null, _ringingInConference.get("jointime").toString(), null, null, null, null, null, null, null, null, null, null, null, _ringingInConference.get("coral_original_num").toString(), this.CallerName(db, _ringingInConference.get("coral_original_num").toString()), "", "2", 1, false, false, null);
                    ringingParticipant.add(objConferenceMember);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting User Ringing in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting User Ringing in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            List handRaisedList = null;
            sql = "select a.uuid,\r\ndatediff('second',a.handraisedat::timestamp(0),current_timestamp AT TIME ZONE 'Asia/Kolkata')::int waitingtime,\r\nTO_CHAR((datediff('second',a.handraisedat::timestamp(0),current_timestamp AT TIME ZONE 'Asia/Kolkata') || ' second')::interval, 'HH24:MI:SS') waitingtimestr\r\nfrom channels a \r\nwhere a.ishandraised = 1 and a.dest = ?;";
            handRaisedList = db.queryForList(sql, new Object[]{conferencenumber});
            if (handRaisedList.size() > 0) {
                for (Map _handRaisedList : handRaisedList) {
                    try {
                        if (listConferenceMemberFinal.size() <= 0) continue;
                        for (ConferenceMember obj : listConferenceMemberFinal) {
                            if (_handRaisedList.get("uuid").toString().equals(obj.getUuid())) {
                                obj.setHandRaised(true);
                                obj.setHandRaisedAt(_handRaisedList.get("waitingtimestr").toString());
                            }
                            listConferenceMemberFinalWithHandRaisedStatus.add(obj);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting User With Hand Raised in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            } else {
                listConferenceMemberFinalWithHandRaisedStatus.addAll(listConferenceMemberFinal);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting User With Hand Raised in Conference list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            Stream stream1 = listConferenceMemberFinalWithHandRaisedStatus.stream();
            Stream stream = ringingParticipant.stream();
            Stream stream4 = ownerDetails.stream();
            Stream resultingStream = Stream.concat(stream1, stream).filter(CoralOCController.distinctByKey(ConferenceMember::get_callernumber));
            Stream resultingStream1 = Stream.concat(resultingStream, stream4).filter(CoralOCController.distinctByKey(ConferenceMember::get_callernumber));
            returnValue = new ConferenceListResponse(listConferenceMemberFinalWithHandRaisedStatus.size(), resultingStream1.collect(Collectors.toList()));
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting Conference Status. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return returnValue;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private String CallerName(JdbcTemplate db, String callernumber) {
        String sql = "";
        String callername = callernumber;
        try {
            sql = "select coalesce(name, extension) callernumber from pbx.extensions where extension = ?";
            callername = (String)db.query(sql, new Object[]{callernumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            String string = callername = callername.isEmpty() ? callernumber : callername;
            if (this.meetConfig != null && this.meetConfig.getMakeBuddyNameProper() == 1) {
                callername = ProperNamingUtil.capitalize((String)callername, (String)"of");
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in CallerName. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return callername;
    }

    private String getCallerNumber(JdbcTemplate db, String uuid, String callerconferencenumber) {
        String sql = "";
        String callernumber = callerconferencenumber;
        try {
            sql = "select coalesce(coral_original_num,'') coral_original_num from channels where coalesce(application,'') = 'conference' and uuid = ?";
            callernumber = (String)db.query(sql, new Object[]{uuid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            callernumber = callernumber.isEmpty() ? callerconferencenumber : callernumber;
        }
        catch (Exception ex) {
            logger.error((Object)("Error in CallerNumber. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return callernumber;
    }

    @GetMapping(path={"/getconferencelist/{conferencenumber}/{conferencegroup}"}, produces={"application/json"})
    public ResponseEntity<ConferenceStatusResponse> getStatusList(@PathVariable(value="conferencenumber") String conferencenumber, @PathVariable(value="conferencegroup") String conferencegroup, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Conference List, For conference no,conferencegroup -> " + conferencenumber + "," + conferencegroup;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ConferenceStatusResponse objCommonResponse = new ConferenceStatusResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        ConferenceListResponse listConferenceListResponse = new ConferenceListResponse();
        ArrayList listConferenceMember = new ArrayList();
        if (conferencenumber.isEmpty() || conferencegroup.isEmpty()) {
            objCommonResponse = new ConferenceStatusResponse(1, "Invalid Input", null, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            listConferenceListResponse = this.getConferenceStatus(db, conferencenumber, conferencegroup);
            responseStatus = 0;
            response = "Conference List Fetched";
            objCommonResponse = listConferenceListResponse != null ? new ConferenceStatusResponse(responseStatus, response, listConferenceListResponse.getData(), listConferenceListResponse.getTotalconnected()) : new ConferenceStatusResponse(responseStatus, response, null, 0);
            logger.info((Object)("Response sent having " + listConferenceMember.size() + " Participant Data."));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ConferenceStatusResponse(1, ex.getMessage(), null, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getconferencelist/{conferencenumber}"}, produces={"application/json"})
    public ResponseEntity<ConferenceStatusResponse> getStatusListConference(@PathVariable(value="conferencenumber") String conferencenumber, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Conference List, For conference no -> " + conferencenumber;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ConferenceStatusResponse objCommonResponse = new ConferenceStatusResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        ConferenceListResponse listConferenceListResponse = new ConferenceListResponse();
        ArrayList listConferenceMember = new ArrayList();
        if (conferencenumber.isEmpty()) {
            objCommonResponse = new ConferenceStatusResponse(1, "Invalid Input", null, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            listConferenceListResponse = this.getConferenceStatusV1(db, conferencenumber);
            responseStatus = 0;
            response = "Conference List Fetched";
            objCommonResponse = listConferenceListResponse != null ? new ConferenceStatusResponse(responseStatus, response, listConferenceListResponse.getData(), listConferenceListResponse.getTotalconnected()) : new ConferenceStatusResponse(responseStatus, response, null, 0);
            logger.info((Object)("Response sent having " + listConferenceMember.size() + " Participant Data."));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ConferenceStatusResponse(1, ex.getMessage(), null, 0);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getacdcallslist/{agentid}/{acdgroup}/{agentnumber}"}, produces={"application/json"})
    public ResponseEntity<ACDCallsListResponse> getAcdCallsList(@PathVariable(value="agentid") String agentid, @PathVariable(value="acdgroup") String acdgroup, @PathVariable(value="agentnumber") String agentnumber, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for ACD Calls List, For agentId, acdGroup, agentNumberno -> " + agentid + ", " + acdgroup + ", " + agentnumber;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ACDCallsListResponse objCommonResponse = new ACDCallsListResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsCallCenter);
        List listACDCallsList = new ArrayList();
        String sql = "";
        String conferenceQueue = "";
        if (agentid.isEmpty() || acdgroup.isEmpty() || agentnumber.isEmpty()) {
            objCommonResponse = new ACDCallsListResponse(1, "Invalid Input", null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            sql = "select coalesce(column10,'') conferencequeue from pbx.extensions where extension = ? limit 1";
            conferenceQueue = (String)db.query(sql, new Object[]{agentnumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (conferenceQueue.isEmpty()) {
                if (!acdgroup.isEmpty()) {
                    if (!("," + acdgroup + ",").contains("," + conferenceQueue + ",")) {
                        acdgroup = acdgroup + "," + conferenceQueue;
                    }
                } else {
                    acdgroup = conferenceQueue;
                }
            }
            listACDCallsList = this.getACDCallsList(db, acdgroup, agentnumber, conferenceQueue, agentid);
            responseStatus = 0;
            response = "ACD Calls List Fetched";
            objCommonResponse = new ACDCallsListResponse(responseStatus, response, listACDCallsList, null);
            logger.info((Object)("Response sent having " + listACDCallsList.size() + " Calls Data."));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ACDCallsListResponse(1, ex.getMessage(), null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/getacdcallslist/{agentid}"}, produces={"application/json"})
    public ResponseEntity<ACDCallsListResponse> getAcdCallsList(@PathVariable(value="agentid") String agentid, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for ACD Calls List, For agentId -> " + agentid;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        ACDCallsListResponse objCommonResponse = new ACDCallsListResponse();
        JdbcTemplate db = new JdbcTemplate(this.dsCallCenter);
        JdbcTemplate dbSwitch = new JdbcTemplate(this.dsSwitch);
        List listACDCallsList = new ArrayList();
        ArrayList<String> allAgentACD = new ArrayList<String>();
        ArrayList<OperatorInitiatedCalls> listOperatorInitiatedCalls = new ArrayList<OperatorInitiatedCalls>();
        if (agentid.isEmpty()) {
            objCommonResponse = new ACDCallsListResponse(1, "Invalid Input", null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        String sql = "";
        String agentnumber = "";
        String acdgroup = "";
        String conferenceQueue = "";
        String contactOperator = "";
        try {
            sql = "select case when coalesce(usercontact,'') = '' then coalesce(operatorcontact,'') else coalesce(usercontact,'') end as extension\r\nfrom(\r\nselect name,contact,\r\nsplit_part(split_part(contact,'user/',2),'@',1) usercontact,\r\nsplit_part(split_part(contact,'internal/',2),'@',1) operatorcontact\r\nfrom agents\r\n)a where name = ? limit 1;";
            agentnumber = (String)db.query(sql, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            sql = "select coalesce(extension,'') as extension from callcenter.operatormaster where operatorcode = ? limit 1;";
            contactOperator = (String)db.query(sql, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!contactOperator.isEmpty()) {
                agentnumber = contactOperator;
            }
            sql = "select coalesce(column10,'') conferencequeue from pbx.extensions where extension = ? limit 1";
            conferenceQueue = (String)dbSwitch.query(sql, new Object[]{agentnumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            logger.info((Object)String.format("getacdcallslist() -> : Agent Number : %s, Agent Conference Queue : %s", agentnumber, conferenceQueue));
            List callcenterACD = null;
            sql = "select queue from tiers where agent = ?;";
            callcenterACD = db.queryForList(sql, new Object[]{agentid});
            for (Object data : callcenterACD) {
                try {
                    String acd = data.get("queue").toString();
                    if (acd.isEmpty()) continue;
                    allAgentACD.add(acd);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting all acd calls list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            List callcenterACD1 = null;
            sql = "select queue from tiers where agent = ?;";
            callcenterACD1 = db.queryForList(sql, new Object[]{agentnumber});
            for (Iterator data : callcenterACD1) {
                try {
                    String acd = data.get("queue").toString();
                    if (acd.isEmpty()) continue;
                    allAgentACD.add(acd);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting all acd calls list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            List switchACD = null;
            sql = "select queue from callcenter.coraltiers where agent = ?;";
            switchACD = dbSwitch.queryForList(sql, new Object[]{agentid});
            for (Map data : switchACD) {
                try {
                    String acd = data.get("queue").toString();
                    if (acd.isEmpty()) continue;
                    allAgentACD.add(acd);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting all acd calls list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (allAgentACD.size() > 0) {
                for (String acd : allAgentACD) {
                    if (!acdgroup.isEmpty()) {
                        acdgroup = acdgroup + ",";
                    }
                    acdgroup = acdgroup + acd;
                }
            }
            if (!conferenceQueue.isEmpty()) {
                if (!acdgroup.isEmpty()) {
                    if (!("," + acdgroup + ",").contains("," + conferenceQueue + ",")) {
                        acdgroup = acdgroup + "," + conferenceQueue;
                    }
                } else {
                    acdgroup = conferenceQueue;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in CallerName. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        logger.info((Object)String.format("getacdcallslist() -> : ACD Allocated to Agent : %s, Total ACD :  %d, ACD List : %s", agentid, allAgentACD.size(), acdgroup));
        try {
            if (!acdgroup.isEmpty() && !agentnumber.isEmpty()) {
                listACDCallsList = this.getACDCallsList(db, acdgroup, agentnumber, conferenceQueue, agentid);
                responseStatus = 0;
                response = "ACD Calls List Fetched";
            } else {
                responseStatus = 1;
                response = "Either agent is not assigned any number or agent is not a part of any acd.";
            }
            try {
                List allOperatorCalls = null;
                String qry = "select coalesce(coral_transferring_from_number,'') as fromNumber, coalesce(coral_original_num,'') as toNumber ,(extract(epoch from now())- transfer_epoch)::bigint ringtime,coalesce(coral_transferring_initial_uuid,call_uuid) uuid,coalesce(coral_transfer_type,'') as coral_transfer_type from channels where callstate in('RING_WAIT','RINGING','EARLY') \r\nand coral_transferring_by_number = ?";
                allOperatorCalls = dbSwitch.queryForList(qry, new Object[]{agentnumber});
                for (Iterator data : allOperatorCalls) {
                    try {
                        String ringtimetext = "";
                        ringtimetext = data.get("ringtime").toString();
                        OperatorInitiatedCalls calls = new OperatorInitiatedCalls(data.get("fromNumber").toString(), data.get("toNumber").toString(), ringtimetext, data.get("uuid").toString(), data.get("coral_transfer_type").toString());
                        listOperatorInitiatedCalls.add(calls);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting operator initiated calls. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting operator initiated calls. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            objCommonResponse = new ACDCallsListResponse(responseStatus, response, listACDCallsList, listOperatorInitiatedCalls);
            logger.info((Object)("Response sent having " + listACDCallsList.size() + " Calls Data & Operator Initiated Calls : " + listOperatorInitiatedCalls.size()));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new ACDCallsListResponse(1, ex.getMessage(), null, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public List<ACDCallsList> getACDCallsList(JdbcTemplate db, String _acdgroup, String agentnumber, String conferenceQueue, String agentid) {
        ArrayList<ACDCallsList> listConferenceMember = new ArrayList<ACDCallsList>();
        String qry = "";
        try {
            String[] __acdGroup;
            List allCallsList = null;
            for (String acdgroup : __acdGroup = _acdgroup.split(",")) {
                if (acdgroup.isEmpty()) continue;
                String _queue = "";
                if (acdgroup.startsWith("ACD_")) {
                    String[] queues = acdgroup.split("_");
                    if (queues.length > 0) {
                        _queue = queues[0] + "_" + queues[1] + "_";
                    }
                } else {
                    _queue = acdgroup.equals(conferenceQueue) ? acdgroup : "ACD_" + (!acdgroup.isEmpty() ? acdgroup.trim() : "XXXX") + "_";
                }
                logger.debug((Object)("getACDCallsList() -> _queue : " + _queue + ", acdGroup : " + acdgroup));
                qry = "";
                qry = "select uuid, state, queue, acdtype, cid_number as caller, cid_name as callername, (extract(epoch from now())- joined_epoch)::bigint as ringtime, serving_agent as agent, session_uuid from (select uuid,state,queue,acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,acdgroup from members_coralacd union  select uuid,state,queue,trim(split_part((replace(queue,'" + _queue + "','')),'_',1)) acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,queue acdgroup from members where queue like '%" + _queue + "%') a where  (coalesce(state,'') = 'Waiting' or (coalesce(state,'') = 'Trying' and coalesce(serving_agent,?) <> ?)) and coalesce(state,'') <> 'Abandoned' and acdgroup = ? and lower(acdtype) in('as','at','av')";
                qry = qry + " union ";
                qry = qry + "select uuid, state, queue, acdtype, cid_number as caller, cid_name as callername, (extract(epoch from now())- joined_epoch)::bigint as ringtime, serving_agent as agent, session_uuid from (select uuid,state,queue,acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,acdgroup,? operatorextension from members_coralacd union  select uuid,state,queue,trim(split_part((replace(queue,'" + _queue + "','')),'_',1)) acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,queue acdgroup,trim(split_part((replace(queue,'" + _queue + "','')),'_',2)) operatorextension from members where queue like '%" + _queue + "%') a where  coalesce(state,'') in ('Waiting') and coalesce(state,'') <> 'Abandoned' and acdgroup = ? and lower(acdtype) in('ab','ar') and operatorextension = ?";
                qry = qry + " union ";
                qry = qry + "select  uuid,state, queue, acdtype, cid_number as caller,\r\ncid_name as callername, (extract(epoch from now())- joined_epoch)::bigint as ringtime,\r\nserving_agent as agent, session_uuid from\r\n(\r\nselect uuid,state,queue,'cpp' acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,acdgroup from members_coralacd where queue = ?\r\nunion  \r\nselect uuid,state,queue,'cpp' acdtype,cid_number,cid_name,joined_epoch,serving_agent,session_uuid,queue acdgroup from members where queue = ?\r\n) a  where (coalesce(state,'') = 'Waiting' or (coalesce(state,'') = 'Trying' and coalesce(serving_agent,?) <> ?)) and coalesce(state,'') <> 'Abandoned' and queue = ?;";
                logger.debug((Object)("getACDCallsList() -> Query : " + qry));
                allCallsList = db.queryForList(qry, new Object[]{agentnumber, agentnumber, acdgroup, agentnumber, acdgroup, agentnumber, acdgroup, acdgroup, agentnumber, agentnumber, conferenceQueue});
                for (Map data : allCallsList) {
                    try {
                        String[] _star = null;
                        String _callername = "";
                        String _rank = "0";
                        String _viprank = "";
                        String misscallerName = "";
                        String _acdType = "";
                        misscallerName = _callername = data.get("callername").toString();
                        _star = _callername.split("\\*");
                        if (_star.length > 0) {
                            _callername = _star[0];
                        }
                        if (_star.length > 1) {
                            _rank = _star[1].toString();
                        }
                        if (Integer.parseInt(_rank) > 0) {
                            _viprank = new String(new char[Integer.parseInt(_rank)]).replace("\u0000", "*");
                            _viprank = _rank.toString() + "(" + _viprank + ")";
                        }
                        if (misscallerName.startsWith("UA")) {
                            _acdType = "UA";
                        }
                        String ringtimetext = "";
                        ringtimetext = data.get("ringtime").toString();
                        ACDCallsList objACDCallsList = new ACDCallsList(data.get("state").toString(), data.get("queue").toString(), data.get("agent").toString(), Long.parseLong(data.get("ringtime").toString()), data.get("caller").toString(), _acdType.isEmpty() ? data.get("callername").toString() : misscallerName.replace("UA-", ""), _acdType.isEmpty() ? data.get("acdtype").toString() : _acdType.trim(), _viprank, data.get("session_uuid").toString(), ringtimetext, data.get("uuid") != null ? data.get("uuid").toString() : "");
                        listConferenceMember.add(objACDCallsList);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in getting all acd calls list. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting acd list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        try {
            listConferenceMember.sort((s1, s2) -> (int)s2.getRingtime() - (int)s1.getRingtime());
        }
        catch (Exception ex) {
            logger.error((Object)("Error in sorting acd list. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return listConferenceMember;
    }

    @PostMapping(path={"/updateconferencestatus"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> updateConferenceStatus(@RequestParam(value="conferencenumber") String conferencenumber, @RequestParam(value="membernumber") String membernumber, @RequestParam(value="conferenceaction") String conferenceaction, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Update Conference Status, For Member no -> " + conferencenumber + ", " + membernumber + ", " + conferenceaction;
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        if (conferencenumber.isEmpty() || membernumber.isEmpty() || conferenceaction.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            if (conferenceaction.equalsIgnoreCase("hangup")) {
                String command = "uuid_kill " + membernumber;
                if (!command.isEmpty()) {
                    command = "fs_cli -x \"" + command + "\"";
                    responseStatus = this.objCommandDialer.executeconferencecommand(command);
                    response = responseStatus == 0 ? "Call Disconnected." : "Error!!. Failed to disconnect ringing call.";
                }
            } else {
                responseStatus = this.executeConferenceCommand(conferencenumber, conferenceaction, membernumber, db);
                response = responseStatus == 0 ? "Action Performed." : "Error!!. Invalid conference or participant id.";
            }
            objCommonResponse = new CommonResponseObject(responseStatus, response, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in updating conference status for : " + conferencenumber + ", " + membernumber + ". Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    public int executeConferenceCommand(String conferencenumber, String conferenceAction, String participantId, JdbcTemplate db) {
        int response = 1;
        String command = "";
        try {
            if (participantId.equalsIgnoreCase("na")) {
                command = "conference " + conferencenumber + " " + conferenceAction;
            } else if (conferenceAction.startsWith("hr:")) {
                try {
                    String uuid = conferenceAction.split(":")[1];
                    command = "conference " + conferencenumber + " unmute " + participantId;
                    if (!uuid.isEmpty()) {
                        db.update("Update channels set ishandraised = 0, handraisedat = null where uuid = ?", new Object[]{uuid});
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in updating conference status for : " + conferencenumber + ", " + conferenceAction + ". Error -> " + ex.getMessage()), (Throwable)ex);
                }
            } else {
                command = "conference " + conferencenumber + " " + conferenceAction + " " + participantId;
            }
            if (!command.isEmpty()) {
                command = "fs_cli -x \"" + command + "\"";
                response = this.objCommandDialer.executeconferencecommand(command);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in executing conference command for : " + conferencenumber + ", " + participantId + ". Error -> " + ex.getMessage()), (Throwable)ex);
        }
        return response;
    }

    @PostMapping(path={"/dialinconference"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> dialInConference(@RequestParam(value="conferenceroom") String conferenceroom, @RequestParam(value="number") String number, @RequestParam(defaultValue="") String agentnumber) {
        String responseMessage = "Request for dail number in conference. -> " + conferenceroom + ", " + number;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String rluCode = "";
        String virtualIp = "";
        int systemExtension = 0;
        String command = "";
        String dialingNumbers = "";
        int isEmergencyConferenceNumber = 0;
        int isEmergencyPhone = 0;
        String qry = "";
        String sipServerInfo = "";
        String conferenceName = "";
        String sipServicesUrl = "";
        String extensionType = "";
        if (conferenceroom.isEmpty() || number.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        if (agentnumber.isEmpty()) {
            agentnumber = "ConferenceCall";
        }
        try {
            String serverIp;
            CoralMeetSystemConfig meetconfig;
            if (virtualIp.isEmpty() && (meetconfig = this.meetConfig) != null) {
                sipServicesUrl = meetconfig.getSipServicesURL();
                try {
                    qry = "select count(*) from pbx.extensions where extension = ?";
                    systemExtension = (Integer)db.queryForObject(qry, new Object[]{number}, Integer.class);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in finding either it is a system number or not : " + number + ", Error : " + ex.getMessage()), (Throwable)ex);
                }
                sipServerInfo = meetconfig.getSipserverinfo();
                virtualIp = systemExtension == 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSipserverinfo().isEmpty() ? meetconfig.getSipserverinfo() : (systemExtension > 0 && Boolean.parseBoolean(meetconfig.getVoipgateway()) && !meetconfig.getSbcip().isEmpty() ? meetconfig.getSbcip() : this.objCommandDialer.getswitchIPinfo("global_getvar local_ip_v4"));
                logger.info((Object)("Final Virtual Ip : " + virtualIp));
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            rluCode = !rluCode.isEmpty() ? "internal_" + rluCode.trim() : "internal";
            qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
            extensionType = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = " select data from pbx.extensions where extension_type = 'ec' and extension = ? and coalesce(data,'') <> '' limit 1;";
            dialingNumbers = (String)db.query(qry, new Object[]{number}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = "select coalesce(contactname,'') contactname from pbx.directorylist where coalesce(contactno,'') = ? limit 1;";
            conferenceName = (String)db.query(qry, new Object[]{conferenceroom}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            String string = conferenceName = conferenceName.isEmpty() ? conferenceroom : conferenceName;
            if (!dialingNumbers.isEmpty()) {
                isEmergencyConferenceNumber = 1;
            }
            if ((isEmergencyPhone = ((Integer)db.queryForObject(qry = "select count(*) from  pbx.extensions where extension = ? and extension_type = 'emergencyphone';", new Object[]{number}, Integer.class)).intValue()) > 0) {
                isEmergencyConferenceNumber = 2;
            }
            XmlRPCClient obj = new XmlRPCClient();
            SendPacketToUDPServer objSendUDP = new SendPacketToUDPServer();
            if (isEmergencyConferenceNumber == 1) {
                logger.info((Object)String.format("The number %s is emergency conference number so inspite of ec number the group number list %s will be dialed.", number, dialingNumbers));
                for (String dialingNumber : dialingNumbers.split(",")) {
                    if (dialingNumber.isEmpty()) continue;
                    qry = "select coalesce(extension_type,'') as extension_type from pbx.extensions where extension = ? limit 1;";
                    extensionType = (String)db.query(qry, new Object[]{dialingNumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
                    if (!sipServicesUrl.isEmpty()) {
                        command = String.format("ORIGINATE %s %s %s %s %s", dialingNumber, conferenceroom, conferenceName, "emergencyphoneConf", extensionType);
                        String serverIp2 = sipServicesUrl.split(":")[0];
                        int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                        if (command.isEmpty()) continue;
                        objSendUDP.sendPacket(serverIp2, port, command);
                        continue;
                    }
                    command = "{origination_callee_id_name=";
                    command = command + dialingNumber;
                    command = command + ",origination_caller_id_number='";
                    command = command + conferenceroom;
                    command = command + "',origination_caller_id_name='" + conferenceName + "'}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + dialingNumber;
                    command = command + "@";
                    command = command + virtualIp;
                    command = command + " ";
                    command = command + conferenceroom;
                    command = command + " ";
                    if ((command = command + "XML emergencyphoneConf").isEmpty()) continue;
                    obj.executeCommandAsync("freeswitch.api", "originate", command);
                }
                responseMessage = String.format("Number(s) %s is added in conference room %s.", dialingNumbers, conferenceroom);
            } else if (isEmergencyConferenceNumber == 2) {
                logger.info((Object)String.format("The number %s is emergency phone number so creating own conference for number %s.", number, number));
                if (!sipServicesUrl.isEmpty()) {
                    command = String.format("ORIGINATE %s %s %s %s %s", number, conferenceroom, "conference-bridge", "emergencyphoneConf", extensionType);
                    serverIp = sipServicesUrl.split(":")[0];
                    int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                    if (!command.isEmpty()) {
                        objSendUDP.sendPacket(serverIp, port, command);
                    }
                } else {
                    command = "{origination_callee_id_name=";
                    command = command + number;
                    command = command + ",origination_caller_id_number='";
                    command = command + conferenceroom;
                    command = command + "',origination_caller_id_name='conference-bridge',sip_h_X-apiconferencebridge=true}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + number;
                    command = command + "@";
                    command = command + sipServerInfo;
                    command = command + " ";
                    command = command + conferenceroom;
                    command = command + " ";
                    if (!(command = command + "XML emergencyphoneConf").isEmpty()) {
                        obj.executeCommandAsync("freeswitch.api", "originate", command);
                    }
                }
                responseMessage = String.format("Number(s) %s is added in its own conference room %s.", number, number);
            } else {
                logger.info((Object)String.format("The number %s is  normal number so it will be dialed.", number));
                if (!sipServicesUrl.isEmpty()) {
                    command = String.format("ORIGINATE %s %s %s %s %s", number, conferenceroom, conferenceName, "emergencyphoneConf", extensionType);
                    serverIp = sipServicesUrl.split(":")[0];
                    int port = Integer.parseInt(sipServicesUrl.split(":")[1]);
                    if (!command.isEmpty()) {
                        objSendUDP.sendPacket(serverIp, port, command);
                    }
                } else {
                    command = "{origination_callee_id_name=";
                    command = command + number;
                    command = command + ",origination_caller_id_number='";
                    command = command + conferenceroom;
                    command = command + "',origination_caller_id_name='" + conferenceName + "'}sofia/";
                    command = command + rluCode;
                    command = command + "/";
                    command = command + number;
                    command = command + "@";
                    command = command + virtualIp;
                    command = command + " ";
                    command = command + conferenceroom;
                    command = command + " ";
                    if (!(command = command + "XML emergencyphoneConf").isEmpty()) {
                        obj.executeCommandAsync("freeswitch.api", "originate", command);
                    }
                }
                responseMessage = String.format("Number %s is added in conference room %s.", number, conferenceroom);
            }
            try {
                logger.info((Object)responseMessage);
                objCommonResponse = new CommonResponseObject(0, responseMessage, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
                objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in adding number in conference. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/transferConferenceParticipant"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> transferConferenceParticipant(@RequestParam(value="conferenceroom") String conferenceroom, @RequestParam(value="number") String number, @RequestParam(value="destination") String destination) {
        String responseMessage = "transferConferenceParticipant : Request for transferring conference participant. -> " + conferenceroom + ", " + number + ", " + destination;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String command = "";
        String participantUuid = "";
        ArrayList listConferenceMember = new ArrayList();
        ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        String rluCode = "";
        String virtualIp = "";
        String qry = "";
        if (conferenceroom.isEmpty() || number.isEmpty() || destination.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            block15: {
                String conferenceData = "";
                try {
                    command = "conference " + conferenceroom + " xml_list";
                    conferenceData = this.objCommandDialer.getConferenceMemeberList(command);
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
                if (conferenceData != null && !conferenceData.isEmpty() && conferenceData.startsWith("<?xml")) {
                    logger.info((Object)"transferConferenceParticipant : Conference detail found : ");
                    try {
                        listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                        if (listConferenceMember.size() > 0) {
                            for (ConferenceMember conf : listConferenceMember) {
                                if (!conf.getId().equals(number)) continue;
                                participantUuid = conf.getUuid();
                                break block15;
                            }
                            break block15;
                        }
                        logger.info((Object)"transferConferenceParticipant : No participant list found.");
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error in  fetching uuid for conference participant. Error -> " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            if (participantUuid.isEmpty()) {
                logger.info((Object)"transferConferenceParticipant : unable to find uuid");
                objCommonResponse = new CommonResponseObject(1, "No active call found for number : " + number, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{conferenceroom}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            logger.info((Object)("transferConferenceParticipant: Rlu code for number : " + conferenceroom + " is : " + rluCode));
            if (!rluCode.isEmpty()) {
                qry = "select virtualip from pbx.m_control_rluserver where coalesce(virtualip,'') <> '' and rlucode = ?  limit 1;";
                virtualIp = (String)db.query(qry, new Object[]{rluCode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (virtualIp.isEmpty()) {
                qry = "select virtualip from pbx.m_control_rluserver where coalesce(virtualip,'') <> '' order by routerid limit 1;";
                virtualIp = (String)db.query(qry, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (virtualIp.isEmpty()) {
                logger.info((Object)"transferConferenceParticipant : unable to find virtual ip");
                objCommonResponse = new CommonResponseObject(1, "unable to find virtual ip for number : " + conferenceroom, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            command = participantUuid + " sip:" + destination + "@" + virtualIp;
            if (!command.isEmpty()) {
                XmlRPCClient obj = new XmlRPCClient();
                obj.executeCommandAsync("freeswitch.api", "uuid_deflect", command);
            }
            responseMessage = "Number " + number + " is trasnferred to " + destination;
            logger.info((Object)responseMessage);
            objCommonResponse = new CommonResponseObject(0, responseMessage, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in  transferring conference participant. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/pickUpACDCall"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> pickUpACDCall(@RequestParam(value="agentid") String agentid, @RequestParam(value="callId") String callId, @RequestParam(value="destination") String destination, @RequestParam(value="uuid") String uuid) {
        String responseMessage = "pickUpACDCall : Request for pickUpACDCall by agent : -> " + agentid + ", " + callId + ", " + destination + ", UUID : " + uuid;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        new ArrayList();
        JdbcTemplate dbCallcenter = new JdbcTemplate(this.dsCallCenter);
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        new ArrayList();
        new ArrayList();
        if (callId.isEmpty() || destination.isEmpty() || agentid.isEmpty() || uuid.isEmpty()) {
            logger.info((Object)"pickUpACDCall : Invalid Input");
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            dbCallcenter.update("Delete from members where uuid = ? and coalesce(state,'') in ('Waiting','Trying')", new Object[]{uuid});
            dbCallcenter.update("Delete from t_abandonedmembers where uuid = ? and  coalesce(state,'') in ('Abandoned')", new Object[]{uuid});
            responseMessage = "Callid " + callId + " is deleted from db.";
            logger.info((Object)responseMessage);
            Thread updateChannel = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            updateChannel.start();
            objCommonResponse = new CommonResponseObject(0, responseMessage, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in  transferring conference participant. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @PostMapping(path={"/pickUpACDCallOld"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> pickUpACDCallOld(@RequestParam(value="agentid") String agentid, @RequestParam(value="callId") String callId, @RequestParam(value="destination") String destination) {
        String responseMessage = "pickUpACDCall : Request for pickUpACDCall by agent : -> " + agentid + ", " + callId + ", " + destination;
        logger.info((Object)responseMessage);
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        String command = "";
        new ArrayList();
        String virtualIp = "";
        String qry = "";
        String rluCode = "";
        JdbcTemplate dbCallcenter = new JdbcTemplate(this.dsCallCenter);
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        new ArrayList();
        new ArrayList();
        String agentnumber = "";
        String contactOperator = "";
        if (callId.isEmpty() || destination.isEmpty() || agentid.isEmpty()) {
            logger.info((Object)"pickUpACDCall : Invalid Input");
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        try {
            XmlRPCClient obj;
            String returnValue;
            qry = "select case when coalesce(usercontact,'') = '' then coalesce(operatorcontact,'') else coalesce(usercontact,'') end as extension\r\nfrom(\r\nselect name,contact,\r\nsplit_part(split_part(contact,'user/',2),'@',1) usercontact,\r\nsplit_part(split_part(contact,'internal/',2),'@',1) operatorcontact\r\nfrom agents\r\n)a where name = ? limit 1;";
            agentnumber = (String)dbCallcenter.query(qry, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            qry = "select coalesce(extension,'') as extension from callcenter.operatormaster where operatorcode = ? limit 1;";
            contactOperator = (String)dbCallcenter.query(qry, new Object[]{agentid}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            if (!contactOperator.isEmpty()) {
                agentnumber = contactOperator;
            }
            if (agentnumber.isEmpty()) {
                logger.info((Object)"pickUpACDCall : Unable to fetch agent number.");
                objCommonResponse = new CommonResponseObject(1, "Unable to fetch agent number.", null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            qry = "select coalesce(rlucode,'') as rlucode from pbx.extensions where extension = ? limit 1;";
            rluCode = (String)db.query(qry, new Object[]{agentnumber}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            logger.info((Object)("pickUpACDCall: Rlu code for number : " + agentnumber + " is : " + rluCode));
            if (!rluCode.isEmpty()) {
                qry = "select virtualip from pbx.m_control_rluserver where coalesce(virtualip,'') <> '' and rlucode = ?  limit 1;";
                virtualIp = (String)db.query(qry, new Object[]{rluCode}, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (virtualIp.isEmpty()) {
                qry = "select virtualip from pbx.m_control_rluserver where coalesce(virtualip,'') <> '' order by routerid limit 1;";
                virtualIp = (String)db.query(qry, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (virtualIp.isEmpty()) {
                logger.info((Object)"pickUpACDCall : unable to find virtual ip");
                objCommonResponse = new CommonResponseObject(1, "unable to find virtual ip for number : " + agentnumber, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
            }
            if (!command.isEmpty() && (returnValue = (obj = new XmlRPCClient()).executeCommandAndReturnStatus("freeswitch.api", "uuid_deflect", command = callId + " sip:" + destination + "@" + virtualIp)).toLowerCase().contains("ok")) {
                logger.info((Object)("command : " + command + " return success. So deleting member record for callid : " + callId));
                dbCallcenter.update("Delete from members where uuid = ?", new Object[]{callId});
            }
            responseMessage = "Callid " + callId + " is deflected to " + destination;
            logger.info((Object)responseMessage);
            objCommonResponse = new CommonResponseObject(0, responseMessage, null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in  transferring conference participant. Error -> " + ex.getMessage()), (Throwable)ex);
            objCommonResponse = new CommonResponseObject(1, ex.getMessage(), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
    }

    @GetMapping(path={"/manageMemberVolume/{conferencenumber}/{uuid}"}, produces={"application/json"})
    public String manageMemberVolume(@PathVariable(value="conferencenumber") String conferencenumber, @PathVariable(value="uuid") String uuid, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = "Request for Update Conference Member volume, For Conference Number, Member uuid -> " + conferencenumber + " : " + uuid;
        logger.info((Object)responseMessage);
        String response = "";
        String command = "";
        ArrayList listConferenceMember = new ArrayList();
        ReadXMLFile _ReadXMLFIle = new ReadXMLFile();
        int participantId = 0;
        if (uuid.isEmpty() || conferencenumber.isEmpty()) {
            response = "Invalid Conference Number Or UUID.";
            logger.info((Object)response);
            return response;
        }
        try {
            String conferenceData = "";
            try {
                command = "conference " + conferencenumber + " xml_list";
                conferenceData = this.objCommandDialer.getConferenceMemeberList(command);
            }
            catch (Exception ex) {
                logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            }
            if (conferenceData != null && !conferenceData.isEmpty() && conferenceData.startsWith("<?xml")) {
                logger.info((Object)("Conference detail found : " + conferenceData));
                try {
                    listConferenceMember = _ReadXMLFIle.ReadXMLFileList(conferenceData);
                    if (listConferenceMember.size() > 0) {
                        for (ConferenceMember conf : listConferenceMember) {
                            if (!conf.getCaller_id_number().equalsIgnoreCase(uuid)) continue;
                            participantId = conf.getId().isEmpty() ? 0 : Integer.parseInt(conf.getId());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
                }
            } else {
                logger.info((Object)"No Conference detail found");
            }
            if (participantId > 0) {
                command = "conference " + conferencenumber + " volume_in " + participantId + " -4";
                if (!command.isEmpty()) {
                    command = "fs_cli -x \"" + command + "\"";
                    this.objCommandDialer.executeconferencecommand(command);
                }
                if (!(command = "conference " + conferencenumber + " volume_out " + participantId + " -4").isEmpty()) {
                    command = "fs_cli -x \"" + command + "\"";
                    this.objCommandDialer.executeconferencecommand(command);
                }
                return "OK";
            }
            logger.info((Object)"No Participant Found.");
            return "No Participant Found.";
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getting conference list. Error -> " + ex.getMessage()), (Throwable)ex);
            return "Error";
        }
    }

    @PostMapping(path={"/updatetransferdetails"}, produces={"application/json"})
    public ResponseEntity<CommonResponseObject> updateTransferDetails(@RequestParam(value="agentnumber") String agentnumber, @RequestParam(value="sourceid") String sourceid, @RequestParam(value="sourcenumber") String sourcenumber, @RequestParam(value="destinationid") String destinationid, @RequestParam(value="destinationnumber") String destinationnumber, @RequestParam(value="transfertype") String transfertype, HttpServletRequest httprequest, HttpServletResponse httpresponse) {
        String responseMessage = String.format("updatetransferdetails : Request for Update Transfer Details. agentnumber = %s, sourceid = %s, sourcenumber = %s, destinationid = %s, destinationnumber = %s & transfertyep = %s", agentnumber, sourceid, sourcenumber, destinationid, destinationnumber, transfertype);
        logger.info((Object)responseMessage);
        int responseStatus = -1;
        String response = "";
        CommonResponseObject objCommonResponse = new CommonResponseObject();
        JdbcTemplate db = new JdbcTemplate(this.dsSwitch);
        if (agentnumber.isEmpty() || sourceid.isEmpty() || sourcenumber.isEmpty() || destinationnumber.isEmpty()) {
            objCommonResponse = new CommonResponseObject(1, "Invalid Input", null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
        }
        Thread updateChannel = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        updateChannel.start();
        responseStatus = 0;
        response = "Transfer details updated.";
        logger.info((Object)"updatetransferdetails : Transfer details updated.");
        objCommonResponse = new CommonResponseObject(responseStatus, response, null);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objCommonResponse);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

