/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config.env;

import com.coraltele.restapi.coralmeet.api.CoralMeetSystemConfig;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class CoralMeetInitializer {
    private static final Logger logger = Logger.getLogger(CoralMeetInitializer.class);
    @Autowired
    Environment env;
    CoralMeetSystemConfig returnValue = new CoralMeetSystemConfig();

    @Bean
    public CoralMeetSystemConfig meetConfig() {
        logger.info((Object)"============ CoralMeetSystemConfig ================");
        String configPrefix = "coralmeet.";
        this.returnValue.setMaximumconferenceroom(0L);
        this.returnValue.setProsodydomain("");
        this.returnValue.setAutoenableuser(0);
        this.returnValue.setMeetingurl("");
        this.returnValue.setManualdialoutstring("");
        try {
            String serverdomain = this.env.getProperty(configPrefix + "prosodydomain", "");
            logger.info((Object)("====== prosodydomain ====== : " + serverdomain));
            int autoenableuser = Integer.parseInt(this.env.getProperty(configPrefix + "autoenableuser", "0"));
            logger.info((Object)("====== autoenableuser ====== : " + autoenableuser));
            String serverip = this.getserverip();
            logger.info((Object)("====== server ip ====== : " + serverip));
            String meetingurl = this.env.getProperty(configPrefix + "joinconferenceurlqtalkapp", "");
            logger.info((Object)("====== Meeting URL ====== : " + meetingurl));
            String manualdialoutstring = this.env.getProperty("manualdialout.dialoutstring", "");
            logger.info((Object)("====== Manual Dial Out String ====== : " + manualdialoutstring));
            this.returnValue.setManualdialoutstring(manualdialoutstring);
            String mPushNotificationMessage = this.env.getProperty("socket.pushnotificationmessageg", "Call Attemped From");
            logger.info((Object)("====== Push Notification Message Content ====== : " + mPushNotificationMessage));
            this.returnValue.setPushnotificationmessage(mPushNotificationMessage);
            String mVoiceMailServer = this.env.getProperty("socket.vmserver", "");
            logger.info((Object)("====== Voice Mail Server ====== : " + mVoiceMailServer));
            this.returnValue.setVoicemailserver(mVoiceMailServer);
            int mDataFromMediaServer = Integer.parseInt(this.env.getProperty("socket.datafrommediaserver", "0"));
            logger.info((Object)("====== CDR Server URL ====== : " + mDataFromMediaServer));
            this.returnValue.setDatafrommediaserver(mDataFromMediaServer);
            String servercode = this.getservercode();
            logger.info((Object)("====== Server Code ====== : " + servercode));
            this.returnValue.setServercode(servercode);
            String billingURL = this.env.getProperty("billing.jdbc.url", "jdbc\\:postgresql\\://127.0.0.1\\:5432/switch");
            logger.info((Object)("====== Billing Server URL ====== : " + billingURL));
            this.returnValue.setBillingurl(billingURL);
            String sipServerURL = this.env.getProperty("rest.sipserverresturl", "http://127.0.0.1:8080");
            logger.info((Object)("====== Sip Server URL ====== : " + sipServerURL));
            this.returnValue.setSipserverurl(sipServerURL);
            String apnsDevUser = this.env.getProperty("fms.apnsdevuser", "");
            logger.info((Object)("====== APNS Dev Users ====== : " + apnsDevUser));
            this.returnValue.setApnsdevuser(apnsDevUser);
            String stateMachineServer = this.env.getProperty("rest.statemachineurl", "http://127.0.0.1:8989");
            logger.info((Object)("====== State Machine Server URL ====== : " + stateMachineServer));
            this.returnValue.setStatemachineurl(stateMachineServer);
            int jwtExpiryInSeconds = Integer.parseInt(this.env.getProperty("jwt.expiry", "30"));
            logger.info((Object)("====== JWT Expiry(Seconds) ====== : " + jwtExpiryInSeconds));
            this.returnValue.setJwtExpiryInSeconds(jwtExpiryInSeconds);
            String appnmsurl = this.env.getProperty("app.nmsurl", "");
            logger.info((Object)("====== NMS App URL ====== : " + appnmsurl));
            this.returnValue.setAppnmsurl(appnmsurl);
            String appcmsurl = this.env.getProperty("app.cmsurl", "");
            logger.info((Object)("====== CMS App URL ====== : " + appcmsurl));
            this.returnValue.setAppcmsurl(appcmsurl);
            String sendEventURL = this.env.getProperty("rest.sendeventurl", "http://127.0.0.1:8989/sendEvent");
            logger.info((Object)("====== Send Event URL ====== : " + sendEventURL));
            this.returnValue.setSendeventurl(sendEventURL);
            String updateChannelUrl = this.env.getProperty("rest.updatechannelurl", "http://127.0.0.1:8989/updateChannel");
            logger.info((Object)("====== Update Channel URL ====== : " + updateChannelUrl));
            this.returnValue.setUpdateChannelUrl(updateChannelUrl);
            String secureCode = this.env.getProperty("sanchar.secureCode", "1870");
            logger.info((Object)("====== Secure Code ====== : " + secureCode));
            this.returnValue.setSecureCode(secureCode);
            int waitingTimeForOutgoing = Integer.parseInt(this.env.getProperty("sanchar.waitingtimeforoutgoing", "15"));
            logger.info((Object)("====== Waiting Time For Outgoing ====== : " + waitingTimeForOutgoing));
            this.returnValue.setWaitingTimeForOutgoing(waitingTimeForOutgoing);
            int makeBuddyNameProper = Integer.parseInt(this.env.getProperty("sanchar.makebuddynameproper", "1"));
            logger.info((Object)("====== Make Buddy Name Proper ====== : " + makeBuddyNameProper));
            this.returnValue.setMakeBuddyNameProper(makeBuddyNameProper);
            int releaseStuckChannels = Integer.parseInt(this.env.getProperty("sanchar.releasestuckchannels", "0"));
            logger.info((Object)("====== Release Stuck Channels ====== : " + releaseStuckChannels));
            this.returnValue.setReleaseStuckChannels(releaseStuckChannels);
            int maxAbandonedCallsToShow = Integer.parseInt(this.env.getProperty("sanchar.maxAbandonedCallsToShow", "500"));
            logger.info((Object)("====== Max Abandoned Calls ====== : " + maxAbandonedCallsToShow));
            this.returnValue.setMaxAbandonedCallsToShow(maxAbandonedCallsToShow);
            String apnTopic = this.env.getProperty("app.apntopic", "com.coraltele.sanchar.voip");
            logger.info((Object)("====== APN Topic ====== : " + apnTopic));
            this.returnValue.setApnTopic(apnTopic);
            String appimsurl = this.env.getProperty("app.imsurl", "");
            logger.info((Object)("====== IMS App URL ====== : " + appimsurl));
            this.returnValue.setAppimsurl(appimsurl);
            String appepcurl = this.env.getProperty("app.epcurl", "");
            logger.info((Object)("====== EPC App URL ====== : " + appepcurl));
            this.returnValue.setAppepcurl(appepcurl);
            String appmgwurl = this.env.getProperty("app.mgwurl", "");
            logger.info((Object)("====== MGW App URL ====== : " + appmgwurl));
            this.returnValue.setAppmgwurl(appmgwurl);
            this.readConfig();
            logger.info((Object)("====== Voip Gateway ====== : " + this.returnValue.getVoipgateway()));
            logger.info((Object)("====== SipServer Info ====== : " + this.returnValue.getSipserverinfo()));
            logger.info((Object)("====== SBC Ip ====== : " + this.returnValue.getSbcip()));
            logger.info((Object)("====== Sip Services URL ====== : " + this.returnValue.getSipServicesURL()));
            if (!serverip.isEmpty()) {
                long licenseavailable;
                this.returnValue.setProsodydomain(serverdomain);
                this.returnValue.setAutoenableuser(autoenableuser);
                this.returnValue.setMeetingurl(meetingurl);
                String license = CoralMeetInitializer.getConferenceRoomLicense((String)serverip, (int)8080, (String)"Conference Room");
                logger.info((Object)("====== license ====== : " + license));
                if (!license.isEmpty() && (licenseavailable = Long.parseLong(license)) > 0L) {
                    this.returnValue.setMaximumconferenceroom(licenseavailable);
                    logger.info((Object)("====== Available Room License ====== : " + licenseavailable));
                }
            }
        }
        catch (Exception ex) {
            this.returnValue.setMaximumconferenceroom(0L);
            logger.error((Object)("Error in meetConfig : " + ex.getMessage()), (Throwable)ex);
        }
        return this.returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() {
        Properties prop = new Properties();
        FileInputStream input = null;
        String fileName = "/etc/coraltele/conf/app.config";
        try {
            input = new FileInputStream(fileName);
            prop.load(input);
            this.returnValue.setVoipgateway(prop.getProperty("voipgateway", "false"));
            this.returnValue.setSipserverinfo(prop.getProperty("sipserverinfo", ""));
            this.returnValue.setSbcip(prop.getProperty("sbcip", ""));
            this.returnValue.setSipServicesURL(prop.getProperty("sipservicesurl", ""));
        }
        catch (IOException ex) {
            logger.error((Object)("Error in readConfig : " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    logger.error((Object)("Error in readConfig : " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    public String getserverip() {
        String eth0 = "";
        try {
            String interfaceName = "eth0";
            NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
            if (networkInterface != null) {
                List<InterfaceAddress> inetAddressAll = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress address : inetAddressAll) {
                    InetAddress currentAddress = address.getAddress();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress() || address.getBroadcast().toString().startsWith("0")) continue;
                    eth0 = currentAddress.toString().replace("/", "");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error at getserverip : ", (Throwable)ex);
        }
        logger.info((Object)("====== Server IP ====== : " + eth0));
        return eth0;
    }

    public String getservercode() {
        String servercode = "";
        Properties prop = new Properties();
        FileInputStream input = null;
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try {
            input = new FileInputStream(fileName);
            prop.load(input);
            if (prop.getProperty("servercode") != null && prop.getProperty("servercode").length() > 0) {
                servercode = prop.getProperty("servercode");
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getservercode. Error -> " + ex.getMessage()), (Throwable)ex);
        }
        logger.info((Object)("====== Server Code ====== : " + servercode));
        return servercode;
    }

    private static String getConferenceRoomLicense(String p_vertualIp, int port, String type) {
        String _ret = "0";
        try {
            String str = "";
            String pstr = "";
            String cmd = "";
            try {
                cmd = "w3m -dump http://" + p_vertualIp + ":" + port + "/dialplan | grep '" + type + "'| awk -F: '{print $2}'| awk -F\" \" '{ print $1}'";
                String[] finalcommand = CoralMeetInitializer.readfullcommmand((String)cmd);
                logger.info((Object)(finalcommand[0] + " - " + finalcommand[1] + " - " + finalcommand[2]));
                Process p = Runtime.getRuntime().exec(finalcommand);
                p.waitFor();
                BufferedReader outbuf = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((str = outbuf.readLine()) != null) {
                    pstr = pstr + str;
                }
                _ret = pstr = pstr.trim();
            }
            catch (IOException ex) {
                logger.error((Object)("Error in getConferenceRoomLicense : " + ex.getMessage()), (Throwable)ex);
            }
            catch (InterruptedException ex) {
                logger.error((Object)("Error in getConferenceRoomLicense : " + ex.getMessage()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error in getConferenceRoomLicense : " + ex.getMessage()), (Throwable)ex);
        }
        return _ret;
    }

    private static String[] readfullcommmand(String cmd) {
        String[] returnValue = new String[]{"/bin/bash", "-c", cmd};
        return returnValue;
    }
}

