/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.common.objects;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProperNamingUtil {
    public static String capitalize(String str, String delimitersRegex) {
        if (str == null || str.length() == 0) {
            return "";
        }
        Pattern delimPattern = delimitersRegex == null || delimitersRegex.length() == 0 ? Pattern.compile("\\W") : Pattern.compile(delimitersRegex);
        Matcher delimMatcher = delimPattern.matcher(str);
        boolean delimiterFound = delimMatcher.find();
        int delimeterStart = -1;
        if (delimiterFound) {
            delimeterStart = delimMatcher.start();
        }
        int strLen = str.length();
        StringBuilder buffer = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            if (delimiterFound && i == delimeterStart) {
                int endIndex = delimMatcher.end();
                buffer.append(str.substring(i, endIndex));
                i = endIndex;
                delimiterFound = delimMatcher.find();
                if (delimiterFound) {
                    delimeterStart = delimMatcher.start();
                }
                capitalizeNext = true;
                continue;
            }
            char ch = str.charAt(i);
            if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            if (!Character.isWhitespace(ch)) continue;
            capitalizeNext = true;
        }
        return buffer.toString();
    }
}

